# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.8
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from empire_platform_api_public_client.models.auction_allocation_resolution import AuctionAllocationResolution
from empire_platform_api_public_client.models.auction_bidding_configuration import AuctionBiddingConfiguration
from empire_platform_api_public_client.models.auction_process_steps_absolute import AuctionProcessStepsAbsolute
from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.auction_status import AuctionStatus
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.long_term_offered_capacity import LongTermOfferedCapacity
from empire_platform_api_public_client.models.long_term_reserve_price import LongTermReservePrice
from empire_platform_api_public_client.models.mtu_period import MtuPeriod
from empire_platform_api_public_client.models.mtu_size import MtuSize

class LongTermAuction(BaseModel):
    """
    LongTermAuction
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    name: StrictStr = Field(..., description="Human readable name")
    display_id: StrictStr = Field(..., alias="displayId", description="Generated display identifier")
    product_type: AuctionProductType = Field(..., alias="productType")
    border_direction: BorderDirection = Field(..., alias="borderDirection")
    status: AuctionStatus = Field(...)
    processing: StrictBool = Field(...)
    delivery_period: MtuPeriod = Field(..., alias="deliveryPeriod")
    allocation_mtu_size: MtuSize = Field(..., alias="allocationMtuSize")
    allocation_resolution: AuctionAllocationResolution = Field(..., alias="allocationResolution")
    bidding_configuration: AuctionBiddingConfiguration = Field(..., alias="biddingConfiguration")
    process_steps: AuctionProcessStepsAbsolute = Field(..., alias="processSteps")
    offered_capacity: LongTermOfferedCapacity = Field(..., alias="offeredCapacity")
    reserve_price: Optional[LongTermReservePrice] = Field(None, alias="reservePrice")
    __properties = ["id", "name", "displayId", "productType", "borderDirection", "status", "processing", "deliveryPeriod", "allocationMtuSize", "allocationResolution", "biddingConfiguration", "processSteps", "offeredCapacity", "reservePrice"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LongTermAuction:
        """Create an instance of LongTermAuction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of delivery_period
        if self.delivery_period:
            _dict['deliveryPeriod'] = self.delivery_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bidding_configuration
        if self.bidding_configuration:
            _dict['biddingConfiguration'] = self.bidding_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of process_steps
        if self.process_steps:
            _dict['processSteps'] = self.process_steps.to_dict()
        # override the default output from pydantic by calling `to_dict()` of offered_capacity
        if self.offered_capacity:
            _dict['offeredCapacity'] = self.offered_capacity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reserve_price
        if self.reserve_price:
            _dict['reservePrice'] = self.reserve_price.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LongTermAuction:
        """Create an instance of LongTermAuction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LongTermAuction.parse_obj(obj)

        _obj = LongTermAuction.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "display_id": obj.get("displayId"),
            "product_type": obj.get("productType"),
            "border_direction": obj.get("borderDirection"),
            "status": obj.get("status"),
            "processing": obj.get("processing"),
            "delivery_period": MtuPeriod.from_dict(obj.get("deliveryPeriod")) if obj.get("deliveryPeriod") is not None else None,
            "allocation_mtu_size": obj.get("allocationMtuSize"),
            "allocation_resolution": obj.get("allocationResolution"),
            "bidding_configuration": AuctionBiddingConfiguration.from_dict(obj.get("biddingConfiguration")) if obj.get("biddingConfiguration") is not None else None,
            "process_steps": AuctionProcessStepsAbsolute.from_dict(obj.get("processSteps")) if obj.get("processSteps") is not None else None,
            "offered_capacity": LongTermOfferedCapacity.from_dict(obj.get("offeredCapacity")) if obj.get("offeredCapacity") is not None else None,
            "reserve_price": LongTermReservePrice.from_dict(obj.get("reservePrice")) if obj.get("reservePrice") is not None else None
        })
        return _obj


