# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.8
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from empire_platform_api_public_client.models.mtu_size_per_auction_product_type import MtuSizePerAuctionProductType

class DefaultBidOptions(BaseModel):
    """
    DefaultBidOptions
    """
    mtu_sizes: conlist(MtuSizePerAuctionProductType) = Field(..., alias="mtuSizes")
    __properties = ["mtuSizes"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DefaultBidOptions:
        """Create an instance of DefaultBidOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in mtu_sizes (list)
        _items = []
        if self.mtu_sizes:
            for _item in self.mtu_sizes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mtuSizes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DefaultBidOptions:
        """Create an instance of DefaultBidOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DefaultBidOptions.parse_obj(obj)

        _obj = DefaultBidOptions.parse_obj({
            "mtu_sizes": [MtuSizePerAuctionProductType.from_dict(_item) for _item in obj.get("mtuSizes")] if obj.get("mtuSizes") is not None else None
        })
        return _obj


