# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.8
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field
from empire_platform_api_public_client.models.auction_bid_status import AuctionBidStatus
from empire_platform_api_public_client.models.bid_value import BidValue
from empire_platform_api_public_client.models.day_ahead_or_intra_day_auction_bid_group_bids_bid_results import DayAheadOrIntraDayAuctionBidGroupBidsBidResults

class DayAheadOrIntraDayAuctionBidGroupBidsBid(BaseModel):
    """
    DayAheadOrIntraDayAuctionBidGroupBidsBid
    """
    value: BidValue = Field(...)
    updated_at: datetime = Field(..., alias="updatedAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    status: AuctionBidStatus = Field(...)
    results: Optional[DayAheadOrIntraDayAuctionBidGroupBidsBidResults] = None
    __properties = ["value", "updatedAt", "status", "results"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DayAheadOrIntraDayAuctionBidGroupBidsBid:
        """Create an instance of DayAheadOrIntraDayAuctionBidGroupBidsBid from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of value
        if self.value:
            _dict['value'] = self.value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of results
        if self.results:
            _dict['results'] = self.results.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DayAheadOrIntraDayAuctionBidGroupBidsBid:
        """Create an instance of DayAheadOrIntraDayAuctionBidGroupBidsBid from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DayAheadOrIntraDayAuctionBidGroupBidsBid.parse_obj(obj)

        _obj = DayAheadOrIntraDayAuctionBidGroupBidsBid.parse_obj({
            "value": BidValue.from_dict(obj.get("value")) if obj.get("value") is not None else None,
            "updated_at": obj.get("updatedAt"),
            "status": obj.get("status"),
            "results": DayAheadOrIntraDayAuctionBidGroupBidsBidResults.from_dict(obj.get("results")) if obj.get("results") is not None else None
        })
        return _obj


