// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// Register Top module auto-generated by `reggen`


module rv_plic_reg_top (
    input clk_i,
    input rst_ni,

    // Below Regster interface can be changed
    input  tlul_pkg::tl_h2d_t tl_i,
    output tlul_pkg::tl_d2h_t tl_o,
    // To HW
    output rv_plic_reg_pkg::rv_plic_reg2hw_t reg2hw, // Write
    input  rv_plic_reg_pkg::rv_plic_hw2reg_t hw2reg  // Read
);

  import rv_plic_reg_pkg::* ;

  localparam AW = 9;
  localparam IW = $bits(tl_i.a_source);
  localparam DW = 32;
  localparam DBW = DW/8;                    // Byte Width
  localparam logic [$clog2($clog2(DBW)+1)-1:0] FSZ = $clog2(DBW); // Full Size 2^(FSZ) = DBW;

  // register signals
  logic          reg_we;
  logic          reg_re;
  logic [AW-1:0] reg_addr;
  logic [DW-1:0] reg_wdata;
  logic          reg_valid;
  logic [DW-1:0] reg_rdata;
  logic          tl_malformed, tl_addrmiss;

  // Bus signals
  tlul_pkg::tl_d_op_e rsp_opcode; // AccessAck or AccessAckData
  logic          reqready;
  logic [IW-1:0] reqid;
  logic [IW-1:0] rspid;
  logic          parity_en;

  logic          outstanding;

  tlul_pkg::tl_h2d_t tl_reg_h2d;
  tlul_pkg::tl_d2h_t tl_reg_d2h;

  assign tl_reg_h2d = tl_i;
  assign tl_o       = tl_reg_d2h;

  // TODO(eunchan): Fix it after bus interface is finalized
  assign reg_we = tl_reg_h2d.a_valid && tl_reg_d2h.a_ready &&
                  ((tl_reg_h2d.a_opcode == tlul_pkg::PutFullData) ||
                   (tl_reg_h2d.a_opcode == tlul_pkg::PutPartialData));
  assign reg_re = tl_reg_h2d.a_valid && tl_reg_d2h.a_ready && (tl_reg_h2d.a_opcode == tlul_pkg::Get);
  assign reg_addr = tl_reg_h2d.a_address[AW-1:0];
  assign reg_wdata = tl_reg_h2d.a_data;

  assign tl_reg_d2h.d_valid  = reg_valid;
  assign tl_reg_d2h.d_opcode = rsp_opcode;
  assign tl_reg_d2h.d_param  = '0;
  assign tl_reg_d2h.d_size   = FSZ;         // always Full Size
  assign tl_reg_d2h.d_source = rspid;
  assign tl_reg_d2h.d_sink   = '0;          // Used in TL-C
  assign tl_reg_d2h.d_data   = reg_rdata;
  assign tl_reg_d2h.d_user   = '0;          // Doesn't allow additional features yet
  assign tl_reg_d2h.d_error  = tl_malformed | tl_addrmiss;

  assign tl_reg_d2h.a_ready  = reqready;

  assign reqid     = tl_reg_h2d.a_source;
  assign parity_en = tl_reg_h2d.a_user[8]; // parity is not supported

  always_ff @(posedge clk_i or negedge rst_ni) begin
    if (!rst_ni) begin
      tl_malformed <= 1'b1;
    end else if (tl_reg_h2d.a_valid && tl_reg_d2h.a_ready) begin
      if ((tl_reg_h2d.a_opcode != tlul_pkg::Get) &&
          (tl_reg_h2d.a_opcode != tlul_pkg::PutFullData) &&
          (tl_reg_h2d.a_opcode != tlul_pkg::PutPartialData)) begin
        tl_malformed <= 1'b1;
      // Only allow Full Write with full mask
      end else if (tl_reg_h2d.a_size != FSZ || tl_reg_h2d.a_mask != {DBW{1'b1}}) begin
        tl_malformed <= 1'b1;
      end else if (parity_en == 1'b1) begin
        tl_malformed <= 1'b1;
      end else begin
        tl_malformed <= 1'b0;
      end
    end
  end
  // TODO(eunchan): Revise Register Interface logic after REG INTF finalized
  // TODO(eunchan): Make concrete scenario
  //    1. Write: No response, so that it can guarantee a request completes a clock after we
  //              It means, bus_reg_ready doesn't have to be lowered.
  //    2. Read: response. So bus_reg_ready should assert after reg_bus_valid & reg_bus_ready
  //               _____         _____
  // a_valid _____/     \_______/     \______
  //         ___________         _____
  // a_ready            \_______/     \______ <- ERR though no logic malfunction
  //                     _____________
  // d_valid ___________/             \______
  //                             _____
  // d_ready ___________________/     \______
  //
  // Above example is fine but if r.b.r doesn't assert within two cycle, then it can be wrong.
  always_ff @(posedge clk_i, negedge rst_ni) begin
    // Not to accept new request when a request is handling
    //   #Outstanding := 1
    if (!rst_ni) begin
      reqready <= 1'b0;
    end else if (reg_we || reg_re) begin
      reqready <= 1'b0;
    end else if (outstanding == 1'b0) begin
      reqready <= 1'b1;
    end
  end

  // Request/ Response ID
  always_ff @(posedge clk_i, negedge rst_ni) begin
    if (!rst_ni) begin
      rspid <= '0;
    end else if (reg_we || reg_re) begin
      rspid <= reqid;
    end
  end

  // Define SW related signals
  // Format: <reg>_<field>_{wd|we|qs}
  //        or <reg>_{wd|we|qs} if field == 1 or 0
  logic ip_p0_qs;
  logic ip_p1_qs;
  logic ip_p2_qs;
  logic ip_p3_qs;
  logic ip_p4_qs;
  logic ip_p5_qs;
  logic ip_p6_qs;
  logic ip_p7_qs;
  logic ip_p8_qs;
  logic ip_p9_qs;
  logic ip_p10_qs;
  logic ip_p11_qs;
  logic ip_p12_qs;
  logic ip_p13_qs;
  logic ip_p14_qs;
  logic ip_p15_qs;
  logic ip_p16_qs;
  logic ip_p17_qs;
  logic ip_p18_qs;
  logic ip_p19_qs;
  logic ip_p20_qs;
  logic ip_p21_qs;
  logic ip_p22_qs;
  logic ip_p23_qs;
  logic ip_p24_qs;
  logic ip_p25_qs;
  logic ip_p26_qs;
  logic ip_p27_qs;
  logic ip_p28_qs;
  logic ip_p29_qs;
  logic ip_p30_qs;
  logic ip_p31_qs;
  logic le_le0_qs;
  logic le_le0_wd;
  logic le_le0_we;
  logic le_le1_qs;
  logic le_le1_wd;
  logic le_le1_we;
  logic le_le2_qs;
  logic le_le2_wd;
  logic le_le2_we;
  logic le_le3_qs;
  logic le_le3_wd;
  logic le_le3_we;
  logic le_le4_qs;
  logic le_le4_wd;
  logic le_le4_we;
  logic le_le5_qs;
  logic le_le5_wd;
  logic le_le5_we;
  logic le_le6_qs;
  logic le_le6_wd;
  logic le_le6_we;
  logic le_le7_qs;
  logic le_le7_wd;
  logic le_le7_we;
  logic le_le8_qs;
  logic le_le8_wd;
  logic le_le8_we;
  logic le_le9_qs;
  logic le_le9_wd;
  logic le_le9_we;
  logic le_le10_qs;
  logic le_le10_wd;
  logic le_le10_we;
  logic le_le11_qs;
  logic le_le11_wd;
  logic le_le11_we;
  logic le_le12_qs;
  logic le_le12_wd;
  logic le_le12_we;
  logic le_le13_qs;
  logic le_le13_wd;
  logic le_le13_we;
  logic le_le14_qs;
  logic le_le14_wd;
  logic le_le14_we;
  logic le_le15_qs;
  logic le_le15_wd;
  logic le_le15_we;
  logic le_le16_qs;
  logic le_le16_wd;
  logic le_le16_we;
  logic le_le17_qs;
  logic le_le17_wd;
  logic le_le17_we;
  logic le_le18_qs;
  logic le_le18_wd;
  logic le_le18_we;
  logic le_le19_qs;
  logic le_le19_wd;
  logic le_le19_we;
  logic le_le20_qs;
  logic le_le20_wd;
  logic le_le20_we;
  logic le_le21_qs;
  logic le_le21_wd;
  logic le_le21_we;
  logic le_le22_qs;
  logic le_le22_wd;
  logic le_le22_we;
  logic le_le23_qs;
  logic le_le23_wd;
  logic le_le23_we;
  logic le_le24_qs;
  logic le_le24_wd;
  logic le_le24_we;
  logic le_le25_qs;
  logic le_le25_wd;
  logic le_le25_we;
  logic le_le26_qs;
  logic le_le26_wd;
  logic le_le26_we;
  logic le_le27_qs;
  logic le_le27_wd;
  logic le_le27_we;
  logic le_le28_qs;
  logic le_le28_wd;
  logic le_le28_we;
  logic le_le29_qs;
  logic le_le29_wd;
  logic le_le29_we;
  logic le_le30_qs;
  logic le_le30_wd;
  logic le_le30_we;
  logic le_le31_qs;
  logic le_le31_wd;
  logic le_le31_we;
  logic [2:0] prio0_qs;
  logic [2:0] prio0_wd;
  logic prio0_we;
  logic [2:0] prio1_qs;
  logic [2:0] prio1_wd;
  logic prio1_we;
  logic [2:0] prio2_qs;
  logic [2:0] prio2_wd;
  logic prio2_we;
  logic [2:0] prio3_qs;
  logic [2:0] prio3_wd;
  logic prio3_we;
  logic [2:0] prio4_qs;
  logic [2:0] prio4_wd;
  logic prio4_we;
  logic [2:0] prio5_qs;
  logic [2:0] prio5_wd;
  logic prio5_we;
  logic [2:0] prio6_qs;
  logic [2:0] prio6_wd;
  logic prio6_we;
  logic [2:0] prio7_qs;
  logic [2:0] prio7_wd;
  logic prio7_we;
  logic [2:0] prio8_qs;
  logic [2:0] prio8_wd;
  logic prio8_we;
  logic [2:0] prio9_qs;
  logic [2:0] prio9_wd;
  logic prio9_we;
  logic [2:0] prio10_qs;
  logic [2:0] prio10_wd;
  logic prio10_we;
  logic [2:0] prio11_qs;
  logic [2:0] prio11_wd;
  logic prio11_we;
  logic [2:0] prio12_qs;
  logic [2:0] prio12_wd;
  logic prio12_we;
  logic [2:0] prio13_qs;
  logic [2:0] prio13_wd;
  logic prio13_we;
  logic [2:0] prio14_qs;
  logic [2:0] prio14_wd;
  logic prio14_we;
  logic [2:0] prio15_qs;
  logic [2:0] prio15_wd;
  logic prio15_we;
  logic [2:0] prio16_qs;
  logic [2:0] prio16_wd;
  logic prio16_we;
  logic [2:0] prio17_qs;
  logic [2:0] prio17_wd;
  logic prio17_we;
  logic [2:0] prio18_qs;
  logic [2:0] prio18_wd;
  logic prio18_we;
  logic [2:0] prio19_qs;
  logic [2:0] prio19_wd;
  logic prio19_we;
  logic [2:0] prio20_qs;
  logic [2:0] prio20_wd;
  logic prio20_we;
  logic [2:0] prio21_qs;
  logic [2:0] prio21_wd;
  logic prio21_we;
  logic [2:0] prio22_qs;
  logic [2:0] prio22_wd;
  logic prio22_we;
  logic [2:0] prio23_qs;
  logic [2:0] prio23_wd;
  logic prio23_we;
  logic [2:0] prio24_qs;
  logic [2:0] prio24_wd;
  logic prio24_we;
  logic [2:0] prio25_qs;
  logic [2:0] prio25_wd;
  logic prio25_we;
  logic [2:0] prio26_qs;
  logic [2:0] prio26_wd;
  logic prio26_we;
  logic [2:0] prio27_qs;
  logic [2:0] prio27_wd;
  logic prio27_we;
  logic [2:0] prio28_qs;
  logic [2:0] prio28_wd;
  logic prio28_we;
  logic [2:0] prio29_qs;
  logic [2:0] prio29_wd;
  logic prio29_we;
  logic [2:0] prio30_qs;
  logic [2:0] prio30_wd;
  logic prio30_we;
  logic [2:0] prio31_qs;
  logic [2:0] prio31_wd;
  logic prio31_we;
  logic ie0_e0_qs;
  logic ie0_e0_wd;
  logic ie0_e0_we;
  logic ie0_e1_qs;
  logic ie0_e1_wd;
  logic ie0_e1_we;
  logic ie0_e2_qs;
  logic ie0_e2_wd;
  logic ie0_e2_we;
  logic ie0_e3_qs;
  logic ie0_e3_wd;
  logic ie0_e3_we;
  logic ie0_e4_qs;
  logic ie0_e4_wd;
  logic ie0_e4_we;
  logic ie0_e5_qs;
  logic ie0_e5_wd;
  logic ie0_e5_we;
  logic ie0_e6_qs;
  logic ie0_e6_wd;
  logic ie0_e6_we;
  logic ie0_e7_qs;
  logic ie0_e7_wd;
  logic ie0_e7_we;
  logic ie0_e8_qs;
  logic ie0_e8_wd;
  logic ie0_e8_we;
  logic ie0_e9_qs;
  logic ie0_e9_wd;
  logic ie0_e9_we;
  logic ie0_e10_qs;
  logic ie0_e10_wd;
  logic ie0_e10_we;
  logic ie0_e11_qs;
  logic ie0_e11_wd;
  logic ie0_e11_we;
  logic ie0_e12_qs;
  logic ie0_e12_wd;
  logic ie0_e12_we;
  logic ie0_e13_qs;
  logic ie0_e13_wd;
  logic ie0_e13_we;
  logic ie0_e14_qs;
  logic ie0_e14_wd;
  logic ie0_e14_we;
  logic ie0_e15_qs;
  logic ie0_e15_wd;
  logic ie0_e15_we;
  logic ie0_e16_qs;
  logic ie0_e16_wd;
  logic ie0_e16_we;
  logic ie0_e17_qs;
  logic ie0_e17_wd;
  logic ie0_e17_we;
  logic ie0_e18_qs;
  logic ie0_e18_wd;
  logic ie0_e18_we;
  logic ie0_e19_qs;
  logic ie0_e19_wd;
  logic ie0_e19_we;
  logic ie0_e20_qs;
  logic ie0_e20_wd;
  logic ie0_e20_we;
  logic ie0_e21_qs;
  logic ie0_e21_wd;
  logic ie0_e21_we;
  logic ie0_e22_qs;
  logic ie0_e22_wd;
  logic ie0_e22_we;
  logic ie0_e23_qs;
  logic ie0_e23_wd;
  logic ie0_e23_we;
  logic ie0_e24_qs;
  logic ie0_e24_wd;
  logic ie0_e24_we;
  logic ie0_e25_qs;
  logic ie0_e25_wd;
  logic ie0_e25_we;
  logic ie0_e26_qs;
  logic ie0_e26_wd;
  logic ie0_e26_we;
  logic ie0_e27_qs;
  logic ie0_e27_wd;
  logic ie0_e27_we;
  logic ie0_e28_qs;
  logic ie0_e28_wd;
  logic ie0_e28_we;
  logic ie0_e29_qs;
  logic ie0_e29_wd;
  logic ie0_e29_we;
  logic ie0_e30_qs;
  logic ie0_e30_wd;
  logic ie0_e30_we;
  logic ie0_e31_qs;
  logic ie0_e31_wd;
  logic ie0_e31_we;
  logic [2:0] threshold0_qs;
  logic [2:0] threshold0_wd;
  logic threshold0_we;
  logic [5:0] cc0_qs;
  logic [5:0] cc0_wd;
  logic cc0_we;
  logic cc0_re;

  // Register instances
  // R[ip]: V(False)

  //   F[p0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p0.de),
    .d      (hw2reg.ip.p0.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p0_qs)
  );


  //   F[p1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p1.de),
    .d      (hw2reg.ip.p1.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p1_qs)
  );


  //   F[p2]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p2.de),
    .d      (hw2reg.ip.p2.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p2_qs)
  );


  //   F[p3]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p3.de),
    .d      (hw2reg.ip.p3.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p3_qs)
  );


  //   F[p4]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p4.de),
    .d      (hw2reg.ip.p4.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p4_qs)
  );


  //   F[p5]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p5.de),
    .d      (hw2reg.ip.p5.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p5_qs)
  );


  //   F[p6]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p6.de),
    .d      (hw2reg.ip.p6.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p6_qs)
  );


  //   F[p7]: 7:7
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p7.de),
    .d      (hw2reg.ip.p7.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p7_qs)
  );


  //   F[p8]: 8:8
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p8.de),
    .d      (hw2reg.ip.p8.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p8_qs)
  );


  //   F[p9]: 9:9
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p9.de),
    .d      (hw2reg.ip.p9.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p9_qs)
  );


  //   F[p10]: 10:10
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p10 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p10.de),
    .d      (hw2reg.ip.p10.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p10_qs)
  );


  //   F[p11]: 11:11
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p11 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p11.de),
    .d      (hw2reg.ip.p11.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p11_qs)
  );


  //   F[p12]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p12 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p12.de),
    .d      (hw2reg.ip.p12.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p12_qs)
  );


  //   F[p13]: 13:13
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p13 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p13.de),
    .d      (hw2reg.ip.p13.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p13_qs)
  );


  //   F[p14]: 14:14
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p14 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p14.de),
    .d      (hw2reg.ip.p14.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p14_qs)
  );


  //   F[p15]: 15:15
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p15 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p15.de),
    .d      (hw2reg.ip.p15.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p15_qs)
  );


  //   F[p16]: 16:16
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p16 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p16.de),
    .d      (hw2reg.ip.p16.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p16_qs)
  );


  //   F[p17]: 17:17
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p17 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p17.de),
    .d      (hw2reg.ip.p17.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p17_qs)
  );


  //   F[p18]: 18:18
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p18 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p18.de),
    .d      (hw2reg.ip.p18.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p18_qs)
  );


  //   F[p19]: 19:19
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p19 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p19.de),
    .d      (hw2reg.ip.p19.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p19_qs)
  );


  //   F[p20]: 20:20
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p20 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p20.de),
    .d      (hw2reg.ip.p20.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p20_qs)
  );


  //   F[p21]: 21:21
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p21 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p21.de),
    .d      (hw2reg.ip.p21.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p21_qs)
  );


  //   F[p22]: 22:22
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p22 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p22.de),
    .d      (hw2reg.ip.p22.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p22_qs)
  );


  //   F[p23]: 23:23
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p23 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p23.de),
    .d      (hw2reg.ip.p23.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p23_qs)
  );


  //   F[p24]: 24:24
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p24 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p24.de),
    .d      (hw2reg.ip.p24.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p24_qs)
  );


  //   F[p25]: 25:25
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p25 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p25.de),
    .d      (hw2reg.ip.p25.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p25_qs)
  );


  //   F[p26]: 26:26
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p26 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p26.de),
    .d      (hw2reg.ip.p26.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p26_qs)
  );


  //   F[p27]: 27:27
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p27 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p27.de),
    .d      (hw2reg.ip.p27.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p27_qs)
  );


  //   F[p28]: 28:28
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p28 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p28.de),
    .d      (hw2reg.ip.p28.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p28_qs)
  );


  //   F[p29]: 29:29
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p29 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p29.de),
    .d      (hw2reg.ip.p29.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p29_qs)
  );


  //   F[p30]: 30:30
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p30 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p30.de),
    .d      (hw2reg.ip.p30.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p30_qs)
  );


  //   F[p31]: 31:31
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_ip_p31 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ip.p31.de),
    .d      (hw2reg.ip.p31.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ip_p31_qs)
  );


  // R[le]: V(False)

  //   F[le0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le0_we),
    .wd     (le_le0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le0.q ),

    // to register interface (read)
    .qs     (le_le0_qs)
  );


  //   F[le1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le1_we),
    .wd     (le_le1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le1.q ),

    // to register interface (read)
    .qs     (le_le1_qs)
  );


  //   F[le2]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le2_we),
    .wd     (le_le2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le2.q ),

    // to register interface (read)
    .qs     (le_le2_qs)
  );


  //   F[le3]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le3_we),
    .wd     (le_le3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le3.q ),

    // to register interface (read)
    .qs     (le_le3_qs)
  );


  //   F[le4]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le4_we),
    .wd     (le_le4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le4.q ),

    // to register interface (read)
    .qs     (le_le4_qs)
  );


  //   F[le5]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le5_we),
    .wd     (le_le5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le5.q ),

    // to register interface (read)
    .qs     (le_le5_qs)
  );


  //   F[le6]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le6_we),
    .wd     (le_le6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le6.q ),

    // to register interface (read)
    .qs     (le_le6_qs)
  );


  //   F[le7]: 7:7
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le7_we),
    .wd     (le_le7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le7.q ),

    // to register interface (read)
    .qs     (le_le7_qs)
  );


  //   F[le8]: 8:8
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le8_we),
    .wd     (le_le8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le8.q ),

    // to register interface (read)
    .qs     (le_le8_qs)
  );


  //   F[le9]: 9:9
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le9_we),
    .wd     (le_le9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le9.q ),

    // to register interface (read)
    .qs     (le_le9_qs)
  );


  //   F[le10]: 10:10
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le10 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le10_we),
    .wd     (le_le10_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le10.q ),

    // to register interface (read)
    .qs     (le_le10_qs)
  );


  //   F[le11]: 11:11
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le11 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le11_we),
    .wd     (le_le11_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le11.q ),

    // to register interface (read)
    .qs     (le_le11_qs)
  );


  //   F[le12]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le12 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le12_we),
    .wd     (le_le12_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le12.q ),

    // to register interface (read)
    .qs     (le_le12_qs)
  );


  //   F[le13]: 13:13
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le13 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le13_we),
    .wd     (le_le13_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le13.q ),

    // to register interface (read)
    .qs     (le_le13_qs)
  );


  //   F[le14]: 14:14
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le14 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le14_we),
    .wd     (le_le14_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le14.q ),

    // to register interface (read)
    .qs     (le_le14_qs)
  );


  //   F[le15]: 15:15
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le15 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le15_we),
    .wd     (le_le15_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le15.q ),

    // to register interface (read)
    .qs     (le_le15_qs)
  );


  //   F[le16]: 16:16
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le16 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le16_we),
    .wd     (le_le16_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le16.q ),

    // to register interface (read)
    .qs     (le_le16_qs)
  );


  //   F[le17]: 17:17
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le17 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le17_we),
    .wd     (le_le17_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le17.q ),

    // to register interface (read)
    .qs     (le_le17_qs)
  );


  //   F[le18]: 18:18
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le18 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le18_we),
    .wd     (le_le18_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le18.q ),

    // to register interface (read)
    .qs     (le_le18_qs)
  );


  //   F[le19]: 19:19
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le19 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le19_we),
    .wd     (le_le19_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le19.q ),

    // to register interface (read)
    .qs     (le_le19_qs)
  );


  //   F[le20]: 20:20
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le20 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le20_we),
    .wd     (le_le20_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le20.q ),

    // to register interface (read)
    .qs     (le_le20_qs)
  );


  //   F[le21]: 21:21
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le21 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le21_we),
    .wd     (le_le21_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le21.q ),

    // to register interface (read)
    .qs     (le_le21_qs)
  );


  //   F[le22]: 22:22
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le22 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le22_we),
    .wd     (le_le22_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le22.q ),

    // to register interface (read)
    .qs     (le_le22_qs)
  );


  //   F[le23]: 23:23
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le23 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le23_we),
    .wd     (le_le23_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le23.q ),

    // to register interface (read)
    .qs     (le_le23_qs)
  );


  //   F[le24]: 24:24
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le24 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le24_we),
    .wd     (le_le24_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le24.q ),

    // to register interface (read)
    .qs     (le_le24_qs)
  );


  //   F[le25]: 25:25
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le25 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le25_we),
    .wd     (le_le25_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le25.q ),

    // to register interface (read)
    .qs     (le_le25_qs)
  );


  //   F[le26]: 26:26
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le26 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le26_we),
    .wd     (le_le26_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le26.q ),

    // to register interface (read)
    .qs     (le_le26_qs)
  );


  //   F[le27]: 27:27
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le27 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le27_we),
    .wd     (le_le27_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le27.q ),

    // to register interface (read)
    .qs     (le_le27_qs)
  );


  //   F[le28]: 28:28
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le28 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le28_we),
    .wd     (le_le28_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le28.q ),

    // to register interface (read)
    .qs     (le_le28_qs)
  );


  //   F[le29]: 29:29
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le29 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le29_we),
    .wd     (le_le29_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le29.q ),

    // to register interface (read)
    .qs     (le_le29_qs)
  );


  //   F[le30]: 30:30
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le30 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le30_we),
    .wd     (le_le30_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le30.q ),

    // to register interface (read)
    .qs     (le_le30_qs)
  );


  //   F[le31]: 31:31
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_le_le31 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (le_le31_we),
    .wd     (le_le31_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.le.le31.q ),

    // to register interface (read)
    .qs     (le_le31_qs)
  );


  // R[prio0]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio0_we),
    .wd     (prio0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio0.q ),

    // to register interface (read)
    .qs     (prio0_qs)
  );


  // R[prio1]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio1_we),
    .wd     (prio1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio1.q ),

    // to register interface (read)
    .qs     (prio1_qs)
  );


  // R[prio2]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio2_we),
    .wd     (prio2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio2.q ),

    // to register interface (read)
    .qs     (prio2_qs)
  );


  // R[prio3]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio3_we),
    .wd     (prio3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio3.q ),

    // to register interface (read)
    .qs     (prio3_qs)
  );


  // R[prio4]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio4_we),
    .wd     (prio4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio4.q ),

    // to register interface (read)
    .qs     (prio4_qs)
  );


  // R[prio5]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio5_we),
    .wd     (prio5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio5.q ),

    // to register interface (read)
    .qs     (prio5_qs)
  );


  // R[prio6]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio6_we),
    .wd     (prio6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio6.q ),

    // to register interface (read)
    .qs     (prio6_qs)
  );


  // R[prio7]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio7_we),
    .wd     (prio7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio7.q ),

    // to register interface (read)
    .qs     (prio7_qs)
  );


  // R[prio8]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio8_we),
    .wd     (prio8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio8.q ),

    // to register interface (read)
    .qs     (prio8_qs)
  );


  // R[prio9]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio9_we),
    .wd     (prio9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio9.q ),

    // to register interface (read)
    .qs     (prio9_qs)
  );


  // R[prio10]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio10 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio10_we),
    .wd     (prio10_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio10.q ),

    // to register interface (read)
    .qs     (prio10_qs)
  );


  // R[prio11]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio11 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio11_we),
    .wd     (prio11_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio11.q ),

    // to register interface (read)
    .qs     (prio11_qs)
  );


  // R[prio12]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio12 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio12_we),
    .wd     (prio12_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio12.q ),

    // to register interface (read)
    .qs     (prio12_qs)
  );


  // R[prio13]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio13 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio13_we),
    .wd     (prio13_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio13.q ),

    // to register interface (read)
    .qs     (prio13_qs)
  );


  // R[prio14]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio14 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio14_we),
    .wd     (prio14_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio14.q ),

    // to register interface (read)
    .qs     (prio14_qs)
  );


  // R[prio15]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio15 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio15_we),
    .wd     (prio15_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio15.q ),

    // to register interface (read)
    .qs     (prio15_qs)
  );


  // R[prio16]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio16 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio16_we),
    .wd     (prio16_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio16.q ),

    // to register interface (read)
    .qs     (prio16_qs)
  );


  // R[prio17]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio17 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio17_we),
    .wd     (prio17_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio17.q ),

    // to register interface (read)
    .qs     (prio17_qs)
  );


  // R[prio18]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio18 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio18_we),
    .wd     (prio18_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio18.q ),

    // to register interface (read)
    .qs     (prio18_qs)
  );


  // R[prio19]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio19 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio19_we),
    .wd     (prio19_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio19.q ),

    // to register interface (read)
    .qs     (prio19_qs)
  );


  // R[prio20]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio20 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio20_we),
    .wd     (prio20_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio20.q ),

    // to register interface (read)
    .qs     (prio20_qs)
  );


  // R[prio21]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio21 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio21_we),
    .wd     (prio21_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio21.q ),

    // to register interface (read)
    .qs     (prio21_qs)
  );


  // R[prio22]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio22 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio22_we),
    .wd     (prio22_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio22.q ),

    // to register interface (read)
    .qs     (prio22_qs)
  );


  // R[prio23]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio23 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio23_we),
    .wd     (prio23_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio23.q ),

    // to register interface (read)
    .qs     (prio23_qs)
  );


  // R[prio24]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio24 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio24_we),
    .wd     (prio24_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio24.q ),

    // to register interface (read)
    .qs     (prio24_qs)
  );


  // R[prio25]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio25 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio25_we),
    .wd     (prio25_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio25.q ),

    // to register interface (read)
    .qs     (prio25_qs)
  );


  // R[prio26]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio26 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio26_we),
    .wd     (prio26_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio26.q ),

    // to register interface (read)
    .qs     (prio26_qs)
  );


  // R[prio27]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio27 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio27_we),
    .wd     (prio27_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio27.q ),

    // to register interface (read)
    .qs     (prio27_qs)
  );


  // R[prio28]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio28 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio28_we),
    .wd     (prio28_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio28.q ),

    // to register interface (read)
    .qs     (prio28_qs)
  );


  // R[prio29]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio29 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio29_we),
    .wd     (prio29_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio29.q ),

    // to register interface (read)
    .qs     (prio29_qs)
  );


  // R[prio30]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio30 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio30_we),
    .wd     (prio30_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio30.q ),

    // to register interface (read)
    .qs     (prio30_qs)
  );


  // R[prio31]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_prio31 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prio31_we),
    .wd     (prio31_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prio31.q ),

    // to register interface (read)
    .qs     (prio31_qs)
  );


  // R[ie0]: V(False)

  //   F[e0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e0_we),
    .wd     (ie0_e0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e0.q ),

    // to register interface (read)
    .qs     (ie0_e0_qs)
  );


  //   F[e1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e1_we),
    .wd     (ie0_e1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e1.q ),

    // to register interface (read)
    .qs     (ie0_e1_qs)
  );


  //   F[e2]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e2_we),
    .wd     (ie0_e2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e2.q ),

    // to register interface (read)
    .qs     (ie0_e2_qs)
  );


  //   F[e3]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e3_we),
    .wd     (ie0_e3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e3.q ),

    // to register interface (read)
    .qs     (ie0_e3_qs)
  );


  //   F[e4]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e4_we),
    .wd     (ie0_e4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e4.q ),

    // to register interface (read)
    .qs     (ie0_e4_qs)
  );


  //   F[e5]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e5_we),
    .wd     (ie0_e5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e5.q ),

    // to register interface (read)
    .qs     (ie0_e5_qs)
  );


  //   F[e6]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e6_we),
    .wd     (ie0_e6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e6.q ),

    // to register interface (read)
    .qs     (ie0_e6_qs)
  );


  //   F[e7]: 7:7
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e7_we),
    .wd     (ie0_e7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e7.q ),

    // to register interface (read)
    .qs     (ie0_e7_qs)
  );


  //   F[e8]: 8:8
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e8_we),
    .wd     (ie0_e8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e8.q ),

    // to register interface (read)
    .qs     (ie0_e8_qs)
  );


  //   F[e9]: 9:9
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e9_we),
    .wd     (ie0_e9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e9.q ),

    // to register interface (read)
    .qs     (ie0_e9_qs)
  );


  //   F[e10]: 10:10
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e10 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e10_we),
    .wd     (ie0_e10_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e10.q ),

    // to register interface (read)
    .qs     (ie0_e10_qs)
  );


  //   F[e11]: 11:11
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e11 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e11_we),
    .wd     (ie0_e11_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e11.q ),

    // to register interface (read)
    .qs     (ie0_e11_qs)
  );


  //   F[e12]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e12 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e12_we),
    .wd     (ie0_e12_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e12.q ),

    // to register interface (read)
    .qs     (ie0_e12_qs)
  );


  //   F[e13]: 13:13
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e13 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e13_we),
    .wd     (ie0_e13_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e13.q ),

    // to register interface (read)
    .qs     (ie0_e13_qs)
  );


  //   F[e14]: 14:14
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e14 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e14_we),
    .wd     (ie0_e14_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e14.q ),

    // to register interface (read)
    .qs     (ie0_e14_qs)
  );


  //   F[e15]: 15:15
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e15 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e15_we),
    .wd     (ie0_e15_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e15.q ),

    // to register interface (read)
    .qs     (ie0_e15_qs)
  );


  //   F[e16]: 16:16
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e16 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e16_we),
    .wd     (ie0_e16_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e16.q ),

    // to register interface (read)
    .qs     (ie0_e16_qs)
  );


  //   F[e17]: 17:17
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e17 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e17_we),
    .wd     (ie0_e17_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e17.q ),

    // to register interface (read)
    .qs     (ie0_e17_qs)
  );


  //   F[e18]: 18:18
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e18 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e18_we),
    .wd     (ie0_e18_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e18.q ),

    // to register interface (read)
    .qs     (ie0_e18_qs)
  );


  //   F[e19]: 19:19
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e19 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e19_we),
    .wd     (ie0_e19_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e19.q ),

    // to register interface (read)
    .qs     (ie0_e19_qs)
  );


  //   F[e20]: 20:20
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e20 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e20_we),
    .wd     (ie0_e20_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e20.q ),

    // to register interface (read)
    .qs     (ie0_e20_qs)
  );


  //   F[e21]: 21:21
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e21 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e21_we),
    .wd     (ie0_e21_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e21.q ),

    // to register interface (read)
    .qs     (ie0_e21_qs)
  );


  //   F[e22]: 22:22
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e22 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e22_we),
    .wd     (ie0_e22_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e22.q ),

    // to register interface (read)
    .qs     (ie0_e22_qs)
  );


  //   F[e23]: 23:23
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e23 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e23_we),
    .wd     (ie0_e23_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e23.q ),

    // to register interface (read)
    .qs     (ie0_e23_qs)
  );


  //   F[e24]: 24:24
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e24 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e24_we),
    .wd     (ie0_e24_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e24.q ),

    // to register interface (read)
    .qs     (ie0_e24_qs)
  );


  //   F[e25]: 25:25
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e25 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e25_we),
    .wd     (ie0_e25_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e25.q ),

    // to register interface (read)
    .qs     (ie0_e25_qs)
  );


  //   F[e26]: 26:26
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e26 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e26_we),
    .wd     (ie0_e26_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e26.q ),

    // to register interface (read)
    .qs     (ie0_e26_qs)
  );


  //   F[e27]: 27:27
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e27 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e27_we),
    .wd     (ie0_e27_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e27.q ),

    // to register interface (read)
    .qs     (ie0_e27_qs)
  );


  //   F[e28]: 28:28
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e28 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e28_we),
    .wd     (ie0_e28_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e28.q ),

    // to register interface (read)
    .qs     (ie0_e28_qs)
  );


  //   F[e29]: 29:29
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e29 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e29_we),
    .wd     (ie0_e29_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e29.q ),

    // to register interface (read)
    .qs     (ie0_e29_qs)
  );


  //   F[e30]: 30:30
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e30 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e30_we),
    .wd     (ie0_e30_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e30.q ),

    // to register interface (read)
    .qs     (ie0_e30_qs)
  );


  //   F[e31]: 31:31
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_ie0_e31 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (ie0_e31_we),
    .wd     (ie0_e31_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ie0.e31.q ),

    // to register interface (read)
    .qs     (ie0_e31_qs)
  );


  // R[threshold0]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_threshold0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (threshold0_we),
    .wd     (threshold0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.threshold0.q ),

    // to register interface (read)
    .qs     (threshold0_qs)
  );


  // R[cc0]: V(True)

  prim_subreg_ext #(
    .DW    (6)
  ) u_cc0 (
    .re     (cc0_re),
    .we     (cc0_we),
    .wd     (cc0_wd),
    .d      (hw2reg.cc0.d),
    .qre    (reg2hw.cc0.re),
    .qe     (reg2hw.cc0.qe),
    .q      (reg2hw.cc0.q ),
    .qs     (cc0_qs)
  );



  logic [36:0] addr_hit;
  always_comb begin
    addr_hit = '0;
    addr_hit[0] = (reg_addr == RV_PLIC_IP_OFFSET);
    addr_hit[1] = (reg_addr == RV_PLIC_LE_OFFSET);
    addr_hit[2] = (reg_addr == RV_PLIC_PRIO0_OFFSET);
    addr_hit[3] = (reg_addr == RV_PLIC_PRIO1_OFFSET);
    addr_hit[4] = (reg_addr == RV_PLIC_PRIO2_OFFSET);
    addr_hit[5] = (reg_addr == RV_PLIC_PRIO3_OFFSET);
    addr_hit[6] = (reg_addr == RV_PLIC_PRIO4_OFFSET);
    addr_hit[7] = (reg_addr == RV_PLIC_PRIO5_OFFSET);
    addr_hit[8] = (reg_addr == RV_PLIC_PRIO6_OFFSET);
    addr_hit[9] = (reg_addr == RV_PLIC_PRIO7_OFFSET);
    addr_hit[10] = (reg_addr == RV_PLIC_PRIO8_OFFSET);
    addr_hit[11] = (reg_addr == RV_PLIC_PRIO9_OFFSET);
    addr_hit[12] = (reg_addr == RV_PLIC_PRIO10_OFFSET);
    addr_hit[13] = (reg_addr == RV_PLIC_PRIO11_OFFSET);
    addr_hit[14] = (reg_addr == RV_PLIC_PRIO12_OFFSET);
    addr_hit[15] = (reg_addr == RV_PLIC_PRIO13_OFFSET);
    addr_hit[16] = (reg_addr == RV_PLIC_PRIO14_OFFSET);
    addr_hit[17] = (reg_addr == RV_PLIC_PRIO15_OFFSET);
    addr_hit[18] = (reg_addr == RV_PLIC_PRIO16_OFFSET);
    addr_hit[19] = (reg_addr == RV_PLIC_PRIO17_OFFSET);
    addr_hit[20] = (reg_addr == RV_PLIC_PRIO18_OFFSET);
    addr_hit[21] = (reg_addr == RV_PLIC_PRIO19_OFFSET);
    addr_hit[22] = (reg_addr == RV_PLIC_PRIO20_OFFSET);
    addr_hit[23] = (reg_addr == RV_PLIC_PRIO21_OFFSET);
    addr_hit[24] = (reg_addr == RV_PLIC_PRIO22_OFFSET);
    addr_hit[25] = (reg_addr == RV_PLIC_PRIO23_OFFSET);
    addr_hit[26] = (reg_addr == RV_PLIC_PRIO24_OFFSET);
    addr_hit[27] = (reg_addr == RV_PLIC_PRIO25_OFFSET);
    addr_hit[28] = (reg_addr == RV_PLIC_PRIO26_OFFSET);
    addr_hit[29] = (reg_addr == RV_PLIC_PRIO27_OFFSET);
    addr_hit[30] = (reg_addr == RV_PLIC_PRIO28_OFFSET);
    addr_hit[31] = (reg_addr == RV_PLIC_PRIO29_OFFSET);
    addr_hit[32] = (reg_addr == RV_PLIC_PRIO30_OFFSET);
    addr_hit[33] = (reg_addr == RV_PLIC_PRIO31_OFFSET);
    addr_hit[34] = (reg_addr == RV_PLIC_IE0_OFFSET);
    addr_hit[35] = (reg_addr == RV_PLIC_THRESHOLD0_OFFSET);
    addr_hit[36] = (reg_addr == RV_PLIC_CC0_OFFSET);
  end

  always_ff @(posedge clk_i, negedge rst_ni) begin
    if (!rst_ni) begin
      tl_addrmiss <= 1'b0;
    end else if (reg_re || reg_we) begin
      tl_addrmiss <= ~|addr_hit;
    end
  end

  // Write Enable signal

































  assign le_le0_we = addr_hit[1] && reg_we;
  assign le_le0_wd = reg_wdata[0];

  assign le_le1_we = addr_hit[1] && reg_we;
  assign le_le1_wd = reg_wdata[1];

  assign le_le2_we = addr_hit[1] && reg_we;
  assign le_le2_wd = reg_wdata[2];

  assign le_le3_we = addr_hit[1] && reg_we;
  assign le_le3_wd = reg_wdata[3];

  assign le_le4_we = addr_hit[1] && reg_we;
  assign le_le4_wd = reg_wdata[4];

  assign le_le5_we = addr_hit[1] && reg_we;
  assign le_le5_wd = reg_wdata[5];

  assign le_le6_we = addr_hit[1] && reg_we;
  assign le_le6_wd = reg_wdata[6];

  assign le_le7_we = addr_hit[1] && reg_we;
  assign le_le7_wd = reg_wdata[7];

  assign le_le8_we = addr_hit[1] && reg_we;
  assign le_le8_wd = reg_wdata[8];

  assign le_le9_we = addr_hit[1] && reg_we;
  assign le_le9_wd = reg_wdata[9];

  assign le_le10_we = addr_hit[1] && reg_we;
  assign le_le10_wd = reg_wdata[10];

  assign le_le11_we = addr_hit[1] && reg_we;
  assign le_le11_wd = reg_wdata[11];

  assign le_le12_we = addr_hit[1] && reg_we;
  assign le_le12_wd = reg_wdata[12];

  assign le_le13_we = addr_hit[1] && reg_we;
  assign le_le13_wd = reg_wdata[13];

  assign le_le14_we = addr_hit[1] && reg_we;
  assign le_le14_wd = reg_wdata[14];

  assign le_le15_we = addr_hit[1] && reg_we;
  assign le_le15_wd = reg_wdata[15];

  assign le_le16_we = addr_hit[1] && reg_we;
  assign le_le16_wd = reg_wdata[16];

  assign le_le17_we = addr_hit[1] && reg_we;
  assign le_le17_wd = reg_wdata[17];

  assign le_le18_we = addr_hit[1] && reg_we;
  assign le_le18_wd = reg_wdata[18];

  assign le_le19_we = addr_hit[1] && reg_we;
  assign le_le19_wd = reg_wdata[19];

  assign le_le20_we = addr_hit[1] && reg_we;
  assign le_le20_wd = reg_wdata[20];

  assign le_le21_we = addr_hit[1] && reg_we;
  assign le_le21_wd = reg_wdata[21];

  assign le_le22_we = addr_hit[1] && reg_we;
  assign le_le22_wd = reg_wdata[22];

  assign le_le23_we = addr_hit[1] && reg_we;
  assign le_le23_wd = reg_wdata[23];

  assign le_le24_we = addr_hit[1] && reg_we;
  assign le_le24_wd = reg_wdata[24];

  assign le_le25_we = addr_hit[1] && reg_we;
  assign le_le25_wd = reg_wdata[25];

  assign le_le26_we = addr_hit[1] && reg_we;
  assign le_le26_wd = reg_wdata[26];

  assign le_le27_we = addr_hit[1] && reg_we;
  assign le_le27_wd = reg_wdata[27];

  assign le_le28_we = addr_hit[1] && reg_we;
  assign le_le28_wd = reg_wdata[28];

  assign le_le29_we = addr_hit[1] && reg_we;
  assign le_le29_wd = reg_wdata[29];

  assign le_le30_we = addr_hit[1] && reg_we;
  assign le_le30_wd = reg_wdata[30];

  assign le_le31_we = addr_hit[1] && reg_we;
  assign le_le31_wd = reg_wdata[31];

  assign prio0_we = addr_hit[2] && reg_we;
  assign prio0_wd = reg_wdata[2:0];

  assign prio1_we = addr_hit[3] && reg_we;
  assign prio1_wd = reg_wdata[2:0];

  assign prio2_we = addr_hit[4] && reg_we;
  assign prio2_wd = reg_wdata[2:0];

  assign prio3_we = addr_hit[5] && reg_we;
  assign prio3_wd = reg_wdata[2:0];

  assign prio4_we = addr_hit[6] && reg_we;
  assign prio4_wd = reg_wdata[2:0];

  assign prio5_we = addr_hit[7] && reg_we;
  assign prio5_wd = reg_wdata[2:0];

  assign prio6_we = addr_hit[8] && reg_we;
  assign prio6_wd = reg_wdata[2:0];

  assign prio7_we = addr_hit[9] && reg_we;
  assign prio7_wd = reg_wdata[2:0];

  assign prio8_we = addr_hit[10] && reg_we;
  assign prio8_wd = reg_wdata[2:0];

  assign prio9_we = addr_hit[11] && reg_we;
  assign prio9_wd = reg_wdata[2:0];

  assign prio10_we = addr_hit[12] && reg_we;
  assign prio10_wd = reg_wdata[2:0];

  assign prio11_we = addr_hit[13] && reg_we;
  assign prio11_wd = reg_wdata[2:0];

  assign prio12_we = addr_hit[14] && reg_we;
  assign prio12_wd = reg_wdata[2:0];

  assign prio13_we = addr_hit[15] && reg_we;
  assign prio13_wd = reg_wdata[2:0];

  assign prio14_we = addr_hit[16] && reg_we;
  assign prio14_wd = reg_wdata[2:0];

  assign prio15_we = addr_hit[17] && reg_we;
  assign prio15_wd = reg_wdata[2:0];

  assign prio16_we = addr_hit[18] && reg_we;
  assign prio16_wd = reg_wdata[2:0];

  assign prio17_we = addr_hit[19] && reg_we;
  assign prio17_wd = reg_wdata[2:0];

  assign prio18_we = addr_hit[20] && reg_we;
  assign prio18_wd = reg_wdata[2:0];

  assign prio19_we = addr_hit[21] && reg_we;
  assign prio19_wd = reg_wdata[2:0];

  assign prio20_we = addr_hit[22] && reg_we;
  assign prio20_wd = reg_wdata[2:0];

  assign prio21_we = addr_hit[23] && reg_we;
  assign prio21_wd = reg_wdata[2:0];

  assign prio22_we = addr_hit[24] && reg_we;
  assign prio22_wd = reg_wdata[2:0];

  assign prio23_we = addr_hit[25] && reg_we;
  assign prio23_wd = reg_wdata[2:0];

  assign prio24_we = addr_hit[26] && reg_we;
  assign prio24_wd = reg_wdata[2:0];

  assign prio25_we = addr_hit[27] && reg_we;
  assign prio25_wd = reg_wdata[2:0];

  assign prio26_we = addr_hit[28] && reg_we;
  assign prio26_wd = reg_wdata[2:0];

  assign prio27_we = addr_hit[29] && reg_we;
  assign prio27_wd = reg_wdata[2:0];

  assign prio28_we = addr_hit[30] && reg_we;
  assign prio28_wd = reg_wdata[2:0];

  assign prio29_we = addr_hit[31] && reg_we;
  assign prio29_wd = reg_wdata[2:0];

  assign prio30_we = addr_hit[32] && reg_we;
  assign prio30_wd = reg_wdata[2:0];

  assign prio31_we = addr_hit[33] && reg_we;
  assign prio31_wd = reg_wdata[2:0];

  assign ie0_e0_we = addr_hit[34] && reg_we;
  assign ie0_e0_wd = reg_wdata[0];

  assign ie0_e1_we = addr_hit[34] && reg_we;
  assign ie0_e1_wd = reg_wdata[1];

  assign ie0_e2_we = addr_hit[34] && reg_we;
  assign ie0_e2_wd = reg_wdata[2];

  assign ie0_e3_we = addr_hit[34] && reg_we;
  assign ie0_e3_wd = reg_wdata[3];

  assign ie0_e4_we = addr_hit[34] && reg_we;
  assign ie0_e4_wd = reg_wdata[4];

  assign ie0_e5_we = addr_hit[34] && reg_we;
  assign ie0_e5_wd = reg_wdata[5];

  assign ie0_e6_we = addr_hit[34] && reg_we;
  assign ie0_e6_wd = reg_wdata[6];

  assign ie0_e7_we = addr_hit[34] && reg_we;
  assign ie0_e7_wd = reg_wdata[7];

  assign ie0_e8_we = addr_hit[34] && reg_we;
  assign ie0_e8_wd = reg_wdata[8];

  assign ie0_e9_we = addr_hit[34] && reg_we;
  assign ie0_e9_wd = reg_wdata[9];

  assign ie0_e10_we = addr_hit[34] && reg_we;
  assign ie0_e10_wd = reg_wdata[10];

  assign ie0_e11_we = addr_hit[34] && reg_we;
  assign ie0_e11_wd = reg_wdata[11];

  assign ie0_e12_we = addr_hit[34] && reg_we;
  assign ie0_e12_wd = reg_wdata[12];

  assign ie0_e13_we = addr_hit[34] && reg_we;
  assign ie0_e13_wd = reg_wdata[13];

  assign ie0_e14_we = addr_hit[34] && reg_we;
  assign ie0_e14_wd = reg_wdata[14];

  assign ie0_e15_we = addr_hit[34] && reg_we;
  assign ie0_e15_wd = reg_wdata[15];

  assign ie0_e16_we = addr_hit[34] && reg_we;
  assign ie0_e16_wd = reg_wdata[16];

  assign ie0_e17_we = addr_hit[34] && reg_we;
  assign ie0_e17_wd = reg_wdata[17];

  assign ie0_e18_we = addr_hit[34] && reg_we;
  assign ie0_e18_wd = reg_wdata[18];

  assign ie0_e19_we = addr_hit[34] && reg_we;
  assign ie0_e19_wd = reg_wdata[19];

  assign ie0_e20_we = addr_hit[34] && reg_we;
  assign ie0_e20_wd = reg_wdata[20];

  assign ie0_e21_we = addr_hit[34] && reg_we;
  assign ie0_e21_wd = reg_wdata[21];

  assign ie0_e22_we = addr_hit[34] && reg_we;
  assign ie0_e22_wd = reg_wdata[22];

  assign ie0_e23_we = addr_hit[34] && reg_we;
  assign ie0_e23_wd = reg_wdata[23];

  assign ie0_e24_we = addr_hit[34] && reg_we;
  assign ie0_e24_wd = reg_wdata[24];

  assign ie0_e25_we = addr_hit[34] && reg_we;
  assign ie0_e25_wd = reg_wdata[25];

  assign ie0_e26_we = addr_hit[34] && reg_we;
  assign ie0_e26_wd = reg_wdata[26];

  assign ie0_e27_we = addr_hit[34] && reg_we;
  assign ie0_e27_wd = reg_wdata[27];

  assign ie0_e28_we = addr_hit[34] && reg_we;
  assign ie0_e28_wd = reg_wdata[28];

  assign ie0_e29_we = addr_hit[34] && reg_we;
  assign ie0_e29_wd = reg_wdata[29];

  assign ie0_e30_we = addr_hit[34] && reg_we;
  assign ie0_e30_wd = reg_wdata[30];

  assign ie0_e31_we = addr_hit[34] && reg_we;
  assign ie0_e31_wd = reg_wdata[31];

  assign threshold0_we = addr_hit[35] && reg_we;
  assign threshold0_wd = reg_wdata[2:0];

  assign cc0_we = addr_hit[36] && reg_we;
  assign cc0_wd = reg_wdata[5:0];
  assign cc0_re = addr_hit[36] && reg_re;

  // Read data return
  logic [DW-1:0] reg_rdata_next;
  always_comb begin
    reg_rdata_next = '0;
    unique case (1'b1)
      addr_hit[0]: begin
        reg_rdata_next[0] = ip_p0_qs;
        reg_rdata_next[1] = ip_p1_qs;
        reg_rdata_next[2] = ip_p2_qs;
        reg_rdata_next[3] = ip_p3_qs;
        reg_rdata_next[4] = ip_p4_qs;
        reg_rdata_next[5] = ip_p5_qs;
        reg_rdata_next[6] = ip_p6_qs;
        reg_rdata_next[7] = ip_p7_qs;
        reg_rdata_next[8] = ip_p8_qs;
        reg_rdata_next[9] = ip_p9_qs;
        reg_rdata_next[10] = ip_p10_qs;
        reg_rdata_next[11] = ip_p11_qs;
        reg_rdata_next[12] = ip_p12_qs;
        reg_rdata_next[13] = ip_p13_qs;
        reg_rdata_next[14] = ip_p14_qs;
        reg_rdata_next[15] = ip_p15_qs;
        reg_rdata_next[16] = ip_p16_qs;
        reg_rdata_next[17] = ip_p17_qs;
        reg_rdata_next[18] = ip_p18_qs;
        reg_rdata_next[19] = ip_p19_qs;
        reg_rdata_next[20] = ip_p20_qs;
        reg_rdata_next[21] = ip_p21_qs;
        reg_rdata_next[22] = ip_p22_qs;
        reg_rdata_next[23] = ip_p23_qs;
        reg_rdata_next[24] = ip_p24_qs;
        reg_rdata_next[25] = ip_p25_qs;
        reg_rdata_next[26] = ip_p26_qs;
        reg_rdata_next[27] = ip_p27_qs;
        reg_rdata_next[28] = ip_p28_qs;
        reg_rdata_next[29] = ip_p29_qs;
        reg_rdata_next[30] = ip_p30_qs;
        reg_rdata_next[31] = ip_p31_qs;
      end

      addr_hit[1]: begin
        reg_rdata_next[0] = le_le0_qs;
        reg_rdata_next[1] = le_le1_qs;
        reg_rdata_next[2] = le_le2_qs;
        reg_rdata_next[3] = le_le3_qs;
        reg_rdata_next[4] = le_le4_qs;
        reg_rdata_next[5] = le_le5_qs;
        reg_rdata_next[6] = le_le6_qs;
        reg_rdata_next[7] = le_le7_qs;
        reg_rdata_next[8] = le_le8_qs;
        reg_rdata_next[9] = le_le9_qs;
        reg_rdata_next[10] = le_le10_qs;
        reg_rdata_next[11] = le_le11_qs;
        reg_rdata_next[12] = le_le12_qs;
        reg_rdata_next[13] = le_le13_qs;
        reg_rdata_next[14] = le_le14_qs;
        reg_rdata_next[15] = le_le15_qs;
        reg_rdata_next[16] = le_le16_qs;
        reg_rdata_next[17] = le_le17_qs;
        reg_rdata_next[18] = le_le18_qs;
        reg_rdata_next[19] = le_le19_qs;
        reg_rdata_next[20] = le_le20_qs;
        reg_rdata_next[21] = le_le21_qs;
        reg_rdata_next[22] = le_le22_qs;
        reg_rdata_next[23] = le_le23_qs;
        reg_rdata_next[24] = le_le24_qs;
        reg_rdata_next[25] = le_le25_qs;
        reg_rdata_next[26] = le_le26_qs;
        reg_rdata_next[27] = le_le27_qs;
        reg_rdata_next[28] = le_le28_qs;
        reg_rdata_next[29] = le_le29_qs;
        reg_rdata_next[30] = le_le30_qs;
        reg_rdata_next[31] = le_le31_qs;
      end

      addr_hit[2]: begin
        reg_rdata_next[2:0] = prio0_qs;
      end

      addr_hit[3]: begin
        reg_rdata_next[2:0] = prio1_qs;
      end

      addr_hit[4]: begin
        reg_rdata_next[2:0] = prio2_qs;
      end

      addr_hit[5]: begin
        reg_rdata_next[2:0] = prio3_qs;
      end

      addr_hit[6]: begin
        reg_rdata_next[2:0] = prio4_qs;
      end

      addr_hit[7]: begin
        reg_rdata_next[2:0] = prio5_qs;
      end

      addr_hit[8]: begin
        reg_rdata_next[2:0] = prio6_qs;
      end

      addr_hit[9]: begin
        reg_rdata_next[2:0] = prio7_qs;
      end

      addr_hit[10]: begin
        reg_rdata_next[2:0] = prio8_qs;
      end

      addr_hit[11]: begin
        reg_rdata_next[2:0] = prio9_qs;
      end

      addr_hit[12]: begin
        reg_rdata_next[2:0] = prio10_qs;
      end

      addr_hit[13]: begin
        reg_rdata_next[2:0] = prio11_qs;
      end

      addr_hit[14]: begin
        reg_rdata_next[2:0] = prio12_qs;
      end

      addr_hit[15]: begin
        reg_rdata_next[2:0] = prio13_qs;
      end

      addr_hit[16]: begin
        reg_rdata_next[2:0] = prio14_qs;
      end

      addr_hit[17]: begin
        reg_rdata_next[2:0] = prio15_qs;
      end

      addr_hit[18]: begin
        reg_rdata_next[2:0] = prio16_qs;
      end

      addr_hit[19]: begin
        reg_rdata_next[2:0] = prio17_qs;
      end

      addr_hit[20]: begin
        reg_rdata_next[2:0] = prio18_qs;
      end

      addr_hit[21]: begin
        reg_rdata_next[2:0] = prio19_qs;
      end

      addr_hit[22]: begin
        reg_rdata_next[2:0] = prio20_qs;
      end

      addr_hit[23]: begin
        reg_rdata_next[2:0] = prio21_qs;
      end

      addr_hit[24]: begin
        reg_rdata_next[2:0] = prio22_qs;
      end

      addr_hit[25]: begin
        reg_rdata_next[2:0] = prio23_qs;
      end

      addr_hit[26]: begin
        reg_rdata_next[2:0] = prio24_qs;
      end

      addr_hit[27]: begin
        reg_rdata_next[2:0] = prio25_qs;
      end

      addr_hit[28]: begin
        reg_rdata_next[2:0] = prio26_qs;
      end

      addr_hit[29]: begin
        reg_rdata_next[2:0] = prio27_qs;
      end

      addr_hit[30]: begin
        reg_rdata_next[2:0] = prio28_qs;
      end

      addr_hit[31]: begin
        reg_rdata_next[2:0] = prio29_qs;
      end

      addr_hit[32]: begin
        reg_rdata_next[2:0] = prio30_qs;
      end

      addr_hit[33]: begin
        reg_rdata_next[2:0] = prio31_qs;
      end

      addr_hit[34]: begin
        reg_rdata_next[0] = ie0_e0_qs;
        reg_rdata_next[1] = ie0_e1_qs;
        reg_rdata_next[2] = ie0_e2_qs;
        reg_rdata_next[3] = ie0_e3_qs;
        reg_rdata_next[4] = ie0_e4_qs;
        reg_rdata_next[5] = ie0_e5_qs;
        reg_rdata_next[6] = ie0_e6_qs;
        reg_rdata_next[7] = ie0_e7_qs;
        reg_rdata_next[8] = ie0_e8_qs;
        reg_rdata_next[9] = ie0_e9_qs;
        reg_rdata_next[10] = ie0_e10_qs;
        reg_rdata_next[11] = ie0_e11_qs;
        reg_rdata_next[12] = ie0_e12_qs;
        reg_rdata_next[13] = ie0_e13_qs;
        reg_rdata_next[14] = ie0_e14_qs;
        reg_rdata_next[15] = ie0_e15_qs;
        reg_rdata_next[16] = ie0_e16_qs;
        reg_rdata_next[17] = ie0_e17_qs;
        reg_rdata_next[18] = ie0_e18_qs;
        reg_rdata_next[19] = ie0_e19_qs;
        reg_rdata_next[20] = ie0_e20_qs;
        reg_rdata_next[21] = ie0_e21_qs;
        reg_rdata_next[22] = ie0_e22_qs;
        reg_rdata_next[23] = ie0_e23_qs;
        reg_rdata_next[24] = ie0_e24_qs;
        reg_rdata_next[25] = ie0_e25_qs;
        reg_rdata_next[26] = ie0_e26_qs;
        reg_rdata_next[27] = ie0_e27_qs;
        reg_rdata_next[28] = ie0_e28_qs;
        reg_rdata_next[29] = ie0_e29_qs;
        reg_rdata_next[30] = ie0_e30_qs;
        reg_rdata_next[31] = ie0_e31_qs;
      end

      addr_hit[35]: begin
        reg_rdata_next[2:0] = threshold0_qs;
      end

      addr_hit[36]: begin
        reg_rdata_next[5:0] = cc0_qs;
      end

      default: begin
        reg_rdata_next = '1;
      end
    endcase
  end

  always_ff @(posedge clk_i, negedge rst_ni) begin
    if (!rst_ni) begin
      reg_valid <= 1'b0;
      reg_rdata <= '0;
      rsp_opcode <= tlul_pkg::AccessAck;
    end else if (reg_re || reg_we) begin
      // Guarantee to return data in a cycle
      reg_valid <= 1'b1;
      if (reg_re) begin
        reg_rdata <= reg_rdata_next;
        rsp_opcode <= tlul_pkg::AccessAckData;
      end else begin
        rsp_opcode <= tlul_pkg::AccessAck;
      end
    end else if (tl_reg_h2d.d_ready) begin
      reg_valid <= 1'b0;
    end
  end

  // Outstanding: 1 outstanding at a time. Identical to `reg_valid`
  always_ff @(posedge clk_i, negedge rst_ni) begin
    if (!rst_ni) begin
      outstanding <= 1'b0;
    end else if (tl_reg_h2d.a_valid && tl_reg_d2h.a_ready) begin
      outstanding <= 1'b1;
    end else if (tl_reg_d2h.d_valid && tl_reg_h2d.d_ready) begin
      outstanding <= 1'b0;
    end
  end

//pragma translate_off
`ifndef verilator
  // Assertion property
  //    Register Interface
  property pulse_prop(sig);
    @(posedge clk_i) disable iff (!rst_ni)
      $rose(sig) |=> !sig;
  endproperty
  we_pulse_assert: assert property(pulse_prop(reg_we));
  re_pulse_assert: assert property(pulse_prop(reg_re));

  property re_after_rv_prop;
    @(posedge clk_i) disable iff (!rst_ni)
      $rose(reg_re || reg_we) |=> reg_valid;
  endproperty
  re2rv_assert: assert property(re_after_rv_prop);

  property en2addr_prop;
    @(posedge clk_i) disable iff (!rst_ni)
      (reg_we | reg_re) |-> $onehot0(addr_hit);
  endproperty
  en2addr_hit_assert: assert property (en2addr_prop);

  property reqparity_prop;
    @(posedge clk_i) disable iff (!rst_ni)
      (tl_i.a_valid & tl_i.a_user[8]) == 1'b0;
  endproperty
  reqparity_assert: assert property (reqparity_prop);
`endif
//pragma translate_on

endmodule



