/* Copyright 2018 ETH Zurich and University of Bologna.
 * Copyright and related rights are licensed under the Solderpad Hardware
 * License, Version 0.51 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://solderpad.org/licenses/SHL-0.51. Unless required by applicable law
 * or agreed to in writing, software, hardware and materials distributed under
 * this License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * File: $filename.v
 *
 * Description: Auto-generated bootrom
 */

// Auto-generated code
module bootrom_32 (
   input  logic         clk_i,
   input  logic         req_i,
   input  logic [63:0]  addr_i,
   output logic [63:0]  rdata_o
);
    localparam int RomSize = 988;

    const logic [RomSize-1:0][63:0] mem = {
        64'h00000000_0a0d2165,
        64'h6e6f6420_00206567,
        64'h616d6920_746f6f62,
        64'h20676e69_79706f63,
        64'h00000009_3a656d61,
        64'h6e090a0d_00093a73,
        64'h65747562_69727474,
        64'h61090a0d_00000009,
        64'h3a61626c_20747361,
        64'h6c090a0d_0000093a,
        64'h61626c20_74737269,
        64'h66090a0d_00000000,
        64'h09202020_20203a64,
        64'h69756720_6e6f6974,
        64'h69747261_70090a0d,
        64'h00000000_093a6469,
        64'h75672065_70797420,
        64'h6e6f6974_69747261,
        64'h70090a0d_00000000,
        64'h20797274_6e65206e,
        64'h6f697469_74726170,
        64'h20747067_00000009,
        64'h20203a73_65697274,
        64'h6e65206e_6f697469,
        64'h74726170_20657a69,
        64'h73090a0d_00000009,
        64'h3a736569_72746e65,
        64'h206e6f69_74697472,
        64'h61702072_65626d75,
        64'h6e090a0d_00000009,
        64'h2020203a_61626c20,
        64'h73656972_746e6520,
        64'h6e6f6974_69747261,
        64'h70090a0d_00093a61,
        64'h646c2070_756b6361,
        64'h62090a0d_00000000,
        64'h093a6162_6c20746e,
        64'h65727275_63090a0d,
        64'h00000009_3a646576,
        64'h72657365_72090a0d,
        64'h00093a72_65646165,
        64'h685f6372_63090a0d,
        64'h00000909_3a657a69,
        64'h73090a0d_00000009,
        64'h3a6e6f69_73697665,
        64'h72090a0d_0000093a,
        64'h65727574_616e6769,
        64'h73090a0d_003a7265,
        64'h64616568_20656c62,
        64'h6174206e_6f697469,
        64'h74726170_20747067,
        64'h0000203a_65756c61,
        64'h76206e72_75746572,
        64'h2079706f_63206473,
        64'h0000000a_0d216465,
        64'h6c696166_20647261,
        64'h63204453_0000000a,
        64'h0d216465_7a696c61,
        64'h6974696e_69206473,
        64'h00000000_0a0d676e,
        64'h69746978_65202e2e,
        64'h2e647320_657a696c,
        64'h61697469_6e692074,
        64'h6f6e2064_6c756f63,
        64'h0000002e_0000000a,
        64'h0d6b636f_6c622044,
        64'h53206461_65722074,
        64'h6f6e2064_6c756f63,
        64'h0000000a_0d202e2e,
        64'h2e445320_676e697a,
        64'h696c6169_74696e69,
        64'h00000031_34646d63,
        64'h00000035_35646d63,
        64'h00000000_30646d63,
        64'h00000020_3a206573,
        64'h6e6f7073_65720920,
        64'h0020646e_616d6d6f,
        64'h63204453_00000000,
        64'h203f3f79_74706d65,
        64'h20746f6e_206f6669,
        64'h66207872_00000a0d,
        64'h2164657a_696c6169,
        64'h74696e69_20495053,
        64'h00007830_203a7375,
        64'h74617473_00000a0d,
        64'h49505320_74696e69,
        64'h00000a0d_21646c72,
        64'h6f57206f_6c6c6548,
        64'h00000032_2d746c75,
        64'h61666564_2d697274,
        64'h2c786e6c_7800746c,
        64'h75616665_642d6972,
        64'h742c786e_6c78006c,
        64'h6175642d_73692c78,
        64'h6e6c7800_746e6573,
        64'h6572702d_74707572,
        64'h7265746e_692c786e,
        64'h6c780068_74646977,
        64'h2d326f69_70672c78,
        64'h6e6c7800_68746469,
        64'h772d6f69_70672c78,
        64'h6e6c7800_322d746c,
        64'h75616665_642d7475,
        64'h6f642c78_6e6c7800,
        64'h746c7561_6665642d,
        64'h74756f64_2c786e6c,
        64'h7800322d_73747570,
        64'h6e692d6c_6c612c78,
        64'h6e6c7800_73747570,
        64'h6e692d6c_6c612c78,
        64'h6e6c7800_72656c6c,
        64'h6f72746e_6f632d6f,
        64'h69706700_736c6c65,
        64'h632d6f69_70672300,
        64'h73736572_6464612d,
        64'h63616d2d_6c61636f,
        64'h6c007077_2d656c62,
        64'h61736964_00736567,
        64'h6e61722d_65676174,
        64'h6c6f7600_79636e65,
        64'h75716572_662d7861,
        64'h6d2d6970_73006f69,
        64'h7461722d_6b63732c,
        64'h786e6c78_00737469,
        64'h622d7265_66736e61,
        64'h72742d6d_756e2c78,
        64'h6e6c7800_73746962,
        64'h2d73732d_6d756e2c,
        64'h786e6c78_00747369,
        64'h78652d6f_6669662c,
        64'h786e6c78_00796c69,
        64'h6d61662c_786e6c78,
        64'h00687464_69772d6f,
        64'h692d6765_72007466,
        64'h6968732d_67657200,
        64'h73747075_72726574,
        64'h6e690074_6e657261,
        64'h702d7470_75727265,
        64'h746e6900_64656570,
        64'h732d746e_65727275,
        64'h63007665_646e2c76,
        64'h63736972_00797469,
        64'h726f6972_702d7861,
        64'h6d2c7663_73697200,
        64'h73656d61_6e2d6765,
        64'h72006465_646e6574,
        64'h78652d73_74707572,
        64'h7265746e_69007365,
        64'h676e6172_00646564,
        64'h6e657073_75732d65,
        64'h74617473_2d6e6961,
        64'h74657200_72656767,
        64'h6972742d_746c7561,
        64'h6665642c_78756e69,
        64'h6c00736f_69706700,
        64'h656c646e_61687000,
        64'h72656c6c_6f72746e,
        64'h6f632d74_70757272,
        64'h65746e69_00736c6c,
        64'h65632d74_70757272,
        64'h65746e69_23007469,
        64'h6c70732d_626c7400,
        64'h65707974_2d756d6d,
        64'h00617369_2c766373,
        64'h69720073_75746174,
        64'h73006765_72006570,
        64'h79745f65_63697665,
        64'h64007963_6e657571,
        64'h6572662d_6b636f6c,
        64'h63007963_6e657571,
        64'h6572662d_65736162,
        64'h656d6974_00687461,
        64'h702d7475_6f647473,
        64'h006c6564_6f6d0065,
        64'h6c626974_61706d6f,
        64'h6300736c_6c65632d,
        64'h657a6973_2300736c,
        64'h6c65632d_73736572,
        64'h64646123_09000000,
        64'h02000000_02000000,
        64'h02000000_01000000,
        64'hb5000000_04000000,
        64'h03000000_ffffffff,
        64'hbf020000_04000000,
        64'h03000000_ffffffff,
        64'hae020000_04000000,
        64'h03000000_01000000,
        64'ha1020000_04000000,
        64'h03000000_00000000,
        64'h8a020000_04000000,
        64'h03000000_08000000,
        64'h79020000_04000000,
        64'h03000000_08000000,
        64'h69020000_04000000,
        64'h03000000_00000000,
        64'h55020000_04000000,
        64'h03000000_00000000,
        64'h43020000_04000000,
        64'h03000000_00000000,
        64'h31020000_04000000,
        64'h03000000_00000000,
        64'h21020000_04000000,
        64'h03000000_00000100,
        64'h00000040_67000000,
        64'h08000000_03000000,
        64'h11020000_00000000,
        64'h03000000_00000000,
        64'h612e3030_2e312d6f,
        64'h6970672d_7370782c,
        64'h786e6c78_1b000000,
        64'h15000000_03000000,
        64'h02000000_05020000,
        64'h04000000_03000000,
        64'h00000030_30303030,
        64'h30303440_6f697067,
        64'h01000000_02000000,
        64'h00800000_00000030,
        64'h67000000_08000000,
        64'h03000000_00007fe3,
        64'h023e1800_f3010000,
        64'h06000000_03000000,
        64'h00000000_03000000,
        64'h52010000_08000000,
        64'h03000000_03000000,
        64'h41010000_04000000,
        64'h03000000_006b726f,
        64'h7774656e_5b000000,
        64'h08000000_03000000,
        64'h00687465_2d637369,
        64'h72776f6c_1b000000,
        64'h0c000000_03000000,
        64'h00000000_30303030,
        64'h30303033_40687465,
        64'h2d637369_72776f6c,
        64'h01000000_02000000,
        64'h02000000_e8010000,
        64'h00000000_03000000,
        64'he40c0000_e40c0000,
        64'hd9010000_08000000,
        64'h03000000_20bcbe00,
        64'hc7010000_04000000,
        64'h03000000_00000000,
        64'h67000000_04000000,
        64'h03000000_00000000,
        64'h746f6c73_2d697073,
        64'h2d636d6d_1b000000,
        64'h0d000000_03000000,
        64'h00000030_40636d6d,
        64'h01000000_04000000,
        64'hb8010000_04000000,
        64'h03000000_08000000,
        64'ha1010000_04000000,
        64'h03000000_01000000,
        64'h90010000_04000000,
        64'h03000000_01000000,
        64'h80010000_04000000,
        64'h03000000_00377865,
        64'h746e696b_74010000,
        64'h08000000_03000000,
        64'h00100000_00000020,
        64'h67000000_08000000,
        64'h03000000_02000000,
        64'h02000000_52010000,
        64'h08000000_03000000,
        64'h03000000_41010000,
        64'h04000000_03000000,
        64'h00000000_0f000000,
        64'h04000000_03000000,
        64'h01000000_00000000,
        64'h04000000_03000000,
        64'h00612e30_302e322d,
        64'h6970732d_7370782c,
        64'h786e6c78_00622e30,
        64'h302e322d_6970732d,
        64'h7370782c_786e6c78,
        64'h1b000000_28000000,
        64'h03000000_00000000,
        64'h30303030_30303032,
        64'h40697073_2d737078,
        64'h01000000_02000000,
        64'h006c6f72_746e6f63,
        64'h0b010000_08000000,
        64'h03000000_03000000,
        64'h41010000_04000000,
        64'h03000000_00100000,
        64'h00000018_67000000,
        64'h08000000_03000000,
        64'h07000000_06000000,
        64'h05000000_04000000,
        64'h52010000_10000000,
        64'h03000000_00007265,
        64'h6d69745f_6270612c,
        64'h706c7570_1b000000,
        64'h0f000000_03000000,
        64'h00003030_30303030,
        64'h38314072_656d6974,
        64'h01000000_02000000,
        64'h04000000_67010000,
        64'h04000000_03000000,
        64'h02000000_5d010000,
        64'h04000000_03000000,
        64'h01000000_52010000,
        64'h04000000_03000000,
        64'h03000000_41010000,
        64'h04000000_03000000,
        64'h00c20100_33010000,
        64'h04000000_03000000,
        64'h80f0fa02_4b000000,
        64'h04000000_03000000,
        64'h00100000_00000010,
        64'h67000000_08000000,
        64'h03000000_00303537,
        64'h3631736e_1b000000,
        64'h08000000_03000000,
        64'h00000030_30303030,
        64'h30303140_74726175,
        64'h01000000_02000000,
        64'h006c6f72_746e6f63,
        64'h0b010000_08000000,
        64'h03000000_00100000,
        64'h00000000_67000000,
        64'h08000000_03000000,
        64'hffff0000_02000000,
        64'hf7000000_08000000,
        64'h03000000_00333130,
        64'h2d677562_65642c76,
        64'h63736972_1b000000,
        64'h10000000_03000000,
        64'h00003040_72656c6c,
        64'h6f72746e_6f632d67,
        64'h75626564_01000000,
        64'h02000000_03000000,
        64'hb5000000_04000000,
        64'h03000000_1e000000,
        64'h28010000_04000000,
        64'h03000000_07000000,
        64'h15010000_04000000,
        64'h03000000_00000004,
        64'h0000000c_67000000,
        64'h08000000_03000000,
        64'h09000000_02000000,
        64'h0b000000_02000000,
        64'hf7000000_10000000,
        64'h03000000_a0000000,
        64'h00000000_03000000,
        64'h00306369_6c702c76,
        64'h63736972_1b000000,
        64'h0c000000_03000000,
        64'h01000000_8f000000,
        64'h04000000_03000000,
        64'h00000000_00000000,
        64'h04000000_03000000,
        64'h00000000_30303030,
        64'h30306340_72656c6c,
        64'h6f72746e_6f632d74,
        64'h70757272_65746e69,
        64'h01000000_02000000,
        64'h006c6f72_746e6f63,
        64'h0b010000_08000000,
        64'h03000000_00000c00,
        64'h00000002_67000000,
        64'h08000000_03000000,
        64'h07000000_02000000,
        64'h03000000_02000000,
        64'hf7000000_10000000,
        64'h03000000_00000000,
        64'h30746e69_6c632c76,
        64'h63736972_1b000000,
        64'h0d000000_03000000,
        64'h00000030_30303030,
        64'h30324074_6e696c63,
        64'h01000000_f0000000,
        64'h00000000_03000000,
        64'h00007375_622d656c,
        64'h706d6973_00636f73,
        64'h2d657261_622d656e,
        64'h61697261_2c687465,
        64'h1b000000_1f000000,
        64'h03000000_01000000,
        64'h0f000000_04000000,
        64'h03000000_01000000,
        64'h00000000_04000000,
        64'h03000000_00636f73,
        64'h01000000_02000000,
        64'h02000000_d9000000,
        64'h00000000_03000000,
        64'h00000074_61656274,
        64'h72616568_c3000000,
        64'h0a000000_03000000,
        64'h00000000_01000000,
        64'h01000000_bd000000,
        64'h0c000000_03000000,
        64'h00000064_656c2d74,
        64'h61656274_72616568,
        64'h01000000_00000073,
        64'h64656c2d_6f697067,
        64'h1b000000_0a000000,
        64'h03000000_00000000,
        64'h7364656c_01000000,
        64'h02000000_00000008,
        64'h00000080_67000000,
        64'h08000000_03000000,
        64'h00007972_6f6d656d,
        64'h5b000000_07000000,
        64'h03000000_00303030,
        64'h30303030_38407972,
        64'h6f6d656d_01000000,
        64'h02000000_02000000,
        64'h02000000_02000000,
        64'hb5000000_04000000,
        64'h03000000_00006374,
        64'h6e692d75_70632c76,
        64'h63736972_1b000000,
        64'h0f000000_03000000,
        64'ha0000000_00000000,
        64'h03000000_01000000,
        64'h8f000000_04000000,
        64'h03000000_00000000,
        64'h72656c6c_6f72746e,
        64'h6f632d74_70757272,
        64'h65746e69_01000000,
        64'h85000000_00000000,
        64'h03000000_00003233,
        64'h76732c76_63736972,
        64'h7c000000_0b000000,
        64'h03000000_00616d69,
        64'h32337672_72000000,
        64'h08000000_03000000,
        64'h00000076_63736972,
        64'h00656e61_69726120,
        64'h2c687465_1b000000,
        64'h12000000_03000000,
        64'h00000000_79616b6f,
        64'h6b000000_05000000,
        64'h03000000_00000000,
        64'h67000000_04000000,
        64'h03000000_00757063,
        64'h5b000000_04000000,
        64'h03000000_80f0fa02,
        64'h4b000000_04000000,
        64'h03000000_00000030,
        64'h40757063_01000000,
        64'h40787d01_38000000,
        64'h04000000_03000000,
        64'h00000000_0f000000,
        64'h04000000_03000000,
        64'h01000000_00000000,
        64'h04000000_03000000,
        64'h00000000_73757063,
        64'h01000000_02000000,
        64'h00000030_30323531,
        64'h313a3030_30303030,
        64'h30314074_7261752f,
        64'h636f732f_2c000000,
        64'h1a000000_03000000,
        64'h00006e65_736f6863,
        64'h01000000_00657261,
        64'h622d656e_61697261,
        64'h2c687465_26000000,
        64'h10000000_03000000,
        64'h00766564_2d657261,
        64'h622d656e_61697261,
        64'h2c687465_1b000000,
        64'h14000000_03000000,
        64'h01000000_0f000000,
        64'h04000000_03000000,
        64'h01000000_00000000,
        64'h04000000_03000000,
        64'h00000000_01000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h14090000_d2020000,
        64'h00000000_10000000,
        64'h11000000_28000000,
        64'h4c090000_38000000,
        64'h1e0c0000_edfe0dd0,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h46454443_42413938,
        64'h37363534_33323130,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h0000006f_00040067,
        64'h12858593_00000597,
        64'h80000437_00051a63,
        64'hc41ff0ef_80000537,
        64'h000085b7_ac4ff0ef,
        64'hd6850513_00001517,
        64'ha88ff0ef_00112623,
        64'h08050513_20058593,
        64'hff010113_02faf537,
        64'h0001c5b7_f11ff06f,
        64'hffe00493_af4ff0ef,
        64'hdd050513_00001517,
        64'hbb8ff0ef_41f4d593,
        64'h00048513_b0cff0ef,
        64'hec050513_00001517,
        64'hb18ff0ef_eb850513,
        64'h00001517_f49ff06f,
        64'hffe00493_b2cff0ef,
        64'he0850513_00001517,
        64'hbf0ff0ef_41fad593,
        64'h000a8513_b44ff0ef,
        64'hef850513_00001517,
        64'hb50ff0ef_ef050513,
        64'h00001517_f81ff06f,
        64'hffe00493_b64ff0ef,
        64'he4050513_00001517,
        64'hc28ff0ef_41f4d593,
        64'h00048513_b7cff0ef,
        64'hf3050513_00001517,
        64'hb88ff0ef_f2850513,
        64'h00001517_fb9ff06f,
        64'hfff00493_b9cff0ef,
        64'hf0050513_00001517,
        64'h00008067_03010113,
        64'h00812c03_00c12b83,
        64'h01012b03_01412a83,
        64'h01812a03_01c12983,
        64'h02012903_02412483,
        64'h02812403_00048513,
        64'h02c12083_fd040113,
        64'hbe0ff0ef_13850513,
        64'h00001517_04051e63,
        64'h00050493_bb1ff0ef,
        64'h40b60633_00160613,
        64'h000b8513_020c2583,
        64'h028c2603_c0cff0ef,
        64'h15050513_00001517,
        64'hf36a94e3_080a0a13,
        64'h08098993_08048913,
        64'hc28ff0ef_001a8a93,
        64'hf0850513_00001517,
        64'hff249ae3_d78ff0ef,
        64'h00148493_0004c503,
        64'hc48ff0ef_18050513,
        64'h00001517_d0cff0ef,
        64'h0149a583_0109a503,
        64'hc60ff0ef_18850513,
        64'h00001517_d24ff0ef,
        64'h0089a503_00c9a583,
        64'hc78ff0ef_19050513,
        64'h00001517_d3cff0ef,
        64'hfb890493_0009a503,
        64'h0049a583_c94ff0ef,
        64'h19c50513_00001517,
        64'hff349ae3_de0ff0ef,
        64'h00148493_0004c503,
        64'h000a0493_cb4ff0ef,
        64'h1a050513_00001517,
        64'hff449ae3_e00ff0ef,
        64'h00148493_0004c503,
        64'hf8090493_cd4ff0ef,
        64'h1a450513_00001517,
        64'he1cff0ef_0ffaf513,
        64'hce8ff0ef_1a050513,
        64'h00001517_00400b13,
        64'h01010a13_02010993,
        64'h08010913_1a051663,
        64'h00050a93_00010c13,
        64'hccdff0ef_00010513,
        64'h00100613_e0010113,
        64'h04892583_d24ff0ef,
        64'h00050513_00001517,
        64'hd88ff0ef_05412503,
        64'hd38ff0ef_1d050513,
        64'h00001517_d9cff0ef,
        64'h05012503_d4cff0ef,
        64'h1c450513_00001517,
        64'he10ff0ef_04812503,
        64'h04c12583_d64ff0ef,
        64'h1bc50513_00001517,
        64'he28ff0ef_02012503,
        64'h02412583_d7cff0ef,
        64'h1c450513_00001517,
        64'he40ff0ef_01812503,
        64'h01c12583_d94ff0ef,
        64'h1c850513_00001517,
        64'hdf8ff0ef_01412503,
        64'hda8ff0ef_1cc50513,
        64'h00001517_e0cff0ef,
        64'h01012503_dbcff0ef,
        64'h1d050513_00001517,
        64'he20ff0ef_00c12503,
        64'hdd0ff0ef_1d850513,
        64'h00001517_e34ff0ef,
        64'h00812503_de4ff0ef,
        64'h1dc50513_00001517,
        64'hea8ff0ef_00012503,
        64'h00412583_dfcff0ef,
        64'h1e450513_00001517,
        64'he08ff0ef_1d450513,
        64'h00001517_2e051a63,
        64'h00050493_00010913,
        64'hdddff0ef_00010513,
        64'h00100593_00100613,
        64'he0010113_e34ff0ef,
        64'h1c050513_00001517,
        64'h28051e63_d09ff0ef,
        64'h00050b93_03010413,
        64'h01812423_01612823,
        64'h01512a23_01412c23,
        64'h01312e23_03212023,
        64'h02912223_02112623,
        64'h01712623_02812423,
        64'hfd010113_fadff06f,
        64'hfff00413_e84ff0ef,
        64'h1c850513_00001517,
        64'hfe041ae3_8edff0ef,
        64'h0ff00513_fff40413,
        64'h00800413_00008067,
        64'h0b010113_08c12b83,
        64'h09012b03_09412a83,
        64'h09812a03_09c12983,
        64'h0a012903_0a412483,
        64'h0a812403_0ac12083,
        64'h00040513_92dff0ef,
        64'h0ff00513_a9dff0ef,
        64'h00c00513_00000593,
        64'h00100613_ffe00413,
        64'hfe1ff06f_ef4ff0ef,
        64'h25450513_00001517,
        64'h0180006f_00000413,
        64'hf33048e3_20048493,
        64'hfff98993_00078c63,
        64'h0349e7b3_02879863,
        64'h0107d793_01079793,
        64'h00aae7b3_985ff0ef,
        64'h010ada93_0ff00513,
        64'h010a9a93_00851a93,
        64'h999ff0ef_0ff00513,
        64'hf89b94e3_04070a93,
        64'h040b8b93_fb5714e3,
        64'h01045413_00170713,
        64'h01041413_00f44433,
        64'h0167f7b3_00579793,
        64'h0107d793_01041793,
        64'h41045413_01041413,
        64'h00f44433_00c41793,
        64'h00f44433_00f47413,
        64'h0047d413_0107d793,
        64'h01041793_00d44433,
        64'h0087e433_00845413,
        64'h00841793_00074683,
        64'h000b8713_ac1ff0ef,
        64'h00010513_04000593,
        64'h000b8613_00000413,
        64'he4048a93_ff251ce3,
        64'ha29ff0ef_0ff00513,
        64'he0048b93_3e800a13,
        64'hfe0b0b13_0fe00913,
        64'h00002b37_14051663,
        64'h20048493_bb5ff0ef,
        64'h01200513_00100613,
        64'hfed79ce3_00178793,
        64'h00e78023_fff00713,
        64'h08010693_00010793,
        64'h00060993_00050493,
        64'h09712623_09612823,
        64'h09512a23_09412c23,
        64'h0b212023_0a812423,
        64'h0a112623_09312e23,
        64'h0a912223_f5010113,
        64'h00008067_01055513,
        64'h01051513_00f54533,
        64'h00e7f7b3_00579793,
        64'hfe070713_00002737,
        64'h0107d793_01051793,
        64'h41055513_01051513,
        64'h00a5c533_00c59513,
        64'h00b545b3_00f57513,
        64'h0045d513_00b7c5b3,
        64'h0107d793_01079793,
        64'h00a7e7b3_00855513,
        64'h00851793_00008067,
        64'h07f57513_00a5c533,
        64'h00451593_00b54533,
        64'h00f54533_0045d513,
        64'h0075d793_00b575b3,
        64'hfd9ff06f_ffd00793,
        64'hfe1ff06f_ffe00793,
        64'hfe9ff06f_fff00793,
        64'h00008067_01010113,
        64'h00078513_00812403,
        64'h00c12083_02050463,
        64'h00000793_f61ff0ef,
        64'h02050663_e6dff0ef,
        64'h02050663_dc5ff0ef,
        64'hfe041ae3_b6dff0ef,
        64'h0ff00513_fff40413,
        64'h00a00413_925ff0ef,
        64'h45050513_00001517,
        64'hac9ff0ef_00812423,
        64'h00112623_ff010113,
        64'h00008067_01010113,
        64'h00412483_00812403,
        64'h00c12083_00143513,
        64'hfc9408e3_bb5ff0ef,
        64'h0ff00513_dc1ff0ef,
        64'h48850513_00001517,
        64'h00050593_00050413,
        64'hd39ff0ef_02900513,
        64'h400005b7_07700613,
        64'hf9dff0ef_00100493,
        64'h00812423_00112623,
        64'h00912223_ff010113,
        64'h00008067_01010113,
        64'h00153513_00812403,
        64'h00c12083_fff40513,
        64'he15ff0ef_4d850513,
        64'h00040593_00001517,
        64'hc21ff0ef_0ff00513,
        64'h00050413_d95ff0ef,
        64'h00812423_00112623,
        64'h03700513_00000593,
        64'h06500613_ff010113,
        64'h00008067_01010113,
        64'h00153513_00012903,
        64'h00412483_f5690513,
        64'h00812403_00c12083,
        64'hfe8492e3_00f4f493,
        64'h00008067_01010113,
        64'h00012903_00412483,
        64'h00812403_00c12083,
        64'h00f40e63_00000513,
        64'h00100793_c95ff0ef,
        64'h0ff00513_c9dff0ef,
        64'h0ff00513_00050913,
        64'hca9ff0ef_0ff00513,
        64'h00050493_cb5ff0ef,
        64'h0ff00513_cbdff0ef,
        64'h0ff00513_cc5ff0ef,
        64'h0ff00513_00050413,
        64'he39ff0ef_01212023,
        64'h00912223_00812423,
        64'h00112623_00800513,
        64'h1aa00593_08700613,
        64'hff010113_00008067,
        64'h01010113_00000513,
        64'h00012903_00412483,
        64'h00812403_00c12083,
        64'h00008067_01010113,
        64'h00100513_00012903,
        64'h00412483_00812403,
        64'h00c12083_f31ff0ef,
        64'h00100593_5ec50513,
        64'h00001517_fd249ee3,
        64'hfff40413_00000513,
        64'h00000593_09500613,
        64'h04040263_d55ff0ef,
        64'h0ff00513_00050493,
        64'hec9ff0ef_0180006f,
        64'h00100913_70f40413,
        64'hd71ff0ef_0ff00513,
        64'h00002437_00050493,
        64'hee9ff0ef_01212023,
        64'h00912223_00812423,
        64'h00112623_00000513,
        64'h00000593_09500613,
        64'hff010113_b4dff06f,
        64'h01010113_62c50513,
        64'h00001517_00412483,
        64'h00c12083_00812403,
        64'hca5ff0ef_00040513,
        64'hb71ff0ef_67450513,
        64'h00001517_b7dff0ef,
        64'h00048513_b85ff0ef,
        64'h00058413_00812423,
        64'h00112623_68850513,
        64'h00001517_00050493,
        64'h00912223_ff010113,
        64'h00008067_01010113,
        64'h00012903_00412483,
        64'h00812403_00c12083,
        64'hfe07c4e3_fff40413,
        64'h4187d793_01851793,
        64'he29ff0ef_0ff00513,
        64'h00040e63_0080006f,
        64'h06400413_e3dff0ef,
        64'h00048513_e45ff0ef,
        64'h0ff47513_e4dff0ef,
        64'h0ff57513_00845513,
        64'he59ff0ef_0ff57513,
        64'h01045513_e65ff0ef,
        64'h01845513_e6dff0ef,
        64'h04096513_e75ff0ef,
        64'h00060493_00058413,
        64'h00912223_00812423,
        64'h00112623_0ff00513,
        64'h00050913_01212023,
        64'hff010113_e9dff06f,
        64'h0ff00513_00008067,
        64'hfff00513_00008067,
        64'h00000513_06e7a023,
        64'h00600713_06e7a823,
        64'hfff00713_200007b7,
        64'hfec594e3_fef60fa3,
        64'h00160613_06c6a783,
        64'hfe079ae3_0017f793,
        64'h06472783_02c58063,
        64'h200006b7_20000737,
        64'h00b605b3_fe079ce3,
        64'h0017f793_06472783,
        64'h20000737_06e7a023,
        64'h200007b7_10600713,
        64'hfe079ce3_fff78793,
        64'h00000013_03200793,
        64'hfed51ae3_06f72423,
        64'h00150513_00054783,
        64'h00058a63_20000737,
        64'h00b506b3_06e7a823,
        64'h200007b7_ffe00713,
        64'h0ab7e063_10000793,
        64'hfb1ff06f_cfdff0ef,
        64'h7d850513_00001517,
        64'hdc1ff0ef_00000593,
        64'h00042503_d15ff0ef,
        64'h7f450513_00001517,
        64'h00008067_01010113,
        64'h00412483_0ff4f513,
        64'h06e7a023_00600713,
        64'h06e7a823_00812403,
        64'h00c12083_fff00713,
        64'h200007b7_02078863,
        64'h0017f793_06472783,
        64'h06c72483_fe079ae3,
        64'h0017f793_06470413,
        64'h06472783_20000737,
        64'h06e7a023_200007b7,
        64'h10600713_fe079ce3,
        64'hfff78793_00000013,
        64'h06400793_06a7a423,
        64'h06e7a823_ffe00713,
        64'h00912223_00812423,
        64'h00112623_200007b7,
        64'hff010113_dadff06f,
        64'h01010113_87c50513,
        64'h00002517_00412483,
        64'h00c12083_00812403,
        64'h06f42023_00600793,
        64'hdd1ff0ef_8ac50513,
        64'h00002517_e95ff0ef,
        64'h00000593_00048513,
        64'hde9ff0ef_8a850513,
        64'h00002517_06442483,
        64'h06f42023_16600793,
        64'he01ff0ef_8dc50513,
        64'h00002517_ec5ff0ef,
        64'h00048513_00000593,
        64'he19ff0ef_8d850513,
        64'h00002517_06442483,
        64'h06f42023_10400793,
        64'h20000437_fe079ce3,
        64'hfff78793_00000013,
        64'h00a00793_04e7a023,
        64'h00a00713_200007b7,
        64'he51ff0ef_00912223,
        64'h00812423_00112623,
        64'h91450513_ff010113,
        64'h00002517_00008067,
        64'h00052503_00008067,
        64'h00b52023_00008067,
        64'h00d70023_fe078ce3,
        64'h0207f793_01474783,
        64'h10000737_00c70023,
        64'hfe078ce3_0207f793,
        64'h01474783_10000737,
        64'h00074683_0007c603,
        64'h00a787b3_00e78733,
        64'h00455513_00f57713,
        64'hc4078793_00001797,
        64'hfa9ff06f_00f667b3,
        64'h00d557b3_00ce9633,
        64'h40de0633_00008067,
        64'hfa669ae3_ff868693,
        64'h00c70023_fe078ce3,
        64'h0207f793_01474783,
        64'h01170023_fe078ce3,
        64'h0207f793_01474783,
        64'h0007c883_00064603,
        64'h00f807b3_00c80633,
        64'h0047d793_00f7f613,
        64'h0ff7f793_00f5d7b3,
        64'h0407c863_fe068793,
        64'hff800313_10000737,
        64'h01f00e13_00159e93,
        64'hcc480813_03800693,
        64'h00001817_00008067,
        64'hfb169ee3_ff868693,
        64'h00c70023_fe078ce3,
        64'h0207f793_01474783,
        64'h01070023_fe078ce3,
        64'h0207f793_01474783,
        64'h0007c803_00064603,
        64'h00f587b3_00c58633,
        64'h0047d793_00f7f613,
        64'h0ff7f793_00d557b3,
        64'hff800893_10000737,
        64'hd2458593_01800693,
        64'h00001597_00008067,
        64'h00f58023_0007c783,
        64'h00e580a3_00a787b3,
        64'h00455513_00074703,
        64'h00e78733_00f57713,
        64'hd5078793_00001797,
        64'h00008067_fe0694e3,
        64'h00054683_00150513,
        64'h00d70023_fe078ce3,
        64'h0207f793_01474783,
        64'h10000737_02068263,
        64'h00054683_00008067,
        64'h00e78823_02000713,
        64'h00e78423_fc700713,
        64'h00e78623_00300713,
        64'h00a78223_0ff57513,
        64'h00e78023_00855513,
        64'h0ff57713_00e78623,
        64'hf8000713_00078223,
        64'h100007b7_02b55533,
        64'h00459593_00008067,
        64'h00a70023_fe078ce3,
        64'h0207f793_01474783,
        64'h10000737_00008067,
        64'h02057513_0147c503,
        64'h100007b7_00008067,
        64'h00054503_00008067,
        64'h00b50023_00008067,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00048067_800004b7,
        64'hf8858593_00001597,
        64'hf1402573_ff24c6e3,
        64'h40090913_02000937,
        64'h00448493_fe091ee3,
        64'h0004a903_00092023,
        64'h00990933_00291913,
        64'hf1402973_020004b7,
        64'hfe090ae3_00897913,
        64'h34402973_10500073,
        64'hff24c6e3_40090913,
        64'h02000937_00448493,
        64'h0124a023_00100913,
        64'h020004b7_685000ef,
        64'h84000137_03249463,
        64'hf1402973_00000493,
        64'h30491073_00800913
    };

    logic [$clog2(RomSize)-1:0] addr_q;

    always_ff @(posedge clk_i) begin
        if (req_i) begin
            addr_q <= addr_i[$clog2(RomSize)-1+3:3];
        end
    end

    // this prevents spurious Xes from propagating into
    // the speculative fetch stage of the core
    assign rdata_o = (addr_q < RomSize) ? mem[addr_q] : '0;
endmodule
