# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field
from empire_platform_api_public_client.models.border_direction_with_both_and_none import BorderDirectionWithBothAndNone
from empire_platform_api_public_client.models.timescale_nomination_options_window_timing import TimescaleNominationOptionsWindowTiming
from empire_platform_api_public_client.models.timescale_nomination_window_status import TimescaleNominationWindowStatus

class TimescaleNominationOptions(BaseModel):
    """
    TimescaleNominationOptions
    """
    window_timing: Optional[TimescaleNominationOptionsWindowTiming] = Field(None, alias="windowTiming")
    window_status: TimescaleNominationWindowStatus = Field(..., alias="windowStatus")
    rights_in_directions: BorderDirectionWithBothAndNone = Field(..., alias="rightsInDirections")
    __properties = ["windowTiming", "windowStatus", "rightsInDirections"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TimescaleNominationOptions:
        """Create an instance of TimescaleNominationOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of window_timing
        if self.window_timing:
            _dict['windowTiming'] = self.window_timing.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TimescaleNominationOptions:
        """Create an instance of TimescaleNominationOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TimescaleNominationOptions.parse_obj(obj)

        _obj = TimescaleNominationOptions.parse_obj({
            "window_timing": TimescaleNominationOptionsWindowTiming.from_dict(obj.get("windowTiming")) if obj.get("windowTiming") is not None else None,
            "window_status": obj.get("windowStatus"),
            "rights_in_directions": obj.get("rightsInDirections")
        })
        return _obj

