# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr
from empire_platform_api_public_client.models.organisation_auth_method import OrganisationAuthMethod

class ProfileUserOrganisation(BaseModel):
    """
    ProfileUserOrganisation
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    name: StrictStr = Field(...)
    auth_method: OrganisationAuthMethod = Field(..., alias="authMethod")
    __properties = ["id", "name", "authMethod"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProfileUserOrganisation:
        """Create an instance of ProfileUserOrganisation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProfileUserOrganisation:
        """Create an instance of ProfileUserOrganisation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProfileUserOrganisation.parse_obj(obj)

        _obj = ProfileUserOrganisation.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "auth_method": obj.get("authMethod")
        })
        return _obj

