# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from empire_platform_api_public_client.models.user_role import UserRole
from empire_platform_api_public_client.models.user_status import UserStatus

class OrganisationUser(BaseModel):
    """
    OrganisationUser
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    name: Optional[StrictStr] = None
    email: constr(strict=True) = Field(...)
    role: UserRole = Field(...)
    invited_at: datetime = Field(..., alias="invitedAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    last_login_at: Optional[datetime] = Field(None, alias="lastLoginAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    last_password_change_at: Optional[datetime] = Field(None, alias="lastPasswordChangeAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    status: UserStatus = Field(...)
    __properties = ["id", "name", "email", "role", "invitedAt", "lastLoginAt", "lastPasswordChangeAt", "status"]

    # @validator('email')
    def email_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[\w-\.]+@([\w-]+\.)+[\w-]{2,6}$", value):
            raise ValueError(r"must validate the regular expression /^[\w-\.]+@([\w-]+\.)+[\w-]{2,6}$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganisationUser:
        """Create an instance of OrganisationUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganisationUser:
        """Create an instance of OrganisationUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OrganisationUser.parse_obj(obj)

        _obj = OrganisationUser.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "email": obj.get("email"),
            "role": obj.get("role"),
            "invited_at": obj.get("invitedAt"),
            "last_login_at": obj.get("lastLoginAt"),
            "last_password_change_at": obj.get("lastPasswordChangeAt"),
            "status": obj.get("status")
        })
        return _obj

