# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from empire_platform_api_public_client.models.attachment import Attachment
from empire_platform_api_public_client.models.organisation_document_file_type import OrganisationDocumentFileType
from empire_platform_api_public_client.models.organisation_document_status import OrganisationDocumentStatus
from empire_platform_api_public_client.models.organisation_document_uploaded_by_user import OrganisationDocumentUploadedByUser

class OrganisationDocument(BaseModel):
    """
    OrganisationDocument
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    file_type: OrganisationDocumentFileType = Field(..., alias="fileType")
    description: StrictStr = Field(...)
    uploaded_at: datetime = Field(..., alias="uploadedAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    uploaded_by_user: OrganisationDocumentUploadedByUser = Field(..., alias="uploadedByUser")
    status: OrganisationDocumentStatus = Field(...)
    attachment: Optional[Attachment] = None
    __properties = ["id", "fileType", "description", "uploadedAt", "uploadedByUser", "status", "attachment"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganisationDocument:
        """Create an instance of OrganisationDocument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of uploaded_by_user
        if self.uploaded_by_user:
            _dict['uploadedByUser'] = self.uploaded_by_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of attachment
        if self.attachment:
            _dict['attachment'] = self.attachment.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganisationDocument:
        """Create an instance of OrganisationDocument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OrganisationDocument.parse_obj(obj)

        _obj = OrganisationDocument.parse_obj({
            "id": obj.get("id"),
            "file_type": obj.get("fileType"),
            "description": obj.get("description"),
            "uploaded_at": obj.get("uploadedAt"),
            "uploaded_by_user": OrganisationDocumentUploadedByUser.from_dict(obj.get("uploadedByUser")) if obj.get("uploadedByUser") is not None else None,
            "status": obj.get("status"),
            "attachment": Attachment.from_dict(obj.get("attachment")) if obj.get("attachment") is not None else None
        })
        return _obj

