# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Union
from pydantic import BaseModel, Field, confloat, conint
from empire_platform_api_public_client.models.border_direction import BorderDirection

class InvoiceVatRate(BaseModel):
    """
    Participant basic information
    """
    direction: BorderDirection = Field(...)
    vat_rate: Union[confloat(le=100, ge=0, multiple_of=0.01, strict=True), conint(le=100, ge=0, strict=True)] = Field(..., alias="vatRate", description="Percentage values, accepted with a precision of maximum 2 decimal places")
    __properties = ["direction", "vatRate"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InvoiceVatRate:
        """Create an instance of InvoiceVatRate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InvoiceVatRate:
        """Create an instance of InvoiceVatRate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InvoiceVatRate.parse_obj(obj)

        _obj = InvoiceVatRate.parse_obj({
            "direction": obj.get("direction"),
            "vat_rate": obj.get("vatRate")
        })
        return _obj

