# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr, constr, validator

class AuctionResultParticipant(BaseModel):
    """
    AuctionResultParticipant
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    name: StrictStr = Field(...)
    eic_code: constr(strict=True) = Field(..., alias="eicCode")
    __properties = ["id", "name", "eicCode"]

    # @validator('eic_code')
    def eic_code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([0-9]|[A-Z]|-){16}$", value):
            raise ValueError(r"must validate the regular expression /^([0-9]|[A-Z]|-){16}$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AuctionResultParticipant:
        """Create an instance of AuctionResultParticipant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AuctionResultParticipant:
        """Create an instance of AuctionResultParticipant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AuctionResultParticipant.parse_obj(obj)

        _obj = AuctionResultParticipant.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "eic_code": obj.get("eicCode")
        })
        return _obj

