# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictBool, StrictStr, conint, conlist

from typing import Optional

from empire_platform_api_public_client.models.message_batch import MessageBatch
from empire_platform_api_public_client.models.message_sender import MessageSender
from empire_platform_api_public_client.models.message_severity import MessageSeverity
from empire_platform_api_public_client.models.message_sort_by import MessageSortBy
from empire_platform_api_public_client.models.message_type import MessageType
from empire_platform_api_public_client.models.system_message_category import SystemMessageCategory
from empire_platform_api_public_client.models.unread_messages_response import UnreadMessagesResponse

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MessagesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_participant_messages(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[MessageSortBy, Field(..., description="Sort list by given attribute and direction")], severities : conlist(MessageSeverity), senders : conlist(MessageSender), types : conlist(MessageType), received_from : Optional[datetime] = None, received_to : Optional[datetime] = None, search_query : Optional[StrictStr] = None, has_attachment : Optional[StrictBool] = None, **kwargs) -> MessageBatch:  # noqa: E501
        """get_participant_messages  # noqa: E501

        Fetch Messages sent for the current Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_MESSAGES`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_messages(limit, offset, sort_by, severities, senders, types, received_from, received_to, search_query, has_attachment, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: MessageSortBy
        :param severities: (required)
        :type severities: List[MessageSeverity]
        :param senders: (required)
        :type senders: List[MessageSender]
        :param types: (required)
        :type types: List[MessageType]
        :param received_from:
        :type received_from: datetime
        :param received_to:
        :type received_to: datetime
        :param search_query:
        :type search_query: str
        :param has_attachment:
        :type has_attachment: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_participant_messages_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_participant_messages_with_http_info(limit, offset, sort_by, severities, senders, types, received_from, received_to, search_query, has_attachment, **kwargs)  # noqa: E501

    @validate_arguments
    def get_participant_messages_with_http_info(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[MessageSortBy, Field(..., description="Sort list by given attribute and direction")], severities : conlist(MessageSeverity), senders : conlist(MessageSender), types : conlist(MessageType), received_from : Optional[datetime] = None, received_to : Optional[datetime] = None, search_query : Optional[StrictStr] = None, has_attachment : Optional[StrictBool] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_participant_messages  # noqa: E501

        Fetch Messages sent for the current Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_MESSAGES`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_messages_with_http_info(limit, offset, sort_by, severities, senders, types, received_from, received_to, search_query, has_attachment, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: MessageSortBy
        :param severities: (required)
        :type severities: List[MessageSeverity]
        :param senders: (required)
        :type senders: List[MessageSender]
        :param types: (required)
        :type types: List[MessageType]
        :param received_from:
        :type received_from: datetime
        :param received_to:
        :type received_to: datetime
        :param search_query:
        :type search_query: str
        :param has_attachment:
        :type has_attachment: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'sort_by',
            'severities',
            'senders',
            'types',
            'received_from',
            'received_to',
            'search_query',
            'has_attachment'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_participant_messages" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by'].value))

        if _params.get('severities') is not None:  # noqa: E501
            _query_params.append(('severities', _params['severities']))
            _collection_formats['severities'] = 'multi'

        if _params.get('senders') is not None:  # noqa: E501
            _query_params.append(('senders', _params['senders']))
            _collection_formats['senders'] = 'multi'

        if _params.get('types') is not None:  # noqa: E501
            _query_params.append(('types', _params['types']))
            _collection_formats['types'] = 'multi'

        if _params.get('received_from') is not None:  # noqa: E501
            if isinstance(_params['received_from'], datetime):
                _query_params.append(('receivedFrom', _params['received_from'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('receivedFrom', _params['received_from']))

        if _params.get('received_to') is not None:  # noqa: E501
            if isinstance(_params['received_to'], datetime):
                _query_params.append(('receivedTo', _params['received_to'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('receivedTo', _params['received_to']))

        if _params.get('search_query') is not None:  # noqa: E501
            _query_params.append(('searchQuery', _params['search_query']))

        if _params.get('has_attachment') is not None:  # noqa: E501
            _query_params.append(('hasAttachment', _params['has_attachment']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "MessageBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/messages/participant', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_participant_unread_messages(self, **kwargs) -> UnreadMessagesResponse:  # noqa: E501
        """get_participant_unread_messages  # noqa: E501

        Fetch the number of \"unread\" Messages sent for the current Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_MESSAGES`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_unread_messages(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UnreadMessagesResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_participant_unread_messages_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_participant_unread_messages_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_participant_unread_messages_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_participant_unread_messages  # noqa: E501

        Fetch the number of \"unread\" Messages sent for the current Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_MESSAGES`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_unread_messages_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UnreadMessagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_participant_unread_messages" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "UnreadMessagesResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/messages/participant/unread', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_system_messages(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[MessageSortBy, Field(..., description="Sort list by given attribute and direction")], category : SystemMessageCategory, severities : conlist(MessageSeverity), senders : conlist(MessageSender), types : conlist(MessageType), received_from : Optional[datetime] = None, received_to : Optional[datetime] = None, search_query : Optional[StrictStr] = None, has_attachment : Optional[StrictBool] = None, **kwargs) -> MessageBatch:  # noqa: E501
        """get_system_messages  # noqa: E501

        Fetch General and Operational System Messages  ---  __Requires Permission:__ (at least one)   * `VIEW_GENERAL_SYSTEM_MESSAGES`   * `VIEW_OPERATIONAL_SYSTEM_MESSAGES`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_system_messages(limit, offset, sort_by, category, severities, senders, types, received_from, received_to, search_query, has_attachment, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: MessageSortBy
        :param category: (required)
        :type category: SystemMessageCategory
        :param severities: (required)
        :type severities: List[MessageSeverity]
        :param senders: (required)
        :type senders: List[MessageSender]
        :param types: (required)
        :type types: List[MessageType]
        :param received_from:
        :type received_from: datetime
        :param received_to:
        :type received_to: datetime
        :param search_query:
        :type search_query: str
        :param has_attachment:
        :type has_attachment: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_system_messages_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_system_messages_with_http_info(limit, offset, sort_by, category, severities, senders, types, received_from, received_to, search_query, has_attachment, **kwargs)  # noqa: E501

    @validate_arguments
    def get_system_messages_with_http_info(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[MessageSortBy, Field(..., description="Sort list by given attribute and direction")], category : SystemMessageCategory, severities : conlist(MessageSeverity), senders : conlist(MessageSender), types : conlist(MessageType), received_from : Optional[datetime] = None, received_to : Optional[datetime] = None, search_query : Optional[StrictStr] = None, has_attachment : Optional[StrictBool] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_system_messages  # noqa: E501

        Fetch General and Operational System Messages  ---  __Requires Permission:__ (at least one)   * `VIEW_GENERAL_SYSTEM_MESSAGES`   * `VIEW_OPERATIONAL_SYSTEM_MESSAGES`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_system_messages_with_http_info(limit, offset, sort_by, category, severities, senders, types, received_from, received_to, search_query, has_attachment, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: MessageSortBy
        :param category: (required)
        :type category: SystemMessageCategory
        :param severities: (required)
        :type severities: List[MessageSeverity]
        :param senders: (required)
        :type senders: List[MessageSender]
        :param types: (required)
        :type types: List[MessageType]
        :param received_from:
        :type received_from: datetime
        :param received_to:
        :type received_to: datetime
        :param search_query:
        :type search_query: str
        :param has_attachment:
        :type has_attachment: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'sort_by',
            'category',
            'severities',
            'senders',
            'types',
            'received_from',
            'received_to',
            'search_query',
            'has_attachment'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_system_messages" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by'].value))

        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category'].value))

        if _params.get('severities') is not None:  # noqa: E501
            _query_params.append(('severities', _params['severities']))
            _collection_formats['severities'] = 'multi'

        if _params.get('senders') is not None:  # noqa: E501
            _query_params.append(('senders', _params['senders']))
            _collection_formats['senders'] = 'multi'

        if _params.get('types') is not None:  # noqa: E501
            _query_params.append(('types', _params['types']))
            _collection_formats['types'] = 'multi'

        if _params.get('received_from') is not None:  # noqa: E501
            if isinstance(_params['received_from'], datetime):
                _query_params.append(('receivedFrom', _params['received_from'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('receivedFrom', _params['received_from']))

        if _params.get('received_to') is not None:  # noqa: E501
            if isinstance(_params['received_to'], datetime):
                _query_params.append(('receivedTo', _params['received_to'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('receivedTo', _params['received_to']))

        if _params.get('search_query') is not None:  # noqa: E501
            _query_params.append(('searchQuery', _params['search_query']))

        if _params.get('has_attachment') is not None:  # noqa: E501
            _query_params.append(('hasAttachment', _params['has_attachment']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "MessageBatch",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/messages/system', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
