# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictStr, conint, conlist

from typing import Optional

from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.border_direction_with_both import BorderDirectionWithBoth
from empire_platform_api_public_client.models.create_day_ahead_or_intra_day_default_bid_request import CreateDayAheadOrIntraDayDefaultBidRequest
from empire_platform_api_public_client.models.create_long_term_default_bid_request import CreateLongTermDefaultBidRequest
from empire_platform_api_public_client.models.created_default_bid import CreatedDefaultBid
from empire_platform_api_public_client.models.day_ahead_or_intra_day_default_bid import DayAheadOrIntraDayDefaultBid
from empire_platform_api_public_client.models.default_bid_batch import DefaultBidBatch
from empire_platform_api_public_client.models.default_bid_options import DefaultBidOptions
from empire_platform_api_public_client.models.default_bid_sort_by import DefaultBidSortBy
from empire_platform_api_public_client.models.long_term_default_bid import LongTermDefaultBid
from empire_platform_api_public_client.models.update_day_ahead_or_intra_day_default_bid_request import UpdateDayAheadOrIntraDayDefaultBidRequest
from empire_platform_api_public_client.models.update_long_term_default_bid_request import UpdateLongTermDefaultBidRequest

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DefaultBidApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_day_ahead_or_intra_day_default_bid(self, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], create_day_ahead_or_intra_day_default_bid_request : CreateDayAheadOrIntraDayDefaultBidRequest, **kwargs) -> CreatedDefaultBid:  # noqa: E501
        """create_day_ahead_or_intra_day_default_bid  # noqa: E501

        Create new Default Bid for Day Ahead or Intra Day product types  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `CREATE_DAY_AHEAD_OR_INTRA_DAY_DEFAULT_BID`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_day_ahead_or_intra_day_default_bid(x_participant_id, create_day_ahead_or_intra_day_default_bid_request, async_req=True)
        >>> result = thread.get()

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param create_day_ahead_or_intra_day_default_bid_request: (required)
        :type create_day_ahead_or_intra_day_default_bid_request: CreateDayAheadOrIntraDayDefaultBidRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatedDefaultBid
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_day_ahead_or_intra_day_default_bid_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_day_ahead_or_intra_day_default_bid_with_http_info(x_participant_id, create_day_ahead_or_intra_day_default_bid_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_day_ahead_or_intra_day_default_bid_with_http_info(self, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], create_day_ahead_or_intra_day_default_bid_request : CreateDayAheadOrIntraDayDefaultBidRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """create_day_ahead_or_intra_day_default_bid  # noqa: E501

        Create new Default Bid for Day Ahead or Intra Day product types  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `CREATE_DAY_AHEAD_OR_INTRA_DAY_DEFAULT_BID`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_day_ahead_or_intra_day_default_bid_with_http_info(x_participant_id, create_day_ahead_or_intra_day_default_bid_request, async_req=True)
        >>> result = thread.get()

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param create_day_ahead_or_intra_day_default_bid_request: (required)
        :type create_day_ahead_or_intra_day_default_bid_request: CreateDayAheadOrIntraDayDefaultBidRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatedDefaultBid, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_participant_id',
            'create_day_ahead_or_intra_day_default_bid_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_day_ahead_or_intra_day_default_bid" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_day_ahead_or_intra_day_default_bid_request'] is not None:
            _body_params = _params['create_day_ahead_or_intra_day_default_bid_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '201': "CreatedDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/default-bids/day-ahead-or-intra-day', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_long_term_default_bid(self, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], create_long_term_default_bid_request : CreateLongTermDefaultBidRequest, **kwargs) -> CreatedDefaultBid:  # noqa: E501
        """create_long_term_default_bid  # noqa: E501

        Create new Default Bid for Long Term product types  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `CREATE_LONG_TERM_DEFAULT_BID`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_long_term_default_bid(x_participant_id, create_long_term_default_bid_request, async_req=True)
        >>> result = thread.get()

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param create_long_term_default_bid_request: (required)
        :type create_long_term_default_bid_request: CreateLongTermDefaultBidRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatedDefaultBid
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_long_term_default_bid_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_long_term_default_bid_with_http_info(x_participant_id, create_long_term_default_bid_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_long_term_default_bid_with_http_info(self, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], create_long_term_default_bid_request : CreateLongTermDefaultBidRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """create_long_term_default_bid  # noqa: E501

        Create new Default Bid for Long Term product types  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `CREATE_LONG_TERM_DEFAULT_BID`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_long_term_default_bid_with_http_info(x_participant_id, create_long_term_default_bid_request, async_req=True)
        >>> result = thread.get()

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param create_long_term_default_bid_request: (required)
        :type create_long_term_default_bid_request: CreateLongTermDefaultBidRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatedDefaultBid, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_participant_id',
            'create_long_term_default_bid_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_long_term_default_bid" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_long_term_default_bid_request'] is not None:
            _body_params = _params['create_long_term_default_bid_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '201': "CreatedDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/default-bids/long-term', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_default_bid(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> None:  # noqa: E501
        """delete_default_bid  # noqa: E501

        Delete an existing Default Bid  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `DELETE_DEFAULT_BID`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_default_bid(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_default_bid_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_default_bid_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_default_bid_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """delete_default_bid  # noqa: E501

        Delete an existing Default Bid  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `DELETE_DEFAULT_BID`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_default_bid_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_default_bid" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/default-bids/{id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_day_ahead_or_intra_day_default_bid(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> DayAheadOrIntraDayDefaultBid:  # noqa: E501
        """get_day_ahead_or_intra_day_default_bid  # noqa: E501

        Fetch a Day Ahead or Intra Day Default Bid by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_default_bid(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DayAheadOrIntraDayDefaultBid
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_day_ahead_or_intra_day_default_bid_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_day_ahead_or_intra_day_default_bid_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_day_ahead_or_intra_day_default_bid_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_day_ahead_or_intra_day_default_bid  # noqa: E501

        Fetch a Day Ahead or Intra Day Default Bid by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_default_bid_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DayAheadOrIntraDayDefaultBid, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_day_ahead_or_intra_day_default_bid" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "DayAheadOrIntraDayDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/default-bids/day-ahead-or-intra-day/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_default_bid_options(self, **kwargs) -> DefaultBidOptions:  # noqa: E501
        """get_default_bid_options  # noqa: E501

        Fetch options for creating and all kinds of Default Bids  Returns allocation MTU size configuration for Auction Product Types  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `MANAGE_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_default_bid_options(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DefaultBidOptions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_default_bid_options_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_default_bid_options_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_default_bid_options_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_default_bid_options  # noqa: E501

        Fetch options for creating and all kinds of Default Bids  Returns allocation MTU size configuration for Auction Product Types  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `MANAGE_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_default_bid_options_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DefaultBidOptions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_default_bid_options" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "DefaultBidOptions",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/default-bids/options', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_default_bids(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[DefaultBidSortBy, Field(..., description="Sort list by given attribute and direction")], x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], product_types : Annotated[conlist(AuctionProductType), Field(..., description="List of Auction Product Types")], border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], delivery_period_start : Annotated[datetime, Field(..., description="Filter for start of delivery period (aligned to MTUs)")], delivery_period_end : Annotated[datetime, Field(..., description="Filter for end of delivery period (aligned to MTUs)")], validity_period_start : Annotated[Optional[datetime], Field(description="Filter for start of validity period (optional)")] = None, validity_period_end : Annotated[Optional[datetime], Field(description="Filter for end of validity period (optional)")] = None, **kwargs) -> DefaultBidBatch:  # noqa: E501
        """get_default_bids  # noqa: E501

        Fetch Default Bids for a given Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_default_bids(limit, offset, sort_by, x_participant_id, product_types, border_direction, delivery_period_start, delivery_period_end, validity_period_start, validity_period_end, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: DefaultBidSortBy
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: Filter for start of delivery period (aligned to MTUs) (required)
        :type delivery_period_start: datetime
        :param delivery_period_end: Filter for end of delivery period (aligned to MTUs) (required)
        :type delivery_period_end: datetime
        :param validity_period_start: Filter for start of validity period (optional)
        :type validity_period_start: datetime
        :param validity_period_end: Filter for end of validity period (optional)
        :type validity_period_end: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DefaultBidBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_default_bids_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_default_bids_with_http_info(limit, offset, sort_by, x_participant_id, product_types, border_direction, delivery_period_start, delivery_period_end, validity_period_start, validity_period_end, **kwargs)  # noqa: E501

    @validate_arguments
    def get_default_bids_with_http_info(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[DefaultBidSortBy, Field(..., description="Sort list by given attribute and direction")], x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], product_types : Annotated[conlist(AuctionProductType), Field(..., description="List of Auction Product Types")], border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], delivery_period_start : Annotated[datetime, Field(..., description="Filter for start of delivery period (aligned to MTUs)")], delivery_period_end : Annotated[datetime, Field(..., description="Filter for end of delivery period (aligned to MTUs)")], validity_period_start : Annotated[Optional[datetime], Field(description="Filter for start of validity period (optional)")] = None, validity_period_end : Annotated[Optional[datetime], Field(description="Filter for end of validity period (optional)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_default_bids  # noqa: E501

        Fetch Default Bids for a given Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_default_bids_with_http_info(limit, offset, sort_by, x_participant_id, product_types, border_direction, delivery_period_start, delivery_period_end, validity_period_start, validity_period_end, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: DefaultBidSortBy
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: Filter for start of delivery period (aligned to MTUs) (required)
        :type delivery_period_start: datetime
        :param delivery_period_end: Filter for end of delivery period (aligned to MTUs) (required)
        :type delivery_period_end: datetime
        :param validity_period_start: Filter for start of validity period (optional)
        :type validity_period_start: datetime
        :param validity_period_end: Filter for end of validity period (optional)
        :type validity_period_end: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DefaultBidBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'sort_by',
            'x_participant_id',
            'product_types',
            'border_direction',
            'delivery_period_start',
            'delivery_period_end',
            'validity_period_start',
            'validity_period_end'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_default_bids" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by'].value))

        if _params.get('product_types') is not None:  # noqa: E501
            _query_params.append(('productTypes', _params['product_types']))
            _collection_formats['productTypes'] = 'multi'

        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('delivery_period_start') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_start'], datetime):
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start']))

        if _params.get('delivery_period_end') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_end'], datetime):
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end']))

        if _params.get('validity_period_start') is not None:  # noqa: E501
            if isinstance(_params['validity_period_start'], datetime):
                _query_params.append(('validityPeriodStart', _params['validity_period_start'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('validityPeriodStart', _params['validity_period_start']))

        if _params.get('validity_period_end') is not None:  # noqa: E501
            if isinstance(_params['validity_period_end'], datetime):
                _query_params.append(('validityPeriodEnd', _params['validity_period_end'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('validityPeriodEnd', _params['validity_period_end']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "DefaultBidBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/default-bids', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_long_term_default_bid(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> LongTermDefaultBid:  # noqa: E501
        """get_long_term_default_bid  # noqa: E501

        Fetch a Long Term Default Bid by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_default_bid(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LongTermDefaultBid
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_long_term_default_bid_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_long_term_default_bid_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_long_term_default_bid_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_long_term_default_bid  # noqa: E501

        Fetch a Long Term Default Bid by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_default_bid_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LongTermDefaultBid, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_long_term_default_bid" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "LongTermDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/default-bids/long-term/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_day_ahead_or_intra_day_default_bid(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], update_day_ahead_or_intra_day_default_bid_request : UpdateDayAheadOrIntraDayDefaultBidRequest, **kwargs) -> None:  # noqa: E501
        """update_day_ahead_or_intra_day_default_bid  # noqa: E501

        Update a Day Ahead or Intra Day Default Bid by its identifier  Re-creates any existing default bid values  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `UPDATE_DAY_AHEAD_OR_INTRA_DAY_DEFAULT_BID`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_day_ahead_or_intra_day_default_bid(id, update_day_ahead_or_intra_day_default_bid_request, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param update_day_ahead_or_intra_day_default_bid_request: (required)
        :type update_day_ahead_or_intra_day_default_bid_request: UpdateDayAheadOrIntraDayDefaultBidRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_day_ahead_or_intra_day_default_bid_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_day_ahead_or_intra_day_default_bid_with_http_info(id, update_day_ahead_or_intra_day_default_bid_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_day_ahead_or_intra_day_default_bid_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], update_day_ahead_or_intra_day_default_bid_request : UpdateDayAheadOrIntraDayDefaultBidRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """update_day_ahead_or_intra_day_default_bid  # noqa: E501

        Update a Day Ahead or Intra Day Default Bid by its identifier  Re-creates any existing default bid values  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `UPDATE_DAY_AHEAD_OR_INTRA_DAY_DEFAULT_BID`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_day_ahead_or_intra_day_default_bid_with_http_info(id, update_day_ahead_or_intra_day_default_bid_request, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param update_day_ahead_or_intra_day_default_bid_request: (required)
        :type update_day_ahead_or_intra_day_default_bid_request: UpdateDayAheadOrIntraDayDefaultBidRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id',
            'update_day_ahead_or_intra_day_default_bid_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_day_ahead_or_intra_day_default_bid" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_day_ahead_or_intra_day_default_bid_request'] is not None:
            _body_params = _params['update_day_ahead_or_intra_day_default_bid_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/default-bids/day-ahead-or-intra-day/{id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_long_term_default_bid(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], update_long_term_default_bid_request : UpdateLongTermDefaultBidRequest, **kwargs) -> None:  # noqa: E501
        """update_long_term_default_bid  # noqa: E501

        Updat a Long Term Default Bid by its identifier  Re-creates any existing default bid values  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `UPDATE_LONG_TERM_DEFAULT_BID`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_long_term_default_bid(id, update_long_term_default_bid_request, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param update_long_term_default_bid_request: (required)
        :type update_long_term_default_bid_request: UpdateLongTermDefaultBidRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_long_term_default_bid_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_long_term_default_bid_with_http_info(id, update_long_term_default_bid_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_long_term_default_bid_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], update_long_term_default_bid_request : UpdateLongTermDefaultBidRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """update_long_term_default_bid  # noqa: E501

        Updat a Long Term Default Bid by its identifier  Re-creates any existing default bid values  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `UPDATE_LONG_TERM_DEFAULT_BID`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_long_term_default_bid_with_http_info(id, update_long_term_default_bid_request, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param update_long_term_default_bid_request: (required)
        :type update_long_term_default_bid_request: UpdateLongTermDefaultBidRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id',
            'update_long_term_default_bid_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_long_term_default_bid" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_long_term_default_bid_request'] is not None:
            _body_params = _params['update_long_term_default_bid_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/default-bids/long-term/{id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
