# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api)   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import StrictBytes, StrictStr

from typing import Union

from empire_platform_api_public_client.models.attachment import Attachment

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AttachmentApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def upload_attachment(self, file_name : StrictStr, file : Union[StrictBytes, StrictStr], **kwargs) -> Attachment:  # noqa: E501
        """upload_attachment  # noqa: E501

        Upload a single Attachment (file)  On successful upload the file gets persisted and metadata for the Attachment is returned. The Attachment can be referenced by its identifier in other functions (e.g Organisation Documents)  **File size limit:** 50 MB  **File types accepted:**   * images:     - .jpg  | image/jpeg     - .png  | image/png   * documents:     - .doc  | application/msword     - .docx | application/vnd.openxmlformats-officedocument.wordprocessingml.document     - .xls  | application/vnd.ms-excel     - .xlsx | application/vnd.openxmlformats-officedocument.spreadsheetml.sheet     - .ppt  | application/vnd.ms-powerpoint     - .pptx | application/vnd.openxmlformats-officedocument.presentationml.presentation     - .pdf  | application/pdf   * text files:     - .txt  | text/plain     - .xml  | application/xml     - .json | application/json   * archives:     - .zip  | application/zip     - .rar  | application/vnd.rar  ---  __Requires Permission:__ (at least one)   * `MANAGE_CRISIS_ACTIONS`   * `INVITE_USERS`   * `MANAGE_OWN_MANUAL_FILE_UPLOAD_BIDS`   * `MANAGE_OWN_MANUAL_FILE_UPLOAD_NOMINATIONS`   * `MANAGE_ANY_MANUAL_FILE_UPLOAD`   * `MANAGE_ANY_ORGANISATION_DOCUMENTS`   * `MANAGE_OWN_ORGANISATION_DOCUMENTS`  __Generates Audit Log Entry:__ `UPLOAD_ATTACHMENT`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_attachment(file_name, file, async_req=True)
        >>> result = thread.get()

        :param file_name: (required)
        :type file_name: str
        :param file: (required)
        :type file: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Attachment
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the upload_attachment_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.upload_attachment_with_http_info(file_name, file, **kwargs)  # noqa: E501

    @validate_arguments
    def upload_attachment_with_http_info(self, file_name : StrictStr, file : Union[StrictBytes, StrictStr], **kwargs) -> ApiResponse:  # noqa: E501
        """upload_attachment  # noqa: E501

        Upload a single Attachment (file)  On successful upload the file gets persisted and metadata for the Attachment is returned. The Attachment can be referenced by its identifier in other functions (e.g Organisation Documents)  **File size limit:** 50 MB  **File types accepted:**   * images:     - .jpg  | image/jpeg     - .png  | image/png   * documents:     - .doc  | application/msword     - .docx | application/vnd.openxmlformats-officedocument.wordprocessingml.document     - .xls  | application/vnd.ms-excel     - .xlsx | application/vnd.openxmlformats-officedocument.spreadsheetml.sheet     - .ppt  | application/vnd.ms-powerpoint     - .pptx | application/vnd.openxmlformats-officedocument.presentationml.presentation     - .pdf  | application/pdf   * text files:     - .txt  | text/plain     - .xml  | application/xml     - .json | application/json   * archives:     - .zip  | application/zip     - .rar  | application/vnd.rar  ---  __Requires Permission:__ (at least one)   * `MANAGE_CRISIS_ACTIONS`   * `INVITE_USERS`   * `MANAGE_OWN_MANUAL_FILE_UPLOAD_BIDS`   * `MANAGE_OWN_MANUAL_FILE_UPLOAD_NOMINATIONS`   * `MANAGE_ANY_MANUAL_FILE_UPLOAD`   * `MANAGE_ANY_ORGANISATION_DOCUMENTS`   * `MANAGE_OWN_ORGANISATION_DOCUMENTS`  __Generates Audit Log Entry:__ `UPLOAD_ATTACHMENT`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_attachment_with_http_info(file_name, file, async_req=True)
        >>> result = thread.get()

        :param file_name: (required)
        :type file_name: str
        :param file: (required)
        :type file: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Attachment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'file_name',
            'file'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_attachment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['file_name']:
            _form_params.append(('fileName', _params['file_name']))

        if _params['file']:
            _files['file'] = _params['file']

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '201': "Attachment",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '413': None,
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/attachments', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
