Django Admin Search
===================

this project implement a search modal in django admin to filter your queryset.

Obs: this project works only in django admin

# Images:

Button in admin list:
    ![input](https://user-images.githubusercontent.com/30196992/59556917-19182f00-8fa2-11e9-9d9a-955d73d79d11.png)

Modal opened:
    ![modal](https://user-images.githubusercontent.com/30196992/59556920-29c8a500-8fa2-11e9-8677-0f340762e64a.png)

# Install:
    pip install django-admin-search

# Usage:

1. Add to your INSTALLED_APPS, in settings.py:
    ```
    INSTALLED_APPS = [  
        ...
        'django_admin_search',
        ...
    ]
    ```

2. Create a search form for model:
    ```
    from .models import Area
    from django.forms import ModelForm, Form
    from django.forms import DateField, CharField, ChoiceField, TextInput


    class YourFormSearch(Form):
        name = CharField(required=False)
        date = DateField(required=False, widget=TextInput(
            attrs={ 
                'filter_method': '__gte',
            }
        ))
    ```

3. In your admin:
    ```
    from django_admin_search.admin import AdvacedSearchAdmin
    from .models import YourModel
    from .form import YourForm, YourFormSearch

    @register(YourModel)
    class YourAdmin(AdvacedSearchAdmin):
        form = YourForm
        search_form = YourFormSearch
    ```

# Advanced:
1. to multiple filters in same field:
    ```
    class YourFormSearch(Form):
        ...
        name = CharField(required=False)
        begin = DateField(required=False, widget=TextInput(
            attrs={
                'filter_field': 'date', 
                'filter_method': '__gte',
            }
        ))
        end = DateField(required=False, widget=TextInput(
            attrs={
                'filter_field': 'date', 
                'filter_method': '__lte',
            }
        ))
    ```

2. add placeholder and mask
    ```
    class YourFormSearch(Form):
        ...
        date = DateField(required=False, widget=TextInput(
            attrs={
                'data-mask': "00/00/0000", 
                'placeholder': 'MM/DD/YYYY'
            }
        ))
    ```

3. Custom filter query for a field
    ```
    from django_admin_search.admin import AdvacedSearchAdmin
    from .models import YourModel
    from .form import YourForm, YourFormSearch

    @register(YourModel)
    class YourAdmin(AdvacedSearchAdmin):
        def search_FieldNameHere(request, field_value, param_values):
            """
                intercept query filter for description field
            """
            query = Q()
            # your Q logic here
            return query
    ```