<a id="mypy-boto3-dynamodb"></a>

# mypy-boto3-dynamodb

[![PyPI - mypy-boto3-dynamodb](https://img.shields.io/pypi/v/mypy-boto3-dynamodb.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-dynamodb.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-dynamodb?color=blue)](https://pypistats.org/packages/mypy-boto3-dynamodb)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.DynamoDB 1.18.63](https://boto3.amazonaws.com/v1/documentation/api/1.18.63/reference/services/dynamodb.html#DynamoDB)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.5.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-dynamodb docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_dynamodb/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-dynamodb](#mypy-boto3-dynamodb)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `DynamoDB` service.

```bash
python -m pip install boto3-stubs[dynamodb]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[dynamodb]` in your environment:
  `python -m pip install 'boto3-stubs[dynamodb]'`

Both type checking and auto-complete should work for `DynamoDB` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[dynamodb]` in your environment:
  `python -m pip install 'boto3-stubs[dynamodb]'`

Both type checking and auto-complete should work for `DynamoDB` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[dynamodb]` in your environment:
  `python -m pip install 'boto3-stubs[dynamodb]'`
- Run `mypy` as usual

Type checking should work for `DynamoDB` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[dynamodb]` in your environment:
  `python -m pip install 'boto3-stubs[dynamodb]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `DynamoDB` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`DynamoDBClient` provides annotations for `boto3.client("dynamodb")`.

```python
import boto3

from mypy_boto3_dynamodb import DynamoDBClient

client: DynamoDBClient = boto3.client("dynamodb")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DynamoDBClient = session.client("dynamodb")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_dynamodb.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_dynamodb import DynamoDBClient
from mypy_boto3_dynamodb.paginator import (
    ListBackupsPaginator,
    ListTablesPaginator,
    ListTagsOfResourcePaginator,
    QueryPaginator,
    ScanPaginator,
)

client: DynamoDBClient = boto3.client("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_backups_paginator: ListBackupsPaginator = client.get_paginator("list_backups")
list_tables_paginator: ListTablesPaginator = client.get_paginator("list_tables")
list_tags_of_resource_paginator: ListTagsOfResourcePaginator = client.get_paginator("list_tags_of_resource")
query_paginator: QueryPaginator = client.get_paginator("query")
scan_paginator: ScanPaginator = client.get_paginator("scan")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_dynamodb.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_dynamodb import DynamoDBClient
from mypy_boto3_dynamodb.waiter import (
    TableExistsWaiter,
    TableNotExistsWaiter,
)

client: DynamoDBClient = boto3.client("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
table_exists_waiter: TableExistsWaiter = client.get_waiter("table_exists")
table_not_exists_waiter: TableNotExistsWaiter = client.get_waiter("table_not_exists")
```

<a id="service-resource-annotations"></a>

### Service Resource annotations

`DynamoDBServiceResource` provides annotations for
`boto3.resource("dynamodb")`.

```python
from mypy_boto3_dynamodb import DynamoDBServiceResource

resource: DynamoDBServiceResource = boto3.resource("dynamodb")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: DynamoDBServiceResource = session.resource("dynamodb")
```

<a id="other-resources-annotations"></a>

### Other resources annotations

`mypy_boto3_dynamodb.service_resource` module contains type annotations for all
resources.

```python
from mypy_boto3_dynamodb import DynamoDBServiceResource
from mypy_boto3_dynamodb.service_resource import (
    Table,
)

resource: DynamoDBServiceResource = boto3.resource("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_table: Table = resource.Table(...)
```

<a id="collections-annotations"></a>

### Collections annotations

`mypy_boto3_dynamodb.service_resource` module contains type annotations for all
`DynamoDBServiceResource` collections.

```python
from mypy_boto3_dynamodb import DynamoDBServiceResource
from mypy_boto3_dynamodb.service_resource import (
    ServiceResourceTablesCollection,
)

resource: DynamoDBServiceResource = boto3.resource("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
tables: dynamodb_resources.ServiceResourceTablesCollection = resource.tables
```

<a id="literals"></a>

### Literals

`mypy_boto3_dynamodb.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_dynamodb.literals import (
    AttributeActionType,
    BackupStatusType,
    BackupTypeFilterType,
    BackupTypeType,
    BatchStatementErrorCodeEnumType,
    BillingModeType,
    ComparisonOperatorType,
    ConditionalOperatorType,
    ContinuousBackupsStatusType,
    ContributorInsightsActionType,
    ContributorInsightsStatusType,
    DestinationStatusType,
    ExportFormatType,
    ExportStatusType,
    GlobalTableStatusType,
    IndexStatusType,
    KeyTypeType,
    ListBackupsPaginatorName,
    ListTablesPaginatorName,
    ListTagsOfResourcePaginatorName,
    PointInTimeRecoveryStatusType,
    ProjectionTypeType,
    QueryPaginatorName,
    ReplicaStatusType,
    ReturnConsumedCapacityType,
    ReturnItemCollectionMetricsType,
    ReturnValueType,
    ReturnValuesOnConditionCheckFailureType,
    S3SseAlgorithmType,
    SSEStatusType,
    SSETypeType,
    ScalarAttributeTypeType,
    ScanPaginatorName,
    SelectType,
    StreamViewTypeType,
    TableExistsWaiterName,
    TableNotExistsWaiterName,
    TableStatusType,
    TimeToLiveStatusType,
    ServiceName,
    PaginatorName,
    WaiterName,
)

def check_value(value: AttributeActionType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_dynamodb.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_dynamodb.type_defs import (
    ArchivalSummaryTypeDef,
    AttributeDefinitionTypeDef,
    AttributeValueUpdateTypeDef,
    AutoScalingPolicyDescriptionTypeDef,
    AutoScalingPolicyUpdateTypeDef,
    AutoScalingSettingsDescriptionTypeDef,
    AutoScalingSettingsUpdateTypeDef,
    AutoScalingTargetTrackingScalingPolicyConfigurationDescriptionTypeDef,
    AutoScalingTargetTrackingScalingPolicyConfigurationUpdateTypeDef,
    BackupDescriptionTypeDef,
    BackupDetailsTypeDef,
    BackupSummaryTypeDef,
    BatchExecuteStatementInputRequestTypeDef,
    BatchExecuteStatementOutputTypeDef,
    BatchGetItemInputRequestTypeDef,
    BatchGetItemInputServiceResourceTypeDef,
    BatchGetItemOutputTypeDef,
    BatchStatementErrorTypeDef,
    BatchStatementRequestTypeDef,
    BatchStatementResponseTypeDef,
    BatchWriteItemInputRequestTypeDef,
    BatchWriteItemInputServiceResourceTypeDef,
    BatchWriteItemOutputTypeDef,
    BillingModeSummaryTypeDef,
    CapacityTypeDef,
    ConditionCheckTypeDef,
    ConditionTypeDef,
    ConsumedCapacityTypeDef,
    ContinuousBackupsDescriptionTypeDef,
    ContributorInsightsSummaryTypeDef,
    CreateBackupInputRequestTypeDef,
    CreateBackupOutputTypeDef,
    CreateGlobalSecondaryIndexActionTypeDef,
    CreateGlobalTableInputRequestTypeDef,
    CreateGlobalTableOutputTypeDef,
    CreateReplicaActionTypeDef,
    CreateReplicationGroupMemberActionTypeDef,
    CreateTableInputRequestTypeDef,
    CreateTableInputServiceResourceTypeDef,
    CreateTableOutputTypeDef,
    DeleteBackupInputRequestTypeDef,
    DeleteBackupOutputTypeDef,
    DeleteGlobalSecondaryIndexActionTypeDef,
    DeleteItemInputRequestTypeDef,
    DeleteItemInputTableTypeDef,
    DeleteItemOutputTypeDef,
    DeleteReplicaActionTypeDef,
    DeleteReplicationGroupMemberActionTypeDef,
    DeleteRequestTypeDef,
    DeleteTableInputRequestTypeDef,
    DeleteTableOutputTypeDef,
    DeleteTypeDef,
    DescribeBackupInputRequestTypeDef,
    DescribeBackupOutputTypeDef,
    DescribeContinuousBackupsInputRequestTypeDef,
    DescribeContinuousBackupsOutputTypeDef,
    DescribeContributorInsightsInputRequestTypeDef,
    DescribeContributorInsightsOutputTypeDef,
    DescribeEndpointsResponseTypeDef,
    DescribeExportInputRequestTypeDef,
    DescribeExportOutputTypeDef,
    DescribeGlobalTableInputRequestTypeDef,
    DescribeGlobalTableOutputTypeDef,
    DescribeGlobalTableSettingsInputRequestTypeDef,
    DescribeGlobalTableSettingsOutputTypeDef,
    DescribeKinesisStreamingDestinationInputRequestTypeDef,
    DescribeKinesisStreamingDestinationOutputTypeDef,
    DescribeLimitsOutputTypeDef,
    DescribeTableInputRequestTypeDef,
    DescribeTableOutputTypeDef,
    DescribeTableReplicaAutoScalingInputRequestTypeDef,
    DescribeTableReplicaAutoScalingOutputTypeDef,
    DescribeTimeToLiveInputRequestTypeDef,
    DescribeTimeToLiveOutputTypeDef,
    EndpointTypeDef,
    ExecuteStatementInputRequestTypeDef,
    ExecuteStatementOutputTypeDef,
    ExecuteTransactionInputRequestTypeDef,
    ExecuteTransactionOutputTypeDef,
    ExpectedAttributeValueTypeDef,
    ExportDescriptionTypeDef,
    ExportSummaryTypeDef,
    ExportTableToPointInTimeInputRequestTypeDef,
    ExportTableToPointInTimeOutputTypeDef,
    FailureExceptionTypeDef,
    GetItemInputRequestTypeDef,
    GetItemInputTableTypeDef,
    GetItemOutputTypeDef,
    GetTypeDef,
    GlobalSecondaryIndexAutoScalingUpdateTypeDef,
    GlobalSecondaryIndexDescriptionTypeDef,
    GlobalSecondaryIndexInfoTypeDef,
    GlobalSecondaryIndexTypeDef,
    GlobalSecondaryIndexUpdateTypeDef,
    GlobalTableDescriptionTypeDef,
    GlobalTableGlobalSecondaryIndexSettingsUpdateTypeDef,
    GlobalTableTypeDef,
    ItemCollectionMetricsTypeDef,
    ItemResponseTypeDef,
    KeySchemaElementTypeDef,
    KeysAndAttributesTypeDef,
    KinesisDataStreamDestinationTypeDef,
    KinesisStreamingDestinationInputRequestTypeDef,
    KinesisStreamingDestinationOutputTypeDef,
    ListBackupsInputRequestTypeDef,
    ListBackupsOutputTypeDef,
    ListContributorInsightsInputRequestTypeDef,
    ListContributorInsightsOutputTypeDef,
    ListExportsInputRequestTypeDef,
    ListExportsOutputTypeDef,
    ListGlobalTablesInputRequestTypeDef,
    ListGlobalTablesOutputTypeDef,
    ListTablesInputRequestTypeDef,
    ListTablesOutputTypeDef,
    ListTagsOfResourceInputRequestTypeDef,
    ListTagsOfResourceOutputTypeDef,
    LocalSecondaryIndexDescriptionTypeDef,
    LocalSecondaryIndexInfoTypeDef,
    LocalSecondaryIndexTypeDef,
    PaginatorConfigTypeDef,
    ParameterizedStatementTypeDef,
    PointInTimeRecoveryDescriptionTypeDef,
    PointInTimeRecoverySpecificationTypeDef,
    ProjectionTypeDef,
    ProvisionedThroughputDescriptionTypeDef,
    ProvisionedThroughputOverrideTypeDef,
    ProvisionedThroughputTypeDef,
    PutItemInputRequestTypeDef,
    PutItemInputTableTypeDef,
    PutItemOutputTypeDef,
    PutRequestTypeDef,
    PutTypeDef,
    QueryInputRequestTypeDef,
    QueryInputTableTypeDef,
    QueryOutputTypeDef,
    ReplicaAutoScalingDescriptionTypeDef,
    ReplicaAutoScalingUpdateTypeDef,
    ReplicaDescriptionTypeDef,
    ReplicaGlobalSecondaryIndexAutoScalingDescriptionTypeDef,
    ReplicaGlobalSecondaryIndexAutoScalingUpdateTypeDef,
    ReplicaGlobalSecondaryIndexDescriptionTypeDef,
    ReplicaGlobalSecondaryIndexSettingsDescriptionTypeDef,
    ReplicaGlobalSecondaryIndexSettingsUpdateTypeDef,
    ReplicaGlobalSecondaryIndexTypeDef,
    ReplicaSettingsDescriptionTypeDef,
    ReplicaSettingsUpdateTypeDef,
    ReplicaTypeDef,
    ReplicaUpdateTypeDef,
    ReplicationGroupUpdateTypeDef,
    ResponseMetadataTypeDef,
    RestoreSummaryTypeDef,
    RestoreTableFromBackupInputRequestTypeDef,
    RestoreTableFromBackupOutputTypeDef,
    RestoreTableToPointInTimeInputRequestTypeDef,
    RestoreTableToPointInTimeOutputTypeDef,
    SSEDescriptionTypeDef,
    SSESpecificationTypeDef,
    ScanInputRequestTypeDef,
    ScanInputTableTypeDef,
    ScanOutputTypeDef,
    ServiceResourceTableRequestTypeDef,
    SourceTableDetailsTypeDef,
    SourceTableFeatureDetailsTypeDef,
    StreamSpecificationTypeDef,
    TableAutoScalingDescriptionTypeDef,
    TableBatchWriterRequestTypeDef,
    TableDescriptionTypeDef,
    TagResourceInputRequestTypeDef,
    TagTypeDef,
    TimeToLiveDescriptionTypeDef,
    TimeToLiveSpecificationTypeDef,
    TransactGetItemTypeDef,
    TransactGetItemsInputRequestTypeDef,
    TransactGetItemsOutputTypeDef,
    TransactWriteItemTypeDef,
    TransactWriteItemsInputRequestTypeDef,
    TransactWriteItemsOutputTypeDef,
    UntagResourceInputRequestTypeDef,
    UpdateContinuousBackupsInputRequestTypeDef,
    UpdateContinuousBackupsOutputTypeDef,
    UpdateContributorInsightsInputRequestTypeDef,
    UpdateContributorInsightsOutputTypeDef,
    UpdateGlobalSecondaryIndexActionTypeDef,
    UpdateGlobalTableInputRequestTypeDef,
    UpdateGlobalTableOutputTypeDef,
    UpdateGlobalTableSettingsInputRequestTypeDef,
    UpdateGlobalTableSettingsOutputTypeDef,
    UpdateItemInputRequestTypeDef,
    UpdateItemInputTableTypeDef,
    UpdateItemOutputTypeDef,
    UpdateReplicationGroupMemberActionTypeDef,
    UpdateTableInputRequestTypeDef,
    UpdateTableInputTableTypeDef,
    UpdateTableOutputTypeDef,
    UpdateTableReplicaAutoScalingInputRequestTypeDef,
    UpdateTableReplicaAutoScalingOutputTypeDef,
    UpdateTimeToLiveInputRequestTypeDef,
    UpdateTimeToLiveOutputTypeDef,
    UpdateTypeDef,
    WaiterConfigTypeDef,
    WriteRequestTypeDef,
)

def get_structure() -> ArchivalSummaryTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-dynamodb` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-dynamodb docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_dynamodb/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
