import * as ec2 from '@aws-cdk/aws-ec2';
import { Duration } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ISecret } from './secret';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Options for a SecretRotationApplication.
 *
 * @stability stable
 */
export interface SecretRotationApplicationOptions {
    /**
     * Whether the rotation application uses the mutli user scheme.
     *
     * @default false
     * @stability stable
     */
    readonly isMultiUser?: boolean;
}
/**
 * A secret rotation serverless application.
 *
 * @stability stable
 */
export declare class SecretRotationApplication {
    /**
     * Conducts an AWS SecretsManager secret rotation for RDS MariaDB using the single user rotation scheme.
     *
     * @stability stable
     */
    static readonly MARIADB_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for RDS MariaDB using the multi user rotation scheme.
     *
     * @stability stable
     */
    static readonly MARIADB_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for RDS MySQL using the single user rotation scheme.
     *
     * @stability stable
     */
    static readonly MYSQL_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for RDS MySQL using the multi user rotation scheme.
     *
     * @stability stable
     */
    static readonly MYSQL_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for RDS Oracle using the single user rotation scheme.
     *
     * @stability stable
     */
    static readonly ORACLE_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for RDS Oracle using the multi user rotation scheme.
     *
     * @stability stable
     */
    static readonly ORACLE_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for RDS PostgreSQL using the single user rotation scheme.
     *
     * @stability stable
     */
    static readonly POSTGRES_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for RDS PostgreSQL using the multi user rotation scheme.
     *
     * @stability stable
     */
    static readonly POSTGRES_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for RDS SQL Server using the single user rotation scheme.
     *
     * @stability stable
     */
    static readonly SQLSERVER_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for RDS SQL Server using the multi user rotation scheme.
     *
     * @stability stable
     */
    static readonly SQLSERVER_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for Amazon Redshift using the single user rotation scheme.
     *
     * @stability stable
     */
    static readonly REDSHIFT_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for Amazon Redshift using the multi user rotation scheme.
     *
     * @stability stable
     */
    static readonly REDSHIFT_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for MongoDB using the single user rotation scheme.
     *
     * @stability stable
     */
    static readonly MONGODB_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * Conducts an AWS SecretsManager secret rotation for MongoDB using the multi user rotation scheme.
     *
     * @stability stable
     */
    static readonly MONGODB_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * The application identifier of the rotation application.
     *
     * @stability stable
     */
    readonly applicationId: string;
    /**
     * The semantic version of the rotation application.
     *
     * @stability stable
     */
    readonly semanticVersion: string;
    /**
     * Whether the rotation application uses the mutli user scheme.
     *
     * @stability stable
     */
    readonly isMultiUser?: boolean;
    /**
     * @stability stable
     */
    constructor(applicationId: string, semanticVersion: string, options?: SecretRotationApplicationOptions);
}
/**
 * Construction properties for a SecretRotation.
 *
 * @stability stable
 */
export interface SecretRotationProps {
    /**
     * The secret to rotate. It must be a JSON string with the following format:.
     *
     * ```
     * {
     *    "engine": <required: database engine>,
     *    "host": <required: instance host name>,
     *    "username": <required: username>,
     *    "password": <required: password>,
     *    "dbname": <optional: database name>,
     *    "port": <optional: if not specified, default port will be used>,
     *    "masterarn": <required for multi user rotation: the arn of the master secret which will be used to create users/change passwords>
     * }
     * ```
     *
     * This is typically the case for a secret referenced from an `AWS::SecretsManager::SecretTargetAttachment`
     * or an `ISecret` returned by the `attach()` method of `Secret`.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secrettargetattachment.html
     * @stability stable
     */
    readonly secret: ISecret;
    /**
     * The master secret for a multi user rotation scheme.
     *
     * @default - single user rotation scheme
     * @stability stable
     */
    readonly masterSecret?: ISecret;
    /**
     * Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     *
     * @default Duration.days(30)
     * @stability stable
     */
    readonly automaticallyAfter?: Duration;
    /**
     * The serverless application for the rotation.
     *
     * @stability stable
     */
    readonly application: SecretRotationApplication;
    /**
     * The VPC where the Lambda rotation function will run.
     *
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * The type of subnets in the VPC where the Lambda rotation function will run.
     *
     * @default - the Vpc default strategy if not specified.
     * @stability stable
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * The target service or database.
     *
     * @stability stable
     */
    readonly target: ec2.IConnectable;
    /**
     * The security group for the Lambda rotation function.
     *
     * @default - a new security group is created
     * @stability stable
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * Characters which should not appear in the generated password.
     *
     * @default - no additional characters are explicitly excluded
     * @stability stable
     */
    readonly excludeCharacters?: string;
}
/**
 * Secret rotation for a service or database.
 *
 * @stability stable
 */
export declare class SecretRotation extends CoreConstruct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: SecretRotationProps);
}
