import os
from pathlib import Path
from dotenv import dotenv_values

from ratelimitcli.config import CONFIG_PATH
from ratelimitcli.config.config_file_serde import ConfigFileSerDe, config_to_dict

serde = ConfigFileSerDe(CONFIG_PATH)
existing_config = serde.load()


settings = {
    **dotenv_values(Path(__file__).parent / ".env"),
    **{k: v for k, v in os.environ.items() if k.startswith("RL_")},
    **{f"RL_{k.upper()}": v for k, v in config_to_dict(existing_config).items()},
}
