import typer


from ratelimitcli import RATELIMIT_CLI_NAME, __version__
from ratelimitcli.billing import billing
from ratelimitcli.limits import limits
from ratelimitcli.config.configure import (
    configure as _configure,
    help as _configure_help,
)

app = typer.Typer(
    help="""
NAME:

    ratelimitcli -

DESCRIPTION

    The Ratelimit Command Line Interface is a unified tool to manage your
    Ratelimit services.

SYNOPSIS

    ratelimitcli [options] <command> <subcommand> [args]

    ratelimitcli <command> --help
"""
)
app.add_typer(billing.app, name="billing")
app.add_typer(limits.app, name="limits")


@app.command(short_help="Configure RateLimit CLI options", help=_configure_help)
def configure():
    return _configure()


@app.command()
def version():
    """Print the CLI version."""
    typer.echo(f"{RATELIMIT_CLI_NAME} version {__version__}")
