from contextvars import ContextVar

from ratelimitcli.client.client import RatelimitClient

_ratelimit_client = ContextVar("ratelimit_client", default=None)
_ratelimit_client.set(None)


def configure_client(*args, **kwargs) -> RatelimitClient:
    client = RatelimitClient(*args, **kwargs)
    _ratelimit_client.set(client)
    return client


def get_client() -> RatelimitClient:
    client = _ratelimit_client.get()
    if client is None:
        client = configure_client()
    return client
