"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const bundling_1 = require("./bundling");
const util_1 = require("./util");
/**
 * A Golang Lambda function
 */
class GoFunction extends lambda.Function {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_go_alpha_GoFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GoFunction);
            }
            throw error;
        }
        if (props.runtime && (props.runtime.family !== lambda.RuntimeFamily.GO && props.runtime.family != lambda.RuntimeFamily.OTHER)) {
            throw new Error('Only `go` and `provided` runtimes are supported.');
        }
        const entry = path.resolve(props.entry);
        // Find the project root
        let moduleDir;
        if (props.moduleDir) {
            const parsedModuleDir = path.parse(props.moduleDir);
            if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base === 'go.mod') {
                if (!fs.existsSync(props.moduleDir)) {
                    throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
                }
            }
            else if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base != 'go.mod') {
                throw new Error('moduleDir is specifying a file that is not go.mod');
            }
            else if (!fs.existsSync(path.join(props.moduleDir, 'go.mod'))) {
                throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
            }
            moduleDir = props.moduleDir;
        }
        else {
            const modFile = (0, util_1.findUp)('go.mod', entry);
            if (!modFile) {
                throw new Error('Cannot find go.mod. Please specify it with `moduleDir`.');
            }
            moduleDir = modFile;
        }
        const runtime = props.runtime ?? lambda.Runtime.PROVIDED_AL2;
        const architecture = props.architecture ?? lambda.Architecture.X86_64;
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                ...props.bundling ?? {},
                entry,
                runtime,
                architecture,
                moduleDir,
            }),
            handler: 'bootstrap', // setting name to bootstrap so that the 'provided' runtime can also be used
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
GoFunction[_a] = { fqn: "@aws-cdk/aws-lambda-go-alpha.GoFunction", version: "2.72.1-alpha.0" };
/**
 * The address of the Google Go proxy
 */
GoFunction.GOOGLE_GOPROXY = 'https://proxy.golang.org';
exports.GoFunction = GoFunction;
//# sourceMappingURL=data:application/json;base64,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