"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Probe = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const k8s = require("./imports/k8s");
/**
 * Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
 *
 * @stability stable
 */
class Probe {
    /**
     * Defines a probe based on an HTTP GET request to the IP address of the container.
     *
     * @param path The URL path to hit.
     * @param options Options.
     * @stability stable
     */
    static fromHttpGet(path, options = {}) {
        return {
            _toKube(container) {
                var _b, _c;
                return {
                    ...parseProbeOptions(options),
                    httpGet: {
                        path,
                        port: k8s.IntOrString.fromNumber((_c = (_b = options.port) !== null && _b !== void 0 ? _b : container.port) !== null && _c !== void 0 ? _c : 80),
                    },
                };
            },
        };
    }
    /**
     * Defines a probe based on a command which is executed within the container.
     *
     * @param command The command to execute.
     * @param options Options.
     * @stability stable
     */
    static fromCommand(command, options = {}) {
        return {
            _toKube: _ => ({
                ...parseProbeOptions(options),
                exec: { command },
            }),
        };
    }
}
exports.Probe = Probe;
_a = JSII_RTTI_SYMBOL_1;
Probe[_a] = { fqn: "cdk8s-plus-22.Probe", version: "1.0.0-beta.60" };
function parseProbeOptions(options = {}) {
    var _b;
    return {
        failureThreshold: (_b = options.failureThreshold) !== null && _b !== void 0 ? _b : 3,
        initialDelaySeconds: options.initialDelaySeconds ? options.initialDelaySeconds.toSeconds() : undefined,
        periodSeconds: options.periodSeconds ? options.periodSeconds.toSeconds() : undefined,
        successThreshold: options.successThreshold,
        timeoutSeconds: options.timeoutSeconds ? options.timeoutSeconds.toSeconds() : undefined,
    };
}
//# sourceMappingURL=data:application/json;base64,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