# coding: utf-8

"""
    printnanny-api-client

    Official API client library for printnanny.ai  # noqa: E501

    The version of the OpenAPI document: 0.131.2
    Contact: leigh@printnanny.ai
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from printnanny_api_client.configuration import Configuration


class DjStripePaymentIntent(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'djstripe_id': 'int',
        'cancellation_reason': 'StripePaymentIntentCancellationReason',
        'charges': 'list[DjStripeCharge]',
        'setup_future_usage': 'StripeIntentUsage',
        'djstripe_created': 'datetime',
        'djstripe_updated': 'datetime',
        'id': 'str',
        'livemode': 'bool',
        'created': 'datetime',
        'metadata': 'dict(str, object)',
        'amount': 'int',
        'amount_capturable': 'int',
        'amount_received': 'int',
        'canceled_at': 'datetime',
        'capture_method': 'StripeConfirmationMethod',
        'client_secret': 'str',
        'confirmation_method': 'StripeConfirmationMethod',
        'currency': 'str',
        'description': 'str',
        'last_payment_error': 'dict(str, object)',
        'next_action': 'dict(str, object)',
        'payment_method_types': 'dict(str, object)',
        'receipt_email': 'str',
        'shipping': 'dict(str, object)',
        'statement_descriptor': 'str',
        'status': 'StripePaymentIntentStatus',
        'transfer_data': 'dict(str, object)',
        'transfer_group': 'str',
        'djstripe_owner_account': 'str',
        'customer': 'str',
        'on_behalf_of': 'str',
        'payment_method': 'str'
    }

    attribute_map = {
        'djstripe_id': 'djstripe_id',
        'cancellation_reason': 'cancellation_reason',
        'charges': 'charges',
        'setup_future_usage': 'setup_future_usage',
        'djstripe_created': 'djstripe_created',
        'djstripe_updated': 'djstripe_updated',
        'id': 'id',
        'livemode': 'livemode',
        'created': 'created',
        'metadata': 'metadata',
        'amount': 'amount',
        'amount_capturable': 'amount_capturable',
        'amount_received': 'amount_received',
        'canceled_at': 'canceled_at',
        'capture_method': 'capture_method',
        'client_secret': 'client_secret',
        'confirmation_method': 'confirmation_method',
        'currency': 'currency',
        'description': 'description',
        'last_payment_error': 'last_payment_error',
        'next_action': 'next_action',
        'payment_method_types': 'payment_method_types',
        'receipt_email': 'receipt_email',
        'shipping': 'shipping',
        'statement_descriptor': 'statement_descriptor',
        'status': 'status',
        'transfer_data': 'transfer_data',
        'transfer_group': 'transfer_group',
        'djstripe_owner_account': 'djstripe_owner_account',
        'customer': 'customer',
        'on_behalf_of': 'on_behalf_of',
        'payment_method': 'payment_method'
    }

    def __init__(self, djstripe_id=None, cancellation_reason=None, charges=None, setup_future_usage=None, djstripe_created=None, djstripe_updated=None, id=None, livemode=None, created=None, metadata=None, amount=None, amount_capturable=None, amount_received=None, canceled_at=None, capture_method=None, client_secret=None, confirmation_method=None, currency=None, description=None, last_payment_error=None, next_action=None, payment_method_types=None, receipt_email=None, shipping=None, statement_descriptor=None, status=None, transfer_data=None, transfer_group=None, djstripe_owner_account=None, customer=None, on_behalf_of=None, payment_method=None, local_vars_configuration=None):  # noqa: E501
        """DjStripePaymentIntent - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._djstripe_id = None
        self._cancellation_reason = None
        self._charges = None
        self._setup_future_usage = None
        self._djstripe_created = None
        self._djstripe_updated = None
        self._id = None
        self._livemode = None
        self._created = None
        self._metadata = None
        self._amount = None
        self._amount_capturable = None
        self._amount_received = None
        self._canceled_at = None
        self._capture_method = None
        self._client_secret = None
        self._confirmation_method = None
        self._currency = None
        self._description = None
        self._last_payment_error = None
        self._next_action = None
        self._payment_method_types = None
        self._receipt_email = None
        self._shipping = None
        self._statement_descriptor = None
        self._status = None
        self._transfer_data = None
        self._transfer_group = None
        self._djstripe_owner_account = None
        self._customer = None
        self._on_behalf_of = None
        self._payment_method = None
        self.discriminator = None

        self.djstripe_id = djstripe_id
        self.cancellation_reason = cancellation_reason
        self.charges = charges
        self.setup_future_usage = setup_future_usage
        self.djstripe_created = djstripe_created
        self.djstripe_updated = djstripe_updated
        self.id = id
        self.livemode = livemode
        self.created = created
        self.metadata = metadata
        self.amount = amount
        self.amount_capturable = amount_capturable
        self.amount_received = amount_received
        self.canceled_at = canceled_at
        self.capture_method = capture_method
        self.client_secret = client_secret
        self.confirmation_method = confirmation_method
        self.currency = currency
        if description is not None:
            self.description = description
        self.last_payment_error = last_payment_error
        self.next_action = next_action
        self.payment_method_types = payment_method_types
        if receipt_email is not None:
            self.receipt_email = receipt_email
        self.shipping = shipping
        if statement_descriptor is not None:
            self.statement_descriptor = statement_descriptor
        self.status = status
        self.transfer_data = transfer_data
        if transfer_group is not None:
            self.transfer_group = transfer_group
        self.djstripe_owner_account = djstripe_owner_account
        self.customer = customer
        self.on_behalf_of = on_behalf_of
        self.payment_method = payment_method

    @property
    def djstripe_id(self):
        """Gets the djstripe_id of this DjStripePaymentIntent.  # noqa: E501


        :return: The djstripe_id of this DjStripePaymentIntent.  # noqa: E501
        :rtype: int
        """
        return self._djstripe_id

    @djstripe_id.setter
    def djstripe_id(self, djstripe_id):
        """Sets the djstripe_id of this DjStripePaymentIntent.


        :param djstripe_id: The djstripe_id of this DjStripePaymentIntent.  # noqa: E501
        :type djstripe_id: int
        """
        if self.local_vars_configuration.client_side_validation and djstripe_id is None:  # noqa: E501
            raise ValueError("Invalid value for `djstripe_id`, must not be `None`")  # noqa: E501

        self._djstripe_id = djstripe_id

    @property
    def cancellation_reason(self):
        """Gets the cancellation_reason of this DjStripePaymentIntent.  # noqa: E501


        :return: The cancellation_reason of this DjStripePaymentIntent.  # noqa: E501
        :rtype: StripePaymentIntentCancellationReason
        """
        return self._cancellation_reason

    @cancellation_reason.setter
    def cancellation_reason(self, cancellation_reason):
        """Sets the cancellation_reason of this DjStripePaymentIntent.


        :param cancellation_reason: The cancellation_reason of this DjStripePaymentIntent.  # noqa: E501
        :type cancellation_reason: StripePaymentIntentCancellationReason
        """
        if self.local_vars_configuration.client_side_validation and cancellation_reason is None:  # noqa: E501
            raise ValueError("Invalid value for `cancellation_reason`, must not be `None`")  # noqa: E501

        self._cancellation_reason = cancellation_reason

    @property
    def charges(self):
        """Gets the charges of this DjStripePaymentIntent.  # noqa: E501


        :return: The charges of this DjStripePaymentIntent.  # noqa: E501
        :rtype: list[DjStripeCharge]
        """
        return self._charges

    @charges.setter
    def charges(self, charges):
        """Sets the charges of this DjStripePaymentIntent.


        :param charges: The charges of this DjStripePaymentIntent.  # noqa: E501
        :type charges: list[DjStripeCharge]
        """
        if self.local_vars_configuration.client_side_validation and charges is None:  # noqa: E501
            raise ValueError("Invalid value for `charges`, must not be `None`")  # noqa: E501

        self._charges = charges

    @property
    def setup_future_usage(self):
        """Gets the setup_future_usage of this DjStripePaymentIntent.  # noqa: E501


        :return: The setup_future_usage of this DjStripePaymentIntent.  # noqa: E501
        :rtype: StripeIntentUsage
        """
        return self._setup_future_usage

    @setup_future_usage.setter
    def setup_future_usage(self, setup_future_usage):
        """Sets the setup_future_usage of this DjStripePaymentIntent.


        :param setup_future_usage: The setup_future_usage of this DjStripePaymentIntent.  # noqa: E501
        :type setup_future_usage: StripeIntentUsage
        """
        if self.local_vars_configuration.client_side_validation and setup_future_usage is None:  # noqa: E501
            raise ValueError("Invalid value for `setup_future_usage`, must not be `None`")  # noqa: E501

        self._setup_future_usage = setup_future_usage

    @property
    def djstripe_created(self):
        """Gets the djstripe_created of this DjStripePaymentIntent.  # noqa: E501


        :return: The djstripe_created of this DjStripePaymentIntent.  # noqa: E501
        :rtype: datetime
        """
        return self._djstripe_created

    @djstripe_created.setter
    def djstripe_created(self, djstripe_created):
        """Sets the djstripe_created of this DjStripePaymentIntent.


        :param djstripe_created: The djstripe_created of this DjStripePaymentIntent.  # noqa: E501
        :type djstripe_created: datetime
        """
        if self.local_vars_configuration.client_side_validation and djstripe_created is None:  # noqa: E501
            raise ValueError("Invalid value for `djstripe_created`, must not be `None`")  # noqa: E501

        self._djstripe_created = djstripe_created

    @property
    def djstripe_updated(self):
        """Gets the djstripe_updated of this DjStripePaymentIntent.  # noqa: E501


        :return: The djstripe_updated of this DjStripePaymentIntent.  # noqa: E501
        :rtype: datetime
        """
        return self._djstripe_updated

    @djstripe_updated.setter
    def djstripe_updated(self, djstripe_updated):
        """Sets the djstripe_updated of this DjStripePaymentIntent.


        :param djstripe_updated: The djstripe_updated of this DjStripePaymentIntent.  # noqa: E501
        :type djstripe_updated: datetime
        """
        if self.local_vars_configuration.client_side_validation and djstripe_updated is None:  # noqa: E501
            raise ValueError("Invalid value for `djstripe_updated`, must not be `None`")  # noqa: E501

        self._djstripe_updated = djstripe_updated

    @property
    def id(self):
        """Gets the id of this DjStripePaymentIntent.  # noqa: E501


        :return: The id of this DjStripePaymentIntent.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DjStripePaymentIntent.


        :param id: The id of this DjStripePaymentIntent.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 255):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `255`")  # noqa: E501

        self._id = id

    @property
    def livemode(self):
        """Gets the livemode of this DjStripePaymentIntent.  # noqa: E501

        Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.  # noqa: E501

        :return: The livemode of this DjStripePaymentIntent.  # noqa: E501
        :rtype: bool
        """
        return self._livemode

    @livemode.setter
    def livemode(self, livemode):
        """Sets the livemode of this DjStripePaymentIntent.

        Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.  # noqa: E501

        :param livemode: The livemode of this DjStripePaymentIntent.  # noqa: E501
        :type livemode: bool
        """

        self._livemode = livemode

    @property
    def created(self):
        """Gets the created of this DjStripePaymentIntent.  # noqa: E501

        The datetime this object was created in stripe.  # noqa: E501

        :return: The created of this DjStripePaymentIntent.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this DjStripePaymentIntent.

        The datetime this object was created in stripe.  # noqa: E501

        :param created: The created of this DjStripePaymentIntent.  # noqa: E501
        :type created: datetime
        """

        self._created = created

    @property
    def metadata(self):
        """Gets the metadata of this DjStripePaymentIntent.  # noqa: E501

        A set of key/value pairs that you can attach to an object. It can be useful for storing additional information about an object in a structured format.  # noqa: E501

        :return: The metadata of this DjStripePaymentIntent.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this DjStripePaymentIntent.

        A set of key/value pairs that you can attach to an object. It can be useful for storing additional information about an object in a structured format.  # noqa: E501

        :param metadata: The metadata of this DjStripePaymentIntent.  # noqa: E501
        :type metadata: dict(str, object)
        """

        self._metadata = metadata

    @property
    def amount(self):
        """Gets the amount of this DjStripePaymentIntent.  # noqa: E501

        Amount (in cents) intended to be collected by this PaymentIntent.  # noqa: E501

        :return: The amount of this DjStripePaymentIntent.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this DjStripePaymentIntent.

        Amount (in cents) intended to be collected by this PaymentIntent.  # noqa: E501

        :param amount: The amount of this DjStripePaymentIntent.  # noqa: E501
        :type amount: int
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                amount is not None and amount > 9223372036854775807):  # noqa: E501
            raise ValueError("Invalid value for `amount`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                amount is not None and amount < -9223372036854775808):  # noqa: E501
            raise ValueError("Invalid value for `amount`, must be a value greater than or equal to `-9223372036854775808`")  # noqa: E501

        self._amount = amount

    @property
    def amount_capturable(self):
        """Gets the amount_capturable of this DjStripePaymentIntent.  # noqa: E501

        Amount (in cents) that can be captured from this PaymentIntent.  # noqa: E501

        :return: The amount_capturable of this DjStripePaymentIntent.  # noqa: E501
        :rtype: int
        """
        return self._amount_capturable

    @amount_capturable.setter
    def amount_capturable(self, amount_capturable):
        """Sets the amount_capturable of this DjStripePaymentIntent.

        Amount (in cents) that can be captured from this PaymentIntent.  # noqa: E501

        :param amount_capturable: The amount_capturable of this DjStripePaymentIntent.  # noqa: E501
        :type amount_capturable: int
        """
        if self.local_vars_configuration.client_side_validation and amount_capturable is None:  # noqa: E501
            raise ValueError("Invalid value for `amount_capturable`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                amount_capturable is not None and amount_capturable > 9223372036854775807):  # noqa: E501
            raise ValueError("Invalid value for `amount_capturable`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                amount_capturable is not None and amount_capturable < -9223372036854775808):  # noqa: E501
            raise ValueError("Invalid value for `amount_capturable`, must be a value greater than or equal to `-9223372036854775808`")  # noqa: E501

        self._amount_capturable = amount_capturable

    @property
    def amount_received(self):
        """Gets the amount_received of this DjStripePaymentIntent.  # noqa: E501

        Amount (in cents) that was collected by this PaymentIntent.  # noqa: E501

        :return: The amount_received of this DjStripePaymentIntent.  # noqa: E501
        :rtype: int
        """
        return self._amount_received

    @amount_received.setter
    def amount_received(self, amount_received):
        """Sets the amount_received of this DjStripePaymentIntent.

        Amount (in cents) that was collected by this PaymentIntent.  # noqa: E501

        :param amount_received: The amount_received of this DjStripePaymentIntent.  # noqa: E501
        :type amount_received: int
        """
        if self.local_vars_configuration.client_side_validation and amount_received is None:  # noqa: E501
            raise ValueError("Invalid value for `amount_received`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                amount_received is not None and amount_received > 9223372036854775807):  # noqa: E501
            raise ValueError("Invalid value for `amount_received`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                amount_received is not None and amount_received < -9223372036854775808):  # noqa: E501
            raise ValueError("Invalid value for `amount_received`, must be a value greater than or equal to `-9223372036854775808`")  # noqa: E501

        self._amount_received = amount_received

    @property
    def canceled_at(self):
        """Gets the canceled_at of this DjStripePaymentIntent.  # noqa: E501

        Populated when status is canceled, this is the time at which the PaymentIntent was canceled. Measured in seconds since the Unix epoch.  # noqa: E501

        :return: The canceled_at of this DjStripePaymentIntent.  # noqa: E501
        :rtype: datetime
        """
        return self._canceled_at

    @canceled_at.setter
    def canceled_at(self, canceled_at):
        """Sets the canceled_at of this DjStripePaymentIntent.

        Populated when status is canceled, this is the time at which the PaymentIntent was canceled. Measured in seconds since the Unix epoch.  # noqa: E501

        :param canceled_at: The canceled_at of this DjStripePaymentIntent.  # noqa: E501
        :type canceled_at: datetime
        """

        self._canceled_at = canceled_at

    @property
    def capture_method(self):
        """Gets the capture_method of this DjStripePaymentIntent.  # noqa: E501

        Capture method of this PaymentIntent, one of automatic or manual.  * `automatic` - Automatic * `manual` - Manual  # noqa: E501

        :return: The capture_method of this DjStripePaymentIntent.  # noqa: E501
        :rtype: StripeConfirmationMethod
        """
        return self._capture_method

    @capture_method.setter
    def capture_method(self, capture_method):
        """Sets the capture_method of this DjStripePaymentIntent.

        Capture method of this PaymentIntent, one of automatic or manual.  * `automatic` - Automatic * `manual` - Manual  # noqa: E501

        :param capture_method: The capture_method of this DjStripePaymentIntent.  # noqa: E501
        :type capture_method: StripeConfirmationMethod
        """

        self._capture_method = capture_method

    @property
    def client_secret(self):
        """Gets the client_secret of this DjStripePaymentIntent.  # noqa: E501

        The client secret of this PaymentIntent. Used for client-side retrieval using a publishable key.  # noqa: E501

        :return: The client_secret of this DjStripePaymentIntent.  # noqa: E501
        :rtype: str
        """
        return self._client_secret

    @client_secret.setter
    def client_secret(self, client_secret):
        """Sets the client_secret of this DjStripePaymentIntent.

        The client secret of this PaymentIntent. Used for client-side retrieval using a publishable key.  # noqa: E501

        :param client_secret: The client_secret of this DjStripePaymentIntent.  # noqa: E501
        :type client_secret: str
        """
        if self.local_vars_configuration.client_side_validation and client_secret is None:  # noqa: E501
            raise ValueError("Invalid value for `client_secret`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                client_secret is not None and len(client_secret) > 5000):
            raise ValueError("Invalid value for `client_secret`, length must be less than or equal to `5000`")  # noqa: E501

        self._client_secret = client_secret

    @property
    def confirmation_method(self):
        """Gets the confirmation_method of this DjStripePaymentIntent.  # noqa: E501

        Confirmation method of this PaymentIntent, one of manual or automatic.  * `automatic` - Automatic * `manual` - Manual  # noqa: E501

        :return: The confirmation_method of this DjStripePaymentIntent.  # noqa: E501
        :rtype: StripeConfirmationMethod
        """
        return self._confirmation_method

    @confirmation_method.setter
    def confirmation_method(self, confirmation_method):
        """Sets the confirmation_method of this DjStripePaymentIntent.

        Confirmation method of this PaymentIntent, one of manual or automatic.  * `automatic` - Automatic * `manual` - Manual  # noqa: E501

        :param confirmation_method: The confirmation_method of this DjStripePaymentIntent.  # noqa: E501
        :type confirmation_method: StripeConfirmationMethod
        """

        self._confirmation_method = confirmation_method

    @property
    def currency(self):
        """Gets the currency of this DjStripePaymentIntent.  # noqa: E501

        Three-letter ISO currency code  # noqa: E501

        :return: The currency of this DjStripePaymentIntent.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this DjStripePaymentIntent.

        Three-letter ISO currency code  # noqa: E501

        :param currency: The currency of this DjStripePaymentIntent.  # noqa: E501
        :type currency: str
        """
        if self.local_vars_configuration.client_side_validation and currency is None:  # noqa: E501
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                currency is not None and len(currency) > 3):
            raise ValueError("Invalid value for `currency`, length must be less than or equal to `3`")  # noqa: E501

        self._currency = currency

    @property
    def description(self):
        """Gets the description of this DjStripePaymentIntent.  # noqa: E501

        An arbitrary string attached to the object. Often useful for displaying to users.  # noqa: E501

        :return: The description of this DjStripePaymentIntent.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this DjStripePaymentIntent.

        An arbitrary string attached to the object. Often useful for displaying to users.  # noqa: E501

        :param description: The description of this DjStripePaymentIntent.  # noqa: E501
        :type description: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 1000):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `1000`")  # noqa: E501

        self._description = description

    @property
    def last_payment_error(self):
        """Gets the last_payment_error of this DjStripePaymentIntent.  # noqa: E501

        The payment error encountered in the previous PaymentIntent confirmation.  # noqa: E501

        :return: The last_payment_error of this DjStripePaymentIntent.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._last_payment_error

    @last_payment_error.setter
    def last_payment_error(self, last_payment_error):
        """Sets the last_payment_error of this DjStripePaymentIntent.

        The payment error encountered in the previous PaymentIntent confirmation.  # noqa: E501

        :param last_payment_error: The last_payment_error of this DjStripePaymentIntent.  # noqa: E501
        :type last_payment_error: dict(str, object)
        """

        self._last_payment_error = last_payment_error

    @property
    def next_action(self):
        """Gets the next_action of this DjStripePaymentIntent.  # noqa: E501

        If present, this property tells you what actions you need to take in order for your customer to fulfill a payment using the provided source.  # noqa: E501

        :return: The next_action of this DjStripePaymentIntent.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._next_action

    @next_action.setter
    def next_action(self, next_action):
        """Sets the next_action of this DjStripePaymentIntent.

        If present, this property tells you what actions you need to take in order for your customer to fulfill a payment using the provided source.  # noqa: E501

        :param next_action: The next_action of this DjStripePaymentIntent.  # noqa: E501
        :type next_action: dict(str, object)
        """

        self._next_action = next_action

    @property
    def payment_method_types(self):
        """Gets the payment_method_types of this DjStripePaymentIntent.  # noqa: E501

        The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.  # noqa: E501

        :return: The payment_method_types of this DjStripePaymentIntent.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._payment_method_types

    @payment_method_types.setter
    def payment_method_types(self, payment_method_types):
        """Sets the payment_method_types of this DjStripePaymentIntent.

        The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.  # noqa: E501

        :param payment_method_types: The payment_method_types of this DjStripePaymentIntent.  # noqa: E501
        :type payment_method_types: dict(str, object)
        """
        if self.local_vars_configuration.client_side_validation and payment_method_types is None:  # noqa: E501
            raise ValueError("Invalid value for `payment_method_types`, must not be `None`")  # noqa: E501

        self._payment_method_types = payment_method_types

    @property
    def receipt_email(self):
        """Gets the receipt_email of this DjStripePaymentIntent.  # noqa: E501

        Email address that the receipt for the resulting payment will be sent to.  # noqa: E501

        :return: The receipt_email of this DjStripePaymentIntent.  # noqa: E501
        :rtype: str
        """
        return self._receipt_email

    @receipt_email.setter
    def receipt_email(self, receipt_email):
        """Sets the receipt_email of this DjStripePaymentIntent.

        Email address that the receipt for the resulting payment will be sent to.  # noqa: E501

        :param receipt_email: The receipt_email of this DjStripePaymentIntent.  # noqa: E501
        :type receipt_email: str
        """
        if (self.local_vars_configuration.client_side_validation and
                receipt_email is not None and len(receipt_email) > 255):
            raise ValueError("Invalid value for `receipt_email`, length must be less than or equal to `255`")  # noqa: E501

        self._receipt_email = receipt_email

    @property
    def shipping(self):
        """Gets the shipping of this DjStripePaymentIntent.  # noqa: E501

        Shipping information for this PaymentIntent.  # noqa: E501

        :return: The shipping of this DjStripePaymentIntent.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._shipping

    @shipping.setter
    def shipping(self, shipping):
        """Sets the shipping of this DjStripePaymentIntent.

        Shipping information for this PaymentIntent.  # noqa: E501

        :param shipping: The shipping of this DjStripePaymentIntent.  # noqa: E501
        :type shipping: dict(str, object)
        """

        self._shipping = shipping

    @property
    def statement_descriptor(self):
        """Gets the statement_descriptor of this DjStripePaymentIntent.  # noqa: E501

        For non-card charges, you can use this value as the complete description that appears on your customers' statements. Must contain at least one letter, maximum 22 characters.  # noqa: E501

        :return: The statement_descriptor of this DjStripePaymentIntent.  # noqa: E501
        :rtype: str
        """
        return self._statement_descriptor

    @statement_descriptor.setter
    def statement_descriptor(self, statement_descriptor):
        """Sets the statement_descriptor of this DjStripePaymentIntent.

        For non-card charges, you can use this value as the complete description that appears on your customers' statements. Must contain at least one letter, maximum 22 characters.  # noqa: E501

        :param statement_descriptor: The statement_descriptor of this DjStripePaymentIntent.  # noqa: E501
        :type statement_descriptor: str
        """
        if (self.local_vars_configuration.client_side_validation and
                statement_descriptor is not None and len(statement_descriptor) > 22):
            raise ValueError("Invalid value for `statement_descriptor`, length must be less than or equal to `22`")  # noqa: E501

        self._statement_descriptor = statement_descriptor

    @property
    def status(self):
        """Gets the status of this DjStripePaymentIntent.  # noqa: E501

        Status of this PaymentIntent, one of requires_payment_method, requires_confirmation, requires_action, processing, requires_capture, canceled, or succeeded. You can read more about PaymentIntent statuses here.  * `canceled` - Cancellation invalidates the intent for future confirmation and cannot be undone. * `processing` - Required actions have been handled. * `requires_action` - Payment Method require additional action, such as 3D secure. * `requires_capture` - Capture the funds on the cards which have been put on holds. * `requires_confirmation` - Intent is ready to be confirmed. * `requires_payment_method` - Intent created and requires a Payment Method to be attached. * `succeeded` - The funds are in your account.  # noqa: E501

        :return: The status of this DjStripePaymentIntent.  # noqa: E501
        :rtype: StripePaymentIntentStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this DjStripePaymentIntent.

        Status of this PaymentIntent, one of requires_payment_method, requires_confirmation, requires_action, processing, requires_capture, canceled, or succeeded. You can read more about PaymentIntent statuses here.  * `canceled` - Cancellation invalidates the intent for future confirmation and cannot be undone. * `processing` - Required actions have been handled. * `requires_action` - Payment Method require additional action, such as 3D secure. * `requires_capture` - Capture the funds on the cards which have been put on holds. * `requires_confirmation` - Intent is ready to be confirmed. * `requires_payment_method` - Intent created and requires a Payment Method to be attached. * `succeeded` - The funds are in your account.  # noqa: E501

        :param status: The status of this DjStripePaymentIntent.  # noqa: E501
        :type status: StripePaymentIntentStatus
        """

        self._status = status

    @property
    def transfer_data(self):
        """Gets the transfer_data of this DjStripePaymentIntent.  # noqa: E501

        The data with which to automatically create a Transfer when the payment is finalized. See the PaymentIntents Connect usage guide for details.  # noqa: E501

        :return: The transfer_data of this DjStripePaymentIntent.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._transfer_data

    @transfer_data.setter
    def transfer_data(self, transfer_data):
        """Sets the transfer_data of this DjStripePaymentIntent.

        The data with which to automatically create a Transfer when the payment is finalized. See the PaymentIntents Connect usage guide for details.  # noqa: E501

        :param transfer_data: The transfer_data of this DjStripePaymentIntent.  # noqa: E501
        :type transfer_data: dict(str, object)
        """

        self._transfer_data = transfer_data

    @property
    def transfer_group(self):
        """Gets the transfer_group of this DjStripePaymentIntent.  # noqa: E501

        A string that identifies the resulting payment as part of a group. See the PaymentIntents Connect usage guide for details.  # noqa: E501

        :return: The transfer_group of this DjStripePaymentIntent.  # noqa: E501
        :rtype: str
        """
        return self._transfer_group

    @transfer_group.setter
    def transfer_group(self, transfer_group):
        """Sets the transfer_group of this DjStripePaymentIntent.

        A string that identifies the resulting payment as part of a group. See the PaymentIntents Connect usage guide for details.  # noqa: E501

        :param transfer_group: The transfer_group of this DjStripePaymentIntent.  # noqa: E501
        :type transfer_group: str
        """
        if (self.local_vars_configuration.client_side_validation and
                transfer_group is not None and len(transfer_group) > 255):
            raise ValueError("Invalid value for `transfer_group`, length must be less than or equal to `255`")  # noqa: E501

        self._transfer_group = transfer_group

    @property
    def djstripe_owner_account(self):
        """Gets the djstripe_owner_account of this DjStripePaymentIntent.  # noqa: E501

        The Stripe Account this object belongs to.  # noqa: E501

        :return: The djstripe_owner_account of this DjStripePaymentIntent.  # noqa: E501
        :rtype: str
        """
        return self._djstripe_owner_account

    @djstripe_owner_account.setter
    def djstripe_owner_account(self, djstripe_owner_account):
        """Sets the djstripe_owner_account of this DjStripePaymentIntent.

        The Stripe Account this object belongs to.  # noqa: E501

        :param djstripe_owner_account: The djstripe_owner_account of this DjStripePaymentIntent.  # noqa: E501
        :type djstripe_owner_account: str
        """

        self._djstripe_owner_account = djstripe_owner_account

    @property
    def customer(self):
        """Gets the customer of this DjStripePaymentIntent.  # noqa: E501

        Customer this PaymentIntent is for if one exists.  # noqa: E501

        :return: The customer of this DjStripePaymentIntent.  # noqa: E501
        :rtype: str
        """
        return self._customer

    @customer.setter
    def customer(self, customer):
        """Sets the customer of this DjStripePaymentIntent.

        Customer this PaymentIntent is for if one exists.  # noqa: E501

        :param customer: The customer of this DjStripePaymentIntent.  # noqa: E501
        :type customer: str
        """

        self._customer = customer

    @property
    def on_behalf_of(self):
        """Gets the on_behalf_of of this DjStripePaymentIntent.  # noqa: E501

        The account (if any) for which the funds of the PaymentIntent are intended.  # noqa: E501

        :return: The on_behalf_of of this DjStripePaymentIntent.  # noqa: E501
        :rtype: str
        """
        return self._on_behalf_of

    @on_behalf_of.setter
    def on_behalf_of(self, on_behalf_of):
        """Sets the on_behalf_of of this DjStripePaymentIntent.

        The account (if any) for which the funds of the PaymentIntent are intended.  # noqa: E501

        :param on_behalf_of: The on_behalf_of of this DjStripePaymentIntent.  # noqa: E501
        :type on_behalf_of: str
        """

        self._on_behalf_of = on_behalf_of

    @property
    def payment_method(self):
        """Gets the payment_method of this DjStripePaymentIntent.  # noqa: E501

        Payment method used in this PaymentIntent.  # noqa: E501

        :return: The payment_method of this DjStripePaymentIntent.  # noqa: E501
        :rtype: str
        """
        return self._payment_method

    @payment_method.setter
    def payment_method(self, payment_method):
        """Sets the payment_method of this DjStripePaymentIntent.

        Payment method used in this PaymentIntent.  # noqa: E501

        :param payment_method: The payment_method of this DjStripePaymentIntent.  # noqa: E501
        :type payment_method: str
        """

        self._payment_method = payment_method

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DjStripePaymentIntent):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DjStripePaymentIntent):
            return True

        return self.to_dict() != other.to_dict()
