"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-apigateway-dynamodb';
// Definitions
const props = {
    allowReadOperation: true,
    allowCreateOperation: true,
    allowDeleteOperation: true,
    allowUpdateOperation: true,
    createRequestTemplate: "{\r\n  \"TableName\": \"${Table}\",\r\n  \"Item\": {\r\n    \"id\": {\r\n      \"S\": \"$input.path('$.id')\"\r\n    },\r\n    \"EventCount\": {\r\n      \"N\": \"$input.path('$.EventCount')\"\r\n    },\r\n    \"Message\": {\r\n      \"S\": \"$input.path('$.Message')\"\r\n    }\r\n  }\r\n}",
    updateRequestTemplate: "{\r\n  \"TableName\": \"${Table}\",\r\n  \"Key\": {\r\n    \"id\": {\r\n      \"S\": \"$input.path('$.id')\"\r\n    }\r\n  },\r\n  \"ExpressionAttributeValues\": {\r\n    \":event_count\": {\r\n      \"N\": \"$input.path('$.EventCount')\"\r\n    },\r\n    \":message\": {\r\n      \"S\": \"$input.path('$.Message')\"\r\n    }\r\n  },\r\n  \"UpdateExpression\": \"ADD EventCount :event_count SET Message = :message\",\r\n  \"ReturnValues\": \"ALL_NEW\"\r\n}"
};
new lib_1.ApiGatewayToDynamoDB(stack, 'test-api-gateway-dynamodb', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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