#!/usr/bin/env ts-node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const console = require("console");
const path = require("path");
const process = require("process");
const fs = require("fs-extra");
const cdk_1 = require("projen/lib/cdk");
// The directory where our 'package.json' lives
const MONOPACKAGE_ROOT = process.cwd();
const ROOT_PATH = findWorkspacePath();
const LIBRARIES_ROOT = path.resolve(ROOT_PATH, "packages");
const UBER_PACKAGE_JSON_PATH = path.join(MONOPACKAGE_ROOT, "package.json");
const EXCLUDED_PACKAGES = [];
async function main() {
    console.log(`🌴  workspace root path is: ${ROOT_PATH}`);
    const uberPackageJson = (await fs.readJson(UBER_PACKAGE_JSON_PATH));
    const libraries = await findLibrariesToPackage(uberPackageJson);
    await verifyDependencies(uberPackageJson, libraries);
    await prepareSourceFiles(libraries, uberPackageJson);
}
main().then(() => process.exit(0), (err) => {
    console.error("❌ An error occurred: ", err.stack);
    process.exit(1);
});
/**
 * Find the workspace root path. Walk up the directory tree until you find nx.json
 */
function findWorkspacePath() {
    return _findRootPath(process.cwd());
    function _findRootPath(part) {
        if (part === path.resolve(part, "..")) {
            throw new Error("couldn't find a 'nx.json' file when walking up the directory tree, are you in a aws-pdk project?");
        }
        if (fs.existsSync(path.resolve(part, "nx.json"))) {
            return part;
        }
        return _findRootPath(path.resolve(part, ".."));
    }
}
async function findLibrariesToPackage(uberPackageJson) {
    console.log("🔍 Discovering libraries that need packaging...");
    const deprecatedPackages = uberPackageJson.bundle?.deprecatedPackages;
    const result = new Array();
    for (const dir of await fs.readdir(LIBRARIES_ROOT)) {
        const packageJsonPath = path.resolve(LIBRARIES_ROOT, dir, "package.json");
        if (!fs.pathExistsSync(packageJsonPath)) {
            continue;
        }
        const packageJson = (await fs.readJson(packageJsonPath));
        if (packageJson.bundle?.exclude ||
            EXCLUDED_PACKAGES.includes(packageJson.name)) {
            console.log(`\t⚠️ Skipping (bundle excluded):    ${packageJson.name}`);
            continue;
        }
        else if (packageJson.jsii == null) {
            console.log(`\t⚠️ Skipping (not jsii-enabled):   ${packageJson.name}`);
            continue;
        }
        else if (deprecatedPackages?.some((packageName) => packageName === packageJson.name)) {
            console.log(`\t⚠️ Skipping (bundle deprecated): ${packageJson.name}`);
            continue;
        }
        else if (packageJson.deprecated) {
            console.log(`\t⚠️ Skipping (deprecated):         ${packageJson.name}`);
            continue;
        }
        else if (packageJson.stability !== cdk_1.Stability.STABLE) {
            console.log(`\t⚠️ Skipping (non stable):         ${packageJson.name}`);
            continue;
        }
        result.push({
            packageJson,
            root: path.join(LIBRARIES_ROOT, dir),
            shortName: packageJson.name === "aws-prototyping-sdk"
                ? packageJson.name
                : packageJson.name.slice("@aws-prototyping-sdk/".length),
        });
    }
    console.log(`\tℹ️ Found ${result.length} relevant packages!`);
    return result;
}
async function verifyDependencies(packageJson, libraries) {
    console.log("🧐 Verifying dependencies are complete...");
    const toBundle = {};
    for (const library of libraries) {
        for (const depName of library.packageJson.bundleDependencies ??
            library.packageJson.bundledDependencies ??
            []) {
            const requiredVersion = library.packageJson.devDependencies?.[depName] ??
                library.packageJson.dependencies?.[depName] ??
                "*";
            if (toBundle[depName] != null && toBundle[depName] !== requiredVersion) {
                throw new Error(`Required to bundle different versions of ${depName}: ${toBundle[depName]} and ${requiredVersion}.`);
            }
            toBundle[depName] = requiredVersion;
        }
    }
    const spuriousBundledDeps = new Set(packageJson.bundledDependencies ?? []);
    for (const [name, version] of Object.entries(toBundle)) {
        spuriousBundledDeps.delete(name);
        if (!packageJson.bundledDependencies?.includes(name)) {
            throw new Error(`\t⚠️ Missing bundled dependency: ${name} at ${version}`);
        }
        if (packageJson.dependencies?.[name] !== version) {
            throw new Error(`\t⚠️ Missing or incorrect dependency: ${name} at ${version}`);
        }
    }
    packageJson.bundledDependencies = packageJson.bundledDependencies?.filter((dep) => !spuriousBundledDeps.has(dep));
    if (spuriousBundledDeps.size > 0) {
        throw new Error(`\t⚠️ Spurious bundled dependencies detected. Please remove from dependencies: ${spuriousBundledDeps}`);
    }
    console.log("\t✅ Dependencies are correct!");
}
async function prepareSourceFiles(libraries, packageJson) {
    console.log("📝 Preparing source files...");
    const libRoot = resolveLibRoot(packageJson);
    // Should not remove collection directory if we're currently in it. The OS would be unhappy.
    if (libRoot !== process.cwd()) {
        await fs.remove(libRoot);
    }
    const indexStatements = new Array();
    for (const library of libraries) {
        const libDir = path.join(libRoot, library.shortName);
        const copied = await transformPackage(library, packageJson, libDir, libraries);
        if (!copied) {
            continue;
        }
        indexStatements.push(`export * as ${library.shortName.replace(/-/g, "_")} from './${library.shortName}';`);
    }
    await fs.writeFile(path.join(libRoot, "index.ts"), indexStatements.join("\n"), { encoding: "utf8" });
    console.log("\t🍺 Success!");
}
async function transformPackage(library, uberPackageJson, destination, allLibraries) {
    await fs.mkdirp(destination);
    await copyOrTransformFiles(library.root, destination, allLibraries, uberPackageJson);
    await fs.writeFile(path.join(destination, "index.ts"), `export * from './src';\n`, { encoding: "utf8" });
    const config = uberPackageJson.jsii.targets;
    await fs.writeJson(path.join(destination, ".jsiirc.json"), {
        targets: transformTargets(config, library.packageJson.jsii.targets),
    }, { spaces: 2 });
    // if libRoot is _not_ under the root of the package, generate a file at the
    // root that will refer to the one under lib/ so that users can still import
    // from "monocdk/aws-lambda".
    const relativeLibRoot = uberPackageJson.bundle?.libRoot;
    if (relativeLibRoot && relativeLibRoot !== ".") {
        await fs.writeFile(path.resolve(MONOPACKAGE_ROOT, `${library.shortName}.ts`), `export * from './${relativeLibRoot}/${library.shortName}';\n`, { encoding: "utf8" });
    }
    return true;
}
function transformTargets(monoConfig, targets) {
    if (targets == null) {
        return targets;
    }
    const result = {};
    for (const [language, config] of Object.entries(targets)) {
        switch (language) {
            case "dotnet":
                if (monoConfig?.dotnet != null) {
                    result[language] = {
                        namespace: config.namespace,
                    };
                }
                break;
            case "java":
                if (monoConfig?.java != null) {
                    result[language] = {
                        package: config.package,
                    };
                }
                break;
            case "python":
                if (monoConfig?.python != null) {
                    result[language] = {
                        module: `${monoConfig.python.module}.${config.module.replace(/^aws_prototyping_sdk\./, "")}`,
                    };
                }
                break;
            default:
                throw new Error(`Unsupported language for submodule configuration translation: ${language}`);
        }
    }
    return result;
}
async function copyOrTransformFiles(from, to, libraries, uberPackageJson) {
    const promises = (await fs.readdir(from)).map(async (name) => {
        if (shouldIgnoreFile(name)) {
            return;
        }
        if (name.endsWith(".d.ts") || name.endsWith(".js")) {
            if (await fs.pathExists(path.join(from, name.replace(/\.(d\.ts|js)$/, ".ts")))) {
                // We won't copy .d.ts and .js files with a corresponding .ts file
                return;
            }
        }
        const source = path.join(from, name);
        const destination = path.join(to, name);
        const stat = await fs.stat(source);
        if (stat.isDirectory()) {
            await fs.mkdirp(destination);
            return copyOrTransformFiles(source, destination, libraries, uberPackageJson);
        }
        if (name.endsWith(".ts")) {
            const sourceCode = fs
                .readFileSync(source)
                .toString()
                .replace(/(import .* from ["'])@aws-prototyping-sdk(\/.*['"];)/g, `$1${path.relative(path.dirname(destination), path.join(LIBRARIES_ROOT, "aws-prototyping-sdk"))}$2`);
            return fs.writeFile(destination, sourceCode);
        }
        else {
            return fs.copyFile(source, destination);
        }
    });
    await Promise.all(promises);
}
const IGNORED_FILE_NAMES = new Set([
    ".eslintrc.js",
    ".gitignore",
    ".jest.config.js",
    ".jsii",
    ".env",
    "target",
    "dist",
    "lib",
    "scripts",
    "test",
    ".npmignore",
    "node_modules",
    "package.json",
    "project.json",
    "tsconfig.json",
    "tsconfig.tsbuildinfo",
    "LICENSE",
    "NOTICE",
]);
function shouldIgnoreFile(name) {
    return IGNORED_FILE_NAMES.has(name);
}
/**
 * Resolves the directory where we're going to collect all the libraries.
 *
 * By default, this is purposely the same as the monopackage root so that our
 * two import styles resolve to the same files but it can be overridden by
 * seeting `bundle.libRoot` in the package.json of the uber package.
 *
 * @param uberPackageJson package.json contents of the uber package
 * @returns The directory where we should collect all the libraries.
 */
function resolveLibRoot(uberPackageJson) {
    return path.resolve(uberPackageJson.bundle?.libRoot ?? MONOPACKAGE_ROOT);
}
//# sourceMappingURL=data:application/json;base64,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