## PDK Nag

PDKNag ships with a helper utility that automatically configures CDKNag within your application.

```java
// Example automatically generated from non-compiling source. May contain errors.
Object app = PDKNag.app();
Object stack = new Stack(app, "MyStack");
```

As shown above, this will configure your application to have CDKNag run on synthesis.

By default, CDK will trigger a failure on `synth` if any errors are encountered. To relax these, run the following:

```shell
cdk synth --ignore-errors
```

Conversely, CDK will not fail on synth if warnings are detected. To enforce that all warnings are resolved, run the following command:

```shell
cdk synth --strict
```

### Instrumenting custom NagPacks

By default, when creating a PDKNag application the [AwsSolutions](https://github.com/cdklabs/cdk-nag/blob/main/RULES.md) NagPack is instrumented. In order to specify custom NagPacks to instrument, you can configure the PDKApp as follows:

```java
// Example automatically generated from non-compiling source. May contain errors.
import aws.prototyping.sdk.pdk.nag.PDKNag;
import aws.prototyping.sdk.pdk.nag.AwsPrototypingChecks;

Object app = PDKNag.app(Map.of(
        "nagPacks", List.of(new AwsPrototypingChecks())));
```

In this example, the [AwsPrototypingChecks](https://github.com/aws/aws-prototyping-sdk/blob/mainline/packages/pdk-nag/src/packs/README.md) NagPack has been configured to run instead of the default. Multiple NagPacks can also be instrumented by adding NagPack instances to the `nagPacks` array;
# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### PDKNagApp <a name="PDKNagApp" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp"></a>

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNagApp;

PDKNagApp.Builder.create()
//  .analyticsReporting(java.lang.Boolean)
//  .autoSynth(java.lang.Boolean)
//  .context(java.util.Map<java.lang.String, java.lang.Object>)
//  .defaultStackSynthesizer(IReusableStackSynthesizer)
//  .outdir(java.lang.String)
//  .postCliContext(java.util.Map<java.lang.String, java.lang.Object>)
//  .stackTraces(java.lang.Boolean)
//  .treeMetadata(java.lang.Boolean)
//  .failOnError(java.lang.Boolean)
//  .failOnWarning(java.lang.Boolean)
//  .nagPacks(java.util.List<NagPack>)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.analyticsReporting">analyticsReporting</a></code> | <code>java.lang.Boolean</code> | Include runtime versioning information in the Stacks of this app. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.autoSynth">autoSynth</a></code> | <code>java.lang.Boolean</code> | Automatically call `synth()` before the program exits. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.context">context</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context values for the application. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.defaultStackSynthesizer">defaultStackSynthesizer</a></code> | <code>software.amazon.awscdk.IReusableStackSynthesizer</code> | The stack synthesizer to use by default for all Stacks in the App. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.outdir">outdir</a></code> | <code>java.lang.String</code> | The output directory into which to emit synthesized artifacts. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.postCliContext">postCliContext</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context values for the application. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.stackTraces">stackTraces</a></code> | <code>java.lang.Boolean</code> | Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.treeMetadata">treeMetadata</a></code> | <code>java.lang.Boolean</code> | Include construct tree metadata as part of the Cloud Assembly. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.failOnError">failOnError</a></code> | <code>java.lang.Boolean</code> | Determines whether any errors encountered should trigger a test failure. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.failOnWarning">failOnWarning</a></code> | <code>java.lang.Boolean</code> | Determines whether any warnings encountered should trigger a test failure. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.nagPacks">nagPacks</a></code> | <code>java.util.List<io.github.cdklabs.cdknag.NagPack></code> | Custom nag packs to execute. |

---

##### `analyticsReporting`<sup>Optional</sup> <a name="analyticsReporting" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.analyticsReporting"></a>

- *Type:* java.lang.Boolean
- *Default:* Value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in the Stacks of this app.

---

##### `autoSynth`<sup>Optional</sup> <a name="autoSynth" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.autoSynth"></a>

- *Type:* java.lang.Boolean
- *Default:* true if running via CDK CLI (`CDK_OUTDIR` is set), `false` otherwise

Automatically call `synth()` before the program exits.

If you set this, you don't have to call `synth()` explicitly. Note that
this feature is only available for certain programming languages, and
calling `synth()` is still recommended.

---

##### `context`<sup>Optional</sup> <a name="context" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.context"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context values for the application.

Context set by the CLI or the `context` key in `cdk.json` has precedence.

Context can be read from any construct using `node.getContext(key)`.

---

##### `defaultStackSynthesizer`<sup>Optional</sup> <a name="defaultStackSynthesizer" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.defaultStackSynthesizer"></a>

- *Type:* software.amazon.awscdk.IReusableStackSynthesizer
- *Default:* A `DefaultStackSynthesizer` with default settings

The stack synthesizer to use by default for all Stacks in the App.

The Stack Synthesizer controls aspects of synthesis and deployment,
like how assets are referenced and what IAM roles to use. For more
information, see the README of the main CDK package.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.outdir"></a>

- *Type:* java.lang.String
- *Default:* If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.   If `CDK_OUTDIR` is not defined, uses a temp directory.

The output directory into which to emit synthesized artifacts.

You should never need to set this value. By default, the value you pass to
the CLI's `--output` flag will be used, and if you change it to a different
directory the CLI will fail to pick up the generated Cloud Assembly.

This property is intended for internal and testing use.

---

##### `postCliContext`<sup>Optional</sup> <a name="postCliContext" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.postCliContext"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context values for the application.

Context provided here has precedence over context set by:

- The CLI via --context
- The `context` key in `cdk.json`
- The `AppProps.context` property

This property is recommended over the `AppProps.context` property since you
can make final decision over which context value to take in your app.

Context can be read from any construct using `node.getContext(key)`.

---

*Example*

```java
// context from the CLI and from `cdk.json` are stored in the
// CDK_CONTEXT env variable
const cliContext = JSON.parse(process.env.CDK_CONTEXT!);

// determine whether to take the context passed in the CLI or not
const determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
new App({
  postCliContext: {
    SOMEKEY: determineValue,
  },
});
```


##### `stackTraces`<sup>Optional</sup> <a name="stackTraces" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.stackTraces"></a>

- *Type:* java.lang.Boolean
- *Default:* true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.

Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.

---

##### `treeMetadata`<sup>Optional</sup> <a name="treeMetadata" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.treeMetadata"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include construct tree metadata as part of the Cloud Assembly.

---

##### `failOnError`<sup>Optional</sup> <a name="failOnError" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.failOnError"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Determines whether any errors encountered should trigger a test failure.

---

##### `failOnWarning`<sup>Optional</sup> <a name="failOnWarning" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.failOnWarning"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Determines whether any warnings encountered should trigger a test failure.

---

##### `nagPacks`<sup>Optional</sup> <a name="nagPacks" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.nagPacks"></a>

- *Type:* java.util.List<io.github.cdklabs.cdknag.NagPack>
- *Default:* DEFAULT_NAG_PACKS

Custom nag packs to execute.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.synth">synth</a></code> | Synthesize this stage into a cloud assembly. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.addNagResult">addNagResult</a></code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.nagResults">nagResults</a></code> | Returns a list of NagResult. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.toString"></a>

```java
public java.lang.String toString()
```

Returns a string representation of this construct.

##### `synth` <a name="synth" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.synth"></a>

```java
public CloudAssembly synth()
public CloudAssembly synth(StageSynthesisOptions options)
```

Synthesize this stage into a cloud assembly.

Once an assembly has been synthesized, it cannot be modified. Subsequent
calls will return the same assembly.

###### `options`<sup>Optional</sup> <a name="options" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.synth.parameter.options"></a>

- *Type:* software.amazon.awscdk.StageSynthesisOptions

---

##### `addNagResult` <a name="addNagResult" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.addNagResult"></a>

```java
public void addNagResult(NagResult result)
```

###### `result`<sup>Required</sup> <a name="result" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.addNagResult.parameter.result"></a>

- *Type:* <a href="#@aws-prototyping-sdk/pdk-nag.NagResult">NagResult</a>

---

##### `nagResults` <a name="nagResults" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.nagResults"></a>

```java
public java.util.List<NagResult> nagResults()
```

Returns a list of NagResult.

Note: app.synth() must be called before this to retrieve results.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.isStage">isStage</a></code> | Test whether the given construct is a stage. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.of">of</a></code> | Return the stage this construct is contained with, if available. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.isApp">isApp</a></code> | Checks if an object is an instance of the `App` class. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isConstruct"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNagApp;

PDKNagApp.isConstruct(java.lang.Object x)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isConstruct.parameter.x"></a>

- *Type:* java.lang.Object

Any object.

---

##### `isStage` <a name="isStage" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isStage"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNagApp;

PDKNagApp.isStage(java.lang.Object x)
```

Test whether the given construct is a stage.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isStage.parameter.x"></a>

- *Type:* java.lang.Object

---

##### `of` <a name="of" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.of"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNagApp;

PDKNagApp.of(IConstruct construct)
```

Return the stage this construct is contained with, if available.

If called
on a nested stage, returns its parent.

###### `construct`<sup>Required</sup> <a name="construct" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.of.parameter.construct"></a>

- *Type:* software.constructs.IConstruct

---

##### `isApp` <a name="isApp" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isApp"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNagApp;

PDKNagApp.isApp(java.lang.Object obj)
```

Checks if an object is an instance of the `App` class.

###### `obj`<sup>Required</sup> <a name="obj" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isApp.parameter.obj"></a>

- *Type:* java.lang.Object

The object to evaluate.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.node">node</a></code> | <code>software.constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.artifactId">artifactId</a></code> | <code>java.lang.String</code> | Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.assetOutdir">assetOutdir</a></code> | <code>java.lang.String</code> | The cloud assembly asset output directory. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The cloud assembly output directory. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.stageName">stageName</a></code> | <code>java.lang.String</code> | The name of the stage. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.account">account</a></code> | <code>java.lang.String</code> | The default account for all resources defined within this stage. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.parentStage">parentStage</a></code> | <code>software.amazon.awscdk.Stage</code> | The parent stage or `undefined` if this is the app. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.region">region</a></code> | <code>java.lang.String</code> | The default region for all resources defined within this stage. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.nagPacks">nagPacks</a></code> | <code>java.util.List<io.github.cdklabs.cdknag.NagPack></code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.node"></a>

```java
public Node getNode();
```

- *Type:* software.constructs.Node

The tree node.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.artifactId"></a>

```java
public java.lang.String getArtifactId();
```

- *Type:* java.lang.String

Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string.

Derived from the construct path.

---

##### `assetOutdir`<sup>Required</sup> <a name="assetOutdir" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.assetOutdir"></a>

```java
public java.lang.String getAssetOutdir();
```

- *Type:* java.lang.String

The cloud assembly asset output directory.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String

The cloud assembly output directory.

---

##### `stageName`<sup>Required</sup> <a name="stageName" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.stageName"></a>

```java
public java.lang.String getStageName();
```

- *Type:* java.lang.String

The name of the stage.

Based on names of the parent stages separated by
hypens.

---

##### `account`<sup>Optional</sup> <a name="account" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.account"></a>

```java
public java.lang.String getAccount();
```

- *Type:* java.lang.String

The default account for all resources defined within this stage.

---

##### `parentStage`<sup>Optional</sup> <a name="parentStage" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.parentStage"></a>

```java
public Stage getParentStage();
```

- *Type:* software.amazon.awscdk.Stage

The parent stage or `undefined` if this is the app.

*

---

##### `region`<sup>Optional</sup> <a name="region" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.region"></a>

```java
public java.lang.String getRegion();
```

- *Type:* java.lang.String

The default region for all resources defined within this stage.

---

##### `nagPacks`<sup>Required</sup> <a name="nagPacks" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.nagPacks"></a>

```java
public java.util.List<NagPack> getNagPacks();
```

- *Type:* java.util.List<io.github.cdklabs.cdknag.NagPack>

---


## Structs <a name="Structs" id="Structs"></a>

### Message <a name="Message" id="@aws-prototyping-sdk/pdk-nag.Message"></a>

Message instance.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/pdk-nag.Message.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pdknag.Message;

Message.builder()
    .messageDescription(java.lang.String)
    .messageType(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.Message.property.messageDescription">messageDescription</a></code> | <code>java.lang.String</code> | Message description. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.Message.property.messageType">messageType</a></code> | <code>java.lang.String</code> | Message type as returned from cdk-nag. |

---

##### `messageDescription`<sup>Required</sup> <a name="messageDescription" id="@aws-prototyping-sdk/pdk-nag.Message.property.messageDescription"></a>

```java
public java.lang.String getMessageDescription();
```

- *Type:* java.lang.String

Message description.

---

##### `messageType`<sup>Required</sup> <a name="messageType" id="@aws-prototyping-sdk/pdk-nag.Message.property.messageType"></a>

```java
public java.lang.String getMessageType();
```

- *Type:* java.lang.String

Message type as returned from cdk-nag.

---

### NagResult <a name="NagResult" id="@aws-prototyping-sdk/pdk-nag.NagResult"></a>

Nag result.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/pdk-nag.NagResult.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pdknag.NagResult;

NagResult.builder()
    .messages(java.util.List<Message>)
    .resource(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.NagResult.property.messages">messages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/pdk-nag.Message">Message</a>></code> | List of messages. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.NagResult.property.resource">resource</a></code> | <code>java.lang.String</code> | Resource which triggered the message. |

---

##### `messages`<sup>Required</sup> <a name="messages" id="@aws-prototyping-sdk/pdk-nag.NagResult.property.messages"></a>

```java
public java.util.List<Message> getMessages();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/pdk-nag.Message">Message</a>>

List of messages.

---

##### `resource`<sup>Required</sup> <a name="resource" id="@aws-prototyping-sdk/pdk-nag.NagResult.property.resource"></a>

```java
public java.lang.String getResource();
```

- *Type:* java.lang.String

Resource which triggered the message.

---

### PDKNagAppProps <a name="PDKNagAppProps" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNagAppProps;

PDKNagAppProps.builder()
//  .analyticsReporting(java.lang.Boolean)
//  .autoSynth(java.lang.Boolean)
//  .context(java.util.Map<java.lang.String, java.lang.Object>)
//  .defaultStackSynthesizer(IReusableStackSynthesizer)
//  .outdir(java.lang.String)
//  .postCliContext(java.util.Map<java.lang.String, java.lang.Object>)
//  .stackTraces(java.lang.Boolean)
//  .treeMetadata(java.lang.Boolean)
//  .failOnError(java.lang.Boolean)
//  .failOnWarning(java.lang.Boolean)
//  .nagPacks(java.util.List<NagPack>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.analyticsReporting">analyticsReporting</a></code> | <code>java.lang.Boolean</code> | Include runtime versioning information in the Stacks of this app. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.autoSynth">autoSynth</a></code> | <code>java.lang.Boolean</code> | Automatically call `synth()` before the program exits. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.context">context</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context values for the application. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.defaultStackSynthesizer">defaultStackSynthesizer</a></code> | <code>software.amazon.awscdk.IReusableStackSynthesizer</code> | The stack synthesizer to use by default for all Stacks in the App. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The output directory into which to emit synthesized artifacts. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.postCliContext">postCliContext</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context values for the application. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.stackTraces">stackTraces</a></code> | <code>java.lang.Boolean</code> | Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.treeMetadata">treeMetadata</a></code> | <code>java.lang.Boolean</code> | Include construct tree metadata as part of the Cloud Assembly. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.failOnError">failOnError</a></code> | <code>java.lang.Boolean</code> | Determines whether any errors encountered should trigger a test failure. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.failOnWarning">failOnWarning</a></code> | <code>java.lang.Boolean</code> | Determines whether any warnings encountered should trigger a test failure. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.nagPacks">nagPacks</a></code> | <code>java.util.List<io.github.cdklabs.cdknag.NagPack></code> | Custom nag packs to execute. |

---

##### `analyticsReporting`<sup>Optional</sup> <a name="analyticsReporting" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.analyticsReporting"></a>

```java
public java.lang.Boolean getAnalyticsReporting();
```

- *Type:* java.lang.Boolean
- *Default:* Value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in the Stacks of this app.

---

##### `autoSynth`<sup>Optional</sup> <a name="autoSynth" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.autoSynth"></a>

```java
public java.lang.Boolean getAutoSynth();
```

- *Type:* java.lang.Boolean
- *Default:* true if running via CDK CLI (`CDK_OUTDIR` is set), `false` otherwise

Automatically call `synth()` before the program exits.

If you set this, you don't have to call `synth()` explicitly. Note that
this feature is only available for certain programming languages, and
calling `synth()` is still recommended.

---

##### `context`<sup>Optional</sup> <a name="context" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.context"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getContext();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context values for the application.

Context set by the CLI or the `context` key in `cdk.json` has precedence.

Context can be read from any construct using `node.getContext(key)`.

---

##### `defaultStackSynthesizer`<sup>Optional</sup> <a name="defaultStackSynthesizer" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.defaultStackSynthesizer"></a>

```java
public IReusableStackSynthesizer getDefaultStackSynthesizer();
```

- *Type:* software.amazon.awscdk.IReusableStackSynthesizer
- *Default:* A `DefaultStackSynthesizer` with default settings

The stack synthesizer to use by default for all Stacks in the App.

The Stack Synthesizer controls aspects of synthesis and deployment,
like how assets are referenced and what IAM roles to use. For more
information, see the README of the main CDK package.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String
- *Default:* If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.   If `CDK_OUTDIR` is not defined, uses a temp directory.

The output directory into which to emit synthesized artifacts.

You should never need to set this value. By default, the value you pass to
the CLI's `--output` flag will be used, and if you change it to a different
directory the CLI will fail to pick up the generated Cloud Assembly.

This property is intended for internal and testing use.

---

##### `postCliContext`<sup>Optional</sup> <a name="postCliContext" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.postCliContext"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getPostCliContext();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context values for the application.

Context provided here has precedence over context set by:

- The CLI via --context
- The `context` key in `cdk.json`
- The `AppProps.context` property

This property is recommended over the `AppProps.context` property since you
can make final decision over which context value to take in your app.

Context can be read from any construct using `node.getContext(key)`.

---

*Example*

```java
// context from the CLI and from `cdk.json` are stored in the
// CDK_CONTEXT env variable
const cliContext = JSON.parse(process.env.CDK_CONTEXT!);

// determine whether to take the context passed in the CLI or not
const determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
new App({
  postCliContext: {
    SOMEKEY: determineValue,
  },
});
```


##### `stackTraces`<sup>Optional</sup> <a name="stackTraces" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.stackTraces"></a>

```java
public java.lang.Boolean getStackTraces();
```

- *Type:* java.lang.Boolean
- *Default:* true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.

Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.

---

##### `treeMetadata`<sup>Optional</sup> <a name="treeMetadata" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.treeMetadata"></a>

```java
public java.lang.Boolean getTreeMetadata();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include construct tree metadata as part of the Cloud Assembly.

---

##### `failOnError`<sup>Optional</sup> <a name="failOnError" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.failOnError"></a>

```java
public java.lang.Boolean getFailOnError();
```

- *Type:* java.lang.Boolean
- *Default:* false

Determines whether any errors encountered should trigger a test failure.

---

##### `failOnWarning`<sup>Optional</sup> <a name="failOnWarning" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.failOnWarning"></a>

```java
public java.lang.Boolean getFailOnWarning();
```

- *Type:* java.lang.Boolean
- *Default:* false

Determines whether any warnings encountered should trigger a test failure.

---

##### `nagPacks`<sup>Optional</sup> <a name="nagPacks" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.nagPacks"></a>

```java
public java.util.List<NagPack> getNagPacks();
```

- *Type:* java.util.List<io.github.cdklabs.cdknag.NagPack>
- *Default:* DEFAULT_NAG_PACKS

Custom nag packs to execute.

---

## Classes <a name="Classes" id="Classes"></a>

### AwsPrototypingChecks <a name="AwsPrototypingChecks" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks"></a>

Check best practices for prototypes.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pdknag.AwsPrototypingChecks;

AwsPrototypingChecks.Builder.create()
//  .logIgnores(java.lang.Boolean)
//  .reports(java.lang.Boolean)
//  .suppressionIgnoreCondition(INagSuppressionIgnore)
//  .verbose(java.lang.Boolean)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.logIgnores">logIgnores</a></code> | <code>java.lang.Boolean</code> | Whether or not to log triggered rules that have been suppressed as informational messages (default: false). |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.reports">reports</a></code> | <code>java.lang.Boolean</code> | Whether or not to generate CSV compliance reports for applied Stacks in the App's output directory (default: true). |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.suppressionIgnoreCondition">suppressionIgnoreCondition</a></code> | <code>io.github.cdklabs.cdknag.INagSuppressionIgnore</code> | Conditionally prevent rules from being suppressed (default: no user provided condition). |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.verbose">verbose</a></code> | <code>java.lang.Boolean</code> | Whether or not to enable extended explanatory descriptions on warning, error, and logged ignore messages (default: false). |

---

##### `logIgnores`<sup>Optional</sup> <a name="logIgnores" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.logIgnores"></a>

- *Type:* java.lang.Boolean

Whether or not to log triggered rules that have been suppressed as informational messages (default: false).

---

##### `reports`<sup>Optional</sup> <a name="reports" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.reports"></a>

- *Type:* java.lang.Boolean

Whether or not to generate CSV compliance reports for applied Stacks in the App's output directory (default: true).

---

##### `suppressionIgnoreCondition`<sup>Optional</sup> <a name="suppressionIgnoreCondition" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.suppressionIgnoreCondition"></a>

- *Type:* io.github.cdklabs.cdknag.INagSuppressionIgnore

Conditionally prevent rules from being suppressed (default: no user provided condition).

---

##### `verbose`<sup>Optional</sup> <a name="verbose" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.verbose"></a>

- *Type:* java.lang.Boolean

Whether or not to enable extended explanatory descriptions on warning, error, and logged ignore messages (default: false).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.visit">visit</a></code> | Check if CfnResource and apply rules. |

---

##### `visit` <a name="visit" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.visit"></a>

```java
public void visit(IConstruct node)
```

Check if CfnResource and apply rules.

###### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.visit.parameter.node"></a>

- *Type:* software.constructs.IConstruct

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.property.readPackName">readPackName</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.property.readReportStacks">readReportStacks</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |

---

##### `readPackName`<sup>Required</sup> <a name="readPackName" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.property.readPackName"></a>

```java
public java.lang.String getReadPackName();
```

- *Type:* java.lang.String

---

##### `readReportStacks`<sup>Required</sup> <a name="readReportStacks" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.property.readReportStacks"></a>

```java
public java.util.List<java.lang.String> getReadReportStacks();
```

- *Type:* java.util.List<java.lang.String>

---


### PDKNag <a name="PDKNag" id="@aws-prototyping-sdk/pdk-nag.PDKNag"></a>

Helper for create a Nag Enabled App.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/pdk-nag.PDKNag.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

new PDKNag();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow">addResourceSuppressionsByPathNoThrow</a></code> | Wrapper around NagSuppressions which does not throw. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.app">app</a></code> | Returns an instance of an App with Nag enabled. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.getStackAccountRegex">getStackAccountRegex</a></code> | Returns a stack account regex. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPartitionRegex">getStackPartitionRegex</a></code> | Returns a stack partition regex. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPrefix">getStackPrefix</a></code> | Returns a prefix comprising of a delimited set of Stack Ids. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.getStackRegionRegex">getStackRegionRegex</a></code> | Returns a stack region regex. |

---

##### `addResourceSuppressionsByPathNoThrow` <a name="addResourceSuppressionsByPathNoThrow" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

PDKNag.addResourceSuppressionsByPathNoThrow(Stack stack, java.lang.String path, java.util.List<NagPackSuppression> suppressions),PDKNag.addResourceSuppressionsByPathNoThrow(Stack stack, java.lang.String path, java.util.List<NagPackSuppression> suppressions, java.lang.Boolean applyToChildren)
```

Wrapper around NagSuppressions which does not throw.

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.stack"></a>

- *Type:* software.amazon.awscdk.Stack

stack instance.

---

###### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.path"></a>

- *Type:* java.lang.String

resource path.

---

###### `suppressions`<sup>Required</sup> <a name="suppressions" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.suppressions"></a>

- *Type:* java.util.List<io.github.cdklabs.cdknag.NagPackSuppression>

list of suppressions to apply.

---

###### `applyToChildren`<sup>Optional</sup> <a name="applyToChildren" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.applyToChildren"></a>

- *Type:* java.lang.Boolean

whether to apply to children.

---

##### `app` <a name="app" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

PDKNag.app(),PDKNag.app(PDKNagAppProps props)
```

Returns an instance of an App with Nag enabled.

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps">PDKNagAppProps</a>

props to initialize the app with.

---

##### `getStackAccountRegex` <a name="getStackAccountRegex" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackAccountRegex"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

PDKNag.getStackAccountRegex(Stack stack)
```

Returns a stack account regex.

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackAccountRegex.parameter.stack"></a>

- *Type:* software.amazon.awscdk.Stack

stack instance.

---

##### `getStackPartitionRegex` <a name="getStackPartitionRegex" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPartitionRegex"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

PDKNag.getStackPartitionRegex(Stack stack)
```

Returns a stack partition regex.

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPartitionRegex.parameter.stack"></a>

- *Type:* software.amazon.awscdk.Stack

stack instance.

---

##### `getStackPrefix` <a name="getStackPrefix" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPrefix"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

PDKNag.getStackPrefix(Stack stack)
```

Returns a prefix comprising of a delimited set of Stack Ids.

For example: StackA/NestedStackB/

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPrefix.parameter.stack"></a>

- *Type:* software.amazon.awscdk.Stack

stack instance.

---

##### `getStackRegionRegex` <a name="getStackRegionRegex" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackRegionRegex"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

PDKNag.getStackRegionRegex(Stack stack)
```

Returns a stack region regex.

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackRegionRegex.parameter.stack"></a>

- *Type:* software.amazon.awscdk.Stack

stack instance.

---




