"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Nx = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
var Nx;
(function (Nx) {
    /**
     * Supported enums for a TargetDependency.
     */
    let TargetDependencyProject;
    (function (TargetDependencyProject) {
        /**
         * Only rely on the package where the target is called.
         *
         * This is usually done for test like targets where you only want to run unit
         * tests on the target packages without testing all dependent packages.
         */
        TargetDependencyProject["SELF"] = "self";
        /**
         * Target relies on executing the target against all dependencies first.
         *
         * This is usually done for build like targets where you want to build all
         * dependant projects first.
         */
        TargetDependencyProject["DEPENDENCIES"] = "dependencies";
    })(TargetDependencyProject = Nx.TargetDependencyProject || (Nx.TargetDependencyProject = {}));
})(Nx = exports.Nx || (exports.Nx = {}));
//# sourceMappingURL=data:application/json;base64,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