import { Component, Project } from "projen";
/**
 * Component which manged the project specific NX Config and is added to all NXMonorepo subprojects.
 *
 */
export declare class NxProject extends Component {
    /**
     * Retrieves an instance of NXProject if one is associated to the given project.
     *
     * @param project project instance.
     */
    static of(project: Project): NxProject | undefined;
    /**
     * List of implicit dependencies.
     *
     * @internal
     * @private
     */
    private readonly _implicitDependencies;
    constructor(project: Project);
    /**
     * Adds an implicit dependency between the dependant (this project) and dependee.
     *
     * @param dependee project to add the implicit dependency on.
     */
    addImplicitDependency(dependee: Project | string): void;
    /**
     * Generate a nx block in the package.json if this is a NodeProject. Otherwise generate a project.json with
     * the relevant NX configuration.
     */
    synthesize(): void;
}
