The nx-monorepo package vends a NxMonorepoProject Projen construct that adds [NX](https://nx.dev/getting-started/intro) monorepo support and manages your yarn/npm/pnpm workspaces on your behalf. This construct enables polyglot builds (and inter language build dependencies), build caching, dependency visualization and much, much more.

The PDK itself uses the nx-monorepo project itself and is a good reference for seeing how a complex, polyglot monorepo can be set up.

> **BREAKING CHANGES** (pre-release)
>
> * v0.13.0: `WorkspaceConfig.nxConfig` type `NxConfig => Nx.WorkspaceConfig`, and `overrideProjectTargets` removed in favor of `PDKProject.nx` config to manage Nx project configurations. See [PR 231](https://github.com/aws/aws-prototyping-sdk/pull/231).

To get started simply run the following command in an empty directory:

```bash
npx projen new --from @aws-prototyping-sdk/nx-monorepo
```

This will bootstrap a new Projen monorepo and contain the following in the .projenrc.ts:

```python
# Example automatically generated from non-compiling source. May contain errors.
from aws_prototyping_sdk import nx_monorepo

project = nx_monorepo.NxMonorepoProject(
    default_release_branch="main",
    deps=["aws-cdk-lib", "constructs", "cdk-nag"],
    dev_deps=["aws-prototyping-sdk"],
    name="my-package"
)

project.synth()
```

To add new packages to the monorepo, you can simply add them as a child to the monorepo. To demonstrate, lets add a PDK Pipeline TS Project as a child as follows:

```python
# Example automatically generated from non-compiling source. May contain errors.
from aws_prototyping_sdk import nx_monorepo

project = nx_monorepo.NxMonorepoProject(
    default_release_branch="main",
    deps=["aws-cdk-lib", "constructs", "cdk-nag"],
    dev_deps=["aws-prototyping-sdk"],
    name="my-package"
)

PDKPipelineTsProject(
    parent=project,
    outdir="packages/cicd",
    default_release_branch="mainline",
    name="cicd",
    cdk_version="2.1.0"
)

project.synth()
```

Once added, run `npx projen` from the root directory. You will now notice a new TS package has been created under the packages/cicd path.

Now let's add a python project to the monorepo and add an inter-language build dependency.

```python
# Example automatically generated from non-compiling source. May contain errors.
from aws_prototyping_sdk import nx_monorepo
from aws_prototyping_sdk.pipeline import PDKPipelineTsProject
from projen.python import PythonProject

project = nx_monorepo.NxMonorepoProject(
    default_release_branch="main",
    deps=["aws-cdk-lib", "constructs", "cdk-nag"],
    dev_deps=["aws-prototyping-sdk"],
    name="test"
)

pipeline_project = PDKPipelineTsProject(
    parent=project,
    outdir="packages/cicd",
    default_release_branch="mainline",
    name="cicd",
    cdk_version="2.1.0"
)

# Standard Projen projects also work here
pythonlib = PythonProject(
    parent=project,
    outdir="packages/pythonlib",
    author_email="",
    author_name="",
    module_name="pythonlib",
    name="pythonlib",
    version="0.0.0"
)

# Pipeline project depends on pythonlib to build first
project.add_implicit_dependency(pipeline_project, pythonlib)

project.synth()
```

Run `npx projen` from the root directory. You will now notice a new Python package has been created under packages/pythonlib.

To visualize our dependency graph, run the following command from the root directory: `npx nx graph`.

Now lets test building our project, from the root directory run `npx nx run-many --target=build --nx-bail`. As you can see, the pythonlib was built first followed by the cicd package.

> This is equivalent to running `yarn build`, `pnpm build`, or `npm run build` depending on your node package manager, and similarly `yarn build` also accepts the same [Nx Run-Many options](https://nx.dev/packages/nx/documents/run-many#options) (eg: `yarn build --projects=cicd`).

The NxMonorepoProject also manages your yarn/pnpm workspaces for you and synthesizes these into your package.json pnpm-workspace.yml respectively.

For more information on NX commands, refer to this [documentation](https://nx.dev/using-nx/nx-cli).

### Homogenous Dependencies

As well as adding implicit dependencies, you can add dependencies between projects of the same language in order to have one project consume another project's code.

#### Typescript

Since the `NxMonorepoProject` manages a yarn/npm/pnpm workspace, configuring dependencies between Typescript projects is as straightforward as referencing them in `deps`.

Note that dependencies cannot be added in the same project synthesis (`npx projen`) as when projects are created. This means a two-pass approach is recommended, first to create your new projects, and then to add the dependencies.

For example:

First add your new projects:

```python
# Example automatically generated from non-compiling source. May contain errors.
TypeScriptProject(
    parent=monorepo,
    outdir="packages/a",
    default_release_branch="main",
    name="project-a"
)

TypeScriptProject(
    parent=monorepo,
    outdir="packages/b",
    default_release_branch="main",
    name="project-b"
)
```

Synthesise, then you can set up your dependency:

```python
# Example automatically generated from non-compiling source. May contain errors.
a = TypeScriptProject(
    parent=monorepo,
    outdir="packages/a",
    default_release_branch="main",
    name="project-a"
)

TypeScriptProject(
    parent=monorepo,
    outdir="packages/b",
    default_release_branch="main",
    name="project-b",
    # B depends on A
    deps=[a.package.package_name]
)
```

#### Python

##### Poetry (Recommended)

The recommended way to configure dependencies between python projects within your monorepo is to use Poetry. Poetry sets up separate virtual environments per project but also supports local file dependencies. You can use the monorepo's `addPythonPoetryDependency` method:

```python
# Example automatically generated from non-compiling source. May contain errors.
a = PythonProject(
    parent=monorepo,
    outdir="packages/a",
    module_name="a",
    name="a",
    author_name="jack",
    author_email="me@example.com",
    version="1.0.0",
    poetry=True
)

b = PythonProject(
    parent=monorepo,
    outdir="packages/b",
    module_name="b",
    name="b",
    author_name="jack",
    author_email="me@example.com",
    version="1.0.0",
    poetry=True
)

# b depends on a
monorepo.add_python_poetry_dependency(b, a)
```

##### Pip

If you are using pip for your python projects, you can set up a dependency using a single shared virtual environment. You can then install packages you wish to depend on into that environment using pip's [Editable Installs](https://pip.pypa.io/en/stable/topics/local-project-installs/#editable-installs).

You will also need to add an implicit dependency to tell the monorepo the correct build order for your packages.

For example:

```python
# Example automatically generated from non-compiling source. May contain errors.
shared_env = {
    "envdir": "../../.env"
}

a = PythonProject(
    parent=monorepo,
    outdir="packages/a",
    module_name="a",
    name="a",
    author_name="jack",
    author_email="me@example.com",
    version="1.0.0",
    venv_options=shared_env
)

# Install A into the virtual env since it is consumed by B
a.tasks.try_find("install").exec("pip install --editable .")

b = PythonProject(
    parent=monorepo,
    outdir="packages/b",
    module_name="b",
    name="b",
    author_name="jack",
    author_email="me@example.com",
    version="1.0.0",
    venv_options=shared_env,
    # B depends on A
    deps=[a.module_name]
)

# Add the implicit dependency so that the monorepo will build A before B
monorepo.add_implicit_dependency(b, a)
```

#### Java

The recommended way to configure dependencies between java projects within your monorepo is to use shared maven repositories. The default java project build will already create a distributable in the correct format for a maven repository in its `dist/java` folder, so you can use this as a repository. You can use the monorepo's `addJavaDependency` method:

For example:

```python
# Example automatically generated from non-compiling source. May contain errors.
a = JavaProject(
    parent=monorepo,
    outdir="packages/a",
    group_id="com.mycompany",
    artifact_id="a",
    name="a",
    version="1.0.0"
)

b = JavaProject(
    parent=monorepo,
    outdir="packages/b",
    group_id="com.mycompany",
    artifact_id="b",
    name="b",
    version="1.0.0"
)

# b depends on a
monorepo.add_java_dependency(b, a)
```
# API Reference <a name="API Reference" id="api-reference"></a>


## Structs <a name="Structs" id="Structs"></a>

### MonorepoUpgradeDepsOptions <a name="MonorepoUpgradeDepsOptions" id="@aws-prototyping-sdk/nx-monorepo.MonorepoUpgradeDepsOptions"></a>

Configuration for Monorepo Upgrade Deps task.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.MonorepoUpgradeDepsOptions.Initializer"></a>

```python
import aws_prototyping_sdk.nx_monorepo

aws_prototyping_sdk.nx_monorepo.MonorepoUpgradeDepsOptions(
  syncpack_config: SyncpackConfig = None,
  task_name: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.MonorepoUpgradeDepsOptions.property.syncpackConfig">syncpack_config</a></code> | <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig">SyncpackConfig</a></code> | Syncpack configuration. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.MonorepoUpgradeDepsOptions.property.taskName">task_name</a></code> | <code>str</code> | Name of the task to create. |

---

##### `syncpack_config`<sup>Optional</sup> <a name="syncpack_config" id="@aws-prototyping-sdk/nx-monorepo.MonorepoUpgradeDepsOptions.property.syncpackConfig"></a>

```python
syncpack_config: SyncpackConfig
```

- *Type:* <a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig">SyncpackConfig</a>
- *Default:* SyncpackConfig.DEFAULT_CONFIG

Syncpack configuration.

No merging is performed and as such a complete syncpackConfig is required if supplied.

---

##### `task_name`<sup>Optional</sup> <a name="task_name" id="@aws-prototyping-sdk/nx-monorepo.MonorepoUpgradeDepsOptions.property.taskName"></a>

```python
task_name: str
```

- *Type:* str
- *Default:* upgrade-deps

Name of the task to create.

---

### NamedInputs <a name="NamedInputs" id="@aws-prototyping-sdk/nx-monorepo.Nx.NamedInputs"></a>

Named inputs config.

> [https://nx.dev/reference/nx-json#inputs-&-namedinputs](https://nx.dev/reference/nx-json#inputs-&-namedinputs)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.Nx.NamedInputs.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

Nx.NamedInputs()
```


### NxMonorepoProjectOptions <a name="NxMonorepoProjectOptions" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions"></a>

Configuration options for the NxMonorepoProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.Initializer"></a>

```python
import aws_prototyping_sdk.nx_monorepo

aws_prototyping_sdk.nx_monorepo.NxMonorepoProjectOptions(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  allow_library_dependencies: bool = None,
  author_email: str = None,
  author_name: str = None,
  author_organization: bool = None,
  author_url: str = None,
  auto_detect_bin: bool = None,
  bin: typing.Mapping[str] = None,
  bugs_email: str = None,
  bugs_url: str = None,
  bundled_deps: typing.List[str] = None,
  code_artifact_options: CodeArtifactOptions = None,
  deps: typing.List[str] = None,
  description: str = None,
  dev_deps: typing.List[str] = None,
  entrypoint: str = None,
  homepage: str = None,
  keywords: typing.List[str] = None,
  license: str = None,
  licensed: bool = None,
  max_node_version: str = None,
  min_node_version: str = None,
  npm_access: NpmAccess = None,
  npm_registry: str = None,
  npm_registry_url: str = None,
  npm_token_secret: str = None,
  package_manager: NodePackageManager = None,
  package_name: str = None,
  peer_dependency_options: PeerDependencyOptions = None,
  peer_deps: typing.List[str] = None,
  pnpm_version: str = None,
  repository: str = None,
  repository_directory: str = None,
  scoped_packages_options: typing.List[ScopedPackagesOptions] = None,
  scripts: typing.Mapping[str] = None,
  stability: str = None,
  jsii_release_version: str = None,
  major_version: typing.Union[int, float] = None,
  min_major_version: typing.Union[int, float] = None,
  npm_dist_tag: str = None,
  post_build_steps: typing.List[JobStep] = None,
  prerelease: str = None,
  publish_dry_run: bool = None,
  publish_tasks: bool = None,
  release_branches: typing.Mapping[BranchOptions] = None,
  release_every_commit: bool = None,
  release_failure_issue: bool = None,
  release_failure_issue_label: str = None,
  release_schedule: str = None,
  release_tag_prefix: str = None,
  release_trigger: ReleaseTrigger = None,
  release_workflow_name: str = None,
  release_workflow_setup_steps: typing.List[JobStep] = None,
  versionrc_options: typing.Mapping[typing.Any] = None,
  workflow_container_image: str = None,
  workflow_runs_on: typing.List[str] = None,
  default_release_branch: str,
  artifacts_directory: str = None,
  auto_approve_upgrades: bool = None,
  build_workflow: bool = None,
  build_workflow_triggers: Triggers = None,
  bundler_options: BundlerOptions = None,
  code_cov: bool = None,
  code_cov_token_secret: str = None,
  copyright_owner: str = None,
  copyright_period: str = None,
  dependabot: bool = None,
  dependabot_options: DependabotOptions = None,
  deps_upgrade: bool = None,
  deps_upgrade_options: UpgradeDependenciesOptions = None,
  gitignore: typing.List[str] = None,
  jest: bool = None,
  jest_options: JestOptions = None,
  mutable_build: bool = None,
  npmignore: typing.List[str] = None,
  npmignore_enabled: bool = None,
  npm_ignore_options: IgnoreFileOptions = None,
  package: bool = None,
  prettier: bool = None,
  prettier_options: PrettierOptions = None,
  projen_dev_dependency: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projen_version: str = None,
  pull_request_template: bool = None,
  pull_request_template_contents: typing.List[str] = None,
  release: bool = None,
  release_to_npm: bool = None,
  release_workflow: bool = None,
  workflow_bootstrap_steps: typing.List[JobStep] = None,
  workflow_git_identity: GitIdentity = None,
  workflow_node_version: str = None,
  disable_tsconfig: bool = None,
  disable_tsconfig_dev: bool = None,
  docgen: bool = None,
  docs_directory: str = None,
  entrypoint_types: str = None,
  eslint: bool = None,
  eslint_options: EslintOptions = None,
  libdir: str = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcOptions = None,
  sample_code: bool = None,
  srcdir: str = None,
  testdir: str = None,
  tsconfig: TypescriptConfigOptions = None,
  tsconfig_dev: TypescriptConfigOptions = None,
  tsconfig_dev_file: str = None,
  typescript_version: str = None,
  monorepo_upgrade_deps: bool = None,
  monorepo_upgrade_deps_options: MonorepoUpgradeDepsOptions = None,
  nx_config: WorkspaceConfig = None,
  workspace_config: WorkspaceConfig = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.authorOrganization">author_organization</a></code> | <code>bool</code> | Is the author an organization. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.authorUrl">author_url</a></code> | <code>str</code> | Author's URL / Website. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.autoDetectBin">auto_detect_bin</a></code> | <code>bool</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.bin">bin</a></code> | <code>typing.Mapping[str]</code> | Binary programs vended with your module. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.bugsEmail">bugs_email</a></code> | <code>str</code> | The email address to which issues should be reported. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.bugsUrl">bugs_url</a></code> | <code>str</code> | The url to your project's issue tracker. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.bundledDeps">bundled_deps</a></code> | <code>typing.List[str]</code> | List of dependencies to bundle into this module. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.codeArtifactOptions">code_artifact_options</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.deps">deps</a></code> | <code>typing.List[str]</code> | Runtime dependencies of this module. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.description">description</a></code> | <code>str</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | Build dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.entrypoint">entrypoint</a></code> | <code>str</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.homepage">homepage</a></code> | <code>str</code> | Package's Homepage / Website. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.keywords">keywords</a></code> | <code>typing.List[str]</code> | Keywords to include in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.license">license</a></code> | <code>str</code> | License's SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.licensed">licensed</a></code> | <code>bool</code> | Indicates if a license should be added. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmAccess">npm_access</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmRegistry">npm_registry</a></code> | <code>str</code> | The host name of the npm registry to publish to. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmRegistryUrl">npm_registry_url</a></code> | <code>str</code> | The base URL of the npm package registry. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmTokenSecret">npm_token_secret</a></code> | <code>str</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.packageName">package_name</a></code> | <code>str</code> | The "name" in package.json. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.peerDependencyOptions">peer_dependency_options</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.peerDeps">peer_deps</a></code> | <code>typing.List[str]</code> | Peer dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.pnpmVersion">pnpm_version</a></code> | <code>str</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.repository">repository</a></code> | <code>str</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.repositoryDirectory">repository_directory</a></code> | <code>str</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.scopedPackagesOptions">scoped_packages_options</a></code> | <code>typing.List[projen.javascript.ScopedPackagesOptions]</code> | Options for privately hosted scoped packages. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.scripts">scripts</a></code> | <code>typing.Mapping[str]</code> | npm scripts to include. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.stability">stability</a></code> | <code>str</code> | Package's Stability. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.jsiiReleaseVersion">jsii_release_version</a></code> | <code>str</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.majorVersion">major_version</a></code> | <code>typing.Union[int, float]</code> | Major version to release from the default branch. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.minMajorVersion">min_major_version</a></code> | <code>typing.Union[int, float]</code> | Minimal Major version to release. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmDistTag">npm_dist_tag</a></code> | <code>str</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.postBuildSteps">post_build_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.prerelease">prerelease</a></code> | <code>str</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.publishDryRun">publish_dry_run</a></code> | <code>bool</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.publishTasks">publish_tasks</a></code> | <code>bool</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseBranches">release_branches</a></code> | <code>typing.Mapping[projen.release.BranchOptions]</code> | Defines additional release branches. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseEveryCommit">release_every_commit</a></code> | <code>bool</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseFailureIssue">release_failure_issue</a></code> | <code>bool</code> | Create a github issue on every failed publishing task. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseFailureIssueLabel">release_failure_issue_label</a></code> | <code>str</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseSchedule">release_schedule</a></code> | <code>str</code> | CRON schedule to trigger new releases. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseTagPrefix">release_tag_prefix</a></code> | <code>str</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseTrigger">release_trigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseWorkflowName">release_workflow_name</a></code> | <code>str</code> | The name of the default release workflow. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseWorkflowSetupSteps">release_workflow_setup_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.versionrcOptions">versionrc_options</a></code> | <code>typing.Mapping[typing.Any]</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.workflowContainerImage">workflow_container_image</a></code> | <code>str</code> | Container image to use for GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.workflowRunsOn">workflow_runs_on</a></code> | <code>typing.List[str]</code> | Github Runner selection labels. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.defaultReleaseBranch">default_release_branch</a></code> | <code>str</code> | The name of the main release branch. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | A directory which will contain build artifacts. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.autoApproveUpgrades">auto_approve_upgrades</a></code> | <code>bool</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.buildWorkflow">build_workflow</a></code> | <code>bool</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.buildWorkflowTriggers">build_workflow_triggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.bundlerOptions">bundler_options</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.codeCov">code_cov</a></code> | <code>bool</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.codeCovTokenSecret">code_cov_token_secret</a></code> | <code>str</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.copyrightOwner">copyright_owner</a></code> | <code>str</code> | License copyright owner. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.copyrightPeriod">copyright_period</a></code> | <code>str</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.dependabot">dependabot</a></code> | <code>bool</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.dependabotOptions">dependabot_options</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.depsUpgrade">deps_upgrade</a></code> | <code>bool</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.depsUpgradeOptions">deps_upgrade_options</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.gitignore">gitignore</a></code> | <code>typing.List[str]</code> | Additional entries to .gitignore. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.jest">jest</a></code> | <code>bool</code> | Setup jest unit tests. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.jestOptions">jest_options</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.mutableBuild">mutable_build</a></code> | <code>bool</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmignore">npmignore</a></code> | <code>typing.List[str]</code> | Additional entries to .npmignore. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmignoreEnabled">npmignore_enabled</a></code> | <code>bool</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmIgnoreOptions">npm_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.package">package</a></code> | <code>bool</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.prettier">prettier</a></code> | <code>bool</code> | Setup prettier. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.prettierOptions">prettier_options</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenDevDependency">projen_dev_dependency</a></code> | <code>bool</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenVersion">projen_version</a></code> | <code>str</code> | Version of projen to install. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.pullRequestTemplate">pull_request_template</a></code> | <code>bool</code> | Include a GitHub pull request template. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.pullRequestTemplateContents">pull_request_template_contents</a></code> | <code>typing.List[str]</code> | The contents of the pull request template. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.release">release</a></code> | <code>bool</code> | Add release management to this project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseToNpm">release_to_npm</a></code> | <code>bool</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseWorkflow">release_workflow</a></code> | <code>bool</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.workflowBootstrapSteps">workflow_bootstrap_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.workflowGitIdentity">workflow_git_identity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.workflowNodeVersion">workflow_node_version</a></code> | <code>str</code> | The node version to use in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.disableTsconfig">disable_tsconfig</a></code> | <code>bool</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.disableTsconfigDev">disable_tsconfig_dev</a></code> | <code>bool</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.docgen">docgen</a></code> | <code>bool</code> | Docgen by Typedoc. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.docsDirectory">docs_directory</a></code> | <code>str</code> | Docs directory. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.entrypointTypes">entrypoint_types</a></code> | <code>str</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.eslint">eslint</a></code> | <code>bool</code> | Setup eslint. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.eslintOptions">eslint_options</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.libdir">libdir</a></code> | <code>str</code> | Typescript  artifacts output directory. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.sampleCode">sample_code</a></code> | <code>bool</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.srcdir">srcdir</a></code> | <code>str</code> | Typescript sources directory. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.testdir">testdir</a></code> | <code>str</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.tsconfigDevFile">tsconfig_dev_file</a></code> | <code>str</code> | The name of the development tsconfig.json file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.typescriptVersion">typescript_version</a></code> | <code>str</code> | TypeScript version to use. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDeps">monorepo_upgrade_deps</a></code> | <code>bool</code> | Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDepsOptions">monorepo_upgrade_deps_options</a></code> | <code><a href="#@aws-prototyping-sdk/nx-monorepo.MonorepoUpgradeDepsOptions">MonorepoUpgradeDepsOptions</a></code> | Monorepo Upgrade Deps options. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.nxConfig">nx_config</a></code> | <code>aws_prototyping_sdk.Nx.WorkspaceConfig</code> | Configuration for NX. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.workspaceConfig">workspace_config</a></code> | <code><a href="#@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig">WorkspaceConfig</a></code> | Configuration for workspace. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.name"></a>

```python
name: str
```

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.gitIgnoreOptions"></a>

```python
git_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.gitOptions"></a>

```python
git_options: GitOptions
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.logging"></a>

```python
logging: LoggerOptions
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenrcJson"></a>

```python
projenrc_json: bool
```

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenrcJsonOptions"></a>

```python
projenrc_json_options: ProjenrcJsonOptions
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.renovatebot"></a>

```python
renovatebot: bool
```

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.renovatebotOptions"></a>

```python
renovatebot_options: RenovatebotOptions
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.autoApproveOptions"></a>

```python
auto_approve_options: AutoApproveOptions
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.autoMerge"></a>

```python
auto_merge: bool
```

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.autoMergeOptions"></a>

```python
auto_merge_options: AutoMergeOptions
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.clobber"></a>

```python
clobber: bool
```

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.devContainer"></a>

```python
dev_container: bool
```

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.github"></a>

```python
github: bool
```

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.githubOptions"></a>

```python
github_options: GitHubOptions
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.gitpod"></a>

```python
gitpod: bool
```

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```python
mergify: bool
```

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```python
mergify_options: MergifyOptions
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenCredentials"></a>

```python
projen_credentials: GithubCredentials
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```python
projen_token_secret: str
```

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.readme"></a>

```python
readme: SampleReadmeProps
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.stale"></a>

```python
stale: bool
```

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.staleOptions"></a>

```python
stale_options: StaleOptions
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.vscode"></a>

```python
vscode: bool
```

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allow_library_dependencies`<sup>Optional</sup> <a name="allow_library_dependencies" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.allowLibraryDependencies"></a>

```python
allow_library_dependencies: bool
```

- *Type:* bool
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `author_email`<sup>Optional</sup> <a name="author_email" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.authorEmail"></a>

```python
author_email: str
```

- *Type:* str

Author's e-mail.

---

##### `author_name`<sup>Optional</sup> <a name="author_name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.authorName"></a>

```python
author_name: str
```

- *Type:* str

Author's name.

---

##### `author_organization`<sup>Optional</sup> <a name="author_organization" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.authorOrganization"></a>

```python
author_organization: bool
```

- *Type:* bool

Is the author an organization.

---

##### `author_url`<sup>Optional</sup> <a name="author_url" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.authorUrl"></a>

```python
author_url: str
```

- *Type:* str

Author's URL / Website.

---

##### `auto_detect_bin`<sup>Optional</sup> <a name="auto_detect_bin" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.autoDetectBin"></a>

```python
auto_detect_bin: bool
```

- *Type:* bool
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.bin"></a>

```python
bin: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugs_email`<sup>Optional</sup> <a name="bugs_email" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.bugsEmail"></a>

```python
bugs_email: str
```

- *Type:* str

The email address to which issues should be reported.

---

##### `bugs_url`<sup>Optional</sup> <a name="bugs_url" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.bugsUrl"></a>

```python
bugs_url: str
```

- *Type:* str

The url to your project's issue tracker.

---

##### `bundled_deps`<sup>Optional</sup> <a name="bundled_deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.bundledDeps"></a>

```python
bundled_deps: typing.List[str]
```

- *Type:* typing.List[str]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `code_artifact_options`<sup>Optional</sup> <a name="code_artifact_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.codeArtifactOptions"></a>

```python
code_artifact_options: CodeArtifactOptions
```

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.deps"></a>

```python
deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.description"></a>

```python
description: str
```

- *Type:* str

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.devDeps"></a>

```python
dev_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.entrypoint"></a>

```python
entrypoint: str
```

- *Type:* str
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.homepage"></a>

```python
homepage: str
```

- *Type:* str

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.keywords"></a>

```python
keywords: typing.List[str]
```

- *Type:* typing.List[str]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.license"></a>

```python
license: str
```

- *Type:* str
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.licensed"></a>

```python
licensed: bool
```

- *Type:* bool
- *Default:* true

Indicates if a license should be added.

---

##### `max_node_version`<sup>Optional</sup> <a name="max_node_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.maxNodeVersion"></a>

```python
max_node_version: str
```

- *Type:* str
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `min_node_version`<sup>Optional</sup> <a name="min_node_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.minNodeVersion"></a>

```python
min_node_version: str
```

- *Type:* str
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npm_access`<sup>Optional</sup> <a name="npm_access" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmAccess"></a>

```python
npm_access: NpmAccess
```

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npm_registry`~~<sup>Optional</sup> <a name="npm_registry" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```python
npm_registry: str
```

- *Type:* str

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npm_registry_url`<sup>Optional</sup> <a name="npm_registry_url" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmRegistryUrl"></a>

```python
npm_registry_url: str
```

- *Type:* str
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npm_token_secret`<sup>Optional</sup> <a name="npm_token_secret" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmTokenSecret"></a>

```python
npm_token_secret: str
```

- *Type:* str
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `package_manager`<sup>Optional</sup> <a name="package_manager" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.packageManager"></a>

```python
package_manager: NodePackageManager
```

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.packageName"></a>

```python
package_name: str
```

- *Type:* str
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peer_dependency_options`<sup>Optional</sup> <a name="peer_dependency_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.peerDependencyOptions"></a>

```python
peer_dependency_options: PeerDependencyOptions
```

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peer_deps`<sup>Optional</sup> <a name="peer_deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.peerDeps"></a>

```python
peer_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpm_version`<sup>Optional</sup> <a name="pnpm_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.pnpmVersion"></a>

```python
pnpm_version: str
```

- *Type:* str
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.repository"></a>

```python
repository: str
```

- *Type:* str

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repository_directory`<sup>Optional</sup> <a name="repository_directory" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.repositoryDirectory"></a>

```python
repository_directory: str
```

- *Type:* str

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scoped_packages_options`<sup>Optional</sup> <a name="scoped_packages_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.scopedPackagesOptions"></a>

```python
scoped_packages_options: typing.List[ScopedPackagesOptions]
```

- *Type:* typing.List[projen.javascript.ScopedPackagesOptions]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```python
scripts: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.stability"></a>

```python
stability: str
```

- *Type:* str

Package's Stability.

---

##### `jsii_release_version`<sup>Optional</sup> <a name="jsii_release_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.jsiiReleaseVersion"></a>

```python
jsii_release_version: str
```

- *Type:* str
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `major_version`<sup>Optional</sup> <a name="major_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.majorVersion"></a>

```python
major_version: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `min_major_version`<sup>Optional</sup> <a name="min_major_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.minMajorVersion"></a>

```python
min_major_version: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npm_dist_tag`<sup>Optional</sup> <a name="npm_dist_tag" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmDistTag"></a>

```python
npm_dist_tag: str
```

- *Type:* str
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `post_build_steps`<sup>Optional</sup> <a name="post_build_steps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.postBuildSteps"></a>

```python
post_build_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.prerelease"></a>

```python
prerelease: str
```

- *Type:* str
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publish_dry_run`<sup>Optional</sup> <a name="publish_dry_run" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.publishDryRun"></a>

```python
publish_dry_run: bool
```

- *Type:* bool
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publish_tasks`<sup>Optional</sup> <a name="publish_tasks" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.publishTasks"></a>

```python
publish_tasks: bool
```

- *Type:* bool
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `release_branches`<sup>Optional</sup> <a name="release_branches" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseBranches"></a>

```python
release_branches: typing.Mapping[BranchOptions]
```

- *Type:* typing.Mapping[projen.release.BranchOptions]
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`release_every_commit`~~<sup>Optional</sup> <a name="release_every_commit" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```python
release_every_commit: bool
```

- *Type:* bool
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `release_failure_issue`<sup>Optional</sup> <a name="release_failure_issue" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseFailureIssue"></a>

```python
release_failure_issue: bool
```

- *Type:* bool
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `release_failure_issue_label`<sup>Optional</sup> <a name="release_failure_issue_label" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseFailureIssueLabel"></a>

```python
release_failure_issue_label: str
```

- *Type:* str
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`release_schedule`~~<sup>Optional</sup> <a name="release_schedule" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```python
release_schedule: str
```

- *Type:* str
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `release_tag_prefix`<sup>Optional</sup> <a name="release_tag_prefix" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseTagPrefix"></a>

```python
release_tag_prefix: str
```

- *Type:* str
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `release_trigger`<sup>Optional</sup> <a name="release_trigger" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseTrigger"></a>

```python
release_trigger: ReleaseTrigger
```

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `release_workflow_name`<sup>Optional</sup> <a name="release_workflow_name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseWorkflowName"></a>

```python
release_workflow_name: str
```

- *Type:* str
- *Default:* "Release"

The name of the default release workflow.

---

##### `release_workflow_setup_steps`<sup>Optional</sup> <a name="release_workflow_setup_steps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseWorkflowSetupSteps"></a>

```python
release_workflow_setup_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrc_options`<sup>Optional</sup> <a name="versionrc_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.versionrcOptions"></a>

```python
versionrc_options: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflow_container_image`<sup>Optional</sup> <a name="workflow_container_image" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.workflowContainerImage"></a>

```python
workflow_container_image: str
```

- *Type:* str
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflow_runs_on`<sup>Optional</sup> <a name="workflow_runs_on" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.workflowRunsOn"></a>

```python
workflow_runs_on: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `default_release_branch`<sup>Required</sup> <a name="default_release_branch" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.defaultReleaseBranch"></a>

```python
default_release_branch: str
```

- *Type:* str
- *Default:* "main"

The name of the main release branch.

---

##### `artifacts_directory`<sup>Optional</sup> <a name="artifacts_directory" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.artifactsDirectory"></a>

```python
artifacts_directory: str
```

- *Type:* str
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `auto_approve_upgrades`<sup>Optional</sup> <a name="auto_approve_upgrades" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.autoApproveUpgrades"></a>

```python
auto_approve_upgrades: bool
```

- *Type:* bool
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `build_workflow`<sup>Optional</sup> <a name="build_workflow" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.buildWorkflow"></a>

```python
build_workflow: bool
```

- *Type:* bool
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `build_workflow_triggers`<sup>Optional</sup> <a name="build_workflow_triggers" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.buildWorkflowTriggers"></a>

```python
build_workflow_triggers: Triggers
```

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundler_options`<sup>Optional</sup> <a name="bundler_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.bundlerOptions"></a>

```python
bundler_options: BundlerOptions
```

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `code_cov`<sup>Optional</sup> <a name="code_cov" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.codeCov"></a>

```python
code_cov: bool
```

- *Type:* bool
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret.

---

##### `code_cov_token_secret`<sup>Optional</sup> <a name="code_cov_token_secret" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.codeCovTokenSecret"></a>

```python
code_cov_token_secret: str
```

- *Type:* str
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyright_owner`<sup>Optional</sup> <a name="copyright_owner" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.copyrightOwner"></a>

```python
copyright_owner: str
```

- *Type:* str
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyright_period`<sup>Optional</sup> <a name="copyright_period" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.copyrightPeriod"></a>

```python
copyright_period: str
```

- *Type:* str
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.dependabot"></a>

```python
dependabot: bool
```

- *Type:* bool
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabot_options`<sup>Optional</sup> <a name="dependabot_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.dependabotOptions"></a>

```python
dependabot_options: DependabotOptions
```

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `deps_upgrade`<sup>Optional</sup> <a name="deps_upgrade" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.depsUpgrade"></a>

```python
deps_upgrade: bool
```

- *Type:* bool
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `deps_upgrade_options`<sup>Optional</sup> <a name="deps_upgrade_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.depsUpgradeOptions"></a>

```python
deps_upgrade_options: UpgradeDependenciesOptions
```

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.gitignore"></a>

```python
gitignore: typing.List[str]
```

- *Type:* typing.List[str]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.jest"></a>

```python
jest: bool
```

- *Type:* bool
- *Default:* true

Setup jest unit tests.

---

##### `jest_options`<sup>Optional</sup> <a name="jest_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.jestOptions"></a>

```python
jest_options: JestOptions
```

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutable_build`<sup>Optional</sup> <a name="mutable_build" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.mutableBuild"></a>

```python
mutable_build: bool
```

- *Type:* bool
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```python
npmignore: typing.List[str]
```

- *Type:* typing.List[str]

Additional entries to .npmignore.

---

##### `npmignore_enabled`<sup>Optional</sup> <a name="npmignore_enabled" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmignoreEnabled"></a>

```python
npmignore_enabled: bool
```

- *Type:* bool
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npm_ignore_options`<sup>Optional</sup> <a name="npm_ignore_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.npmIgnoreOptions"></a>

```python
npm_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.package"></a>

```python
package: bool
```

- *Type:* bool
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.prettier"></a>

```python
prettier: bool
```

- *Type:* bool
- *Default:* false

Setup prettier.

---

##### `prettier_options`<sup>Optional</sup> <a name="prettier_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.prettierOptions"></a>

```python
prettier_options: PrettierOptions
```

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projen_dev_dependency`<sup>Optional</sup> <a name="projen_dev_dependency" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenDevDependency"></a>

```python
projen_dev_dependency: bool
```

- *Type:* bool
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenrcJs"></a>

```python
projenrc_js: bool
```

- *Type:* bool
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenrcJsOptions"></a>

```python
projenrc_js_options: ProjenrcOptions
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projen_version`<sup>Optional</sup> <a name="projen_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenVersion"></a>

```python
projen_version: str
```

- *Type:* str
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pull_request_template`<sup>Optional</sup> <a name="pull_request_template" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.pullRequestTemplate"></a>

```python
pull_request_template: bool
```

- *Type:* bool
- *Default:* true

Include a GitHub pull request template.

---

##### `pull_request_template_contents`<sup>Optional</sup> <a name="pull_request_template_contents" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.pullRequestTemplateContents"></a>

```python
pull_request_template_contents: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.release"></a>

```python
release: bool
```

- *Type:* bool
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `release_to_npm`<sup>Optional</sup> <a name="release_to_npm" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseToNpm"></a>

```python
release_to_npm: bool
```

- *Type:* bool
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`release_workflow`~~<sup>Optional</sup> <a name="release_workflow" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```python
release_workflow: bool
```

- *Type:* bool
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflow_bootstrap_steps`<sup>Optional</sup> <a name="workflow_bootstrap_steps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.workflowBootstrapSteps"></a>

```python
workflow_bootstrap_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflow_git_identity`<sup>Optional</sup> <a name="workflow_git_identity" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.workflowGitIdentity"></a>

```python
workflow_git_identity: GitIdentity
```

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflow_node_version`<sup>Optional</sup> <a name="workflow_node_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.workflowNodeVersion"></a>

```python
workflow_node_version: str
```

- *Type:* str
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `disable_tsconfig`<sup>Optional</sup> <a name="disable_tsconfig" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.disableTsconfig"></a>

```python
disable_tsconfig: bool
```

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disable_tsconfig_dev`<sup>Optional</sup> <a name="disable_tsconfig_dev" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.disableTsconfigDev"></a>

```python
disable_tsconfig_dev: bool
```

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.docgen"></a>

```python
docgen: bool
```

- *Type:* bool
- *Default:* false

Docgen by Typedoc.

---

##### `docs_directory`<sup>Optional</sup> <a name="docs_directory" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.docsDirectory"></a>

```python
docs_directory: str
```

- *Type:* str
- *Default:* "docs"

Docs directory.

---

##### `entrypoint_types`<sup>Optional</sup> <a name="entrypoint_types" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.entrypointTypes"></a>

```python
entrypoint_types: str
```

- *Type:* str
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.eslint"></a>

```python
eslint: bool
```

- *Type:* bool
- *Default:* true

Setup eslint.

---

##### `eslint_options`<sup>Optional</sup> <a name="eslint_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.eslintOptions"></a>

```python
eslint_options: EslintOptions
```

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.libdir"></a>

```python
libdir: str
```

- *Type:* str
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenrcTs"></a>

```python
projenrc_ts: bool
```

- *Type:* bool
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.projenrcTsOptions"></a>

```python
projenrc_ts_options: ProjenrcOptions
```

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sample_code`<sup>Optional</sup> <a name="sample_code" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.sampleCode"></a>

```python
sample_code: bool
```

- *Type:* bool
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.srcdir"></a>

```python
srcdir: str
```

- *Type:* str
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.testdir"></a>

```python
testdir: str
```

- *Type:* str
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.tsconfig"></a>

```python
tsconfig: TypescriptConfigOptions
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfig_dev`<sup>Optional</sup> <a name="tsconfig_dev" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.tsconfigDev"></a>

```python
tsconfig_dev: TypescriptConfigOptions
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfig_dev_file`<sup>Optional</sup> <a name="tsconfig_dev_file" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.tsconfigDevFile"></a>

```python
tsconfig_dev_file: str
```

- *Type:* str
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescript_version`<sup>Optional</sup> <a name="typescript_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.typescriptVersion"></a>

```python
typescript_version: str
```

- *Type:* str
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `monorepo_upgrade_deps`<sup>Optional</sup> <a name="monorepo_upgrade_deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDeps"></a>

```python
monorepo_upgrade_deps: bool
```

- *Type:* bool
- *Default:* true

Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies.

---

##### `monorepo_upgrade_deps_options`<sup>Optional</sup> <a name="monorepo_upgrade_deps_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDepsOptions"></a>

```python
monorepo_upgrade_deps_options: MonorepoUpgradeDepsOptions
```

- *Type:* <a href="#@aws-prototyping-sdk/nx-monorepo.MonorepoUpgradeDepsOptions">MonorepoUpgradeDepsOptions</a>
- *Default:* undefined

Monorepo Upgrade Deps options.

This is only used if monorepoUpgradeDeps is true.

---

##### `nx_config`<sup>Optional</sup> <a name="nx_config" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.nxConfig"></a>

```python
nx_config: WorkspaceConfig
```

- *Type:* aws_prototyping_sdk.Nx.WorkspaceConfig

Configuration for NX.

---

##### `workspace_config`<sup>Optional</sup> <a name="workspace_config" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProjectOptions.property.workspaceConfig"></a>

```python
workspace_config: WorkspaceConfig
```

- *Type:* <a href="#@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig">WorkspaceConfig</a>

Configuration for workspace.

---

### NxRunManyOptions <a name="NxRunManyOptions" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions"></a>

> [https://nx.dev/packages/nx/documents/run-many#options](https://nx.dev/packages/nx/documents/run-many#options)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.Initializer"></a>

```python
import aws_prototyping_sdk.nx_monorepo

aws_prototyping_sdk.nx_monorepo.NxRunManyOptions(
  target: str,
  configuration: str = None,
  exclude: str = None,
  ignore_cycles: bool = None,
  no_bail: bool = None,
  output_style: str = None,
  parallel: typing.Union[int, float] = None,
  projects: typing.List[str] = None,
  runner: str = None,
  skip_cache: bool = None,
  verbose: bool = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.target">target</a></code> | <code>str</code> | Task to run for affected projects. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.configuration">configuration</a></code> | <code>str</code> | This is the configuration to use when performing tasks on projects. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.exclude">exclude</a></code> | <code>str</code> | Exclude certain projects from being processed. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.ignoreCycles">ignore_cycles</a></code> | <code>bool</code> | Ignore cycles in the task graph. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.noBail">no_bail</a></code> | <code>bool</code> | Do not stop command execution after the first failed task. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.outputStyle">output_style</a></code> | <code>str</code> | Defines how Nx emits outputs tasks logs. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.parallel">parallel</a></code> | <code>typing.Union[int, float]</code> | Max number of parallel processes. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.projects">projects</a></code> | <code>typing.List[str]</code> | Project to run as list project names and/or patterns. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.runner">runner</a></code> | <code>str</code> | This is the name of the tasks runner configuration in nx.json. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.skipCache">skip_cache</a></code> | <code>bool</code> | Rerun the tasks even when the results are available in the cache. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.verbose">verbose</a></code> | <code>bool</code> | Prints additional information about the commands (e.g. stack traces). |

---

##### `target`<sup>Required</sup> <a name="target" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.target"></a>

```python
target: str
```

- *Type:* str

Task to run for affected projects.

---

##### `configuration`<sup>Optional</sup> <a name="configuration" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.configuration"></a>

```python
configuration: str
```

- *Type:* str

This is the configuration to use when performing tasks on projects.

---

##### `exclude`<sup>Optional</sup> <a name="exclude" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.exclude"></a>

```python
exclude: str
```

- *Type:* str

Exclude certain projects from being processed.

---

##### `ignore_cycles`<sup>Optional</sup> <a name="ignore_cycles" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.ignoreCycles"></a>

```python
ignore_cycles: bool
```

- *Type:* bool

Ignore cycles in the task graph.

---

##### `no_bail`<sup>Optional</sup> <a name="no_bail" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.noBail"></a>

```python
no_bail: bool
```

- *Type:* bool

Do not stop command execution after the first failed task.

---

##### `output_style`<sup>Optional</sup> <a name="output_style" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.outputStyle"></a>

```python
output_style: str
```

- *Type:* str
- *Default:* "stream"

Defines how Nx emits outputs tasks logs.

---

##### `parallel`<sup>Optional</sup> <a name="parallel" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.parallel"></a>

```python
parallel: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* 3

Max number of parallel processes.

---

##### `projects`<sup>Optional</sup> <a name="projects" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.projects"></a>

```python
projects: typing.List[str]
```

- *Type:* typing.List[str]

Project to run as list project names and/or patterns.

---

##### `runner`<sup>Optional</sup> <a name="runner" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.runner"></a>

```python
runner: str
```

- *Type:* str

This is the name of the tasks runner configuration in nx.json.

---

##### `skip_cache`<sup>Optional</sup> <a name="skip_cache" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.skipCache"></a>

```python
skip_cache: bool
```

- *Type:* bool

Rerun the tasks even when the results are available in the cache.

---

##### `verbose`<sup>Optional</sup> <a name="verbose" id="@aws-prototyping-sdk/nx-monorepo.NxRunManyOptions.property.verbose"></a>

```python
verbose: bool
```

- *Type:* bool

Prints additional information about the commands (e.g. stack traces).

---

### ProjectConfig <a name="ProjectConfig" id="@aws-prototyping-sdk/nx-monorepo.Nx.ProjectConfig"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.Nx.ProjectConfig.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

Nx.ProjectConfig(
  implicit_dependencies: typing.List[str] = None,
  included_scripts: typing.List[str] = None,
  named_inputs: NamedInputs = None,
  tags: typing.List[str] = None,
  targets: typing.Mapping[ProjectTarget] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.ProjectConfig.property.implicitDependencies">implicit_dependencies</a></code> | <code>typing.List[str]</code> | Implicit dependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.ProjectConfig.property.includedScripts">included_scripts</a></code> | <code>typing.List[str]</code> | Explicit list of scripts for Nx to include. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.ProjectConfig.property.namedInputs">named_inputs</a></code> | <code>aws_prototyping_sdk.Nx.NamedInputs</code> | Named inputs. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.ProjectConfig.property.tags">tags</a></code> | <code>typing.List[str]</code> | Project tag annotations. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.ProjectConfig.property.targets">targets</a></code> | <code>typing.Mapping[aws_prototyping_sdk.Nx.ProjectTarget]</code> | Targets configuration. |

---

##### `implicit_dependencies`<sup>Optional</sup> <a name="implicit_dependencies" id="@aws-prototyping-sdk/nx-monorepo.Nx.ProjectConfig.property.implicitDependencies"></a>

```python
implicit_dependencies: typing.List[str]
```

- *Type:* typing.List[str]

Implicit dependencies.

> [https://nx.dev/reference/project-configuration#implicitdependencies](https://nx.dev/reference/project-configuration#implicitdependencies)

---

##### `included_scripts`<sup>Optional</sup> <a name="included_scripts" id="@aws-prototyping-sdk/nx-monorepo.Nx.ProjectConfig.property.includedScripts"></a>

```python
included_scripts: typing.List[str]
```

- *Type:* typing.List[str]

Explicit list of scripts for Nx to include.

> [https://nx.dev/reference/project-configuration#ignoring-package.json-scripts](https://nx.dev/reference/project-configuration#ignoring-package.json-scripts)

---

##### `named_inputs`<sup>Optional</sup> <a name="named_inputs" id="@aws-prototyping-sdk/nx-monorepo.Nx.ProjectConfig.property.namedInputs"></a>

```python
named_inputs: NamedInputs
```

- *Type:* aws_prototyping_sdk.Nx.NamedInputs

Named inputs.

> [https://nx.dev/reference/nx-json#inputs-&-namedinputs](https://nx.dev/reference/nx-json#inputs-&-namedinputs)

---

##### `tags`<sup>Optional</sup> <a name="tags" id="@aws-prototyping-sdk/nx-monorepo.Nx.ProjectConfig.property.tags"></a>

```python
tags: typing.List[str]
```

- *Type:* typing.List[str]

Project tag annotations.

> [https://nx.dev/reference/project-configuration#tags](https://nx.dev/reference/project-configuration#tags)

---

##### `targets`<sup>Optional</sup> <a name="targets" id="@aws-prototyping-sdk/nx-monorepo.Nx.ProjectConfig.property.targets"></a>

```python
targets: typing.Mapping[ProjectTarget]
```

- *Type:* typing.Mapping[aws_prototyping_sdk.Nx.ProjectTarget]

Targets configuration.

> [https://nx.dev/reference/project-configuration](https://nx.dev/reference/project-configuration)

---

### ProjectTarget <a name="ProjectTarget" id="@aws-prototyping-sdk/nx-monorepo.Nx.ProjectTarget"></a>

Project Target.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.Nx.ProjectTarget.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

Nx.ProjectTarget(
  depends_on: typing.List[TargetDependency] = None,
  inputs: typing.List[str] = None,
  outputs: typing.List[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.ProjectTarget.property.dependsOn">depends_on</a></code> | <code>typing.List[aws_prototyping_sdk.Nx.TargetDependency]</code> | List of Target Dependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.ProjectTarget.property.inputs">inputs</a></code> | <code>typing.List[str]</code> | List of inputs to hash for cache key, relative to the root of the monorepo. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.ProjectTarget.property.outputs">outputs</a></code> | <code>typing.List[str]</code> | List of outputs to cache, relative to the root of the monorepo. |

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@aws-prototyping-sdk/nx-monorepo.Nx.ProjectTarget.property.dependsOn"></a>

```python
depends_on: typing.List[TargetDependency]
```

- *Type:* typing.List[aws_prototyping_sdk.Nx.TargetDependency]

List of Target Dependencies.

---

##### `inputs`<sup>Optional</sup> <a name="inputs" id="@aws-prototyping-sdk/nx-monorepo.Nx.ProjectTarget.property.inputs"></a>

```python
inputs: typing.List[str]
```

- *Type:* typing.List[str]

List of inputs to hash for cache key, relative to the root of the monorepo.

note: must start with leading /

---

##### `outputs`<sup>Optional</sup> <a name="outputs" id="@aws-prototyping-sdk/nx-monorepo.Nx.ProjectTarget.property.outputs"></a>

```python
outputs: typing.List[str]
```

- *Type:* typing.List[str]

List of outputs to cache, relative to the root of the monorepo.

note: must start with leading /

---

### SemverGroup <a name="SemverGroup" id="@aws-prototyping-sdk/nx-monorepo.SemverGroup"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.SemverGroup.Initializer"></a>

```python
import aws_prototyping_sdk.nx_monorepo

aws_prototyping_sdk.nx_monorepo.SemverGroup(
  dependencies: typing.List[str],
  packages: typing.List[str],
  range: str,
  dependency_types: typing.List[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SemverGroup.property.dependencies">dependencies</a></code> | <code>typing.List[str]</code> | the names of the dependencies (eg. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SemverGroup.property.packages">packages</a></code> | <code>typing.List[str]</code> | the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SemverGroup.property.range">range</a></code> | <code>str</code> | the semver range which dependencies in this group should use. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SemverGroup.property.dependencyTypes">dependency_types</a></code> | <code>typing.List[str]</code> | optionally only apply this group to dependencies of the provided types. |

---

##### `dependencies`<sup>Required</sup> <a name="dependencies" id="@aws-prototyping-sdk/nx-monorepo.SemverGroup.property.dependencies"></a>

```python
dependencies: typing.List[str]
```

- *Type:* typing.List[str]

the names of the dependencies (eg.

"lodash") which belong to this group

---

##### `packages`<sup>Required</sup> <a name="packages" id="@aws-prototyping-sdk/nx-monorepo.SemverGroup.property.packages"></a>

```python
packages: typing.List[str]
```

- *Type:* typing.List[str]

the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name.

---

##### `range`<sup>Required</sup> <a name="range" id="@aws-prototyping-sdk/nx-monorepo.SemverGroup.property.range"></a>

```python
range: str
```

- *Type:* str

the semver range which dependencies in this group should use.

---

##### `dependency_types`<sup>Optional</sup> <a name="dependency_types" id="@aws-prototyping-sdk/nx-monorepo.SemverGroup.property.dependencyTypes"></a>

```python
dependency_types: typing.List[str]
```

- *Type:* typing.List[str]

optionally only apply this group to dependencies of the provided types.

---

### SyncpackConfig <a name="SyncpackConfig" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.Initializer"></a>

```python
import aws_prototyping_sdk.nx_monorepo

aws_prototyping_sdk.nx_monorepo.SyncpackConfig(
  dependency_types: typing.List[str],
  dev: bool,
  filter: str,
  indent: str,
  overrides: bool,
  peer: bool,
  pnpm_overrides: bool,
  prod: bool,
  resolutions: bool,
  semver_groups: typing.List[SemverGroup],
  semver_range: str,
  sort_az: typing.List[str],
  sort_first: typing.List[str],
  source: typing.List[str],
  version_groups: typing.List[VersionGroup],
  workspace: bool
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.dependencyTypes">dependency_types</a></code> | <code>typing.List[str]</code> | which dependency properties to search within. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.dev">dev</a></code> | <code>bool</code> | whether to search within devDependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.filter">filter</a></code> | <code>str</code> | a string which will be passed to `new RegExp()` to match against package names that should be included. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.indent">indent</a></code> | <code>str</code> | the character(s) to be used to indent your package.json files when writing to disk. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.overrides">overrides</a></code> | <code>bool</code> | whether to search within npm overrides. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.peer">peer</a></code> | <code>bool</code> | whether to search within peerDependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.pnpmOverrides">pnpm_overrides</a></code> | <code>bool</code> | whether to search within pnpm overrides. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.prod">prod</a></code> | <code>bool</code> | whether to search within dependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.resolutions">resolutions</a></code> | <code>bool</code> | whether to search within yarn resolutions. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.semverGroups">semver_groups</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/nx-monorepo.SemverGroup">SemverGroup</a>]</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.semverRange">semver_range</a></code> | <code>str</code> | defaults to `""` to ensure that exact dependency versions are used instead of loose ranges. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.sortAz">sort_az</a></code> | <code>typing.List[str]</code> | which fields within package.json files should be sorted alphabetically. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.sortFirst">sort_first</a></code> | <code>typing.List[str]</code> | which fields within package.json files should appear at the top, and in what order. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.source">source</a></code> | <code>typing.List[str]</code> | glob patterns for package.json file locations. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.versionGroups">version_groups</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/nx-monorepo.VersionGroup">VersionGroup</a>]</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.workspace">workspace</a></code> | <code>bool</code> | whether to include the versions of the `--source` packages developed in your workspace/monorepo as part of the search for versions to sync. |

---

##### `dependency_types`<sup>Required</sup> <a name="dependency_types" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.dependencyTypes"></a>

```python
dependency_types: typing.List[str]
```

- *Type:* typing.List[str]

which dependency properties to search within.

---

##### `dev`<sup>Required</sup> <a name="dev" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.dev"></a>

```python
dev: bool
```

- *Type:* bool

whether to search within devDependencies.

---

##### `filter`<sup>Required</sup> <a name="filter" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.filter"></a>

```python
filter: str
```

- *Type:* str

a string which will be passed to `new RegExp()` to match against package names that should be included.

---

##### `indent`<sup>Required</sup> <a name="indent" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.indent"></a>

```python
indent: str
```

- *Type:* str

the character(s) to be used to indent your package.json files when writing to disk.

---

##### `overrides`<sup>Required</sup> <a name="overrides" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.overrides"></a>

```python
overrides: bool
```

- *Type:* bool

whether to search within npm overrides.

---

##### `peer`<sup>Required</sup> <a name="peer" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.peer"></a>

```python
peer: bool
```

- *Type:* bool

whether to search within peerDependencies.

---

##### `pnpm_overrides`<sup>Required</sup> <a name="pnpm_overrides" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.pnpmOverrides"></a>

```python
pnpm_overrides: bool
```

- *Type:* bool

whether to search within pnpm overrides.

---

##### `prod`<sup>Required</sup> <a name="prod" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.prod"></a>

```python
prod: bool
```

- *Type:* bool

whether to search within dependencies.

---

##### `resolutions`<sup>Required</sup> <a name="resolutions" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.resolutions"></a>

```python
resolutions: bool
```

- *Type:* bool

whether to search within yarn resolutions.

---

##### `semver_groups`<sup>Required</sup> <a name="semver_groups" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.semverGroups"></a>

```python
semver_groups: typing.List[SemverGroup]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/nx-monorepo.SemverGroup">SemverGroup</a>]

---

##### `semver_range`<sup>Required</sup> <a name="semver_range" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.semverRange"></a>

```python
semver_range: str
```

- *Type:* str

defaults to `""` to ensure that exact dependency versions are used instead of loose ranges.

---

##### `sort_az`<sup>Required</sup> <a name="sort_az" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.sortAz"></a>

```python
sort_az: typing.List[str]
```

- *Type:* typing.List[str]

which fields within package.json files should be sorted alphabetically.

---

##### `sort_first`<sup>Required</sup> <a name="sort_first" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.sortFirst"></a>

```python
sort_first: typing.List[str]
```

- *Type:* typing.List[str]

which fields within package.json files should appear at the top, and in what order.

---

##### `source`<sup>Required</sup> <a name="source" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.source"></a>

```python
source: typing.List[str]
```

- *Type:* typing.List[str]

glob patterns for package.json file locations.

---

##### `version_groups`<sup>Required</sup> <a name="version_groups" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.versionGroups"></a>

```python
version_groups: typing.List[VersionGroup]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/nx-monorepo.VersionGroup">VersionGroup</a>]

---

##### `workspace`<sup>Required</sup> <a name="workspace" id="@aws-prototyping-sdk/nx-monorepo.SyncpackConfig.property.workspace"></a>

```python
workspace: bool
```

- *Type:* bool

whether to include the versions of the `--source` packages developed in your workspace/monorepo as part of the search for versions to sync.

---

### TargetDefaults <a name="TargetDefaults" id="@aws-prototyping-sdk/nx-monorepo.Nx.TargetDefaults"></a>

Target defaults config.

> [https://nx.dev/reference/nx-json#target-defaults](https://nx.dev/reference/nx-json#target-defaults)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.Nx.TargetDefaults.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

Nx.TargetDefaults()
```


### TargetDependency <a name="TargetDependency" id="@aws-prototyping-sdk/nx-monorepo.Nx.TargetDependency"></a>

Represents an NX Target Dependency.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.Nx.TargetDependency.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

Nx.TargetDependency(
  projects: TargetDependencyProject,
  target: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.TargetDependency.property.projects">projects</a></code> | <code>aws_prototyping_sdk.Nx.TargetDependencyProject</code> | Target dependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.TargetDependency.property.target">target</a></code> | <code>str</code> | Projen target i.e: build, test, etc. |

---

##### `projects`<sup>Required</sup> <a name="projects" id="@aws-prototyping-sdk/nx-monorepo.Nx.TargetDependency.property.projects"></a>

```python
projects: TargetDependencyProject
```

- *Type:* aws_prototyping_sdk.Nx.TargetDependencyProject

Target dependencies.

---

##### `target`<sup>Required</sup> <a name="target" id="@aws-prototyping-sdk/nx-monorepo.Nx.TargetDependency.property.target"></a>

```python
target: str
```

- *Type:* str

Projen target i.e: build, test, etc.

---

### VersionGroup <a name="VersionGroup" id="@aws-prototyping-sdk/nx-monorepo.VersionGroup"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.VersionGroup.Initializer"></a>

```python
import aws_prototyping_sdk.nx_monorepo

aws_prototyping_sdk.nx_monorepo.VersionGroup(
  dependencies: typing.List[str],
  packages: typing.List[str],
  dependency_types: typing.List[str] = None,
  is_banned: bool = None,
  pin_version: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.VersionGroup.property.dependencies">dependencies</a></code> | <code>typing.List[str]</code> | the names of the dependencies (eg. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.VersionGroup.property.packages">packages</a></code> | <code>typing.List[str]</code> | the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.VersionGroup.property.dependencyTypes">dependency_types</a></code> | <code>typing.List[str]</code> | optionally only apply this group to dependencies of the provided types. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.VersionGroup.property.isBanned">is_banned</a></code> | <code>bool</code> | optionally force all dependencies in this group to be removed. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.VersionGroup.property.pinVersion">pin_version</a></code> | <code>str</code> | optionally force all dependencies in this group to have this version. |

---

##### `dependencies`<sup>Required</sup> <a name="dependencies" id="@aws-prototyping-sdk/nx-monorepo.VersionGroup.property.dependencies"></a>

```python
dependencies: typing.List[str]
```

- *Type:* typing.List[str]

the names of the dependencies (eg.

"lodash") which belong to this group

---

##### `packages`<sup>Required</sup> <a name="packages" id="@aws-prototyping-sdk/nx-monorepo.VersionGroup.property.packages"></a>

```python
packages: typing.List[str]
```

- *Type:* typing.List[str]

the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name.

---

##### `dependency_types`<sup>Optional</sup> <a name="dependency_types" id="@aws-prototyping-sdk/nx-monorepo.VersionGroup.property.dependencyTypes"></a>

```python
dependency_types: typing.List[str]
```

- *Type:* typing.List[str]

optionally only apply this group to dependencies of the provided types.

---

##### `is_banned`<sup>Optional</sup> <a name="is_banned" id="@aws-prototyping-sdk/nx-monorepo.VersionGroup.property.isBanned"></a>

```python
is_banned: bool
```

- *Type:* bool

optionally force all dependencies in this group to be removed.

---

##### `pin_version`<sup>Optional</sup> <a name="pin_version" id="@aws-prototyping-sdk/nx-monorepo.VersionGroup.property.pinVersion"></a>

```python
pin_version: str
```

- *Type:* str

optionally force all dependencies in this group to have this version.

---

### WorkspaceConfig <a name="WorkspaceConfig" id="@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig"></a>

Workspace configurations.

> [https://classic.yarnpkg.com/lang/en/docs/workspaces/](https://classic.yarnpkg.com/lang/en/docs/workspaces/)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig.Initializer"></a>

```python
import aws_prototyping_sdk.nx_monorepo

aws_prototyping_sdk.nx_monorepo.WorkspaceConfig(
  additional_packages: typing.List[str] = None,
  disable_no_hoist_bundled: bool = None,
  link_local_workspace_bins: bool = None,
  no_hoist: typing.List[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig.property.additionalPackages">additional_packages</a></code> | <code>typing.List[str]</code> | List of additional package globs to include in the workspace. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig.property.disableNoHoistBundled">disable_no_hoist_bundled</a></code> | <code>bool</code> | Disable automatically applying `noHoist` logic for all sub-project "bundledDependencies". |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig.property.linkLocalWorkspaceBins">link_local_workspace_bins</a></code> | <code>bool</code> | Links all local workspace project bins so they can be used for local development. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig.property.noHoist">no_hoist</a></code> | <code>typing.List[str]</code> | List of package globs to exclude from hoisting in the workspace. |

---

##### `additional_packages`<sup>Optional</sup> <a name="additional_packages" id="@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig.property.additionalPackages"></a>

```python
additional_packages: typing.List[str]
```

- *Type:* typing.List[str]

List of additional package globs to include in the workspace.

All packages which are parented by the monorepo are automatically added to the workspace, but you can use this
property to specify any additional paths to packages which may not be managed by projen.

---

##### `disable_no_hoist_bundled`<sup>Optional</sup> <a name="disable_no_hoist_bundled" id="@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig.property.disableNoHoistBundled"></a>

```python
disable_no_hoist_bundled: bool
```

- *Type:* bool
- *Default:* false

Disable automatically applying `noHoist` logic for all sub-project "bundledDependencies".

---

##### `link_local_workspace_bins`<sup>Optional</sup> <a name="link_local_workspace_bins" id="@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig.property.linkLocalWorkspaceBins"></a>

```python
link_local_workspace_bins: bool
```

- *Type:* bool

Links all local workspace project bins so they can be used for local development.

Package bins are only linked when installed from the registry, however it is very useful
for monorepo development to also utilize these bin scripts. When enabled, this flag will
recursively link all bins from packages.json files to the root node_modules/.bin.

---

##### `no_hoist`<sup>Optional</sup> <a name="no_hoist" id="@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig.property.noHoist"></a>

```python
no_hoist: typing.List[str]
```

- *Type:* typing.List[str]

List of package globs to exclude from hoisting in the workspace.

> [https://classic.yarnpkg.com/blog/2018/02/15/nohoist/](https://classic.yarnpkg.com/blog/2018/02/15/nohoist/)

---

### WorkspaceConfig <a name="WorkspaceConfig" id="@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig"></a>

NX workspace configurations.

> [https://nx.dev/configuration/packagejson](https://nx.dev/configuration/packagejson)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

Nx.WorkspaceConfig(
  affected_branch: str = None,
  cacheable_operations: typing.List[str] = None,
  named_inputs: NamedInputs = None,
  nx_cloud_read_only_access_token: str = None,
  nx_ignore: typing.List[str] = None,
  target_defaults: TargetDefaults = None,
  target_dependencies: typing.Mapping[typing.List[TargetDependency]] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.affectedBranch">affected_branch</a></code> | <code>str</code> | Affected branch. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.cacheableOperations">cacheable_operations</a></code> | <code>typing.List[str]</code> | Defines the list of targets/operations that are cached by Nx. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.namedInputs">named_inputs</a></code> | <code>aws_prototyping_sdk.Nx.NamedInputs</code> | Named inputs. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.nxCloudReadOnlyAccessToken">nx_cloud_read_only_access_token</a></code> | <code>str</code> | Read only access token if enabling nx cloud. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.nxIgnore">nx_ignore</a></code> | <code>typing.List[str]</code> | List of patterns to include in the .nxignore file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.targetDefaults">target_defaults</a></code> | <code>aws_prototyping_sdk.Nx.TargetDefaults</code> | Target defaults. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.targetDependencies">target_dependencies</a></code> | <code>typing.Mapping[typing.List[aws_prototyping_sdk.Nx.TargetDependency]]</code> | Configuration for TargetDependencies. |

---

##### `affected_branch`<sup>Optional</sup> <a name="affected_branch" id="@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.affectedBranch"></a>

```python
affected_branch: str
```

- *Type:* str
- *Default:* mainline

Affected branch.

---

##### `cacheable_operations`<sup>Optional</sup> <a name="cacheable_operations" id="@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.cacheableOperations"></a>

```python
cacheable_operations: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* ["build", "test"]

Defines the list of targets/operations that are cached by Nx.

> [https://nx.dev/reference/nx-json#tasks-runner-options](https://nx.dev/reference/nx-json#tasks-runner-options)

---

##### `named_inputs`<sup>Optional</sup> <a name="named_inputs" id="@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.namedInputs"></a>

```python
named_inputs: NamedInputs
```

- *Type:* aws_prototyping_sdk.Nx.NamedInputs

Named inputs.

> [https://nx.dev/reference/nx-json#inputs-&-namedinputs](https://nx.dev/reference/nx-json#inputs-&-namedinputs)

---

##### `nx_cloud_read_only_access_token`<sup>Optional</sup> <a name="nx_cloud_read_only_access_token" id="@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.nxCloudReadOnlyAccessToken"></a>

```python
nx_cloud_read_only_access_token: str
```

- *Type:* str

Read only access token if enabling nx cloud.

---

##### `nx_ignore`<sup>Optional</sup> <a name="nx_ignore" id="@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.nxIgnore"></a>

```python
nx_ignore: typing.List[str]
```

- *Type:* typing.List[str]

List of patterns to include in the .nxignore file.

> [https://nx.dev/configuration/packagejson#nxignore](https://nx.dev/configuration/packagejson#nxignore)

---

##### `target_defaults`<sup>Optional</sup> <a name="target_defaults" id="@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.targetDefaults"></a>

```python
target_defaults: TargetDefaults
```

- *Type:* aws_prototyping_sdk.Nx.TargetDefaults

Target defaults.

> [https://nx.dev/reference/nx-json#target-defaults](https://nx.dev/reference/nx-json#target-defaults)

---

##### `target_dependencies`<sup>Optional</sup> <a name="target_dependencies" id="@aws-prototyping-sdk/nx-monorepo.Nx.WorkspaceConfig.property.targetDependencies"></a>

```python
target_dependencies: typing.Mapping[typing.List[TargetDependency]]
```

- *Type:* typing.Mapping[typing.List[aws_prototyping_sdk.Nx.TargetDependency]]

Configuration for TargetDependencies.

> [https://nx.dev/configuration/packagejson#target-dependencies](https://nx.dev/configuration/packagejson#target-dependencies)

---

## Classes <a name="Classes" id="Classes"></a>

### NxMonorepoProject <a name="NxMonorepoProject" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject"></a>

This project type will bootstrap a NX based monorepo with support for polygot builds, build caching, dependency graph visualization and much more.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer"></a>

```python
import aws_prototyping_sdk.nx_monorepo

aws_prototyping_sdk.nx_monorepo.NxMonorepoProject(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  allow_library_dependencies: bool = None,
  author_email: str = None,
  author_name: str = None,
  author_organization: bool = None,
  author_url: str = None,
  auto_detect_bin: bool = None,
  bin: typing.Mapping[str] = None,
  bugs_email: str = None,
  bugs_url: str = None,
  bundled_deps: typing.List[str] = None,
  code_artifact_options: CodeArtifactOptions = None,
  deps: typing.List[str] = None,
  description: str = None,
  dev_deps: typing.List[str] = None,
  entrypoint: str = None,
  homepage: str = None,
  keywords: typing.List[str] = None,
  license: str = None,
  licensed: bool = None,
  max_node_version: str = None,
  min_node_version: str = None,
  npm_access: NpmAccess = None,
  npm_registry: str = None,
  npm_registry_url: str = None,
  npm_token_secret: str = None,
  package_manager: NodePackageManager = None,
  package_name: str = None,
  peer_dependency_options: PeerDependencyOptions = None,
  peer_deps: typing.List[str] = None,
  pnpm_version: str = None,
  repository: str = None,
  repository_directory: str = None,
  scoped_packages_options: typing.List[ScopedPackagesOptions] = None,
  scripts: typing.Mapping[str] = None,
  stability: str = None,
  jsii_release_version: str = None,
  major_version: typing.Union[int, float] = None,
  min_major_version: typing.Union[int, float] = None,
  npm_dist_tag: str = None,
  post_build_steps: typing.List[JobStep] = None,
  prerelease: str = None,
  publish_dry_run: bool = None,
  publish_tasks: bool = None,
  release_branches: typing.Mapping[BranchOptions] = None,
  release_every_commit: bool = None,
  release_failure_issue: bool = None,
  release_failure_issue_label: str = None,
  release_schedule: str = None,
  release_tag_prefix: str = None,
  release_trigger: ReleaseTrigger = None,
  release_workflow_name: str = None,
  release_workflow_setup_steps: typing.List[JobStep] = None,
  versionrc_options: typing.Mapping[typing.Any] = None,
  workflow_container_image: str = None,
  workflow_runs_on: typing.List[str] = None,
  default_release_branch: str,
  artifacts_directory: str = None,
  auto_approve_upgrades: bool = None,
  build_workflow: bool = None,
  build_workflow_triggers: Triggers = None,
  bundler_options: BundlerOptions = None,
  code_cov: bool = None,
  code_cov_token_secret: str = None,
  copyright_owner: str = None,
  copyright_period: str = None,
  dependabot: bool = None,
  dependabot_options: DependabotOptions = None,
  deps_upgrade: bool = None,
  deps_upgrade_options: UpgradeDependenciesOptions = None,
  gitignore: typing.List[str] = None,
  jest: bool = None,
  jest_options: JestOptions = None,
  mutable_build: bool = None,
  npmignore: typing.List[str] = None,
  npmignore_enabled: bool = None,
  npm_ignore_options: IgnoreFileOptions = None,
  package: bool = None,
  prettier: bool = None,
  prettier_options: PrettierOptions = None,
  projen_dev_dependency: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projen_version: str = None,
  pull_request_template: bool = None,
  pull_request_template_contents: typing.List[str] = None,
  release: bool = None,
  release_to_npm: bool = None,
  release_workflow: bool = None,
  workflow_bootstrap_steps: typing.List[JobStep] = None,
  workflow_git_identity: GitIdentity = None,
  workflow_node_version: str = None,
  disable_tsconfig: bool = None,
  disable_tsconfig_dev: bool = None,
  docgen: bool = None,
  docs_directory: str = None,
  entrypoint_types: str = None,
  eslint: bool = None,
  eslint_options: EslintOptions = None,
  libdir: str = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcOptions = None,
  sample_code: bool = None,
  srcdir: str = None,
  testdir: str = None,
  tsconfig: TypescriptConfigOptions = None,
  tsconfig_dev: TypescriptConfigOptions = None,
  tsconfig_dev_file: str = None,
  typescript_version: str = None,
  monorepo_upgrade_deps: bool = None,
  monorepo_upgrade_deps_options: MonorepoUpgradeDepsOptions = None,
  nx_config: WorkspaceConfig = None,
  workspace_config: WorkspaceConfig = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.authorOrganization">author_organization</a></code> | <code>bool</code> | Is the author an organization. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.authorUrl">author_url</a></code> | <code>str</code> | Author's URL / Website. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.autoDetectBin">auto_detect_bin</a></code> | <code>bool</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.bin">bin</a></code> | <code>typing.Mapping[str]</code> | Binary programs vended with your module. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.bugsEmail">bugs_email</a></code> | <code>str</code> | The email address to which issues should be reported. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.bugsUrl">bugs_url</a></code> | <code>str</code> | The url to your project's issue tracker. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.bundledDeps">bundled_deps</a></code> | <code>typing.List[str]</code> | List of dependencies to bundle into this module. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.codeArtifactOptions">code_artifact_options</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.deps">deps</a></code> | <code>typing.List[str]</code> | Runtime dependencies of this module. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.description">description</a></code> | <code>str</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | Build dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.entrypoint">entrypoint</a></code> | <code>str</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.homepage">homepage</a></code> | <code>str</code> | Package's Homepage / Website. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.keywords">keywords</a></code> | <code>typing.List[str]</code> | Keywords to include in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.license">license</a></code> | <code>str</code> | License's SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.licensed">licensed</a></code> | <code>bool</code> | Indicates if a license should be added. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmAccess">npm_access</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmRegistry">npm_registry</a></code> | <code>str</code> | The host name of the npm registry to publish to. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmRegistryUrl">npm_registry_url</a></code> | <code>str</code> | The base URL of the npm package registry. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmTokenSecret">npm_token_secret</a></code> | <code>str</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.packageName">package_name</a></code> | <code>str</code> | The "name" in package.json. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.peerDependencyOptions">peer_dependency_options</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.peerDeps">peer_deps</a></code> | <code>typing.List[str]</code> | Peer dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.pnpmVersion">pnpm_version</a></code> | <code>str</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.repository">repository</a></code> | <code>str</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.repositoryDirectory">repository_directory</a></code> | <code>str</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.scopedPackagesOptions">scoped_packages_options</a></code> | <code>typing.List[projen.javascript.ScopedPackagesOptions]</code> | Options for privately hosted scoped packages. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.scripts">scripts</a></code> | <code>typing.Mapping[str]</code> | npm scripts to include. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.stability">stability</a></code> | <code>str</code> | Package's Stability. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.jsiiReleaseVersion">jsii_release_version</a></code> | <code>str</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.majorVersion">major_version</a></code> | <code>typing.Union[int, float]</code> | Major version to release from the default branch. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.minMajorVersion">min_major_version</a></code> | <code>typing.Union[int, float]</code> | Minimal Major version to release. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmDistTag">npm_dist_tag</a></code> | <code>str</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.postBuildSteps">post_build_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.prerelease">prerelease</a></code> | <code>str</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.publishDryRun">publish_dry_run</a></code> | <code>bool</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.publishTasks">publish_tasks</a></code> | <code>bool</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseBranches">release_branches</a></code> | <code>typing.Mapping[projen.release.BranchOptions]</code> | Defines additional release branches. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseEveryCommit">release_every_commit</a></code> | <code>bool</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseFailureIssue">release_failure_issue</a></code> | <code>bool</code> | Create a github issue on every failed publishing task. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseFailureIssueLabel">release_failure_issue_label</a></code> | <code>str</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseSchedule">release_schedule</a></code> | <code>str</code> | CRON schedule to trigger new releases. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseTagPrefix">release_tag_prefix</a></code> | <code>str</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseTrigger">release_trigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflowName">release_workflow_name</a></code> | <code>str</code> | The name of the default release workflow. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflowSetupSteps">release_workflow_setup_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.versionrcOptions">versionrc_options</a></code> | <code>typing.Mapping[typing.Any]</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.workflowContainerImage">workflow_container_image</a></code> | <code>str</code> | Container image to use for GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.workflowRunsOn">workflow_runs_on</a></code> | <code>typing.List[str]</code> | Github Runner selection labels. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.defaultReleaseBranch">default_release_branch</a></code> | <code>str</code> | The name of the main release branch. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | A directory which will contain build artifacts. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.autoApproveUpgrades">auto_approve_upgrades</a></code> | <code>bool</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.buildWorkflow">build_workflow</a></code> | <code>bool</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.buildWorkflowTriggers">build_workflow_triggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.bundlerOptions">bundler_options</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.codeCov">code_cov</a></code> | <code>bool</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.codeCovTokenSecret">code_cov_token_secret</a></code> | <code>str</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.copyrightOwner">copyright_owner</a></code> | <code>str</code> | License copyright owner. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.copyrightPeriod">copyright_period</a></code> | <code>str</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.dependabot">dependabot</a></code> | <code>bool</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.dependabotOptions">dependabot_options</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.depsUpgrade">deps_upgrade</a></code> | <code>bool</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.depsUpgradeOptions">deps_upgrade_options</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.gitignore">gitignore</a></code> | <code>typing.List[str]</code> | Additional entries to .gitignore. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.jest">jest</a></code> | <code>bool</code> | Setup jest unit tests. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.jestOptions">jest_options</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.mutableBuild">mutable_build</a></code> | <code>bool</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmignore">npmignore</a></code> | <code>typing.List[str]</code> | Additional entries to .npmignore. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmignoreEnabled">npmignore_enabled</a></code> | <code>bool</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmIgnoreOptions">npm_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.package">package</a></code> | <code>bool</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.prettier">prettier</a></code> | <code>bool</code> | Setup prettier. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.prettierOptions">prettier_options</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenDevDependency">projen_dev_dependency</a></code> | <code>bool</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenVersion">projen_version</a></code> | <code>str</code> | Version of projen to install. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.pullRequestTemplate">pull_request_template</a></code> | <code>bool</code> | Include a GitHub pull request template. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.pullRequestTemplateContents">pull_request_template_contents</a></code> | <code>typing.List[str]</code> | The contents of the pull request template. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.release">release</a></code> | <code>bool</code> | Add release management to this project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseToNpm">release_to_npm</a></code> | <code>bool</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflow">release_workflow</a></code> | <code>bool</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.workflowBootstrapSteps">workflow_bootstrap_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.workflowGitIdentity">workflow_git_identity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.workflowNodeVersion">workflow_node_version</a></code> | <code>str</code> | The node version to use in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.disableTsconfig">disable_tsconfig</a></code> | <code>bool</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.disableTsconfigDev">disable_tsconfig_dev</a></code> | <code>bool</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.docgen">docgen</a></code> | <code>bool</code> | Docgen by Typedoc. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.docsDirectory">docs_directory</a></code> | <code>str</code> | Docs directory. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.entrypointTypes">entrypoint_types</a></code> | <code>str</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.eslint">eslint</a></code> | <code>bool</code> | Setup eslint. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.eslintOptions">eslint_options</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.libdir">libdir</a></code> | <code>str</code> | Typescript  artifacts output directory. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.sampleCode">sample_code</a></code> | <code>bool</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.srcdir">srcdir</a></code> | <code>str</code> | Typescript sources directory. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.testdir">testdir</a></code> | <code>str</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.tsconfigDevFile">tsconfig_dev_file</a></code> | <code>str</code> | The name of the development tsconfig.json file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.typescriptVersion">typescript_version</a></code> | <code>str</code> | TypeScript version to use. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.monorepoUpgradeDeps">monorepo_upgrade_deps</a></code> | <code>bool</code> | Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.monorepoUpgradeDepsOptions">monorepo_upgrade_deps_options</a></code> | <code><a href="#@aws-prototyping-sdk/nx-monorepo.MonorepoUpgradeDepsOptions">MonorepoUpgradeDepsOptions</a></code> | Monorepo Upgrade Deps options. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.nxConfig">nx_config</a></code> | <code>aws_prototyping_sdk.Nx.WorkspaceConfig</code> | Configuration for NX. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.workspaceConfig">workspace_config</a></code> | <code><a href="#@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig">WorkspaceConfig</a></code> | Configuration for workspace. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.name"></a>

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.commitGenerated"></a>

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.gitOptions"></a>

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.logging"></a>

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.outdir"></a>

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.parent"></a>

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenCommand"></a>

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenrcJson"></a>

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.renovatebot"></a>

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.autoMerge"></a>

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.clobber"></a>

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.devContainer"></a>

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.github"></a>

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.githubOptions"></a>

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.gitpod"></a>

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenCredentials"></a>

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.readme"></a>

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.stale"></a>

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.staleOptions"></a>

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.vscode"></a>

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allow_library_dependencies`<sup>Optional</sup> <a name="allow_library_dependencies" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.allowLibraryDependencies"></a>

- *Type:* bool
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `author_email`<sup>Optional</sup> <a name="author_email" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.authorEmail"></a>

- *Type:* str

Author's e-mail.

---

##### `author_name`<sup>Optional</sup> <a name="author_name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.authorName"></a>

- *Type:* str

Author's name.

---

##### `author_organization`<sup>Optional</sup> <a name="author_organization" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.authorOrganization"></a>

- *Type:* bool

Is the author an organization.

---

##### `author_url`<sup>Optional</sup> <a name="author_url" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.authorUrl"></a>

- *Type:* str

Author's URL / Website.

---

##### `auto_detect_bin`<sup>Optional</sup> <a name="auto_detect_bin" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.autoDetectBin"></a>

- *Type:* bool
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.bin"></a>

- *Type:* typing.Mapping[str]

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugs_email`<sup>Optional</sup> <a name="bugs_email" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.bugsEmail"></a>

- *Type:* str

The email address to which issues should be reported.

---

##### `bugs_url`<sup>Optional</sup> <a name="bugs_url" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.bugsUrl"></a>

- *Type:* str

The url to your project's issue tracker.

---

##### `bundled_deps`<sup>Optional</sup> <a name="bundled_deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.bundledDeps"></a>

- *Type:* typing.List[str]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `code_artifact_options`<sup>Optional</sup> <a name="code_artifact_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.codeArtifactOptions"></a>

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.deps"></a>

- *Type:* typing.List[str]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.description"></a>

- *Type:* str

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.devDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.entrypoint"></a>

- *Type:* str
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.homepage"></a>

- *Type:* str

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.keywords"></a>

- *Type:* typing.List[str]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.license"></a>

- *Type:* str
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.licensed"></a>

- *Type:* bool
- *Default:* true

Indicates if a license should be added.

---

##### `max_node_version`<sup>Optional</sup> <a name="max_node_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.maxNodeVersion"></a>

- *Type:* str
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `min_node_version`<sup>Optional</sup> <a name="min_node_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.minNodeVersion"></a>

- *Type:* str
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npm_access`<sup>Optional</sup> <a name="npm_access" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmAccess"></a>

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npm_registry`~~<sup>Optional</sup> <a name="npm_registry" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

- *Type:* str

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npm_registry_url`<sup>Optional</sup> <a name="npm_registry_url" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmRegistryUrl"></a>

- *Type:* str
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npm_token_secret`<sup>Optional</sup> <a name="npm_token_secret" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmTokenSecret"></a>

- *Type:* str
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `package_manager`<sup>Optional</sup> <a name="package_manager" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.packageManager"></a>

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.packageName"></a>

- *Type:* str
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peer_dependency_options`<sup>Optional</sup> <a name="peer_dependency_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.peerDependencyOptions"></a>

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peer_deps`<sup>Optional</sup> <a name="peer_deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.peerDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpm_version`<sup>Optional</sup> <a name="pnpm_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.pnpmVersion"></a>

- *Type:* str
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.repository"></a>

- *Type:* str

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repository_directory`<sup>Optional</sup> <a name="repository_directory" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.repositoryDirectory"></a>

- *Type:* str

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scoped_packages_options`<sup>Optional</sup> <a name="scoped_packages_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.scopedPackagesOptions"></a>

- *Type:* typing.List[projen.javascript.ScopedPackagesOptions]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

- *Type:* typing.Mapping[str]
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.stability"></a>

- *Type:* str

Package's Stability.

---

##### `jsii_release_version`<sup>Optional</sup> <a name="jsii_release_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.jsiiReleaseVersion"></a>

- *Type:* str
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `major_version`<sup>Optional</sup> <a name="major_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.majorVersion"></a>

- *Type:* typing.Union[int, float]
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `min_major_version`<sup>Optional</sup> <a name="min_major_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.minMajorVersion"></a>

- *Type:* typing.Union[int, float]
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npm_dist_tag`<sup>Optional</sup> <a name="npm_dist_tag" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmDistTag"></a>

- *Type:* str
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `post_build_steps`<sup>Optional</sup> <a name="post_build_steps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.postBuildSteps"></a>

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.prerelease"></a>

- *Type:* str
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publish_dry_run`<sup>Optional</sup> <a name="publish_dry_run" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.publishDryRun"></a>

- *Type:* bool
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publish_tasks`<sup>Optional</sup> <a name="publish_tasks" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.publishTasks"></a>

- *Type:* bool
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `release_branches`<sup>Optional</sup> <a name="release_branches" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseBranches"></a>

- *Type:* typing.Mapping[projen.release.BranchOptions]
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`release_every_commit`~~<sup>Optional</sup> <a name="release_every_commit" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

- *Type:* bool
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `release_failure_issue`<sup>Optional</sup> <a name="release_failure_issue" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseFailureIssue"></a>

- *Type:* bool
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `release_failure_issue_label`<sup>Optional</sup> <a name="release_failure_issue_label" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseFailureIssueLabel"></a>

- *Type:* str
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`release_schedule`~~<sup>Optional</sup> <a name="release_schedule" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

- *Type:* str
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `release_tag_prefix`<sup>Optional</sup> <a name="release_tag_prefix" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseTagPrefix"></a>

- *Type:* str
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `release_trigger`<sup>Optional</sup> <a name="release_trigger" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseTrigger"></a>

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `release_workflow_name`<sup>Optional</sup> <a name="release_workflow_name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflowName"></a>

- *Type:* str
- *Default:* "Release"

The name of the default release workflow.

---

##### `release_workflow_setup_steps`<sup>Optional</sup> <a name="release_workflow_setup_steps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflowSetupSteps"></a>

- *Type:* typing.List[projen.github.workflows.JobStep]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrc_options`<sup>Optional</sup> <a name="versionrc_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.versionrcOptions"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflow_container_image`<sup>Optional</sup> <a name="workflow_container_image" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.workflowContainerImage"></a>

- *Type:* str
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflow_runs_on`<sup>Optional</sup> <a name="workflow_runs_on" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.workflowRunsOn"></a>

- *Type:* typing.List[str]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `default_release_branch`<sup>Required</sup> <a name="default_release_branch" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.defaultReleaseBranch"></a>

- *Type:* str
- *Default:* "main"

The name of the main release branch.

---

##### `artifacts_directory`<sup>Optional</sup> <a name="artifacts_directory" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.artifactsDirectory"></a>

- *Type:* str
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `auto_approve_upgrades`<sup>Optional</sup> <a name="auto_approve_upgrades" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.autoApproveUpgrades"></a>

- *Type:* bool
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `build_workflow`<sup>Optional</sup> <a name="build_workflow" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.buildWorkflow"></a>

- *Type:* bool
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `build_workflow_triggers`<sup>Optional</sup> <a name="build_workflow_triggers" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.buildWorkflowTriggers"></a>

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundler_options`<sup>Optional</sup> <a name="bundler_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.bundlerOptions"></a>

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `code_cov`<sup>Optional</sup> <a name="code_cov" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.codeCov"></a>

- *Type:* bool
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret.

---

##### `code_cov_token_secret`<sup>Optional</sup> <a name="code_cov_token_secret" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.codeCovTokenSecret"></a>

- *Type:* str
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyright_owner`<sup>Optional</sup> <a name="copyright_owner" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.copyrightOwner"></a>

- *Type:* str
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyright_period`<sup>Optional</sup> <a name="copyright_period" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.copyrightPeriod"></a>

- *Type:* str
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.dependabot"></a>

- *Type:* bool
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabot_options`<sup>Optional</sup> <a name="dependabot_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.dependabotOptions"></a>

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `deps_upgrade`<sup>Optional</sup> <a name="deps_upgrade" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.depsUpgrade"></a>

- *Type:* bool
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `deps_upgrade_options`<sup>Optional</sup> <a name="deps_upgrade_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.depsUpgradeOptions"></a>

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.gitignore"></a>

- *Type:* typing.List[str]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.jest"></a>

- *Type:* bool
- *Default:* true

Setup jest unit tests.

---

##### `jest_options`<sup>Optional</sup> <a name="jest_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.jestOptions"></a>

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutable_build`<sup>Optional</sup> <a name="mutable_build" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.mutableBuild"></a>

- *Type:* bool
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

- *Type:* typing.List[str]

Additional entries to .npmignore.

---

##### `npmignore_enabled`<sup>Optional</sup> <a name="npmignore_enabled" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmignoreEnabled"></a>

- *Type:* bool
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npm_ignore_options`<sup>Optional</sup> <a name="npm_ignore_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.npmIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.package"></a>

- *Type:* bool
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.prettier"></a>

- *Type:* bool
- *Default:* false

Setup prettier.

---

##### `prettier_options`<sup>Optional</sup> <a name="prettier_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.prettierOptions"></a>

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projen_dev_dependency`<sup>Optional</sup> <a name="projen_dev_dependency" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenDevDependency"></a>

- *Type:* bool
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenrcJs"></a>

- *Type:* bool
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projen_version`<sup>Optional</sup> <a name="projen_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenVersion"></a>

- *Type:* str
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pull_request_template`<sup>Optional</sup> <a name="pull_request_template" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.pullRequestTemplate"></a>

- *Type:* bool
- *Default:* true

Include a GitHub pull request template.

---

##### `pull_request_template_contents`<sup>Optional</sup> <a name="pull_request_template_contents" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.pullRequestTemplateContents"></a>

- *Type:* typing.List[str]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.release"></a>

- *Type:* bool
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `release_to_npm`<sup>Optional</sup> <a name="release_to_npm" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseToNpm"></a>

- *Type:* bool
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`release_workflow`~~<sup>Optional</sup> <a name="release_workflow" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflow"></a>

- *Deprecated:* see `release`.

- *Type:* bool
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflow_bootstrap_steps`<sup>Optional</sup> <a name="workflow_bootstrap_steps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.workflowBootstrapSteps"></a>

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflow_git_identity`<sup>Optional</sup> <a name="workflow_git_identity" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.workflowGitIdentity"></a>

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflow_node_version`<sup>Optional</sup> <a name="workflow_node_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.workflowNodeVersion"></a>

- *Type:* str
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `disable_tsconfig`<sup>Optional</sup> <a name="disable_tsconfig" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.disableTsconfig"></a>

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disable_tsconfig_dev`<sup>Optional</sup> <a name="disable_tsconfig_dev" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.disableTsconfigDev"></a>

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.docgen"></a>

- *Type:* bool
- *Default:* false

Docgen by Typedoc.

---

##### `docs_directory`<sup>Optional</sup> <a name="docs_directory" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.docsDirectory"></a>

- *Type:* str
- *Default:* "docs"

Docs directory.

---

##### `entrypoint_types`<sup>Optional</sup> <a name="entrypoint_types" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.entrypointTypes"></a>

- *Type:* str
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.eslint"></a>

- *Type:* bool
- *Default:* true

Setup eslint.

---

##### `eslint_options`<sup>Optional</sup> <a name="eslint_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.eslintOptions"></a>

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.libdir"></a>

- *Type:* str
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenrcTs"></a>

- *Type:* bool
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sample_code`<sup>Optional</sup> <a name="sample_code" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.sampleCode"></a>

- *Type:* bool
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.srcdir"></a>

- *Type:* str
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.testdir"></a>

- *Type:* str
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.tsconfig"></a>

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfig_dev`<sup>Optional</sup> <a name="tsconfig_dev" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.tsconfigDev"></a>

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfig_dev_file`<sup>Optional</sup> <a name="tsconfig_dev_file" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.tsconfigDevFile"></a>

- *Type:* str
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescript_version`<sup>Optional</sup> <a name="typescript_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.typescriptVersion"></a>

- *Type:* str
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `monorepo_upgrade_deps`<sup>Optional</sup> <a name="monorepo_upgrade_deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.monorepoUpgradeDeps"></a>

- *Type:* bool
- *Default:* true

Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies.

---

##### `monorepo_upgrade_deps_options`<sup>Optional</sup> <a name="monorepo_upgrade_deps_options" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.monorepoUpgradeDepsOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/nx-monorepo.MonorepoUpgradeDepsOptions">MonorepoUpgradeDepsOptions</a>
- *Default:* undefined

Monorepo Upgrade Deps options.

This is only used if monorepoUpgradeDeps is true.

---

##### `nx_config`<sup>Optional</sup> <a name="nx_config" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.nxConfig"></a>

- *Type:* aws_prototyping_sdk.Nx.WorkspaceConfig

Configuration for NX.

---

##### `workspace_config`<sup>Optional</sup> <a name="workspace_config" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.Initializer.parameter.workspaceConfig"></a>

- *Type:* <a href="#@aws-prototyping-sdk/nx-monorepo.WorkspaceConfig">WorkspaceConfig</a>

Configuration for workspace.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addExcludeFromCleanup">add_exclude_from_cleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addGitIgnore">add_git_ignore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addPackageIgnore">add_package_ignore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTask">add_task</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTip">add_tip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.annotateGenerated">annotate_generated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.postSynthesize">post_synthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.preSynthesize">pre_synthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.removeTask">remove_task</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.runTaskCommand">run_task_command</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.tryFindFile">try_find_file</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.tryFindJsonFile">try_find_json_file</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.tryFindObjectFile">try_find_object_file</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.tryRemoveFile">try_remove_file</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addBins">add_bins</a></code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addBundledDeps">add_bundled_deps</a></code> | Defines bundled dependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addCompileCommand">add_compile_command</a></code> | DEPRECATED. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addDeps">add_deps</a></code> | Defines normal dependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addDevDeps">add_dev_deps</a></code> | Defines development/test dependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addFields">add_fields</a></code> | Directly set fields in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addKeywords">add_keywords</a></code> | Adds keywords to package.json (deduplicated). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addPeerDeps">add_peer_deps</a></code> | Defines peer dependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addScripts">add_scripts</a></code> | Replaces the contents of multiple npm package.json scripts. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTestCommand">add_test_command</a></code> | DEPRECATED. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.hasScript">has_script</a></code> | Indicates if a script by the name name is defined. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.removeScript">remove_script</a></code> | Removes the npm script (always successful). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.renderWorkflowSetup">render_workflow_setup</a></code> | Returns the set of workflow steps which should be executed to bootstrap a workflow. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.setScript">set_script</a></code> | Replaces the contents of an npm package.json script. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addImplicitDependency">add_implicit_dependency</a></code> | Create an implicit dependency between two Projects. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addJavaDependency">add_java_dependency</a></code> | Adds a dependency between two Java Projects in the monorepo. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask">add_nx_run_many_task</a></code> | Add project task that executes `npx nx run-many ...` style command. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addPythonPoetryDependency">add_python_poetry_dependency</a></code> | Adds a dependency between two Python Projects in the monorepo. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addWorkspacePackages">add_workspace_packages</a></code> | Add one or more additional package globs to the workspace. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand">format_nx_run_many_command</a></code> | Helper to format `npx nx run-many ...` style command. |

---

##### `add_exclude_from_cleanup` <a name="add_exclude_from_cleanup" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addExcludeFromCleanup"></a>

```python
def add_exclude_from_cleanup(
  globs: str
) -> None
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* str

The glob patterns to match.

---

##### `add_git_ignore` <a name="add_git_ignore" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addGitIgnore"></a>

```python
def add_git_ignore(
  pattern: str
) -> None
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addGitIgnore.parameter.pattern"></a>

- *Type:* str

The glob pattern to ignore.

---

##### `add_package_ignore` <a name="add_package_ignore" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addPackageIgnore"></a>

```python
def add_package_ignore(
  pattern: str
) -> None
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addPackageIgnore.parameter.pattern"></a>

- *Type:* str

---

##### `add_task` <a name="add_task" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTask"></a>

```python
def add_task(
  name: str,
  condition: str = None,
  cwd: str = None,
  description: str = None,
  env: typing.Mapping[str] = None,
  required_env: typing.List[str] = None,
  args: typing.List[str] = None,
  exec: str = None,
  receive_args: bool = None,
  steps: typing.List[TaskStep] = None
) -> Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTask.parameter.name"></a>

- *Type:* str

The task name to add.

---

###### `condition`<sup>Optional</sup> <a name="condition" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTask.parameter.condition"></a>

- *Type:* str

A shell command which determines if the this task should be executed.

If
the program exits with a zero exit code, steps will be executed. A non-zero
code means that task will be skipped.

---

###### `cwd`<sup>Optional</sup> <a name="cwd" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTask.parameter.cwd"></a>

- *Type:* str
- *Default:* process.cwd()

The working directory for all steps in this task (unless overridden by the step).

---

###### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTask.parameter.description"></a>

- *Type:* str
- *Default:* the task name

The description of this build command.

---

###### `env`<sup>Optional</sup> <a name="env" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTask.parameter.env"></a>

- *Type:* typing.Mapping[str]
- *Default:* {}

Defines environment variables for the execution of this task.

Values in this map will be evaluated in a shell, so you can do stuff like `$(echo "foo")`.

---

###### `required_env`<sup>Optional</sup> <a name="required_env" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTask.parameter.requiredEnv"></a>

- *Type:* typing.List[str]

A set of environment variables that must be defined in order to execute this task.

Task execution will fail if one of these is not defined.

---

###### `args`<sup>Optional</sup> <a name="args" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTask.parameter.args"></a>

- *Type:* typing.List[str]
- *Default:* no arguments are passed to the step

Should the provided `exec` shell command receive fixed args.

> [{@link TaskStepOptions.args }]({@link TaskStepOptions.args })

---

###### `exec`<sup>Optional</sup> <a name="exec" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTask.parameter.exec"></a>

- *Type:* str
- *Default:* add steps using `task.exec(command)` or `task.spawn(subtask)`

Shell command to execute as the first command of the task.

---

###### `receive_args`<sup>Optional</sup> <a name="receive_args" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTask.parameter.receiveArgs"></a>

- *Type:* bool
- *Default:* false

Should the provided `exec` shell command receive args passed to the task.

> [{@link TaskStepOptions.receiveArgs }]({@link TaskStepOptions.receiveArgs })

---

###### `steps`<sup>Optional</sup> <a name="steps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTask.parameter.steps"></a>

- *Type:* typing.List[projen.TaskStep]

List of task steps to run.

---

##### ~~`add_tip`~~ <a name="add_tip" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTip"></a>

```python
def add_tip(
  message: str
) -> None
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTip.parameter.message"></a>

- *Type:* str

The message.

---

##### `annotate_generated` <a name="annotate_generated" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.annotateGenerated"></a>

```python
def annotate_generated(
  glob: str
) -> None
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.annotateGenerated.parameter.glob"></a>

- *Type:* str

the glob pattern to match (could be a file path).

---

##### `post_synthesize` <a name="post_synthesize" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.postSynthesize"></a>

```python
def post_synthesize() -> None
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `pre_synthesize` <a name="pre_synthesize" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.preSynthesize"></a>

```python
def pre_synthesize() -> None
```

Called before all components are synthesized.

##### `remove_task` <a name="remove_task" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.removeTask"></a>

```python
def remove_task(
  name: str
) -> Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.removeTask.parameter.name"></a>

- *Type:* str

The name of the task to remove.

---

##### `run_task_command` <a name="run_task_command" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.runTaskCommand"></a>

```python
def run_task_command(
  task: Task
) -> str
```

Returns the shell command to execute in order to run a task.

This will
typically be `npx projen TASK`.

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.synth"></a>

```python
def synth() -> None
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `try_find_file` <a name="try_find_file" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.tryFindFile"></a>

```python
def try_find_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.tryFindFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`try_find_json_file`~~ <a name="try_find_json_file" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.tryFindJsonFile"></a>

```python
def try_find_json_file(
  file_path: str
) -> JsonFile
```

Finds a json file by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### `try_find_object_file` <a name="try_find_object_file" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.tryFindObjectFile"></a>

```python
def try_find_object_file(
  file_path: str
) -> ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### `try_remove_file` <a name="try_remove_file" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.tryRemoveFile"></a>

```python
def try_remove_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `add_bins` <a name="add_bins" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addBins"></a>

```python
def add_bins(
  bins: typing.Mapping[str]
) -> None
```

###### `bins`<sup>Required</sup> <a name="bins" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addBins.parameter.bins"></a>

- *Type:* typing.Mapping[str]

---

##### `add_bundled_deps` <a name="add_bundled_deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addBundledDeps"></a>

```python
def add_bundled_deps(
  deps: str
) -> None
```

Defines bundled dependencies.

Bundled dependencies will be added as normal dependencies as well as to the
`bundledDependencies` section of your `package.json`.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addBundledDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`add_compile_command`~~ <a name="add_compile_command" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addCompileCommand"></a>

```python
def add_compile_command(
  commands: str
) -> None
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addCompileCommand.parameter.commands"></a>

- *Type:* str

---

##### `add_deps` <a name="add_deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addDeps"></a>

```python
def add_deps(
  deps: str
) -> None
```

Defines normal dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `add_dev_deps` <a name="add_dev_deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addDevDeps"></a>

```python
def add_dev_deps(
  deps: str
) -> None
```

Defines development/test dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addDevDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `add_fields` <a name="add_fields" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addFields"></a>

```python
def add_fields(
  fields: typing.Mapping[typing.Any]
) -> None
```

Directly set fields in `package.json`.

###### `fields`<sup>Required</sup> <a name="fields" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addFields.parameter.fields"></a>

- *Type:* typing.Mapping[typing.Any]

The fields to set.

---

##### `add_keywords` <a name="add_keywords" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addKeywords"></a>

```python
def add_keywords(
  keywords: str
) -> None
```

Adds keywords to package.json (deduplicated).

###### `keywords`<sup>Required</sup> <a name="keywords" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addKeywords.parameter.keywords"></a>

- *Type:* str

The keywords to add.

---

##### `add_peer_deps` <a name="add_peer_deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addPeerDeps"></a>

```python
def add_peer_deps(
  deps: str
) -> None
```

Defines peer dependencies.

When adding peer dependencies, a devDependency will also be added on the
pinned version of the declared peer. This will ensure that you are testing
your code against the minimum version required from your consumers.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addPeerDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `add_scripts` <a name="add_scripts" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addScripts"></a>

```python
def add_scripts(
  scripts: typing.Mapping[str]
) -> None
```

Replaces the contents of multiple npm package.json scripts.

###### `scripts`<sup>Required</sup> <a name="scripts" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addScripts.parameter.scripts"></a>

- *Type:* typing.Mapping[str]

The scripts to set.

---

##### ~~`add_test_command`~~ <a name="add_test_command" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTestCommand"></a>

```python
def add_test_command(
  commands: str
) -> None
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addTestCommand.parameter.commands"></a>

- *Type:* str

---

##### ~~`has_script`~~ <a name="has_script" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.hasScript"></a>

```python
def has_script(
  name: str
) -> bool
```

Indicates if a script by the name name is defined.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.hasScript.parameter.name"></a>

- *Type:* str

The name of the script.

---

##### `remove_script` <a name="remove_script" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.removeScript"></a>

```python
def remove_script(
  name: str
) -> None
```

Removes the npm script (always successful).

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.removeScript.parameter.name"></a>

- *Type:* str

The name of the script.

---

##### `render_workflow_setup` <a name="render_workflow_setup" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.renderWorkflowSetup"></a>

```python
def render_workflow_setup(
  mutable: bool = None
) -> typing.List[JobStep]
```

Returns the set of workflow steps which should be executed to bootstrap a workflow.

###### `mutable`<sup>Optional</sup> <a name="mutable" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.renderWorkflowSetup.parameter.mutable"></a>

- *Type:* bool
- *Default:* false

Should the pacakge lockfile be updated?

---

##### `set_script` <a name="set_script" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.setScript"></a>

```python
def set_script(
  name: str,
  command: str
) -> None
```

Replaces the contents of an npm package.json script.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.setScript.parameter.name"></a>

- *Type:* str

The script name.

---

###### `command`<sup>Required</sup> <a name="command" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.setScript.parameter.command"></a>

- *Type:* str

The command to execute.

---

##### `add_implicit_dependency` <a name="add_implicit_dependency" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addImplicitDependency"></a>

```python
def add_implicit_dependency(
  dependent: Project,
  dependee: typing.Union[str, Project]
) -> None
```

Create an implicit dependency between two Projects.

This is typically
used in polygot repos where a Typescript project wants a build dependency
on a Python project as an example.

###### `dependent`<sup>Required</sup> <a name="dependent" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addImplicitDependency.parameter.dependent"></a>

- *Type:* projen.Project

project you want to have the dependency.

---

###### `dependee`<sup>Required</sup> <a name="dependee" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addImplicitDependency.parameter.dependee"></a>

- *Type:* typing.Union[str, projen.Project]

project you wish to depend on.

---

##### `add_java_dependency` <a name="add_java_dependency" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addJavaDependency"></a>

```python
def add_java_dependency(
  dependent: JavaProject,
  dependee: JavaProject
) -> None
```

Adds a dependency between two Java Projects in the monorepo.

###### `dependent`<sup>Required</sup> <a name="dependent" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addJavaDependency.parameter.dependent"></a>

- *Type:* projen.java.JavaProject

project you want to have the dependency.

---

###### `dependee`<sup>Required</sup> <a name="dependee" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addJavaDependency.parameter.dependee"></a>

- *Type:* projen.java.JavaProject

project you wish to depend on.

---

##### `add_nx_run_many_task` <a name="add_nx_run_many_task" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask"></a>

```python
def add_nx_run_many_task(
  name: str,
  target: str,
  configuration: str = None,
  exclude: str = None,
  ignore_cycles: bool = None,
  no_bail: bool = None,
  output_style: str = None,
  parallel: typing.Union[int, float] = None,
  projects: typing.List[str] = None,
  runner: str = None,
  skip_cache: bool = None,
  verbose: bool = None
) -> Task
```

Add project task that executes `npx nx run-many ...` style command.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask.parameter.name"></a>

- *Type:* str

---

###### `target`<sup>Required</sup> <a name="target" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask.parameter.target"></a>

- *Type:* str

Task to run for affected projects.

---

###### `configuration`<sup>Optional</sup> <a name="configuration" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask.parameter.configuration"></a>

- *Type:* str

This is the configuration to use when performing tasks on projects.

---

###### `exclude`<sup>Optional</sup> <a name="exclude" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask.parameter.exclude"></a>

- *Type:* str

Exclude certain projects from being processed.

---

###### `ignore_cycles`<sup>Optional</sup> <a name="ignore_cycles" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask.parameter.ignoreCycles"></a>

- *Type:* bool

Ignore cycles in the task graph.

---

###### `no_bail`<sup>Optional</sup> <a name="no_bail" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask.parameter.noBail"></a>

- *Type:* bool

Do not stop command execution after the first failed task.

---

###### `output_style`<sup>Optional</sup> <a name="output_style" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask.parameter.outputStyle"></a>

- *Type:* str
- *Default:* "stream"

Defines how Nx emits outputs tasks logs.

---

###### `parallel`<sup>Optional</sup> <a name="parallel" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask.parameter.parallel"></a>

- *Type:* typing.Union[int, float]
- *Default:* 3

Max number of parallel processes.

---

###### `projects`<sup>Optional</sup> <a name="projects" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask.parameter.projects"></a>

- *Type:* typing.List[str]

Project to run as list project names and/or patterns.

---

###### `runner`<sup>Optional</sup> <a name="runner" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask.parameter.runner"></a>

- *Type:* str

This is the name of the tasks runner configuration in nx.json.

---

###### `skip_cache`<sup>Optional</sup> <a name="skip_cache" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask.parameter.skipCache"></a>

- *Type:* bool

Rerun the tasks even when the results are available in the cache.

---

###### `verbose`<sup>Optional</sup> <a name="verbose" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addNxRunManyTask.parameter.verbose"></a>

- *Type:* bool

Prints additional information about the commands (e.g. stack traces).

---

##### `add_python_poetry_dependency` <a name="add_python_poetry_dependency" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addPythonPoetryDependency"></a>

```python
def add_python_poetry_dependency(
  dependent: PythonProject,
  dependee: PythonProject
) -> None
```

Adds a dependency between two Python Projects in the monorepo.

The dependent must have Poetry enabled.

###### `dependent`<sup>Required</sup> <a name="dependent" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addPythonPoetryDependency.parameter.dependent"></a>

- *Type:* projen.python.PythonProject

project you want to have the dependency (must be a Poetry Python Project).

---

###### `dependee`<sup>Required</sup> <a name="dependee" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addPythonPoetryDependency.parameter.dependee"></a>

- *Type:* projen.python.PythonProject

project you wish to depend on.

---

##### `add_workspace_packages` <a name="add_workspace_packages" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addWorkspacePackages"></a>

```python
def add_workspace_packages(
  package_globs: str
) -> None
```

Add one or more additional package globs to the workspace.

###### `package_globs`<sup>Required</sup> <a name="package_globs" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.addWorkspacePackages.parameter.packageGlobs"></a>

- *Type:* str

paths to the package to include in the workspace (for example packages/my-package).

---

##### `format_nx_run_many_command` <a name="format_nx_run_many_command" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand"></a>

```python
def format_nx_run_many_command(
  target: str,
  configuration: str = None,
  exclude: str = None,
  ignore_cycles: bool = None,
  no_bail: bool = None,
  output_style: str = None,
  parallel: typing.Union[int, float] = None,
  projects: typing.List[str] = None,
  runner: str = None,
  skip_cache: bool = None,
  verbose: bool = None
) -> str
```

Helper to format `npx nx run-many ...` style command.

###### `target`<sup>Required</sup> <a name="target" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.target"></a>

- *Type:* str

Task to run for affected projects.

---

###### `configuration`<sup>Optional</sup> <a name="configuration" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.configuration"></a>

- *Type:* str

This is the configuration to use when performing tasks on projects.

---

###### `exclude`<sup>Optional</sup> <a name="exclude" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.exclude"></a>

- *Type:* str

Exclude certain projects from being processed.

---

###### `ignore_cycles`<sup>Optional</sup> <a name="ignore_cycles" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.ignoreCycles"></a>

- *Type:* bool

Ignore cycles in the task graph.

---

###### `no_bail`<sup>Optional</sup> <a name="no_bail" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.noBail"></a>

- *Type:* bool

Do not stop command execution after the first failed task.

---

###### `output_style`<sup>Optional</sup> <a name="output_style" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.outputStyle"></a>

- *Type:* str
- *Default:* "stream"

Defines how Nx emits outputs tasks logs.

---

###### `parallel`<sup>Optional</sup> <a name="parallel" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.parallel"></a>

- *Type:* typing.Union[int, float]
- *Default:* 3

Max number of parallel processes.

---

###### `projects`<sup>Optional</sup> <a name="projects" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.projects"></a>

- *Type:* typing.List[str]

Project to run as list project names and/or patterns.

---

###### `runner`<sup>Optional</sup> <a name="runner" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.runner"></a>

- *Type:* str

This is the name of the tasks runner configuration in nx.json.

---

###### `skip_cache`<sup>Optional</sup> <a name="skip_cache" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.skipCache"></a>

- *Type:* bool

Rerun the tasks even when the results are available in the cache.

---

###### `verbose`<sup>Optional</sup> <a name="verbose" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.verbose"></a>

- *Type:* bool

Prints additional information about the commands (e.g. stack traces).

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.buildTask">build_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.compileTask">compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.components">components</a></code> | <code>typing.List[projen.Component]</code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.ejected">ejected</a></code> | <code>bool</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.files">files</a></code> | <code>typing.List[projen.FileBase]</code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.name">name</a></code> | <code>str</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.outdir">outdir</a></code> | <code>str</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.packageTask">package_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.postCompileTask">post_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.preCompileTask">pre_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.projectBuild">project_build</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.projenCommand">projen_command</a></code> | <code>str</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.testTask">test_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.defaultTask">default_task</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.initProject">init_project</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.autoApprove">auto_approve</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.devContainer">dev_container</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | The build output directory. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.artifactsJavascriptDirectory">artifacts_javascript_directory</a></code> | <code>str</code> | The location of the npm tarball after build (`${artifactsDirectory}/js`). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.bundler">bundler</a></code> | <code>projen.javascript.Bundler</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.entrypoint">entrypoint</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.manifest">manifest</a></code> | <code>typing.Any</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.npmrc">npmrc</a></code> | <code>projen.javascript.NpmConfig</code> | The .npmrc file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.package">package</a></code> | <code>projen.javascript.NodePackage</code> | API for managing the node package. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The package manager to use. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.runScriptCommand">run_script_command</a></code> | <code>str</code> | The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.autoMerge">auto_merge</a></code> | <code>projen.github.AutoMerge</code> | Component that sets up mergify for merging approved pull requests. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.buildWorkflow">build_workflow</a></code> | <code>projen.build.BuildWorkflow</code> | The PR build GitHub workflow. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.buildWorkflowJobId">build_workflow_job_id</a></code> | <code>str</code> | The job ID of the build workflow. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.jest">jest</a></code> | <code>projen.javascript.Jest</code> | The Jest configuration (if enabled). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Maximum node version required by this package. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum node.js version required by this package. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.npmignore">npmignore</a></code> | <code>projen.IgnoreFile</code> | The .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.prettier">prettier</a></code> | <code>projen.javascript.Prettier</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.publisher">publisher</a></code> | <code>projen.release.Publisher</code> | Package publisher. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.release">release</a></code> | <code>projen.release.Release</code> | Release management. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.upgradeWorkflow">upgrade_workflow</a></code> | <code>projen.javascript.UpgradeDependencies</code> | The upgrade workflow. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.docsDirectory">docs_directory</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.libdir">libdir</a></code> | <code>str</code> | The directory in which compiled .js files reside. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.srcdir">srcdir</a></code> | <code>str</code> | The directory in which the .ts sources reside. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.testdir">testdir</a></code> | <code>str</code> | The directory in which tests reside. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfig</code> | A typescript configuration file which covers all files (sources, tests, projen). |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.watchTask">watch_task</a></code> | <code>projen.Task</code> | The "watch" task. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.docgen">docgen</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.eslint">eslint</a></code> | <code>projen.javascript.Eslint</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.tsconfigEslint">tsconfig_eslint</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.nxJson">nx_json</a></code> | <code>projen.JsonFile</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.subProjects">sub_projects</a></code> | <code>typing.List[projen.Project]</code> | *No description.* |

---

##### `build_task`<sup>Required</sup> <a name="build_task" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.buildTask"></a>

```python
build_task: Task
```

- *Type:* projen.Task

---

##### `commit_generated`<sup>Required</sup> <a name="commit_generated" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool

Whether to commit the managed files by default.

---

##### `compile_task`<sup>Required</sup> <a name="compile_task" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.compileTask"></a>

```python
compile_task: Task
```

- *Type:* projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.components"></a>

```python
components: typing.List[Component]
```

- *Type:* typing.List[projen.Component]

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.deps"></a>

```python
deps: Dependencies
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.ejected"></a>

```python
ejected: bool
```

- *Type:* bool

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.files"></a>

```python
files: typing.List[FileBase]
```

- *Type:* typing.List[projen.FileBase]

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.gitattributes"></a>

```python
gitattributes: GitAttributesFile
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.gitignore"></a>

```python
gitignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.logger"></a>

```python
logger: Logger
```

- *Type:* projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.name"></a>

```python
name: str
```

- *Type:* str

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.outdir"></a>

```python
outdir: str
```

- *Type:* str

Absolute output directory of this project.

---

##### `package_task`<sup>Required</sup> <a name="package_task" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.packageTask"></a>

```python
package_task: Task
```

- *Type:* projen.Task

---

##### `post_compile_task`<sup>Required</sup> <a name="post_compile_task" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.postCompileTask"></a>

```python
post_compile_task: Task
```

- *Type:* projen.Task

---

##### `pre_compile_task`<sup>Required</sup> <a name="pre_compile_task" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.preCompileTask"></a>

```python
pre_compile_task: Task
```

- *Type:* projen.Task

---

##### `project_build`<sup>Required</sup> <a name="project_build" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.projectBuild"></a>

```python
project_build: ProjectBuild
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### `projen_command`<sup>Required</sup> <a name="projen_command" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.root"></a>

```python
root: Project
```

- *Type:* projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.tasks"></a>

```python
tasks: Tasks
```

- *Type:* projen.Tasks

Project tasks.

---

##### `test_task`<sup>Required</sup> <a name="test_task" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.testTask"></a>

```python
test_task: Task
```

- *Type:* projen.Task

---

##### `default_task`<sup>Optional</sup> <a name="default_task" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.defaultTask"></a>

```python
default_task: Task
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `init_project`<sup>Optional</sup> <a name="init_project" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.initProject"></a>

```python
init_project: InitProject
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### `project_type`<sup>Required</sup> <a name="project_type" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.projectType"></a>

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType

---

##### `auto_approve`<sup>Optional</sup> <a name="auto_approve" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.autoApprove"></a>

```python
auto_approve: AutoApprove
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.devContainer"></a>

```python
dev_container: DevContainer
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.github"></a>

```python
github: GitHub
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.gitpod"></a>

```python
gitpod: Gitpod
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.vscode"></a>

```python
vscode: VsCode
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`allow_library_dependencies`~~<sup>Required</sup> <a name="allow_library_dependencies" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.allowLibraryDependencies"></a>

- *Deprecated:* use `package.allowLibraryDependencies`

```python
allow_library_dependencies: bool
```

- *Type:* bool

---

##### `artifacts_directory`<sup>Required</sup> <a name="artifacts_directory" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.artifactsDirectory"></a>

```python
artifacts_directory: str
```

- *Type:* str

The build output directory.

An npm tarball will be created under the `js`
subdirectory. For example, if this is set to `dist` (the default), the npm
tarball will be placed under `dist/js/boom-boom-1.2.3.tg`.

---

##### `artifacts_javascript_directory`<sup>Required</sup> <a name="artifacts_javascript_directory" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.artifactsJavascriptDirectory"></a>

```python
artifacts_javascript_directory: str
```

- *Type:* str

The location of the npm tarball after build (`${artifactsDirectory}/js`).

---

##### `bundler`<sup>Required</sup> <a name="bundler" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.bundler"></a>

```python
bundler: Bundler
```

- *Type:* projen.javascript.Bundler

---

##### ~~`entrypoint`~~<sup>Required</sup> <a name="entrypoint" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.entrypoint"></a>

- *Deprecated:* use `package.entrypoint`

```python
entrypoint: str
```

- *Type:* str

---

##### ~~`manifest`~~<sup>Required</sup> <a name="manifest" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.manifest"></a>

- *Deprecated:* use `package.addField(x, y)`

```python
manifest: typing.Any
```

- *Type:* typing.Any

---

##### `npmrc`<sup>Required</sup> <a name="npmrc" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.npmrc"></a>

```python
npmrc: NpmConfig
```

- *Type:* projen.javascript.NpmConfig

The .npmrc file.

---

##### `package`<sup>Required</sup> <a name="package" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.package"></a>

```python
package: NodePackage
```

- *Type:* projen.javascript.NodePackage

API for managing the node package.

---

##### ~~`package_manager`~~<sup>Required</sup> <a name="package_manager" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.packageManager"></a>

- *Deprecated:* use `package.packageManager`

```python
package_manager: NodePackageManager
```

- *Type:* projen.javascript.NodePackageManager

The package manager to use.

---

##### `run_script_command`<sup>Required</sup> <a name="run_script_command" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.runScriptCommand"></a>

```python
run_script_command: str
```

- *Type:* str

The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager).

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.autoMerge"></a>

```python
auto_merge: AutoMerge
```

- *Type:* projen.github.AutoMerge

Component that sets up mergify for merging approved pull requests.

---

##### `build_workflow`<sup>Optional</sup> <a name="build_workflow" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.buildWorkflow"></a>

```python
build_workflow: BuildWorkflow
```

- *Type:* projen.build.BuildWorkflow

The PR build GitHub workflow.

`undefined` if `buildWorkflow` is disabled.

---

##### `build_workflow_job_id`<sup>Optional</sup> <a name="build_workflow_job_id" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.buildWorkflowJobId"></a>

```python
build_workflow_job_id: str
```

- *Type:* str

The job ID of the build workflow.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.jest"></a>

```python
jest: Jest
```

- *Type:* projen.javascript.Jest

The Jest configuration (if enabled).

---

##### `max_node_version`<sup>Optional</sup> <a name="max_node_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.maxNodeVersion"></a>

```python
max_node_version: str
```

- *Type:* str

Maximum node version required by this package.

---

##### `min_node_version`<sup>Optional</sup> <a name="min_node_version" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.minNodeVersion"></a>

```python
min_node_version: str
```

- *Type:* str

Minimum node.js version required by this package.

---

##### `npmignore`<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.npmignore"></a>

```python
npmignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

The .npmignore file.

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.prettier"></a>

```python
prettier: Prettier
```

- *Type:* projen.javascript.Prettier

---

##### ~~`publisher`~~<sup>Optional</sup> <a name="publisher" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.publisher"></a>

- *Deprecated:* use `release.publisher`.

```python
publisher: Publisher
```

- *Type:* projen.release.Publisher

Package publisher.

This will be `undefined` if the project does not have a
release workflow.

---

##### `release`<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.release"></a>

```python
release: Release
```

- *Type:* projen.release.Release

Release management.

---

##### `upgrade_workflow`<sup>Optional</sup> <a name="upgrade_workflow" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.upgradeWorkflow"></a>

```python
upgrade_workflow: UpgradeDependencies
```

- *Type:* projen.javascript.UpgradeDependencies

The upgrade workflow.

---

##### `docs_directory`<sup>Required</sup> <a name="docs_directory" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.docsDirectory"></a>

```python
docs_directory: str
```

- *Type:* str

---

##### `libdir`<sup>Required</sup> <a name="libdir" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.libdir"></a>

```python
libdir: str
```

- *Type:* str

The directory in which compiled .js files reside.

---

##### `srcdir`<sup>Required</sup> <a name="srcdir" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.srcdir"></a>

```python
srcdir: str
```

- *Type:* str

The directory in which the .ts sources reside.

---

##### `testdir`<sup>Required</sup> <a name="testdir" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.testdir"></a>

```python
testdir: str
```

- *Type:* str

The directory in which tests reside.

---

##### `tsconfig_dev`<sup>Required</sup> <a name="tsconfig_dev" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.tsconfigDev"></a>

```python
tsconfig_dev: TypescriptConfig
```

- *Type:* projen.javascript.TypescriptConfig

A typescript configuration file which covers all files (sources, tests, projen).

---

##### `watch_task`<sup>Required</sup> <a name="watch_task" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.watchTask"></a>

```python
watch_task: Task
```

- *Type:* projen.Task

The "watch" task.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.docgen"></a>

```python
docgen: bool
```

- *Type:* bool

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.eslint"></a>

```python
eslint: Eslint
```

- *Type:* projen.javascript.Eslint

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.tsconfig"></a>

```python
tsconfig: TypescriptConfig
```

- *Type:* projen.javascript.TypescriptConfig

---

##### `tsconfig_eslint`<sup>Optional</sup> <a name="tsconfig_eslint" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.tsconfigEslint"></a>

```python
tsconfig_eslint: TypescriptConfig
```

- *Type:* projen.javascript.TypescriptConfig

---

##### `nx_json`<sup>Required</sup> <a name="nx_json" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.nxJson"></a>

```python
nx_json: JsonFile
```

- *Type:* projen.JsonFile

---

##### `sub_projects`<sup>Required</sup> <a name="sub_projects" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.subProjects"></a>

```python
sub_projects: typing.List[Project]
```

- *Type:* typing.List[projen.Project]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>str</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/nx-monorepo.NxMonorepoProject.property.DEFAULT_TASK"></a>

```python
DEFAULT_TASK: str
```

- *Type:* str

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---


## Enums <a name="Enums" id="Enums"></a>

### TargetDependencyProject <a name="TargetDependencyProject" id="@aws-prototyping-sdk/nx-monorepo.Nx.TargetDependencyProject"></a>

Supported enums for a TargetDependency.

#### Members <a name="Members" id="Members"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.TargetDependencyProject.SELF">SELF</a></code> | Only rely on the package where the target is called. |
| <code><a href="#@aws-prototyping-sdk/nx-monorepo.Nx.TargetDependencyProject.DEPENDENCIES">DEPENDENCIES</a></code> | Target relies on executing the target against all dependencies first. |

---

##### `SELF` <a name="SELF" id="@aws-prototyping-sdk/nx-monorepo.Nx.TargetDependencyProject.SELF"></a>

Only rely on the package where the target is called.

This is usually done for test like targets where you only want to run unit
tests on the target packages without testing all dependent packages.

---


##### `DEPENDENCIES` <a name="DEPENDENCIES" id="@aws-prototyping-sdk/nx-monorepo.Nx.TargetDependencyProject.DEPENDENCIES"></a>

Target relies on executing the target against all dependencies first.

This is usually done for build like targets where you want to build all
dependant projects first.

---

