"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatFiles = void 0;
const tslib_1 = require("tslib");
const path = require("path");
// eslint-disable-next-line @typescript-eslint/no-restricted-imports
const object_sort_1 = require("nx/src/utils/object-sort");
const nx_1 = require("../../nx");
const { updateJson, readJson } = (0, nx_1.requireNx)();
/**
 * Formats all the created or updated files using Prettier
 * @param tree - the file system tree
 */
function formatFiles(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        let prettier;
        try {
            prettier = yield Promise.resolve().then(() => require('prettier'));
        }
        catch (_a) { }
        sortTsConfig(tree);
        if (!prettier)
            return;
        const files = new Set(tree.listChanges().filter((file) => file.type !== 'DELETE'));
        yield Promise.all(Array.from(files).map((file) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const systemPath = path.join(tree.root, file.path);
            const resolvedOptions = yield prettier.resolveConfig(systemPath, {
                editorconfig: true,
            });
            let optionsFromTree;
            if (!resolvedOptions) {
                try {
                    optionsFromTree = readJson(tree, '.prettierrc');
                }
                catch (_b) { }
            }
            const options = Object.assign({ filepath: systemPath }, (resolvedOptions !== null && resolvedOptions !== void 0 ? resolvedOptions : optionsFromTree));
            if (file.path.endsWith('.swcrc')) {
                options.parser = 'json';
            }
            const support = yield prettier.getFileInfo(systemPath, options);
            if (support.ignored || !support.inferredParser) {
                return;
            }
            try {
                tree.write(file.path, prettier.format(file.content.toString('utf-8'), options));
            }
            catch (e) {
                console.warn(`Could not format ${file.path}. Error: "${e.message}"`);
            }
        })));
    });
}
exports.formatFiles = formatFiles;
function sortTsConfig(tree) {
    try {
        const tsConfigPath = getRootTsConfigPath(tree);
        if (!tsConfigPath) {
            return;
        }
        updateJson(tree, tsConfigPath, (tsconfig) => (Object.assign(Object.assign({}, tsconfig), { compilerOptions: Object.assign(Object.assign({}, tsconfig.compilerOptions), { paths: (0, object_sort_1.sortObjectByKeys)(tsconfig.compilerOptions.paths) }) })));
    }
    catch (e) {
        // catch noop
    }
}
function getRootTsConfigPath(tree) {
    for (const path of ['tsconfig.base.json', 'tsconfig.json']) {
        if (tree.exists(path)) {
            return path;
        }
    }
    return null;
}
//# sourceMappingURL=format-files.js.map