"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.targetToTargetString = exports.parseTargetString = void 0;
// eslint-disable-next-line @typescript-eslint/no-restricted-imports
const split_target_1 = require("nx/src/utils/split-target");
const nx_1 = require("../../nx");
const { readCachedProjectGraph } = (0, nx_1.requireNx)();
function parseTargetString(targetString, projectGraph = readCachedProjectGraph()) {
    const [project, target, configuration] = (0, split_target_1.splitTarget)(targetString, projectGraph);
    if (!project || !target) {
        throw new Error(`Invalid Target String: ${targetString}`);
    }
    return {
        project,
        target,
        configuration,
    };
}
exports.parseTargetString = parseTargetString;
/**
 * Returns a string in the format "project:target[:configuration]" for the target
 *
 * @param target - target object
 *
 * Examples:
 *
 * ```typescript
 * targetToTargetString({ project: "proj", target: "test" }) // returns "proj:test"
 * targetToTargetString({ project: "proj", target: "test", configuration: "production" }) // returns "proj:test:production"
 * ```
 */
function targetToTargetString({ project, target, configuration, }) {
    return `${project}:${target.indexOf(':') > -1 ? `"${target}"` : target}${configuration !== undefined ? ':' + configuration : ''}`;
}
exports.targetToTargetString = targetToTargetString;
//# sourceMappingURL=parse-target-string.js.map