> **DEPRECATION NOTICE:** The `aws-prototyping-sdk` is on path to deprecation. This package is simply a wrapper around the individual `@aws-prototyping-skd/*` packages and has no unique code aside from bundling the other packages. Due to lack of significant value compared to maintenance overhead, this package will be deprecated soon in favor of using the individual packages directly. Please use the individual packages starting now to prevent future migration and loss of update capabilities.

The aws-prototyping-sdk provides stable CDK and Projen constructs, allowing developers to have access to higher level abstractions than provided by the CDK or Projen alone.

For detailed documentation, please refer to the [documentation website](https://aws.github.io/aws-prototyping-sdk/).

## Bundling

This package simply bundles various packages from the `@aws-prototyping-sdk` namespace which have been marked as `stable`. As such, not all constructs or classes may be exported from this package and will need to be explicitly imported by creating a dependency on the individual packages.

To illustrate, at the time of writing the following individual packages are published:

```
@aws-prototyping-sdk
        |_ pipeline       : [stable]
        |_ nx-monorepo    : [stable]
        |_ static-website : [experimental]
        |_ identity       : [experimental]
```

The aws-prototyping-sdk package will bundle all stable packages and export them as namespaces as follows:

```
aws-prototyping-sdk
        |_ pipeline
        |_ nx_monorepo
```

This means if you wanted to access the PDKPipeline which is a stable construct, you simply add a dependency on the `aws-prototyping-sdk` and import it as follows:

```ts
import { nx_monorepo, pipeline } from "aws-prototyping-sdk";
```

To import `experimental` constructs, a dependency on the individual package is required. In the case of `static-website`, a dependency on `@aws-prototyping-sdk/static-website` is required. The constructs can then be imported as follows:

```ts
import { StaticWebsite } from "@aws-prototyping-sdk/static-website";
```

# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### PDKNagApp <a name="PDKNagApp" id="aws-prototyping-sdk.pdk_nag.PDKNagApp"></a>

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

new pdk_nag.PDKNagApp(props?: PDKNagAppProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.props">props</a></code> | <code>aws-prototyping-sdk.pdk_nag.PDKNagAppProps</code> | *No description.* |

---

##### `props`<sup>Optional</sup> <a name="props" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.props"></a>

- *Type:* aws-prototyping-sdk.pdk_nag.PDKNagAppProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.synth">synth</a></code> | Synthesize this stage into a cloud assembly. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.addNagResult">addNagResult</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.nagResults">nagResults</a></code> | Returns a list of NagResult. |

---

##### `toString` <a name="toString" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `synth` <a name="synth" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.synth"></a>

```typescript
public synth(options?: StageSynthesisOptions): CloudAssembly
```

Synthesize this stage into a cloud assembly.

Once an assembly has been synthesized, it cannot be modified. Subsequent
calls will return the same assembly.

###### `options`<sup>Optional</sup> <a name="options" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.synth.parameter.options"></a>

- *Type:* aws-cdk-lib.StageSynthesisOptions

---

##### `addNagResult` <a name="addNagResult" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.addNagResult"></a>

```typescript
public addNagResult(result: NagResult): void
```

###### `result`<sup>Required</sup> <a name="result" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.addNagResult.parameter.result"></a>

- *Type:* aws-prototyping-sdk.pdk_nag.NagResult

---

##### `nagResults` <a name="nagResults" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.nagResults"></a>

```typescript
public nagResults(): NagResult[]
```

Returns a list of NagResult.

Note: app.synth() must be called before this to retrieve results.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.isStage">isStage</a></code> | Test whether the given construct is a stage. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.of">of</a></code> | Return the stage this construct is contained with, if available. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.isApp">isApp</a></code> | Checks if an object is an instance of the `App` class. |

---

##### `isConstruct` <a name="isConstruct" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isConstruct"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

pdk_nag.PDKNagApp.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isStage` <a name="isStage" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isStage"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

pdk_nag.PDKNagApp.isStage(x: any)
```

Test whether the given construct is a stage.

###### `x`<sup>Required</sup> <a name="x" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isStage.parameter.x"></a>

- *Type:* any

---

##### `of` <a name="of" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.of"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

pdk_nag.PDKNagApp.of(construct: IConstruct)
```

Return the stage this construct is contained with, if available.

If called
on a nested stage, returns its parent.

###### `construct`<sup>Required</sup> <a name="construct" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.of.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isApp` <a name="isApp" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isApp"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

pdk_nag.PDKNagApp.isApp(obj: any)
```

Checks if an object is an instance of the `App` class.

###### `obj`<sup>Required</sup> <a name="obj" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isApp.parameter.obj"></a>

- *Type:* any

The object to evaluate.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.artifactId">artifactId</a></code> | <code>string</code> | Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.assetOutdir">assetOutdir</a></code> | <code>string</code> | The cloud assembly asset output directory. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.outdir">outdir</a></code> | <code>string</code> | The cloud assembly output directory. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.stageName">stageName</a></code> | <code>string</code> | The name of the stage. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.account">account</a></code> | <code>string</code> | The default account for all resources defined within this stage. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.parentStage">parentStage</a></code> | <code>aws-cdk-lib.Stage</code> | The parent stage or `undefined` if this is the app. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.region">region</a></code> | <code>string</code> | The default region for all resources defined within this stage. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.nagPacks">nagPacks</a></code> | <code>cdk-nag.NagPack[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.artifactId"></a>

```typescript
public readonly artifactId: string;
```

- *Type:* string

Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string.

Derived from the construct path.

---

##### `assetOutdir`<sup>Required</sup> <a name="assetOutdir" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.assetOutdir"></a>

```typescript
public readonly assetOutdir: string;
```

- *Type:* string

The cloud assembly asset output directory.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string

The cloud assembly output directory.

---

##### `stageName`<sup>Required</sup> <a name="stageName" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.stageName"></a>

```typescript
public readonly stageName: string;
```

- *Type:* string

The name of the stage.

Based on names of the parent stages separated by
hypens.

---

##### `account`<sup>Optional</sup> <a name="account" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string

The default account for all resources defined within this stage.

---

##### `parentStage`<sup>Optional</sup> <a name="parentStage" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.parentStage"></a>

```typescript
public readonly parentStage: Stage;
```

- *Type:* aws-cdk-lib.Stage

The parent stage or `undefined` if this is the app.

*

---

##### `region`<sup>Optional</sup> <a name="region" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string

The default region for all resources defined within this stage.

---

##### `nagPacks`<sup>Required</sup> <a name="nagPacks" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.nagPacks"></a>

```typescript
public readonly nagPacks: NagPack[];
```

- *Type:* cdk-nag.NagPack[]

---


### PDKPipeline <a name="PDKPipeline" id="aws-prototyping-sdk.pipeline.PDKPipeline"></a>

An extension to CodePipeline which configures sane defaults for a NX Monorepo codebase.

In addition to this, it also creates a CodeCommit repository with
automated PR builds and approvals.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

new pipeline.PDKPipeline(scope: Construct, id: string, props: PDKPipelineProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.props">props</a></code> | <code>aws-prototyping-sdk.pipeline.PDKPipelineProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.props"></a>

- *Type:* aws-prototyping-sdk.pipeline.PDKPipelineProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.addStage">addStage</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.buildPipeline">buildPipeline</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.suppressCDKViolations">suppressCDKViolations</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="aws-prototyping-sdk.pipeline.PDKPipeline.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addStage` <a name="addStage" id="aws-prototyping-sdk.pipeline.PDKPipeline.addStage"></a>

```typescript
public addStage(stage: Stage, options?: AddStageOpts): StageDeployment
```

###### `stage`<sup>Required</sup> <a name="stage" id="aws-prototyping-sdk.pipeline.PDKPipeline.addStage.parameter.stage"></a>

- *Type:* aws-cdk-lib.Stage

---

###### `options`<sup>Optional</sup> <a name="options" id="aws-prototyping-sdk.pipeline.PDKPipeline.addStage.parameter.options"></a>

- *Type:* aws-cdk-lib.pipelines.AddStageOpts

---

##### `buildPipeline` <a name="buildPipeline" id="aws-prototyping-sdk.pipeline.PDKPipeline.buildPipeline"></a>

```typescript
public buildPipeline(): void
```

##### `suppressCDKViolations` <a name="suppressCDKViolations" id="aws-prototyping-sdk.pipeline.PDKPipeline.suppressCDKViolations"></a>

```typescript
public suppressCDKViolations(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="aws-prototyping-sdk.pipeline.PDKPipeline.isConstruct"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

pipeline.PDKPipeline.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="aws-prototyping-sdk.pipeline.PDKPipeline.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.property.codePipeline">codePipeline</a></code> | <code>aws-cdk-lib.pipelines.CodePipeline</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.property.codeRepository">codeRepository</a></code> | <code>aws-cdk-lib.aws_codecommit.Repository</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="aws-prototyping-sdk.pipeline.PDKPipeline.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `codePipeline`<sup>Required</sup> <a name="codePipeline" id="aws-prototyping-sdk.pipeline.PDKPipeline.property.codePipeline"></a>

```typescript
public readonly codePipeline: CodePipeline;
```

- *Type:* aws-cdk-lib.pipelines.CodePipeline

---

##### `codeRepository`<sup>Required</sup> <a name="codeRepository" id="aws-prototyping-sdk.pipeline.PDKPipeline.property.codeRepository"></a>

```typescript
public readonly codeRepository: Repository;
```

- *Type:* aws-cdk-lib.aws_codecommit.Repository

---


### SonarCodeScanner <a name="SonarCodeScanner" id="aws-prototyping-sdk.pipeline.SonarCodeScanner"></a>

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

new pipeline.SonarCodeScanner(scope: Construct, id: string, props: SonarCodeScannerProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.props">props</a></code> | <code>aws-prototyping-sdk.pipeline.SonarCodeScannerProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.props"></a>

- *Type:* aws-prototyping-sdk.pipeline.SonarCodeScannerProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.isConstruct"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

pipeline.SonarCodeScanner.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---


## Structs <a name="Structs" id="Structs"></a>

### Message <a name="Message" id="aws-prototyping-sdk.pdk_nag.Message"></a>

Message instance.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pdk_nag.Message.Initializer"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

const message: pdk_nag.Message = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.Message.property.messageDescription">messageDescription</a></code> | <code>string</code> | Message description. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.Message.property.messageType">messageType</a></code> | <code>string</code> | Message type as returned from cdk-nag. |

---

##### `messageDescription`<sup>Required</sup> <a name="messageDescription" id="aws-prototyping-sdk.pdk_nag.Message.property.messageDescription"></a>

```typescript
public readonly messageDescription: string;
```

- *Type:* string

Message description.

---

##### `messageType`<sup>Required</sup> <a name="messageType" id="aws-prototyping-sdk.pdk_nag.Message.property.messageType"></a>

```typescript
public readonly messageType: string;
```

- *Type:* string

Message type as returned from cdk-nag.

---

### MonorepoUpgradeDepsOptions <a name="MonorepoUpgradeDepsOptions" id="aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions"></a>

Configuration for Monorepo Upgrade Deps task.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.Initializer"></a>

```typescript
import { nx_monorepo } from 'aws-prototyping-sdk'

const monorepoUpgradeDepsOptions: nx_monorepo.MonorepoUpgradeDepsOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.property.syncpackConfig">syncpackConfig</a></code> | <code>aws-prototyping-sdk.nx_monorepo.SyncpackConfig</code> | Syncpack configuration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.property.taskName">taskName</a></code> | <code>string</code> | Name of the task to create. |

---

##### `syncpackConfig`<sup>Optional</sup> <a name="syncpackConfig" id="aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.property.syncpackConfig"></a>

```typescript
public readonly syncpackConfig: SyncpackConfig;
```

- *Type:* aws-prototyping-sdk.nx_monorepo.SyncpackConfig
- *Default:* SyncpackConfig.DEFAULT_CONFIG

Syncpack configuration.

No merging is performed and as such a complete syncpackConfig is required if supplied.

---

##### `taskName`<sup>Optional</sup> <a name="taskName" id="aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.property.taskName"></a>

```typescript
public readonly taskName: string;
```

- *Type:* string
- *Default:* upgrade-deps

Name of the task to create.

---

### NagResult <a name="NagResult" id="aws-prototyping-sdk.pdk_nag.NagResult"></a>

Nag result.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pdk_nag.NagResult.Initializer"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

const nagResult: pdk_nag.NagResult = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.NagResult.property.messages">messages</a></code> | <code>aws-prototyping-sdk.pdk_nag.Message[]</code> | List of messages. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.NagResult.property.resource">resource</a></code> | <code>string</code> | Resource which triggered the message. |

---

##### `messages`<sup>Required</sup> <a name="messages" id="aws-prototyping-sdk.pdk_nag.NagResult.property.messages"></a>

```typescript
public readonly messages: Message[];
```

- *Type:* aws-prototyping-sdk.pdk_nag.Message[]

List of messages.

---

##### `resource`<sup>Required</sup> <a name="resource" id="aws-prototyping-sdk.pdk_nag.NagResult.property.resource"></a>

```typescript
public readonly resource: string;
```

- *Type:* string

Resource which triggered the message.

---

### NxMonorepoProjectOptions <a name="NxMonorepoProjectOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions"></a>

Configuration options for the NxMonorepoProject.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.Initializer"></a>

```typescript
import { nx_monorepo } from 'aws-prototyping-sdk'

const nxMonorepoProjectOptions: nx_monorepo.NxMonorepoProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.name">name</a></code> | <code>string</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitOptions">gitOptions</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.outdir">outdir</a></code> | <code>string</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenCommand">projenCommand</a></code> | <code>string</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.renovatebot">renovatebot</a></code> | <code>boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoMerge">autoMerge</a></code> | <code>boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.clobber">clobber</a></code> | <code>boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.devContainer">devContainer</a></code> | <code>boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.github">github</a></code> | <code>boolean</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.githubOptions">githubOptions</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitpod">gitpod</a></code> | <code>boolean</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mergify">mergify</a></code> | <code>boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>string</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.stale">stale</a></code> | <code>boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.staleOptions">staleOptions</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.vscode">vscode</a></code> | <code>boolean</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>boolean</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorEmail">authorEmail</a></code> | <code>string</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorName">authorName</a></code> | <code>string</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorOrganization">authorOrganization</a></code> | <code>boolean</code> | Is the author an organization. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorUrl">authorUrl</a></code> | <code>string</code> | Author's URL / Website. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoDetectBin">autoDetectBin</a></code> | <code>boolean</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bin">bin</a></code> | <code>{[ key: string ]: string}</code> | Binary programs vended with your module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bugsEmail">bugsEmail</a></code> | <code>string</code> | The email address to which issues should be reported. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bugsUrl">bugsUrl</a></code> | <code>string</code> | The url to your project's issue tracker. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bundledDeps">bundledDeps</a></code> | <code>string[]</code> | List of dependencies to bundle into this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeArtifactOptions">codeArtifactOptions</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.deps">deps</a></code> | <code>string[]</code> | Runtime dependencies of this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.description">description</a></code> | <code>string</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.devDeps">devDeps</a></code> | <code>string[]</code> | Build dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.entrypoint">entrypoint</a></code> | <code>string</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.homepage">homepage</a></code> | <code>string</code> | Package's Homepage / Website. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.keywords">keywords</a></code> | <code>string[]</code> | Keywords to include in `package.json`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.license">license</a></code> | <code>string</code> | License's SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.licensed">licensed</a></code> | <code>boolean</code> | Indicates if a license should be added. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.maxNodeVersion">maxNodeVersion</a></code> | <code>string</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.minNodeVersion">minNodeVersion</a></code> | <code>string</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmAccess">npmAccess</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmRegistry">npmRegistry</a></code> | <code>string</code> | The host name of the npm registry to publish to. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmRegistryUrl">npmRegistryUrl</a></code> | <code>string</code> | The base URL of the npm package registry. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmTokenSecret">npmTokenSecret</a></code> | <code>string</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.packageManager">packageManager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.packageName">packageName</a></code> | <code>string</code> | The "name" in package.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.peerDependencyOptions">peerDependencyOptions</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.peerDeps">peerDeps</a></code> | <code>string[]</code> | Peer dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pnpmVersion">pnpmVersion</a></code> | <code>string</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.repository">repository</a></code> | <code>string</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.repositoryDirectory">repositoryDirectory</a></code> | <code>string</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.scopedPackagesOptions">scopedPackagesOptions</a></code> | <code>projen.javascript.ScopedPackagesOptions[]</code> | Options for privately hosted scoped packages. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.scripts">scripts</a></code> | <code>{[ key: string ]: string}</code> | npm scripts to include. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.stability">stability</a></code> | <code>string</code> | Package's Stability. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jsiiReleaseVersion">jsiiReleaseVersion</a></code> | <code>string</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.majorVersion">majorVersion</a></code> | <code>number</code> | Major version to release from the default branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.minMajorVersion">minMajorVersion</a></code> | <code>number</code> | Minimal Major version to release. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmDistTag">npmDistTag</a></code> | <code>string</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.postBuildSteps">postBuildSteps</a></code> | <code>projen.github.workflows.JobStep[]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prerelease">prerelease</a></code> | <code>string</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.publishDryRun">publishDryRun</a></code> | <code>boolean</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.publishTasks">publishTasks</a></code> | <code>boolean</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseBranches">releaseBranches</a></code> | <code>{[ key: string ]: projen.release.BranchOptions}</code> | Defines additional release branches. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseEveryCommit">releaseEveryCommit</a></code> | <code>boolean</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseFailureIssue">releaseFailureIssue</a></code> | <code>boolean</code> | Create a github issue on every failed publishing task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseFailureIssueLabel">releaseFailureIssueLabel</a></code> | <code>string</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseSchedule">releaseSchedule</a></code> | <code>string</code> | CRON schedule to trigger new releases. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseTagPrefix">releaseTagPrefix</a></code> | <code>string</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseTrigger">releaseTrigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflowName">releaseWorkflowName</a></code> | <code>string</code> | The name of the default release workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflowSetupSteps">releaseWorkflowSetupSteps</a></code> | <code>projen.github.workflows.JobStep[]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.versionrcOptions">versionrcOptions</a></code> | <code>{[ key: string ]: any}</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowContainerImage">workflowContainerImage</a></code> | <code>string</code> | Container image to use for GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowRunsOn">workflowRunsOn</a></code> | <code>string[]</code> | Github Runner selection labels. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.defaultReleaseBranch">defaultReleaseBranch</a></code> | <code>string</code> | The name of the main release branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.artifactsDirectory">artifactsDirectory</a></code> | <code>string</code> | A directory which will contain build artifacts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoApproveUpgrades">autoApproveUpgrades</a></code> | <code>boolean</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.buildWorkflow">buildWorkflow</a></code> | <code>boolean</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.buildWorkflowTriggers">buildWorkflowTriggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bundlerOptions">bundlerOptions</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeCov">codeCov</a></code> | <code>boolean</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeCovTokenSecret">codeCovTokenSecret</a></code> | <code>string</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.copyrightOwner">copyrightOwner</a></code> | <code>string</code> | License copyright owner. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.copyrightPeriod">copyrightPeriod</a></code> | <code>string</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.dependabot">dependabot</a></code> | <code>boolean</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.dependabotOptions">dependabotOptions</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.depsUpgrade">depsUpgrade</a></code> | <code>boolean</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.depsUpgradeOptions">depsUpgradeOptions</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitignore">gitignore</a></code> | <code>string[]</code> | Additional entries to .gitignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jest">jest</a></code> | <code>boolean</code> | Setup jest unit tests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jestOptions">jestOptions</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mutableBuild">mutableBuild</a></code> | <code>boolean</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmignore">npmignore</a></code> | <code>string[]</code> | Additional entries to .npmignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmignoreEnabled">npmignoreEnabled</a></code> | <code>boolean</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmIgnoreOptions">npmIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.package">package</a></code> | <code>boolean</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prettier">prettier</a></code> | <code>boolean</code> | Setup prettier. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prettierOptions">prettierOptions</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenDevDependency">projenDevDependency</a></code> | <code>boolean</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>boolean</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenVersion">projenVersion</a></code> | <code>string</code> | Version of projen to install. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pullRequestTemplate">pullRequestTemplate</a></code> | <code>boolean</code> | Include a GitHub pull request template. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pullRequestTemplateContents">pullRequestTemplateContents</a></code> | <code>string[]</code> | The contents of the pull request template. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.release">release</a></code> | <code>boolean</code> | Add release management to this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseToNpm">releaseToNpm</a></code> | <code>boolean</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflow">releaseWorkflow</a></code> | <code>boolean</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowBootstrapSteps">workflowBootstrapSteps</a></code> | <code>projen.github.workflows.JobStep[]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowGitIdentity">workflowGitIdentity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowNodeVersion">workflowNodeVersion</a></code> | <code>string</code> | The node version to use in GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.disableTsconfig">disableTsconfig</a></code> | <code>boolean</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.disableTsconfigDev">disableTsconfigDev</a></code> | <code>boolean</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.docgen">docgen</a></code> | <code>boolean</code> | Docgen by Typedoc. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.docsDirectory">docsDirectory</a></code> | <code>string</code> | Docs directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.entrypointTypes">entrypointTypes</a></code> | <code>string</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.eslint">eslint</a></code> | <code>boolean</code> | Setup eslint. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.eslintOptions">eslintOptions</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.libdir">libdir</a></code> | <code>string</code> | Typescript  artifacts output directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>boolean</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.sampleCode">sampleCode</a></code> | <code>boolean</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.srcdir">srcdir</a></code> | <code>string</code> | Typescript sources directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.testdir">testdir</a></code> | <code>string</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfigDev">tsconfigDev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfigDevFile">tsconfigDevFile</a></code> | <code>string</code> | The name of the development tsconfig.json file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.typescriptVersion">typescriptVersion</a></code> | <code>string</code> | TypeScript version to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDeps">monorepoUpgradeDeps</a></code> | <code>boolean</code> | Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDepsOptions">monorepoUpgradeDepsOptions</a></code> | <code>aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions</code> | Monorepo Upgrade Deps options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.nxConfig">nxConfig</a></code> | <code>aws-prototyping-sdk.nx_monorepo.Nx.WorkspaceConfig</code> | Configuration for NX. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workspaceConfig">workspaceConfig</a></code> | <code>aws-prototyping-sdk.nx_monorepo.WorkspaceConfig</code> | Configuration for workspace. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitIgnoreOptions"></a>

```typescript
public readonly gitIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitOptions"></a>

```typescript
public readonly gitOptions: GitOptions;
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.logging"></a>

```typescript
public readonly logging: LoggerOptions;
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJson"></a>

```typescript
public readonly projenrcJson: boolean;
```

- *Type:* boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJsonOptions"></a>

```typescript
public readonly projenrcJsonOptions: ProjenrcJsonOptions;
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.renovatebot"></a>

```typescript
public readonly renovatebot: boolean;
```

- *Type:* boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.renovatebotOptions"></a>

```typescript
public readonly renovatebotOptions: RenovatebotOptions;
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoApproveOptions"></a>

```typescript
public readonly autoApproveOptions: AutoApproveOptions;
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoMerge"></a>

```typescript
public readonly autoMerge: boolean;
```

- *Type:* boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoMergeOptions"></a>

```typescript
public readonly autoMergeOptions: AutoMergeOptions;
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.clobber"></a>

```typescript
public readonly clobber: boolean;
```

- *Type:* boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.devContainer"></a>

```typescript
public readonly devContainer: boolean;
```

- *Type:* boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.github"></a>

```typescript
public readonly github: boolean;
```

- *Type:* boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.githubOptions"></a>

```typescript
public readonly githubOptions: GitHubOptions;
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitpod"></a>

```typescript
public readonly gitpod: boolean;
```

- *Type:* boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```typescript
public readonly mergify: boolean;
```

- *Type:* boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```typescript
public readonly mergifyOptions: MergifyOptions;
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenCredentials"></a>

```typescript
public readonly projenCredentials: GithubCredentials;
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```typescript
public readonly projenTokenSecret: string;
```

- *Type:* string
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.readme"></a>

```typescript
public readonly readme: SampleReadmeProps;
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```typescript
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.stale"></a>

```typescript
public readonly stale: boolean;
```

- *Type:* boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.staleOptions"></a>

```typescript
public readonly staleOptions: StaleOptions;
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.vscode"></a>

```typescript
public readonly vscode: boolean;
```

- *Type:* boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allowLibraryDependencies`<sup>Optional</sup> <a name="allowLibraryDependencies" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.allowLibraryDependencies"></a>

```typescript
public readonly allowLibraryDependencies: boolean;
```

- *Type:* boolean
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `authorEmail`<sup>Optional</sup> <a name="authorEmail" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorEmail"></a>

```typescript
public readonly authorEmail: string;
```

- *Type:* string

Author's e-mail.

---

##### `authorName`<sup>Optional</sup> <a name="authorName" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorName"></a>

```typescript
public readonly authorName: string;
```

- *Type:* string

Author's name.

---

##### `authorOrganization`<sup>Optional</sup> <a name="authorOrganization" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorOrganization"></a>

```typescript
public readonly authorOrganization: boolean;
```

- *Type:* boolean

Is the author an organization.

---

##### `authorUrl`<sup>Optional</sup> <a name="authorUrl" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorUrl"></a>

```typescript
public readonly authorUrl: string;
```

- *Type:* string

Author's URL / Website.

---

##### `autoDetectBin`<sup>Optional</sup> <a name="autoDetectBin" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoDetectBin"></a>

```typescript
public readonly autoDetectBin: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bin"></a>

```typescript
public readonly bin: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugsEmail`<sup>Optional</sup> <a name="bugsEmail" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bugsEmail"></a>

```typescript
public readonly bugsEmail: string;
```

- *Type:* string

The email address to which issues should be reported.

---

##### `bugsUrl`<sup>Optional</sup> <a name="bugsUrl" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bugsUrl"></a>

```typescript
public readonly bugsUrl: string;
```

- *Type:* string

The url to your project's issue tracker.

---

##### `bundledDeps`<sup>Optional</sup> <a name="bundledDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bundledDeps"></a>

```typescript
public readonly bundledDeps: string[];
```

- *Type:* string[]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `codeArtifactOptions`<sup>Optional</sup> <a name="codeArtifactOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeArtifactOptions"></a>

```typescript
public readonly codeArtifactOptions: CodeArtifactOptions;
```

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.deps"></a>

```typescript
public readonly deps: string[];
```

- *Type:* string[]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```typescript
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.devDeps"></a>

```typescript
public readonly devDeps: string[];
```

- *Type:* string[]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```typescript
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.entrypoint"></a>

```typescript
public readonly entrypoint: string;
```

- *Type:* string
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.homepage"></a>

```typescript
public readonly homepage: string;
```

- *Type:* string

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.keywords"></a>

```typescript
public readonly keywords: string[];
```

- *Type:* string[]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.license"></a>

```typescript
public readonly license: string;
```

- *Type:* string
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.licensed"></a>

```typescript
public readonly licensed: boolean;
```

- *Type:* boolean
- *Default:* true

Indicates if a license should be added.

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.maxNodeVersion"></a>

```typescript
public readonly maxNodeVersion: string;
```

- *Type:* string
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.minNodeVersion"></a>

```typescript
public readonly minNodeVersion: string;
```

- *Type:* string
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npmAccess`<sup>Optional</sup> <a name="npmAccess" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmAccess"></a>

```typescript
public readonly npmAccess: NpmAccess;
```

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npmRegistry`~~<sup>Optional</sup> <a name="npmRegistry" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```typescript
public readonly npmRegistry: string;
```

- *Type:* string

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npmRegistryUrl`<sup>Optional</sup> <a name="npmRegistryUrl" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmRegistryUrl"></a>

```typescript
public readonly npmRegistryUrl: string;
```

- *Type:* string
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npmTokenSecret`<sup>Optional</sup> <a name="npmTokenSecret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmTokenSecret"></a>

```typescript
public readonly npmTokenSecret: string;
```

- *Type:* string
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `packageManager`<sup>Optional</sup> <a name="packageManager" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.packageManager"></a>

```typescript
public readonly packageManager: NodePackageManager;
```

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.packageName"></a>

```typescript
public readonly packageName: string;
```

- *Type:* string
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peerDependencyOptions`<sup>Optional</sup> <a name="peerDependencyOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.peerDependencyOptions"></a>

```typescript
public readonly peerDependencyOptions: PeerDependencyOptions;
```

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peerDeps`<sup>Optional</sup> <a name="peerDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.peerDeps"></a>

```typescript
public readonly peerDeps: string[];
```

- *Type:* string[]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpmVersion`<sup>Optional</sup> <a name="pnpmVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pnpmVersion"></a>

```typescript
public readonly pnpmVersion: string;
```

- *Type:* string
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.repository"></a>

```typescript
public readonly repository: string;
```

- *Type:* string

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repositoryDirectory`<sup>Optional</sup> <a name="repositoryDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.repositoryDirectory"></a>

```typescript
public readonly repositoryDirectory: string;
```

- *Type:* string

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scopedPackagesOptions`<sup>Optional</sup> <a name="scopedPackagesOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.scopedPackagesOptions"></a>

```typescript
public readonly scopedPackagesOptions: ScopedPackagesOptions[];
```

- *Type:* projen.javascript.ScopedPackagesOptions[]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```typescript
public readonly scripts: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.stability"></a>

```typescript
public readonly stability: string;
```

- *Type:* string

Package's Stability.

---

##### `jsiiReleaseVersion`<sup>Optional</sup> <a name="jsiiReleaseVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jsiiReleaseVersion"></a>

```typescript
public readonly jsiiReleaseVersion: string;
```

- *Type:* string
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `majorVersion`<sup>Optional</sup> <a name="majorVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.majorVersion"></a>

```typescript
public readonly majorVersion: number;
```

- *Type:* number
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `minMajorVersion`<sup>Optional</sup> <a name="minMajorVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.minMajorVersion"></a>

```typescript
public readonly minMajorVersion: number;
```

- *Type:* number
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npmDistTag`<sup>Optional</sup> <a name="npmDistTag" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmDistTag"></a>

```typescript
public readonly npmDistTag: string;
```

- *Type:* string
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `postBuildSteps`<sup>Optional</sup> <a name="postBuildSteps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.postBuildSteps"></a>

```typescript
public readonly postBuildSteps: JobStep[];
```

- *Type:* projen.github.workflows.JobStep[]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prerelease"></a>

```typescript
public readonly prerelease: string;
```

- *Type:* string
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publishDryRun`<sup>Optional</sup> <a name="publishDryRun" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.publishDryRun"></a>

```typescript
public readonly publishDryRun: boolean;
```

- *Type:* boolean
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publishTasks`<sup>Optional</sup> <a name="publishTasks" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.publishTasks"></a>

```typescript
public readonly publishTasks: boolean;
```

- *Type:* boolean
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `releaseBranches`<sup>Optional</sup> <a name="releaseBranches" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseBranches"></a>

```typescript
public readonly releaseBranches: {[ key: string ]: BranchOptions};
```

- *Type:* {[ key: string ]: projen.release.BranchOptions}
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`releaseEveryCommit`~~<sup>Optional</sup> <a name="releaseEveryCommit" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```typescript
public readonly releaseEveryCommit: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `releaseFailureIssue`<sup>Optional</sup> <a name="releaseFailureIssue" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseFailureIssue"></a>

```typescript
public readonly releaseFailureIssue: boolean;
```

- *Type:* boolean
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `releaseFailureIssueLabel`<sup>Optional</sup> <a name="releaseFailureIssueLabel" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseFailureIssueLabel"></a>

```typescript
public readonly releaseFailureIssueLabel: string;
```

- *Type:* string
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`releaseSchedule`~~<sup>Optional</sup> <a name="releaseSchedule" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```typescript
public readonly releaseSchedule: string;
```

- *Type:* string
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `releaseTagPrefix`<sup>Optional</sup> <a name="releaseTagPrefix" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseTagPrefix"></a>

```typescript
public readonly releaseTagPrefix: string;
```

- *Type:* string
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `releaseTrigger`<sup>Optional</sup> <a name="releaseTrigger" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseTrigger"></a>

```typescript
public readonly releaseTrigger: ReleaseTrigger;
```

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `releaseWorkflowName`<sup>Optional</sup> <a name="releaseWorkflowName" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflowName"></a>

```typescript
public readonly releaseWorkflowName: string;
```

- *Type:* string
- *Default:* "Release"

The name of the default release workflow.

---

##### `releaseWorkflowSetupSteps`<sup>Optional</sup> <a name="releaseWorkflowSetupSteps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflowSetupSteps"></a>

```typescript
public readonly releaseWorkflowSetupSteps: JobStep[];
```

- *Type:* projen.github.workflows.JobStep[]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrcOptions`<sup>Optional</sup> <a name="versionrcOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.versionrcOptions"></a>

```typescript
public readonly versionrcOptions: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflowContainerImage`<sup>Optional</sup> <a name="workflowContainerImage" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowContainerImage"></a>

```typescript
public readonly workflowContainerImage: string;
```

- *Type:* string
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflowRunsOn`<sup>Optional</sup> <a name="workflowRunsOn" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowRunsOn"></a>

```typescript
public readonly workflowRunsOn: string[];
```

- *Type:* string[]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `defaultReleaseBranch`<sup>Required</sup> <a name="defaultReleaseBranch" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.defaultReleaseBranch"></a>

```typescript
public readonly defaultReleaseBranch: string;
```

- *Type:* string
- *Default:* "main"

The name of the main release branch.

---

##### `artifactsDirectory`<sup>Optional</sup> <a name="artifactsDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.artifactsDirectory"></a>

```typescript
public readonly artifactsDirectory: string;
```

- *Type:* string
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `autoApproveUpgrades`<sup>Optional</sup> <a name="autoApproveUpgrades" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoApproveUpgrades"></a>

```typescript
public readonly autoApproveUpgrades: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.buildWorkflow"></a>

```typescript
public readonly buildWorkflow: boolean;
```

- *Type:* boolean
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `buildWorkflowTriggers`<sup>Optional</sup> <a name="buildWorkflowTriggers" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.buildWorkflowTriggers"></a>

```typescript
public readonly buildWorkflowTriggers: Triggers;
```

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundlerOptions`<sup>Optional</sup> <a name="bundlerOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bundlerOptions"></a>

```typescript
public readonly bundlerOptions: BundlerOptions;
```

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `codeCov`<sup>Optional</sup> <a name="codeCov" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeCov"></a>

```typescript
public readonly codeCov: boolean;
```

- *Type:* boolean
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret.

---

##### `codeCovTokenSecret`<sup>Optional</sup> <a name="codeCovTokenSecret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeCovTokenSecret"></a>

```typescript
public readonly codeCovTokenSecret: string;
```

- *Type:* string
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyrightOwner`<sup>Optional</sup> <a name="copyrightOwner" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.copyrightOwner"></a>

```typescript
public readonly copyrightOwner: string;
```

- *Type:* string
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyrightPeriod`<sup>Optional</sup> <a name="copyrightPeriod" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.copyrightPeriod"></a>

```typescript
public readonly copyrightPeriod: string;
```

- *Type:* string
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.dependabot"></a>

```typescript
public readonly dependabot: boolean;
```

- *Type:* boolean
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabotOptions`<sup>Optional</sup> <a name="dependabotOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.dependabotOptions"></a>

```typescript
public readonly dependabotOptions: DependabotOptions;
```

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `depsUpgrade`<sup>Optional</sup> <a name="depsUpgrade" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.depsUpgrade"></a>

```typescript
public readonly depsUpgrade: boolean;
```

- *Type:* boolean
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `depsUpgradeOptions`<sup>Optional</sup> <a name="depsUpgradeOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.depsUpgradeOptions"></a>

```typescript
public readonly depsUpgradeOptions: UpgradeDependenciesOptions;
```

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitignore"></a>

```typescript
public readonly gitignore: string[];
```

- *Type:* string[]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jest"></a>

```typescript
public readonly jest: boolean;
```

- *Type:* boolean
- *Default:* true

Setup jest unit tests.

---

##### `jestOptions`<sup>Optional</sup> <a name="jestOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jestOptions"></a>

```typescript
public readonly jestOptions: JestOptions;
```

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutableBuild`<sup>Optional</sup> <a name="mutableBuild" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mutableBuild"></a>

```typescript
public readonly mutableBuild: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```typescript
public readonly npmignore: string[];
```

- *Type:* string[]

Additional entries to .npmignore.

---

##### `npmignoreEnabled`<sup>Optional</sup> <a name="npmignoreEnabled" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmignoreEnabled"></a>

```typescript
public readonly npmignoreEnabled: boolean;
```

- *Type:* boolean
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npmIgnoreOptions`<sup>Optional</sup> <a name="npmIgnoreOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmIgnoreOptions"></a>

```typescript
public readonly npmIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.package"></a>

```typescript
public readonly package: boolean;
```

- *Type:* boolean
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prettier"></a>

```typescript
public readonly prettier: boolean;
```

- *Type:* boolean
- *Default:* false

Setup prettier.

---

##### `prettierOptions`<sup>Optional</sup> <a name="prettierOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prettierOptions"></a>

```typescript
public readonly prettierOptions: PrettierOptions;
```

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projenDevDependency`<sup>Optional</sup> <a name="projenDevDependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenDevDependency"></a>

```typescript
public readonly projenDevDependency: boolean;
```

- *Type:* boolean
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJs"></a>

```typescript
public readonly projenrcJs: boolean;
```

- *Type:* boolean
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJsOptions"></a>

```typescript
public readonly projenrcJsOptions: ProjenrcOptions;
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projenVersion`<sup>Optional</sup> <a name="projenVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenVersion"></a>

```typescript
public readonly projenVersion: string;
```

- *Type:* string
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pullRequestTemplate`<sup>Optional</sup> <a name="pullRequestTemplate" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pullRequestTemplate"></a>

```typescript
public readonly pullRequestTemplate: boolean;
```

- *Type:* boolean
- *Default:* true

Include a GitHub pull request template.

---

##### `pullRequestTemplateContents`<sup>Optional</sup> <a name="pullRequestTemplateContents" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pullRequestTemplateContents"></a>

```typescript
public readonly pullRequestTemplateContents: string[];
```

- *Type:* string[]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.release"></a>

```typescript
public readonly release: boolean;
```

- *Type:* boolean
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `releaseToNpm`<sup>Optional</sup> <a name="releaseToNpm" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseToNpm"></a>

```typescript
public readonly releaseToNpm: boolean;
```

- *Type:* boolean
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`releaseWorkflow`~~<sup>Optional</sup> <a name="releaseWorkflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```typescript
public readonly releaseWorkflow: boolean;
```

- *Type:* boolean
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflowBootstrapSteps`<sup>Optional</sup> <a name="workflowBootstrapSteps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowBootstrapSteps"></a>

```typescript
public readonly workflowBootstrapSteps: JobStep[];
```

- *Type:* projen.github.workflows.JobStep[]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflowGitIdentity`<sup>Optional</sup> <a name="workflowGitIdentity" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowGitIdentity"></a>

```typescript
public readonly workflowGitIdentity: GitIdentity;
```

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflowNodeVersion`<sup>Optional</sup> <a name="workflowNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowNodeVersion"></a>

```typescript
public readonly workflowNodeVersion: string;
```

- *Type:* string
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `disableTsconfig`<sup>Optional</sup> <a name="disableTsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.disableTsconfig"></a>

```typescript
public readonly disableTsconfig: boolean;
```

- *Type:* boolean
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disableTsconfigDev`<sup>Optional</sup> <a name="disableTsconfigDev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.disableTsconfigDev"></a>

```typescript
public readonly disableTsconfigDev: boolean;
```

- *Type:* boolean
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.docgen"></a>

```typescript
public readonly docgen: boolean;
```

- *Type:* boolean
- *Default:* false

Docgen by Typedoc.

---

##### `docsDirectory`<sup>Optional</sup> <a name="docsDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.docsDirectory"></a>

```typescript
public readonly docsDirectory: string;
```

- *Type:* string
- *Default:* "docs"

Docs directory.

---

##### `entrypointTypes`<sup>Optional</sup> <a name="entrypointTypes" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.entrypointTypes"></a>

```typescript
public readonly entrypointTypes: string;
```

- *Type:* string
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.eslint"></a>

```typescript
public readonly eslint: boolean;
```

- *Type:* boolean
- *Default:* true

Setup eslint.

---

##### `eslintOptions`<sup>Optional</sup> <a name="eslintOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.eslintOptions"></a>

```typescript
public readonly eslintOptions: EslintOptions;
```

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.libdir"></a>

```typescript
public readonly libdir: string;
```

- *Type:* string
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcTs"></a>

```typescript
public readonly projenrcTs: boolean;
```

- *Type:* boolean
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcTsOptions"></a>

```typescript
public readonly projenrcTsOptions: ProjenrcOptions;
```

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sampleCode`<sup>Optional</sup> <a name="sampleCode" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.sampleCode"></a>

```typescript
public readonly sampleCode: boolean;
```

- *Type:* boolean
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.srcdir"></a>

```typescript
public readonly srcdir: string;
```

- *Type:* string
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.testdir"></a>

```typescript
public readonly testdir: string;
```

- *Type:* string
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfig"></a>

```typescript
public readonly tsconfig: TypescriptConfigOptions;
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfigDev`<sup>Optional</sup> <a name="tsconfigDev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfigDev"></a>

```typescript
public readonly tsconfigDev: TypescriptConfigOptions;
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfigDevFile`<sup>Optional</sup> <a name="tsconfigDevFile" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfigDevFile"></a>

```typescript
public readonly tsconfigDevFile: string;
```

- *Type:* string
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescriptVersion`<sup>Optional</sup> <a name="typescriptVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.typescriptVersion"></a>

```typescript
public readonly typescriptVersion: string;
```

- *Type:* string
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `monorepoUpgradeDeps`<sup>Optional</sup> <a name="monorepoUpgradeDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDeps"></a>

```typescript
public readonly monorepoUpgradeDeps: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies.

---

##### `monorepoUpgradeDepsOptions`<sup>Optional</sup> <a name="monorepoUpgradeDepsOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDepsOptions"></a>

```typescript
public readonly monorepoUpgradeDepsOptions: MonorepoUpgradeDepsOptions;
```

- *Type:* aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions
- *Default:* undefined

Monorepo Upgrade Deps options.

This is only used if monorepoUpgradeDeps is true.

---

##### `nxConfig`<sup>Optional</sup> <a name="nxConfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.nxConfig"></a>

```typescript
public readonly nxConfig: WorkspaceConfig;
```

- *Type:* aws-prototyping-sdk.nx_monorepo.Nx.WorkspaceConfig

Configuration for NX.

---

##### `workspaceConfig`<sup>Optional</sup> <a name="workspaceConfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workspaceConfig"></a>

```typescript
public readonly workspaceConfig: WorkspaceConfig;
```

- *Type:* aws-prototyping-sdk.nx_monorepo.WorkspaceConfig

Configuration for workspace.

---

### NxRunManyOptions <a name="NxRunManyOptions" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions"></a>

> [https://nx.dev/packages/nx/documents/run-many#options](https://nx.dev/packages/nx/documents/run-many#options)

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.Initializer"></a>

```typescript
import { nx_monorepo } from 'aws-prototyping-sdk'

const nxRunManyOptions: nx_monorepo.NxRunManyOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.target">target</a></code> | <code>string</code> | Task to run for affected projects. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.configuration">configuration</a></code> | <code>string</code> | This is the configuration to use when performing tasks on projects. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.exclude">exclude</a></code> | <code>string</code> | Exclude certain projects from being processed. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.ignoreCycles">ignoreCycles</a></code> | <code>boolean</code> | Ignore cycles in the task graph. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.noBail">noBail</a></code> | <code>boolean</code> | Do not stop command execution after the first failed task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.outputStyle">outputStyle</a></code> | <code>string</code> | Defines how Nx emits outputs tasks logs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.parallel">parallel</a></code> | <code>number</code> | Max number of parallel processes. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.projects">projects</a></code> | <code>string[]</code> | Project to run as list project names and/or patterns. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.runner">runner</a></code> | <code>string</code> | This is the name of the tasks runner configuration in nx.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.skipCache">skipCache</a></code> | <code>boolean</code> | Rerun the tasks even when the results are available in the cache. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.verbose">verbose</a></code> | <code>boolean</code> | Prints additional information about the commands (e.g. stack traces). |

---

##### `target`<sup>Required</sup> <a name="target" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.target"></a>

```typescript
public readonly target: string;
```

- *Type:* string

Task to run for affected projects.

---

##### `configuration`<sup>Optional</sup> <a name="configuration" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.configuration"></a>

```typescript
public readonly configuration: string;
```

- *Type:* string

This is the configuration to use when performing tasks on projects.

---

##### `exclude`<sup>Optional</sup> <a name="exclude" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.exclude"></a>

```typescript
public readonly exclude: string;
```

- *Type:* string

Exclude certain projects from being processed.

---

##### `ignoreCycles`<sup>Optional</sup> <a name="ignoreCycles" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.ignoreCycles"></a>

```typescript
public readonly ignoreCycles: boolean;
```

- *Type:* boolean

Ignore cycles in the task graph.

---

##### `noBail`<sup>Optional</sup> <a name="noBail" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.noBail"></a>

```typescript
public readonly noBail: boolean;
```

- *Type:* boolean

Do not stop command execution after the first failed task.

---

##### `outputStyle`<sup>Optional</sup> <a name="outputStyle" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.outputStyle"></a>

```typescript
public readonly outputStyle: string;
```

- *Type:* string
- *Default:* "stream"

Defines how Nx emits outputs tasks logs.

---

##### `parallel`<sup>Optional</sup> <a name="parallel" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.parallel"></a>

```typescript
public readonly parallel: number;
```

- *Type:* number
- *Default:* 3

Max number of parallel processes.

---

##### `projects`<sup>Optional</sup> <a name="projects" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.projects"></a>

```typescript
public readonly projects: string[];
```

- *Type:* string[]

Project to run as list project names and/or patterns.

---

##### `runner`<sup>Optional</sup> <a name="runner" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.runner"></a>

```typescript
public readonly runner: string;
```

- *Type:* string

This is the name of the tasks runner configuration in nx.json.

---

##### `skipCache`<sup>Optional</sup> <a name="skipCache" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.skipCache"></a>

```typescript
public readonly skipCache: boolean;
```

- *Type:* boolean

Rerun the tasks even when the results are available in the cache.

---

##### `verbose`<sup>Optional</sup> <a name="verbose" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.verbose"></a>

```typescript
public readonly verbose: boolean;
```

- *Type:* boolean

Prints additional information about the commands (e.g. stack traces).

---

### PDKNagAppProps <a name="PDKNagAppProps" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.Initializer"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

const pDKNagAppProps: pdk_nag.PDKNagAppProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.analyticsReporting">analyticsReporting</a></code> | <code>boolean</code> | Include runtime versioning information in the Stacks of this app. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.autoSynth">autoSynth</a></code> | <code>boolean</code> | Automatically call `synth()` before the program exits. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.context">context</a></code> | <code>{[ key: string ]: any}</code> | Additional context values for the application. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.defaultStackSynthesizer">defaultStackSynthesizer</a></code> | <code>aws-cdk-lib.IReusableStackSynthesizer</code> | The stack synthesizer to use by default for all Stacks in the App. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.outdir">outdir</a></code> | <code>string</code> | The output directory into which to emit synthesized artifacts. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.postCliContext">postCliContext</a></code> | <code>{[ key: string ]: any}</code> | Additional context values for the application. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.stackTraces">stackTraces</a></code> | <code>boolean</code> | Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.treeMetadata">treeMetadata</a></code> | <code>boolean</code> | Include construct tree metadata as part of the Cloud Assembly. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.failOnError">failOnError</a></code> | <code>boolean</code> | Determines whether any errors encountered should trigger a test failure. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.failOnWarning">failOnWarning</a></code> | <code>boolean</code> | Determines whether any warnings encountered should trigger a test failure. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.nagPacks">nagPacks</a></code> | <code>cdk-nag.NagPack[]</code> | Custom nag packs to execute. |

---

##### `analyticsReporting`<sup>Optional</sup> <a name="analyticsReporting" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.analyticsReporting"></a>

```typescript
public readonly analyticsReporting: boolean;
```

- *Type:* boolean
- *Default:* Value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in the Stacks of this app.

---

##### `autoSynth`<sup>Optional</sup> <a name="autoSynth" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.autoSynth"></a>

```typescript
public readonly autoSynth: boolean;
```

- *Type:* boolean
- *Default:* true if running via CDK CLI (`CDK_OUTDIR` is set), `false` otherwise

Automatically call `synth()` before the program exits.

If you set this, you don't have to call `synth()` explicitly. Note that
this feature is only available for certain programming languages, and
calling `synth()` is still recommended.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.context"></a>

```typescript
public readonly context: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no additional context

Additional context values for the application.

Context set by the CLI or the `context` key in `cdk.json` has precedence.

Context can be read from any construct using `node.getContext(key)`.

---

##### `defaultStackSynthesizer`<sup>Optional</sup> <a name="defaultStackSynthesizer" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.defaultStackSynthesizer"></a>

```typescript
public readonly defaultStackSynthesizer: IReusableStackSynthesizer;
```

- *Type:* aws-cdk-lib.IReusableStackSynthesizer
- *Default:* A `DefaultStackSynthesizer` with default settings

The stack synthesizer to use by default for all Stacks in the App.

The Stack Synthesizer controls aspects of synthesis and deployment,
like how assets are referenced and what IAM roles to use. For more
information, see the README of the main CDK package.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string
- *Default:* If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.   If `CDK_OUTDIR` is not defined, uses a temp directory.

The output directory into which to emit synthesized artifacts.

You should never need to set this value. By default, the value you pass to
the CLI's `--output` flag will be used, and if you change it to a different
directory the CLI will fail to pick up the generated Cloud Assembly.

This property is intended for internal and testing use.

---

##### `postCliContext`<sup>Optional</sup> <a name="postCliContext" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.postCliContext"></a>

```typescript
public readonly postCliContext: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no additional context

Additional context values for the application.

Context provided here has precedence over context set by:

- The CLI via --context
- The `context` key in `cdk.json`
- The `AppProps.context` property

This property is recommended over the `AppProps.context` property since you
can make final decision over which context value to take in your app.

Context can be read from any construct using `node.getContext(key)`.

---

*Example*

```typescript
// context from the CLI and from `cdk.json` are stored in the
// CDK_CONTEXT env variable
const cliContext = JSON.parse(process.env.CDK_CONTEXT!);

// determine whether to take the context passed in the CLI or not
const determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
new App({
  postCliContext: {
    SOMEKEY: determineValue,
  },
});
```


##### `stackTraces`<sup>Optional</sup> <a name="stackTraces" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.stackTraces"></a>

```typescript
public readonly stackTraces: boolean;
```

- *Type:* boolean
- *Default:* true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.

Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.

---

##### `treeMetadata`<sup>Optional</sup> <a name="treeMetadata" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.treeMetadata"></a>

```typescript
public readonly treeMetadata: boolean;
```

- *Type:* boolean
- *Default:* true

Include construct tree metadata as part of the Cloud Assembly.

---

##### `failOnError`<sup>Optional</sup> <a name="failOnError" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.failOnError"></a>

```typescript
public readonly failOnError: boolean;
```

- *Type:* boolean
- *Default:* false

Determines whether any errors encountered should trigger a test failure.

---

##### `failOnWarning`<sup>Optional</sup> <a name="failOnWarning" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.failOnWarning"></a>

```typescript
public readonly failOnWarning: boolean;
```

- *Type:* boolean
- *Default:* false

Determines whether any warnings encountered should trigger a test failure.

---

##### `nagPacks`<sup>Optional</sup> <a name="nagPacks" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.nagPacks"></a>

```typescript
public readonly nagPacks: NagPack[];
```

- *Type:* cdk-nag.NagPack[]
- *Default:* DEFAULT_NAG_PACKS

Custom nag packs to execute.

---

### PDKPipelineJavaProjectOptions <a name="PDKPipelineJavaProjectOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions"></a>

Configuration options for the PDKPipelineJavaProject.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.Initializer"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

const pDKPipelineJavaProjectOptions: pipeline.PDKPipelineJavaProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.name">name</a></code> | <code>string</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitOptions">gitOptions</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.outdir">outdir</a></code> | <code>string</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenCommand">projenCommand</a></code> | <code>string</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.renovatebot">renovatebot</a></code> | <code>boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoMerge">autoMerge</a></code> | <code>boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.clobber">clobber</a></code> | <code>boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.devContainer">devContainer</a></code> | <code>boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.github">github</a></code> | <code>boolean</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.githubOptions">githubOptions</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitpod">gitpod</a></code> | <code>boolean</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mergify">mergify</a></code> | <code>boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>string</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.stale">stale</a></code> | <code>boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.staleOptions">staleOptions</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.vscode">vscode</a></code> | <code>boolean</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.artifactId">artifactId</a></code> | <code>string</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.groupId">groupId</a></code> | <code>string</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.version">version</a></code> | <code>string</code> | This is the last piece of the naming puzzle. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.description">description</a></code> | <code>string</code> | Description of a project is always good. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.packaging">packaging</a></code> | <code>string</code> | Project packaging format. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.url">url</a></code> | <code>string</code> | The URL, like the name, is not required. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.compileOptions">compileOptions</a></code> | <code>projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.deps">deps</a></code> | <code>string[]</code> | List of runtime dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.distdir">distdir</a></code> | <code>string</code> | Final artifact output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.junit">junit</a></code> | <code>boolean</code> | Include junit tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.junitOptions">junitOptions</a></code> | <code>projen.java.JunitOptions</code> | junit options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.packagingOptions">packagingOptions</a></code> | <code>projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJava">projenrcJava</a></code> | <code>boolean</code> | Use projenrc in java. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJavaOptions">projenrcJavaOptions</a></code> | <code>projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.testDeps">testDeps</a></code> | <code>string[]</code> | List of test dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.sample">sample</a></code> | <code>boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.sampleJavaPackage">sampleJavaPackage</a></code> | <code>string</code> | The java package to use for the code sample. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.buildCommand">buildCommand</a></code> | <code>string</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkout">cdkout</a></code> | <code>string</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.context">context</a></code> | <code>{[ key: string ]: any}</code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.featureFlags">featureFlags</a></code> | <code>boolean</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.requireApproval">requireApproval</a></code> | <code>projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.watchExcludes">watchExcludes</a></code> | <code>string[]</code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.watchIncludes">watchIncludes</a></code> | <code>string[]</code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkVersion">cdkVersion</a></code> | <code>string</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkAssert">cdkAssert</a></code> | <code>boolean</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkAssertions">cdkAssertions</a></code> | <code>boolean</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkDependencies">cdkDependencies</a></code> | <code>string[]</code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkDependenciesAsDeps">cdkDependenciesAsDeps</a></code> | <code>boolean</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkTestDependencies">cdkTestDependencies</a></code> | <code>string[]</code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkVersionPinning">cdkVersionPinning</a></code> | <code>boolean</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.constructsVersion">constructsVersion</a></code> | <code>string</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mainClass">mainClass</a></code> | <code>string</code> | The name of the Java class with the static `main()` method. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitIgnoreOptions"></a>

```typescript
public readonly gitIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitOptions"></a>

```typescript
public readonly gitOptions: GitOptions;
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.logging"></a>

```typescript
public readonly logging: LoggerOptions;
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJson"></a>

```typescript
public readonly projenrcJson: boolean;
```

- *Type:* boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJsonOptions"></a>

```typescript
public readonly projenrcJsonOptions: ProjenrcJsonOptions;
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.renovatebot"></a>

```typescript
public readonly renovatebot: boolean;
```

- *Type:* boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.renovatebotOptions"></a>

```typescript
public readonly renovatebotOptions: RenovatebotOptions;
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoApproveOptions"></a>

```typescript
public readonly autoApproveOptions: AutoApproveOptions;
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoMerge"></a>

```typescript
public readonly autoMerge: boolean;
```

- *Type:* boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoMergeOptions"></a>

```typescript
public readonly autoMergeOptions: AutoMergeOptions;
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.clobber"></a>

```typescript
public readonly clobber: boolean;
```

- *Type:* boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.devContainer"></a>

```typescript
public readonly devContainer: boolean;
```

- *Type:* boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.github"></a>

```typescript
public readonly github: boolean;
```

- *Type:* boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.githubOptions"></a>

```typescript
public readonly githubOptions: GitHubOptions;
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitpod"></a>

```typescript
public readonly gitpod: boolean;
```

- *Type:* boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```typescript
public readonly mergify: boolean;
```

- *Type:* boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```typescript
public readonly mergifyOptions: MergifyOptions;
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenCredentials"></a>

```typescript
public readonly projenCredentials: GithubCredentials;
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```typescript
public readonly projenTokenSecret: string;
```

- *Type:* string
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.readme"></a>

```typescript
public readonly readme: SampleReadmeProps;
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```typescript
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.stale"></a>

```typescript
public readonly stale: boolean;
```

- *Type:* boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.staleOptions"></a>

```typescript
public readonly staleOptions: StaleOptions;
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.vscode"></a>

```typescript
public readonly vscode: boolean;
```

- *Type:* boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.artifactId"></a>

```typescript
public readonly artifactId: string;
```

- *Type:* string
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.groupId"></a>

```typescript
public readonly groupId: string;
```

- *Type:* string
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.version"></a>

```typescript
public readonly version: string;
```

- *Type:* string
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.packaging"></a>

```typescript
public readonly packaging: string;
```

- *Type:* string
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.url"></a>

```typescript
public readonly url: string;
```

- *Type:* string
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compileOptions`<sup>Optional</sup> <a name="compileOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.compileOptions"></a>

```typescript
public readonly compileOptions: MavenCompileOptions;
```

- *Type:* projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.deps"></a>

```typescript
public readonly deps: string[];
```

- *Type:* string[]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.distdir"></a>

```typescript
public readonly distdir: string;
```

- *Type:* string
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.junit"></a>

```typescript
public readonly junit: boolean;
```

- *Type:* boolean
- *Default:* true

Include junit tests.

---

##### `junitOptions`<sup>Optional</sup> <a name="junitOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.junitOptions"></a>

```typescript
public readonly junitOptions: JunitOptions;
```

- *Type:* projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packagingOptions`<sup>Optional</sup> <a name="packagingOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.packagingOptions"></a>

```typescript
public readonly packagingOptions: MavenPackagingOptions;
```

- *Type:* projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrcJava`<sup>Optional</sup> <a name="projenrcJava" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJava"></a>

```typescript
public readonly projenrcJava: boolean;
```

- *Type:* boolean
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrcJavaOptions`<sup>Optional</sup> <a name="projenrcJavaOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJavaOptions"></a>

```typescript
public readonly projenrcJavaOptions: ProjenrcOptions;
```

- *Type:* projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `testDeps`<sup>Optional</sup> <a name="testDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.testDeps"></a>

```typescript
public readonly testDeps: string[];
```

- *Type:* string[]
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.sample"></a>

```typescript
public readonly sample: boolean;
```

- *Type:* boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sampleJavaPackage`<sup>Optional</sup> <a name="sampleJavaPackage" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.sampleJavaPackage"></a>

```typescript
public readonly sampleJavaPackage: string;
```

- *Type:* string
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `buildCommand`<sup>Optional</sup> <a name="buildCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.buildCommand"></a>

```typescript
public readonly buildCommand: string;
```

- *Type:* string
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkout"></a>

```typescript
public readonly cdkout: string;
```

- *Type:* string
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.context"></a>

```typescript
public readonly context: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `featureFlags`<sup>Optional</sup> <a name="featureFlags" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.featureFlags"></a>

```typescript
public readonly featureFlags: boolean;
```

- *Type:* boolean
- *Default:* true

Include all feature flags in cdk.json.

---

##### `requireApproval`<sup>Optional</sup> <a name="requireApproval" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.requireApproval"></a>

```typescript
public readonly requireApproval: ApprovalLevel;
```

- *Type:* projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watchExcludes`<sup>Optional</sup> <a name="watchExcludes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.watchExcludes"></a>

```typescript
public readonly watchExcludes: string[];
```

- *Type:* string[]
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watchIncludes`<sup>Optional</sup> <a name="watchIncludes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.watchIncludes"></a>

```typescript
public readonly watchIncludes: string[];
```

- *Type:* string[]
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkVersion"></a>

```typescript
public readonly cdkVersion: string;
```

- *Type:* string
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdkAssert`~~<sup>Optional</sup> <a name="cdkAssert" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkAssert"></a>

- *Deprecated:* The

```typescript
public readonly cdkAssert: boolean;
```

- *Type:* boolean
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdkAssertions`<sup>Optional</sup> <a name="cdkAssertions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkAssertions"></a>

```typescript
public readonly cdkAssertions: boolean;
```

- *Type:* boolean
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdkDependencies`~~<sup>Optional</sup> <a name="cdkDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

```typescript
public readonly cdkDependencies: string[];
```

- *Type:* string[]

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdkDependenciesAsDeps`~~<sup>Optional</sup> <a name="cdkDependenciesAsDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

```typescript
public readonly cdkDependenciesAsDeps: boolean;
```

- *Type:* boolean
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdkTestDependencies`~~<sup>Optional</sup> <a name="cdkTestDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

```typescript
public readonly cdkTestDependencies: string[];
```

- *Type:* string[]

AWS CDK modules required for testing.

---

##### `cdkVersionPinning`<sup>Optional</sup> <a name="cdkVersionPinning" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkVersionPinning"></a>

```typescript
public readonly cdkVersionPinning: boolean;
```

- *Type:* boolean

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructsVersion`<sup>Optional</sup> <a name="constructsVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.constructsVersion"></a>

```typescript
public readonly constructsVersion: string;
```

- *Type:* string
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `mainClass`<sup>Required</sup> <a name="mainClass" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mainClass"></a>

```typescript
public readonly mainClass: string;
```

- *Type:* string
- *Default:* "org.acme.MyApp"

The name of the Java class with the static `main()` method.

This method
should call `app.synth()` on the CDK app.

---

### PDKPipelineProps <a name="PDKPipelineProps" id="aws-prototyping-sdk.pipeline.PDKPipelineProps"></a>

Properties to configure the PDKPipeline.

Note: Due to limitations with JSII and generic support it should be noted that
the synth, synthShellStepPartialProps.input and
synthShellStepPartialProps.primaryOutputDirectory properties will be ignored
if passed in to this construct.

synthShellStepPartialProps.commands is marked as a required field, however
if you pass in [] the default commands of this construct will be retained.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.Initializer"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

const pDKPipelineProps: pipeline.PDKPipelineProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synth">synth</a></code> | <code>aws-cdk-lib.pipelines.IFileSetProducer</code> | The build step that produces the CDK Cloud Assembly. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.assetPublishingCodeBuildDefaults">assetPublishingCodeBuildDefaults</a></code> | <code>aws-cdk-lib.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the asset publishing CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.cliVersion">cliVersion</a></code> | <code>string</code> | CDK CLI version to use in self-mutation and asset publishing steps. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codeBuildDefaults">codeBuildDefaults</a></code> | <code>aws-cdk-lib.pipelines.CodeBuildOptions</code> | Customize the CodeBuild projects created for this pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codePipeline">codePipeline</a></code> | <code>aws-cdk-lib.aws_codepipeline.Pipeline</code> | An existing Pipeline to be reused and built upon. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.crossAccountKeys">crossAccountKeys</a></code> | <code>boolean</code> | Create KMS keys for the artifact buckets, allowing cross-account deployments. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerCredentials">dockerCredentials</a></code> | <code>aws-cdk-lib.pipelines.DockerCredential[]</code> | A list of credentials used to authenticate to Docker registries. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerEnabledForSelfMutation">dockerEnabledForSelfMutation</a></code> | <code>boolean</code> | Enable Docker for the self-mutate step. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerEnabledForSynth">dockerEnabledForSynth</a></code> | <code>boolean</code> | Enable Docker for the 'synth' step. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.enableKeyRotation">enableKeyRotation</a></code> | <code>boolean</code> | Enable KMS key rotation for the generated KMS keys. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.pipelineName">pipelineName</a></code> | <code>string</code> | The name of the CodePipeline pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.publishAssetsInParallel">publishAssetsInParallel</a></code> | <code>boolean</code> | Publish assets in multiple CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.reuseCrossRegionSupportStacks">reuseCrossRegionSupportStacks</a></code> | <code>boolean</code> | Reuse the same cross region support stack for all pipelines in the App. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.role">role</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | The IAM role to be assumed by this Pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.selfMutation">selfMutation</a></code> | <code>boolean</code> | Whether the pipeline will update itself. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.selfMutationCodeBuildDefaults">selfMutationCodeBuildDefaults</a></code> | <code>aws-cdk-lib.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the self mutation CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synthCodeBuildDefaults">synthCodeBuildDefaults</a></code> | <code>aws-cdk-lib.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the synthesize CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.useChangeSets">useChangeSets</a></code> | <code>boolean</code> | Deploy every stack by creating a change set and executing it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.primarySynthDirectory">primarySynthDirectory</a></code> | <code>string</code> | Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.repositoryName">repositoryName</a></code> | <code>string</code> | Name of the CodeCommit repository to create. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codeCommitRemovalPolicy">codeCommitRemovalPolicy</a></code> | <code>aws-cdk-lib.RemovalPolicy</code> | Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.defaultBranchName">defaultBranchName</a></code> | <code>string</code> | Branch to trigger the pipeline execution. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.sonarCodeScannerConfig">sonarCodeScannerConfig</a></code> | <code>aws-prototyping-sdk.pipeline.SonarCodeScannerConfig</code> | Configuration for enabling Sonarqube code scanning on a successful synth. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synthShellStepPartialProps">synthShellStepPartialProps</a></code> | <code>aws-cdk-lib.pipelines.ShellStepProps</code> | PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands. |

---

##### `synth`<sup>Required</sup> <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synth"></a>

```typescript
public readonly synth: IFileSetProducer;
```

- *Type:* aws-cdk-lib.pipelines.IFileSetProducer

The build step that produces the CDK Cloud Assembly.

The primary output of this step needs to be the `cdk.out` directory
generated by the `cdk synth` command.

If you use a `ShellStep` here and you don't configure an output directory,
the output directory will automatically be assumed to be `cdk.out`.

---

##### `assetPublishingCodeBuildDefaults`<sup>Optional</sup> <a name="assetPublishingCodeBuildDefaults" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.assetPublishingCodeBuildDefaults"></a>

```typescript
public readonly assetPublishingCodeBuildDefaults: CodeBuildOptions;
```

- *Type:* aws-cdk-lib.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the asset publishing CodeBuild projects.

---

##### `cliVersion`<sup>Optional</sup> <a name="cliVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.cliVersion"></a>

```typescript
public readonly cliVersion: string;
```

- *Type:* string
- *Default:* Latest version

CDK CLI version to use in self-mutation and asset publishing steps.

If you want to lock the CDK CLI version used in the pipeline, by steps
that are automatically generated for you, specify the version here.

We recommend you do not specify this value, as not specifying it always
uses the latest CLI version which is backwards compatible with old versions.

If you do specify it, be aware that this version should always be equal to or higher than the
version of the CDK framework used by the CDK app, when the CDK commands are
run during your pipeline execution. When you change this version, the *next
time* the `SelfMutate` step runs it will still be using the CLI of the the
*previous* version that was in this property: it will only start using the
new version after `SelfMutate` completes successfully. That means that if
you want to update both framework and CLI version, you should update the
CLI version first, commit, push and deploy, and only then update the
framework version.

---

##### `codeBuildDefaults`<sup>Optional</sup> <a name="codeBuildDefaults" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codeBuildDefaults"></a>

```typescript
public readonly codeBuildDefaults: CodeBuildOptions;
```

- *Type:* aws-cdk-lib.pipelines.CodeBuildOptions
- *Default:* All projects run non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_6_0

Customize the CodeBuild projects created for this pipeline.

---

##### `codePipeline`<sup>Optional</sup> <a name="codePipeline" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codePipeline"></a>

```typescript
public readonly codePipeline: Pipeline;
```

- *Type:* aws-cdk-lib.aws_codepipeline.Pipeline
- *Default:* a new underlying pipeline is created.

An existing Pipeline to be reused and built upon.

[disable-awslint:ref-via-interface]

---

##### `crossAccountKeys`<sup>Optional</sup> <a name="crossAccountKeys" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.crossAccountKeys"></a>

```typescript
public readonly crossAccountKeys: boolean;
```

- *Type:* boolean
- *Default:* false

Create KMS keys for the artifact buckets, allowing cross-account deployments.

The artifact buckets have to be encrypted to support deploying CDK apps to
another account, so if you want to do that or want to have your artifact
buckets encrypted, be sure to set this value to `true`.

Be aware there is a cost associated with maintaining the KMS keys.

---

##### `dockerCredentials`<sup>Optional</sup> <a name="dockerCredentials" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerCredentials"></a>

```typescript
public readonly dockerCredentials: DockerCredential[];
```

- *Type:* aws-cdk-lib.pipelines.DockerCredential[]
- *Default:* []

A list of credentials used to authenticate to Docker registries.

Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.

---

##### `dockerEnabledForSelfMutation`<sup>Optional</sup> <a name="dockerEnabledForSelfMutation" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerEnabledForSelfMutation"></a>

```typescript
public readonly dockerEnabledForSelfMutation: boolean;
```

- *Type:* boolean
- *Default:* false

Enable Docker for the self-mutate step.

Set this to true if the pipeline itself uses Docker container assets
(for example, if you use `LinuxBuildImage.fromAsset()` as the build
image of a CodeBuild step in the pipeline).

You do not need to set it if you build Docker image assets in the
application Stages and Stacks that are *deployed* by this pipeline.

Configures privileged mode for the self-mutation CodeBuild action.

If you are about to turn this on in an already-deployed Pipeline,
set the value to `true` first, commit and allow the pipeline to
self-update, and only then use the Docker asset in the pipeline.

---

##### `dockerEnabledForSynth`<sup>Optional</sup> <a name="dockerEnabledForSynth" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerEnabledForSynth"></a>

```typescript
public readonly dockerEnabledForSynth: boolean;
```

- *Type:* boolean
- *Default:* false

Enable Docker for the 'synth' step.

Set this to true if you are using file assets that require
"bundling" anywhere in your application (meaning an asset
compilation step will be run with the tools provided by
a Docker image), both for the Pipeline stack as well as the
application stacks.

A common way to use bundling assets in your application is by
using the `@aws-cdk/aws-lambda-nodejs` library.

Configures privileged mode for the synth CodeBuild action.

If you are about to turn this on in an already-deployed Pipeline,
set the value to `true` first, commit and allow the pipeline to
self-update, and only then use the bundled asset.

---

##### `enableKeyRotation`<sup>Optional</sup> <a name="enableKeyRotation" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.enableKeyRotation"></a>

```typescript
public readonly enableKeyRotation: boolean;
```

- *Type:* boolean
- *Default:* false (key rotation is disabled)

Enable KMS key rotation for the generated KMS keys.

By default KMS key rotation is disabled, but will add
additional costs when enabled.

---

##### `pipelineName`<sup>Optional</sup> <a name="pipelineName" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.pipelineName"></a>

```typescript
public readonly pipelineName: string;
```

- *Type:* string
- *Default:* Automatically generated

The name of the CodePipeline pipeline.

---

##### `publishAssetsInParallel`<sup>Optional</sup> <a name="publishAssetsInParallel" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.publishAssetsInParallel"></a>

```typescript
public readonly publishAssetsInParallel: boolean;
```

- *Type:* boolean
- *Default:* true

Publish assets in multiple CodeBuild projects.

If set to false, use one Project per type to publish all assets.

Publishing in parallel improves concurrency and may reduce publishing
latency, but may also increase overall provisioning time of the CodeBuild
projects.

Experiment and see what value works best for you.

---

##### `reuseCrossRegionSupportStacks`<sup>Optional</sup> <a name="reuseCrossRegionSupportStacks" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.reuseCrossRegionSupportStacks"></a>

```typescript
public readonly reuseCrossRegionSupportStacks: boolean;
```

- *Type:* boolean
- *Default:* true (Use the same support stack for all pipelines in App)

Reuse the same cross region support stack for all pipelines in the App.

---

##### `role`<sup>Optional</sup> <a name="role" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.role"></a>

```typescript
public readonly role: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole
- *Default:* A new role is created

The IAM role to be assumed by this Pipeline.

---

##### `selfMutation`<sup>Optional</sup> <a name="selfMutation" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.selfMutation"></a>

```typescript
public readonly selfMutation: boolean;
```

- *Type:* boolean
- *Default:* true

Whether the pipeline will update itself.

This needs to be set to `true` to allow the pipeline to reconfigure
itself when assets or stages are being added to it, and `true` is the
recommended setting.

You can temporarily set this to `false` while you are iterating
on the pipeline itself and prefer to deploy changes using `cdk deploy`.

---

##### `selfMutationCodeBuildDefaults`<sup>Optional</sup> <a name="selfMutationCodeBuildDefaults" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.selfMutationCodeBuildDefaults"></a>

```typescript
public readonly selfMutationCodeBuildDefaults: CodeBuildOptions;
```

- *Type:* aws-cdk-lib.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the self mutation CodeBuild projects.

---

##### `synthCodeBuildDefaults`<sup>Optional</sup> <a name="synthCodeBuildDefaults" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synthCodeBuildDefaults"></a>

```typescript
public readonly synthCodeBuildDefaults: CodeBuildOptions;
```

- *Type:* aws-cdk-lib.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the synthesize CodeBuild projects.

---

##### `useChangeSets`<sup>Optional</sup> <a name="useChangeSets" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.useChangeSets"></a>

```typescript
public readonly useChangeSets: boolean;
```

- *Type:* boolean
- *Default:* true

Deploy every stack by creating a change set and executing it.

When enabled, creates a "Prepare" and "Execute" action for each stack. Disable
to deploy the stack in one pipeline action.

---

##### `primarySynthDirectory`<sup>Required</sup> <a name="primarySynthDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.primarySynthDirectory"></a>

```typescript
public readonly primarySynthDirectory: string;
```

- *Type:* string

Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out.

---

##### `repositoryName`<sup>Required</sup> <a name="repositoryName" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.repositoryName"></a>

```typescript
public readonly repositoryName: string;
```

- *Type:* string

Name of the CodeCommit repository to create.

---

##### `codeCommitRemovalPolicy`<sup>Optional</sup> <a name="codeCommitRemovalPolicy" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codeCommitRemovalPolicy"></a>

```typescript
public readonly codeCommitRemovalPolicy: RemovalPolicy;
```

- *Type:* aws-cdk-lib.RemovalPolicy

Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation.

---

##### `defaultBranchName`<sup>Optional</sup> <a name="defaultBranchName" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.defaultBranchName"></a>

```typescript
public readonly defaultBranchName: string;
```

- *Type:* string
- *Default:* mainline

Branch to trigger the pipeline execution.

---

##### `sonarCodeScannerConfig`<sup>Optional</sup> <a name="sonarCodeScannerConfig" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.sonarCodeScannerConfig"></a>

```typescript
public readonly sonarCodeScannerConfig: SonarCodeScannerConfig;
```

- *Type:* aws-prototyping-sdk.pipeline.SonarCodeScannerConfig
- *Default:* undefined

Configuration for enabling Sonarqube code scanning on a successful synth.

---

##### `synthShellStepPartialProps`<sup>Optional</sup> <a name="synthShellStepPartialProps" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synthShellStepPartialProps"></a>

```typescript
public readonly synthShellStepPartialProps: ShellStepProps;
```

- *Type:* aws-cdk-lib.pipelines.ShellStepProps

PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands.

To override these defaults
and/or provide additional inputs, specify env settings, etc you can provide
a partial ShellStepProps.

---

### PDKPipelinePyProjectOptions <a name="PDKPipelinePyProjectOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions"></a>

Configuration options for the PDKPipelinePyProject.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.Initializer"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

const pDKPipelinePyProjectOptions: pipeline.PDKPipelinePyProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.name">name</a></code> | <code>string</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitOptions">gitOptions</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.outdir">outdir</a></code> | <code>string</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenCommand">projenCommand</a></code> | <code>string</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.renovatebot">renovatebot</a></code> | <code>boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoMerge">autoMerge</a></code> | <code>boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.clobber">clobber</a></code> | <code>boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.devContainer">devContainer</a></code> | <code>boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.github">github</a></code> | <code>boolean</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.githubOptions">githubOptions</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitpod">gitpod</a></code> | <code>boolean</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.mergify">mergify</a></code> | <code>boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>string</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.stale">stale</a></code> | <code>boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.staleOptions">staleOptions</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.vscode">vscode</a></code> | <code>boolean</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.authorEmail">authorEmail</a></code> | <code>string</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.authorName">authorName</a></code> | <code>string</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.version">version</a></code> | <code>string</code> | Version of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.classifiers">classifiers</a></code> | <code>string[]</code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.description">description</a></code> | <code>string</code> | A short description of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.homepage">homepage</a></code> | <code>string</code> | A URL to the website of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.license">license</a></code> | <code>string</code> | License of this package as an SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.packageName">packageName</a></code> | <code>string</code> | Package name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.poetryOptions">poetryOptions</a></code> | <code>projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.setupConfig">setupConfig</a></code> | <code>{[ key: string ]: any}</code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.moduleName">moduleName</a></code> | <code>string</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.deps">deps</a></code> | <code>string[]</code> | List of runtime dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.devDeps">devDeps</a></code> | <code>string[]</code> | List of dev dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pip">pip</a></code> | <code>boolean</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.poetry">poetry</a></code> | <code>boolean</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>boolean</code> | Use projenrc in javascript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcPython">projenrcPython</a></code> | <code>boolean</code> | Use projenrc in Python. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcPythonOptions">projenrcPythonOptions</a></code> | <code>projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>boolean</code> | Use projenrc in TypeScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pytest">pytest</a></code> | <code>boolean</code> | Include pytest tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pytestOptions">pytestOptions</a></code> | <code>projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.sample">sample</a></code> | <code>boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.setuptools">setuptools</a></code> | <code>boolean</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.venv">venv</a></code> | <code>boolean</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.venvOptions">venvOptions</a></code> | <code>projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.buildCommand">buildCommand</a></code> | <code>string</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkout">cdkout</a></code> | <code>string</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.context">context</a></code> | <code>{[ key: string ]: any}</code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.featureFlags">featureFlags</a></code> | <code>boolean</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.requireApproval">requireApproval</a></code> | <code>projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.watchExcludes">watchExcludes</a></code> | <code>string[]</code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.watchIncludes">watchIncludes</a></code> | <code>string[]</code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkVersion">cdkVersion</a></code> | <code>string</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkAssert">cdkAssert</a></code> | <code>boolean</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkAssertions">cdkAssertions</a></code> | <code>boolean</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkDependencies">cdkDependencies</a></code> | <code>string[]</code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkDependenciesAsDeps">cdkDependenciesAsDeps</a></code> | <code>boolean</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkTestDependencies">cdkTestDependencies</a></code> | <code>string[]</code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkVersionPinning">cdkVersionPinning</a></code> | <code>boolean</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.constructsVersion">constructsVersion</a></code> | <code>string</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.appEntrypoint">appEntrypoint</a></code> | <code>string</code> | The CDK app's entrypoint (relative to the source directory, which is "src" by default). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.testdir">testdir</a></code> | <code>string</code> | Python sources directory. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitIgnoreOptions"></a>

```typescript
public readonly gitIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitOptions"></a>

```typescript
public readonly gitOptions: GitOptions;
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.logging"></a>

```typescript
public readonly logging: LoggerOptions;
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJson"></a>

```typescript
public readonly projenrcJson: boolean;
```

- *Type:* boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJsonOptions"></a>

```typescript
public readonly projenrcJsonOptions: ProjenrcJsonOptions;
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.renovatebot"></a>

```typescript
public readonly renovatebot: boolean;
```

- *Type:* boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.renovatebotOptions"></a>

```typescript
public readonly renovatebotOptions: RenovatebotOptions;
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoApproveOptions"></a>

```typescript
public readonly autoApproveOptions: AutoApproveOptions;
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoMerge"></a>

```typescript
public readonly autoMerge: boolean;
```

- *Type:* boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoMergeOptions"></a>

```typescript
public readonly autoMergeOptions: AutoMergeOptions;
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.clobber"></a>

```typescript
public readonly clobber: boolean;
```

- *Type:* boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.devContainer"></a>

```typescript
public readonly devContainer: boolean;
```

- *Type:* boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.github"></a>

```typescript
public readonly github: boolean;
```

- *Type:* boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.githubOptions"></a>

```typescript
public readonly githubOptions: GitHubOptions;
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitpod"></a>

```typescript
public readonly gitpod: boolean;
```

- *Type:* boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```typescript
public readonly mergify: boolean;
```

- *Type:* boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```typescript
public readonly mergifyOptions: MergifyOptions;
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenCredentials"></a>

```typescript
public readonly projenCredentials: GithubCredentials;
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```typescript
public readonly projenTokenSecret: string;
```

- *Type:* string
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.readme"></a>

```typescript
public readonly readme: SampleReadmeProps;
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```typescript
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.stale"></a>

```typescript
public readonly stale: boolean;
```

- *Type:* boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.staleOptions"></a>

```typescript
public readonly staleOptions: StaleOptions;
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.vscode"></a>

```typescript
public readonly vscode: boolean;
```

- *Type:* boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `authorEmail`<sup>Required</sup> <a name="authorEmail" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.authorEmail"></a>

```typescript
public readonly authorEmail: string;
```

- *Type:* string
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `authorName`<sup>Required</sup> <a name="authorName" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.authorName"></a>

```typescript
public readonly authorName: string;
```

- *Type:* string
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.version"></a>

```typescript
public readonly version: string;
```

- *Type:* string
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.classifiers"></a>

```typescript
public readonly classifiers: string[];
```

- *Type:* string[]

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.homepage"></a>

```typescript
public readonly homepage: string;
```

- *Type:* string

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.license"></a>

```typescript
public readonly license: string;
```

- *Type:* string

License of this package as an SPDX identifier.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.packageName"></a>

```typescript
public readonly packageName: string;
```

- *Type:* string

Package name.

---

##### `poetryOptions`<sup>Optional</sup> <a name="poetryOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.poetryOptions"></a>

```typescript
public readonly poetryOptions: PoetryPyprojectOptionsWithoutDeps;
```

- *Type:* projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setupConfig`<sup>Optional</sup> <a name="setupConfig" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.setupConfig"></a>

```typescript
public readonly setupConfig: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

Additional fields to pass in the setup() function if using setuptools.

---

##### `moduleName`<sup>Required</sup> <a name="moduleName" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.moduleName"></a>

```typescript
public readonly moduleName: string;
```

- *Type:* string
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.deps"></a>

```typescript
public readonly deps: string[];
```

- *Type:* string[]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.devDeps"></a>

```typescript
public readonly devDeps: string[];
```

- *Type:* string[]
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pip"></a>

```typescript
public readonly pip: boolean;
```

- *Type:* boolean
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.poetry"></a>

```typescript
public readonly poetry: boolean;
```

- *Type:* boolean
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJs"></a>

```typescript
public readonly projenrcJs: boolean;
```

- *Type:* boolean
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJsOptions"></a>

```typescript
public readonly projenrcJsOptions: ProjenrcOptions;
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrcPython`<sup>Optional</sup> <a name="projenrcPython" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcPython"></a>

```typescript
public readonly projenrcPython: boolean;
```

- *Type:* boolean
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrcPythonOptions`<sup>Optional</sup> <a name="projenrcPythonOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcPythonOptions"></a>

```typescript
public readonly projenrcPythonOptions: ProjenrcOptions;
```

- *Type:* projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcTs"></a>

```typescript
public readonly projenrcTs: boolean;
```

- *Type:* boolean
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcTsOptions"></a>

```typescript
public readonly projenrcTsOptions: ProjenrcTsOptions;
```

- *Type:* projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pytest"></a>

```typescript
public readonly pytest: boolean;
```

- *Type:* boolean
- *Default:* true

Include pytest tests.

---

##### `pytestOptions`<sup>Optional</sup> <a name="pytestOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pytestOptions"></a>

```typescript
public readonly pytestOptions: PytestOptions;
```

- *Type:* projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.sample"></a>

```typescript
public readonly sample: boolean;
```

- *Type:* boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.setuptools"></a>

```typescript
public readonly setuptools: boolean;
```

- *Type:* boolean
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.venv"></a>

```typescript
public readonly venv: boolean;
```

- *Type:* boolean
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venvOptions`<sup>Optional</sup> <a name="venvOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.venvOptions"></a>

```typescript
public readonly venvOptions: VenvOptions;
```

- *Type:* projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `buildCommand`<sup>Optional</sup> <a name="buildCommand" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.buildCommand"></a>

```typescript
public readonly buildCommand: string;
```

- *Type:* string
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkout"></a>

```typescript
public readonly cdkout: string;
```

- *Type:* string
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.context"></a>

```typescript
public readonly context: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `featureFlags`<sup>Optional</sup> <a name="featureFlags" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.featureFlags"></a>

```typescript
public readonly featureFlags: boolean;
```

- *Type:* boolean
- *Default:* true

Include all feature flags in cdk.json.

---

##### `requireApproval`<sup>Optional</sup> <a name="requireApproval" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.requireApproval"></a>

```typescript
public readonly requireApproval: ApprovalLevel;
```

- *Type:* projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watchExcludes`<sup>Optional</sup> <a name="watchExcludes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.watchExcludes"></a>

```typescript
public readonly watchExcludes: string[];
```

- *Type:* string[]
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watchIncludes`<sup>Optional</sup> <a name="watchIncludes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.watchIncludes"></a>

```typescript
public readonly watchIncludes: string[];
```

- *Type:* string[]
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkVersion"></a>

```typescript
public readonly cdkVersion: string;
```

- *Type:* string
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdkAssert`~~<sup>Optional</sup> <a name="cdkAssert" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkAssert"></a>

- *Deprecated:* The

```typescript
public readonly cdkAssert: boolean;
```

- *Type:* boolean
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdkAssertions`<sup>Optional</sup> <a name="cdkAssertions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkAssertions"></a>

```typescript
public readonly cdkAssertions: boolean;
```

- *Type:* boolean
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdkDependencies`~~<sup>Optional</sup> <a name="cdkDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

```typescript
public readonly cdkDependencies: string[];
```

- *Type:* string[]

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdkDependenciesAsDeps`~~<sup>Optional</sup> <a name="cdkDependenciesAsDeps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

```typescript
public readonly cdkDependenciesAsDeps: boolean;
```

- *Type:* boolean
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdkTestDependencies`~~<sup>Optional</sup> <a name="cdkTestDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

```typescript
public readonly cdkTestDependencies: string[];
```

- *Type:* string[]

AWS CDK modules required for testing.

---

##### `cdkVersionPinning`<sup>Optional</sup> <a name="cdkVersionPinning" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkVersionPinning"></a>

```typescript
public readonly cdkVersionPinning: boolean;
```

- *Type:* boolean

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructsVersion`<sup>Optional</sup> <a name="constructsVersion" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.constructsVersion"></a>

```typescript
public readonly constructsVersion: string;
```

- *Type:* string
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `appEntrypoint`<sup>Optional</sup> <a name="appEntrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.appEntrypoint"></a>

```typescript
public readonly appEntrypoint: string;
```

- *Type:* string
- *Default:* "app.py"

The CDK app's entrypoint (relative to the source directory, which is "src" by default).

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.testdir"></a>

```typescript
public readonly testdir: string;
```

- *Type:* string
- *Default:* "tests"

Python sources directory.

---

### PDKPipelineTsProjectOptions <a name="PDKPipelineTsProjectOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions"></a>

Configuration options for the PDKPipelineTsProject.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.Initializer"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

const pDKPipelineTsProjectOptions: pipeline.PDKPipelineTsProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.name">name</a></code> | <code>string</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitOptions">gitOptions</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.outdir">outdir</a></code> | <code>string</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenCommand">projenCommand</a></code> | <code>string</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.renovatebot">renovatebot</a></code> | <code>boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoMerge">autoMerge</a></code> | <code>boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.clobber">clobber</a></code> | <code>boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.devContainer">devContainer</a></code> | <code>boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.github">github</a></code> | <code>boolean</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.githubOptions">githubOptions</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitpod">gitpod</a></code> | <code>boolean</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mergify">mergify</a></code> | <code>boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>string</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.stale">stale</a></code> | <code>boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.staleOptions">staleOptions</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.vscode">vscode</a></code> | <code>boolean</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>boolean</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorEmail">authorEmail</a></code> | <code>string</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorName">authorName</a></code> | <code>string</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorOrganization">authorOrganization</a></code> | <code>boolean</code> | Is the author an organization. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorUrl">authorUrl</a></code> | <code>string</code> | Author's URL / Website. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoDetectBin">autoDetectBin</a></code> | <code>boolean</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bin">bin</a></code> | <code>{[ key: string ]: string}</code> | Binary programs vended with your module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bugsEmail">bugsEmail</a></code> | <code>string</code> | The email address to which issues should be reported. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bugsUrl">bugsUrl</a></code> | <code>string</code> | The url to your project's issue tracker. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bundledDeps">bundledDeps</a></code> | <code>string[]</code> | List of dependencies to bundle into this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeArtifactOptions">codeArtifactOptions</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.deps">deps</a></code> | <code>string[]</code> | Runtime dependencies of this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.description">description</a></code> | <code>string</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.devDeps">devDeps</a></code> | <code>string[]</code> | Build dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.entrypoint">entrypoint</a></code> | <code>string</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.homepage">homepage</a></code> | <code>string</code> | Package's Homepage / Website. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.keywords">keywords</a></code> | <code>string[]</code> | Keywords to include in `package.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.license">license</a></code> | <code>string</code> | License's SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.licensed">licensed</a></code> | <code>boolean</code> | Indicates if a license should be added. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.maxNodeVersion">maxNodeVersion</a></code> | <code>string</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.minNodeVersion">minNodeVersion</a></code> | <code>string</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmAccess">npmAccess</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmRegistry">npmRegistry</a></code> | <code>string</code> | The host name of the npm registry to publish to. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmRegistryUrl">npmRegistryUrl</a></code> | <code>string</code> | The base URL of the npm package registry. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmTokenSecret">npmTokenSecret</a></code> | <code>string</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.packageManager">packageManager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.packageName">packageName</a></code> | <code>string</code> | The "name" in package.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.peerDependencyOptions">peerDependencyOptions</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.peerDeps">peerDeps</a></code> | <code>string[]</code> | Peer dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pnpmVersion">pnpmVersion</a></code> | <code>string</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.repository">repository</a></code> | <code>string</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.repositoryDirectory">repositoryDirectory</a></code> | <code>string</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.scopedPackagesOptions">scopedPackagesOptions</a></code> | <code>projen.javascript.ScopedPackagesOptions[]</code> | Options for privately hosted scoped packages. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.scripts">scripts</a></code> | <code>{[ key: string ]: string}</code> | npm scripts to include. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.stability">stability</a></code> | <code>string</code> | Package's Stability. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jsiiReleaseVersion">jsiiReleaseVersion</a></code> | <code>string</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.majorVersion">majorVersion</a></code> | <code>number</code> | Major version to release from the default branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.minMajorVersion">minMajorVersion</a></code> | <code>number</code> | Minimal Major version to release. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmDistTag">npmDistTag</a></code> | <code>string</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.postBuildSteps">postBuildSteps</a></code> | <code>projen.github.workflows.JobStep[]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prerelease">prerelease</a></code> | <code>string</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.publishDryRun">publishDryRun</a></code> | <code>boolean</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.publishTasks">publishTasks</a></code> | <code>boolean</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseBranches">releaseBranches</a></code> | <code>{[ key: string ]: projen.release.BranchOptions}</code> | Defines additional release branches. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseEveryCommit">releaseEveryCommit</a></code> | <code>boolean</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseFailureIssue">releaseFailureIssue</a></code> | <code>boolean</code> | Create a github issue on every failed publishing task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseFailureIssueLabel">releaseFailureIssueLabel</a></code> | <code>string</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseSchedule">releaseSchedule</a></code> | <code>string</code> | CRON schedule to trigger new releases. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseTagPrefix">releaseTagPrefix</a></code> | <code>string</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseTrigger">releaseTrigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflowName">releaseWorkflowName</a></code> | <code>string</code> | The name of the default release workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflowSetupSteps">releaseWorkflowSetupSteps</a></code> | <code>projen.github.workflows.JobStep[]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.versionrcOptions">versionrcOptions</a></code> | <code>{[ key: string ]: any}</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowContainerImage">workflowContainerImage</a></code> | <code>string</code> | Container image to use for GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowRunsOn">workflowRunsOn</a></code> | <code>string[]</code> | Github Runner selection labels. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.defaultReleaseBranch">defaultReleaseBranch</a></code> | <code>string</code> | The name of the main release branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.artifactsDirectory">artifactsDirectory</a></code> | <code>string</code> | A directory which will contain build artifacts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoApproveUpgrades">autoApproveUpgrades</a></code> | <code>boolean</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildWorkflow">buildWorkflow</a></code> | <code>boolean</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildWorkflowTriggers">buildWorkflowTriggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bundlerOptions">bundlerOptions</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeCov">codeCov</a></code> | <code>boolean</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeCovTokenSecret">codeCovTokenSecret</a></code> | <code>string</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.copyrightOwner">copyrightOwner</a></code> | <code>string</code> | License copyright owner. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.copyrightPeriod">copyrightPeriod</a></code> | <code>string</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.dependabot">dependabot</a></code> | <code>boolean</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.dependabotOptions">dependabotOptions</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.depsUpgrade">depsUpgrade</a></code> | <code>boolean</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.depsUpgradeOptions">depsUpgradeOptions</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitignore">gitignore</a></code> | <code>string[]</code> | Additional entries to .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jest">jest</a></code> | <code>boolean</code> | Setup jest unit tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jestOptions">jestOptions</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mutableBuild">mutableBuild</a></code> | <code>boolean</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmignore">npmignore</a></code> | <code>string[]</code> | Additional entries to .npmignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmignoreEnabled">npmignoreEnabled</a></code> | <code>boolean</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmIgnoreOptions">npmIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.package">package</a></code> | <code>boolean</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prettier">prettier</a></code> | <code>boolean</code> | Setup prettier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prettierOptions">prettierOptions</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenDevDependency">projenDevDependency</a></code> | <code>boolean</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>boolean</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenVersion">projenVersion</a></code> | <code>string</code> | Version of projen to install. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pullRequestTemplate">pullRequestTemplate</a></code> | <code>boolean</code> | Include a GitHub pull request template. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pullRequestTemplateContents">pullRequestTemplateContents</a></code> | <code>string[]</code> | The contents of the pull request template. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.release">release</a></code> | <code>boolean</code> | Add release management to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseToNpm">releaseToNpm</a></code> | <code>boolean</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflow">releaseWorkflow</a></code> | <code>boolean</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowBootstrapSteps">workflowBootstrapSteps</a></code> | <code>projen.github.workflows.JobStep[]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowGitIdentity">workflowGitIdentity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowNodeVersion">workflowNodeVersion</a></code> | <code>string</code> | The node version to use in GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.disableTsconfig">disableTsconfig</a></code> | <code>boolean</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.disableTsconfigDev">disableTsconfigDev</a></code> | <code>boolean</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.docgen">docgen</a></code> | <code>boolean</code> | Docgen by Typedoc. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.docsDirectory">docsDirectory</a></code> | <code>string</code> | Docs directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.entrypointTypes">entrypointTypes</a></code> | <code>string</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.eslint">eslint</a></code> | <code>boolean</code> | Setup eslint. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.eslintOptions">eslintOptions</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.libdir">libdir</a></code> | <code>string</code> | Typescript  artifacts output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>boolean</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.sampleCode">sampleCode</a></code> | <code>boolean</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.srcdir">srcdir</a></code> | <code>string</code> | Typescript sources directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.testdir">testdir</a></code> | <code>string</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfigDev">tsconfigDev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfigDevFile">tsconfigDevFile</a></code> | <code>string</code> | The name of the development tsconfig.json file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.typescriptVersion">typescriptVersion</a></code> | <code>string</code> | TypeScript version to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildCommand">buildCommand</a></code> | <code>string</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkout">cdkout</a></code> | <code>string</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.context">context</a></code> | <code>{[ key: string ]: any}</code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.featureFlags">featureFlags</a></code> | <code>boolean</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.requireApproval">requireApproval</a></code> | <code>projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.watchExcludes">watchExcludes</a></code> | <code>string[]</code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.watchIncludes">watchIncludes</a></code> | <code>string[]</code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkVersion">cdkVersion</a></code> | <code>string</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkAssert">cdkAssert</a></code> | <code>boolean</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkAssertions">cdkAssertions</a></code> | <code>boolean</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkDependencies">cdkDependencies</a></code> | <code>string[]</code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkDependenciesAsDeps">cdkDependenciesAsDeps</a></code> | <code>boolean</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkTestDependencies">cdkTestDependencies</a></code> | <code>string[]</code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkVersionPinning">cdkVersionPinning</a></code> | <code>boolean</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.constructsVersion">constructsVersion</a></code> | <code>string</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.appEntrypoint">appEntrypoint</a></code> | <code>string</code> | The CDK app's entrypoint (relative to the source directory, which is "src" by default). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.edgeLambdaAutoDiscover">edgeLambdaAutoDiscover</a></code> | <code>boolean</code> | Automatically adds an `cloudfront.experimental.EdgeFunction` for each `.edge-lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.integrationTestAutoDiscover">integrationTestAutoDiscover</a></code> | <code>boolean</code> | Automatically discovers and creates integration tests for each `.integ.ts` file in under your test directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaAutoDiscover">lambdaAutoDiscover</a></code> | <code>boolean</code> | Automatically adds an `awscdk.LambdaFunction` for each `.lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaExtensionAutoDiscover">lambdaExtensionAutoDiscover</a></code> | <code>boolean</code> | Automatically adds an `awscdk.LambdaExtension` for each `.lambda-extension.ts` entrypoint in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaOptions">lambdaOptions</a></code> | <code>projen.awscdk.LambdaFunctionCommonOptions</code> | Common options for all AWS Lambda functions. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitIgnoreOptions"></a>

```typescript
public readonly gitIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitOptions"></a>

```typescript
public readonly gitOptions: GitOptions;
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.logging"></a>

```typescript
public readonly logging: LoggerOptions;
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJson"></a>

```typescript
public readonly projenrcJson: boolean;
```

- *Type:* boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJsonOptions"></a>

```typescript
public readonly projenrcJsonOptions: ProjenrcJsonOptions;
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.renovatebot"></a>

```typescript
public readonly renovatebot: boolean;
```

- *Type:* boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.renovatebotOptions"></a>

```typescript
public readonly renovatebotOptions: RenovatebotOptions;
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoApproveOptions"></a>

```typescript
public readonly autoApproveOptions: AutoApproveOptions;
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoMerge"></a>

```typescript
public readonly autoMerge: boolean;
```

- *Type:* boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoMergeOptions"></a>

```typescript
public readonly autoMergeOptions: AutoMergeOptions;
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.clobber"></a>

```typescript
public readonly clobber: boolean;
```

- *Type:* boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.devContainer"></a>

```typescript
public readonly devContainer: boolean;
```

- *Type:* boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.github"></a>

```typescript
public readonly github: boolean;
```

- *Type:* boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.githubOptions"></a>

```typescript
public readonly githubOptions: GitHubOptions;
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitpod"></a>

```typescript
public readonly gitpod: boolean;
```

- *Type:* boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```typescript
public readonly mergify: boolean;
```

- *Type:* boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```typescript
public readonly mergifyOptions: MergifyOptions;
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenCredentials"></a>

```typescript
public readonly projenCredentials: GithubCredentials;
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```typescript
public readonly projenTokenSecret: string;
```

- *Type:* string
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.readme"></a>

```typescript
public readonly readme: SampleReadmeProps;
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```typescript
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.stale"></a>

```typescript
public readonly stale: boolean;
```

- *Type:* boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.staleOptions"></a>

```typescript
public readonly staleOptions: StaleOptions;
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.vscode"></a>

```typescript
public readonly vscode: boolean;
```

- *Type:* boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allowLibraryDependencies`<sup>Optional</sup> <a name="allowLibraryDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.allowLibraryDependencies"></a>

```typescript
public readonly allowLibraryDependencies: boolean;
```

- *Type:* boolean
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `authorEmail`<sup>Optional</sup> <a name="authorEmail" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorEmail"></a>

```typescript
public readonly authorEmail: string;
```

- *Type:* string

Author's e-mail.

---

##### `authorName`<sup>Optional</sup> <a name="authorName" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorName"></a>

```typescript
public readonly authorName: string;
```

- *Type:* string

Author's name.

---

##### `authorOrganization`<sup>Optional</sup> <a name="authorOrganization" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorOrganization"></a>

```typescript
public readonly authorOrganization: boolean;
```

- *Type:* boolean

Is the author an organization.

---

##### `authorUrl`<sup>Optional</sup> <a name="authorUrl" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorUrl"></a>

```typescript
public readonly authorUrl: string;
```

- *Type:* string

Author's URL / Website.

---

##### `autoDetectBin`<sup>Optional</sup> <a name="autoDetectBin" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoDetectBin"></a>

```typescript
public readonly autoDetectBin: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bin"></a>

```typescript
public readonly bin: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugsEmail`<sup>Optional</sup> <a name="bugsEmail" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bugsEmail"></a>

```typescript
public readonly bugsEmail: string;
```

- *Type:* string

The email address to which issues should be reported.

---

##### `bugsUrl`<sup>Optional</sup> <a name="bugsUrl" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bugsUrl"></a>

```typescript
public readonly bugsUrl: string;
```

- *Type:* string

The url to your project's issue tracker.

---

##### `bundledDeps`<sup>Optional</sup> <a name="bundledDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bundledDeps"></a>

```typescript
public readonly bundledDeps: string[];
```

- *Type:* string[]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `codeArtifactOptions`<sup>Optional</sup> <a name="codeArtifactOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeArtifactOptions"></a>

```typescript
public readonly codeArtifactOptions: CodeArtifactOptions;
```

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.deps"></a>

```typescript
public readonly deps: string[];
```

- *Type:* string[]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```typescript
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.devDeps"></a>

```typescript
public readonly devDeps: string[];
```

- *Type:* string[]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```typescript
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.entrypoint"></a>

```typescript
public readonly entrypoint: string;
```

- *Type:* string
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.homepage"></a>

```typescript
public readonly homepage: string;
```

- *Type:* string

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.keywords"></a>

```typescript
public readonly keywords: string[];
```

- *Type:* string[]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.license"></a>

```typescript
public readonly license: string;
```

- *Type:* string
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.licensed"></a>

```typescript
public readonly licensed: boolean;
```

- *Type:* boolean
- *Default:* true

Indicates if a license should be added.

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.maxNodeVersion"></a>

```typescript
public readonly maxNodeVersion: string;
```

- *Type:* string
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.minNodeVersion"></a>

```typescript
public readonly minNodeVersion: string;
```

- *Type:* string
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npmAccess`<sup>Optional</sup> <a name="npmAccess" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmAccess"></a>

```typescript
public readonly npmAccess: NpmAccess;
```

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npmRegistry`~~<sup>Optional</sup> <a name="npmRegistry" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```typescript
public readonly npmRegistry: string;
```

- *Type:* string

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npmRegistryUrl`<sup>Optional</sup> <a name="npmRegistryUrl" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmRegistryUrl"></a>

```typescript
public readonly npmRegistryUrl: string;
```

- *Type:* string
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npmTokenSecret`<sup>Optional</sup> <a name="npmTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmTokenSecret"></a>

```typescript
public readonly npmTokenSecret: string;
```

- *Type:* string
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `packageManager`<sup>Optional</sup> <a name="packageManager" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.packageManager"></a>

```typescript
public readonly packageManager: NodePackageManager;
```

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.packageName"></a>

```typescript
public readonly packageName: string;
```

- *Type:* string
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peerDependencyOptions`<sup>Optional</sup> <a name="peerDependencyOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.peerDependencyOptions"></a>

```typescript
public readonly peerDependencyOptions: PeerDependencyOptions;
```

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peerDeps`<sup>Optional</sup> <a name="peerDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.peerDeps"></a>

```typescript
public readonly peerDeps: string[];
```

- *Type:* string[]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpmVersion`<sup>Optional</sup> <a name="pnpmVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pnpmVersion"></a>

```typescript
public readonly pnpmVersion: string;
```

- *Type:* string
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.repository"></a>

```typescript
public readonly repository: string;
```

- *Type:* string

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repositoryDirectory`<sup>Optional</sup> <a name="repositoryDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.repositoryDirectory"></a>

```typescript
public readonly repositoryDirectory: string;
```

- *Type:* string

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scopedPackagesOptions`<sup>Optional</sup> <a name="scopedPackagesOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.scopedPackagesOptions"></a>

```typescript
public readonly scopedPackagesOptions: ScopedPackagesOptions[];
```

- *Type:* projen.javascript.ScopedPackagesOptions[]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```typescript
public readonly scripts: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.stability"></a>

```typescript
public readonly stability: string;
```

- *Type:* string

Package's Stability.

---

##### `jsiiReleaseVersion`<sup>Optional</sup> <a name="jsiiReleaseVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jsiiReleaseVersion"></a>

```typescript
public readonly jsiiReleaseVersion: string;
```

- *Type:* string
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `majorVersion`<sup>Optional</sup> <a name="majorVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.majorVersion"></a>

```typescript
public readonly majorVersion: number;
```

- *Type:* number
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `minMajorVersion`<sup>Optional</sup> <a name="minMajorVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.minMajorVersion"></a>

```typescript
public readonly minMajorVersion: number;
```

- *Type:* number
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npmDistTag`<sup>Optional</sup> <a name="npmDistTag" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmDistTag"></a>

```typescript
public readonly npmDistTag: string;
```

- *Type:* string
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `postBuildSteps`<sup>Optional</sup> <a name="postBuildSteps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.postBuildSteps"></a>

```typescript
public readonly postBuildSteps: JobStep[];
```

- *Type:* projen.github.workflows.JobStep[]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prerelease"></a>

```typescript
public readonly prerelease: string;
```

- *Type:* string
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publishDryRun`<sup>Optional</sup> <a name="publishDryRun" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.publishDryRun"></a>

```typescript
public readonly publishDryRun: boolean;
```

- *Type:* boolean
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publishTasks`<sup>Optional</sup> <a name="publishTasks" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.publishTasks"></a>

```typescript
public readonly publishTasks: boolean;
```

- *Type:* boolean
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `releaseBranches`<sup>Optional</sup> <a name="releaseBranches" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseBranches"></a>

```typescript
public readonly releaseBranches: {[ key: string ]: BranchOptions};
```

- *Type:* {[ key: string ]: projen.release.BranchOptions}
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`releaseEveryCommit`~~<sup>Optional</sup> <a name="releaseEveryCommit" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```typescript
public readonly releaseEveryCommit: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `releaseFailureIssue`<sup>Optional</sup> <a name="releaseFailureIssue" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseFailureIssue"></a>

```typescript
public readonly releaseFailureIssue: boolean;
```

- *Type:* boolean
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `releaseFailureIssueLabel`<sup>Optional</sup> <a name="releaseFailureIssueLabel" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseFailureIssueLabel"></a>

```typescript
public readonly releaseFailureIssueLabel: string;
```

- *Type:* string
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`releaseSchedule`~~<sup>Optional</sup> <a name="releaseSchedule" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```typescript
public readonly releaseSchedule: string;
```

- *Type:* string
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `releaseTagPrefix`<sup>Optional</sup> <a name="releaseTagPrefix" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseTagPrefix"></a>

```typescript
public readonly releaseTagPrefix: string;
```

- *Type:* string
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `releaseTrigger`<sup>Optional</sup> <a name="releaseTrigger" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseTrigger"></a>

```typescript
public readonly releaseTrigger: ReleaseTrigger;
```

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `releaseWorkflowName`<sup>Optional</sup> <a name="releaseWorkflowName" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflowName"></a>

```typescript
public readonly releaseWorkflowName: string;
```

- *Type:* string
- *Default:* "Release"

The name of the default release workflow.

---

##### `releaseWorkflowSetupSteps`<sup>Optional</sup> <a name="releaseWorkflowSetupSteps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflowSetupSteps"></a>

```typescript
public readonly releaseWorkflowSetupSteps: JobStep[];
```

- *Type:* projen.github.workflows.JobStep[]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrcOptions`<sup>Optional</sup> <a name="versionrcOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.versionrcOptions"></a>

```typescript
public readonly versionrcOptions: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflowContainerImage`<sup>Optional</sup> <a name="workflowContainerImage" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowContainerImage"></a>

```typescript
public readonly workflowContainerImage: string;
```

- *Type:* string
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflowRunsOn`<sup>Optional</sup> <a name="workflowRunsOn" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowRunsOn"></a>

```typescript
public readonly workflowRunsOn: string[];
```

- *Type:* string[]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `defaultReleaseBranch`<sup>Required</sup> <a name="defaultReleaseBranch" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.defaultReleaseBranch"></a>

```typescript
public readonly defaultReleaseBranch: string;
```

- *Type:* string
- *Default:* "main"

The name of the main release branch.

---

##### `artifactsDirectory`<sup>Optional</sup> <a name="artifactsDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.artifactsDirectory"></a>

```typescript
public readonly artifactsDirectory: string;
```

- *Type:* string
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `autoApproveUpgrades`<sup>Optional</sup> <a name="autoApproveUpgrades" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoApproveUpgrades"></a>

```typescript
public readonly autoApproveUpgrades: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildWorkflow"></a>

```typescript
public readonly buildWorkflow: boolean;
```

- *Type:* boolean
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `buildWorkflowTriggers`<sup>Optional</sup> <a name="buildWorkflowTriggers" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildWorkflowTriggers"></a>

```typescript
public readonly buildWorkflowTriggers: Triggers;
```

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundlerOptions`<sup>Optional</sup> <a name="bundlerOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bundlerOptions"></a>

```typescript
public readonly bundlerOptions: BundlerOptions;
```

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `codeCov`<sup>Optional</sup> <a name="codeCov" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeCov"></a>

```typescript
public readonly codeCov: boolean;
```

- *Type:* boolean
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret.

---

##### `codeCovTokenSecret`<sup>Optional</sup> <a name="codeCovTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeCovTokenSecret"></a>

```typescript
public readonly codeCovTokenSecret: string;
```

- *Type:* string
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyrightOwner`<sup>Optional</sup> <a name="copyrightOwner" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.copyrightOwner"></a>

```typescript
public readonly copyrightOwner: string;
```

- *Type:* string
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyrightPeriod`<sup>Optional</sup> <a name="copyrightPeriod" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.copyrightPeriod"></a>

```typescript
public readonly copyrightPeriod: string;
```

- *Type:* string
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.dependabot"></a>

```typescript
public readonly dependabot: boolean;
```

- *Type:* boolean
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabotOptions`<sup>Optional</sup> <a name="dependabotOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.dependabotOptions"></a>

```typescript
public readonly dependabotOptions: DependabotOptions;
```

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `depsUpgrade`<sup>Optional</sup> <a name="depsUpgrade" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.depsUpgrade"></a>

```typescript
public readonly depsUpgrade: boolean;
```

- *Type:* boolean
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `depsUpgradeOptions`<sup>Optional</sup> <a name="depsUpgradeOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.depsUpgradeOptions"></a>

```typescript
public readonly depsUpgradeOptions: UpgradeDependenciesOptions;
```

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitignore"></a>

```typescript
public readonly gitignore: string[];
```

- *Type:* string[]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jest"></a>

```typescript
public readonly jest: boolean;
```

- *Type:* boolean
- *Default:* true

Setup jest unit tests.

---

##### `jestOptions`<sup>Optional</sup> <a name="jestOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jestOptions"></a>

```typescript
public readonly jestOptions: JestOptions;
```

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutableBuild`<sup>Optional</sup> <a name="mutableBuild" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mutableBuild"></a>

```typescript
public readonly mutableBuild: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```typescript
public readonly npmignore: string[];
```

- *Type:* string[]

Additional entries to .npmignore.

---

##### `npmignoreEnabled`<sup>Optional</sup> <a name="npmignoreEnabled" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmignoreEnabled"></a>

```typescript
public readonly npmignoreEnabled: boolean;
```

- *Type:* boolean
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npmIgnoreOptions`<sup>Optional</sup> <a name="npmIgnoreOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmIgnoreOptions"></a>

```typescript
public readonly npmIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.package"></a>

```typescript
public readonly package: boolean;
```

- *Type:* boolean
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prettier"></a>

```typescript
public readonly prettier: boolean;
```

- *Type:* boolean
- *Default:* false

Setup prettier.

---

##### `prettierOptions`<sup>Optional</sup> <a name="prettierOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prettierOptions"></a>

```typescript
public readonly prettierOptions: PrettierOptions;
```

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projenDevDependency`<sup>Optional</sup> <a name="projenDevDependency" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenDevDependency"></a>

```typescript
public readonly projenDevDependency: boolean;
```

- *Type:* boolean
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJs"></a>

```typescript
public readonly projenrcJs: boolean;
```

- *Type:* boolean
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJsOptions"></a>

```typescript
public readonly projenrcJsOptions: ProjenrcOptions;
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projenVersion`<sup>Optional</sup> <a name="projenVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenVersion"></a>

```typescript
public readonly projenVersion: string;
```

- *Type:* string
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pullRequestTemplate`<sup>Optional</sup> <a name="pullRequestTemplate" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pullRequestTemplate"></a>

```typescript
public readonly pullRequestTemplate: boolean;
```

- *Type:* boolean
- *Default:* true

Include a GitHub pull request template.

---

##### `pullRequestTemplateContents`<sup>Optional</sup> <a name="pullRequestTemplateContents" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pullRequestTemplateContents"></a>

```typescript
public readonly pullRequestTemplateContents: string[];
```

- *Type:* string[]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.release"></a>

```typescript
public readonly release: boolean;
```

- *Type:* boolean
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `releaseToNpm`<sup>Optional</sup> <a name="releaseToNpm" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseToNpm"></a>

```typescript
public readonly releaseToNpm: boolean;
```

- *Type:* boolean
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`releaseWorkflow`~~<sup>Optional</sup> <a name="releaseWorkflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```typescript
public readonly releaseWorkflow: boolean;
```

- *Type:* boolean
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflowBootstrapSteps`<sup>Optional</sup> <a name="workflowBootstrapSteps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowBootstrapSteps"></a>

```typescript
public readonly workflowBootstrapSteps: JobStep[];
```

- *Type:* projen.github.workflows.JobStep[]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflowGitIdentity`<sup>Optional</sup> <a name="workflowGitIdentity" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowGitIdentity"></a>

```typescript
public readonly workflowGitIdentity: GitIdentity;
```

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflowNodeVersion`<sup>Optional</sup> <a name="workflowNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowNodeVersion"></a>

```typescript
public readonly workflowNodeVersion: string;
```

- *Type:* string
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `disableTsconfig`<sup>Optional</sup> <a name="disableTsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.disableTsconfig"></a>

```typescript
public readonly disableTsconfig: boolean;
```

- *Type:* boolean
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disableTsconfigDev`<sup>Optional</sup> <a name="disableTsconfigDev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.disableTsconfigDev"></a>

```typescript
public readonly disableTsconfigDev: boolean;
```

- *Type:* boolean
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.docgen"></a>

```typescript
public readonly docgen: boolean;
```

- *Type:* boolean
- *Default:* false

Docgen by Typedoc.

---

##### `docsDirectory`<sup>Optional</sup> <a name="docsDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.docsDirectory"></a>

```typescript
public readonly docsDirectory: string;
```

- *Type:* string
- *Default:* "docs"

Docs directory.

---

##### `entrypointTypes`<sup>Optional</sup> <a name="entrypointTypes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.entrypointTypes"></a>

```typescript
public readonly entrypointTypes: string;
```

- *Type:* string
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.eslint"></a>

```typescript
public readonly eslint: boolean;
```

- *Type:* boolean
- *Default:* true

Setup eslint.

---

##### `eslintOptions`<sup>Optional</sup> <a name="eslintOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.eslintOptions"></a>

```typescript
public readonly eslintOptions: EslintOptions;
```

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.libdir"></a>

```typescript
public readonly libdir: string;
```

- *Type:* string
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcTs"></a>

```typescript
public readonly projenrcTs: boolean;
```

- *Type:* boolean
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcTsOptions"></a>

```typescript
public readonly projenrcTsOptions: ProjenrcOptions;
```

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sampleCode`<sup>Optional</sup> <a name="sampleCode" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.sampleCode"></a>

```typescript
public readonly sampleCode: boolean;
```

- *Type:* boolean
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.srcdir"></a>

```typescript
public readonly srcdir: string;
```

- *Type:* string
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.testdir"></a>

```typescript
public readonly testdir: string;
```

- *Type:* string
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfig"></a>

```typescript
public readonly tsconfig: TypescriptConfigOptions;
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfigDev`<sup>Optional</sup> <a name="tsconfigDev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfigDev"></a>

```typescript
public readonly tsconfigDev: TypescriptConfigOptions;
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfigDevFile`<sup>Optional</sup> <a name="tsconfigDevFile" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfigDevFile"></a>

```typescript
public readonly tsconfigDevFile: string;
```

- *Type:* string
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescriptVersion`<sup>Optional</sup> <a name="typescriptVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.typescriptVersion"></a>

```typescript
public readonly typescriptVersion: string;
```

- *Type:* string
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `buildCommand`<sup>Optional</sup> <a name="buildCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildCommand"></a>

```typescript
public readonly buildCommand: string;
```

- *Type:* string
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkout"></a>

```typescript
public readonly cdkout: string;
```

- *Type:* string
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.context"></a>

```typescript
public readonly context: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `featureFlags`<sup>Optional</sup> <a name="featureFlags" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.featureFlags"></a>

```typescript
public readonly featureFlags: boolean;
```

- *Type:* boolean
- *Default:* true

Include all feature flags in cdk.json.

---

##### `requireApproval`<sup>Optional</sup> <a name="requireApproval" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.requireApproval"></a>

```typescript
public readonly requireApproval: ApprovalLevel;
```

- *Type:* projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watchExcludes`<sup>Optional</sup> <a name="watchExcludes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.watchExcludes"></a>

```typescript
public readonly watchExcludes: string[];
```

- *Type:* string[]
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watchIncludes`<sup>Optional</sup> <a name="watchIncludes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.watchIncludes"></a>

```typescript
public readonly watchIncludes: string[];
```

- *Type:* string[]
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkVersion"></a>

```typescript
public readonly cdkVersion: string;
```

- *Type:* string
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdkAssert`~~<sup>Optional</sup> <a name="cdkAssert" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkAssert"></a>

- *Deprecated:* The

```typescript
public readonly cdkAssert: boolean;
```

- *Type:* boolean
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdkAssertions`<sup>Optional</sup> <a name="cdkAssertions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkAssertions"></a>

```typescript
public readonly cdkAssertions: boolean;
```

- *Type:* boolean
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdkDependencies`~~<sup>Optional</sup> <a name="cdkDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

```typescript
public readonly cdkDependencies: string[];
```

- *Type:* string[]

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdkDependenciesAsDeps`~~<sup>Optional</sup> <a name="cdkDependenciesAsDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

```typescript
public readonly cdkDependenciesAsDeps: boolean;
```

- *Type:* boolean
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdkTestDependencies`~~<sup>Optional</sup> <a name="cdkTestDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

```typescript
public readonly cdkTestDependencies: string[];
```

- *Type:* string[]

AWS CDK modules required for testing.

---

##### `cdkVersionPinning`<sup>Optional</sup> <a name="cdkVersionPinning" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkVersionPinning"></a>

```typescript
public readonly cdkVersionPinning: boolean;
```

- *Type:* boolean

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructsVersion`<sup>Optional</sup> <a name="constructsVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.constructsVersion"></a>

```typescript
public readonly constructsVersion: string;
```

- *Type:* string
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `appEntrypoint`<sup>Optional</sup> <a name="appEntrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.appEntrypoint"></a>

```typescript
public readonly appEntrypoint: string;
```

- *Type:* string
- *Default:* "main.ts"

The CDK app's entrypoint (relative to the source directory, which is "src" by default).

---

##### `edgeLambdaAutoDiscover`<sup>Optional</sup> <a name="edgeLambdaAutoDiscover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.edgeLambdaAutoDiscover"></a>

```typescript
public readonly edgeLambdaAutoDiscover: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically adds an `cloudfront.experimental.EdgeFunction` for each `.edge-lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `integrationTestAutoDiscover`<sup>Optional</sup> <a name="integrationTestAutoDiscover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.integrationTestAutoDiscover"></a>

```typescript
public readonly integrationTestAutoDiscover: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically discovers and creates integration tests for each `.integ.ts` file in under your test directory.

---

##### `lambdaAutoDiscover`<sup>Optional</sup> <a name="lambdaAutoDiscover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaAutoDiscover"></a>

```typescript
public readonly lambdaAutoDiscover: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically adds an `awscdk.LambdaFunction` for each `.lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `lambdaExtensionAutoDiscover`<sup>Optional</sup> <a name="lambdaExtensionAutoDiscover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaExtensionAutoDiscover"></a>

```typescript
public readonly lambdaExtensionAutoDiscover: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically adds an `awscdk.LambdaExtension` for each `.lambda-extension.ts` entrypoint in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `lambdaOptions`<sup>Optional</sup> <a name="lambdaOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaOptions"></a>

```typescript
public readonly lambdaOptions: LambdaFunctionCommonOptions;
```

- *Type:* projen.awscdk.LambdaFunctionCommonOptions
- *Default:* default options

Common options for all AWS Lambda functions.

---

### SemverGroup <a name="SemverGroup" id="aws-prototyping-sdk.nx_monorepo.SemverGroup"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.Initializer"></a>

```typescript
import { nx_monorepo } from 'aws-prototyping-sdk'

const semverGroup: nx_monorepo.SemverGroup = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SemverGroup.property.dependencies">dependencies</a></code> | <code>string[]</code> | the names of the dependencies (eg. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SemverGroup.property.packages">packages</a></code> | <code>string[]</code> | the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SemverGroup.property.range">range</a></code> | <code>string</code> | the semver range which dependencies in this group should use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SemverGroup.property.dependencyTypes">dependencyTypes</a></code> | <code>string[]</code> | optionally only apply this group to dependencies of the provided types. |

---

##### `dependencies`<sup>Required</sup> <a name="dependencies" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.property.dependencies"></a>

```typescript
public readonly dependencies: string[];
```

- *Type:* string[]

the names of the dependencies (eg.

"lodash") which belong to this group

---

##### `packages`<sup>Required</sup> <a name="packages" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.property.packages"></a>

```typescript
public readonly packages: string[];
```

- *Type:* string[]

the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name.

---

##### `range`<sup>Required</sup> <a name="range" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.property.range"></a>

```typescript
public readonly range: string;
```

- *Type:* string

the semver range which dependencies in this group should use.

---

##### `dependencyTypes`<sup>Optional</sup> <a name="dependencyTypes" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.property.dependencyTypes"></a>

```typescript
public readonly dependencyTypes: string[];
```

- *Type:* string[]

optionally only apply this group to dependencies of the provided types.

---

### SonarCodeScannerConfig <a name="SonarCodeScannerConfig" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.Initializer"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

const sonarCodeScannerConfig: pipeline.SonarCodeScannerConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeAuthorizedGroup">sonarqubeAuthorizedGroup</a></code> | <code>string</code> | Group name in Sonarqube with access to administer this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeDefaultProfileOrGateName">sonarqubeDefaultProfileOrGateName</a></code> | <code>string</code> | Default profile/gate name i.e: your org profile. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeEndpoint">sonarqubeEndpoint</a></code> | <code>string</code> | endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeProjectName">sonarqubeProjectName</a></code> | <code>string</code> | Name of the project to create in Sonarqube. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.cdkOutDir">cdkOutDir</a></code> | <code>string</code> | directory containing the synthesized cdk resources. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.cfnNagIgnorePath">cfnNagIgnorePath</a></code> | <code>string</code> | path to a file containing the cfn nag suppression rules. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.excludeGlobsForScan">excludeGlobsForScan</a></code> | <code>string[]</code> | glob patterns to exclude from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.includeGlobsForScan">includeGlobsForScan</a></code> | <code>string[]</code> | glob patterns to include from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.preArchiveCommands">preArchiveCommands</a></code> | <code>string[]</code> | Hook which allows custom commands to be executed before the process commences the archival process. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeSpecificProfileOrGateName">sonarqubeSpecificProfileOrGateName</a></code> | <code>string</code> | Specific profile/gate name i.e: language specific. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeTags">sonarqubeTags</a></code> | <code>string[]</code> | Tags to associate with this project. |

---

##### `sonarqubeAuthorizedGroup`<sup>Required</sup> <a name="sonarqubeAuthorizedGroup" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeAuthorizedGroup"></a>

```typescript
public readonly sonarqubeAuthorizedGroup: string;
```

- *Type:* string

Group name in Sonarqube with access to administer this project.

---

##### `sonarqubeDefaultProfileOrGateName`<sup>Required</sup> <a name="sonarqubeDefaultProfileOrGateName" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeDefaultProfileOrGateName"></a>

```typescript
public readonly sonarqubeDefaultProfileOrGateName: string;
```

- *Type:* string

Default profile/gate name i.e: your org profile.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqubeEndpoint`<sup>Required</sup> <a name="sonarqubeEndpoint" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeEndpoint"></a>

```typescript
public readonly sonarqubeEndpoint: string;
```

- *Type:* string

endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>.

Note: Ensure a trailing '/' is not included.

---

##### `sonarqubeProjectName`<sup>Required</sup> <a name="sonarqubeProjectName" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeProjectName"></a>

```typescript
public readonly sonarqubeProjectName: string;
```

- *Type:* string

Name of the project to create in Sonarqube.

---

##### `cdkOutDir`<sup>Optional</sup> <a name="cdkOutDir" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.cdkOutDir"></a>

```typescript
public readonly cdkOutDir: string;
```

- *Type:* string

directory containing the synthesized cdk resources.

---

##### `cfnNagIgnorePath`<sup>Optional</sup> <a name="cfnNagIgnorePath" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.cfnNagIgnorePath"></a>

```typescript
public readonly cfnNagIgnorePath: string;
```

- *Type:* string

path to a file containing the cfn nag suppression rules.

---

##### `excludeGlobsForScan`<sup>Optional</sup> <a name="excludeGlobsForScan" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.excludeGlobsForScan"></a>

```typescript
public readonly excludeGlobsForScan: string[];
```

- *Type:* string[]

glob patterns to exclude from sonar scan.

---

##### `includeGlobsForScan`<sup>Optional</sup> <a name="includeGlobsForScan" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.includeGlobsForScan"></a>

```typescript
public readonly includeGlobsForScan: string[];
```

- *Type:* string[]

glob patterns to include from sonar scan.

---

##### `preArchiveCommands`<sup>Optional</sup> <a name="preArchiveCommands" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.preArchiveCommands"></a>

```typescript
public readonly preArchiveCommands: string[];
```

- *Type:* string[]

Hook which allows custom commands to be executed before the process commences the archival process.

---

##### `sonarqubeSpecificProfileOrGateName`<sup>Optional</sup> <a name="sonarqubeSpecificProfileOrGateName" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeSpecificProfileOrGateName"></a>

```typescript
public readonly sonarqubeSpecificProfileOrGateName: string;
```

- *Type:* string

Specific profile/gate name i.e: language specific.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqubeTags`<sup>Optional</sup> <a name="sonarqubeTags" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeTags"></a>

```typescript
public readonly sonarqubeTags: string[];
```

- *Type:* string[]

Tags to associate with this project.

---

### SonarCodeScannerProps <a name="SonarCodeScannerProps" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps"></a>

SonarCodeScanners properties.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.Initializer"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

const sonarCodeScannerProps: pipeline.SonarCodeScannerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeAuthorizedGroup">sonarqubeAuthorizedGroup</a></code> | <code>string</code> | Group name in Sonarqube with access to administer this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeDefaultProfileOrGateName">sonarqubeDefaultProfileOrGateName</a></code> | <code>string</code> | Default profile/gate name i.e: your org profile. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeEndpoint">sonarqubeEndpoint</a></code> | <code>string</code> | endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeProjectName">sonarqubeProjectName</a></code> | <code>string</code> | Name of the project to create in Sonarqube. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.cdkOutDir">cdkOutDir</a></code> | <code>string</code> | directory containing the synthesized cdk resources. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.cfnNagIgnorePath">cfnNagIgnorePath</a></code> | <code>string</code> | path to a file containing the cfn nag suppression rules. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.excludeGlobsForScan">excludeGlobsForScan</a></code> | <code>string[]</code> | glob patterns to exclude from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.includeGlobsForScan">includeGlobsForScan</a></code> | <code>string[]</code> | glob patterns to include from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.preArchiveCommands">preArchiveCommands</a></code> | <code>string[]</code> | Hook which allows custom commands to be executed before the process commences the archival process. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeSpecificProfileOrGateName">sonarqubeSpecificProfileOrGateName</a></code> | <code>string</code> | Specific profile/gate name i.e: language specific. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeTags">sonarqubeTags</a></code> | <code>string[]</code> | Tags to associate with this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.artifactBucketArn">artifactBucketArn</a></code> | <code>string</code> | S3 bucket ARN containing the built artifacts from the synth build. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.synthBuildArn">synthBuildArn</a></code> | <code>string</code> | ARN for the CodeBuild task responsible for executing the synth command. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.artifactBucketKeyArn">artifactBucketKeyArn</a></code> | <code>string</code> | Artifact bucket key ARN used to encrypt the artifacts. |

---

##### `sonarqubeAuthorizedGroup`<sup>Required</sup> <a name="sonarqubeAuthorizedGroup" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeAuthorizedGroup"></a>

```typescript
public readonly sonarqubeAuthorizedGroup: string;
```

- *Type:* string

Group name in Sonarqube with access to administer this project.

---

##### `sonarqubeDefaultProfileOrGateName`<sup>Required</sup> <a name="sonarqubeDefaultProfileOrGateName" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeDefaultProfileOrGateName"></a>

```typescript
public readonly sonarqubeDefaultProfileOrGateName: string;
```

- *Type:* string

Default profile/gate name i.e: your org profile.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqubeEndpoint`<sup>Required</sup> <a name="sonarqubeEndpoint" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeEndpoint"></a>

```typescript
public readonly sonarqubeEndpoint: string;
```

- *Type:* string

endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>.

Note: Ensure a trailing '/' is not included.

---

##### `sonarqubeProjectName`<sup>Required</sup> <a name="sonarqubeProjectName" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeProjectName"></a>

```typescript
public readonly sonarqubeProjectName: string;
```

- *Type:* string

Name of the project to create in Sonarqube.

---

##### `cdkOutDir`<sup>Optional</sup> <a name="cdkOutDir" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.cdkOutDir"></a>

```typescript
public readonly cdkOutDir: string;
```

- *Type:* string

directory containing the synthesized cdk resources.

---

##### `cfnNagIgnorePath`<sup>Optional</sup> <a name="cfnNagIgnorePath" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.cfnNagIgnorePath"></a>

```typescript
public readonly cfnNagIgnorePath: string;
```

- *Type:* string

path to a file containing the cfn nag suppression rules.

---

##### `excludeGlobsForScan`<sup>Optional</sup> <a name="excludeGlobsForScan" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.excludeGlobsForScan"></a>

```typescript
public readonly excludeGlobsForScan: string[];
```

- *Type:* string[]

glob patterns to exclude from sonar scan.

---

##### `includeGlobsForScan`<sup>Optional</sup> <a name="includeGlobsForScan" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.includeGlobsForScan"></a>

```typescript
public readonly includeGlobsForScan: string[];
```

- *Type:* string[]

glob patterns to include from sonar scan.

---

##### `preArchiveCommands`<sup>Optional</sup> <a name="preArchiveCommands" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.preArchiveCommands"></a>

```typescript
public readonly preArchiveCommands: string[];
```

- *Type:* string[]

Hook which allows custom commands to be executed before the process commences the archival process.

---

##### `sonarqubeSpecificProfileOrGateName`<sup>Optional</sup> <a name="sonarqubeSpecificProfileOrGateName" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeSpecificProfileOrGateName"></a>

```typescript
public readonly sonarqubeSpecificProfileOrGateName: string;
```

- *Type:* string

Specific profile/gate name i.e: language specific.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqubeTags`<sup>Optional</sup> <a name="sonarqubeTags" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeTags"></a>

```typescript
public readonly sonarqubeTags: string[];
```

- *Type:* string[]

Tags to associate with this project.

---

##### `artifactBucketArn`<sup>Required</sup> <a name="artifactBucketArn" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.artifactBucketArn"></a>

```typescript
public readonly artifactBucketArn: string;
```

- *Type:* string

S3 bucket ARN containing the built artifacts from the synth build.

---

##### `synthBuildArn`<sup>Required</sup> <a name="synthBuildArn" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.synthBuildArn"></a>

```typescript
public readonly synthBuildArn: string;
```

- *Type:* string

ARN for the CodeBuild task responsible for executing the synth command.

---

##### `artifactBucketKeyArn`<sup>Optional</sup> <a name="artifactBucketKeyArn" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.artifactBucketKeyArn"></a>

```typescript
public readonly artifactBucketKeyArn: string;
```

- *Type:* string

Artifact bucket key ARN used to encrypt the artifacts.

---

### SyncpackConfig <a name="SyncpackConfig" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.Initializer"></a>

```typescript
import { nx_monorepo } from 'aws-prototyping-sdk'

const syncpackConfig: nx_monorepo.SyncpackConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.dependencyTypes">dependencyTypes</a></code> | <code>string[]</code> | which dependency properties to search within. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.dev">dev</a></code> | <code>boolean</code> | whether to search within devDependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.filter">filter</a></code> | <code>string</code> | a string which will be passed to `new RegExp()` to match against package names that should be included. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.indent">indent</a></code> | <code>string</code> | the character(s) to be used to indent your package.json files when writing to disk. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.overrides">overrides</a></code> | <code>boolean</code> | whether to search within npm overrides. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.peer">peer</a></code> | <code>boolean</code> | whether to search within peerDependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.pnpmOverrides">pnpmOverrides</a></code> | <code>boolean</code> | whether to search within pnpm overrides. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.prod">prod</a></code> | <code>boolean</code> | whether to search within dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.resolutions">resolutions</a></code> | <code>boolean</code> | whether to search within yarn resolutions. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.semverGroups">semverGroups</a></code> | <code>aws-prototyping-sdk.nx_monorepo.SemverGroup[]</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.semverRange">semverRange</a></code> | <code>string</code> | defaults to `""` to ensure that exact dependency versions are used instead of loose ranges. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.sortAz">sortAz</a></code> | <code>string[]</code> | which fields within package.json files should be sorted alphabetically. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.sortFirst">sortFirst</a></code> | <code>string[]</code> | which fields within package.json files should appear at the top, and in what order. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.source">source</a></code> | <code>string[]</code> | glob patterns for package.json file locations. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.versionGroups">versionGroups</a></code> | <code>aws-prototyping-sdk.nx_monorepo.VersionGroup[]</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.workspace">workspace</a></code> | <code>boolean</code> | whether to include the versions of the `--source` packages developed in your workspace/monorepo as part of the search for versions to sync. |

---

##### `dependencyTypes`<sup>Required</sup> <a name="dependencyTypes" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.dependencyTypes"></a>

```typescript
public readonly dependencyTypes: string[];
```

- *Type:* string[]

which dependency properties to search within.

---

##### `dev`<sup>Required</sup> <a name="dev" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.dev"></a>

```typescript
public readonly dev: boolean;
```

- *Type:* boolean

whether to search within devDependencies.

---

##### `filter`<sup>Required</sup> <a name="filter" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.filter"></a>

```typescript
public readonly filter: string;
```

- *Type:* string

a string which will be passed to `new RegExp()` to match against package names that should be included.

---

##### `indent`<sup>Required</sup> <a name="indent" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.indent"></a>

```typescript
public readonly indent: string;
```

- *Type:* string

the character(s) to be used to indent your package.json files when writing to disk.

---

##### `overrides`<sup>Required</sup> <a name="overrides" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.overrides"></a>

```typescript
public readonly overrides: boolean;
```

- *Type:* boolean

whether to search within npm overrides.

---

##### `peer`<sup>Required</sup> <a name="peer" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.peer"></a>

```typescript
public readonly peer: boolean;
```

- *Type:* boolean

whether to search within peerDependencies.

---

##### `pnpmOverrides`<sup>Required</sup> <a name="pnpmOverrides" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.pnpmOverrides"></a>

```typescript
public readonly pnpmOverrides: boolean;
```

- *Type:* boolean

whether to search within pnpm overrides.

---

##### `prod`<sup>Required</sup> <a name="prod" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.prod"></a>

```typescript
public readonly prod: boolean;
```

- *Type:* boolean

whether to search within dependencies.

---

##### `resolutions`<sup>Required</sup> <a name="resolutions" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.resolutions"></a>

```typescript
public readonly resolutions: boolean;
```

- *Type:* boolean

whether to search within yarn resolutions.

---

##### `semverGroups`<sup>Required</sup> <a name="semverGroups" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.semverGroups"></a>

```typescript
public readonly semverGroups: SemverGroup[];
```

- *Type:* aws-prototyping-sdk.nx_monorepo.SemverGroup[]

---

##### `semverRange`<sup>Required</sup> <a name="semverRange" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.semverRange"></a>

```typescript
public readonly semverRange: string;
```

- *Type:* string

defaults to `""` to ensure that exact dependency versions are used instead of loose ranges.

---

##### `sortAz`<sup>Required</sup> <a name="sortAz" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.sortAz"></a>

```typescript
public readonly sortAz: string[];
```

- *Type:* string[]

which fields within package.json files should be sorted alphabetically.

---

##### `sortFirst`<sup>Required</sup> <a name="sortFirst" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.sortFirst"></a>

```typescript
public readonly sortFirst: string[];
```

- *Type:* string[]

which fields within package.json files should appear at the top, and in what order.

---

##### `source`<sup>Required</sup> <a name="source" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.source"></a>

```typescript
public readonly source: string[];
```

- *Type:* string[]

glob patterns for package.json file locations.

---

##### `versionGroups`<sup>Required</sup> <a name="versionGroups" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.versionGroups"></a>

```typescript
public readonly versionGroups: VersionGroup[];
```

- *Type:* aws-prototyping-sdk.nx_monorepo.VersionGroup[]

---

##### `workspace`<sup>Required</sup> <a name="workspace" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.workspace"></a>

```typescript
public readonly workspace: boolean;
```

- *Type:* boolean

whether to include the versions of the `--source` packages developed in your workspace/monorepo as part of the search for versions to sync.

---

### VersionGroup <a name="VersionGroup" id="aws-prototyping-sdk.nx_monorepo.VersionGroup"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.Initializer"></a>

```typescript
import { nx_monorepo } from 'aws-prototyping-sdk'

const versionGroup: nx_monorepo.VersionGroup = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.dependencies">dependencies</a></code> | <code>string[]</code> | the names of the dependencies (eg. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.packages">packages</a></code> | <code>string[]</code> | the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.dependencyTypes">dependencyTypes</a></code> | <code>string[]</code> | optionally only apply this group to dependencies of the provided types. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.isBanned">isBanned</a></code> | <code>boolean</code> | optionally force all dependencies in this group to be removed. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.pinVersion">pinVersion</a></code> | <code>string</code> | optionally force all dependencies in this group to have this version. |

---

##### `dependencies`<sup>Required</sup> <a name="dependencies" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.dependencies"></a>

```typescript
public readonly dependencies: string[];
```

- *Type:* string[]

the names of the dependencies (eg.

"lodash") which belong to this group

---

##### `packages`<sup>Required</sup> <a name="packages" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.packages"></a>

```typescript
public readonly packages: string[];
```

- *Type:* string[]

the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name.

---

##### `dependencyTypes`<sup>Optional</sup> <a name="dependencyTypes" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.dependencyTypes"></a>

```typescript
public readonly dependencyTypes: string[];
```

- *Type:* string[]

optionally only apply this group to dependencies of the provided types.

---

##### `isBanned`<sup>Optional</sup> <a name="isBanned" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.isBanned"></a>

```typescript
public readonly isBanned: boolean;
```

- *Type:* boolean

optionally force all dependencies in this group to be removed.

---

##### `pinVersion`<sup>Optional</sup> <a name="pinVersion" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.pinVersion"></a>

```typescript
public readonly pinVersion: string;
```

- *Type:* string

optionally force all dependencies in this group to have this version.

---

### WorkspaceConfig <a name="WorkspaceConfig" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig"></a>

Workspace configurations.

> [https://classic.yarnpkg.com/lang/en/docs/workspaces/](https://classic.yarnpkg.com/lang/en/docs/workspaces/)

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.Initializer"></a>

```typescript
import { nx_monorepo } from 'aws-prototyping-sdk'

const workspaceConfig: nx_monorepo.WorkspaceConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.additionalPackages">additionalPackages</a></code> | <code>string[]</code> | List of additional package globs to include in the workspace. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.disableNoHoistBundled">disableNoHoistBundled</a></code> | <code>boolean</code> | Disable automatically applying `noHoist` logic for all sub-project "bundledDependencies". |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.linkLocalWorkspaceBins">linkLocalWorkspaceBins</a></code> | <code>boolean</code> | Links all local workspace project bins so they can be used for local development. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.noHoist">noHoist</a></code> | <code>string[]</code> | List of package globs to exclude from hoisting in the workspace. |

---

##### `additionalPackages`<sup>Optional</sup> <a name="additionalPackages" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.additionalPackages"></a>

```typescript
public readonly additionalPackages: string[];
```

- *Type:* string[]

List of additional package globs to include in the workspace.

All packages which are parented by the monorepo are automatically added to the workspace, but you can use this
property to specify any additional paths to packages which may not be managed by projen.

---

##### `disableNoHoistBundled`<sup>Optional</sup> <a name="disableNoHoistBundled" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.disableNoHoistBundled"></a>

```typescript
public readonly disableNoHoistBundled: boolean;
```

- *Type:* boolean
- *Default:* false

Disable automatically applying `noHoist` logic for all sub-project "bundledDependencies".

---

##### `linkLocalWorkspaceBins`<sup>Optional</sup> <a name="linkLocalWorkspaceBins" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.linkLocalWorkspaceBins"></a>

```typescript
public readonly linkLocalWorkspaceBins: boolean;
```

- *Type:* boolean

Links all local workspace project bins so they can be used for local development.

Package bins are only linked when installed from the registry, however it is very useful
for monorepo development to also utilize these bin scripts. When enabled, this flag will
recursively link all bins from packages.json files to the root node_modules/.bin.

---

##### `noHoist`<sup>Optional</sup> <a name="noHoist" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.noHoist"></a>

```typescript
public readonly noHoist: string[];
```

- *Type:* string[]

List of package globs to exclude from hoisting in the workspace.

> [https://classic.yarnpkg.com/blog/2018/02/15/nohoist/](https://classic.yarnpkg.com/blog/2018/02/15/nohoist/)

---

## Classes <a name="Classes" id="Classes"></a>

### AwsPrototypingChecks <a name="AwsPrototypingChecks" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks"></a>

Check best practices for prototypes.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

new pdk_nag.AwsPrototypingChecks(props?: NagPackProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.props">props</a></code> | <code>cdk-nag.NagPackProps</code> | *No description.* |

---

##### `props`<sup>Optional</sup> <a name="props" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.props"></a>

- *Type:* cdk-nag.NagPackProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.visit">visit</a></code> | Check if CfnResource and apply rules. |

---

##### `visit` <a name="visit" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.visit"></a>

```typescript
public visit(node: IConstruct): void
```

Check if CfnResource and apply rules.

###### `node`<sup>Required</sup> <a name="node" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.visit.parameter.node"></a>

- *Type:* constructs.IConstruct

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.property.readPackName">readPackName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.property.readReportStacks">readReportStacks</a></code> | <code>string[]</code> | *No description.* |

---

##### `readPackName`<sup>Required</sup> <a name="readPackName" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.property.readPackName"></a>

```typescript
public readonly readPackName: string;
```

- *Type:* string

---

##### `readReportStacks`<sup>Required</sup> <a name="readReportStacks" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.property.readReportStacks"></a>

```typescript
public readonly readReportStacks: string[];
```

- *Type:* string[]

---


### NxMonorepoProject <a name="NxMonorepoProject" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject"></a>

This project type will bootstrap a NX based monorepo with support for polygot builds, build caching, dependency graph visualization and much more.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer"></a>

```typescript
import { nx_monorepo } from 'aws-prototyping-sdk'

new nx_monorepo.NxMonorepoProject(options: NxMonorepoProjectOptions)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.options">options</a></code> | <code>aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions</code> | *No description.* |

---

##### `options`<sup>Required</sup> <a name="options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.options"></a>

- *Type:* aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBins">addBins</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBundledDeps">addBundledDeps</a></code> | Defines bundled dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addCompileCommand">addCompileCommand</a></code> | DEPRECATED. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDeps">addDeps</a></code> | Defines normal dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDevDeps">addDevDeps</a></code> | Defines development/test dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addFields">addFields</a></code> | Directly set fields in `package.json`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addKeywords">addKeywords</a></code> | Adds keywords to package.json (deduplicated). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPeerDeps">addPeerDeps</a></code> | Defines peer dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addScripts">addScripts</a></code> | Replaces the contents of multiple npm package.json scripts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTestCommand">addTestCommand</a></code> | DEPRECATED. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.hasScript">hasScript</a></code> | Indicates if a script by the name name is defined. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeScript">removeScript</a></code> | Removes the npm script (always successful). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.renderWorkflowSetup">renderWorkflowSetup</a></code> | Returns the set of workflow steps which should be executed to bootstrap a workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.setScript">setScript</a></code> | Replaces the contents of an npm package.json script. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addImplicitDependency">addImplicitDependency</a></code> | Create an implicit dependency between two Projects. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addJavaDependency">addJavaDependency</a></code> | Adds a dependency between two Java Projects in the monorepo. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask">addNxRunManyTask</a></code> | Add project task that executes `npx nx run-many ...` style command. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPythonPoetryDependency">addPythonPoetryDependency</a></code> | Adds a dependency between two Python Projects in the monorepo. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addWorkspacePackages">addWorkspacePackages</a></code> | Add one or more additional package globs to the workspace. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand">formatNxRunManyCommand</a></code> | Helper to format `npx nx run-many ...` style command. |

---

##### `addExcludeFromCleanup` <a name="addExcludeFromCleanup" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addExcludeFromCleanup"></a>

```typescript
public addExcludeFromCleanup(globs: string): void
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* string

The glob patterns to match.

---

##### `addGitIgnore` <a name="addGitIgnore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addGitIgnore"></a>

```typescript
public addGitIgnore(pattern: string): void
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addGitIgnore.parameter.pattern"></a>

- *Type:* string

The glob pattern to ignore.

---

##### `addPackageIgnore` <a name="addPackageIgnore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPackageIgnore"></a>

```typescript
public addPackageIgnore(pattern: string): void
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPackageIgnore.parameter.pattern"></a>

- *Type:* string

---

##### `addTask` <a name="addTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask"></a>

```typescript
public addTask(name: string, props?: TaskOptions): Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.name"></a>

- *Type:* string

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.props"></a>

- *Type:* projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTip"></a>

```typescript
public addTip(message: string): void
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTip.parameter.message"></a>

- *Type:* string

The message.

---

##### `annotateGenerated` <a name="annotateGenerated" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.annotateGenerated"></a>

```typescript
public annotateGenerated(glob: string): void
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.annotateGenerated.parameter.glob"></a>

- *Type:* string

the glob pattern to match (could be a file path).

---

##### `postSynthesize` <a name="postSynthesize" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.postSynthesize"></a>

```typescript
public postSynthesize(): void
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `preSynthesize` <a name="preSynthesize" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.preSynthesize"></a>

```typescript
public preSynthesize(): void
```

Called before all components are synthesized.

##### `removeTask` <a name="removeTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeTask"></a>

```typescript
public removeTask(name: string): Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeTask.parameter.name"></a>

- *Type:* string

The name of the task to remove.

---

##### `runTaskCommand` <a name="runTaskCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.runTaskCommand"></a>

```typescript
public runTaskCommand(task: Task): string
```

Returns the shell command to execute in order to run a task.

This will
typically be `npx projen TASK`.

###### `task`<sup>Required</sup> <a name="task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.synth"></a>

```typescript
public synth(): void
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `tryFindFile` <a name="tryFindFile" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindFile"></a>

```typescript
public tryFindFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindJsonFile"></a>

```typescript
public tryFindJsonFile(filePath: string): JsonFile
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### `tryFindObjectFile` <a name="tryFindObjectFile" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindObjectFile"></a>

```typescript
public tryFindObjectFile(filePath: string): ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### `tryRemoveFile` <a name="tryRemoveFile" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryRemoveFile"></a>

```typescript
public tryRemoveFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `addBins` <a name="addBins" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBins"></a>

```typescript
public addBins(bins: {[ key: string ]: string}): void
```

###### `bins`<sup>Required</sup> <a name="bins" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBins.parameter.bins"></a>

- *Type:* {[ key: string ]: string}

---

##### `addBundledDeps` <a name="addBundledDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBundledDeps"></a>

```typescript
public addBundledDeps(deps: string): void
```

Defines bundled dependencies.

Bundled dependencies will be added as normal dependencies as well as to the
`bundledDependencies` section of your `package.json`.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBundledDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addCompileCommand`~~ <a name="addCompileCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addCompileCommand"></a>

```typescript
public addCompileCommand(commands: string): void
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addCompileCommand.parameter.commands"></a>

- *Type:* string

---

##### `addDeps` <a name="addDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDeps"></a>

```typescript
public addDeps(deps: string): void
```

Defines normal dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `addDevDeps` <a name="addDevDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDevDeps"></a>

```typescript
public addDevDeps(deps: string): void
```

Defines development/test dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDevDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `addFields` <a name="addFields" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addFields"></a>

```typescript
public addFields(fields: {[ key: string ]: any}): void
```

Directly set fields in `package.json`.

###### `fields`<sup>Required</sup> <a name="fields" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addFields.parameter.fields"></a>

- *Type:* {[ key: string ]: any}

The fields to set.

---

##### `addKeywords` <a name="addKeywords" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addKeywords"></a>

```typescript
public addKeywords(keywords: string): void
```

Adds keywords to package.json (deduplicated).

###### `keywords`<sup>Required</sup> <a name="keywords" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addKeywords.parameter.keywords"></a>

- *Type:* string

The keywords to add.

---

##### `addPeerDeps` <a name="addPeerDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPeerDeps"></a>

```typescript
public addPeerDeps(deps: string): void
```

Defines peer dependencies.

When adding peer dependencies, a devDependency will also be added on the
pinned version of the declared peer. This will ensure that you are testing
your code against the minimum version required from your consumers.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPeerDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `addScripts` <a name="addScripts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addScripts"></a>

```typescript
public addScripts(scripts: {[ key: string ]: string}): void
```

Replaces the contents of multiple npm package.json scripts.

###### `scripts`<sup>Required</sup> <a name="scripts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addScripts.parameter.scripts"></a>

- *Type:* {[ key: string ]: string}

The scripts to set.

---

##### ~~`addTestCommand`~~ <a name="addTestCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTestCommand"></a>

```typescript
public addTestCommand(commands: string): void
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTestCommand.parameter.commands"></a>

- *Type:* string

---

##### ~~`hasScript`~~ <a name="hasScript" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.hasScript"></a>

```typescript
public hasScript(name: string): boolean
```

Indicates if a script by the name name is defined.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.hasScript.parameter.name"></a>

- *Type:* string

The name of the script.

---

##### `removeScript` <a name="removeScript" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeScript"></a>

```typescript
public removeScript(name: string): void
```

Removes the npm script (always successful).

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeScript.parameter.name"></a>

- *Type:* string

The name of the script.

---

##### `renderWorkflowSetup` <a name="renderWorkflowSetup" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.renderWorkflowSetup"></a>

```typescript
public renderWorkflowSetup(options?: RenderWorkflowSetupOptions): JobStep[]
```

Returns the set of workflow steps which should be executed to bootstrap a workflow.

###### `options`<sup>Optional</sup> <a name="options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.renderWorkflowSetup.parameter.options"></a>

- *Type:* projen.javascript.RenderWorkflowSetupOptions

Options.

---

##### `setScript` <a name="setScript" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.setScript"></a>

```typescript
public setScript(name: string, command: string): void
```

Replaces the contents of an npm package.json script.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.setScript.parameter.name"></a>

- *Type:* string

The script name.

---

###### `command`<sup>Required</sup> <a name="command" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.setScript.parameter.command"></a>

- *Type:* string

The command to execute.

---

##### `addImplicitDependency` <a name="addImplicitDependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addImplicitDependency"></a>

```typescript
public addImplicitDependency(dependent: Project, dependee: string | Project): void
```

Create an implicit dependency between two Projects.

This is typically
used in polygot repos where a Typescript project wants a build dependency
on a Python project as an example.

###### `dependent`<sup>Required</sup> <a name="dependent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addImplicitDependency.parameter.dependent"></a>

- *Type:* projen.Project

project you want to have the dependency.

---

###### `dependee`<sup>Required</sup> <a name="dependee" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addImplicitDependency.parameter.dependee"></a>

- *Type:* string | projen.Project

project you wish to depend on.

---

##### `addJavaDependency` <a name="addJavaDependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addJavaDependency"></a>

```typescript
public addJavaDependency(dependent: JavaProject, dependee: JavaProject): void
```

Adds a dependency between two Java Projects in the monorepo.

###### `dependent`<sup>Required</sup> <a name="dependent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addJavaDependency.parameter.dependent"></a>

- *Type:* projen.java.JavaProject

project you want to have the dependency.

---

###### `dependee`<sup>Required</sup> <a name="dependee" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addJavaDependency.parameter.dependee"></a>

- *Type:* projen.java.JavaProject

project you wish to depend on.

---

##### `addNxRunManyTask` <a name="addNxRunManyTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask"></a>

```typescript
public addNxRunManyTask(name: string, options: NxRunManyOptions): Task
```

Add project task that executes `npx nx run-many ...` style command.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.name"></a>

- *Type:* string

---

###### `options`<sup>Required</sup> <a name="options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.options"></a>

- *Type:* aws-prototyping-sdk.nx_monorepo.NxRunManyOptions

---

##### `addPythonPoetryDependency` <a name="addPythonPoetryDependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPythonPoetryDependency"></a>

```typescript
public addPythonPoetryDependency(dependent: PythonProject, dependee: PythonProject): void
```

Adds a dependency between two Python Projects in the monorepo.

The dependent must have Poetry enabled.

###### `dependent`<sup>Required</sup> <a name="dependent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPythonPoetryDependency.parameter.dependent"></a>

- *Type:* projen.python.PythonProject

project you want to have the dependency (must be a Poetry Python Project).

---

###### `dependee`<sup>Required</sup> <a name="dependee" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPythonPoetryDependency.parameter.dependee"></a>

- *Type:* projen.python.PythonProject

project you wish to depend on.

---

##### `addWorkspacePackages` <a name="addWorkspacePackages" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addWorkspacePackages"></a>

```typescript
public addWorkspacePackages(packageGlobs: string): void
```

Add one or more additional package globs to the workspace.

###### `packageGlobs`<sup>Required</sup> <a name="packageGlobs" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addWorkspacePackages.parameter.packageGlobs"></a>

- *Type:* string

paths to the package to include in the workspace (for example packages/my-package).

---

##### `formatNxRunManyCommand` <a name="formatNxRunManyCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand"></a>

```typescript
public formatNxRunManyCommand(options: NxRunManyOptions): string
```

Helper to format `npx nx run-many ...` style command.

###### `options`<sup>Required</sup> <a name="options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.options"></a>

- *Type:* aws-prototyping-sdk.nx_monorepo.NxRunManyOptions

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildTask">buildTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.compileTask">compileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.components">components</a></code> | <code>projen.Component[]</code> | Returns all the components within this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.ejected">ejected</a></code> | <code>boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.files">files</a></code> | <code>projen.FileBase[]</code> | All files in this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.name">name</a></code> | <code>string</code> | Project name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.outdir">outdir</a></code> | <code>string</code> | Absolute output directory of this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.packageTask">packageTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.postCompileTask">postCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.preCompileTask">preCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projectBuild">projectBuild</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projenCommand">projenCommand</a></code> | <code>string</code> | The command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.testTask">testTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.defaultTask">defaultTask</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.initProject">initProject</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.autoApprove">autoApprove</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.devContainer">devContainer</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.artifactsDirectory">artifactsDirectory</a></code> | <code>string</code> | The build output directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.artifactsJavascriptDirectory">artifactsJavascriptDirectory</a></code> | <code>string</code> | The location of the npm tarball after build (`${artifactsDirectory}/js`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.bundler">bundler</a></code> | <code>projen.javascript.Bundler</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.entrypoint">entrypoint</a></code> | <code>string</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.manifest">manifest</a></code> | <code>any</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.npmrc">npmrc</a></code> | <code>projen.javascript.NpmConfig</code> | The .npmrc file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.package">package</a></code> | <code>projen.javascript.NodePackage</code> | API for managing the node package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.packageManager">packageManager</a></code> | <code>projen.javascript.NodePackageManager</code> | The package manager to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.runScriptCommand">runScriptCommand</a></code> | <code>string</code> | The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.autoMerge">autoMerge</a></code> | <code>projen.github.AutoMerge</code> | Component that sets up mergify for merging approved pull requests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildWorkflow">buildWorkflow</a></code> | <code>projen.build.BuildWorkflow</code> | The PR build GitHub workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildWorkflowJobId">buildWorkflowJobId</a></code> | <code>string</code> | The job ID of the build workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.jest">jest</a></code> | <code>projen.javascript.Jest</code> | The Jest configuration (if enabled). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.maxNodeVersion">maxNodeVersion</a></code> | <code>string</code> | Maximum node version required by this package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.minNodeVersion">minNodeVersion</a></code> | <code>string</code> | Minimum node.js version required by this package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.npmignore">npmignore</a></code> | <code>projen.IgnoreFile</code> | The .npmignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.prettier">prettier</a></code> | <code>projen.javascript.Prettier</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.publisher">publisher</a></code> | <code>projen.release.Publisher</code> | Package publisher. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.release">release</a></code> | <code>projen.release.Release</code> | Release management. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.upgradeWorkflow">upgradeWorkflow</a></code> | <code>projen.javascript.UpgradeDependencies</code> | The upgrade workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.docsDirectory">docsDirectory</a></code> | <code>string</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.libdir">libdir</a></code> | <code>string</code> | The directory in which compiled .js files reside. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.srcdir">srcdir</a></code> | <code>string</code> | The directory in which the .ts sources reside. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.testdir">testdir</a></code> | <code>string</code> | The directory in which tests reside. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfigDev">tsconfigDev</a></code> | <code>projen.javascript.TypescriptConfig</code> | A typescript configuration file which covers all files (sources, tests, projen). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.watchTask">watchTask</a></code> | <code>projen.Task</code> | The "watch" task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.docgen">docgen</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.eslint">eslint</a></code> | <code>projen.javascript.Eslint</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfigEslint">tsconfigEslint</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.nxJson">nxJson</a></code> | <code>projen.JsonFile</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.subProjects">subProjects</a></code> | <code>projen.Project[]</code> | *No description.* |

---

##### `buildTask`<sup>Required</sup> <a name="buildTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildTask"></a>

```typescript
public readonly buildTask: Task;
```

- *Type:* projen.Task

---

##### `commitGenerated`<sup>Required</sup> <a name="commitGenerated" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean

Whether to commit the managed files by default.

---

##### `compileTask`<sup>Required</sup> <a name="compileTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.compileTask"></a>

```typescript
public readonly compileTask: Task;
```

- *Type:* projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.components"></a>

```typescript
public readonly components: Component[];
```

- *Type:* projen.Component[]

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.deps"></a>

```typescript
public readonly deps: Dependencies;
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.ejected"></a>

```typescript
public readonly ejected: boolean;
```

- *Type:* boolean

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.files"></a>

```typescript
public readonly files: FileBase[];
```

- *Type:* projen.FileBase[]

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitattributes"></a>

```typescript
public readonly gitattributes: GitAttributesFile;
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitignore"></a>

```typescript
public readonly gitignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.logger"></a>

```typescript
public readonly logger: Logger;
```

- *Type:* projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string

Absolute output directory of this project.

---

##### `packageTask`<sup>Required</sup> <a name="packageTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.packageTask"></a>

```typescript
public readonly packageTask: Task;
```

- *Type:* projen.Task

---

##### `postCompileTask`<sup>Required</sup> <a name="postCompileTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.postCompileTask"></a>

```typescript
public readonly postCompileTask: Task;
```

- *Type:* projen.Task

---

##### `preCompileTask`<sup>Required</sup> <a name="preCompileTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.preCompileTask"></a>

```typescript
public readonly preCompileTask: Task;
```

- *Type:* projen.Task

---

##### `projectBuild`<sup>Required</sup> <a name="projectBuild" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projectBuild"></a>

```typescript
public readonly projectBuild: ProjectBuild;
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### `projenCommand`<sup>Required</sup> <a name="projenCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.root"></a>

```typescript
public readonly root: Project;
```

- *Type:* projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tasks"></a>

```typescript
public readonly tasks: Tasks;
```

- *Type:* projen.Tasks

Project tasks.

---

##### `testTask`<sup>Required</sup> <a name="testTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.testTask"></a>

```typescript
public readonly testTask: Task;
```

- *Type:* projen.Task

---

##### `defaultTask`<sup>Optional</sup> <a name="defaultTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.defaultTask"></a>

```typescript
public readonly defaultTask: Task;
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `initProject`<sup>Optional</sup> <a name="initProject" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.initProject"></a>

```typescript
public readonly initProject: InitProject;
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### `projectType`<sup>Required</sup> <a name="projectType" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projectType"></a>

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType

---

##### `autoApprove`<sup>Optional</sup> <a name="autoApprove" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.autoApprove"></a>

```typescript
public readonly autoApprove: AutoApprove;
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.devContainer"></a>

```typescript
public readonly devContainer: DevContainer;
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.github"></a>

```typescript
public readonly github: GitHub;
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitpod"></a>

```typescript
public readonly gitpod: Gitpod;
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.vscode"></a>

```typescript
public readonly vscode: VsCode;
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`allowLibraryDependencies`~~<sup>Required</sup> <a name="allowLibraryDependencies" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.allowLibraryDependencies"></a>

- *Deprecated:* use `package.allowLibraryDependencies`

```typescript
public readonly allowLibraryDependencies: boolean;
```

- *Type:* boolean

---

##### `artifactsDirectory`<sup>Required</sup> <a name="artifactsDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.artifactsDirectory"></a>

```typescript
public readonly artifactsDirectory: string;
```

- *Type:* string

The build output directory.

An npm tarball will be created under the `js`
subdirectory. For example, if this is set to `dist` (the default), the npm
tarball will be placed under `dist/js/boom-boom-1.2.3.tg`.

---

##### `artifactsJavascriptDirectory`<sup>Required</sup> <a name="artifactsJavascriptDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.artifactsJavascriptDirectory"></a>

```typescript
public readonly artifactsJavascriptDirectory: string;
```

- *Type:* string

The location of the npm tarball after build (`${artifactsDirectory}/js`).

---

##### `bundler`<sup>Required</sup> <a name="bundler" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.bundler"></a>

```typescript
public readonly bundler: Bundler;
```

- *Type:* projen.javascript.Bundler

---

##### ~~`entrypoint`~~<sup>Required</sup> <a name="entrypoint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.entrypoint"></a>

- *Deprecated:* use `package.entrypoint`

```typescript
public readonly entrypoint: string;
```

- *Type:* string

---

##### ~~`manifest`~~<sup>Required</sup> <a name="manifest" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.manifest"></a>

- *Deprecated:* use `package.addField(x, y)`

```typescript
public readonly manifest: any;
```

- *Type:* any

---

##### `npmrc`<sup>Required</sup> <a name="npmrc" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.npmrc"></a>

```typescript
public readonly npmrc: NpmConfig;
```

- *Type:* projen.javascript.NpmConfig

The .npmrc file.

---

##### `package`<sup>Required</sup> <a name="package" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.package"></a>

```typescript
public readonly package: NodePackage;
```

- *Type:* projen.javascript.NodePackage

API for managing the node package.

---

##### ~~`packageManager`~~<sup>Required</sup> <a name="packageManager" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.packageManager"></a>

- *Deprecated:* use `package.packageManager`

```typescript
public readonly packageManager: NodePackageManager;
```

- *Type:* projen.javascript.NodePackageManager

The package manager to use.

---

##### `runScriptCommand`<sup>Required</sup> <a name="runScriptCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.runScriptCommand"></a>

```typescript
public readonly runScriptCommand: string;
```

- *Type:* string

The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager).

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.autoMerge"></a>

```typescript
public readonly autoMerge: AutoMerge;
```

- *Type:* projen.github.AutoMerge

Component that sets up mergify for merging approved pull requests.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildWorkflow"></a>

```typescript
public readonly buildWorkflow: BuildWorkflow;
```

- *Type:* projen.build.BuildWorkflow

The PR build GitHub workflow.

`undefined` if `buildWorkflow` is disabled.

---

##### `buildWorkflowJobId`<sup>Optional</sup> <a name="buildWorkflowJobId" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildWorkflowJobId"></a>

```typescript
public readonly buildWorkflowJobId: string;
```

- *Type:* string

The job ID of the build workflow.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.jest"></a>

```typescript
public readonly jest: Jest;
```

- *Type:* projen.javascript.Jest

The Jest configuration (if enabled).

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.maxNodeVersion"></a>

```typescript
public readonly maxNodeVersion: string;
```

- *Type:* string

Maximum node version required by this package.

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.minNodeVersion"></a>

```typescript
public readonly minNodeVersion: string;
```

- *Type:* string

Minimum node.js version required by this package.

---

##### `npmignore`<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.npmignore"></a>

```typescript
public readonly npmignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

The .npmignore file.

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.prettier"></a>

```typescript
public readonly prettier: Prettier;
```

- *Type:* projen.javascript.Prettier

---

##### ~~`publisher`~~<sup>Optional</sup> <a name="publisher" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.publisher"></a>

- *Deprecated:* use `release.publisher`.

```typescript
public readonly publisher: Publisher;
```

- *Type:* projen.release.Publisher

Package publisher.

This will be `undefined` if the project does not have a
release workflow.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.release"></a>

```typescript
public readonly release: Release;
```

- *Type:* projen.release.Release

Release management.

---

##### `upgradeWorkflow`<sup>Optional</sup> <a name="upgradeWorkflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.upgradeWorkflow"></a>

```typescript
public readonly upgradeWorkflow: UpgradeDependencies;
```

- *Type:* projen.javascript.UpgradeDependencies

The upgrade workflow.

---

##### `docsDirectory`<sup>Required</sup> <a name="docsDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.docsDirectory"></a>

```typescript
public readonly docsDirectory: string;
```

- *Type:* string

---

##### `libdir`<sup>Required</sup> <a name="libdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.libdir"></a>

```typescript
public readonly libdir: string;
```

- *Type:* string

The directory in which compiled .js files reside.

---

##### `srcdir`<sup>Required</sup> <a name="srcdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.srcdir"></a>

```typescript
public readonly srcdir: string;
```

- *Type:* string

The directory in which the .ts sources reside.

---

##### `testdir`<sup>Required</sup> <a name="testdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.testdir"></a>

```typescript
public readonly testdir: string;
```

- *Type:* string

The directory in which tests reside.

---

##### `tsconfigDev`<sup>Required</sup> <a name="tsconfigDev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfigDev"></a>

```typescript
public readonly tsconfigDev: TypescriptConfig;
```

- *Type:* projen.javascript.TypescriptConfig

A typescript configuration file which covers all files (sources, tests, projen).

---

##### `watchTask`<sup>Required</sup> <a name="watchTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.watchTask"></a>

```typescript
public readonly watchTask: Task;
```

- *Type:* projen.Task

The "watch" task.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.docgen"></a>

```typescript
public readonly docgen: boolean;
```

- *Type:* boolean

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.eslint"></a>

```typescript
public readonly eslint: Eslint;
```

- *Type:* projen.javascript.Eslint

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfig"></a>

```typescript
public readonly tsconfig: TypescriptConfig;
```

- *Type:* projen.javascript.TypescriptConfig

---

##### `tsconfigEslint`<sup>Optional</sup> <a name="tsconfigEslint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfigEslint"></a>

```typescript
public readonly tsconfigEslint: TypescriptConfig;
```

- *Type:* projen.javascript.TypescriptConfig

---

##### `nxJson`<sup>Required</sup> <a name="nxJson" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.nxJson"></a>

```typescript
public readonly nxJson: JsonFile;
```

- *Type:* projen.JsonFile

---

##### `subProjects`<sup>Required</sup> <a name="subProjects" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.subProjects"></a>

```typescript
public readonly subProjects: Project[];
```

- *Type:* projen.Project[]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>string</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.DEFAULT_TASK"></a>

```typescript
public readonly DEFAULT_TASK: string;
```

- *Type:* string

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### PDKNag <a name="PDKNag" id="aws-prototyping-sdk.pdk_nag.PDKNag"></a>

Helper for create a Nag Enabled App.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pdk_nag.PDKNag.Initializer"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

new pdk_nag.PDKNag()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow">addResourceSuppressionsByPathNoThrow</a></code> | Wrapper around NagSuppressions which does not throw. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.app">app</a></code> | Returns an instance of an App with Nag enabled. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.getStackAccountRegex">getStackAccountRegex</a></code> | Returns a stack account regex. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.getStackPartitionRegex">getStackPartitionRegex</a></code> | Returns a stack partition regex. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.getStackPrefix">getStackPrefix</a></code> | Returns a prefix comprising of a delimited set of Stack Ids. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.getStackRegionRegex">getStackRegionRegex</a></code> | Returns a stack region regex. |

---

##### `addResourceSuppressionsByPathNoThrow` <a name="addResourceSuppressionsByPathNoThrow" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow(stack: Stack, path: string, suppressions: NagPackSuppression[], applyToChildren?: boolean)
```

Wrapper around NagSuppressions which does not throw.

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.stack"></a>

- *Type:* aws-cdk-lib.Stack

stack instance.

---

###### `path`<sup>Required</sup> <a name="path" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.path"></a>

- *Type:* string

resource path.

---

###### `suppressions`<sup>Required</sup> <a name="suppressions" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.suppressions"></a>

- *Type:* cdk-nag.NagPackSuppression[]

list of suppressions to apply.

---

###### `applyToChildren`<sup>Optional</sup> <a name="applyToChildren" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.applyToChildren"></a>

- *Type:* boolean

whether to apply to children.

---

##### `app` <a name="app" id="aws-prototyping-sdk.pdk_nag.PDKNag.app"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

pdk_nag.PDKNag.app(props?: PDKNagAppProps)
```

Returns an instance of an App with Nag enabled.

###### `props`<sup>Optional</sup> <a name="props" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.props"></a>

- *Type:* aws-prototyping-sdk.pdk_nag.PDKNagAppProps

props to initialize the app with.

---

##### `getStackAccountRegex` <a name="getStackAccountRegex" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackAccountRegex"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

pdk_nag.PDKNag.getStackAccountRegex(stack: Stack)
```

Returns a stack account regex.

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackAccountRegex.parameter.stack"></a>

- *Type:* aws-cdk-lib.Stack

stack instance.

---

##### `getStackPartitionRegex` <a name="getStackPartitionRegex" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackPartitionRegex"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

pdk_nag.PDKNag.getStackPartitionRegex(stack: Stack)
```

Returns a stack partition regex.

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackPartitionRegex.parameter.stack"></a>

- *Type:* aws-cdk-lib.Stack

stack instance.

---

##### `getStackPrefix` <a name="getStackPrefix" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackPrefix"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

pdk_nag.PDKNag.getStackPrefix(stack: Stack)
```

Returns a prefix comprising of a delimited set of Stack Ids.

For example: StackA/NestedStackB/

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackPrefix.parameter.stack"></a>

- *Type:* aws-cdk-lib.Stack

stack instance.

---

##### `getStackRegionRegex` <a name="getStackRegionRegex" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackRegionRegex"></a>

```typescript
import { pdk_nag } from 'aws-prototyping-sdk'

pdk_nag.PDKNag.getStackRegionRegex(stack: Stack)
```

Returns a stack region regex.

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackRegionRegex.parameter.stack"></a>

- *Type:* aws-cdk-lib.Stack

stack instance.

---



### PDKPipelineJavaProject <a name="PDKPipelineJavaProject" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject"></a>

Synthesizes a Java Project with a CI/CD pipeline.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

new pipeline.PDKPipelineJavaProject(options: PDKPipelineJavaProjectOptions)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.options">options</a></code> | <code>aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions</code> | *No description.* |

---

##### `options`<sup>Required</sup> <a name="options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.options"></a>

- *Type:* aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addDependency">addDependency</a></code> | Adds a runtime dependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin">addPlugin</a></code> | Adds a build plugin to the pom. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTestDependency">addTestDependency</a></code> | Adds a test dependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addCdkDependency">addCdkDependency</a></code> | Adds an AWS CDK module dependencies. |

---

##### `addExcludeFromCleanup` <a name="addExcludeFromCleanup" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addExcludeFromCleanup"></a>

```typescript
public addExcludeFromCleanup(globs: string): void
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* string

The glob patterns to match.

---

##### `addGitIgnore` <a name="addGitIgnore" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addGitIgnore"></a>

```typescript
public addGitIgnore(pattern: string): void
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addGitIgnore.parameter.pattern"></a>

- *Type:* string

The glob pattern to ignore.

---

##### `addPackageIgnore` <a name="addPackageIgnore" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPackageIgnore"></a>

```typescript
public addPackageIgnore(_pattern: string): void
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* string

The glob pattern to exclude.

---

##### `addTask` <a name="addTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask"></a>

```typescript
public addTask(name: string, props?: TaskOptions): Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.name"></a>

- *Type:* string

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.props"></a>

- *Type:* projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTip"></a>

```typescript
public addTip(message: string): void
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTip.parameter.message"></a>

- *Type:* string

The message.

---

##### `annotateGenerated` <a name="annotateGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.annotateGenerated"></a>

```typescript
public annotateGenerated(glob: string): void
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.annotateGenerated.parameter.glob"></a>

- *Type:* string

the glob pattern to match (could be a file path).

---

##### `postSynthesize` <a name="postSynthesize" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.postSynthesize"></a>

```typescript
public postSynthesize(): void
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `preSynthesize` <a name="preSynthesize" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.preSynthesize"></a>

```typescript
public preSynthesize(): void
```

Called before all components are synthesized.

##### `removeTask` <a name="removeTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.removeTask"></a>

```typescript
public removeTask(name: string): Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.removeTask.parameter.name"></a>

- *Type:* string

The name of the task to remove.

---

##### `runTaskCommand` <a name="runTaskCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.runTaskCommand"></a>

```typescript
public runTaskCommand(task: Task): string
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.synth"></a>

```typescript
public synth(): void
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `tryFindFile` <a name="tryFindFile" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindFile"></a>

```typescript
public tryFindFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindJsonFile"></a>

```typescript
public tryFindJsonFile(filePath: string): JsonFile
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### `tryFindObjectFile` <a name="tryFindObjectFile" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindObjectFile"></a>

```typescript
public tryFindObjectFile(filePath: string): ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### `tryRemoveFile` <a name="tryRemoveFile" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryRemoveFile"></a>

```typescript
public tryRemoveFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `addDependency` <a name="addDependency" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addDependency"></a>

```typescript
public addDependency(spec: string): void
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addDependency.parameter.spec"></a>

- *Type:* string

Format `<groupId>/<artifactId>@<semver>`.

---

##### `addPlugin` <a name="addPlugin" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin"></a>

```typescript
public addPlugin(spec: string, options?: PluginOptions): Dependency
```

Adds a build plugin to the pom.

The plug in is also added as a BUILD dep to the project.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin.parameter.spec"></a>

- *Type:* string

dependency spec (`group/artifact@version`).

---

###### `options`<sup>Optional</sup> <a name="options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin.parameter.options"></a>

- *Type:* projen.java.PluginOptions

plugin options.

---

##### `addTestDependency` <a name="addTestDependency" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTestDependency"></a>

```typescript
public addTestDependency(spec: string): void
```

Adds a test dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTestDependency.parameter.spec"></a>

- *Type:* string

Format `<groupId>/<artifactId>@<semver>`.

---

##### ~~`addCdkDependency`~~ <a name="addCdkDependency" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addCdkDependency"></a>

```typescript
public addCdkDependency(modules: string): void
```

Adds an AWS CDK module dependencies.

###### `modules`<sup>Required</sup> <a name="modules" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addCdkDependency.parameter.modules"></a>

- *Type:* string

The list of modules to depend on (e.g. "software.amazon.awscdk/aws-lambda", "software.amazon.awscdk/aws-iam", etc).

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.buildTask">buildTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.compileTask">compileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.components">components</a></code> | <code>projen.Component[]</code> | Returns all the components within this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.ejected">ejected</a></code> | <code>boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.files">files</a></code> | <code>projen.FileBase[]</code> | All files in this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.name">name</a></code> | <code>string</code> | Project name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.outdir">outdir</a></code> | <code>string</code> | Absolute output directory of this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.packageTask">packageTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.postCompileTask">postCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.preCompileTask">preCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projectBuild">projectBuild</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projenCommand">projenCommand</a></code> | <code>string</code> | The command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.testTask">testTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.defaultTask">defaultTask</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.initProject">initProject</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.autoApprove">autoApprove</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.devContainer">devContainer</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.compile">compile</a></code> | <code>projen.java.MavenCompile</code> | Compile component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.distdir">distdir</a></code> | <code>string</code> | Maven artifact output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.packaging">packaging</a></code> | <code>projen.java.MavenPackaging</code> | Packaging component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.pom">pom</a></code> | <code>projen.java.Pom</code> | API for managing `pom.xml`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.junit">junit</a></code> | <code>projen.java.Junit</code> | JUnit component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projenrc">projenrc</a></code> | <code>projen.java.Projenrc</code> | Projenrc component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkConfig">cdkConfig</a></code> | <code>projen.awscdk.CdkConfig</code> | The `cdk.json` file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkDeps">cdkDeps</a></code> | <code>projen.awscdk.AwsCdkDeps</code> | CDK dependency management helper class. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkTasks">cdkTasks</a></code> | <code>projen.awscdk.CdkTasks</code> | CDK tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainClass">mainClass</a></code> | <code>string</code> | The full name of the main class of the java app (package.Class). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainClassName">mainClassName</a></code> | <code>string</code> | The name of the Java class with the static `main()` method. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainPackage">mainPackage</a></code> | <code>string</code> | The name of the Java package that includes the main class. |

---

##### `buildTask`<sup>Required</sup> <a name="buildTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.buildTask"></a>

```typescript
public readonly buildTask: Task;
```

- *Type:* projen.Task

---

##### `commitGenerated`<sup>Required</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean

Whether to commit the managed files by default.

---

##### `compileTask`<sup>Required</sup> <a name="compileTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.compileTask"></a>

```typescript
public readonly compileTask: Task;
```

- *Type:* projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.components"></a>

```typescript
public readonly components: Component[];
```

- *Type:* projen.Component[]

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.deps"></a>

```typescript
public readonly deps: Dependencies;
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.ejected"></a>

```typescript
public readonly ejected: boolean;
```

- *Type:* boolean

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.files"></a>

```typescript
public readonly files: FileBase[];
```

- *Type:* projen.FileBase[]

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitattributes"></a>

```typescript
public readonly gitattributes: GitAttributesFile;
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitignore"></a>

```typescript
public readonly gitignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.logger"></a>

```typescript
public readonly logger: Logger;
```

- *Type:* projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string

Absolute output directory of this project.

---

##### `packageTask`<sup>Required</sup> <a name="packageTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.packageTask"></a>

```typescript
public readonly packageTask: Task;
```

- *Type:* projen.Task

---

##### `postCompileTask`<sup>Required</sup> <a name="postCompileTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.postCompileTask"></a>

```typescript
public readonly postCompileTask: Task;
```

- *Type:* projen.Task

---

##### `preCompileTask`<sup>Required</sup> <a name="preCompileTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.preCompileTask"></a>

```typescript
public readonly preCompileTask: Task;
```

- *Type:* projen.Task

---

##### `projectBuild`<sup>Required</sup> <a name="projectBuild" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projectBuild"></a>

```typescript
public readonly projectBuild: ProjectBuild;
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### `projenCommand`<sup>Required</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.root"></a>

```typescript
public readonly root: Project;
```

- *Type:* projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.tasks"></a>

```typescript
public readonly tasks: Tasks;
```

- *Type:* projen.Tasks

Project tasks.

---

##### `testTask`<sup>Required</sup> <a name="testTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.testTask"></a>

```typescript
public readonly testTask: Task;
```

- *Type:* projen.Task

---

##### `defaultTask`<sup>Optional</sup> <a name="defaultTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.defaultTask"></a>

```typescript
public readonly defaultTask: Task;
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `initProject`<sup>Optional</sup> <a name="initProject" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.initProject"></a>

```typescript
public readonly initProject: InitProject;
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### `projectType`<sup>Required</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projectType"></a>

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType

---

##### `autoApprove`<sup>Optional</sup> <a name="autoApprove" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.autoApprove"></a>

```typescript
public readonly autoApprove: AutoApprove;
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.devContainer"></a>

```typescript
public readonly devContainer: DevContainer;
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.github"></a>

```typescript
public readonly github: GitHub;
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitpod"></a>

```typescript
public readonly gitpod: Gitpod;
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.vscode"></a>

```typescript
public readonly vscode: VsCode;
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### `compile`<sup>Required</sup> <a name="compile" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.compile"></a>

```typescript
public readonly compile: MavenCompile;
```

- *Type:* projen.java.MavenCompile

Compile component.

---

##### `distdir`<sup>Required</sup> <a name="distdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.distdir"></a>

```typescript
public readonly distdir: string;
```

- *Type:* string

Maven artifact output directory.

---

##### `packaging`<sup>Required</sup> <a name="packaging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.packaging"></a>

```typescript
public readonly packaging: MavenPackaging;
```

- *Type:* projen.java.MavenPackaging

Packaging component.

---

##### `pom`<sup>Required</sup> <a name="pom" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.pom"></a>

```typescript
public readonly pom: Pom;
```

- *Type:* projen.java.Pom

API for managing `pom.xml`.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.junit"></a>

```typescript
public readonly junit: Junit;
```

- *Type:* projen.java.Junit

JUnit component.

---

##### `projenrc`<sup>Optional</sup> <a name="projenrc" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projenrc"></a>

```typescript
public readonly projenrc: Projenrc;
```

- *Type:* projen.java.Projenrc

Projenrc component.

---

##### `cdkConfig`<sup>Required</sup> <a name="cdkConfig" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkConfig"></a>

```typescript
public readonly cdkConfig: CdkConfig;
```

- *Type:* projen.awscdk.CdkConfig

The `cdk.json` file.

---

##### `cdkDeps`<sup>Required</sup> <a name="cdkDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkDeps"></a>

```typescript
public readonly cdkDeps: AwsCdkDeps;
```

- *Type:* projen.awscdk.AwsCdkDeps

CDK dependency management helper class.

---

##### `cdkTasks`<sup>Required</sup> <a name="cdkTasks" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkTasks"></a>

```typescript
public readonly cdkTasks: CdkTasks;
```

- *Type:* projen.awscdk.CdkTasks

CDK tasks.

---

##### `mainClass`<sup>Required</sup> <a name="mainClass" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainClass"></a>

```typescript
public readonly mainClass: string;
```

- *Type:* string

The full name of the main class of the java app (package.Class).

---

##### `mainClassName`<sup>Required</sup> <a name="mainClassName" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainClassName"></a>

```typescript
public readonly mainClassName: string;
```

- *Type:* string

The name of the Java class with the static `main()` method.

---

##### `mainPackage`<sup>Required</sup> <a name="mainPackage" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainPackage"></a>

```typescript
public readonly mainPackage: string;
```

- *Type:* string

The name of the Java package that includes the main class.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>string</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.DEFAULT_TASK"></a>

```typescript
public readonly DEFAULT_TASK: string;
```

- *Type:* string

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### PDKPipelinePyProject <a name="PDKPipelinePyProject" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject"></a>

Synthesizes a Python Project with a CI/CD pipeline.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

new pipeline.PDKPipelinePyProject(options: PDKPipelinePyProjectOptions)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.options">options</a></code> | <code>aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions</code> | *No description.* |

---

##### `options`<sup>Required</sup> <a name="options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.options"></a>

- *Type:* aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDependency">addDependency</a></code> | Adds a runtime dependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDevDependency">addDevDependency</a></code> | Adds a dev dependency. |

---

##### `addExcludeFromCleanup` <a name="addExcludeFromCleanup" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addExcludeFromCleanup"></a>

```typescript
public addExcludeFromCleanup(globs: string): void
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* string

The glob patterns to match.

---

##### `addGitIgnore` <a name="addGitIgnore" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addGitIgnore"></a>

```typescript
public addGitIgnore(pattern: string): void
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addGitIgnore.parameter.pattern"></a>

- *Type:* string

The glob pattern to ignore.

---

##### `addPackageIgnore` <a name="addPackageIgnore" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addPackageIgnore"></a>

```typescript
public addPackageIgnore(_pattern: string): void
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* string

The glob pattern to exclude.

---

##### `addTask` <a name="addTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask"></a>

```typescript
public addTask(name: string, props?: TaskOptions): Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.name"></a>

- *Type:* string

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.props"></a>

- *Type:* projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTip"></a>

```typescript
public addTip(message: string): void
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTip.parameter.message"></a>

- *Type:* string

The message.

---

##### `annotateGenerated` <a name="annotateGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.annotateGenerated"></a>

```typescript
public annotateGenerated(glob: string): void
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.annotateGenerated.parameter.glob"></a>

- *Type:* string

the glob pattern to match (could be a file path).

---

##### `postSynthesize` <a name="postSynthesize" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.postSynthesize"></a>

```typescript
public postSynthesize(): void
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `preSynthesize` <a name="preSynthesize" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.preSynthesize"></a>

```typescript
public preSynthesize(): void
```

Called before all components are synthesized.

##### `removeTask` <a name="removeTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.removeTask"></a>

```typescript
public removeTask(name: string): Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.removeTask.parameter.name"></a>

- *Type:* string

The name of the task to remove.

---

##### `runTaskCommand` <a name="runTaskCommand" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.runTaskCommand"></a>

```typescript
public runTaskCommand(task: Task): string
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.synth"></a>

```typescript
public synth(): void
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `tryFindFile` <a name="tryFindFile" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindFile"></a>

```typescript
public tryFindFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindJsonFile"></a>

```typescript
public tryFindJsonFile(filePath: string): JsonFile
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### `tryFindObjectFile` <a name="tryFindObjectFile" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindObjectFile"></a>

```typescript
public tryFindObjectFile(filePath: string): ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### `tryRemoveFile` <a name="tryRemoveFile" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryRemoveFile"></a>

```typescript
public tryRemoveFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `addDependency` <a name="addDependency" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDependency"></a>

```typescript
public addDependency(spec: string): void
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDependency.parameter.spec"></a>

- *Type:* string

Format `<module>@<semver>`.

---

##### `addDevDependency` <a name="addDevDependency" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDevDependency"></a>

```typescript
public addDevDependency(spec: string): void
```

Adds a dev dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDevDependency.parameter.spec"></a>

- *Type:* string

Format `<module>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.buildTask">buildTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.compileTask">compileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.components">components</a></code> | <code>projen.Component[]</code> | Returns all the components within this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.ejected">ejected</a></code> | <code>boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.files">files</a></code> | <code>projen.FileBase[]</code> | All files in this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.name">name</a></code> | <code>string</code> | Project name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.outdir">outdir</a></code> | <code>string</code> | Absolute output directory of this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.packageTask">packageTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.postCompileTask">postCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.preCompileTask">preCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projectBuild">projectBuild</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projenCommand">projenCommand</a></code> | <code>string</code> | The command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.testTask">testTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.defaultTask">defaultTask</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.initProject">initProject</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.autoApprove">autoApprove</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.devContainer">devContainer</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.depsManager">depsManager</a></code> | <code>projen.python.IPythonDeps</code> | API for managing dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.envManager">envManager</a></code> | <code>projen.python.IPythonEnv</code> | API for mangaging the Python runtime environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.moduleName">moduleName</a></code> | <code>string</code> | Python module name (the project name, with any hyphens or periods replaced with underscores). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.version">version</a></code> | <code>string</code> | Version of the package for distribution (should follow semver). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.packagingManager">packagingManager</a></code> | <code>projen.python.IPythonPackaging</code> | API for managing packaging the project as a library. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.pytest">pytest</a></code> | <code>projen.python.Pytest</code> | Pytest component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.appEntrypoint">appEntrypoint</a></code> | <code>string</code> | The CDK app entrypoint. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkConfig">cdkConfig</a></code> | <code>projen.awscdk.CdkConfig</code> | cdk.json configuration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkDeps">cdkDeps</a></code> | <code>projen.awscdk.AwsCdkDeps</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkTasks">cdkTasks</a></code> | <code>projen.awscdk.CdkTasks</code> | Common CDK tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkVersion">cdkVersion</a></code> | <code>string</code> | The CDK version this app is using. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.testdir">testdir</a></code> | <code>string</code> | The directory in which the python tests reside. |

---

##### `buildTask`<sup>Required</sup> <a name="buildTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.buildTask"></a>

```typescript
public readonly buildTask: Task;
```

- *Type:* projen.Task

---

##### `commitGenerated`<sup>Required</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean

Whether to commit the managed files by default.

---

##### `compileTask`<sup>Required</sup> <a name="compileTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.compileTask"></a>

```typescript
public readonly compileTask: Task;
```

- *Type:* projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.components"></a>

```typescript
public readonly components: Component[];
```

- *Type:* projen.Component[]

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.deps"></a>

```typescript
public readonly deps: Dependencies;
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.ejected"></a>

```typescript
public readonly ejected: boolean;
```

- *Type:* boolean

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.files"></a>

```typescript
public readonly files: FileBase[];
```

- *Type:* projen.FileBase[]

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitattributes"></a>

```typescript
public readonly gitattributes: GitAttributesFile;
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitignore"></a>

```typescript
public readonly gitignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.logger"></a>

```typescript
public readonly logger: Logger;
```

- *Type:* projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string

Absolute output directory of this project.

---

##### `packageTask`<sup>Required</sup> <a name="packageTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.packageTask"></a>

```typescript
public readonly packageTask: Task;
```

- *Type:* projen.Task

---

##### `postCompileTask`<sup>Required</sup> <a name="postCompileTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.postCompileTask"></a>

```typescript
public readonly postCompileTask: Task;
```

- *Type:* projen.Task

---

##### `preCompileTask`<sup>Required</sup> <a name="preCompileTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.preCompileTask"></a>

```typescript
public readonly preCompileTask: Task;
```

- *Type:* projen.Task

---

##### `projectBuild`<sup>Required</sup> <a name="projectBuild" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projectBuild"></a>

```typescript
public readonly projectBuild: ProjectBuild;
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### `projenCommand`<sup>Required</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.root"></a>

```typescript
public readonly root: Project;
```

- *Type:* projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.tasks"></a>

```typescript
public readonly tasks: Tasks;
```

- *Type:* projen.Tasks

Project tasks.

---

##### `testTask`<sup>Required</sup> <a name="testTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.testTask"></a>

```typescript
public readonly testTask: Task;
```

- *Type:* projen.Task

---

##### `defaultTask`<sup>Optional</sup> <a name="defaultTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.defaultTask"></a>

```typescript
public readonly defaultTask: Task;
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `initProject`<sup>Optional</sup> <a name="initProject" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.initProject"></a>

```typescript
public readonly initProject: InitProject;
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### `projectType`<sup>Required</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projectType"></a>

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType

---

##### `autoApprove`<sup>Optional</sup> <a name="autoApprove" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.autoApprove"></a>

```typescript
public readonly autoApprove: AutoApprove;
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.devContainer"></a>

```typescript
public readonly devContainer: DevContainer;
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.github"></a>

```typescript
public readonly github: GitHub;
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitpod"></a>

```typescript
public readonly gitpod: Gitpod;
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.vscode"></a>

```typescript
public readonly vscode: VsCode;
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### `depsManager`<sup>Required</sup> <a name="depsManager" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.depsManager"></a>

```typescript
public readonly depsManager: IPythonDeps;
```

- *Type:* projen.python.IPythonDeps

API for managing dependencies.

---

##### `envManager`<sup>Required</sup> <a name="envManager" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.envManager"></a>

```typescript
public readonly envManager: IPythonEnv;
```

- *Type:* projen.python.IPythonEnv

API for mangaging the Python runtime environment.

---

##### `moduleName`<sup>Required</sup> <a name="moduleName" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.moduleName"></a>

```typescript
public readonly moduleName: string;
```

- *Type:* string

Python module name (the project name, with any hyphens or periods replaced with underscores).

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.version"></a>

```typescript
public readonly version: string;
```

- *Type:* string

Version of the package for distribution (should follow semver).

---

##### `packagingManager`<sup>Optional</sup> <a name="packagingManager" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.packagingManager"></a>

```typescript
public readonly packagingManager: IPythonPackaging;
```

- *Type:* projen.python.IPythonPackaging

API for managing packaging the project as a library.

Only applies when the `projectType` is LIB.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.pytest"></a>

```typescript
public readonly pytest: Pytest;
```

- *Type:* projen.python.Pytest

Pytest component.

---

##### `appEntrypoint`<sup>Required</sup> <a name="appEntrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.appEntrypoint"></a>

```typescript
public readonly appEntrypoint: string;
```

- *Type:* string

The CDK app entrypoint.

---

##### `cdkConfig`<sup>Required</sup> <a name="cdkConfig" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkConfig"></a>

```typescript
public readonly cdkConfig: CdkConfig;
```

- *Type:* projen.awscdk.CdkConfig

cdk.json configuration.

---

##### `cdkDeps`<sup>Required</sup> <a name="cdkDeps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkDeps"></a>

```typescript
public readonly cdkDeps: AwsCdkDeps;
```

- *Type:* projen.awscdk.AwsCdkDeps

---

##### `cdkTasks`<sup>Required</sup> <a name="cdkTasks" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkTasks"></a>

```typescript
public readonly cdkTasks: CdkTasks;
```

- *Type:* projen.awscdk.CdkTasks

Common CDK tasks.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkVersion"></a>

```typescript
public readonly cdkVersion: string;
```

- *Type:* string

The CDK version this app is using.

---

##### `testdir`<sup>Required</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.testdir"></a>

```typescript
public readonly testdir: string;
```

- *Type:* string

The directory in which the python tests reside.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>string</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.DEFAULT_TASK"></a>

```typescript
public readonly DEFAULT_TASK: string;
```

- *Type:* string

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### PDKPipelineTsProject <a name="PDKPipelineTsProject" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject"></a>

Synthesizes a Typescript Project with a CI/CD pipeline.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer"></a>

```typescript
import { pipeline } from 'aws-prototyping-sdk'

new pipeline.PDKPipelineTsProject(options: PDKPipelineTsProjectOptions)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.options">options</a></code> | <code>aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions</code> | *No description.* |

---

##### `options`<sup>Required</sup> <a name="options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.options"></a>

- *Type:* aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBins">addBins</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBundledDeps">addBundledDeps</a></code> | Defines bundled dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCompileCommand">addCompileCommand</a></code> | DEPRECATED. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDeps">addDeps</a></code> | Defines normal dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDevDeps">addDevDeps</a></code> | Defines development/test dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addFields">addFields</a></code> | Directly set fields in `package.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addKeywords">addKeywords</a></code> | Adds keywords to package.json (deduplicated). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPeerDeps">addPeerDeps</a></code> | Defines peer dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addScripts">addScripts</a></code> | Replaces the contents of multiple npm package.json scripts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTestCommand">addTestCommand</a></code> | DEPRECATED. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.hasScript">hasScript</a></code> | Indicates if a script by the name name is defined. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeScript">removeScript</a></code> | Removes the npm script (always successful). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.renderWorkflowSetup">renderWorkflowSetup</a></code> | Returns the set of workflow steps which should be executed to bootstrap a workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.setScript">setScript</a></code> | Replaces the contents of an npm package.json script. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCdkDependency">addCdkDependency</a></code> | Adds an AWS CDK module dependencies. |

---

##### `addExcludeFromCleanup` <a name="addExcludeFromCleanup" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addExcludeFromCleanup"></a>

```typescript
public addExcludeFromCleanup(globs: string): void
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* string

The glob patterns to match.

---

##### `addGitIgnore` <a name="addGitIgnore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addGitIgnore"></a>

```typescript
public addGitIgnore(pattern: string): void
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addGitIgnore.parameter.pattern"></a>

- *Type:* string

The glob pattern to ignore.

---

##### `addPackageIgnore` <a name="addPackageIgnore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPackageIgnore"></a>

```typescript
public addPackageIgnore(pattern: string): void
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPackageIgnore.parameter.pattern"></a>

- *Type:* string

---

##### `addTask` <a name="addTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask"></a>

```typescript
public addTask(name: string, props?: TaskOptions): Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.name"></a>

- *Type:* string

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.props"></a>

- *Type:* projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTip"></a>

```typescript
public addTip(message: string): void
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTip.parameter.message"></a>

- *Type:* string

The message.

---

##### `annotateGenerated` <a name="annotateGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.annotateGenerated"></a>

```typescript
public annotateGenerated(glob: string): void
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.annotateGenerated.parameter.glob"></a>

- *Type:* string

the glob pattern to match (could be a file path).

---

##### `postSynthesize` <a name="postSynthesize" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.postSynthesize"></a>

```typescript
public postSynthesize(): void
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `preSynthesize` <a name="preSynthesize" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.preSynthesize"></a>

```typescript
public preSynthesize(): void
```

Called before all components are synthesized.

##### `removeTask` <a name="removeTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeTask"></a>

```typescript
public removeTask(name: string): Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeTask.parameter.name"></a>

- *Type:* string

The name of the task to remove.

---

##### `runTaskCommand` <a name="runTaskCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.runTaskCommand"></a>

```typescript
public runTaskCommand(task: Task): string
```

Returns the shell command to execute in order to run a task.

This will
typically be `npx projen TASK`.

###### `task`<sup>Required</sup> <a name="task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.synth"></a>

```typescript
public synth(): void
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `tryFindFile` <a name="tryFindFile" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindFile"></a>

```typescript
public tryFindFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindJsonFile"></a>

```typescript
public tryFindJsonFile(filePath: string): JsonFile
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### `tryFindObjectFile` <a name="tryFindObjectFile" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindObjectFile"></a>

```typescript
public tryFindObjectFile(filePath: string): ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### `tryRemoveFile` <a name="tryRemoveFile" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryRemoveFile"></a>

```typescript
public tryRemoveFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `addBins` <a name="addBins" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBins"></a>

```typescript
public addBins(bins: {[ key: string ]: string}): void
```

###### `bins`<sup>Required</sup> <a name="bins" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBins.parameter.bins"></a>

- *Type:* {[ key: string ]: string}

---

##### `addBundledDeps` <a name="addBundledDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBundledDeps"></a>

```typescript
public addBundledDeps(deps: string): void
```

Defines bundled dependencies.

Bundled dependencies will be added as normal dependencies as well as to the
`bundledDependencies` section of your `package.json`.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBundledDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addCompileCommand`~~ <a name="addCompileCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCompileCommand"></a>

```typescript
public addCompileCommand(commands: string): void
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCompileCommand.parameter.commands"></a>

- *Type:* string

---

##### `addDeps` <a name="addDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDeps"></a>

```typescript
public addDeps(deps: string): void
```

Defines normal dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `addDevDeps` <a name="addDevDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDevDeps"></a>

```typescript
public addDevDeps(deps: string): void
```

Defines development/test dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDevDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `addFields` <a name="addFields" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addFields"></a>

```typescript
public addFields(fields: {[ key: string ]: any}): void
```

Directly set fields in `package.json`.

###### `fields`<sup>Required</sup> <a name="fields" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addFields.parameter.fields"></a>

- *Type:* {[ key: string ]: any}

The fields to set.

---

##### `addKeywords` <a name="addKeywords" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addKeywords"></a>

```typescript
public addKeywords(keywords: string): void
```

Adds keywords to package.json (deduplicated).

###### `keywords`<sup>Required</sup> <a name="keywords" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addKeywords.parameter.keywords"></a>

- *Type:* string

The keywords to add.

---

##### `addPeerDeps` <a name="addPeerDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPeerDeps"></a>

```typescript
public addPeerDeps(deps: string): void
```

Defines peer dependencies.

When adding peer dependencies, a devDependency will also be added on the
pinned version of the declared peer. This will ensure that you are testing
your code against the minimum version required from your consumers.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPeerDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `addScripts` <a name="addScripts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addScripts"></a>

```typescript
public addScripts(scripts: {[ key: string ]: string}): void
```

Replaces the contents of multiple npm package.json scripts.

###### `scripts`<sup>Required</sup> <a name="scripts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addScripts.parameter.scripts"></a>

- *Type:* {[ key: string ]: string}

The scripts to set.

---

##### ~~`addTestCommand`~~ <a name="addTestCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTestCommand"></a>

```typescript
public addTestCommand(commands: string): void
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTestCommand.parameter.commands"></a>

- *Type:* string

---

##### ~~`hasScript`~~ <a name="hasScript" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.hasScript"></a>

```typescript
public hasScript(name: string): boolean
```

Indicates if a script by the name name is defined.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.hasScript.parameter.name"></a>

- *Type:* string

The name of the script.

---

##### `removeScript` <a name="removeScript" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeScript"></a>

```typescript
public removeScript(name: string): void
```

Removes the npm script (always successful).

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeScript.parameter.name"></a>

- *Type:* string

The name of the script.

---

##### `renderWorkflowSetup` <a name="renderWorkflowSetup" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.renderWorkflowSetup"></a>

```typescript
public renderWorkflowSetup(options?: RenderWorkflowSetupOptions): JobStep[]
```

Returns the set of workflow steps which should be executed to bootstrap a workflow.

###### `options`<sup>Optional</sup> <a name="options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.renderWorkflowSetup.parameter.options"></a>

- *Type:* projen.javascript.RenderWorkflowSetupOptions

Options.

---

##### `setScript` <a name="setScript" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.setScript"></a>

```typescript
public setScript(name: string, command: string): void
```

Replaces the contents of an npm package.json script.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.setScript.parameter.name"></a>

- *Type:* string

The script name.

---

###### `command`<sup>Required</sup> <a name="command" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.setScript.parameter.command"></a>

- *Type:* string

The command to execute.

---

##### `addCdkDependency` <a name="addCdkDependency" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCdkDependency"></a>

```typescript
public addCdkDependency(modules: string): void
```

Adds an AWS CDK module dependencies.

###### `modules`<sup>Required</sup> <a name="modules" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCdkDependency.parameter.modules"></a>

- *Type:* string

The list of modules to depend on.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildTask">buildTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.compileTask">compileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.components">components</a></code> | <code>projen.Component[]</code> | Returns all the components within this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.ejected">ejected</a></code> | <code>boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.files">files</a></code> | <code>projen.FileBase[]</code> | All files in this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.name">name</a></code> | <code>string</code> | Project name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.outdir">outdir</a></code> | <code>string</code> | Absolute output directory of this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.packageTask">packageTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.postCompileTask">postCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.preCompileTask">preCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projectBuild">projectBuild</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projenCommand">projenCommand</a></code> | <code>string</code> | The command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.testTask">testTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.defaultTask">defaultTask</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.initProject">initProject</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.autoApprove">autoApprove</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.devContainer">devContainer</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.artifactsDirectory">artifactsDirectory</a></code> | <code>string</code> | The build output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.artifactsJavascriptDirectory">artifactsJavascriptDirectory</a></code> | <code>string</code> | The location of the npm tarball after build (`${artifactsDirectory}/js`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.bundler">bundler</a></code> | <code>projen.javascript.Bundler</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.entrypoint">entrypoint</a></code> | <code>string</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.manifest">manifest</a></code> | <code>any</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.npmrc">npmrc</a></code> | <code>projen.javascript.NpmConfig</code> | The .npmrc file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.package">package</a></code> | <code>projen.javascript.NodePackage</code> | API for managing the node package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.packageManager">packageManager</a></code> | <code>projen.javascript.NodePackageManager</code> | The package manager to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.runScriptCommand">runScriptCommand</a></code> | <code>string</code> | The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.autoMerge">autoMerge</a></code> | <code>projen.github.AutoMerge</code> | Component that sets up mergify for merging approved pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildWorkflow">buildWorkflow</a></code> | <code>projen.build.BuildWorkflow</code> | The PR build GitHub workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildWorkflowJobId">buildWorkflowJobId</a></code> | <code>string</code> | The job ID of the build workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.jest">jest</a></code> | <code>projen.javascript.Jest</code> | The Jest configuration (if enabled). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.maxNodeVersion">maxNodeVersion</a></code> | <code>string</code> | Maximum node version required by this package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.minNodeVersion">minNodeVersion</a></code> | <code>string</code> | Minimum node.js version required by this package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.npmignore">npmignore</a></code> | <code>projen.IgnoreFile</code> | The .npmignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.prettier">prettier</a></code> | <code>projen.javascript.Prettier</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.publisher">publisher</a></code> | <code>projen.release.Publisher</code> | Package publisher. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.release">release</a></code> | <code>projen.release.Release</code> | Release management. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.upgradeWorkflow">upgradeWorkflow</a></code> | <code>projen.javascript.UpgradeDependencies</code> | The upgrade workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.docsDirectory">docsDirectory</a></code> | <code>string</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.libdir">libdir</a></code> | <code>string</code> | The directory in which compiled .js files reside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.srcdir">srcdir</a></code> | <code>string</code> | The directory in which the .ts sources reside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.testdir">testdir</a></code> | <code>string</code> | The directory in which tests reside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfigDev">tsconfigDev</a></code> | <code>projen.javascript.TypescriptConfig</code> | A typescript configuration file which covers all files (sources, tests, projen). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.watchTask">watchTask</a></code> | <code>projen.Task</code> | The "watch" task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.docgen">docgen</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.eslint">eslint</a></code> | <code>projen.javascript.Eslint</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfigEslint">tsconfigEslint</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.appEntrypoint">appEntrypoint</a></code> | <code>string</code> | The CDK app entrypoint. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkConfig">cdkConfig</a></code> | <code>projen.awscdk.CdkConfig</code> | cdk.json configuration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkDeps">cdkDeps</a></code> | <code>projen.awscdk.AwsCdkDeps</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkTasks">cdkTasks</a></code> | <code>projen.awscdk.CdkTasks</code> | Common CDK tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkVersion">cdkVersion</a></code> | <code>string</code> | The CDK version this app is using. |

---

##### `buildTask`<sup>Required</sup> <a name="buildTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildTask"></a>

```typescript
public readonly buildTask: Task;
```

- *Type:* projen.Task

---

##### `commitGenerated`<sup>Required</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean

Whether to commit the managed files by default.

---

##### `compileTask`<sup>Required</sup> <a name="compileTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.compileTask"></a>

```typescript
public readonly compileTask: Task;
```

- *Type:* projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.components"></a>

```typescript
public readonly components: Component[];
```

- *Type:* projen.Component[]

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.deps"></a>

```typescript
public readonly deps: Dependencies;
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.ejected"></a>

```typescript
public readonly ejected: boolean;
```

- *Type:* boolean

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.files"></a>

```typescript
public readonly files: FileBase[];
```

- *Type:* projen.FileBase[]

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitattributes"></a>

```typescript
public readonly gitattributes: GitAttributesFile;
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitignore"></a>

```typescript
public readonly gitignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.logger"></a>

```typescript
public readonly logger: Logger;
```

- *Type:* projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string

Absolute output directory of this project.

---

##### `packageTask`<sup>Required</sup> <a name="packageTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.packageTask"></a>

```typescript
public readonly packageTask: Task;
```

- *Type:* projen.Task

---

##### `postCompileTask`<sup>Required</sup> <a name="postCompileTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.postCompileTask"></a>

```typescript
public readonly postCompileTask: Task;
```

- *Type:* projen.Task

---

##### `preCompileTask`<sup>Required</sup> <a name="preCompileTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.preCompileTask"></a>

```typescript
public readonly preCompileTask: Task;
```

- *Type:* projen.Task

---

##### `projectBuild`<sup>Required</sup> <a name="projectBuild" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projectBuild"></a>

```typescript
public readonly projectBuild: ProjectBuild;
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### `projenCommand`<sup>Required</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.root"></a>

```typescript
public readonly root: Project;
```

- *Type:* projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tasks"></a>

```typescript
public readonly tasks: Tasks;
```

- *Type:* projen.Tasks

Project tasks.

---

##### `testTask`<sup>Required</sup> <a name="testTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.testTask"></a>

```typescript
public readonly testTask: Task;
```

- *Type:* projen.Task

---

##### `defaultTask`<sup>Optional</sup> <a name="defaultTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.defaultTask"></a>

```typescript
public readonly defaultTask: Task;
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `initProject`<sup>Optional</sup> <a name="initProject" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.initProject"></a>

```typescript
public readonly initProject: InitProject;
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### `projectType`<sup>Required</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projectType"></a>

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType

---

##### `autoApprove`<sup>Optional</sup> <a name="autoApprove" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.autoApprove"></a>

```typescript
public readonly autoApprove: AutoApprove;
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.devContainer"></a>

```typescript
public readonly devContainer: DevContainer;
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.github"></a>

```typescript
public readonly github: GitHub;
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitpod"></a>

```typescript
public readonly gitpod: Gitpod;
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.vscode"></a>

```typescript
public readonly vscode: VsCode;
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`allowLibraryDependencies`~~<sup>Required</sup> <a name="allowLibraryDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.allowLibraryDependencies"></a>

- *Deprecated:* use `package.allowLibraryDependencies`

```typescript
public readonly allowLibraryDependencies: boolean;
```

- *Type:* boolean

---

##### `artifactsDirectory`<sup>Required</sup> <a name="artifactsDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.artifactsDirectory"></a>

```typescript
public readonly artifactsDirectory: string;
```

- *Type:* string

The build output directory.

An npm tarball will be created under the `js`
subdirectory. For example, if this is set to `dist` (the default), the npm
tarball will be placed under `dist/js/boom-boom-1.2.3.tg`.

---

##### `artifactsJavascriptDirectory`<sup>Required</sup> <a name="artifactsJavascriptDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.artifactsJavascriptDirectory"></a>

```typescript
public readonly artifactsJavascriptDirectory: string;
```

- *Type:* string

The location of the npm tarball after build (`${artifactsDirectory}/js`).

---

##### `bundler`<sup>Required</sup> <a name="bundler" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.bundler"></a>

```typescript
public readonly bundler: Bundler;
```

- *Type:* projen.javascript.Bundler

---

##### ~~`entrypoint`~~<sup>Required</sup> <a name="entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.entrypoint"></a>

- *Deprecated:* use `package.entrypoint`

```typescript
public readonly entrypoint: string;
```

- *Type:* string

---

##### ~~`manifest`~~<sup>Required</sup> <a name="manifest" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.manifest"></a>

- *Deprecated:* use `package.addField(x, y)`

```typescript
public readonly manifest: any;
```

- *Type:* any

---

##### `npmrc`<sup>Required</sup> <a name="npmrc" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.npmrc"></a>

```typescript
public readonly npmrc: NpmConfig;
```

- *Type:* projen.javascript.NpmConfig

The .npmrc file.

---

##### `package`<sup>Required</sup> <a name="package" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.package"></a>

```typescript
public readonly package: NodePackage;
```

- *Type:* projen.javascript.NodePackage

API for managing the node package.

---

##### ~~`packageManager`~~<sup>Required</sup> <a name="packageManager" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.packageManager"></a>

- *Deprecated:* use `package.packageManager`

```typescript
public readonly packageManager: NodePackageManager;
```

- *Type:* projen.javascript.NodePackageManager

The package manager to use.

---

##### `runScriptCommand`<sup>Required</sup> <a name="runScriptCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.runScriptCommand"></a>

```typescript
public readonly runScriptCommand: string;
```

- *Type:* string

The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager).

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.autoMerge"></a>

```typescript
public readonly autoMerge: AutoMerge;
```

- *Type:* projen.github.AutoMerge

Component that sets up mergify for merging approved pull requests.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildWorkflow"></a>

```typescript
public readonly buildWorkflow: BuildWorkflow;
```

- *Type:* projen.build.BuildWorkflow

The PR build GitHub workflow.

`undefined` if `buildWorkflow` is disabled.

---

##### `buildWorkflowJobId`<sup>Optional</sup> <a name="buildWorkflowJobId" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildWorkflowJobId"></a>

```typescript
public readonly buildWorkflowJobId: string;
```

- *Type:* string

The job ID of the build workflow.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.jest"></a>

```typescript
public readonly jest: Jest;
```

- *Type:* projen.javascript.Jest

The Jest configuration (if enabled).

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.maxNodeVersion"></a>

```typescript
public readonly maxNodeVersion: string;
```

- *Type:* string

Maximum node version required by this package.

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.minNodeVersion"></a>

```typescript
public readonly minNodeVersion: string;
```

- *Type:* string

Minimum node.js version required by this package.

---

##### `npmignore`<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.npmignore"></a>

```typescript
public readonly npmignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

The .npmignore file.

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.prettier"></a>

```typescript
public readonly prettier: Prettier;
```

- *Type:* projen.javascript.Prettier

---

##### ~~`publisher`~~<sup>Optional</sup> <a name="publisher" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.publisher"></a>

- *Deprecated:* use `release.publisher`.

```typescript
public readonly publisher: Publisher;
```

- *Type:* projen.release.Publisher

Package publisher.

This will be `undefined` if the project does not have a
release workflow.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.release"></a>

```typescript
public readonly release: Release;
```

- *Type:* projen.release.Release

Release management.

---

##### `upgradeWorkflow`<sup>Optional</sup> <a name="upgradeWorkflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.upgradeWorkflow"></a>

```typescript
public readonly upgradeWorkflow: UpgradeDependencies;
```

- *Type:* projen.javascript.UpgradeDependencies

The upgrade workflow.

---

##### `docsDirectory`<sup>Required</sup> <a name="docsDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.docsDirectory"></a>

```typescript
public readonly docsDirectory: string;
```

- *Type:* string

---

##### `libdir`<sup>Required</sup> <a name="libdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.libdir"></a>

```typescript
public readonly libdir: string;
```

- *Type:* string

The directory in which compiled .js files reside.

---

##### `srcdir`<sup>Required</sup> <a name="srcdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.srcdir"></a>

```typescript
public readonly srcdir: string;
```

- *Type:* string

The directory in which the .ts sources reside.

---

##### `testdir`<sup>Required</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.testdir"></a>

```typescript
public readonly testdir: string;
```

- *Type:* string

The directory in which tests reside.

---

##### `tsconfigDev`<sup>Required</sup> <a name="tsconfigDev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfigDev"></a>

```typescript
public readonly tsconfigDev: TypescriptConfig;
```

- *Type:* projen.javascript.TypescriptConfig

A typescript configuration file which covers all files (sources, tests, projen).

---

##### `watchTask`<sup>Required</sup> <a name="watchTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.watchTask"></a>

```typescript
public readonly watchTask: Task;
```

- *Type:* projen.Task

The "watch" task.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.docgen"></a>

```typescript
public readonly docgen: boolean;
```

- *Type:* boolean

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.eslint"></a>

```typescript
public readonly eslint: Eslint;
```

- *Type:* projen.javascript.Eslint

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfig"></a>

```typescript
public readonly tsconfig: TypescriptConfig;
```

- *Type:* projen.javascript.TypescriptConfig

---

##### `tsconfigEslint`<sup>Optional</sup> <a name="tsconfigEslint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfigEslint"></a>

```typescript
public readonly tsconfigEslint: TypescriptConfig;
```

- *Type:* projen.javascript.TypescriptConfig

---

##### `appEntrypoint`<sup>Required</sup> <a name="appEntrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.appEntrypoint"></a>

```typescript
public readonly appEntrypoint: string;
```

- *Type:* string

The CDK app entrypoint.

---

##### `cdkConfig`<sup>Required</sup> <a name="cdkConfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkConfig"></a>

```typescript
public readonly cdkConfig: CdkConfig;
```

- *Type:* projen.awscdk.CdkConfig

cdk.json configuration.

---

##### `cdkDeps`<sup>Required</sup> <a name="cdkDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkDeps"></a>

```typescript
public readonly cdkDeps: AwsCdkDeps;
```

- *Type:* projen.awscdk.AwsCdkDeps

---

##### `cdkTasks`<sup>Required</sup> <a name="cdkTasks" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkTasks"></a>

```typescript
public readonly cdkTasks: CdkTasks;
```

- *Type:* projen.awscdk.CdkTasks

Common CDK tasks.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkVersion"></a>

```typescript
public readonly cdkVersion: string;
```

- *Type:* string

The CDK version this app is using.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>string</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.DEFAULT_TASK"></a>

```typescript
public readonly DEFAULT_TASK: string;
```

- *Type:* string

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---


