> **DEPRECATION NOTICE:** The `aws-prototyping-sdk` is on path to deprecation. This package is simply a wrapper around the individual `@aws-prototyping-skd/*` packages and has no unique code aside from bundling the other packages. Due to lack of significant value compared to maintenance overhead, this package will be deprecated soon in favor of using the individual packages directly. Please use the individual packages starting now to prevent future migration and loss of update capabilities.

The aws-prototyping-sdk provides stable CDK and Projen constructs, allowing developers to have access to higher level abstractions than provided by the CDK or Projen alone.

For detailed documentation, please refer to the [documentation website](https://aws.github.io/aws-prototyping-sdk/).

## Bundling

This package simply bundles various packages from the `@aws-prototyping-sdk` namespace which have been marked as `stable`. As such, not all constructs or classes may be exported from this package and will need to be explicitly imported by creating a dependency on the individual packages.

To illustrate, at the time of writing the following individual packages are published:

```
@aws-prototyping-sdk
        |_ pipeline       : [stable]
        |_ nx-monorepo    : [stable]
        |_ static-website : [experimental]
        |_ identity       : [experimental]
```

The aws-prototyping-sdk package will bundle all stable packages and export them as namespaces as follows:

```
aws-prototyping-sdk
        |_ pipeline
        |_ nx_monorepo
```

This means if you wanted to access the PDKPipeline which is a stable construct, you simply add a dependency on the `aws-prototyping-sdk` and import it as follows:

```python
# Example automatically generated from non-compiling source. May contain errors.
from aws_prototyping_sdk import nx_monorepo, pipeline
```

To import `experimental` constructs, a dependency on the individual package is required. In the case of `static-website`, a dependency on `@aws-prototyping-sdk/static-website` is required. The constructs can then be imported as follows:

```python
# Example automatically generated from non-compiling source. May contain errors.
from aws_prototyping_sdk.static_website import StaticWebsite
```
# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### PDKNagApp <a name="PDKNagApp" id="aws-prototyping-sdk.pdk_nag.PDKNagApp"></a>

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNagApp(
  analytics_reporting: bool = None,
  auto_synth: bool = None,
  context: typing.Mapping[typing.Any] = None,
  default_stack_synthesizer: IReusableStackSynthesizer = None,
  outdir: str = None,
  post_cli_context: typing.Mapping[typing.Any] = None,
  stack_traces: bool = None,
  tree_metadata: bool = None,
  fail_on_error: bool = None,
  fail_on_warning: bool = None,
  nag_packs: typing.List[NagPack] = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.analyticsReporting">analytics_reporting</a></code> | <code>bool</code> | Include runtime versioning information in the Stacks of this app. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.autoSynth">auto_synth</a></code> | <code>bool</code> | Automatically call `synth()` before the program exits. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.context">context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context values for the application. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.defaultStackSynthesizer">default_stack_synthesizer</a></code> | <code>aws_cdk.IReusableStackSynthesizer</code> | The stack synthesizer to use by default for all Stacks in the App. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The output directory into which to emit synthesized artifacts. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.postCliContext">post_cli_context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context values for the application. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.stackTraces">stack_traces</a></code> | <code>bool</code> | Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.treeMetadata">tree_metadata</a></code> | <code>bool</code> | Include construct tree metadata as part of the Cloud Assembly. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.failOnError">fail_on_error</a></code> | <code>bool</code> | Determines whether any errors encountered should trigger a test failure. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.failOnWarning">fail_on_warning</a></code> | <code>bool</code> | Determines whether any warnings encountered should trigger a test failure. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.nagPacks">nag_packs</a></code> | <code>typing.List[cdk_nag.NagPack]</code> | Custom nag packs to execute. |

---

##### `analytics_reporting`<sup>Optional</sup> <a name="analytics_reporting" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.analyticsReporting"></a>

- *Type:* bool
- *Default:* Value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in the Stacks of this app.

---

##### `auto_synth`<sup>Optional</sup> <a name="auto_synth" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.autoSynth"></a>

- *Type:* bool
- *Default:* true if running via CDK CLI (`CDK_OUTDIR` is set), `false` otherwise

Automatically call `synth()` before the program exits.

If you set this, you don't have to call `synth()` explicitly. Note that
this feature is only available for certain programming languages, and
calling `synth()` is still recommended.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.context"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context values for the application.

Context set by the CLI or the `context` key in `cdk.json` has precedence.

Context can be read from any construct using `node.getContext(key)`.

---

##### `default_stack_synthesizer`<sup>Optional</sup> <a name="default_stack_synthesizer" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.defaultStackSynthesizer"></a>

- *Type:* aws_cdk.IReusableStackSynthesizer
- *Default:* A `DefaultStackSynthesizer` with default settings

The stack synthesizer to use by default for all Stacks in the App.

The Stack Synthesizer controls aspects of synthesis and deployment,
like how assets are referenced and what IAM roles to use. For more
information, see the README of the main CDK package.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.outdir"></a>

- *Type:* str
- *Default:* If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.   If `CDK_OUTDIR` is not defined, uses a temp directory.

The output directory into which to emit synthesized artifacts.

You should never need to set this value. By default, the value you pass to
the CLI's `--output` flag will be used, and if you change it to a different
directory the CLI will fail to pick up the generated Cloud Assembly.

This property is intended for internal and testing use.

---

##### `post_cli_context`<sup>Optional</sup> <a name="post_cli_context" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.postCliContext"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context values for the application.

Context provided here has precedence over context set by:

- The CLI via --context
- The `context` key in `cdk.json`
- The `AppProps.context` property

This property is recommended over the `AppProps.context` property since you
can make final decision over which context value to take in your app.

Context can be read from any construct using `node.getContext(key)`.

---

*Example*

```python
// context from the CLI and from `cdk.json` are stored in the
// CDK_CONTEXT env variable
const cliContext = JSON.parse(process.env.CDK_CONTEXT!);

// determine whether to take the context passed in the CLI or not
const determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
new App({
  postCliContext: {
    SOMEKEY: determineValue,
  },
});
```


##### `stack_traces`<sup>Optional</sup> <a name="stack_traces" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.stackTraces"></a>

- *Type:* bool
- *Default:* true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.

Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.

---

##### `tree_metadata`<sup>Optional</sup> <a name="tree_metadata" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.treeMetadata"></a>

- *Type:* bool
- *Default:* true

Include construct tree metadata as part of the Cloud Assembly.

---

##### `fail_on_error`<sup>Optional</sup> <a name="fail_on_error" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.failOnError"></a>

- *Type:* bool
- *Default:* false

Determines whether any errors encountered should trigger a test failure.

---

##### `fail_on_warning`<sup>Optional</sup> <a name="fail_on_warning" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.failOnWarning"></a>

- *Type:* bool
- *Default:* false

Determines whether any warnings encountered should trigger a test failure.

---

##### `nag_packs`<sup>Optional</sup> <a name="nag_packs" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.nagPacks"></a>

- *Type:* typing.List[cdk_nag.NagPack]
- *Default:* DEFAULT_NAG_PACKS

Custom nag packs to execute.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.synth">synth</a></code> | Synthesize this stage into a cloud assembly. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.addNagResult">add_nag_result</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.nagResults">nag_results</a></code> | Returns a list of NagResult. |

---

##### `to_string` <a name="to_string" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `synth` <a name="synth" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.synth"></a>

```python
def synth(
  force: bool = None,
  skip_validation: bool = None,
  validate_on_synthesis: bool = None
) -> CloudAssembly
```

Synthesize this stage into a cloud assembly.

Once an assembly has been synthesized, it cannot be modified. Subsequent
calls will return the same assembly.

###### `force`<sup>Optional</sup> <a name="force" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.synth.parameter.force"></a>

- *Type:* bool
- *Default:* false

Force a re-synth, even if the stage has already been synthesized.

This is used by tests to allow for incremental verification of the output.
Do not use in production.

---

###### `skip_validation`<sup>Optional</sup> <a name="skip_validation" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.synth.parameter.skipValidation"></a>

- *Type:* bool
- *Default:* false

Should we skip construct validation.

---

###### `validate_on_synthesis`<sup>Optional</sup> <a name="validate_on_synthesis" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.synth.parameter.validateOnSynthesis"></a>

- *Type:* bool
- *Default:* false

Whether the stack should be validated after synthesis to check for error metadata.

---

##### `add_nag_result` <a name="add_nag_result" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.addNagResult"></a>

```python
def add_nag_result(
  messages: typing.List[Message],
  resource: str
) -> None
```

###### `messages`<sup>Required</sup> <a name="messages" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.addNagResult.parameter.messages"></a>

- *Type:* typing.List[aws_prototyping_sdk.pdk_nag.Message]

List of messages.

---

###### `resource`<sup>Required</sup> <a name="resource" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.addNagResult.parameter.resource"></a>

- *Type:* str

Resource which triggered the message.

---

##### `nag_results` <a name="nag_results" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.nagResults"></a>

```python
def nag_results() -> typing.List[NagResult]
```

Returns a list of NagResult.

Note: app.synth() must be called before this to retrieve results.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.isStage">is_stage</a></code> | Test whether the given construct is a stage. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.of">of</a></code> | Return the stage this construct is contained with, if available. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.isApp">is_app</a></code> | Checks if an object is an instance of the `App` class. |

---

##### `is_construct` <a name="is_construct" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isConstruct"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNagApp.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

##### `is_stage` <a name="is_stage" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isStage"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNagApp.is_stage(
  x: typing.Any
)
```

Test whether the given construct is a stage.

###### `x`<sup>Required</sup> <a name="x" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isStage.parameter.x"></a>

- *Type:* typing.Any

---

##### `of` <a name="of" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.of"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNagApp.of(
  construct: IConstruct
)
```

Return the stage this construct is contained with, if available.

If called
on a nested stage, returns its parent.

###### `construct`<sup>Required</sup> <a name="construct" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.of.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `is_app` <a name="is_app" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isApp"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNagApp.is_app(
  obj: typing.Any
)
```

Checks if an object is an instance of the `App` class.

###### `obj`<sup>Required</sup> <a name="obj" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isApp.parameter.obj"></a>

- *Type:* typing.Any

The object to evaluate.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.artifactId">artifact_id</a></code> | <code>str</code> | Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.assetOutdir">asset_outdir</a></code> | <code>str</code> | The cloud assembly asset output directory. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.outdir">outdir</a></code> | <code>str</code> | The cloud assembly output directory. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.stageName">stage_name</a></code> | <code>str</code> | The name of the stage. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.account">account</a></code> | <code>str</code> | The default account for all resources defined within this stage. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.parentStage">parent_stage</a></code> | <code>aws_cdk.Stage</code> | The parent stage or `undefined` if this is the app. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.region">region</a></code> | <code>str</code> | The default region for all resources defined within this stage. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.nagPacks">nag_packs</a></code> | <code>typing.List[cdk_nag.NagPack]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `artifact_id`<sup>Required</sup> <a name="artifact_id" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.artifactId"></a>

```python
artifact_id: str
```

- *Type:* str

Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string.

Derived from the construct path.

---

##### `asset_outdir`<sup>Required</sup> <a name="asset_outdir" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.assetOutdir"></a>

```python
asset_outdir: str
```

- *Type:* str

The cloud assembly asset output directory.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.outdir"></a>

```python
outdir: str
```

- *Type:* str

The cloud assembly output directory.

---

##### `stage_name`<sup>Required</sup> <a name="stage_name" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.stageName"></a>

```python
stage_name: str
```

- *Type:* str

The name of the stage.

Based on names of the parent stages separated by
hypens.

---

##### `account`<sup>Optional</sup> <a name="account" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.account"></a>

```python
account: str
```

- *Type:* str

The default account for all resources defined within this stage.

---

##### `parent_stage`<sup>Optional</sup> <a name="parent_stage" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.parentStage"></a>

```python
parent_stage: Stage
```

- *Type:* aws_cdk.Stage

The parent stage or `undefined` if this is the app.

*

---

##### `region`<sup>Optional</sup> <a name="region" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.region"></a>

```python
region: str
```

- *Type:* str

The default region for all resources defined within this stage.

---

##### `nag_packs`<sup>Required</sup> <a name="nag_packs" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.nagPacks"></a>

```python
nag_packs: typing.List[NagPack]
```

- *Type:* typing.List[cdk_nag.NagPack]

---


### PDKPipeline <a name="PDKPipeline" id="aws-prototyping-sdk.pipeline.PDKPipeline"></a>

An extension to CodePipeline which configures sane defaults for a NX Monorepo codebase.

In addition to this, it also creates a CodeCommit repository with
automated PR builds and approvals.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.PDKPipeline(
  scope: Construct,
  id: str,
  synth: IFileSetProducer,
  asset_publishing_code_build_defaults: CodeBuildOptions = None,
  cli_version: str = None,
  code_build_defaults: CodeBuildOptions = None,
  code_pipeline: Pipeline = None,
  cross_account_keys: bool = None,
  docker_credentials: typing.List[DockerCredential] = None,
  docker_enabled_for_self_mutation: bool = None,
  docker_enabled_for_synth: bool = None,
  enable_key_rotation: bool = None,
  pipeline_name: str = None,
  publish_assets_in_parallel: bool = None,
  reuse_cross_region_support_stacks: bool = None,
  role: IRole = None,
  self_mutation: bool = None,
  self_mutation_code_build_defaults: CodeBuildOptions = None,
  synth_code_build_defaults: CodeBuildOptions = None,
  use_change_sets: bool = None,
  primary_synth_directory: str,
  repository_name: str,
  code_commit_removal_policy: RemovalPolicy = None,
  default_branch_name: str = None,
  sonar_code_scanner_config: SonarCodeScannerConfig = None,
  synth_shell_step_partial_props: ShellStepProps = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.synth">synth</a></code> | <code>aws_cdk.pipelines.IFileSetProducer</code> | The build step that produces the CDK Cloud Assembly. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.assetPublishingCodeBuildDefaults">asset_publishing_code_build_defaults</a></code> | <code>aws_cdk.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the asset publishing CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.cliVersion">cli_version</a></code> | <code>str</code> | CDK CLI version to use in self-mutation and asset publishing steps. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.codeBuildDefaults">code_build_defaults</a></code> | <code>aws_cdk.pipelines.CodeBuildOptions</code> | Customize the CodeBuild projects created for this pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.codePipeline">code_pipeline</a></code> | <code>aws_cdk.aws_codepipeline.Pipeline</code> | An existing Pipeline to be reused and built upon. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.crossAccountKeys">cross_account_keys</a></code> | <code>bool</code> | Create KMS keys for the artifact buckets, allowing cross-account deployments. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.dockerCredentials">docker_credentials</a></code> | <code>typing.List[aws_cdk.pipelines.DockerCredential]</code> | A list of credentials used to authenticate to Docker registries. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.dockerEnabledForSelfMutation">docker_enabled_for_self_mutation</a></code> | <code>bool</code> | Enable Docker for the self-mutate step. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.dockerEnabledForSynth">docker_enabled_for_synth</a></code> | <code>bool</code> | Enable Docker for the 'synth' step. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.enableKeyRotation">enable_key_rotation</a></code> | <code>bool</code> | Enable KMS key rotation for the generated KMS keys. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.pipelineName">pipeline_name</a></code> | <code>str</code> | The name of the CodePipeline pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.publishAssetsInParallel">publish_assets_in_parallel</a></code> | <code>bool</code> | Publish assets in multiple CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.reuseCrossRegionSupportStacks">reuse_cross_region_support_stacks</a></code> | <code>bool</code> | Reuse the same cross region support stack for all pipelines in the App. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.role">role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | The IAM role to be assumed by this Pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.selfMutation">self_mutation</a></code> | <code>bool</code> | Whether the pipeline will update itself. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.selfMutationCodeBuildDefaults">self_mutation_code_build_defaults</a></code> | <code>aws_cdk.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the self mutation CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.synthCodeBuildDefaults">synth_code_build_defaults</a></code> | <code>aws_cdk.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the synthesize CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.useChangeSets">use_change_sets</a></code> | <code>bool</code> | Deploy every stack by creating a change set and executing it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.primarySynthDirectory">primary_synth_directory</a></code> | <code>str</code> | Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.repositoryName">repository_name</a></code> | <code>str</code> | Name of the CodeCommit repository to create. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.codeCommitRemovalPolicy">code_commit_removal_policy</a></code> | <code>aws_cdk.RemovalPolicy</code> | Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.defaultBranchName">default_branch_name</a></code> | <code>str</code> | Branch to trigger the pipeline execution. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.sonarCodeScannerConfig">sonar_code_scanner_config</a></code> | <code>aws_prototyping_sdk.pipeline.SonarCodeScannerConfig</code> | Configuration for enabling Sonarqube code scanning on a successful synth. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.synthShellStepPartialProps">synth_shell_step_partial_props</a></code> | <code>aws_cdk.pipelines.ShellStepProps</code> | PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.id"></a>

- *Type:* str

---

##### `synth`<sup>Required</sup> <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.synth"></a>

- *Type:* aws_cdk.pipelines.IFileSetProducer

The build step that produces the CDK Cloud Assembly.

The primary output of this step needs to be the `cdk.out` directory
generated by the `cdk synth` command.

If you use a `ShellStep` here and you don't configure an output directory,
the output directory will automatically be assumed to be `cdk.out`.

---

##### `asset_publishing_code_build_defaults`<sup>Optional</sup> <a name="asset_publishing_code_build_defaults" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.assetPublishingCodeBuildDefaults"></a>

- *Type:* aws_cdk.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the asset publishing CodeBuild projects.

---

##### `cli_version`<sup>Optional</sup> <a name="cli_version" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.cliVersion"></a>

- *Type:* str
- *Default:* Latest version

CDK CLI version to use in self-mutation and asset publishing steps.

If you want to lock the CDK CLI version used in the pipeline, by steps
that are automatically generated for you, specify the version here.

We recommend you do not specify this value, as not specifying it always
uses the latest CLI version which is backwards compatible with old versions.

If you do specify it, be aware that this version should always be equal to or higher than the
version of the CDK framework used by the CDK app, when the CDK commands are
run during your pipeline execution. When you change this version, the *next
time* the `SelfMutate` step runs it will still be using the CLI of the the
*previous* version that was in this property: it will only start using the
new version after `SelfMutate` completes successfully. That means that if
you want to update both framework and CLI version, you should update the
CLI version first, commit, push and deploy, and only then update the
framework version.

---

##### `code_build_defaults`<sup>Optional</sup> <a name="code_build_defaults" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.codeBuildDefaults"></a>

- *Type:* aws_cdk.pipelines.CodeBuildOptions
- *Default:* All projects run non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_6_0

Customize the CodeBuild projects created for this pipeline.

---

##### `code_pipeline`<sup>Optional</sup> <a name="code_pipeline" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.codePipeline"></a>

- *Type:* aws_cdk.aws_codepipeline.Pipeline
- *Default:* a new underlying pipeline is created.

An existing Pipeline to be reused and built upon.

[disable-awslint:ref-via-interface]

---

##### `cross_account_keys`<sup>Optional</sup> <a name="cross_account_keys" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.crossAccountKeys"></a>

- *Type:* bool
- *Default:* false

Create KMS keys for the artifact buckets, allowing cross-account deployments.

The artifact buckets have to be encrypted to support deploying CDK apps to
another account, so if you want to do that or want to have your artifact
buckets encrypted, be sure to set this value to `true`.

Be aware there is a cost associated with maintaining the KMS keys.

---

##### `docker_credentials`<sup>Optional</sup> <a name="docker_credentials" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.dockerCredentials"></a>

- *Type:* typing.List[aws_cdk.pipelines.DockerCredential]
- *Default:* []

A list of credentials used to authenticate to Docker registries.

Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.

---

##### `docker_enabled_for_self_mutation`<sup>Optional</sup> <a name="docker_enabled_for_self_mutation" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.dockerEnabledForSelfMutation"></a>

- *Type:* bool
- *Default:* false

Enable Docker for the self-mutate step.

Set this to true if the pipeline itself uses Docker container assets
(for example, if you use `LinuxBuildImage.fromAsset()` as the build
image of a CodeBuild step in the pipeline).

You do not need to set it if you build Docker image assets in the
application Stages and Stacks that are *deployed* by this pipeline.

Configures privileged mode for the self-mutation CodeBuild action.

If you are about to turn this on in an already-deployed Pipeline,
set the value to `true` first, commit and allow the pipeline to
self-update, and only then use the Docker asset in the pipeline.

---

##### `docker_enabled_for_synth`<sup>Optional</sup> <a name="docker_enabled_for_synth" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.dockerEnabledForSynth"></a>

- *Type:* bool
- *Default:* false

Enable Docker for the 'synth' step.

Set this to true if you are using file assets that require
"bundling" anywhere in your application (meaning an asset
compilation step will be run with the tools provided by
a Docker image), both for the Pipeline stack as well as the
application stacks.

A common way to use bundling assets in your application is by
using the `@aws-cdk/aws-lambda-nodejs` library.

Configures privileged mode for the synth CodeBuild action.

If you are about to turn this on in an already-deployed Pipeline,
set the value to `true` first, commit and allow the pipeline to
self-update, and only then use the bundled asset.

---

##### `enable_key_rotation`<sup>Optional</sup> <a name="enable_key_rotation" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.enableKeyRotation"></a>

- *Type:* bool
- *Default:* false (key rotation is disabled)

Enable KMS key rotation for the generated KMS keys.

By default KMS key rotation is disabled, but will add
additional costs when enabled.

---

##### `pipeline_name`<sup>Optional</sup> <a name="pipeline_name" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.pipelineName"></a>

- *Type:* str
- *Default:* Automatically generated

The name of the CodePipeline pipeline.

---

##### `publish_assets_in_parallel`<sup>Optional</sup> <a name="publish_assets_in_parallel" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.publishAssetsInParallel"></a>

- *Type:* bool
- *Default:* true

Publish assets in multiple CodeBuild projects.

If set to false, use one Project per type to publish all assets.

Publishing in parallel improves concurrency and may reduce publishing
latency, but may also increase overall provisioning time of the CodeBuild
projects.

Experiment and see what value works best for you.

---

##### `reuse_cross_region_support_stacks`<sup>Optional</sup> <a name="reuse_cross_region_support_stacks" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.reuseCrossRegionSupportStacks"></a>

- *Type:* bool
- *Default:* true (Use the same support stack for all pipelines in App)

Reuse the same cross region support stack for all pipelines in the App.

---

##### `role`<sup>Optional</sup> <a name="role" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.role"></a>

- *Type:* aws_cdk.aws_iam.IRole
- *Default:* A new role is created

The IAM role to be assumed by this Pipeline.

---

##### `self_mutation`<sup>Optional</sup> <a name="self_mutation" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.selfMutation"></a>

- *Type:* bool
- *Default:* true

Whether the pipeline will update itself.

This needs to be set to `true` to allow the pipeline to reconfigure
itself when assets or stages are being added to it, and `true` is the
recommended setting.

You can temporarily set this to `false` while you are iterating
on the pipeline itself and prefer to deploy changes using `cdk deploy`.

---

##### `self_mutation_code_build_defaults`<sup>Optional</sup> <a name="self_mutation_code_build_defaults" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.selfMutationCodeBuildDefaults"></a>

- *Type:* aws_cdk.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the self mutation CodeBuild projects.

---

##### `synth_code_build_defaults`<sup>Optional</sup> <a name="synth_code_build_defaults" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.synthCodeBuildDefaults"></a>

- *Type:* aws_cdk.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the synthesize CodeBuild projects.

---

##### `use_change_sets`<sup>Optional</sup> <a name="use_change_sets" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.useChangeSets"></a>

- *Type:* bool
- *Default:* true

Deploy every stack by creating a change set and executing it.

When enabled, creates a "Prepare" and "Execute" action for each stack. Disable
to deploy the stack in one pipeline action.

---

##### `primary_synth_directory`<sup>Required</sup> <a name="primary_synth_directory" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.primarySynthDirectory"></a>

- *Type:* str

Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out.

---

##### `repository_name`<sup>Required</sup> <a name="repository_name" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.repositoryName"></a>

- *Type:* str

Name of the CodeCommit repository to create.

---

##### `code_commit_removal_policy`<sup>Optional</sup> <a name="code_commit_removal_policy" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.codeCommitRemovalPolicy"></a>

- *Type:* aws_cdk.RemovalPolicy

Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation.

---

##### `default_branch_name`<sup>Optional</sup> <a name="default_branch_name" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.defaultBranchName"></a>

- *Type:* str
- *Default:* mainline

Branch to trigger the pipeline execution.

---

##### `sonar_code_scanner_config`<sup>Optional</sup> <a name="sonar_code_scanner_config" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.sonarCodeScannerConfig"></a>

- *Type:* aws_prototyping_sdk.pipeline.SonarCodeScannerConfig
- *Default:* undefined

Configuration for enabling Sonarqube code scanning on a successful synth.

---

##### `synth_shell_step_partial_props`<sup>Optional</sup> <a name="synth_shell_step_partial_props" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.synthShellStepPartialProps"></a>

- *Type:* aws_cdk.pipelines.ShellStepProps

PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands.

To override these defaults
and/or provide additional inputs, specify env settings, etc you can provide
a partial ShellStepProps.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.addStage">add_stage</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.buildPipeline">build_pipeline</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.suppressCDKViolations">suppress_cdk_violations</a></code> | *No description.* |

---

##### `to_string` <a name="to_string" id="aws-prototyping-sdk.pipeline.PDKPipeline.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `add_stage` <a name="add_stage" id="aws-prototyping-sdk.pipeline.PDKPipeline.addStage"></a>

```python
def add_stage(
  stage: Stage,
  post: typing.List[Step] = None,
  pre: typing.List[Step] = None,
  stack_steps: typing.List[StackSteps] = None
) -> StageDeployment
```

###### `stage`<sup>Required</sup> <a name="stage" id="aws-prototyping-sdk.pipeline.PDKPipeline.addStage.parameter.stage"></a>

- *Type:* aws_cdk.Stage

---

###### `post`<sup>Optional</sup> <a name="post" id="aws-prototyping-sdk.pipeline.PDKPipeline.addStage.parameter.post"></a>

- *Type:* typing.List[aws_cdk.pipelines.Step]
- *Default:* No additional steps

Additional steps to run after all of the stacks in the stage.

---

###### `pre`<sup>Optional</sup> <a name="pre" id="aws-prototyping-sdk.pipeline.PDKPipeline.addStage.parameter.pre"></a>

- *Type:* typing.List[aws_cdk.pipelines.Step]
- *Default:* No additional steps

Additional steps to run before any of the stacks in the stage.

---

###### `stack_steps`<sup>Optional</sup> <a name="stack_steps" id="aws-prototyping-sdk.pipeline.PDKPipeline.addStage.parameter.stackSteps"></a>

- *Type:* typing.List[aws_cdk.pipelines.StackSteps]
- *Default:* No additional instructions

Instructions for stack level steps.

---

##### `build_pipeline` <a name="build_pipeline" id="aws-prototyping-sdk.pipeline.PDKPipeline.buildPipeline"></a>

```python
def build_pipeline() -> None
```

##### `suppress_cdk_violations` <a name="suppress_cdk_violations" id="aws-prototyping-sdk.pipeline.PDKPipeline.suppressCDKViolations"></a>

```python
def suppress_cdk_violations() -> None
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### `is_construct` <a name="is_construct" id="aws-prototyping-sdk.pipeline.PDKPipeline.isConstruct"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.PDKPipeline.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="aws-prototyping-sdk.pipeline.PDKPipeline.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.property.codePipeline">code_pipeline</a></code> | <code>aws_cdk.pipelines.CodePipeline</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.property.codeRepository">code_repository</a></code> | <code>aws_cdk.aws_codecommit.Repository</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="aws-prototyping-sdk.pipeline.PDKPipeline.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `code_pipeline`<sup>Required</sup> <a name="code_pipeline" id="aws-prototyping-sdk.pipeline.PDKPipeline.property.codePipeline"></a>

```python
code_pipeline: CodePipeline
```

- *Type:* aws_cdk.pipelines.CodePipeline

---

##### `code_repository`<sup>Required</sup> <a name="code_repository" id="aws-prototyping-sdk.pipeline.PDKPipeline.property.codeRepository"></a>

```python
code_repository: Repository
```

- *Type:* aws_cdk.aws_codecommit.Repository

---


### SonarCodeScanner <a name="SonarCodeScanner" id="aws-prototyping-sdk.pipeline.SonarCodeScanner"></a>

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.SonarCodeScanner(
  scope: Construct,
  id: str,
  sonarqube_authorized_group: str,
  sonarqube_default_profile_or_gate_name: str,
  sonarqube_endpoint: str,
  sonarqube_project_name: str,
  cdk_out_dir: str = None,
  cfn_nag_ignore_path: str = None,
  exclude_globs_for_scan: typing.List[str] = None,
  include_globs_for_scan: typing.List[str] = None,
  pre_archive_commands: typing.List[str] = None,
  sonarqube_specific_profile_or_gate_name: str = None,
  sonarqube_tags: typing.List[str] = None,
  artifact_bucket_arn: str,
  synth_build_arn: str,
  artifact_bucket_key_arn: str = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeAuthorizedGroup">sonarqube_authorized_group</a></code> | <code>str</code> | Group name in Sonarqube with access to administer this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeDefaultProfileOrGateName">sonarqube_default_profile_or_gate_name</a></code> | <code>str</code> | Default profile/gate name i.e: your org profile. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeEndpoint">sonarqube_endpoint</a></code> | <code>str</code> | endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeProjectName">sonarqube_project_name</a></code> | <code>str</code> | Name of the project to create in Sonarqube. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.cdkOutDir">cdk_out_dir</a></code> | <code>str</code> | directory containing the synthesized cdk resources. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.cfnNagIgnorePath">cfn_nag_ignore_path</a></code> | <code>str</code> | path to a file containing the cfn nag suppression rules. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.excludeGlobsForScan">exclude_globs_for_scan</a></code> | <code>typing.List[str]</code> | glob patterns to exclude from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.includeGlobsForScan">include_globs_for_scan</a></code> | <code>typing.List[str]</code> | glob patterns to include from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.preArchiveCommands">pre_archive_commands</a></code> | <code>typing.List[str]</code> | Hook which allows custom commands to be executed before the process commences the archival process. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeSpecificProfileOrGateName">sonarqube_specific_profile_or_gate_name</a></code> | <code>str</code> | Specific profile/gate name i.e: language specific. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeTags">sonarqube_tags</a></code> | <code>typing.List[str]</code> | Tags to associate with this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.artifactBucketArn">artifact_bucket_arn</a></code> | <code>str</code> | S3 bucket ARN containing the built artifacts from the synth build. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.synthBuildArn">synth_build_arn</a></code> | <code>str</code> | ARN for the CodeBuild task responsible for executing the synth command. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.artifactBucketKeyArn">artifact_bucket_key_arn</a></code> | <code>str</code> | Artifact bucket key ARN used to encrypt the artifacts. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.id"></a>

- *Type:* str

---

##### `sonarqube_authorized_group`<sup>Required</sup> <a name="sonarqube_authorized_group" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeAuthorizedGroup"></a>

- *Type:* str

Group name in Sonarqube with access to administer this project.

---

##### `sonarqube_default_profile_or_gate_name`<sup>Required</sup> <a name="sonarqube_default_profile_or_gate_name" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeDefaultProfileOrGateName"></a>

- *Type:* str

Default profile/gate name i.e: your org profile.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqube_endpoint`<sup>Required</sup> <a name="sonarqube_endpoint" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeEndpoint"></a>

- *Type:* str

endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>.

Note: Ensure a trailing '/' is not included.

---

##### `sonarqube_project_name`<sup>Required</sup> <a name="sonarqube_project_name" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeProjectName"></a>

- *Type:* str

Name of the project to create in Sonarqube.

---

##### `cdk_out_dir`<sup>Optional</sup> <a name="cdk_out_dir" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.cdkOutDir"></a>

- *Type:* str

directory containing the synthesized cdk resources.

---

##### `cfn_nag_ignore_path`<sup>Optional</sup> <a name="cfn_nag_ignore_path" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.cfnNagIgnorePath"></a>

- *Type:* str

path to a file containing the cfn nag suppression rules.

---

##### `exclude_globs_for_scan`<sup>Optional</sup> <a name="exclude_globs_for_scan" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.excludeGlobsForScan"></a>

- *Type:* typing.List[str]

glob patterns to exclude from sonar scan.

---

##### `include_globs_for_scan`<sup>Optional</sup> <a name="include_globs_for_scan" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.includeGlobsForScan"></a>

- *Type:* typing.List[str]

glob patterns to include from sonar scan.

---

##### `pre_archive_commands`<sup>Optional</sup> <a name="pre_archive_commands" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.preArchiveCommands"></a>

- *Type:* typing.List[str]

Hook which allows custom commands to be executed before the process commences the archival process.

---

##### `sonarqube_specific_profile_or_gate_name`<sup>Optional</sup> <a name="sonarqube_specific_profile_or_gate_name" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeSpecificProfileOrGateName"></a>

- *Type:* str

Specific profile/gate name i.e: language specific.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqube_tags`<sup>Optional</sup> <a name="sonarqube_tags" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeTags"></a>

- *Type:* typing.List[str]

Tags to associate with this project.

---

##### `artifact_bucket_arn`<sup>Required</sup> <a name="artifact_bucket_arn" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.artifactBucketArn"></a>

- *Type:* str

S3 bucket ARN containing the built artifacts from the synth build.

---

##### `synth_build_arn`<sup>Required</sup> <a name="synth_build_arn" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.synthBuildArn"></a>

- *Type:* str

ARN for the CodeBuild task responsible for executing the synth command.

---

##### `artifact_bucket_key_arn`<sup>Optional</sup> <a name="artifact_bucket_key_arn" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.artifactBucketKeyArn"></a>

- *Type:* str

Artifact bucket key ARN used to encrypt the artifacts.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.toString">to_string</a></code> | Returns a string representation of this construct. |

---

##### `to_string` <a name="to_string" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### `is_construct` <a name="is_construct" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.isConstruct"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.SonarCodeScanner.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---


## Structs <a name="Structs" id="Structs"></a>

### Message <a name="Message" id="aws-prototyping-sdk.pdk_nag.Message"></a>

Message instance.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pdk_nag.Message.Initializer"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.Message(
  message_description: str,
  message_type: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.Message.property.messageDescription">message_description</a></code> | <code>str</code> | Message description. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.Message.property.messageType">message_type</a></code> | <code>str</code> | Message type as returned from cdk-nag. |

---

##### `message_description`<sup>Required</sup> <a name="message_description" id="aws-prototyping-sdk.pdk_nag.Message.property.messageDescription"></a>

```python
message_description: str
```

- *Type:* str

Message description.

---

##### `message_type`<sup>Required</sup> <a name="message_type" id="aws-prototyping-sdk.pdk_nag.Message.property.messageType"></a>

```python
message_type: str
```

- *Type:* str

Message type as returned from cdk-nag.

---

### MonorepoUpgradeDepsOptions <a name="MonorepoUpgradeDepsOptions" id="aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions"></a>

Configuration for Monorepo Upgrade Deps task.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

nx_monorepo.MonorepoUpgradeDepsOptions(
  syncpack_config: SyncpackConfig = None,
  task_name: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.property.syncpackConfig">syncpack_config</a></code> | <code>aws_prototyping_sdk.nx_monorepo.SyncpackConfig</code> | Syncpack configuration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.property.taskName">task_name</a></code> | <code>str</code> | Name of the task to create. |

---

##### `syncpack_config`<sup>Optional</sup> <a name="syncpack_config" id="aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.property.syncpackConfig"></a>

```python
syncpack_config: SyncpackConfig
```

- *Type:* aws_prototyping_sdk.nx_monorepo.SyncpackConfig
- *Default:* SyncpackConfig.DEFAULT_CONFIG

Syncpack configuration.

No merging is performed and as such a complete syncpackConfig is required if supplied.

---

##### `task_name`<sup>Optional</sup> <a name="task_name" id="aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.property.taskName"></a>

```python
task_name: str
```

- *Type:* str
- *Default:* upgrade-deps

Name of the task to create.

---

### NagResult <a name="NagResult" id="aws-prototyping-sdk.pdk_nag.NagResult"></a>

Nag result.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pdk_nag.NagResult.Initializer"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.NagResult(
  messages: typing.List[Message],
  resource: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.NagResult.property.messages">messages</a></code> | <code>typing.List[aws_prototyping_sdk.pdk_nag.Message]</code> | List of messages. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.NagResult.property.resource">resource</a></code> | <code>str</code> | Resource which triggered the message. |

---

##### `messages`<sup>Required</sup> <a name="messages" id="aws-prototyping-sdk.pdk_nag.NagResult.property.messages"></a>

```python
messages: typing.List[Message]
```

- *Type:* typing.List[aws_prototyping_sdk.pdk_nag.Message]

List of messages.

---

##### `resource`<sup>Required</sup> <a name="resource" id="aws-prototyping-sdk.pdk_nag.NagResult.property.resource"></a>

```python
resource: str
```

- *Type:* str

Resource which triggered the message.

---

### NxMonorepoProjectOptions <a name="NxMonorepoProjectOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions"></a>

Configuration options for the NxMonorepoProject.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

nx_monorepo.NxMonorepoProjectOptions(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  allow_library_dependencies: bool = None,
  author_email: str = None,
  author_name: str = None,
  author_organization: bool = None,
  author_url: str = None,
  auto_detect_bin: bool = None,
  bin: typing.Mapping[str] = None,
  bugs_email: str = None,
  bugs_url: str = None,
  bundled_deps: typing.List[str] = None,
  code_artifact_options: CodeArtifactOptions = None,
  deps: typing.List[str] = None,
  description: str = None,
  dev_deps: typing.List[str] = None,
  entrypoint: str = None,
  homepage: str = None,
  keywords: typing.List[str] = None,
  license: str = None,
  licensed: bool = None,
  max_node_version: str = None,
  min_node_version: str = None,
  npm_access: NpmAccess = None,
  npm_registry: str = None,
  npm_registry_url: str = None,
  npm_token_secret: str = None,
  package_manager: NodePackageManager = None,
  package_name: str = None,
  peer_dependency_options: PeerDependencyOptions = None,
  peer_deps: typing.List[str] = None,
  pnpm_version: str = None,
  repository: str = None,
  repository_directory: str = None,
  scoped_packages_options: typing.List[ScopedPackagesOptions] = None,
  scripts: typing.Mapping[str] = None,
  stability: str = None,
  jsii_release_version: str = None,
  major_version: typing.Union[int, float] = None,
  min_major_version: typing.Union[int, float] = None,
  npm_dist_tag: str = None,
  post_build_steps: typing.List[JobStep] = None,
  prerelease: str = None,
  publish_dry_run: bool = None,
  publish_tasks: bool = None,
  release_branches: typing.Mapping[BranchOptions] = None,
  release_every_commit: bool = None,
  release_failure_issue: bool = None,
  release_failure_issue_label: str = None,
  release_schedule: str = None,
  release_tag_prefix: str = None,
  release_trigger: ReleaseTrigger = None,
  release_workflow_name: str = None,
  release_workflow_setup_steps: typing.List[JobStep] = None,
  versionrc_options: typing.Mapping[typing.Any] = None,
  workflow_container_image: str = None,
  workflow_runs_on: typing.List[str] = None,
  default_release_branch: str,
  artifacts_directory: str = None,
  auto_approve_upgrades: bool = None,
  build_workflow: bool = None,
  build_workflow_triggers: Triggers = None,
  bundler_options: BundlerOptions = None,
  code_cov: bool = None,
  code_cov_token_secret: str = None,
  copyright_owner: str = None,
  copyright_period: str = None,
  dependabot: bool = None,
  dependabot_options: DependabotOptions = None,
  deps_upgrade: bool = None,
  deps_upgrade_options: UpgradeDependenciesOptions = None,
  gitignore: typing.List[str] = None,
  jest: bool = None,
  jest_options: JestOptions = None,
  mutable_build: bool = None,
  npmignore: typing.List[str] = None,
  npmignore_enabled: bool = None,
  npm_ignore_options: IgnoreFileOptions = None,
  package: bool = None,
  prettier: bool = None,
  prettier_options: PrettierOptions = None,
  projen_dev_dependency: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projen_version: str = None,
  pull_request_template: bool = None,
  pull_request_template_contents: typing.List[str] = None,
  release: bool = None,
  release_to_npm: bool = None,
  release_workflow: bool = None,
  workflow_bootstrap_steps: typing.List[JobStep] = None,
  workflow_git_identity: GitIdentity = None,
  workflow_node_version: str = None,
  disable_tsconfig: bool = None,
  disable_tsconfig_dev: bool = None,
  docgen: bool = None,
  docs_directory: str = None,
  entrypoint_types: str = None,
  eslint: bool = None,
  eslint_options: EslintOptions = None,
  libdir: str = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcOptions = None,
  sample_code: bool = None,
  srcdir: str = None,
  testdir: str = None,
  tsconfig: TypescriptConfigOptions = None,
  tsconfig_dev: TypescriptConfigOptions = None,
  tsconfig_dev_file: str = None,
  typescript_version: str = None,
  monorepo_upgrade_deps: bool = None,
  monorepo_upgrade_deps_options: MonorepoUpgradeDepsOptions = None,
  nx_config: WorkspaceConfig = None,
  workspace_config: WorkspaceConfig = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorOrganization">author_organization</a></code> | <code>bool</code> | Is the author an organization. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorUrl">author_url</a></code> | <code>str</code> | Author's URL / Website. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoDetectBin">auto_detect_bin</a></code> | <code>bool</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bin">bin</a></code> | <code>typing.Mapping[str]</code> | Binary programs vended with your module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bugsEmail">bugs_email</a></code> | <code>str</code> | The email address to which issues should be reported. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bugsUrl">bugs_url</a></code> | <code>str</code> | The url to your project's issue tracker. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bundledDeps">bundled_deps</a></code> | <code>typing.List[str]</code> | List of dependencies to bundle into this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeArtifactOptions">code_artifact_options</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.deps">deps</a></code> | <code>typing.List[str]</code> | Runtime dependencies of this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.description">description</a></code> | <code>str</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | Build dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.entrypoint">entrypoint</a></code> | <code>str</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.homepage">homepage</a></code> | <code>str</code> | Package's Homepage / Website. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.keywords">keywords</a></code> | <code>typing.List[str]</code> | Keywords to include in `package.json`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.license">license</a></code> | <code>str</code> | License's SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.licensed">licensed</a></code> | <code>bool</code> | Indicates if a license should be added. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmAccess">npm_access</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmRegistry">npm_registry</a></code> | <code>str</code> | The host name of the npm registry to publish to. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmRegistryUrl">npm_registry_url</a></code> | <code>str</code> | The base URL of the npm package registry. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmTokenSecret">npm_token_secret</a></code> | <code>str</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.packageName">package_name</a></code> | <code>str</code> | The "name" in package.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.peerDependencyOptions">peer_dependency_options</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.peerDeps">peer_deps</a></code> | <code>typing.List[str]</code> | Peer dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pnpmVersion">pnpm_version</a></code> | <code>str</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.repository">repository</a></code> | <code>str</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.repositoryDirectory">repository_directory</a></code> | <code>str</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.scopedPackagesOptions">scoped_packages_options</a></code> | <code>typing.List[projen.javascript.ScopedPackagesOptions]</code> | Options for privately hosted scoped packages. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.scripts">scripts</a></code> | <code>typing.Mapping[str]</code> | npm scripts to include. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.stability">stability</a></code> | <code>str</code> | Package's Stability. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jsiiReleaseVersion">jsii_release_version</a></code> | <code>str</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.majorVersion">major_version</a></code> | <code>typing.Union[int, float]</code> | Major version to release from the default branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.minMajorVersion">min_major_version</a></code> | <code>typing.Union[int, float]</code> | Minimal Major version to release. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmDistTag">npm_dist_tag</a></code> | <code>str</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.postBuildSteps">post_build_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prerelease">prerelease</a></code> | <code>str</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.publishDryRun">publish_dry_run</a></code> | <code>bool</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.publishTasks">publish_tasks</a></code> | <code>bool</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseBranches">release_branches</a></code> | <code>typing.Mapping[projen.release.BranchOptions]</code> | Defines additional release branches. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseEveryCommit">release_every_commit</a></code> | <code>bool</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseFailureIssue">release_failure_issue</a></code> | <code>bool</code> | Create a github issue on every failed publishing task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseFailureIssueLabel">release_failure_issue_label</a></code> | <code>str</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseSchedule">release_schedule</a></code> | <code>str</code> | CRON schedule to trigger new releases. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseTagPrefix">release_tag_prefix</a></code> | <code>str</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseTrigger">release_trigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflowName">release_workflow_name</a></code> | <code>str</code> | The name of the default release workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflowSetupSteps">release_workflow_setup_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.versionrcOptions">versionrc_options</a></code> | <code>typing.Mapping[typing.Any]</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowContainerImage">workflow_container_image</a></code> | <code>str</code> | Container image to use for GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowRunsOn">workflow_runs_on</a></code> | <code>typing.List[str]</code> | Github Runner selection labels. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.defaultReleaseBranch">default_release_branch</a></code> | <code>str</code> | The name of the main release branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | A directory which will contain build artifacts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoApproveUpgrades">auto_approve_upgrades</a></code> | <code>bool</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.buildWorkflow">build_workflow</a></code> | <code>bool</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.buildWorkflowTriggers">build_workflow_triggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bundlerOptions">bundler_options</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeCov">code_cov</a></code> | <code>bool</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeCovTokenSecret">code_cov_token_secret</a></code> | <code>str</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.copyrightOwner">copyright_owner</a></code> | <code>str</code> | License copyright owner. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.copyrightPeriod">copyright_period</a></code> | <code>str</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.dependabot">dependabot</a></code> | <code>bool</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.dependabotOptions">dependabot_options</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.depsUpgrade">deps_upgrade</a></code> | <code>bool</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.depsUpgradeOptions">deps_upgrade_options</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitignore">gitignore</a></code> | <code>typing.List[str]</code> | Additional entries to .gitignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jest">jest</a></code> | <code>bool</code> | Setup jest unit tests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jestOptions">jest_options</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mutableBuild">mutable_build</a></code> | <code>bool</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmignore">npmignore</a></code> | <code>typing.List[str]</code> | Additional entries to .npmignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmignoreEnabled">npmignore_enabled</a></code> | <code>bool</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmIgnoreOptions">npm_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.package">package</a></code> | <code>bool</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prettier">prettier</a></code> | <code>bool</code> | Setup prettier. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prettierOptions">prettier_options</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenDevDependency">projen_dev_dependency</a></code> | <code>bool</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenVersion">projen_version</a></code> | <code>str</code> | Version of projen to install. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pullRequestTemplate">pull_request_template</a></code> | <code>bool</code> | Include a GitHub pull request template. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pullRequestTemplateContents">pull_request_template_contents</a></code> | <code>typing.List[str]</code> | The contents of the pull request template. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.release">release</a></code> | <code>bool</code> | Add release management to this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseToNpm">release_to_npm</a></code> | <code>bool</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflow">release_workflow</a></code> | <code>bool</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowBootstrapSteps">workflow_bootstrap_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowGitIdentity">workflow_git_identity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowNodeVersion">workflow_node_version</a></code> | <code>str</code> | The node version to use in GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.disableTsconfig">disable_tsconfig</a></code> | <code>bool</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.disableTsconfigDev">disable_tsconfig_dev</a></code> | <code>bool</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.docgen">docgen</a></code> | <code>bool</code> | Docgen by Typedoc. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.docsDirectory">docs_directory</a></code> | <code>str</code> | Docs directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.entrypointTypes">entrypoint_types</a></code> | <code>str</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.eslint">eslint</a></code> | <code>bool</code> | Setup eslint. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.eslintOptions">eslint_options</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.libdir">libdir</a></code> | <code>str</code> | Typescript  artifacts output directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.sampleCode">sample_code</a></code> | <code>bool</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.srcdir">srcdir</a></code> | <code>str</code> | Typescript sources directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.testdir">testdir</a></code> | <code>str</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfigDevFile">tsconfig_dev_file</a></code> | <code>str</code> | The name of the development tsconfig.json file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.typescriptVersion">typescript_version</a></code> | <code>str</code> | TypeScript version to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDeps">monorepo_upgrade_deps</a></code> | <code>bool</code> | Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDepsOptions">monorepo_upgrade_deps_options</a></code> | <code>aws_prototyping_sdk.nx_monorepo.MonorepoUpgradeDepsOptions</code> | Monorepo Upgrade Deps options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.nxConfig">nx_config</a></code> | <code>aws_prototyping_sdk.nx_monorepo.Nx.WorkspaceConfig</code> | Configuration for NX. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workspaceConfig">workspace_config</a></code> | <code>aws_prototyping_sdk.nx_monorepo.WorkspaceConfig</code> | Configuration for workspace. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.name"></a>

```python
name: str
```

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitIgnoreOptions"></a>

```python
git_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitOptions"></a>

```python
git_options: GitOptions
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.logging"></a>

```python
logging: LoggerOptions
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJson"></a>

```python
projenrc_json: bool
```

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJsonOptions"></a>

```python
projenrc_json_options: ProjenrcJsonOptions
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.renovatebot"></a>

```python
renovatebot: bool
```

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.renovatebotOptions"></a>

```python
renovatebot_options: RenovatebotOptions
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoApproveOptions"></a>

```python
auto_approve_options: AutoApproveOptions
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoMerge"></a>

```python
auto_merge: bool
```

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoMergeOptions"></a>

```python
auto_merge_options: AutoMergeOptions
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.clobber"></a>

```python
clobber: bool
```

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.devContainer"></a>

```python
dev_container: bool
```

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.github"></a>

```python
github: bool
```

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.githubOptions"></a>

```python
github_options: GitHubOptions
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitpod"></a>

```python
gitpod: bool
```

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```python
mergify: bool
```

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```python
mergify_options: MergifyOptions
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenCredentials"></a>

```python
projen_credentials: GithubCredentials
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```python
projen_token_secret: str
```

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.readme"></a>

```python
readme: SampleReadmeProps
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.stale"></a>

```python
stale: bool
```

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.staleOptions"></a>

```python
stale_options: StaleOptions
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.vscode"></a>

```python
vscode: bool
```

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allow_library_dependencies`<sup>Optional</sup> <a name="allow_library_dependencies" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.allowLibraryDependencies"></a>

```python
allow_library_dependencies: bool
```

- *Type:* bool
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `author_email`<sup>Optional</sup> <a name="author_email" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorEmail"></a>

```python
author_email: str
```

- *Type:* str

Author's e-mail.

---

##### `author_name`<sup>Optional</sup> <a name="author_name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorName"></a>

```python
author_name: str
```

- *Type:* str

Author's name.

---

##### `author_organization`<sup>Optional</sup> <a name="author_organization" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorOrganization"></a>

```python
author_organization: bool
```

- *Type:* bool

Is the author an organization.

---

##### `author_url`<sup>Optional</sup> <a name="author_url" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorUrl"></a>

```python
author_url: str
```

- *Type:* str

Author's URL / Website.

---

##### `auto_detect_bin`<sup>Optional</sup> <a name="auto_detect_bin" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoDetectBin"></a>

```python
auto_detect_bin: bool
```

- *Type:* bool
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bin"></a>

```python
bin: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugs_email`<sup>Optional</sup> <a name="bugs_email" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bugsEmail"></a>

```python
bugs_email: str
```

- *Type:* str

The email address to which issues should be reported.

---

##### `bugs_url`<sup>Optional</sup> <a name="bugs_url" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bugsUrl"></a>

```python
bugs_url: str
```

- *Type:* str

The url to your project's issue tracker.

---

##### `bundled_deps`<sup>Optional</sup> <a name="bundled_deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bundledDeps"></a>

```python
bundled_deps: typing.List[str]
```

- *Type:* typing.List[str]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `code_artifact_options`<sup>Optional</sup> <a name="code_artifact_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeArtifactOptions"></a>

```python
code_artifact_options: CodeArtifactOptions
```

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.deps"></a>

```python
deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.description"></a>

```python
description: str
```

- *Type:* str

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.devDeps"></a>

```python
dev_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.entrypoint"></a>

```python
entrypoint: str
```

- *Type:* str
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.homepage"></a>

```python
homepage: str
```

- *Type:* str

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.keywords"></a>

```python
keywords: typing.List[str]
```

- *Type:* typing.List[str]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.license"></a>

```python
license: str
```

- *Type:* str
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.licensed"></a>

```python
licensed: bool
```

- *Type:* bool
- *Default:* true

Indicates if a license should be added.

---

##### `max_node_version`<sup>Optional</sup> <a name="max_node_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.maxNodeVersion"></a>

```python
max_node_version: str
```

- *Type:* str
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `min_node_version`<sup>Optional</sup> <a name="min_node_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.minNodeVersion"></a>

```python
min_node_version: str
```

- *Type:* str
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npm_access`<sup>Optional</sup> <a name="npm_access" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmAccess"></a>

```python
npm_access: NpmAccess
```

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npm_registry`~~<sup>Optional</sup> <a name="npm_registry" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```python
npm_registry: str
```

- *Type:* str

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npm_registry_url`<sup>Optional</sup> <a name="npm_registry_url" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmRegistryUrl"></a>

```python
npm_registry_url: str
```

- *Type:* str
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npm_token_secret`<sup>Optional</sup> <a name="npm_token_secret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmTokenSecret"></a>

```python
npm_token_secret: str
```

- *Type:* str
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `package_manager`<sup>Optional</sup> <a name="package_manager" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.packageManager"></a>

```python
package_manager: NodePackageManager
```

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.packageName"></a>

```python
package_name: str
```

- *Type:* str
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peer_dependency_options`<sup>Optional</sup> <a name="peer_dependency_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.peerDependencyOptions"></a>

```python
peer_dependency_options: PeerDependencyOptions
```

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peer_deps`<sup>Optional</sup> <a name="peer_deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.peerDeps"></a>

```python
peer_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpm_version`<sup>Optional</sup> <a name="pnpm_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pnpmVersion"></a>

```python
pnpm_version: str
```

- *Type:* str
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.repository"></a>

```python
repository: str
```

- *Type:* str

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repository_directory`<sup>Optional</sup> <a name="repository_directory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.repositoryDirectory"></a>

```python
repository_directory: str
```

- *Type:* str

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scoped_packages_options`<sup>Optional</sup> <a name="scoped_packages_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.scopedPackagesOptions"></a>

```python
scoped_packages_options: typing.List[ScopedPackagesOptions]
```

- *Type:* typing.List[projen.javascript.ScopedPackagesOptions]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```python
scripts: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.stability"></a>

```python
stability: str
```

- *Type:* str

Package's Stability.

---

##### `jsii_release_version`<sup>Optional</sup> <a name="jsii_release_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jsiiReleaseVersion"></a>

```python
jsii_release_version: str
```

- *Type:* str
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `major_version`<sup>Optional</sup> <a name="major_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.majorVersion"></a>

```python
major_version: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `min_major_version`<sup>Optional</sup> <a name="min_major_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.minMajorVersion"></a>

```python
min_major_version: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npm_dist_tag`<sup>Optional</sup> <a name="npm_dist_tag" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmDistTag"></a>

```python
npm_dist_tag: str
```

- *Type:* str
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `post_build_steps`<sup>Optional</sup> <a name="post_build_steps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.postBuildSteps"></a>

```python
post_build_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prerelease"></a>

```python
prerelease: str
```

- *Type:* str
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publish_dry_run`<sup>Optional</sup> <a name="publish_dry_run" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.publishDryRun"></a>

```python
publish_dry_run: bool
```

- *Type:* bool
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publish_tasks`<sup>Optional</sup> <a name="publish_tasks" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.publishTasks"></a>

```python
publish_tasks: bool
```

- *Type:* bool
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `release_branches`<sup>Optional</sup> <a name="release_branches" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseBranches"></a>

```python
release_branches: typing.Mapping[BranchOptions]
```

- *Type:* typing.Mapping[projen.release.BranchOptions]
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`release_every_commit`~~<sup>Optional</sup> <a name="release_every_commit" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```python
release_every_commit: bool
```

- *Type:* bool
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `release_failure_issue`<sup>Optional</sup> <a name="release_failure_issue" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseFailureIssue"></a>

```python
release_failure_issue: bool
```

- *Type:* bool
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `release_failure_issue_label`<sup>Optional</sup> <a name="release_failure_issue_label" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseFailureIssueLabel"></a>

```python
release_failure_issue_label: str
```

- *Type:* str
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`release_schedule`~~<sup>Optional</sup> <a name="release_schedule" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```python
release_schedule: str
```

- *Type:* str
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `release_tag_prefix`<sup>Optional</sup> <a name="release_tag_prefix" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseTagPrefix"></a>

```python
release_tag_prefix: str
```

- *Type:* str
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `release_trigger`<sup>Optional</sup> <a name="release_trigger" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseTrigger"></a>

```python
release_trigger: ReleaseTrigger
```

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `release_workflow_name`<sup>Optional</sup> <a name="release_workflow_name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflowName"></a>

```python
release_workflow_name: str
```

- *Type:* str
- *Default:* "Release"

The name of the default release workflow.

---

##### `release_workflow_setup_steps`<sup>Optional</sup> <a name="release_workflow_setup_steps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflowSetupSteps"></a>

```python
release_workflow_setup_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrc_options`<sup>Optional</sup> <a name="versionrc_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.versionrcOptions"></a>

```python
versionrc_options: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflow_container_image`<sup>Optional</sup> <a name="workflow_container_image" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowContainerImage"></a>

```python
workflow_container_image: str
```

- *Type:* str
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflow_runs_on`<sup>Optional</sup> <a name="workflow_runs_on" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowRunsOn"></a>

```python
workflow_runs_on: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `default_release_branch`<sup>Required</sup> <a name="default_release_branch" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.defaultReleaseBranch"></a>

```python
default_release_branch: str
```

- *Type:* str
- *Default:* "main"

The name of the main release branch.

---

##### `artifacts_directory`<sup>Optional</sup> <a name="artifacts_directory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.artifactsDirectory"></a>

```python
artifacts_directory: str
```

- *Type:* str
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `auto_approve_upgrades`<sup>Optional</sup> <a name="auto_approve_upgrades" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoApproveUpgrades"></a>

```python
auto_approve_upgrades: bool
```

- *Type:* bool
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `build_workflow`<sup>Optional</sup> <a name="build_workflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.buildWorkflow"></a>

```python
build_workflow: bool
```

- *Type:* bool
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `build_workflow_triggers`<sup>Optional</sup> <a name="build_workflow_triggers" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.buildWorkflowTriggers"></a>

```python
build_workflow_triggers: Triggers
```

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundler_options`<sup>Optional</sup> <a name="bundler_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bundlerOptions"></a>

```python
bundler_options: BundlerOptions
```

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `code_cov`<sup>Optional</sup> <a name="code_cov" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeCov"></a>

```python
code_cov: bool
```

- *Type:* bool
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret.

---

##### `code_cov_token_secret`<sup>Optional</sup> <a name="code_cov_token_secret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeCovTokenSecret"></a>

```python
code_cov_token_secret: str
```

- *Type:* str
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyright_owner`<sup>Optional</sup> <a name="copyright_owner" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.copyrightOwner"></a>

```python
copyright_owner: str
```

- *Type:* str
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyright_period`<sup>Optional</sup> <a name="copyright_period" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.copyrightPeriod"></a>

```python
copyright_period: str
```

- *Type:* str
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.dependabot"></a>

```python
dependabot: bool
```

- *Type:* bool
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabot_options`<sup>Optional</sup> <a name="dependabot_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.dependabotOptions"></a>

```python
dependabot_options: DependabotOptions
```

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `deps_upgrade`<sup>Optional</sup> <a name="deps_upgrade" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.depsUpgrade"></a>

```python
deps_upgrade: bool
```

- *Type:* bool
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `deps_upgrade_options`<sup>Optional</sup> <a name="deps_upgrade_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.depsUpgradeOptions"></a>

```python
deps_upgrade_options: UpgradeDependenciesOptions
```

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitignore"></a>

```python
gitignore: typing.List[str]
```

- *Type:* typing.List[str]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jest"></a>

```python
jest: bool
```

- *Type:* bool
- *Default:* true

Setup jest unit tests.

---

##### `jest_options`<sup>Optional</sup> <a name="jest_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jestOptions"></a>

```python
jest_options: JestOptions
```

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutable_build`<sup>Optional</sup> <a name="mutable_build" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mutableBuild"></a>

```python
mutable_build: bool
```

- *Type:* bool
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```python
npmignore: typing.List[str]
```

- *Type:* typing.List[str]

Additional entries to .npmignore.

---

##### `npmignore_enabled`<sup>Optional</sup> <a name="npmignore_enabled" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmignoreEnabled"></a>

```python
npmignore_enabled: bool
```

- *Type:* bool
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npm_ignore_options`<sup>Optional</sup> <a name="npm_ignore_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmIgnoreOptions"></a>

```python
npm_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.package"></a>

```python
package: bool
```

- *Type:* bool
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prettier"></a>

```python
prettier: bool
```

- *Type:* bool
- *Default:* false

Setup prettier.

---

##### `prettier_options`<sup>Optional</sup> <a name="prettier_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prettierOptions"></a>

```python
prettier_options: PrettierOptions
```

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projen_dev_dependency`<sup>Optional</sup> <a name="projen_dev_dependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenDevDependency"></a>

```python
projen_dev_dependency: bool
```

- *Type:* bool
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJs"></a>

```python
projenrc_js: bool
```

- *Type:* bool
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJsOptions"></a>

```python
projenrc_js_options: ProjenrcOptions
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projen_version`<sup>Optional</sup> <a name="projen_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenVersion"></a>

```python
projen_version: str
```

- *Type:* str
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pull_request_template`<sup>Optional</sup> <a name="pull_request_template" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pullRequestTemplate"></a>

```python
pull_request_template: bool
```

- *Type:* bool
- *Default:* true

Include a GitHub pull request template.

---

##### `pull_request_template_contents`<sup>Optional</sup> <a name="pull_request_template_contents" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pullRequestTemplateContents"></a>

```python
pull_request_template_contents: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.release"></a>

```python
release: bool
```

- *Type:* bool
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `release_to_npm`<sup>Optional</sup> <a name="release_to_npm" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseToNpm"></a>

```python
release_to_npm: bool
```

- *Type:* bool
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`release_workflow`~~<sup>Optional</sup> <a name="release_workflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```python
release_workflow: bool
```

- *Type:* bool
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflow_bootstrap_steps`<sup>Optional</sup> <a name="workflow_bootstrap_steps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowBootstrapSteps"></a>

```python
workflow_bootstrap_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflow_git_identity`<sup>Optional</sup> <a name="workflow_git_identity" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowGitIdentity"></a>

```python
workflow_git_identity: GitIdentity
```

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflow_node_version`<sup>Optional</sup> <a name="workflow_node_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowNodeVersion"></a>

```python
workflow_node_version: str
```

- *Type:* str
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `disable_tsconfig`<sup>Optional</sup> <a name="disable_tsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.disableTsconfig"></a>

```python
disable_tsconfig: bool
```

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disable_tsconfig_dev`<sup>Optional</sup> <a name="disable_tsconfig_dev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.disableTsconfigDev"></a>

```python
disable_tsconfig_dev: bool
```

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.docgen"></a>

```python
docgen: bool
```

- *Type:* bool
- *Default:* false

Docgen by Typedoc.

---

##### `docs_directory`<sup>Optional</sup> <a name="docs_directory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.docsDirectory"></a>

```python
docs_directory: str
```

- *Type:* str
- *Default:* "docs"

Docs directory.

---

##### `entrypoint_types`<sup>Optional</sup> <a name="entrypoint_types" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.entrypointTypes"></a>

```python
entrypoint_types: str
```

- *Type:* str
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.eslint"></a>

```python
eslint: bool
```

- *Type:* bool
- *Default:* true

Setup eslint.

---

##### `eslint_options`<sup>Optional</sup> <a name="eslint_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.eslintOptions"></a>

```python
eslint_options: EslintOptions
```

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.libdir"></a>

```python
libdir: str
```

- *Type:* str
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcTs"></a>

```python
projenrc_ts: bool
```

- *Type:* bool
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcTsOptions"></a>

```python
projenrc_ts_options: ProjenrcOptions
```

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sample_code`<sup>Optional</sup> <a name="sample_code" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.sampleCode"></a>

```python
sample_code: bool
```

- *Type:* bool
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.srcdir"></a>

```python
srcdir: str
```

- *Type:* str
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.testdir"></a>

```python
testdir: str
```

- *Type:* str
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfig"></a>

```python
tsconfig: TypescriptConfigOptions
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfig_dev`<sup>Optional</sup> <a name="tsconfig_dev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfigDev"></a>

```python
tsconfig_dev: TypescriptConfigOptions
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfig_dev_file`<sup>Optional</sup> <a name="tsconfig_dev_file" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfigDevFile"></a>

```python
tsconfig_dev_file: str
```

- *Type:* str
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescript_version`<sup>Optional</sup> <a name="typescript_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.typescriptVersion"></a>

```python
typescript_version: str
```

- *Type:* str
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `monorepo_upgrade_deps`<sup>Optional</sup> <a name="monorepo_upgrade_deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDeps"></a>

```python
monorepo_upgrade_deps: bool
```

- *Type:* bool
- *Default:* true

Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies.

---

##### `monorepo_upgrade_deps_options`<sup>Optional</sup> <a name="monorepo_upgrade_deps_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDepsOptions"></a>

```python
monorepo_upgrade_deps_options: MonorepoUpgradeDepsOptions
```

- *Type:* aws_prototyping_sdk.nx_monorepo.MonorepoUpgradeDepsOptions
- *Default:* undefined

Monorepo Upgrade Deps options.

This is only used if monorepoUpgradeDeps is true.

---

##### `nx_config`<sup>Optional</sup> <a name="nx_config" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.nxConfig"></a>

```python
nx_config: WorkspaceConfig
```

- *Type:* aws_prototyping_sdk.nx_monorepo.Nx.WorkspaceConfig

Configuration for NX.

---

##### `workspace_config`<sup>Optional</sup> <a name="workspace_config" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workspaceConfig"></a>

```python
workspace_config: WorkspaceConfig
```

- *Type:* aws_prototyping_sdk.nx_monorepo.WorkspaceConfig

Configuration for workspace.

---

### NxRunManyOptions <a name="NxRunManyOptions" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions"></a>

> [https://nx.dev/packages/nx/documents/run-many#options](https://nx.dev/packages/nx/documents/run-many#options)

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

nx_monorepo.NxRunManyOptions(
  target: str,
  configuration: str = None,
  exclude: str = None,
  ignore_cycles: bool = None,
  no_bail: bool = None,
  output_style: str = None,
  parallel: typing.Union[int, float] = None,
  projects: typing.List[str] = None,
  runner: str = None,
  skip_cache: bool = None,
  verbose: bool = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.target">target</a></code> | <code>str</code> | Task to run for affected projects. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.configuration">configuration</a></code> | <code>str</code> | This is the configuration to use when performing tasks on projects. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.exclude">exclude</a></code> | <code>str</code> | Exclude certain projects from being processed. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.ignoreCycles">ignore_cycles</a></code> | <code>bool</code> | Ignore cycles in the task graph. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.noBail">no_bail</a></code> | <code>bool</code> | Do not stop command execution after the first failed task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.outputStyle">output_style</a></code> | <code>str</code> | Defines how Nx emits outputs tasks logs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.parallel">parallel</a></code> | <code>typing.Union[int, float]</code> | Max number of parallel processes. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.projects">projects</a></code> | <code>typing.List[str]</code> | Project to run as list project names and/or patterns. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.runner">runner</a></code> | <code>str</code> | This is the name of the tasks runner configuration in nx.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.skipCache">skip_cache</a></code> | <code>bool</code> | Rerun the tasks even when the results are available in the cache. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.verbose">verbose</a></code> | <code>bool</code> | Prints additional information about the commands (e.g. stack traces). |

---

##### `target`<sup>Required</sup> <a name="target" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.target"></a>

```python
target: str
```

- *Type:* str

Task to run for affected projects.

---

##### `configuration`<sup>Optional</sup> <a name="configuration" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.configuration"></a>

```python
configuration: str
```

- *Type:* str

This is the configuration to use when performing tasks on projects.

---

##### `exclude`<sup>Optional</sup> <a name="exclude" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.exclude"></a>

```python
exclude: str
```

- *Type:* str

Exclude certain projects from being processed.

---

##### `ignore_cycles`<sup>Optional</sup> <a name="ignore_cycles" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.ignoreCycles"></a>

```python
ignore_cycles: bool
```

- *Type:* bool

Ignore cycles in the task graph.

---

##### `no_bail`<sup>Optional</sup> <a name="no_bail" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.noBail"></a>

```python
no_bail: bool
```

- *Type:* bool

Do not stop command execution after the first failed task.

---

##### `output_style`<sup>Optional</sup> <a name="output_style" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.outputStyle"></a>

```python
output_style: str
```

- *Type:* str
- *Default:* "stream"

Defines how Nx emits outputs tasks logs.

---

##### `parallel`<sup>Optional</sup> <a name="parallel" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.parallel"></a>

```python
parallel: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* 3

Max number of parallel processes.

---

##### `projects`<sup>Optional</sup> <a name="projects" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.projects"></a>

```python
projects: typing.List[str]
```

- *Type:* typing.List[str]

Project to run as list project names and/or patterns.

---

##### `runner`<sup>Optional</sup> <a name="runner" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.runner"></a>

```python
runner: str
```

- *Type:* str

This is the name of the tasks runner configuration in nx.json.

---

##### `skip_cache`<sup>Optional</sup> <a name="skip_cache" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.skipCache"></a>

```python
skip_cache: bool
```

- *Type:* bool

Rerun the tasks even when the results are available in the cache.

---

##### `verbose`<sup>Optional</sup> <a name="verbose" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.verbose"></a>

```python
verbose: bool
```

- *Type:* bool

Prints additional information about the commands (e.g. stack traces).

---

### PDKNagAppProps <a name="PDKNagAppProps" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.Initializer"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNagAppProps(
  analytics_reporting: bool = None,
  auto_synth: bool = None,
  context: typing.Mapping[typing.Any] = None,
  default_stack_synthesizer: IReusableStackSynthesizer = None,
  outdir: str = None,
  post_cli_context: typing.Mapping[typing.Any] = None,
  stack_traces: bool = None,
  tree_metadata: bool = None,
  fail_on_error: bool = None,
  fail_on_warning: bool = None,
  nag_packs: typing.List[NagPack] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.analyticsReporting">analytics_reporting</a></code> | <code>bool</code> | Include runtime versioning information in the Stacks of this app. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.autoSynth">auto_synth</a></code> | <code>bool</code> | Automatically call `synth()` before the program exits. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.context">context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context values for the application. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.defaultStackSynthesizer">default_stack_synthesizer</a></code> | <code>aws_cdk.IReusableStackSynthesizer</code> | The stack synthesizer to use by default for all Stacks in the App. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.outdir">outdir</a></code> | <code>str</code> | The output directory into which to emit synthesized artifacts. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.postCliContext">post_cli_context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context values for the application. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.stackTraces">stack_traces</a></code> | <code>bool</code> | Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.treeMetadata">tree_metadata</a></code> | <code>bool</code> | Include construct tree metadata as part of the Cloud Assembly. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.failOnError">fail_on_error</a></code> | <code>bool</code> | Determines whether any errors encountered should trigger a test failure. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.failOnWarning">fail_on_warning</a></code> | <code>bool</code> | Determines whether any warnings encountered should trigger a test failure. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.nagPacks">nag_packs</a></code> | <code>typing.List[cdk_nag.NagPack]</code> | Custom nag packs to execute. |

---

##### `analytics_reporting`<sup>Optional</sup> <a name="analytics_reporting" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.analyticsReporting"></a>

```python
analytics_reporting: bool
```

- *Type:* bool
- *Default:* Value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in the Stacks of this app.

---

##### `auto_synth`<sup>Optional</sup> <a name="auto_synth" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.autoSynth"></a>

```python
auto_synth: bool
```

- *Type:* bool
- *Default:* true if running via CDK CLI (`CDK_OUTDIR` is set), `false` otherwise

Automatically call `synth()` before the program exits.

If you set this, you don't have to call `synth()` explicitly. Note that
this feature is only available for certain programming languages, and
calling `synth()` is still recommended.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.context"></a>

```python
context: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context values for the application.

Context set by the CLI or the `context` key in `cdk.json` has precedence.

Context can be read from any construct using `node.getContext(key)`.

---

##### `default_stack_synthesizer`<sup>Optional</sup> <a name="default_stack_synthesizer" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.defaultStackSynthesizer"></a>

```python
default_stack_synthesizer: IReusableStackSynthesizer
```

- *Type:* aws_cdk.IReusableStackSynthesizer
- *Default:* A `DefaultStackSynthesizer` with default settings

The stack synthesizer to use by default for all Stacks in the App.

The Stack Synthesizer controls aspects of synthesis and deployment,
like how assets are referenced and what IAM roles to use. For more
information, see the README of the main CDK package.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.   If `CDK_OUTDIR` is not defined, uses a temp directory.

The output directory into which to emit synthesized artifacts.

You should never need to set this value. By default, the value you pass to
the CLI's `--output` flag will be used, and if you change it to a different
directory the CLI will fail to pick up the generated Cloud Assembly.

This property is intended for internal and testing use.

---

##### `post_cli_context`<sup>Optional</sup> <a name="post_cli_context" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.postCliContext"></a>

```python
post_cli_context: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context values for the application.

Context provided here has precedence over context set by:

- The CLI via --context
- The `context` key in `cdk.json`
- The `AppProps.context` property

This property is recommended over the `AppProps.context` property since you
can make final decision over which context value to take in your app.

Context can be read from any construct using `node.getContext(key)`.

---

*Example*

```python
// context from the CLI and from `cdk.json` are stored in the
// CDK_CONTEXT env variable
const cliContext = JSON.parse(process.env.CDK_CONTEXT!);

// determine whether to take the context passed in the CLI or not
const determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
new App({
  postCliContext: {
    SOMEKEY: determineValue,
  },
});
```


##### `stack_traces`<sup>Optional</sup> <a name="stack_traces" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.stackTraces"></a>

```python
stack_traces: bool
```

- *Type:* bool
- *Default:* true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.

Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.

---

##### `tree_metadata`<sup>Optional</sup> <a name="tree_metadata" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.treeMetadata"></a>

```python
tree_metadata: bool
```

- *Type:* bool
- *Default:* true

Include construct tree metadata as part of the Cloud Assembly.

---

##### `fail_on_error`<sup>Optional</sup> <a name="fail_on_error" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.failOnError"></a>

```python
fail_on_error: bool
```

- *Type:* bool
- *Default:* false

Determines whether any errors encountered should trigger a test failure.

---

##### `fail_on_warning`<sup>Optional</sup> <a name="fail_on_warning" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.failOnWarning"></a>

```python
fail_on_warning: bool
```

- *Type:* bool
- *Default:* false

Determines whether any warnings encountered should trigger a test failure.

---

##### `nag_packs`<sup>Optional</sup> <a name="nag_packs" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.nagPacks"></a>

```python
nag_packs: typing.List[NagPack]
```

- *Type:* typing.List[cdk_nag.NagPack]
- *Default:* DEFAULT_NAG_PACKS

Custom nag packs to execute.

---

### PDKPipelineJavaProjectOptions <a name="PDKPipelineJavaProjectOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions"></a>

Configuration options for the PDKPipelineJavaProject.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.Initializer"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.PDKPipelineJavaProjectOptions(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  artifact_id: str,
  group_id: str,
  version: str,
  description: str = None,
  packaging: str = None,
  url: str = None,
  compile_options: MavenCompileOptions = None,
  deps: typing.List[str] = None,
  distdir: str = None,
  junit: bool = None,
  junit_options: JunitOptions = None,
  packaging_options: MavenPackagingOptions = None,
  projenrc_java: bool = None,
  projenrc_java_options: ProjenrcOptions = None,
  test_deps: typing.List[str] = None,
  sample: bool = None,
  sample_java_package: str = None,
  build_command: str = None,
  cdkout: str = None,
  context: typing.Mapping[typing.Any] = None,
  feature_flags: bool = None,
  require_approval: ApprovalLevel = None,
  watch_excludes: typing.List[str] = None,
  watch_includes: typing.List[str] = None,
  cdk_version: str,
  cdk_assert: bool = None,
  cdk_assertions: bool = None,
  cdk_dependencies: typing.List[str] = None,
  cdk_dependencies_as_deps: bool = None,
  cdk_test_dependencies: typing.List[str] = None,
  cdk_version_pinning: bool = None,
  constructs_version: str = None,
  main_class: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.artifactId">artifact_id</a></code> | <code>str</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.groupId">group_id</a></code> | <code>str</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.version">version</a></code> | <code>str</code> | This is the last piece of the naming puzzle. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.description">description</a></code> | <code>str</code> | Description of a project is always good. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.packaging">packaging</a></code> | <code>str</code> | Project packaging format. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.url">url</a></code> | <code>str</code> | The URL, like the name, is not required. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.compileOptions">compile_options</a></code> | <code>projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.deps">deps</a></code> | <code>typing.List[str]</code> | List of runtime dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.distdir">distdir</a></code> | <code>str</code> | Final artifact output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.junit">junit</a></code> | <code>bool</code> | Include junit tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.junitOptions">junit_options</a></code> | <code>projen.java.JunitOptions</code> | junit options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.packagingOptions">packaging_options</a></code> | <code>projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJava">projenrc_java</a></code> | <code>bool</code> | Use projenrc in java. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJavaOptions">projenrc_java_options</a></code> | <code>projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.testDeps">test_deps</a></code> | <code>typing.List[str]</code> | List of test dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.sample">sample</a></code> | <code>bool</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.sampleJavaPackage">sample_java_package</a></code> | <code>str</code> | The java package to use for the code sample. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.buildCommand">build_command</a></code> | <code>str</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkout">cdkout</a></code> | <code>str</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.context">context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.featureFlags">feature_flags</a></code> | <code>bool</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.requireApproval">require_approval</a></code> | <code>projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.watchExcludes">watch_excludes</a></code> | <code>typing.List[str]</code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.watchIncludes">watch_includes</a></code> | <code>typing.List[str]</code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkVersion">cdk_version</a></code> | <code>str</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkAssert">cdk_assert</a></code> | <code>bool</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkAssertions">cdk_assertions</a></code> | <code>bool</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkDependencies">cdk_dependencies</a></code> | <code>typing.List[str]</code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkDependenciesAsDeps">cdk_dependencies_as_deps</a></code> | <code>bool</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkTestDependencies">cdk_test_dependencies</a></code> | <code>typing.List[str]</code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkVersionPinning">cdk_version_pinning</a></code> | <code>bool</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.constructsVersion">constructs_version</a></code> | <code>str</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mainClass">main_class</a></code> | <code>str</code> | The name of the Java class with the static `main()` method. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.name"></a>

```python
name: str
```

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitIgnoreOptions"></a>

```python
git_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitOptions"></a>

```python
git_options: GitOptions
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.logging"></a>

```python
logging: LoggerOptions
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJson"></a>

```python
projenrc_json: bool
```

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJsonOptions"></a>

```python
projenrc_json_options: ProjenrcJsonOptions
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.renovatebot"></a>

```python
renovatebot: bool
```

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.renovatebotOptions"></a>

```python
renovatebot_options: RenovatebotOptions
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoApproveOptions"></a>

```python
auto_approve_options: AutoApproveOptions
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoMerge"></a>

```python
auto_merge: bool
```

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoMergeOptions"></a>

```python
auto_merge_options: AutoMergeOptions
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.clobber"></a>

```python
clobber: bool
```

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.devContainer"></a>

```python
dev_container: bool
```

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.github"></a>

```python
github: bool
```

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.githubOptions"></a>

```python
github_options: GitHubOptions
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitpod"></a>

```python
gitpod: bool
```

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```python
mergify: bool
```

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```python
mergify_options: MergifyOptions
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenCredentials"></a>

```python
projen_credentials: GithubCredentials
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```python
projen_token_secret: str
```

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.readme"></a>

```python
readme: SampleReadmeProps
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.stale"></a>

```python
stale: bool
```

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.staleOptions"></a>

```python
stale_options: StaleOptions
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.vscode"></a>

```python
vscode: bool
```

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifact_id`<sup>Required</sup> <a name="artifact_id" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.artifactId"></a>

```python
artifact_id: str
```

- *Type:* str
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `group_id`<sup>Required</sup> <a name="group_id" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.groupId"></a>

```python
group_id: str
```

- *Type:* str
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.version"></a>

```python
version: str
```

- *Type:* str
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.description"></a>

```python
description: str
```

- *Type:* str
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.packaging"></a>

```python
packaging: str
```

- *Type:* str
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.url"></a>

```python
url: str
```

- *Type:* str
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compile_options`<sup>Optional</sup> <a name="compile_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.compileOptions"></a>

```python
compile_options: MavenCompileOptions
```

- *Type:* projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.deps"></a>

```python
deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.distdir"></a>

```python
distdir: str
```

- *Type:* str
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.junit"></a>

```python
junit: bool
```

- *Type:* bool
- *Default:* true

Include junit tests.

---

##### `junit_options`<sup>Optional</sup> <a name="junit_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.junitOptions"></a>

```python
junit_options: JunitOptions
```

- *Type:* projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packaging_options`<sup>Optional</sup> <a name="packaging_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.packagingOptions"></a>

```python
packaging_options: MavenPackagingOptions
```

- *Type:* projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrc_java`<sup>Optional</sup> <a name="projenrc_java" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJava"></a>

```python
projenrc_java: bool
```

- *Type:* bool
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrc_java_options`<sup>Optional</sup> <a name="projenrc_java_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJavaOptions"></a>

```python
projenrc_java_options: ProjenrcOptions
```

- *Type:* projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `test_deps`<sup>Optional</sup> <a name="test_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.testDeps"></a>

```python
test_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.sample"></a>

```python
sample: bool
```

- *Type:* bool
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sample_java_package`<sup>Optional</sup> <a name="sample_java_package" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.sampleJavaPackage"></a>

```python
sample_java_package: str
```

- *Type:* str
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `build_command`<sup>Optional</sup> <a name="build_command" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.buildCommand"></a>

```python
build_command: str
```

- *Type:* str
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkout"></a>

```python
cdkout: str
```

- *Type:* str
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.context"></a>

```python
context: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `feature_flags`<sup>Optional</sup> <a name="feature_flags" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.featureFlags"></a>

```python
feature_flags: bool
```

- *Type:* bool
- *Default:* true

Include all feature flags in cdk.json.

---

##### `require_approval`<sup>Optional</sup> <a name="require_approval" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.requireApproval"></a>

```python
require_approval: ApprovalLevel
```

- *Type:* projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watch_excludes`<sup>Optional</sup> <a name="watch_excludes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.watchExcludes"></a>

```python
watch_excludes: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watch_includes`<sup>Optional</sup> <a name="watch_includes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.watchIncludes"></a>

```python
watch_includes: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdk_version`<sup>Required</sup> <a name="cdk_version" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkVersion"></a>

```python
cdk_version: str
```

- *Type:* str
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdk_assert`~~<sup>Optional</sup> <a name="cdk_assert" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkAssert"></a>

- *Deprecated:* The

```python
cdk_assert: bool
```

- *Type:* bool
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdk_assertions`<sup>Optional</sup> <a name="cdk_assertions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkAssertions"></a>

```python
cdk_assertions: bool
```

- *Type:* bool
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdk_dependencies`~~<sup>Optional</sup> <a name="cdk_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

```python
cdk_dependencies: typing.List[str]
```

- *Type:* typing.List[str]

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdk_dependencies_as_deps`~~<sup>Optional</sup> <a name="cdk_dependencies_as_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

```python
cdk_dependencies_as_deps: bool
```

- *Type:* bool
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdk_test_dependencies`~~<sup>Optional</sup> <a name="cdk_test_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

```python
cdk_test_dependencies: typing.List[str]
```

- *Type:* typing.List[str]

AWS CDK modules required for testing.

---

##### `cdk_version_pinning`<sup>Optional</sup> <a name="cdk_version_pinning" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkVersionPinning"></a>

```python
cdk_version_pinning: bool
```

- *Type:* bool

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructs_version`<sup>Optional</sup> <a name="constructs_version" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.constructsVersion"></a>

```python
constructs_version: str
```

- *Type:* str
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `main_class`<sup>Required</sup> <a name="main_class" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mainClass"></a>

```python
main_class: str
```

- *Type:* str
- *Default:* "org.acme.MyApp"

The name of the Java class with the static `main()` method.

This method
should call `app.synth()` on the CDK app.

---

### PDKPipelineProps <a name="PDKPipelineProps" id="aws-prototyping-sdk.pipeline.PDKPipelineProps"></a>

Properties to configure the PDKPipeline.

Note: Due to limitations with JSII and generic support it should be noted that
the synth, synthShellStepPartialProps.input and
synthShellStepPartialProps.primaryOutputDirectory properties will be ignored
if passed in to this construct.

synthShellStepPartialProps.commands is marked as a required field, however
if you pass in [] the default commands of this construct will be retained.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.Initializer"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.PDKPipelineProps(
  synth: IFileSetProducer,
  asset_publishing_code_build_defaults: CodeBuildOptions = None,
  cli_version: str = None,
  code_build_defaults: CodeBuildOptions = None,
  code_pipeline: Pipeline = None,
  cross_account_keys: bool = None,
  docker_credentials: typing.List[DockerCredential] = None,
  docker_enabled_for_self_mutation: bool = None,
  docker_enabled_for_synth: bool = None,
  enable_key_rotation: bool = None,
  pipeline_name: str = None,
  publish_assets_in_parallel: bool = None,
  reuse_cross_region_support_stacks: bool = None,
  role: IRole = None,
  self_mutation: bool = None,
  self_mutation_code_build_defaults: CodeBuildOptions = None,
  synth_code_build_defaults: CodeBuildOptions = None,
  use_change_sets: bool = None,
  primary_synth_directory: str,
  repository_name: str,
  code_commit_removal_policy: RemovalPolicy = None,
  default_branch_name: str = None,
  sonar_code_scanner_config: SonarCodeScannerConfig = None,
  synth_shell_step_partial_props: ShellStepProps = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synth">synth</a></code> | <code>aws_cdk.pipelines.IFileSetProducer</code> | The build step that produces the CDK Cloud Assembly. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.assetPublishingCodeBuildDefaults">asset_publishing_code_build_defaults</a></code> | <code>aws_cdk.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the asset publishing CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.cliVersion">cli_version</a></code> | <code>str</code> | CDK CLI version to use in self-mutation and asset publishing steps. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codeBuildDefaults">code_build_defaults</a></code> | <code>aws_cdk.pipelines.CodeBuildOptions</code> | Customize the CodeBuild projects created for this pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codePipeline">code_pipeline</a></code> | <code>aws_cdk.aws_codepipeline.Pipeline</code> | An existing Pipeline to be reused and built upon. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.crossAccountKeys">cross_account_keys</a></code> | <code>bool</code> | Create KMS keys for the artifact buckets, allowing cross-account deployments. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerCredentials">docker_credentials</a></code> | <code>typing.List[aws_cdk.pipelines.DockerCredential]</code> | A list of credentials used to authenticate to Docker registries. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerEnabledForSelfMutation">docker_enabled_for_self_mutation</a></code> | <code>bool</code> | Enable Docker for the self-mutate step. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerEnabledForSynth">docker_enabled_for_synth</a></code> | <code>bool</code> | Enable Docker for the 'synth' step. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.enableKeyRotation">enable_key_rotation</a></code> | <code>bool</code> | Enable KMS key rotation for the generated KMS keys. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.pipelineName">pipeline_name</a></code> | <code>str</code> | The name of the CodePipeline pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.publishAssetsInParallel">publish_assets_in_parallel</a></code> | <code>bool</code> | Publish assets in multiple CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.reuseCrossRegionSupportStacks">reuse_cross_region_support_stacks</a></code> | <code>bool</code> | Reuse the same cross region support stack for all pipelines in the App. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.role">role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | The IAM role to be assumed by this Pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.selfMutation">self_mutation</a></code> | <code>bool</code> | Whether the pipeline will update itself. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.selfMutationCodeBuildDefaults">self_mutation_code_build_defaults</a></code> | <code>aws_cdk.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the self mutation CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synthCodeBuildDefaults">synth_code_build_defaults</a></code> | <code>aws_cdk.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the synthesize CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.useChangeSets">use_change_sets</a></code> | <code>bool</code> | Deploy every stack by creating a change set and executing it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.primarySynthDirectory">primary_synth_directory</a></code> | <code>str</code> | Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.repositoryName">repository_name</a></code> | <code>str</code> | Name of the CodeCommit repository to create. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codeCommitRemovalPolicy">code_commit_removal_policy</a></code> | <code>aws_cdk.RemovalPolicy</code> | Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.defaultBranchName">default_branch_name</a></code> | <code>str</code> | Branch to trigger the pipeline execution. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.sonarCodeScannerConfig">sonar_code_scanner_config</a></code> | <code>aws_prototyping_sdk.pipeline.SonarCodeScannerConfig</code> | Configuration for enabling Sonarqube code scanning on a successful synth. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synthShellStepPartialProps">synth_shell_step_partial_props</a></code> | <code>aws_cdk.pipelines.ShellStepProps</code> | PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands. |

---

##### `synth`<sup>Required</sup> <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synth"></a>

```python
synth: IFileSetProducer
```

- *Type:* aws_cdk.pipelines.IFileSetProducer

The build step that produces the CDK Cloud Assembly.

The primary output of this step needs to be the `cdk.out` directory
generated by the `cdk synth` command.

If you use a `ShellStep` here and you don't configure an output directory,
the output directory will automatically be assumed to be `cdk.out`.

---

##### `asset_publishing_code_build_defaults`<sup>Optional</sup> <a name="asset_publishing_code_build_defaults" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.assetPublishingCodeBuildDefaults"></a>

```python
asset_publishing_code_build_defaults: CodeBuildOptions
```

- *Type:* aws_cdk.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the asset publishing CodeBuild projects.

---

##### `cli_version`<sup>Optional</sup> <a name="cli_version" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.cliVersion"></a>

```python
cli_version: str
```

- *Type:* str
- *Default:* Latest version

CDK CLI version to use in self-mutation and asset publishing steps.

If you want to lock the CDK CLI version used in the pipeline, by steps
that are automatically generated for you, specify the version here.

We recommend you do not specify this value, as not specifying it always
uses the latest CLI version which is backwards compatible with old versions.

If you do specify it, be aware that this version should always be equal to or higher than the
version of the CDK framework used by the CDK app, when the CDK commands are
run during your pipeline execution. When you change this version, the *next
time* the `SelfMutate` step runs it will still be using the CLI of the the
*previous* version that was in this property: it will only start using the
new version after `SelfMutate` completes successfully. That means that if
you want to update both framework and CLI version, you should update the
CLI version first, commit, push and deploy, and only then update the
framework version.

---

##### `code_build_defaults`<sup>Optional</sup> <a name="code_build_defaults" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codeBuildDefaults"></a>

```python
code_build_defaults: CodeBuildOptions
```

- *Type:* aws_cdk.pipelines.CodeBuildOptions
- *Default:* All projects run non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_6_0

Customize the CodeBuild projects created for this pipeline.

---

##### `code_pipeline`<sup>Optional</sup> <a name="code_pipeline" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codePipeline"></a>

```python
code_pipeline: Pipeline
```

- *Type:* aws_cdk.aws_codepipeline.Pipeline
- *Default:* a new underlying pipeline is created.

An existing Pipeline to be reused and built upon.

[disable-awslint:ref-via-interface]

---

##### `cross_account_keys`<sup>Optional</sup> <a name="cross_account_keys" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.crossAccountKeys"></a>

```python
cross_account_keys: bool
```

- *Type:* bool
- *Default:* false

Create KMS keys for the artifact buckets, allowing cross-account deployments.

The artifact buckets have to be encrypted to support deploying CDK apps to
another account, so if you want to do that or want to have your artifact
buckets encrypted, be sure to set this value to `true`.

Be aware there is a cost associated with maintaining the KMS keys.

---

##### `docker_credentials`<sup>Optional</sup> <a name="docker_credentials" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerCredentials"></a>

```python
docker_credentials: typing.List[DockerCredential]
```

- *Type:* typing.List[aws_cdk.pipelines.DockerCredential]
- *Default:* []

A list of credentials used to authenticate to Docker registries.

Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.

---

##### `docker_enabled_for_self_mutation`<sup>Optional</sup> <a name="docker_enabled_for_self_mutation" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerEnabledForSelfMutation"></a>

```python
docker_enabled_for_self_mutation: bool
```

- *Type:* bool
- *Default:* false

Enable Docker for the self-mutate step.

Set this to true if the pipeline itself uses Docker container assets
(for example, if you use `LinuxBuildImage.fromAsset()` as the build
image of a CodeBuild step in the pipeline).

You do not need to set it if you build Docker image assets in the
application Stages and Stacks that are *deployed* by this pipeline.

Configures privileged mode for the self-mutation CodeBuild action.

If you are about to turn this on in an already-deployed Pipeline,
set the value to `true` first, commit and allow the pipeline to
self-update, and only then use the Docker asset in the pipeline.

---

##### `docker_enabled_for_synth`<sup>Optional</sup> <a name="docker_enabled_for_synth" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerEnabledForSynth"></a>

```python
docker_enabled_for_synth: bool
```

- *Type:* bool
- *Default:* false

Enable Docker for the 'synth' step.

Set this to true if you are using file assets that require
"bundling" anywhere in your application (meaning an asset
compilation step will be run with the tools provided by
a Docker image), both for the Pipeline stack as well as the
application stacks.

A common way to use bundling assets in your application is by
using the `@aws-cdk/aws-lambda-nodejs` library.

Configures privileged mode for the synth CodeBuild action.

If you are about to turn this on in an already-deployed Pipeline,
set the value to `true` first, commit and allow the pipeline to
self-update, and only then use the bundled asset.

---

##### `enable_key_rotation`<sup>Optional</sup> <a name="enable_key_rotation" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.enableKeyRotation"></a>

```python
enable_key_rotation: bool
```

- *Type:* bool
- *Default:* false (key rotation is disabled)

Enable KMS key rotation for the generated KMS keys.

By default KMS key rotation is disabled, but will add
additional costs when enabled.

---

##### `pipeline_name`<sup>Optional</sup> <a name="pipeline_name" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.pipelineName"></a>

```python
pipeline_name: str
```

- *Type:* str
- *Default:* Automatically generated

The name of the CodePipeline pipeline.

---

##### `publish_assets_in_parallel`<sup>Optional</sup> <a name="publish_assets_in_parallel" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.publishAssetsInParallel"></a>

```python
publish_assets_in_parallel: bool
```

- *Type:* bool
- *Default:* true

Publish assets in multiple CodeBuild projects.

If set to false, use one Project per type to publish all assets.

Publishing in parallel improves concurrency and may reduce publishing
latency, but may also increase overall provisioning time of the CodeBuild
projects.

Experiment and see what value works best for you.

---

##### `reuse_cross_region_support_stacks`<sup>Optional</sup> <a name="reuse_cross_region_support_stacks" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.reuseCrossRegionSupportStacks"></a>

```python
reuse_cross_region_support_stacks: bool
```

- *Type:* bool
- *Default:* true (Use the same support stack for all pipelines in App)

Reuse the same cross region support stack for all pipelines in the App.

---

##### `role`<sup>Optional</sup> <a name="role" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.role"></a>

```python
role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole
- *Default:* A new role is created

The IAM role to be assumed by this Pipeline.

---

##### `self_mutation`<sup>Optional</sup> <a name="self_mutation" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.selfMutation"></a>

```python
self_mutation: bool
```

- *Type:* bool
- *Default:* true

Whether the pipeline will update itself.

This needs to be set to `true` to allow the pipeline to reconfigure
itself when assets or stages are being added to it, and `true` is the
recommended setting.

You can temporarily set this to `false` while you are iterating
on the pipeline itself and prefer to deploy changes using `cdk deploy`.

---

##### `self_mutation_code_build_defaults`<sup>Optional</sup> <a name="self_mutation_code_build_defaults" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.selfMutationCodeBuildDefaults"></a>

```python
self_mutation_code_build_defaults: CodeBuildOptions
```

- *Type:* aws_cdk.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the self mutation CodeBuild projects.

---

##### `synth_code_build_defaults`<sup>Optional</sup> <a name="synth_code_build_defaults" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synthCodeBuildDefaults"></a>

```python
synth_code_build_defaults: CodeBuildOptions
```

- *Type:* aws_cdk.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the synthesize CodeBuild projects.

---

##### `use_change_sets`<sup>Optional</sup> <a name="use_change_sets" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.useChangeSets"></a>

```python
use_change_sets: bool
```

- *Type:* bool
- *Default:* true

Deploy every stack by creating a change set and executing it.

When enabled, creates a "Prepare" and "Execute" action for each stack. Disable
to deploy the stack in one pipeline action.

---

##### `primary_synth_directory`<sup>Required</sup> <a name="primary_synth_directory" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.primarySynthDirectory"></a>

```python
primary_synth_directory: str
```

- *Type:* str

Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out.

---

##### `repository_name`<sup>Required</sup> <a name="repository_name" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.repositoryName"></a>

```python
repository_name: str
```

- *Type:* str

Name of the CodeCommit repository to create.

---

##### `code_commit_removal_policy`<sup>Optional</sup> <a name="code_commit_removal_policy" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codeCommitRemovalPolicy"></a>

```python
code_commit_removal_policy: RemovalPolicy
```

- *Type:* aws_cdk.RemovalPolicy

Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation.

---

##### `default_branch_name`<sup>Optional</sup> <a name="default_branch_name" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.defaultBranchName"></a>

```python
default_branch_name: str
```

- *Type:* str
- *Default:* mainline

Branch to trigger the pipeline execution.

---

##### `sonar_code_scanner_config`<sup>Optional</sup> <a name="sonar_code_scanner_config" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.sonarCodeScannerConfig"></a>

```python
sonar_code_scanner_config: SonarCodeScannerConfig
```

- *Type:* aws_prototyping_sdk.pipeline.SonarCodeScannerConfig
- *Default:* undefined

Configuration for enabling Sonarqube code scanning on a successful synth.

---

##### `synth_shell_step_partial_props`<sup>Optional</sup> <a name="synth_shell_step_partial_props" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synthShellStepPartialProps"></a>

```python
synth_shell_step_partial_props: ShellStepProps
```

- *Type:* aws_cdk.pipelines.ShellStepProps

PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands.

To override these defaults
and/or provide additional inputs, specify env settings, etc you can provide
a partial ShellStepProps.

---

### PDKPipelinePyProjectOptions <a name="PDKPipelinePyProjectOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions"></a>

Configuration options for the PDKPipelinePyProject.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.Initializer"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.PDKPipelinePyProjectOptions(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  author_email: str,
  author_name: str,
  version: str,
  classifiers: typing.List[str] = None,
  description: str = None,
  homepage: str = None,
  license: str = None,
  package_name: str = None,
  poetry_options: PoetryPyprojectOptionsWithoutDeps = None,
  setup_config: typing.Mapping[typing.Any] = None,
  module_name: str,
  deps: typing.List[str] = None,
  dev_deps: typing.List[str] = None,
  pip: bool = None,
  poetry: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projenrc_python: bool = None,
  projenrc_python_options: ProjenrcOptions = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcTsOptions = None,
  pytest: bool = None,
  pytest_options: PytestOptions = None,
  sample: bool = None,
  setuptools: bool = None,
  venv: bool = None,
  venv_options: VenvOptions = None,
  build_command: str = None,
  cdkout: str = None,
  context: typing.Mapping[typing.Any] = None,
  feature_flags: bool = None,
  require_approval: ApprovalLevel = None,
  watch_excludes: typing.List[str] = None,
  watch_includes: typing.List[str] = None,
  cdk_version: str,
  cdk_assert: bool = None,
  cdk_assertions: bool = None,
  cdk_dependencies: typing.List[str] = None,
  cdk_dependencies_as_deps: bool = None,
  cdk_test_dependencies: typing.List[str] = None,
  cdk_version_pinning: bool = None,
  constructs_version: str = None,
  app_entrypoint: str = None,
  testdir: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.version">version</a></code> | <code>str</code> | Version of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.classifiers">classifiers</a></code> | <code>typing.List[str]</code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.description">description</a></code> | <code>str</code> | A short description of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.homepage">homepage</a></code> | <code>str</code> | A URL to the website of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.license">license</a></code> | <code>str</code> | License of this package as an SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.packageName">package_name</a></code> | <code>str</code> | Package name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.poetryOptions">poetry_options</a></code> | <code>projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.setupConfig">setup_config</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.moduleName">module_name</a></code> | <code>str</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.deps">deps</a></code> | <code>typing.List[str]</code> | List of runtime dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | List of dev dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pip">pip</a></code> | <code>bool</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.poetry">poetry</a></code> | <code>bool</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Use projenrc in javascript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcPython">projenrc_python</a></code> | <code>bool</code> | Use projenrc in Python. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcPythonOptions">projenrc_python_options</a></code> | <code>projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use projenrc in TypeScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pytest">pytest</a></code> | <code>bool</code> | Include pytest tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pytestOptions">pytest_options</a></code> | <code>projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.sample">sample</a></code> | <code>bool</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.setuptools">setuptools</a></code> | <code>bool</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.venv">venv</a></code> | <code>bool</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.venvOptions">venv_options</a></code> | <code>projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.buildCommand">build_command</a></code> | <code>str</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkout">cdkout</a></code> | <code>str</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.context">context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.featureFlags">feature_flags</a></code> | <code>bool</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.requireApproval">require_approval</a></code> | <code>projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.watchExcludes">watch_excludes</a></code> | <code>typing.List[str]</code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.watchIncludes">watch_includes</a></code> | <code>typing.List[str]</code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkVersion">cdk_version</a></code> | <code>str</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkAssert">cdk_assert</a></code> | <code>bool</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkAssertions">cdk_assertions</a></code> | <code>bool</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkDependencies">cdk_dependencies</a></code> | <code>typing.List[str]</code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkDependenciesAsDeps">cdk_dependencies_as_deps</a></code> | <code>bool</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkTestDependencies">cdk_test_dependencies</a></code> | <code>typing.List[str]</code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkVersionPinning">cdk_version_pinning</a></code> | <code>bool</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.constructsVersion">constructs_version</a></code> | <code>str</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.appEntrypoint">app_entrypoint</a></code> | <code>str</code> | The CDK app's entrypoint (relative to the source directory, which is "src" by default). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.testdir">testdir</a></code> | <code>str</code> | Python sources directory. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.name"></a>

```python
name: str
```

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitIgnoreOptions"></a>

```python
git_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitOptions"></a>

```python
git_options: GitOptions
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.logging"></a>

```python
logging: LoggerOptions
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJson"></a>

```python
projenrc_json: bool
```

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJsonOptions"></a>

```python
projenrc_json_options: ProjenrcJsonOptions
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.renovatebot"></a>

```python
renovatebot: bool
```

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.renovatebotOptions"></a>

```python
renovatebot_options: RenovatebotOptions
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoApproveOptions"></a>

```python
auto_approve_options: AutoApproveOptions
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoMerge"></a>

```python
auto_merge: bool
```

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoMergeOptions"></a>

```python
auto_merge_options: AutoMergeOptions
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.clobber"></a>

```python
clobber: bool
```

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.devContainer"></a>

```python
dev_container: bool
```

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.github"></a>

```python
github: bool
```

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.githubOptions"></a>

```python
github_options: GitHubOptions
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitpod"></a>

```python
gitpod: bool
```

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```python
mergify: bool
```

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```python
mergify_options: MergifyOptions
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenCredentials"></a>

```python
projen_credentials: GithubCredentials
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```python
projen_token_secret: str
```

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.readme"></a>

```python
readme: SampleReadmeProps
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.stale"></a>

```python
stale: bool
```

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.staleOptions"></a>

```python
stale_options: StaleOptions
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.vscode"></a>

```python
vscode: bool
```

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `author_email`<sup>Required</sup> <a name="author_email" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.authorEmail"></a>

```python
author_email: str
```

- *Type:* str
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `author_name`<sup>Required</sup> <a name="author_name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.authorName"></a>

```python
author_name: str
```

- *Type:* str
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.version"></a>

```python
version: str
```

- *Type:* str
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.classifiers"></a>

```python
classifiers: typing.List[str]
```

- *Type:* typing.List[str]

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.description"></a>

```python
description: str
```

- *Type:* str

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.homepage"></a>

```python
homepage: str
```

- *Type:* str

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.license"></a>

```python
license: str
```

- *Type:* str

License of this package as an SPDX identifier.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.packageName"></a>

```python
package_name: str
```

- *Type:* str

Package name.

---

##### `poetry_options`<sup>Optional</sup> <a name="poetry_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.poetryOptions"></a>

```python
poetry_options: PoetryPyprojectOptionsWithoutDeps
```

- *Type:* projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setup_config`<sup>Optional</sup> <a name="setup_config" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.setupConfig"></a>

```python
setup_config: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]

Additional fields to pass in the setup() function if using setuptools.

---

##### `module_name`<sup>Required</sup> <a name="module_name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.moduleName"></a>

```python
module_name: str
```

- *Type:* str
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.deps"></a>

```python
deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.devDeps"></a>

```python
dev_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pip"></a>

```python
pip: bool
```

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.poetry"></a>

```python
poetry: bool
```

- *Type:* bool
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJs"></a>

```python
projenrc_js: bool
```

- *Type:* bool
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJsOptions"></a>

```python
projenrc_js_options: ProjenrcOptions
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrc_python`<sup>Optional</sup> <a name="projenrc_python" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcPython"></a>

```python
projenrc_python: bool
```

- *Type:* bool
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrc_python_options`<sup>Optional</sup> <a name="projenrc_python_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcPythonOptions"></a>

```python
projenrc_python_options: ProjenrcOptions
```

- *Type:* projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcTs"></a>

```python
projenrc_ts: bool
```

- *Type:* bool
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcTsOptions"></a>

```python
projenrc_ts_options: ProjenrcTsOptions
```

- *Type:* projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pytest"></a>

```python
pytest: bool
```

- *Type:* bool
- *Default:* true

Include pytest tests.

---

##### `pytest_options`<sup>Optional</sup> <a name="pytest_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pytestOptions"></a>

```python
pytest_options: PytestOptions
```

- *Type:* projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.sample"></a>

```python
sample: bool
```

- *Type:* bool
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.setuptools"></a>

```python
setuptools: bool
```

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.venv"></a>

```python
venv: bool
```

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venv_options`<sup>Optional</sup> <a name="venv_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.venvOptions"></a>

```python
venv_options: VenvOptions
```

- *Type:* projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `build_command`<sup>Optional</sup> <a name="build_command" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.buildCommand"></a>

```python
build_command: str
```

- *Type:* str
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkout"></a>

```python
cdkout: str
```

- *Type:* str
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.context"></a>

```python
context: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `feature_flags`<sup>Optional</sup> <a name="feature_flags" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.featureFlags"></a>

```python
feature_flags: bool
```

- *Type:* bool
- *Default:* true

Include all feature flags in cdk.json.

---

##### `require_approval`<sup>Optional</sup> <a name="require_approval" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.requireApproval"></a>

```python
require_approval: ApprovalLevel
```

- *Type:* projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watch_excludes`<sup>Optional</sup> <a name="watch_excludes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.watchExcludes"></a>

```python
watch_excludes: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watch_includes`<sup>Optional</sup> <a name="watch_includes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.watchIncludes"></a>

```python
watch_includes: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdk_version`<sup>Required</sup> <a name="cdk_version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkVersion"></a>

```python
cdk_version: str
```

- *Type:* str
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdk_assert`~~<sup>Optional</sup> <a name="cdk_assert" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkAssert"></a>

- *Deprecated:* The

```python
cdk_assert: bool
```

- *Type:* bool
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdk_assertions`<sup>Optional</sup> <a name="cdk_assertions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkAssertions"></a>

```python
cdk_assertions: bool
```

- *Type:* bool
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdk_dependencies`~~<sup>Optional</sup> <a name="cdk_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

```python
cdk_dependencies: typing.List[str]
```

- *Type:* typing.List[str]

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdk_dependencies_as_deps`~~<sup>Optional</sup> <a name="cdk_dependencies_as_deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

```python
cdk_dependencies_as_deps: bool
```

- *Type:* bool
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdk_test_dependencies`~~<sup>Optional</sup> <a name="cdk_test_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

```python
cdk_test_dependencies: typing.List[str]
```

- *Type:* typing.List[str]

AWS CDK modules required for testing.

---

##### `cdk_version_pinning`<sup>Optional</sup> <a name="cdk_version_pinning" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkVersionPinning"></a>

```python
cdk_version_pinning: bool
```

- *Type:* bool

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructs_version`<sup>Optional</sup> <a name="constructs_version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.constructsVersion"></a>

```python
constructs_version: str
```

- *Type:* str
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `app_entrypoint`<sup>Optional</sup> <a name="app_entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.appEntrypoint"></a>

```python
app_entrypoint: str
```

- *Type:* str
- *Default:* "app.py"

The CDK app's entrypoint (relative to the source directory, which is "src" by default).

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.testdir"></a>

```python
testdir: str
```

- *Type:* str
- *Default:* "tests"

Python sources directory.

---

### PDKPipelineTsProjectOptions <a name="PDKPipelineTsProjectOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions"></a>

Configuration options for the PDKPipelineTsProject.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.Initializer"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.PDKPipelineTsProjectOptions(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  allow_library_dependencies: bool = None,
  author_email: str = None,
  author_name: str = None,
  author_organization: bool = None,
  author_url: str = None,
  auto_detect_bin: bool = None,
  bin: typing.Mapping[str] = None,
  bugs_email: str = None,
  bugs_url: str = None,
  bundled_deps: typing.List[str] = None,
  code_artifact_options: CodeArtifactOptions = None,
  deps: typing.List[str] = None,
  description: str = None,
  dev_deps: typing.List[str] = None,
  entrypoint: str = None,
  homepage: str = None,
  keywords: typing.List[str] = None,
  license: str = None,
  licensed: bool = None,
  max_node_version: str = None,
  min_node_version: str = None,
  npm_access: NpmAccess = None,
  npm_registry: str = None,
  npm_registry_url: str = None,
  npm_token_secret: str = None,
  package_manager: NodePackageManager = None,
  package_name: str = None,
  peer_dependency_options: PeerDependencyOptions = None,
  peer_deps: typing.List[str] = None,
  pnpm_version: str = None,
  repository: str = None,
  repository_directory: str = None,
  scoped_packages_options: typing.List[ScopedPackagesOptions] = None,
  scripts: typing.Mapping[str] = None,
  stability: str = None,
  jsii_release_version: str = None,
  major_version: typing.Union[int, float] = None,
  min_major_version: typing.Union[int, float] = None,
  npm_dist_tag: str = None,
  post_build_steps: typing.List[JobStep] = None,
  prerelease: str = None,
  publish_dry_run: bool = None,
  publish_tasks: bool = None,
  release_branches: typing.Mapping[BranchOptions] = None,
  release_every_commit: bool = None,
  release_failure_issue: bool = None,
  release_failure_issue_label: str = None,
  release_schedule: str = None,
  release_tag_prefix: str = None,
  release_trigger: ReleaseTrigger = None,
  release_workflow_name: str = None,
  release_workflow_setup_steps: typing.List[JobStep] = None,
  versionrc_options: typing.Mapping[typing.Any] = None,
  workflow_container_image: str = None,
  workflow_runs_on: typing.List[str] = None,
  default_release_branch: str,
  artifacts_directory: str = None,
  auto_approve_upgrades: bool = None,
  build_workflow: bool = None,
  build_workflow_triggers: Triggers = None,
  bundler_options: BundlerOptions = None,
  code_cov: bool = None,
  code_cov_token_secret: str = None,
  copyright_owner: str = None,
  copyright_period: str = None,
  dependabot: bool = None,
  dependabot_options: DependabotOptions = None,
  deps_upgrade: bool = None,
  deps_upgrade_options: UpgradeDependenciesOptions = None,
  gitignore: typing.List[str] = None,
  jest: bool = None,
  jest_options: JestOptions = None,
  mutable_build: bool = None,
  npmignore: typing.List[str] = None,
  npmignore_enabled: bool = None,
  npm_ignore_options: IgnoreFileOptions = None,
  package: bool = None,
  prettier: bool = None,
  prettier_options: PrettierOptions = None,
  projen_dev_dependency: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projen_version: str = None,
  pull_request_template: bool = None,
  pull_request_template_contents: typing.List[str] = None,
  release: bool = None,
  release_to_npm: bool = None,
  release_workflow: bool = None,
  workflow_bootstrap_steps: typing.List[JobStep] = None,
  workflow_git_identity: GitIdentity = None,
  workflow_node_version: str = None,
  disable_tsconfig: bool = None,
  disable_tsconfig_dev: bool = None,
  docgen: bool = None,
  docs_directory: str = None,
  entrypoint_types: str = None,
  eslint: bool = None,
  eslint_options: EslintOptions = None,
  libdir: str = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcOptions = None,
  sample_code: bool = None,
  srcdir: str = None,
  testdir: str = None,
  tsconfig: TypescriptConfigOptions = None,
  tsconfig_dev: TypescriptConfigOptions = None,
  tsconfig_dev_file: str = None,
  typescript_version: str = None,
  build_command: str = None,
  cdkout: str = None,
  context: typing.Mapping[typing.Any] = None,
  feature_flags: bool = None,
  require_approval: ApprovalLevel = None,
  watch_excludes: typing.List[str] = None,
  watch_includes: typing.List[str] = None,
  cdk_version: str,
  cdk_assert: bool = None,
  cdk_assertions: bool = None,
  cdk_dependencies: typing.List[str] = None,
  cdk_dependencies_as_deps: bool = None,
  cdk_test_dependencies: typing.List[str] = None,
  cdk_version_pinning: bool = None,
  constructs_version: str = None,
  app_entrypoint: str = None,
  edge_lambda_auto_discover: bool = None,
  integration_test_auto_discover: bool = None,
  lambda_auto_discover: bool = None,
  lambda_extension_auto_discover: bool = None,
  lambda_options: LambdaFunctionCommonOptions = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorOrganization">author_organization</a></code> | <code>bool</code> | Is the author an organization. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorUrl">author_url</a></code> | <code>str</code> | Author's URL / Website. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoDetectBin">auto_detect_bin</a></code> | <code>bool</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bin">bin</a></code> | <code>typing.Mapping[str]</code> | Binary programs vended with your module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bugsEmail">bugs_email</a></code> | <code>str</code> | The email address to which issues should be reported. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bugsUrl">bugs_url</a></code> | <code>str</code> | The url to your project's issue tracker. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bundledDeps">bundled_deps</a></code> | <code>typing.List[str]</code> | List of dependencies to bundle into this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeArtifactOptions">code_artifact_options</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.deps">deps</a></code> | <code>typing.List[str]</code> | Runtime dependencies of this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.description">description</a></code> | <code>str</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | Build dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.entrypoint">entrypoint</a></code> | <code>str</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.homepage">homepage</a></code> | <code>str</code> | Package's Homepage / Website. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.keywords">keywords</a></code> | <code>typing.List[str]</code> | Keywords to include in `package.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.license">license</a></code> | <code>str</code> | License's SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.licensed">licensed</a></code> | <code>bool</code> | Indicates if a license should be added. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmAccess">npm_access</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmRegistry">npm_registry</a></code> | <code>str</code> | The host name of the npm registry to publish to. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmRegistryUrl">npm_registry_url</a></code> | <code>str</code> | The base URL of the npm package registry. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmTokenSecret">npm_token_secret</a></code> | <code>str</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.packageName">package_name</a></code> | <code>str</code> | The "name" in package.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.peerDependencyOptions">peer_dependency_options</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.peerDeps">peer_deps</a></code> | <code>typing.List[str]</code> | Peer dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pnpmVersion">pnpm_version</a></code> | <code>str</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.repository">repository</a></code> | <code>str</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.repositoryDirectory">repository_directory</a></code> | <code>str</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.scopedPackagesOptions">scoped_packages_options</a></code> | <code>typing.List[projen.javascript.ScopedPackagesOptions]</code> | Options for privately hosted scoped packages. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.scripts">scripts</a></code> | <code>typing.Mapping[str]</code> | npm scripts to include. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.stability">stability</a></code> | <code>str</code> | Package's Stability. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jsiiReleaseVersion">jsii_release_version</a></code> | <code>str</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.majorVersion">major_version</a></code> | <code>typing.Union[int, float]</code> | Major version to release from the default branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.minMajorVersion">min_major_version</a></code> | <code>typing.Union[int, float]</code> | Minimal Major version to release. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmDistTag">npm_dist_tag</a></code> | <code>str</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.postBuildSteps">post_build_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prerelease">prerelease</a></code> | <code>str</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.publishDryRun">publish_dry_run</a></code> | <code>bool</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.publishTasks">publish_tasks</a></code> | <code>bool</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseBranches">release_branches</a></code> | <code>typing.Mapping[projen.release.BranchOptions]</code> | Defines additional release branches. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseEveryCommit">release_every_commit</a></code> | <code>bool</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseFailureIssue">release_failure_issue</a></code> | <code>bool</code> | Create a github issue on every failed publishing task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseFailureIssueLabel">release_failure_issue_label</a></code> | <code>str</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseSchedule">release_schedule</a></code> | <code>str</code> | CRON schedule to trigger new releases. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseTagPrefix">release_tag_prefix</a></code> | <code>str</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseTrigger">release_trigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflowName">release_workflow_name</a></code> | <code>str</code> | The name of the default release workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflowSetupSteps">release_workflow_setup_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.versionrcOptions">versionrc_options</a></code> | <code>typing.Mapping[typing.Any]</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowContainerImage">workflow_container_image</a></code> | <code>str</code> | Container image to use for GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowRunsOn">workflow_runs_on</a></code> | <code>typing.List[str]</code> | Github Runner selection labels. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.defaultReleaseBranch">default_release_branch</a></code> | <code>str</code> | The name of the main release branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | A directory which will contain build artifacts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoApproveUpgrades">auto_approve_upgrades</a></code> | <code>bool</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildWorkflow">build_workflow</a></code> | <code>bool</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildWorkflowTriggers">build_workflow_triggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bundlerOptions">bundler_options</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeCov">code_cov</a></code> | <code>bool</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeCovTokenSecret">code_cov_token_secret</a></code> | <code>str</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.copyrightOwner">copyright_owner</a></code> | <code>str</code> | License copyright owner. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.copyrightPeriod">copyright_period</a></code> | <code>str</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.dependabot">dependabot</a></code> | <code>bool</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.dependabotOptions">dependabot_options</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.depsUpgrade">deps_upgrade</a></code> | <code>bool</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.depsUpgradeOptions">deps_upgrade_options</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitignore">gitignore</a></code> | <code>typing.List[str]</code> | Additional entries to .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jest">jest</a></code> | <code>bool</code> | Setup jest unit tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jestOptions">jest_options</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mutableBuild">mutable_build</a></code> | <code>bool</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmignore">npmignore</a></code> | <code>typing.List[str]</code> | Additional entries to .npmignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmignoreEnabled">npmignore_enabled</a></code> | <code>bool</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmIgnoreOptions">npm_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.package">package</a></code> | <code>bool</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prettier">prettier</a></code> | <code>bool</code> | Setup prettier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prettierOptions">prettier_options</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenDevDependency">projen_dev_dependency</a></code> | <code>bool</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenVersion">projen_version</a></code> | <code>str</code> | Version of projen to install. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pullRequestTemplate">pull_request_template</a></code> | <code>bool</code> | Include a GitHub pull request template. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pullRequestTemplateContents">pull_request_template_contents</a></code> | <code>typing.List[str]</code> | The contents of the pull request template. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.release">release</a></code> | <code>bool</code> | Add release management to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseToNpm">release_to_npm</a></code> | <code>bool</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflow">release_workflow</a></code> | <code>bool</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowBootstrapSteps">workflow_bootstrap_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowGitIdentity">workflow_git_identity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowNodeVersion">workflow_node_version</a></code> | <code>str</code> | The node version to use in GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.disableTsconfig">disable_tsconfig</a></code> | <code>bool</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.disableTsconfigDev">disable_tsconfig_dev</a></code> | <code>bool</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.docgen">docgen</a></code> | <code>bool</code> | Docgen by Typedoc. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.docsDirectory">docs_directory</a></code> | <code>str</code> | Docs directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.entrypointTypes">entrypoint_types</a></code> | <code>str</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.eslint">eslint</a></code> | <code>bool</code> | Setup eslint. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.eslintOptions">eslint_options</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.libdir">libdir</a></code> | <code>str</code> | Typescript  artifacts output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.sampleCode">sample_code</a></code> | <code>bool</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.srcdir">srcdir</a></code> | <code>str</code> | Typescript sources directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.testdir">testdir</a></code> | <code>str</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfigDevFile">tsconfig_dev_file</a></code> | <code>str</code> | The name of the development tsconfig.json file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.typescriptVersion">typescript_version</a></code> | <code>str</code> | TypeScript version to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildCommand">build_command</a></code> | <code>str</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkout">cdkout</a></code> | <code>str</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.context">context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.featureFlags">feature_flags</a></code> | <code>bool</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.requireApproval">require_approval</a></code> | <code>projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.watchExcludes">watch_excludes</a></code> | <code>typing.List[str]</code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.watchIncludes">watch_includes</a></code> | <code>typing.List[str]</code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkVersion">cdk_version</a></code> | <code>str</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkAssert">cdk_assert</a></code> | <code>bool</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkAssertions">cdk_assertions</a></code> | <code>bool</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkDependencies">cdk_dependencies</a></code> | <code>typing.List[str]</code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkDependenciesAsDeps">cdk_dependencies_as_deps</a></code> | <code>bool</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkTestDependencies">cdk_test_dependencies</a></code> | <code>typing.List[str]</code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkVersionPinning">cdk_version_pinning</a></code> | <code>bool</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.constructsVersion">constructs_version</a></code> | <code>str</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.appEntrypoint">app_entrypoint</a></code> | <code>str</code> | The CDK app's entrypoint (relative to the source directory, which is "src" by default). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.edgeLambdaAutoDiscover">edge_lambda_auto_discover</a></code> | <code>bool</code> | Automatically adds an `cloudfront.experimental.EdgeFunction` for each `.edge-lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.integrationTestAutoDiscover">integration_test_auto_discover</a></code> | <code>bool</code> | Automatically discovers and creates integration tests for each `.integ.ts` file in under your test directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaAutoDiscover">lambda_auto_discover</a></code> | <code>bool</code> | Automatically adds an `awscdk.LambdaFunction` for each `.lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaExtensionAutoDiscover">lambda_extension_auto_discover</a></code> | <code>bool</code> | Automatically adds an `awscdk.LambdaExtension` for each `.lambda-extension.ts` entrypoint in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaOptions">lambda_options</a></code> | <code>projen.awscdk.LambdaFunctionCommonOptions</code> | Common options for all AWS Lambda functions. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.name"></a>

```python
name: str
```

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitIgnoreOptions"></a>

```python
git_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitOptions"></a>

```python
git_options: GitOptions
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.logging"></a>

```python
logging: LoggerOptions
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJson"></a>

```python
projenrc_json: bool
```

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJsonOptions"></a>

```python
projenrc_json_options: ProjenrcJsonOptions
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.renovatebot"></a>

```python
renovatebot: bool
```

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.renovatebotOptions"></a>

```python
renovatebot_options: RenovatebotOptions
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoApproveOptions"></a>

```python
auto_approve_options: AutoApproveOptions
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoMerge"></a>

```python
auto_merge: bool
```

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoMergeOptions"></a>

```python
auto_merge_options: AutoMergeOptions
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.clobber"></a>

```python
clobber: bool
```

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.devContainer"></a>

```python
dev_container: bool
```

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.github"></a>

```python
github: bool
```

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.githubOptions"></a>

```python
github_options: GitHubOptions
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitpod"></a>

```python
gitpod: bool
```

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```python
mergify: bool
```

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```python
mergify_options: MergifyOptions
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenCredentials"></a>

```python
projen_credentials: GithubCredentials
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```python
projen_token_secret: str
```

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.readme"></a>

```python
readme: SampleReadmeProps
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.stale"></a>

```python
stale: bool
```

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.staleOptions"></a>

```python
stale_options: StaleOptions
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.vscode"></a>

```python
vscode: bool
```

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allow_library_dependencies`<sup>Optional</sup> <a name="allow_library_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.allowLibraryDependencies"></a>

```python
allow_library_dependencies: bool
```

- *Type:* bool
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `author_email`<sup>Optional</sup> <a name="author_email" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorEmail"></a>

```python
author_email: str
```

- *Type:* str

Author's e-mail.

---

##### `author_name`<sup>Optional</sup> <a name="author_name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorName"></a>

```python
author_name: str
```

- *Type:* str

Author's name.

---

##### `author_organization`<sup>Optional</sup> <a name="author_organization" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorOrganization"></a>

```python
author_organization: bool
```

- *Type:* bool

Is the author an organization.

---

##### `author_url`<sup>Optional</sup> <a name="author_url" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorUrl"></a>

```python
author_url: str
```

- *Type:* str

Author's URL / Website.

---

##### `auto_detect_bin`<sup>Optional</sup> <a name="auto_detect_bin" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoDetectBin"></a>

```python
auto_detect_bin: bool
```

- *Type:* bool
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bin"></a>

```python
bin: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugs_email`<sup>Optional</sup> <a name="bugs_email" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bugsEmail"></a>

```python
bugs_email: str
```

- *Type:* str

The email address to which issues should be reported.

---

##### `bugs_url`<sup>Optional</sup> <a name="bugs_url" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bugsUrl"></a>

```python
bugs_url: str
```

- *Type:* str

The url to your project's issue tracker.

---

##### `bundled_deps`<sup>Optional</sup> <a name="bundled_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bundledDeps"></a>

```python
bundled_deps: typing.List[str]
```

- *Type:* typing.List[str]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `code_artifact_options`<sup>Optional</sup> <a name="code_artifact_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeArtifactOptions"></a>

```python
code_artifact_options: CodeArtifactOptions
```

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.deps"></a>

```python
deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.description"></a>

```python
description: str
```

- *Type:* str

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.devDeps"></a>

```python
dev_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.entrypoint"></a>

```python
entrypoint: str
```

- *Type:* str
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.homepage"></a>

```python
homepage: str
```

- *Type:* str

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.keywords"></a>

```python
keywords: typing.List[str]
```

- *Type:* typing.List[str]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.license"></a>

```python
license: str
```

- *Type:* str
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.licensed"></a>

```python
licensed: bool
```

- *Type:* bool
- *Default:* true

Indicates if a license should be added.

---

##### `max_node_version`<sup>Optional</sup> <a name="max_node_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.maxNodeVersion"></a>

```python
max_node_version: str
```

- *Type:* str
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `min_node_version`<sup>Optional</sup> <a name="min_node_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.minNodeVersion"></a>

```python
min_node_version: str
```

- *Type:* str
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npm_access`<sup>Optional</sup> <a name="npm_access" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmAccess"></a>

```python
npm_access: NpmAccess
```

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npm_registry`~~<sup>Optional</sup> <a name="npm_registry" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```python
npm_registry: str
```

- *Type:* str

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npm_registry_url`<sup>Optional</sup> <a name="npm_registry_url" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmRegistryUrl"></a>

```python
npm_registry_url: str
```

- *Type:* str
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npm_token_secret`<sup>Optional</sup> <a name="npm_token_secret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmTokenSecret"></a>

```python
npm_token_secret: str
```

- *Type:* str
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `package_manager`<sup>Optional</sup> <a name="package_manager" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.packageManager"></a>

```python
package_manager: NodePackageManager
```

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.packageName"></a>

```python
package_name: str
```

- *Type:* str
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peer_dependency_options`<sup>Optional</sup> <a name="peer_dependency_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.peerDependencyOptions"></a>

```python
peer_dependency_options: PeerDependencyOptions
```

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peer_deps`<sup>Optional</sup> <a name="peer_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.peerDeps"></a>

```python
peer_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpm_version`<sup>Optional</sup> <a name="pnpm_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pnpmVersion"></a>

```python
pnpm_version: str
```

- *Type:* str
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.repository"></a>

```python
repository: str
```

- *Type:* str

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repository_directory`<sup>Optional</sup> <a name="repository_directory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.repositoryDirectory"></a>

```python
repository_directory: str
```

- *Type:* str

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scoped_packages_options`<sup>Optional</sup> <a name="scoped_packages_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.scopedPackagesOptions"></a>

```python
scoped_packages_options: typing.List[ScopedPackagesOptions]
```

- *Type:* typing.List[projen.javascript.ScopedPackagesOptions]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```python
scripts: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.stability"></a>

```python
stability: str
```

- *Type:* str

Package's Stability.

---

##### `jsii_release_version`<sup>Optional</sup> <a name="jsii_release_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jsiiReleaseVersion"></a>

```python
jsii_release_version: str
```

- *Type:* str
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `major_version`<sup>Optional</sup> <a name="major_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.majorVersion"></a>

```python
major_version: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `min_major_version`<sup>Optional</sup> <a name="min_major_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.minMajorVersion"></a>

```python
min_major_version: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npm_dist_tag`<sup>Optional</sup> <a name="npm_dist_tag" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmDistTag"></a>

```python
npm_dist_tag: str
```

- *Type:* str
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `post_build_steps`<sup>Optional</sup> <a name="post_build_steps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.postBuildSteps"></a>

```python
post_build_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prerelease"></a>

```python
prerelease: str
```

- *Type:* str
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publish_dry_run`<sup>Optional</sup> <a name="publish_dry_run" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.publishDryRun"></a>

```python
publish_dry_run: bool
```

- *Type:* bool
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publish_tasks`<sup>Optional</sup> <a name="publish_tasks" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.publishTasks"></a>

```python
publish_tasks: bool
```

- *Type:* bool
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `release_branches`<sup>Optional</sup> <a name="release_branches" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseBranches"></a>

```python
release_branches: typing.Mapping[BranchOptions]
```

- *Type:* typing.Mapping[projen.release.BranchOptions]
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`release_every_commit`~~<sup>Optional</sup> <a name="release_every_commit" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```python
release_every_commit: bool
```

- *Type:* bool
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `release_failure_issue`<sup>Optional</sup> <a name="release_failure_issue" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseFailureIssue"></a>

```python
release_failure_issue: bool
```

- *Type:* bool
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `release_failure_issue_label`<sup>Optional</sup> <a name="release_failure_issue_label" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseFailureIssueLabel"></a>

```python
release_failure_issue_label: str
```

- *Type:* str
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`release_schedule`~~<sup>Optional</sup> <a name="release_schedule" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```python
release_schedule: str
```

- *Type:* str
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `release_tag_prefix`<sup>Optional</sup> <a name="release_tag_prefix" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseTagPrefix"></a>

```python
release_tag_prefix: str
```

- *Type:* str
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `release_trigger`<sup>Optional</sup> <a name="release_trigger" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseTrigger"></a>

```python
release_trigger: ReleaseTrigger
```

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `release_workflow_name`<sup>Optional</sup> <a name="release_workflow_name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflowName"></a>

```python
release_workflow_name: str
```

- *Type:* str
- *Default:* "Release"

The name of the default release workflow.

---

##### `release_workflow_setup_steps`<sup>Optional</sup> <a name="release_workflow_setup_steps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflowSetupSteps"></a>

```python
release_workflow_setup_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrc_options`<sup>Optional</sup> <a name="versionrc_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.versionrcOptions"></a>

```python
versionrc_options: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflow_container_image`<sup>Optional</sup> <a name="workflow_container_image" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowContainerImage"></a>

```python
workflow_container_image: str
```

- *Type:* str
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflow_runs_on`<sup>Optional</sup> <a name="workflow_runs_on" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowRunsOn"></a>

```python
workflow_runs_on: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `default_release_branch`<sup>Required</sup> <a name="default_release_branch" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.defaultReleaseBranch"></a>

```python
default_release_branch: str
```

- *Type:* str
- *Default:* "main"

The name of the main release branch.

---

##### `artifacts_directory`<sup>Optional</sup> <a name="artifacts_directory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.artifactsDirectory"></a>

```python
artifacts_directory: str
```

- *Type:* str
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `auto_approve_upgrades`<sup>Optional</sup> <a name="auto_approve_upgrades" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoApproveUpgrades"></a>

```python
auto_approve_upgrades: bool
```

- *Type:* bool
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `build_workflow`<sup>Optional</sup> <a name="build_workflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildWorkflow"></a>

```python
build_workflow: bool
```

- *Type:* bool
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `build_workflow_triggers`<sup>Optional</sup> <a name="build_workflow_triggers" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildWorkflowTriggers"></a>

```python
build_workflow_triggers: Triggers
```

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundler_options`<sup>Optional</sup> <a name="bundler_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bundlerOptions"></a>

```python
bundler_options: BundlerOptions
```

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `code_cov`<sup>Optional</sup> <a name="code_cov" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeCov"></a>

```python
code_cov: bool
```

- *Type:* bool
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret.

---

##### `code_cov_token_secret`<sup>Optional</sup> <a name="code_cov_token_secret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeCovTokenSecret"></a>

```python
code_cov_token_secret: str
```

- *Type:* str
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyright_owner`<sup>Optional</sup> <a name="copyright_owner" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.copyrightOwner"></a>

```python
copyright_owner: str
```

- *Type:* str
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyright_period`<sup>Optional</sup> <a name="copyright_period" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.copyrightPeriod"></a>

```python
copyright_period: str
```

- *Type:* str
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.dependabot"></a>

```python
dependabot: bool
```

- *Type:* bool
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabot_options`<sup>Optional</sup> <a name="dependabot_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.dependabotOptions"></a>

```python
dependabot_options: DependabotOptions
```

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `deps_upgrade`<sup>Optional</sup> <a name="deps_upgrade" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.depsUpgrade"></a>

```python
deps_upgrade: bool
```

- *Type:* bool
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `deps_upgrade_options`<sup>Optional</sup> <a name="deps_upgrade_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.depsUpgradeOptions"></a>

```python
deps_upgrade_options: UpgradeDependenciesOptions
```

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitignore"></a>

```python
gitignore: typing.List[str]
```

- *Type:* typing.List[str]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jest"></a>

```python
jest: bool
```

- *Type:* bool
- *Default:* true

Setup jest unit tests.

---

##### `jest_options`<sup>Optional</sup> <a name="jest_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jestOptions"></a>

```python
jest_options: JestOptions
```

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutable_build`<sup>Optional</sup> <a name="mutable_build" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mutableBuild"></a>

```python
mutable_build: bool
```

- *Type:* bool
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```python
npmignore: typing.List[str]
```

- *Type:* typing.List[str]

Additional entries to .npmignore.

---

##### `npmignore_enabled`<sup>Optional</sup> <a name="npmignore_enabled" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmignoreEnabled"></a>

```python
npmignore_enabled: bool
```

- *Type:* bool
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npm_ignore_options`<sup>Optional</sup> <a name="npm_ignore_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmIgnoreOptions"></a>

```python
npm_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.package"></a>

```python
package: bool
```

- *Type:* bool
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prettier"></a>

```python
prettier: bool
```

- *Type:* bool
- *Default:* false

Setup prettier.

---

##### `prettier_options`<sup>Optional</sup> <a name="prettier_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prettierOptions"></a>

```python
prettier_options: PrettierOptions
```

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projen_dev_dependency`<sup>Optional</sup> <a name="projen_dev_dependency" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenDevDependency"></a>

```python
projen_dev_dependency: bool
```

- *Type:* bool
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJs"></a>

```python
projenrc_js: bool
```

- *Type:* bool
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJsOptions"></a>

```python
projenrc_js_options: ProjenrcOptions
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projen_version`<sup>Optional</sup> <a name="projen_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenVersion"></a>

```python
projen_version: str
```

- *Type:* str
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pull_request_template`<sup>Optional</sup> <a name="pull_request_template" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pullRequestTemplate"></a>

```python
pull_request_template: bool
```

- *Type:* bool
- *Default:* true

Include a GitHub pull request template.

---

##### `pull_request_template_contents`<sup>Optional</sup> <a name="pull_request_template_contents" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pullRequestTemplateContents"></a>

```python
pull_request_template_contents: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.release"></a>

```python
release: bool
```

- *Type:* bool
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `release_to_npm`<sup>Optional</sup> <a name="release_to_npm" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseToNpm"></a>

```python
release_to_npm: bool
```

- *Type:* bool
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`release_workflow`~~<sup>Optional</sup> <a name="release_workflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```python
release_workflow: bool
```

- *Type:* bool
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflow_bootstrap_steps`<sup>Optional</sup> <a name="workflow_bootstrap_steps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowBootstrapSteps"></a>

```python
workflow_bootstrap_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflow_git_identity`<sup>Optional</sup> <a name="workflow_git_identity" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowGitIdentity"></a>

```python
workflow_git_identity: GitIdentity
```

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflow_node_version`<sup>Optional</sup> <a name="workflow_node_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowNodeVersion"></a>

```python
workflow_node_version: str
```

- *Type:* str
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `disable_tsconfig`<sup>Optional</sup> <a name="disable_tsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.disableTsconfig"></a>

```python
disable_tsconfig: bool
```

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disable_tsconfig_dev`<sup>Optional</sup> <a name="disable_tsconfig_dev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.disableTsconfigDev"></a>

```python
disable_tsconfig_dev: bool
```

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.docgen"></a>

```python
docgen: bool
```

- *Type:* bool
- *Default:* false

Docgen by Typedoc.

---

##### `docs_directory`<sup>Optional</sup> <a name="docs_directory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.docsDirectory"></a>

```python
docs_directory: str
```

- *Type:* str
- *Default:* "docs"

Docs directory.

---

##### `entrypoint_types`<sup>Optional</sup> <a name="entrypoint_types" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.entrypointTypes"></a>

```python
entrypoint_types: str
```

- *Type:* str
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.eslint"></a>

```python
eslint: bool
```

- *Type:* bool
- *Default:* true

Setup eslint.

---

##### `eslint_options`<sup>Optional</sup> <a name="eslint_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.eslintOptions"></a>

```python
eslint_options: EslintOptions
```

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.libdir"></a>

```python
libdir: str
```

- *Type:* str
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcTs"></a>

```python
projenrc_ts: bool
```

- *Type:* bool
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcTsOptions"></a>

```python
projenrc_ts_options: ProjenrcOptions
```

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sample_code`<sup>Optional</sup> <a name="sample_code" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.sampleCode"></a>

```python
sample_code: bool
```

- *Type:* bool
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.srcdir"></a>

```python
srcdir: str
```

- *Type:* str
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.testdir"></a>

```python
testdir: str
```

- *Type:* str
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfig"></a>

```python
tsconfig: TypescriptConfigOptions
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfig_dev`<sup>Optional</sup> <a name="tsconfig_dev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfigDev"></a>

```python
tsconfig_dev: TypescriptConfigOptions
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfig_dev_file`<sup>Optional</sup> <a name="tsconfig_dev_file" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfigDevFile"></a>

```python
tsconfig_dev_file: str
```

- *Type:* str
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescript_version`<sup>Optional</sup> <a name="typescript_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.typescriptVersion"></a>

```python
typescript_version: str
```

- *Type:* str
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `build_command`<sup>Optional</sup> <a name="build_command" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildCommand"></a>

```python
build_command: str
```

- *Type:* str
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkout"></a>

```python
cdkout: str
```

- *Type:* str
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.context"></a>

```python
context: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `feature_flags`<sup>Optional</sup> <a name="feature_flags" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.featureFlags"></a>

```python
feature_flags: bool
```

- *Type:* bool
- *Default:* true

Include all feature flags in cdk.json.

---

##### `require_approval`<sup>Optional</sup> <a name="require_approval" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.requireApproval"></a>

```python
require_approval: ApprovalLevel
```

- *Type:* projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watch_excludes`<sup>Optional</sup> <a name="watch_excludes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.watchExcludes"></a>

```python
watch_excludes: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watch_includes`<sup>Optional</sup> <a name="watch_includes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.watchIncludes"></a>

```python
watch_includes: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdk_version`<sup>Required</sup> <a name="cdk_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkVersion"></a>

```python
cdk_version: str
```

- *Type:* str
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdk_assert`~~<sup>Optional</sup> <a name="cdk_assert" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkAssert"></a>

- *Deprecated:* The

```python
cdk_assert: bool
```

- *Type:* bool
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdk_assertions`<sup>Optional</sup> <a name="cdk_assertions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkAssertions"></a>

```python
cdk_assertions: bool
```

- *Type:* bool
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdk_dependencies`~~<sup>Optional</sup> <a name="cdk_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

```python
cdk_dependencies: typing.List[str]
```

- *Type:* typing.List[str]

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdk_dependencies_as_deps`~~<sup>Optional</sup> <a name="cdk_dependencies_as_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

```python
cdk_dependencies_as_deps: bool
```

- *Type:* bool
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdk_test_dependencies`~~<sup>Optional</sup> <a name="cdk_test_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

```python
cdk_test_dependencies: typing.List[str]
```

- *Type:* typing.List[str]

AWS CDK modules required for testing.

---

##### `cdk_version_pinning`<sup>Optional</sup> <a name="cdk_version_pinning" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkVersionPinning"></a>

```python
cdk_version_pinning: bool
```

- *Type:* bool

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructs_version`<sup>Optional</sup> <a name="constructs_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.constructsVersion"></a>

```python
constructs_version: str
```

- *Type:* str
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `app_entrypoint`<sup>Optional</sup> <a name="app_entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.appEntrypoint"></a>

```python
app_entrypoint: str
```

- *Type:* str
- *Default:* "main.ts"

The CDK app's entrypoint (relative to the source directory, which is "src" by default).

---

##### `edge_lambda_auto_discover`<sup>Optional</sup> <a name="edge_lambda_auto_discover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.edgeLambdaAutoDiscover"></a>

```python
edge_lambda_auto_discover: bool
```

- *Type:* bool
- *Default:* true

Automatically adds an `cloudfront.experimental.EdgeFunction` for each `.edge-lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `integration_test_auto_discover`<sup>Optional</sup> <a name="integration_test_auto_discover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.integrationTestAutoDiscover"></a>

```python
integration_test_auto_discover: bool
```

- *Type:* bool
- *Default:* true

Automatically discovers and creates integration tests for each `.integ.ts` file in under your test directory.

---

##### `lambda_auto_discover`<sup>Optional</sup> <a name="lambda_auto_discover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaAutoDiscover"></a>

```python
lambda_auto_discover: bool
```

- *Type:* bool
- *Default:* true

Automatically adds an `awscdk.LambdaFunction` for each `.lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `lambda_extension_auto_discover`<sup>Optional</sup> <a name="lambda_extension_auto_discover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaExtensionAutoDiscover"></a>

```python
lambda_extension_auto_discover: bool
```

- *Type:* bool
- *Default:* true

Automatically adds an `awscdk.LambdaExtension` for each `.lambda-extension.ts` entrypoint in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `lambda_options`<sup>Optional</sup> <a name="lambda_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaOptions"></a>

```python
lambda_options: LambdaFunctionCommonOptions
```

- *Type:* projen.awscdk.LambdaFunctionCommonOptions
- *Default:* default options

Common options for all AWS Lambda functions.

---

### SemverGroup <a name="SemverGroup" id="aws-prototyping-sdk.nx_monorepo.SemverGroup"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

nx_monorepo.SemverGroup(
  dependencies: typing.List[str],
  packages: typing.List[str],
  range: str,
  dependency_types: typing.List[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SemverGroup.property.dependencies">dependencies</a></code> | <code>typing.List[str]</code> | the names of the dependencies (eg. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SemverGroup.property.packages">packages</a></code> | <code>typing.List[str]</code> | the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SemverGroup.property.range">range</a></code> | <code>str</code> | the semver range which dependencies in this group should use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SemverGroup.property.dependencyTypes">dependency_types</a></code> | <code>typing.List[str]</code> | optionally only apply this group to dependencies of the provided types. |

---

##### `dependencies`<sup>Required</sup> <a name="dependencies" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.property.dependencies"></a>

```python
dependencies: typing.List[str]
```

- *Type:* typing.List[str]

the names of the dependencies (eg.

"lodash") which belong to this group

---

##### `packages`<sup>Required</sup> <a name="packages" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.property.packages"></a>

```python
packages: typing.List[str]
```

- *Type:* typing.List[str]

the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name.

---

##### `range`<sup>Required</sup> <a name="range" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.property.range"></a>

```python
range: str
```

- *Type:* str

the semver range which dependencies in this group should use.

---

##### `dependency_types`<sup>Optional</sup> <a name="dependency_types" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.property.dependencyTypes"></a>

```python
dependency_types: typing.List[str]
```

- *Type:* typing.List[str]

optionally only apply this group to dependencies of the provided types.

---

### SonarCodeScannerConfig <a name="SonarCodeScannerConfig" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.Initializer"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.SonarCodeScannerConfig(
  sonarqube_authorized_group: str,
  sonarqube_default_profile_or_gate_name: str,
  sonarqube_endpoint: str,
  sonarqube_project_name: str,
  cdk_out_dir: str = None,
  cfn_nag_ignore_path: str = None,
  exclude_globs_for_scan: typing.List[str] = None,
  include_globs_for_scan: typing.List[str] = None,
  pre_archive_commands: typing.List[str] = None,
  sonarqube_specific_profile_or_gate_name: str = None,
  sonarqube_tags: typing.List[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeAuthorizedGroup">sonarqube_authorized_group</a></code> | <code>str</code> | Group name in Sonarqube with access to administer this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeDefaultProfileOrGateName">sonarqube_default_profile_or_gate_name</a></code> | <code>str</code> | Default profile/gate name i.e: your org profile. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeEndpoint">sonarqube_endpoint</a></code> | <code>str</code> | endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeProjectName">sonarqube_project_name</a></code> | <code>str</code> | Name of the project to create in Sonarqube. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.cdkOutDir">cdk_out_dir</a></code> | <code>str</code> | directory containing the synthesized cdk resources. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.cfnNagIgnorePath">cfn_nag_ignore_path</a></code> | <code>str</code> | path to a file containing the cfn nag suppression rules. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.excludeGlobsForScan">exclude_globs_for_scan</a></code> | <code>typing.List[str]</code> | glob patterns to exclude from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.includeGlobsForScan">include_globs_for_scan</a></code> | <code>typing.List[str]</code> | glob patterns to include from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.preArchiveCommands">pre_archive_commands</a></code> | <code>typing.List[str]</code> | Hook which allows custom commands to be executed before the process commences the archival process. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeSpecificProfileOrGateName">sonarqube_specific_profile_or_gate_name</a></code> | <code>str</code> | Specific profile/gate name i.e: language specific. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeTags">sonarqube_tags</a></code> | <code>typing.List[str]</code> | Tags to associate with this project. |

---

##### `sonarqube_authorized_group`<sup>Required</sup> <a name="sonarqube_authorized_group" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeAuthorizedGroup"></a>

```python
sonarqube_authorized_group: str
```

- *Type:* str

Group name in Sonarqube with access to administer this project.

---

##### `sonarqube_default_profile_or_gate_name`<sup>Required</sup> <a name="sonarqube_default_profile_or_gate_name" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeDefaultProfileOrGateName"></a>

```python
sonarqube_default_profile_or_gate_name: str
```

- *Type:* str

Default profile/gate name i.e: your org profile.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqube_endpoint`<sup>Required</sup> <a name="sonarqube_endpoint" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeEndpoint"></a>

```python
sonarqube_endpoint: str
```

- *Type:* str

endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>.

Note: Ensure a trailing '/' is not included.

---

##### `sonarqube_project_name`<sup>Required</sup> <a name="sonarqube_project_name" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeProjectName"></a>

```python
sonarqube_project_name: str
```

- *Type:* str

Name of the project to create in Sonarqube.

---

##### `cdk_out_dir`<sup>Optional</sup> <a name="cdk_out_dir" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.cdkOutDir"></a>

```python
cdk_out_dir: str
```

- *Type:* str

directory containing the synthesized cdk resources.

---

##### `cfn_nag_ignore_path`<sup>Optional</sup> <a name="cfn_nag_ignore_path" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.cfnNagIgnorePath"></a>

```python
cfn_nag_ignore_path: str
```

- *Type:* str

path to a file containing the cfn nag suppression rules.

---

##### `exclude_globs_for_scan`<sup>Optional</sup> <a name="exclude_globs_for_scan" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.excludeGlobsForScan"></a>

```python
exclude_globs_for_scan: typing.List[str]
```

- *Type:* typing.List[str]

glob patterns to exclude from sonar scan.

---

##### `include_globs_for_scan`<sup>Optional</sup> <a name="include_globs_for_scan" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.includeGlobsForScan"></a>

```python
include_globs_for_scan: typing.List[str]
```

- *Type:* typing.List[str]

glob patterns to include from sonar scan.

---

##### `pre_archive_commands`<sup>Optional</sup> <a name="pre_archive_commands" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.preArchiveCommands"></a>

```python
pre_archive_commands: typing.List[str]
```

- *Type:* typing.List[str]

Hook which allows custom commands to be executed before the process commences the archival process.

---

##### `sonarqube_specific_profile_or_gate_name`<sup>Optional</sup> <a name="sonarqube_specific_profile_or_gate_name" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeSpecificProfileOrGateName"></a>

```python
sonarqube_specific_profile_or_gate_name: str
```

- *Type:* str

Specific profile/gate name i.e: language specific.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqube_tags`<sup>Optional</sup> <a name="sonarqube_tags" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeTags"></a>

```python
sonarqube_tags: typing.List[str]
```

- *Type:* typing.List[str]

Tags to associate with this project.

---

### SonarCodeScannerProps <a name="SonarCodeScannerProps" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps"></a>

SonarCodeScanners properties.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.Initializer"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.SonarCodeScannerProps(
  sonarqube_authorized_group: str,
  sonarqube_default_profile_or_gate_name: str,
  sonarqube_endpoint: str,
  sonarqube_project_name: str,
  cdk_out_dir: str = None,
  cfn_nag_ignore_path: str = None,
  exclude_globs_for_scan: typing.List[str] = None,
  include_globs_for_scan: typing.List[str] = None,
  pre_archive_commands: typing.List[str] = None,
  sonarqube_specific_profile_or_gate_name: str = None,
  sonarqube_tags: typing.List[str] = None,
  artifact_bucket_arn: str,
  synth_build_arn: str,
  artifact_bucket_key_arn: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeAuthorizedGroup">sonarqube_authorized_group</a></code> | <code>str</code> | Group name in Sonarqube with access to administer this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeDefaultProfileOrGateName">sonarqube_default_profile_or_gate_name</a></code> | <code>str</code> | Default profile/gate name i.e: your org profile. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeEndpoint">sonarqube_endpoint</a></code> | <code>str</code> | endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeProjectName">sonarqube_project_name</a></code> | <code>str</code> | Name of the project to create in Sonarqube. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.cdkOutDir">cdk_out_dir</a></code> | <code>str</code> | directory containing the synthesized cdk resources. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.cfnNagIgnorePath">cfn_nag_ignore_path</a></code> | <code>str</code> | path to a file containing the cfn nag suppression rules. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.excludeGlobsForScan">exclude_globs_for_scan</a></code> | <code>typing.List[str]</code> | glob patterns to exclude from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.includeGlobsForScan">include_globs_for_scan</a></code> | <code>typing.List[str]</code> | glob patterns to include from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.preArchiveCommands">pre_archive_commands</a></code> | <code>typing.List[str]</code> | Hook which allows custom commands to be executed before the process commences the archival process. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeSpecificProfileOrGateName">sonarqube_specific_profile_or_gate_name</a></code> | <code>str</code> | Specific profile/gate name i.e: language specific. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeTags">sonarqube_tags</a></code> | <code>typing.List[str]</code> | Tags to associate with this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.artifactBucketArn">artifact_bucket_arn</a></code> | <code>str</code> | S3 bucket ARN containing the built artifacts from the synth build. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.synthBuildArn">synth_build_arn</a></code> | <code>str</code> | ARN for the CodeBuild task responsible for executing the synth command. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.artifactBucketKeyArn">artifact_bucket_key_arn</a></code> | <code>str</code> | Artifact bucket key ARN used to encrypt the artifacts. |

---

##### `sonarqube_authorized_group`<sup>Required</sup> <a name="sonarqube_authorized_group" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeAuthorizedGroup"></a>

```python
sonarqube_authorized_group: str
```

- *Type:* str

Group name in Sonarqube with access to administer this project.

---

##### `sonarqube_default_profile_or_gate_name`<sup>Required</sup> <a name="sonarqube_default_profile_or_gate_name" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeDefaultProfileOrGateName"></a>

```python
sonarqube_default_profile_or_gate_name: str
```

- *Type:* str

Default profile/gate name i.e: your org profile.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqube_endpoint`<sup>Required</sup> <a name="sonarqube_endpoint" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeEndpoint"></a>

```python
sonarqube_endpoint: str
```

- *Type:* str

endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>.

Note: Ensure a trailing '/' is not included.

---

##### `sonarqube_project_name`<sup>Required</sup> <a name="sonarqube_project_name" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeProjectName"></a>

```python
sonarqube_project_name: str
```

- *Type:* str

Name of the project to create in Sonarqube.

---

##### `cdk_out_dir`<sup>Optional</sup> <a name="cdk_out_dir" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.cdkOutDir"></a>

```python
cdk_out_dir: str
```

- *Type:* str

directory containing the synthesized cdk resources.

---

##### `cfn_nag_ignore_path`<sup>Optional</sup> <a name="cfn_nag_ignore_path" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.cfnNagIgnorePath"></a>

```python
cfn_nag_ignore_path: str
```

- *Type:* str

path to a file containing the cfn nag suppression rules.

---

##### `exclude_globs_for_scan`<sup>Optional</sup> <a name="exclude_globs_for_scan" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.excludeGlobsForScan"></a>

```python
exclude_globs_for_scan: typing.List[str]
```

- *Type:* typing.List[str]

glob patterns to exclude from sonar scan.

---

##### `include_globs_for_scan`<sup>Optional</sup> <a name="include_globs_for_scan" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.includeGlobsForScan"></a>

```python
include_globs_for_scan: typing.List[str]
```

- *Type:* typing.List[str]

glob patterns to include from sonar scan.

---

##### `pre_archive_commands`<sup>Optional</sup> <a name="pre_archive_commands" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.preArchiveCommands"></a>

```python
pre_archive_commands: typing.List[str]
```

- *Type:* typing.List[str]

Hook which allows custom commands to be executed before the process commences the archival process.

---

##### `sonarqube_specific_profile_or_gate_name`<sup>Optional</sup> <a name="sonarqube_specific_profile_or_gate_name" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeSpecificProfileOrGateName"></a>

```python
sonarqube_specific_profile_or_gate_name: str
```

- *Type:* str

Specific profile/gate name i.e: language specific.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqube_tags`<sup>Optional</sup> <a name="sonarqube_tags" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeTags"></a>

```python
sonarqube_tags: typing.List[str]
```

- *Type:* typing.List[str]

Tags to associate with this project.

---

##### `artifact_bucket_arn`<sup>Required</sup> <a name="artifact_bucket_arn" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.artifactBucketArn"></a>

```python
artifact_bucket_arn: str
```

- *Type:* str

S3 bucket ARN containing the built artifacts from the synth build.

---

##### `synth_build_arn`<sup>Required</sup> <a name="synth_build_arn" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.synthBuildArn"></a>

```python
synth_build_arn: str
```

- *Type:* str

ARN for the CodeBuild task responsible for executing the synth command.

---

##### `artifact_bucket_key_arn`<sup>Optional</sup> <a name="artifact_bucket_key_arn" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.artifactBucketKeyArn"></a>

```python
artifact_bucket_key_arn: str
```

- *Type:* str

Artifact bucket key ARN used to encrypt the artifacts.

---

### SyncpackConfig <a name="SyncpackConfig" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

nx_monorepo.SyncpackConfig(
  dependency_types: typing.List[str],
  dev: bool,
  filter: str,
  indent: str,
  overrides: bool,
  peer: bool,
  pnpm_overrides: bool,
  prod: bool,
  resolutions: bool,
  semver_groups: typing.List[SemverGroup],
  semver_range: str,
  sort_az: typing.List[str],
  sort_first: typing.List[str],
  source: typing.List[str],
  version_groups: typing.List[VersionGroup],
  workspace: bool
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.dependencyTypes">dependency_types</a></code> | <code>typing.List[str]</code> | which dependency properties to search within. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.dev">dev</a></code> | <code>bool</code> | whether to search within devDependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.filter">filter</a></code> | <code>str</code> | a string which will be passed to `new RegExp()` to match against package names that should be included. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.indent">indent</a></code> | <code>str</code> | the character(s) to be used to indent your package.json files when writing to disk. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.overrides">overrides</a></code> | <code>bool</code> | whether to search within npm overrides. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.peer">peer</a></code> | <code>bool</code> | whether to search within peerDependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.pnpmOverrides">pnpm_overrides</a></code> | <code>bool</code> | whether to search within pnpm overrides. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.prod">prod</a></code> | <code>bool</code> | whether to search within dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.resolutions">resolutions</a></code> | <code>bool</code> | whether to search within yarn resolutions. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.semverGroups">semver_groups</a></code> | <code>typing.List[aws_prototyping_sdk.nx_monorepo.SemverGroup]</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.semverRange">semver_range</a></code> | <code>str</code> | defaults to `""` to ensure that exact dependency versions are used instead of loose ranges. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.sortAz">sort_az</a></code> | <code>typing.List[str]</code> | which fields within package.json files should be sorted alphabetically. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.sortFirst">sort_first</a></code> | <code>typing.List[str]</code> | which fields within package.json files should appear at the top, and in what order. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.source">source</a></code> | <code>typing.List[str]</code> | glob patterns for package.json file locations. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.versionGroups">version_groups</a></code> | <code>typing.List[aws_prototyping_sdk.nx_monorepo.VersionGroup]</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.workspace">workspace</a></code> | <code>bool</code> | whether to include the versions of the `--source` packages developed in your workspace/monorepo as part of the search for versions to sync. |

---

##### `dependency_types`<sup>Required</sup> <a name="dependency_types" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.dependencyTypes"></a>

```python
dependency_types: typing.List[str]
```

- *Type:* typing.List[str]

which dependency properties to search within.

---

##### `dev`<sup>Required</sup> <a name="dev" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.dev"></a>

```python
dev: bool
```

- *Type:* bool

whether to search within devDependencies.

---

##### `filter`<sup>Required</sup> <a name="filter" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.filter"></a>

```python
filter: str
```

- *Type:* str

a string which will be passed to `new RegExp()` to match against package names that should be included.

---

##### `indent`<sup>Required</sup> <a name="indent" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.indent"></a>

```python
indent: str
```

- *Type:* str

the character(s) to be used to indent your package.json files when writing to disk.

---

##### `overrides`<sup>Required</sup> <a name="overrides" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.overrides"></a>

```python
overrides: bool
```

- *Type:* bool

whether to search within npm overrides.

---

##### `peer`<sup>Required</sup> <a name="peer" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.peer"></a>

```python
peer: bool
```

- *Type:* bool

whether to search within peerDependencies.

---

##### `pnpm_overrides`<sup>Required</sup> <a name="pnpm_overrides" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.pnpmOverrides"></a>

```python
pnpm_overrides: bool
```

- *Type:* bool

whether to search within pnpm overrides.

---

##### `prod`<sup>Required</sup> <a name="prod" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.prod"></a>

```python
prod: bool
```

- *Type:* bool

whether to search within dependencies.

---

##### `resolutions`<sup>Required</sup> <a name="resolutions" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.resolutions"></a>

```python
resolutions: bool
```

- *Type:* bool

whether to search within yarn resolutions.

---

##### `semver_groups`<sup>Required</sup> <a name="semver_groups" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.semverGroups"></a>

```python
semver_groups: typing.List[SemverGroup]
```

- *Type:* typing.List[aws_prototyping_sdk.nx_monorepo.SemverGroup]

---

##### `semver_range`<sup>Required</sup> <a name="semver_range" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.semverRange"></a>

```python
semver_range: str
```

- *Type:* str

defaults to `""` to ensure that exact dependency versions are used instead of loose ranges.

---

##### `sort_az`<sup>Required</sup> <a name="sort_az" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.sortAz"></a>

```python
sort_az: typing.List[str]
```

- *Type:* typing.List[str]

which fields within package.json files should be sorted alphabetically.

---

##### `sort_first`<sup>Required</sup> <a name="sort_first" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.sortFirst"></a>

```python
sort_first: typing.List[str]
```

- *Type:* typing.List[str]

which fields within package.json files should appear at the top, and in what order.

---

##### `source`<sup>Required</sup> <a name="source" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.source"></a>

```python
source: typing.List[str]
```

- *Type:* typing.List[str]

glob patterns for package.json file locations.

---

##### `version_groups`<sup>Required</sup> <a name="version_groups" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.versionGroups"></a>

```python
version_groups: typing.List[VersionGroup]
```

- *Type:* typing.List[aws_prototyping_sdk.nx_monorepo.VersionGroup]

---

##### `workspace`<sup>Required</sup> <a name="workspace" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.workspace"></a>

```python
workspace: bool
```

- *Type:* bool

whether to include the versions of the `--source` packages developed in your workspace/monorepo as part of the search for versions to sync.

---

### VersionGroup <a name="VersionGroup" id="aws-prototyping-sdk.nx_monorepo.VersionGroup"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

nx_monorepo.VersionGroup(
  dependencies: typing.List[str],
  packages: typing.List[str],
  dependency_types: typing.List[str] = None,
  is_banned: bool = None,
  pin_version: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.dependencies">dependencies</a></code> | <code>typing.List[str]</code> | the names of the dependencies (eg. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.packages">packages</a></code> | <code>typing.List[str]</code> | the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.dependencyTypes">dependency_types</a></code> | <code>typing.List[str]</code> | optionally only apply this group to dependencies of the provided types. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.isBanned">is_banned</a></code> | <code>bool</code> | optionally force all dependencies in this group to be removed. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.pinVersion">pin_version</a></code> | <code>str</code> | optionally force all dependencies in this group to have this version. |

---

##### `dependencies`<sup>Required</sup> <a name="dependencies" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.dependencies"></a>

```python
dependencies: typing.List[str]
```

- *Type:* typing.List[str]

the names of the dependencies (eg.

"lodash") which belong to this group

---

##### `packages`<sup>Required</sup> <a name="packages" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.packages"></a>

```python
packages: typing.List[str]
```

- *Type:* typing.List[str]

the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name.

---

##### `dependency_types`<sup>Optional</sup> <a name="dependency_types" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.dependencyTypes"></a>

```python
dependency_types: typing.List[str]
```

- *Type:* typing.List[str]

optionally only apply this group to dependencies of the provided types.

---

##### `is_banned`<sup>Optional</sup> <a name="is_banned" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.isBanned"></a>

```python
is_banned: bool
```

- *Type:* bool

optionally force all dependencies in this group to be removed.

---

##### `pin_version`<sup>Optional</sup> <a name="pin_version" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.pinVersion"></a>

```python
pin_version: str
```

- *Type:* str

optionally force all dependencies in this group to have this version.

---

### WorkspaceConfig <a name="WorkspaceConfig" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig"></a>

Workspace configurations.

> [https://classic.yarnpkg.com/lang/en/docs/workspaces/](https://classic.yarnpkg.com/lang/en/docs/workspaces/)

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

nx_monorepo.WorkspaceConfig(
  additional_packages: typing.List[str] = None,
  disable_no_hoist_bundled: bool = None,
  link_local_workspace_bins: bool = None,
  no_hoist: typing.List[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.additionalPackages">additional_packages</a></code> | <code>typing.List[str]</code> | List of additional package globs to include in the workspace. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.disableNoHoistBundled">disable_no_hoist_bundled</a></code> | <code>bool</code> | Disable automatically applying `noHoist` logic for all sub-project "bundledDependencies". |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.linkLocalWorkspaceBins">link_local_workspace_bins</a></code> | <code>bool</code> | Links all local workspace project bins so they can be used for local development. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.noHoist">no_hoist</a></code> | <code>typing.List[str]</code> | List of package globs to exclude from hoisting in the workspace. |

---

##### `additional_packages`<sup>Optional</sup> <a name="additional_packages" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.additionalPackages"></a>

```python
additional_packages: typing.List[str]
```

- *Type:* typing.List[str]

List of additional package globs to include in the workspace.

All packages which are parented by the monorepo are automatically added to the workspace, but you can use this
property to specify any additional paths to packages which may not be managed by projen.

---

##### `disable_no_hoist_bundled`<sup>Optional</sup> <a name="disable_no_hoist_bundled" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.disableNoHoistBundled"></a>

```python
disable_no_hoist_bundled: bool
```

- *Type:* bool
- *Default:* false

Disable automatically applying `noHoist` logic for all sub-project "bundledDependencies".

---

##### `link_local_workspace_bins`<sup>Optional</sup> <a name="link_local_workspace_bins" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.linkLocalWorkspaceBins"></a>

```python
link_local_workspace_bins: bool
```

- *Type:* bool

Links all local workspace project bins so they can be used for local development.

Package bins are only linked when installed from the registry, however it is very useful
for monorepo development to also utilize these bin scripts. When enabled, this flag will
recursively link all bins from packages.json files to the root node_modules/.bin.

---

##### `no_hoist`<sup>Optional</sup> <a name="no_hoist" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.noHoist"></a>

```python
no_hoist: typing.List[str]
```

- *Type:* typing.List[str]

List of package globs to exclude from hoisting in the workspace.

> [https://classic.yarnpkg.com/blog/2018/02/15/nohoist/](https://classic.yarnpkg.com/blog/2018/02/15/nohoist/)

---

## Classes <a name="Classes" id="Classes"></a>

### AwsPrototypingChecks <a name="AwsPrototypingChecks" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks"></a>

Check best practices for prototypes.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.AwsPrototypingChecks(
  log_ignores: bool = None,
  reports: bool = None,
  suppression_ignore_condition: INagSuppressionIgnore = None,
  verbose: bool = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.logIgnores">log_ignores</a></code> | <code>bool</code> | Whether or not to log triggered rules that have been suppressed as informational messages (default: false). |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.reports">reports</a></code> | <code>bool</code> | Whether or not to generate CSV compliance reports for applied Stacks in the App's output directory (default: true). |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.suppressionIgnoreCondition">suppression_ignore_condition</a></code> | <code>cdk_nag.INagSuppressionIgnore</code> | Conditionally prevent rules from being suppressed (default: no user provided condition). |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.verbose">verbose</a></code> | <code>bool</code> | Whether or not to enable extended explanatory descriptions on warning, error, and logged ignore messages (default: false). |

---

##### `log_ignores`<sup>Optional</sup> <a name="log_ignores" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.logIgnores"></a>

- *Type:* bool

Whether or not to log triggered rules that have been suppressed as informational messages (default: false).

---

##### `reports`<sup>Optional</sup> <a name="reports" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.reports"></a>

- *Type:* bool

Whether or not to generate CSV compliance reports for applied Stacks in the App's output directory (default: true).

---

##### `suppression_ignore_condition`<sup>Optional</sup> <a name="suppression_ignore_condition" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.suppressionIgnoreCondition"></a>

- *Type:* cdk_nag.INagSuppressionIgnore

Conditionally prevent rules from being suppressed (default: no user provided condition).

---

##### `verbose`<sup>Optional</sup> <a name="verbose" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.verbose"></a>

- *Type:* bool

Whether or not to enable extended explanatory descriptions on warning, error, and logged ignore messages (default: false).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.visit">visit</a></code> | Check if CfnResource and apply rules. |

---

##### `visit` <a name="visit" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.visit"></a>

```python
def visit(
  node: IConstruct
) -> None
```

Check if CfnResource and apply rules.

###### `node`<sup>Required</sup> <a name="node" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.visit.parameter.node"></a>

- *Type:* constructs.IConstruct

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.property.readPackName">read_pack_name</a></code> | <code>str</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.property.readReportStacks">read_report_stacks</a></code> | <code>typing.List[str]</code> | *No description.* |

---

##### `read_pack_name`<sup>Required</sup> <a name="read_pack_name" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.property.readPackName"></a>

```python
read_pack_name: str
```

- *Type:* str

---

##### `read_report_stacks`<sup>Required</sup> <a name="read_report_stacks" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.property.readReportStacks"></a>

```python
read_report_stacks: typing.List[str]
```

- *Type:* typing.List[str]

---


### NxMonorepoProject <a name="NxMonorepoProject" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject"></a>

This project type will bootstrap a NX based monorepo with support for polygot builds, build caching, dependency graph visualization and much more.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer"></a>

```python
from aws_prototyping_sdk import nx_monorepo

nx_monorepo.NxMonorepoProject(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  allow_library_dependencies: bool = None,
  author_email: str = None,
  author_name: str = None,
  author_organization: bool = None,
  author_url: str = None,
  auto_detect_bin: bool = None,
  bin: typing.Mapping[str] = None,
  bugs_email: str = None,
  bugs_url: str = None,
  bundled_deps: typing.List[str] = None,
  code_artifact_options: CodeArtifactOptions = None,
  deps: typing.List[str] = None,
  description: str = None,
  dev_deps: typing.List[str] = None,
  entrypoint: str = None,
  homepage: str = None,
  keywords: typing.List[str] = None,
  license: str = None,
  licensed: bool = None,
  max_node_version: str = None,
  min_node_version: str = None,
  npm_access: NpmAccess = None,
  npm_registry: str = None,
  npm_registry_url: str = None,
  npm_token_secret: str = None,
  package_manager: NodePackageManager = None,
  package_name: str = None,
  peer_dependency_options: PeerDependencyOptions = None,
  peer_deps: typing.List[str] = None,
  pnpm_version: str = None,
  repository: str = None,
  repository_directory: str = None,
  scoped_packages_options: typing.List[ScopedPackagesOptions] = None,
  scripts: typing.Mapping[str] = None,
  stability: str = None,
  jsii_release_version: str = None,
  major_version: typing.Union[int, float] = None,
  min_major_version: typing.Union[int, float] = None,
  npm_dist_tag: str = None,
  post_build_steps: typing.List[JobStep] = None,
  prerelease: str = None,
  publish_dry_run: bool = None,
  publish_tasks: bool = None,
  release_branches: typing.Mapping[BranchOptions] = None,
  release_every_commit: bool = None,
  release_failure_issue: bool = None,
  release_failure_issue_label: str = None,
  release_schedule: str = None,
  release_tag_prefix: str = None,
  release_trigger: ReleaseTrigger = None,
  release_workflow_name: str = None,
  release_workflow_setup_steps: typing.List[JobStep] = None,
  versionrc_options: typing.Mapping[typing.Any] = None,
  workflow_container_image: str = None,
  workflow_runs_on: typing.List[str] = None,
  default_release_branch: str,
  artifacts_directory: str = None,
  auto_approve_upgrades: bool = None,
  build_workflow: bool = None,
  build_workflow_triggers: Triggers = None,
  bundler_options: BundlerOptions = None,
  code_cov: bool = None,
  code_cov_token_secret: str = None,
  copyright_owner: str = None,
  copyright_period: str = None,
  dependabot: bool = None,
  dependabot_options: DependabotOptions = None,
  deps_upgrade: bool = None,
  deps_upgrade_options: UpgradeDependenciesOptions = None,
  gitignore: typing.List[str] = None,
  jest: bool = None,
  jest_options: JestOptions = None,
  mutable_build: bool = None,
  npmignore: typing.List[str] = None,
  npmignore_enabled: bool = None,
  npm_ignore_options: IgnoreFileOptions = None,
  package: bool = None,
  prettier: bool = None,
  prettier_options: PrettierOptions = None,
  projen_dev_dependency: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projen_version: str = None,
  pull_request_template: bool = None,
  pull_request_template_contents: typing.List[str] = None,
  release: bool = None,
  release_to_npm: bool = None,
  release_workflow: bool = None,
  workflow_bootstrap_steps: typing.List[JobStep] = None,
  workflow_git_identity: GitIdentity = None,
  workflow_node_version: str = None,
  disable_tsconfig: bool = None,
  disable_tsconfig_dev: bool = None,
  docgen: bool = None,
  docs_directory: str = None,
  entrypoint_types: str = None,
  eslint: bool = None,
  eslint_options: EslintOptions = None,
  libdir: str = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcOptions = None,
  sample_code: bool = None,
  srcdir: str = None,
  testdir: str = None,
  tsconfig: TypescriptConfigOptions = None,
  tsconfig_dev: TypescriptConfigOptions = None,
  tsconfig_dev_file: str = None,
  typescript_version: str = None,
  monorepo_upgrade_deps: bool = None,
  monorepo_upgrade_deps_options: MonorepoUpgradeDepsOptions = None,
  nx_config: WorkspaceConfig = None,
  workspace_config: WorkspaceConfig = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorOrganization">author_organization</a></code> | <code>bool</code> | Is the author an organization. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorUrl">author_url</a></code> | <code>str</code> | Author's URL / Website. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoDetectBin">auto_detect_bin</a></code> | <code>bool</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bin">bin</a></code> | <code>typing.Mapping[str]</code> | Binary programs vended with your module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bugsEmail">bugs_email</a></code> | <code>str</code> | The email address to which issues should be reported. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bugsUrl">bugs_url</a></code> | <code>str</code> | The url to your project's issue tracker. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bundledDeps">bundled_deps</a></code> | <code>typing.List[str]</code> | List of dependencies to bundle into this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.codeArtifactOptions">code_artifact_options</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.deps">deps</a></code> | <code>typing.List[str]</code> | Runtime dependencies of this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.description">description</a></code> | <code>str</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | Build dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.entrypoint">entrypoint</a></code> | <code>str</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.homepage">homepage</a></code> | <code>str</code> | Package's Homepage / Website. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.keywords">keywords</a></code> | <code>typing.List[str]</code> | Keywords to include in `package.json`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.license">license</a></code> | <code>str</code> | License's SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.licensed">licensed</a></code> | <code>bool</code> | Indicates if a license should be added. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmAccess">npm_access</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmRegistry">npm_registry</a></code> | <code>str</code> | The host name of the npm registry to publish to. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmRegistryUrl">npm_registry_url</a></code> | <code>str</code> | The base URL of the npm package registry. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmTokenSecret">npm_token_secret</a></code> | <code>str</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.packageName">package_name</a></code> | <code>str</code> | The "name" in package.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.peerDependencyOptions">peer_dependency_options</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.peerDeps">peer_deps</a></code> | <code>typing.List[str]</code> | Peer dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.pnpmVersion">pnpm_version</a></code> | <code>str</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.repository">repository</a></code> | <code>str</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.repositoryDirectory">repository_directory</a></code> | <code>str</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.scopedPackagesOptions">scoped_packages_options</a></code> | <code>typing.List[projen.javascript.ScopedPackagesOptions]</code> | Options for privately hosted scoped packages. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.scripts">scripts</a></code> | <code>typing.Mapping[str]</code> | npm scripts to include. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.stability">stability</a></code> | <code>str</code> | Package's Stability. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.jsiiReleaseVersion">jsii_release_version</a></code> | <code>str</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.majorVersion">major_version</a></code> | <code>typing.Union[int, float]</code> | Major version to release from the default branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.minMajorVersion">min_major_version</a></code> | <code>typing.Union[int, float]</code> | Minimal Major version to release. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmDistTag">npm_dist_tag</a></code> | <code>str</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.postBuildSteps">post_build_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.prerelease">prerelease</a></code> | <code>str</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.publishDryRun">publish_dry_run</a></code> | <code>bool</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.publishTasks">publish_tasks</a></code> | <code>bool</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseBranches">release_branches</a></code> | <code>typing.Mapping[projen.release.BranchOptions]</code> | Defines additional release branches. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseEveryCommit">release_every_commit</a></code> | <code>bool</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseFailureIssue">release_failure_issue</a></code> | <code>bool</code> | Create a github issue on every failed publishing task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseFailureIssueLabel">release_failure_issue_label</a></code> | <code>str</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseSchedule">release_schedule</a></code> | <code>str</code> | CRON schedule to trigger new releases. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseTagPrefix">release_tag_prefix</a></code> | <code>str</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseTrigger">release_trigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflowName">release_workflow_name</a></code> | <code>str</code> | The name of the default release workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflowSetupSteps">release_workflow_setup_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.versionrcOptions">versionrc_options</a></code> | <code>typing.Mapping[typing.Any]</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowContainerImage">workflow_container_image</a></code> | <code>str</code> | Container image to use for GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowRunsOn">workflow_runs_on</a></code> | <code>typing.List[str]</code> | Github Runner selection labels. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.defaultReleaseBranch">default_release_branch</a></code> | <code>str</code> | The name of the main release branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | A directory which will contain build artifacts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoApproveUpgrades">auto_approve_upgrades</a></code> | <code>bool</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.buildWorkflow">build_workflow</a></code> | <code>bool</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.buildWorkflowTriggers">build_workflow_triggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bundlerOptions">bundler_options</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.codeCov">code_cov</a></code> | <code>bool</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.codeCovTokenSecret">code_cov_token_secret</a></code> | <code>str</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.copyrightOwner">copyright_owner</a></code> | <code>str</code> | License copyright owner. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.copyrightPeriod">copyright_period</a></code> | <code>str</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.dependabot">dependabot</a></code> | <code>bool</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.dependabotOptions">dependabot_options</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.depsUpgrade">deps_upgrade</a></code> | <code>bool</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.depsUpgradeOptions">deps_upgrade_options</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitignore">gitignore</a></code> | <code>typing.List[str]</code> | Additional entries to .gitignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.jest">jest</a></code> | <code>bool</code> | Setup jest unit tests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.jestOptions">jest_options</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.mutableBuild">mutable_build</a></code> | <code>bool</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmignore">npmignore</a></code> | <code>typing.List[str]</code> | Additional entries to .npmignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmignoreEnabled">npmignore_enabled</a></code> | <code>bool</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmIgnoreOptions">npm_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.package">package</a></code> | <code>bool</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.prettier">prettier</a></code> | <code>bool</code> | Setup prettier. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.prettierOptions">prettier_options</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenDevDependency">projen_dev_dependency</a></code> | <code>bool</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenVersion">projen_version</a></code> | <code>str</code> | Version of projen to install. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.pullRequestTemplate">pull_request_template</a></code> | <code>bool</code> | Include a GitHub pull request template. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.pullRequestTemplateContents">pull_request_template_contents</a></code> | <code>typing.List[str]</code> | The contents of the pull request template. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.release">release</a></code> | <code>bool</code> | Add release management to this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseToNpm">release_to_npm</a></code> | <code>bool</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflow">release_workflow</a></code> | <code>bool</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowBootstrapSteps">workflow_bootstrap_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowGitIdentity">workflow_git_identity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowNodeVersion">workflow_node_version</a></code> | <code>str</code> | The node version to use in GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.disableTsconfig">disable_tsconfig</a></code> | <code>bool</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.disableTsconfigDev">disable_tsconfig_dev</a></code> | <code>bool</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.docgen">docgen</a></code> | <code>bool</code> | Docgen by Typedoc. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.docsDirectory">docs_directory</a></code> | <code>str</code> | Docs directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.entrypointTypes">entrypoint_types</a></code> | <code>str</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.eslint">eslint</a></code> | <code>bool</code> | Setup eslint. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.eslintOptions">eslint_options</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.libdir">libdir</a></code> | <code>str</code> | Typescript  artifacts output directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.sampleCode">sample_code</a></code> | <code>bool</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.srcdir">srcdir</a></code> | <code>str</code> | Typescript sources directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.testdir">testdir</a></code> | <code>str</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.tsconfigDevFile">tsconfig_dev_file</a></code> | <code>str</code> | The name of the development tsconfig.json file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.typescriptVersion">typescript_version</a></code> | <code>str</code> | TypeScript version to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.monorepoUpgradeDeps">monorepo_upgrade_deps</a></code> | <code>bool</code> | Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.monorepoUpgradeDepsOptions">monorepo_upgrade_deps_options</a></code> | <code>aws_prototyping_sdk.nx_monorepo.MonorepoUpgradeDepsOptions</code> | Monorepo Upgrade Deps options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.nxConfig">nx_config</a></code> | <code>aws_prototyping_sdk.nx_monorepo.Nx.WorkspaceConfig</code> | Configuration for NX. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workspaceConfig">workspace_config</a></code> | <code>aws_prototyping_sdk.nx_monorepo.WorkspaceConfig</code> | Configuration for workspace. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.name"></a>

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.commitGenerated"></a>

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitOptions"></a>

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.logging"></a>

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.outdir"></a>

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.parent"></a>

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenCommand"></a>

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJson"></a>

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.renovatebot"></a>

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoMerge"></a>

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.clobber"></a>

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.devContainer"></a>

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.github"></a>

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.githubOptions"></a>

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitpod"></a>

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenCredentials"></a>

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.readme"></a>

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.stale"></a>

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.staleOptions"></a>

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.vscode"></a>

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allow_library_dependencies`<sup>Optional</sup> <a name="allow_library_dependencies" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.allowLibraryDependencies"></a>

- *Type:* bool
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `author_email`<sup>Optional</sup> <a name="author_email" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorEmail"></a>

- *Type:* str

Author's e-mail.

---

##### `author_name`<sup>Optional</sup> <a name="author_name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorName"></a>

- *Type:* str

Author's name.

---

##### `author_organization`<sup>Optional</sup> <a name="author_organization" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorOrganization"></a>

- *Type:* bool

Is the author an organization.

---

##### `author_url`<sup>Optional</sup> <a name="author_url" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorUrl"></a>

- *Type:* str

Author's URL / Website.

---

##### `auto_detect_bin`<sup>Optional</sup> <a name="auto_detect_bin" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoDetectBin"></a>

- *Type:* bool
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bin"></a>

- *Type:* typing.Mapping[str]

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugs_email`<sup>Optional</sup> <a name="bugs_email" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bugsEmail"></a>

- *Type:* str

The email address to which issues should be reported.

---

##### `bugs_url`<sup>Optional</sup> <a name="bugs_url" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bugsUrl"></a>

- *Type:* str

The url to your project's issue tracker.

---

##### `bundled_deps`<sup>Optional</sup> <a name="bundled_deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bundledDeps"></a>

- *Type:* typing.List[str]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `code_artifact_options`<sup>Optional</sup> <a name="code_artifact_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.codeArtifactOptions"></a>

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.deps"></a>

- *Type:* typing.List[str]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.description"></a>

- *Type:* str

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.devDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.entrypoint"></a>

- *Type:* str
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.homepage"></a>

- *Type:* str

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.keywords"></a>

- *Type:* typing.List[str]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.license"></a>

- *Type:* str
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.licensed"></a>

- *Type:* bool
- *Default:* true

Indicates if a license should be added.

---

##### `max_node_version`<sup>Optional</sup> <a name="max_node_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.maxNodeVersion"></a>

- *Type:* str
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `min_node_version`<sup>Optional</sup> <a name="min_node_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.minNodeVersion"></a>

- *Type:* str
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npm_access`<sup>Optional</sup> <a name="npm_access" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmAccess"></a>

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npm_registry`~~<sup>Optional</sup> <a name="npm_registry" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

- *Type:* str

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npm_registry_url`<sup>Optional</sup> <a name="npm_registry_url" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmRegistryUrl"></a>

- *Type:* str
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npm_token_secret`<sup>Optional</sup> <a name="npm_token_secret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmTokenSecret"></a>

- *Type:* str
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `package_manager`<sup>Optional</sup> <a name="package_manager" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.packageManager"></a>

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.packageName"></a>

- *Type:* str
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peer_dependency_options`<sup>Optional</sup> <a name="peer_dependency_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.peerDependencyOptions"></a>

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peer_deps`<sup>Optional</sup> <a name="peer_deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.peerDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpm_version`<sup>Optional</sup> <a name="pnpm_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.pnpmVersion"></a>

- *Type:* str
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.repository"></a>

- *Type:* str

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repository_directory`<sup>Optional</sup> <a name="repository_directory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.repositoryDirectory"></a>

- *Type:* str

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scoped_packages_options`<sup>Optional</sup> <a name="scoped_packages_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.scopedPackagesOptions"></a>

- *Type:* typing.List[projen.javascript.ScopedPackagesOptions]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

- *Type:* typing.Mapping[str]
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.stability"></a>

- *Type:* str

Package's Stability.

---

##### `jsii_release_version`<sup>Optional</sup> <a name="jsii_release_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.jsiiReleaseVersion"></a>

- *Type:* str
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `major_version`<sup>Optional</sup> <a name="major_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.majorVersion"></a>

- *Type:* typing.Union[int, float]
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `min_major_version`<sup>Optional</sup> <a name="min_major_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.minMajorVersion"></a>

- *Type:* typing.Union[int, float]
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npm_dist_tag`<sup>Optional</sup> <a name="npm_dist_tag" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmDistTag"></a>

- *Type:* str
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `post_build_steps`<sup>Optional</sup> <a name="post_build_steps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.postBuildSteps"></a>

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.prerelease"></a>

- *Type:* str
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publish_dry_run`<sup>Optional</sup> <a name="publish_dry_run" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.publishDryRun"></a>

- *Type:* bool
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publish_tasks`<sup>Optional</sup> <a name="publish_tasks" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.publishTasks"></a>

- *Type:* bool
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `release_branches`<sup>Optional</sup> <a name="release_branches" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseBranches"></a>

- *Type:* typing.Mapping[projen.release.BranchOptions]
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`release_every_commit`~~<sup>Optional</sup> <a name="release_every_commit" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

- *Type:* bool
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `release_failure_issue`<sup>Optional</sup> <a name="release_failure_issue" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseFailureIssue"></a>

- *Type:* bool
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `release_failure_issue_label`<sup>Optional</sup> <a name="release_failure_issue_label" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseFailureIssueLabel"></a>

- *Type:* str
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`release_schedule`~~<sup>Optional</sup> <a name="release_schedule" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

- *Type:* str
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `release_tag_prefix`<sup>Optional</sup> <a name="release_tag_prefix" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseTagPrefix"></a>

- *Type:* str
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `release_trigger`<sup>Optional</sup> <a name="release_trigger" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseTrigger"></a>

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `release_workflow_name`<sup>Optional</sup> <a name="release_workflow_name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflowName"></a>

- *Type:* str
- *Default:* "Release"

The name of the default release workflow.

---

##### `release_workflow_setup_steps`<sup>Optional</sup> <a name="release_workflow_setup_steps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflowSetupSteps"></a>

- *Type:* typing.List[projen.github.workflows.JobStep]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrc_options`<sup>Optional</sup> <a name="versionrc_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.versionrcOptions"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflow_container_image`<sup>Optional</sup> <a name="workflow_container_image" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowContainerImage"></a>

- *Type:* str
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflow_runs_on`<sup>Optional</sup> <a name="workflow_runs_on" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowRunsOn"></a>

- *Type:* typing.List[str]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `default_release_branch`<sup>Required</sup> <a name="default_release_branch" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.defaultReleaseBranch"></a>

- *Type:* str
- *Default:* "main"

The name of the main release branch.

---

##### `artifacts_directory`<sup>Optional</sup> <a name="artifacts_directory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.artifactsDirectory"></a>

- *Type:* str
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `auto_approve_upgrades`<sup>Optional</sup> <a name="auto_approve_upgrades" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoApproveUpgrades"></a>

- *Type:* bool
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `build_workflow`<sup>Optional</sup> <a name="build_workflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.buildWorkflow"></a>

- *Type:* bool
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `build_workflow_triggers`<sup>Optional</sup> <a name="build_workflow_triggers" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.buildWorkflowTriggers"></a>

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundler_options`<sup>Optional</sup> <a name="bundler_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bundlerOptions"></a>

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `code_cov`<sup>Optional</sup> <a name="code_cov" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.codeCov"></a>

- *Type:* bool
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret.

---

##### `code_cov_token_secret`<sup>Optional</sup> <a name="code_cov_token_secret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.codeCovTokenSecret"></a>

- *Type:* str
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyright_owner`<sup>Optional</sup> <a name="copyright_owner" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.copyrightOwner"></a>

- *Type:* str
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyright_period`<sup>Optional</sup> <a name="copyright_period" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.copyrightPeriod"></a>

- *Type:* str
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.dependabot"></a>

- *Type:* bool
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabot_options`<sup>Optional</sup> <a name="dependabot_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.dependabotOptions"></a>

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `deps_upgrade`<sup>Optional</sup> <a name="deps_upgrade" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.depsUpgrade"></a>

- *Type:* bool
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `deps_upgrade_options`<sup>Optional</sup> <a name="deps_upgrade_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.depsUpgradeOptions"></a>

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitignore"></a>

- *Type:* typing.List[str]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.jest"></a>

- *Type:* bool
- *Default:* true

Setup jest unit tests.

---

##### `jest_options`<sup>Optional</sup> <a name="jest_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.jestOptions"></a>

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutable_build`<sup>Optional</sup> <a name="mutable_build" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.mutableBuild"></a>

- *Type:* bool
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

- *Type:* typing.List[str]

Additional entries to .npmignore.

---

##### `npmignore_enabled`<sup>Optional</sup> <a name="npmignore_enabled" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmignoreEnabled"></a>

- *Type:* bool
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npm_ignore_options`<sup>Optional</sup> <a name="npm_ignore_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.package"></a>

- *Type:* bool
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.prettier"></a>

- *Type:* bool
- *Default:* false

Setup prettier.

---

##### `prettier_options`<sup>Optional</sup> <a name="prettier_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.prettierOptions"></a>

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projen_dev_dependency`<sup>Optional</sup> <a name="projen_dev_dependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenDevDependency"></a>

- *Type:* bool
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJs"></a>

- *Type:* bool
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projen_version`<sup>Optional</sup> <a name="projen_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenVersion"></a>

- *Type:* str
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pull_request_template`<sup>Optional</sup> <a name="pull_request_template" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.pullRequestTemplate"></a>

- *Type:* bool
- *Default:* true

Include a GitHub pull request template.

---

##### `pull_request_template_contents`<sup>Optional</sup> <a name="pull_request_template_contents" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.pullRequestTemplateContents"></a>

- *Type:* typing.List[str]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.release"></a>

- *Type:* bool
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `release_to_npm`<sup>Optional</sup> <a name="release_to_npm" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseToNpm"></a>

- *Type:* bool
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`release_workflow`~~<sup>Optional</sup> <a name="release_workflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflow"></a>

- *Deprecated:* see `release`.

- *Type:* bool
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflow_bootstrap_steps`<sup>Optional</sup> <a name="workflow_bootstrap_steps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowBootstrapSteps"></a>

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflow_git_identity`<sup>Optional</sup> <a name="workflow_git_identity" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowGitIdentity"></a>

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflow_node_version`<sup>Optional</sup> <a name="workflow_node_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowNodeVersion"></a>

- *Type:* str
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `disable_tsconfig`<sup>Optional</sup> <a name="disable_tsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.disableTsconfig"></a>

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disable_tsconfig_dev`<sup>Optional</sup> <a name="disable_tsconfig_dev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.disableTsconfigDev"></a>

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.docgen"></a>

- *Type:* bool
- *Default:* false

Docgen by Typedoc.

---

##### `docs_directory`<sup>Optional</sup> <a name="docs_directory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.docsDirectory"></a>

- *Type:* str
- *Default:* "docs"

Docs directory.

---

##### `entrypoint_types`<sup>Optional</sup> <a name="entrypoint_types" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.entrypointTypes"></a>

- *Type:* str
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.eslint"></a>

- *Type:* bool
- *Default:* true

Setup eslint.

---

##### `eslint_options`<sup>Optional</sup> <a name="eslint_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.eslintOptions"></a>

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.libdir"></a>

- *Type:* str
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcTs"></a>

- *Type:* bool
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sample_code`<sup>Optional</sup> <a name="sample_code" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.sampleCode"></a>

- *Type:* bool
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.srcdir"></a>

- *Type:* str
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.testdir"></a>

- *Type:* str
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.tsconfig"></a>

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfig_dev`<sup>Optional</sup> <a name="tsconfig_dev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.tsconfigDev"></a>

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfig_dev_file`<sup>Optional</sup> <a name="tsconfig_dev_file" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.tsconfigDevFile"></a>

- *Type:* str
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescript_version`<sup>Optional</sup> <a name="typescript_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.typescriptVersion"></a>

- *Type:* str
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `monorepo_upgrade_deps`<sup>Optional</sup> <a name="monorepo_upgrade_deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.monorepoUpgradeDeps"></a>

- *Type:* bool
- *Default:* true

Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies.

---

##### `monorepo_upgrade_deps_options`<sup>Optional</sup> <a name="monorepo_upgrade_deps_options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.monorepoUpgradeDepsOptions"></a>

- *Type:* aws_prototyping_sdk.nx_monorepo.MonorepoUpgradeDepsOptions
- *Default:* undefined

Monorepo Upgrade Deps options.

This is only used if monorepoUpgradeDeps is true.

---

##### `nx_config`<sup>Optional</sup> <a name="nx_config" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.nxConfig"></a>

- *Type:* aws_prototyping_sdk.nx_monorepo.Nx.WorkspaceConfig

Configuration for NX.

---

##### `workspace_config`<sup>Optional</sup> <a name="workspace_config" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workspaceConfig"></a>

- *Type:* aws_prototyping_sdk.nx_monorepo.WorkspaceConfig

Configuration for workspace.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addExcludeFromCleanup">add_exclude_from_cleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addGitIgnore">add_git_ignore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPackageIgnore">add_package_ignore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask">add_task</a></code> | Adds a new task to this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTip">add_tip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.annotateGenerated">annotate_generated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.postSynthesize">post_synthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.preSynthesize">pre_synthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeTask">remove_task</a></code> | Removes a task from a project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.runTaskCommand">run_task_command</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindFile">try_find_file</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindJsonFile">try_find_json_file</a></code> | Finds a json file by name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindObjectFile">try_find_object_file</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryRemoveFile">try_remove_file</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBins">add_bins</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBundledDeps">add_bundled_deps</a></code> | Defines bundled dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addCompileCommand">add_compile_command</a></code> | DEPRECATED. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDeps">add_deps</a></code> | Defines normal dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDevDeps">add_dev_deps</a></code> | Defines development/test dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addFields">add_fields</a></code> | Directly set fields in `package.json`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addKeywords">add_keywords</a></code> | Adds keywords to package.json (deduplicated). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPeerDeps">add_peer_deps</a></code> | Defines peer dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addScripts">add_scripts</a></code> | Replaces the contents of multiple npm package.json scripts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTestCommand">add_test_command</a></code> | DEPRECATED. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.hasScript">has_script</a></code> | Indicates if a script by the name name is defined. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeScript">remove_script</a></code> | Removes the npm script (always successful). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.renderWorkflowSetup">render_workflow_setup</a></code> | Returns the set of workflow steps which should be executed to bootstrap a workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.setScript">set_script</a></code> | Replaces the contents of an npm package.json script. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addImplicitDependency">add_implicit_dependency</a></code> | Create an implicit dependency between two Projects. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addJavaDependency">add_java_dependency</a></code> | Adds a dependency between two Java Projects in the monorepo. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask">add_nx_run_many_task</a></code> | Add project task that executes `npx nx run-many ...` style command. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPythonPoetryDependency">add_python_poetry_dependency</a></code> | Adds a dependency between two Python Projects in the monorepo. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addWorkspacePackages">add_workspace_packages</a></code> | Add one or more additional package globs to the workspace. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand">format_nx_run_many_command</a></code> | Helper to format `npx nx run-many ...` style command. |

---

##### `add_exclude_from_cleanup` <a name="add_exclude_from_cleanup" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addExcludeFromCleanup"></a>

```python
def add_exclude_from_cleanup(
  globs: str
) -> None
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* str

The glob patterns to match.

---

##### `add_git_ignore` <a name="add_git_ignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addGitIgnore"></a>

```python
def add_git_ignore(
  pattern: str
) -> None
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addGitIgnore.parameter.pattern"></a>

- *Type:* str

The glob pattern to ignore.

---

##### `add_package_ignore` <a name="add_package_ignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPackageIgnore"></a>

```python
def add_package_ignore(
  pattern: str
) -> None
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPackageIgnore.parameter.pattern"></a>

- *Type:* str

---

##### `add_task` <a name="add_task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask"></a>

```python
def add_task(
  name: str,
  condition: str = None,
  cwd: str = None,
  description: str = None,
  env: typing.Mapping[str] = None,
  required_env: typing.List[str] = None,
  args: typing.List[str] = None,
  exec: str = None,
  receive_args: bool = None,
  steps: typing.List[TaskStep] = None
) -> Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.name"></a>

- *Type:* str

The task name to add.

---

###### `condition`<sup>Optional</sup> <a name="condition" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.condition"></a>

- *Type:* str

A shell command which determines if the this task should be executed.

If
the program exits with a zero exit code, steps will be executed. A non-zero
code means that task will be skipped.

---

###### `cwd`<sup>Optional</sup> <a name="cwd" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.cwd"></a>

- *Type:* str
- *Default:* process.cwd()

The working directory for all steps in this task (unless overridden by the step).

---

###### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.description"></a>

- *Type:* str
- *Default:* the task name

The description of this build command.

---

###### `env`<sup>Optional</sup> <a name="env" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.env"></a>

- *Type:* typing.Mapping[str]
- *Default:* {}

Defines environment variables for the execution of this task.

Values in this map will be evaluated in a shell, so you can do stuff like `$(echo "foo")`.

---

###### `required_env`<sup>Optional</sup> <a name="required_env" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.requiredEnv"></a>

- *Type:* typing.List[str]

A set of environment variables that must be defined in order to execute this task.

Task execution will fail if one of these is not defined.

---

###### `args`<sup>Optional</sup> <a name="args" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.args"></a>

- *Type:* typing.List[str]
- *Default:* no arguments are passed to the step

Should the provided `exec` shell command receive fixed args.

> [{@link TaskStepOptions.args }]({@link TaskStepOptions.args })

---

###### `exec`<sup>Optional</sup> <a name="exec" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.exec"></a>

- *Type:* str
- *Default:* add steps using `task.exec(command)` or `task.spawn(subtask)`

Shell command to execute as the first command of the task.

---

###### `receive_args`<sup>Optional</sup> <a name="receive_args" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.receiveArgs"></a>

- *Type:* bool
- *Default:* false

Should the provided `exec` shell command receive args passed to the task.

> [{@link TaskStepOptions.receiveArgs }]({@link TaskStepOptions.receiveArgs })

---

###### `steps`<sup>Optional</sup> <a name="steps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.steps"></a>

- *Type:* typing.List[projen.TaskStep]

List of task steps to run.

---

##### ~~`add_tip`~~ <a name="add_tip" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTip"></a>

```python
def add_tip(
  message: str
) -> None
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTip.parameter.message"></a>

- *Type:* str

The message.

---

##### `annotate_generated` <a name="annotate_generated" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.annotateGenerated"></a>

```python
def annotate_generated(
  glob: str
) -> None
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.annotateGenerated.parameter.glob"></a>

- *Type:* str

the glob pattern to match (could be a file path).

---

##### `post_synthesize` <a name="post_synthesize" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.postSynthesize"></a>

```python
def post_synthesize() -> None
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `pre_synthesize` <a name="pre_synthesize" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.preSynthesize"></a>

```python
def pre_synthesize() -> None
```

Called before all components are synthesized.

##### `remove_task` <a name="remove_task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeTask"></a>

```python
def remove_task(
  name: str
) -> Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeTask.parameter.name"></a>

- *Type:* str

The name of the task to remove.

---

##### `run_task_command` <a name="run_task_command" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.runTaskCommand"></a>

```python
def run_task_command(
  task: Task
) -> str
```

Returns the shell command to execute in order to run a task.

This will
typically be `npx projen TASK`.

###### `task`<sup>Required</sup> <a name="task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.synth"></a>

```python
def synth() -> None
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `try_find_file` <a name="try_find_file" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindFile"></a>

```python
def try_find_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`try_find_json_file`~~ <a name="try_find_json_file" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindJsonFile"></a>

```python
def try_find_json_file(
  file_path: str
) -> JsonFile
```

Finds a json file by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### `try_find_object_file` <a name="try_find_object_file" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindObjectFile"></a>

```python
def try_find_object_file(
  file_path: str
) -> ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### `try_remove_file` <a name="try_remove_file" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryRemoveFile"></a>

```python
def try_remove_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `add_bins` <a name="add_bins" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBins"></a>

```python
def add_bins(
  bins: typing.Mapping[str]
) -> None
```

###### `bins`<sup>Required</sup> <a name="bins" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBins.parameter.bins"></a>

- *Type:* typing.Mapping[str]

---

##### `add_bundled_deps` <a name="add_bundled_deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBundledDeps"></a>

```python
def add_bundled_deps(
  deps: str
) -> None
```

Defines bundled dependencies.

Bundled dependencies will be added as normal dependencies as well as to the
`bundledDependencies` section of your `package.json`.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBundledDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`add_compile_command`~~ <a name="add_compile_command" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addCompileCommand"></a>

```python
def add_compile_command(
  commands: str
) -> None
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addCompileCommand.parameter.commands"></a>

- *Type:* str

---

##### `add_deps` <a name="add_deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDeps"></a>

```python
def add_deps(
  deps: str
) -> None
```

Defines normal dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `add_dev_deps` <a name="add_dev_deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDevDeps"></a>

```python
def add_dev_deps(
  deps: str
) -> None
```

Defines development/test dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDevDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `add_fields` <a name="add_fields" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addFields"></a>

```python
def add_fields(
  fields: typing.Mapping[typing.Any]
) -> None
```

Directly set fields in `package.json`.

###### `fields`<sup>Required</sup> <a name="fields" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addFields.parameter.fields"></a>

- *Type:* typing.Mapping[typing.Any]

The fields to set.

---

##### `add_keywords` <a name="add_keywords" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addKeywords"></a>

```python
def add_keywords(
  keywords: str
) -> None
```

Adds keywords to package.json (deduplicated).

###### `keywords`<sup>Required</sup> <a name="keywords" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addKeywords.parameter.keywords"></a>

- *Type:* str

The keywords to add.

---

##### `add_peer_deps` <a name="add_peer_deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPeerDeps"></a>

```python
def add_peer_deps(
  deps: str
) -> None
```

Defines peer dependencies.

When adding peer dependencies, a devDependency will also be added on the
pinned version of the declared peer. This will ensure that you are testing
your code against the minimum version required from your consumers.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPeerDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `add_scripts` <a name="add_scripts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addScripts"></a>

```python
def add_scripts(
  scripts: typing.Mapping[str]
) -> None
```

Replaces the contents of multiple npm package.json scripts.

###### `scripts`<sup>Required</sup> <a name="scripts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addScripts.parameter.scripts"></a>

- *Type:* typing.Mapping[str]

The scripts to set.

---

##### ~~`add_test_command`~~ <a name="add_test_command" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTestCommand"></a>

```python
def add_test_command(
  commands: str
) -> None
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTestCommand.parameter.commands"></a>

- *Type:* str

---

##### ~~`has_script`~~ <a name="has_script" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.hasScript"></a>

```python
def has_script(
  name: str
) -> bool
```

Indicates if a script by the name name is defined.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.hasScript.parameter.name"></a>

- *Type:* str

The name of the script.

---

##### `remove_script` <a name="remove_script" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeScript"></a>

```python
def remove_script(
  name: str
) -> None
```

Removes the npm script (always successful).

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeScript.parameter.name"></a>

- *Type:* str

The name of the script.

---

##### `render_workflow_setup` <a name="render_workflow_setup" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.renderWorkflowSetup"></a>

```python
def render_workflow_setup(
  mutable: bool = None
) -> typing.List[JobStep]
```

Returns the set of workflow steps which should be executed to bootstrap a workflow.

###### `mutable`<sup>Optional</sup> <a name="mutable" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.renderWorkflowSetup.parameter.mutable"></a>

- *Type:* bool
- *Default:* false

Should the pacakge lockfile be updated?

---

##### `set_script` <a name="set_script" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.setScript"></a>

```python
def set_script(
  name: str,
  command: str
) -> None
```

Replaces the contents of an npm package.json script.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.setScript.parameter.name"></a>

- *Type:* str

The script name.

---

###### `command`<sup>Required</sup> <a name="command" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.setScript.parameter.command"></a>

- *Type:* str

The command to execute.

---

##### `add_implicit_dependency` <a name="add_implicit_dependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addImplicitDependency"></a>

```python
def add_implicit_dependency(
  dependent: Project,
  dependee: typing.Union[str, Project]
) -> None
```

Create an implicit dependency between two Projects.

This is typically
used in polygot repos where a Typescript project wants a build dependency
on a Python project as an example.

###### `dependent`<sup>Required</sup> <a name="dependent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addImplicitDependency.parameter.dependent"></a>

- *Type:* projen.Project

project you want to have the dependency.

---

###### `dependee`<sup>Required</sup> <a name="dependee" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addImplicitDependency.parameter.dependee"></a>

- *Type:* typing.Union[str, projen.Project]

project you wish to depend on.

---

##### `add_java_dependency` <a name="add_java_dependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addJavaDependency"></a>

```python
def add_java_dependency(
  dependent: JavaProject,
  dependee: JavaProject
) -> None
```

Adds a dependency between two Java Projects in the monorepo.

###### `dependent`<sup>Required</sup> <a name="dependent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addJavaDependency.parameter.dependent"></a>

- *Type:* projen.java.JavaProject

project you want to have the dependency.

---

###### `dependee`<sup>Required</sup> <a name="dependee" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addJavaDependency.parameter.dependee"></a>

- *Type:* projen.java.JavaProject

project you wish to depend on.

---

##### `add_nx_run_many_task` <a name="add_nx_run_many_task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask"></a>

```python
def add_nx_run_many_task(
  name: str,
  target: str,
  configuration: str = None,
  exclude: str = None,
  ignore_cycles: bool = None,
  no_bail: bool = None,
  output_style: str = None,
  parallel: typing.Union[int, float] = None,
  projects: typing.List[str] = None,
  runner: str = None,
  skip_cache: bool = None,
  verbose: bool = None
) -> Task
```

Add project task that executes `npx nx run-many ...` style command.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.name"></a>

- *Type:* str

---

###### `target`<sup>Required</sup> <a name="target" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.target"></a>

- *Type:* str

Task to run for affected projects.

---

###### `configuration`<sup>Optional</sup> <a name="configuration" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.configuration"></a>

- *Type:* str

This is the configuration to use when performing tasks on projects.

---

###### `exclude`<sup>Optional</sup> <a name="exclude" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.exclude"></a>

- *Type:* str

Exclude certain projects from being processed.

---

###### `ignore_cycles`<sup>Optional</sup> <a name="ignore_cycles" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.ignoreCycles"></a>

- *Type:* bool

Ignore cycles in the task graph.

---

###### `no_bail`<sup>Optional</sup> <a name="no_bail" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.noBail"></a>

- *Type:* bool

Do not stop command execution after the first failed task.

---

###### `output_style`<sup>Optional</sup> <a name="output_style" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.outputStyle"></a>

- *Type:* str
- *Default:* "stream"

Defines how Nx emits outputs tasks logs.

---

###### `parallel`<sup>Optional</sup> <a name="parallel" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.parallel"></a>

- *Type:* typing.Union[int, float]
- *Default:* 3

Max number of parallel processes.

---

###### `projects`<sup>Optional</sup> <a name="projects" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.projects"></a>

- *Type:* typing.List[str]

Project to run as list project names and/or patterns.

---

###### `runner`<sup>Optional</sup> <a name="runner" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.runner"></a>

- *Type:* str

This is the name of the tasks runner configuration in nx.json.

---

###### `skip_cache`<sup>Optional</sup> <a name="skip_cache" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.skipCache"></a>

- *Type:* bool

Rerun the tasks even when the results are available in the cache.

---

###### `verbose`<sup>Optional</sup> <a name="verbose" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.verbose"></a>

- *Type:* bool

Prints additional information about the commands (e.g. stack traces).

---

##### `add_python_poetry_dependency` <a name="add_python_poetry_dependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPythonPoetryDependency"></a>

```python
def add_python_poetry_dependency(
  dependent: PythonProject,
  dependee: PythonProject
) -> None
```

Adds a dependency between two Python Projects in the monorepo.

The dependent must have Poetry enabled.

###### `dependent`<sup>Required</sup> <a name="dependent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPythonPoetryDependency.parameter.dependent"></a>

- *Type:* projen.python.PythonProject

project you want to have the dependency (must be a Poetry Python Project).

---

###### `dependee`<sup>Required</sup> <a name="dependee" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPythonPoetryDependency.parameter.dependee"></a>

- *Type:* projen.python.PythonProject

project you wish to depend on.

---

##### `add_workspace_packages` <a name="add_workspace_packages" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addWorkspacePackages"></a>

```python
def add_workspace_packages(
  package_globs: str
) -> None
```

Add one or more additional package globs to the workspace.

###### `package_globs`<sup>Required</sup> <a name="package_globs" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addWorkspacePackages.parameter.packageGlobs"></a>

- *Type:* str

paths to the package to include in the workspace (for example packages/my-package).

---

##### `format_nx_run_many_command` <a name="format_nx_run_many_command" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand"></a>

```python
def format_nx_run_many_command(
  target: str,
  configuration: str = None,
  exclude: str = None,
  ignore_cycles: bool = None,
  no_bail: bool = None,
  output_style: str = None,
  parallel: typing.Union[int, float] = None,
  projects: typing.List[str] = None,
  runner: str = None,
  skip_cache: bool = None,
  verbose: bool = None
) -> str
```

Helper to format `npx nx run-many ...` style command.

###### `target`<sup>Required</sup> <a name="target" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.target"></a>

- *Type:* str

Task to run for affected projects.

---

###### `configuration`<sup>Optional</sup> <a name="configuration" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.configuration"></a>

- *Type:* str

This is the configuration to use when performing tasks on projects.

---

###### `exclude`<sup>Optional</sup> <a name="exclude" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.exclude"></a>

- *Type:* str

Exclude certain projects from being processed.

---

###### `ignore_cycles`<sup>Optional</sup> <a name="ignore_cycles" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.ignoreCycles"></a>

- *Type:* bool

Ignore cycles in the task graph.

---

###### `no_bail`<sup>Optional</sup> <a name="no_bail" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.noBail"></a>

- *Type:* bool

Do not stop command execution after the first failed task.

---

###### `output_style`<sup>Optional</sup> <a name="output_style" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.outputStyle"></a>

- *Type:* str
- *Default:* "stream"

Defines how Nx emits outputs tasks logs.

---

###### `parallel`<sup>Optional</sup> <a name="parallel" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.parallel"></a>

- *Type:* typing.Union[int, float]
- *Default:* 3

Max number of parallel processes.

---

###### `projects`<sup>Optional</sup> <a name="projects" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.projects"></a>

- *Type:* typing.List[str]

Project to run as list project names and/or patterns.

---

###### `runner`<sup>Optional</sup> <a name="runner" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.runner"></a>

- *Type:* str

This is the name of the tasks runner configuration in nx.json.

---

###### `skip_cache`<sup>Optional</sup> <a name="skip_cache" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.skipCache"></a>

- *Type:* bool

Rerun the tasks even when the results are available in the cache.

---

###### `verbose`<sup>Optional</sup> <a name="verbose" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.verbose"></a>

- *Type:* bool

Prints additional information about the commands (e.g. stack traces).

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildTask">build_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.compileTask">compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.components">components</a></code> | <code>typing.List[projen.Component]</code> | Returns all the components within this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.ejected">ejected</a></code> | <code>bool</code> | Whether or not the project is being ejected. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.files">files</a></code> | <code>typing.List[projen.FileBase]</code> | All files in this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.name">name</a></code> | <code>str</code> | Project name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.outdir">outdir</a></code> | <code>str</code> | Absolute output directory of this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.packageTask">package_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.postCompileTask">post_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.preCompileTask">pre_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projectBuild">project_build</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projenCommand">projen_command</a></code> | <code>str</code> | The command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.testTask">test_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.defaultTask">default_task</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.initProject">init_project</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.autoApprove">auto_approve</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.devContainer">dev_container</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | The build output directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.artifactsJavascriptDirectory">artifacts_javascript_directory</a></code> | <code>str</code> | The location of the npm tarball after build (`${artifactsDirectory}/js`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.bundler">bundler</a></code> | <code>projen.javascript.Bundler</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.entrypoint">entrypoint</a></code> | <code>str</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.manifest">manifest</a></code> | <code>typing.Any</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.npmrc">npmrc</a></code> | <code>projen.javascript.NpmConfig</code> | The .npmrc file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.package">package</a></code> | <code>projen.javascript.NodePackage</code> | API for managing the node package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The package manager to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.runScriptCommand">run_script_command</a></code> | <code>str</code> | The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.autoMerge">auto_merge</a></code> | <code>projen.github.AutoMerge</code> | Component that sets up mergify for merging approved pull requests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildWorkflow">build_workflow</a></code> | <code>projen.build.BuildWorkflow</code> | The PR build GitHub workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildWorkflowJobId">build_workflow_job_id</a></code> | <code>str</code> | The job ID of the build workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.jest">jest</a></code> | <code>projen.javascript.Jest</code> | The Jest configuration (if enabled). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Maximum node version required by this package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum node.js version required by this package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.npmignore">npmignore</a></code> | <code>projen.IgnoreFile</code> | The .npmignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.prettier">prettier</a></code> | <code>projen.javascript.Prettier</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.publisher">publisher</a></code> | <code>projen.release.Publisher</code> | Package publisher. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.release">release</a></code> | <code>projen.release.Release</code> | Release management. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.upgradeWorkflow">upgrade_workflow</a></code> | <code>projen.javascript.UpgradeDependencies</code> | The upgrade workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.docsDirectory">docs_directory</a></code> | <code>str</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.libdir">libdir</a></code> | <code>str</code> | The directory in which compiled .js files reside. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.srcdir">srcdir</a></code> | <code>str</code> | The directory in which the .ts sources reside. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.testdir">testdir</a></code> | <code>str</code> | The directory in which tests reside. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfig</code> | A typescript configuration file which covers all files (sources, tests, projen). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.watchTask">watch_task</a></code> | <code>projen.Task</code> | The "watch" task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.docgen">docgen</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.eslint">eslint</a></code> | <code>projen.javascript.Eslint</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfigEslint">tsconfig_eslint</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.nxJson">nx_json</a></code> | <code>projen.JsonFile</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.subProjects">sub_projects</a></code> | <code>typing.List[projen.Project]</code> | *No description.* |

---

##### `build_task`<sup>Required</sup> <a name="build_task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildTask"></a>

```python
build_task: Task
```

- *Type:* projen.Task

---

##### `commit_generated`<sup>Required</sup> <a name="commit_generated" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool

Whether to commit the managed files by default.

---

##### `compile_task`<sup>Required</sup> <a name="compile_task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.compileTask"></a>

```python
compile_task: Task
```

- *Type:* projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.components"></a>

```python
components: typing.List[Component]
```

- *Type:* typing.List[projen.Component]

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.deps"></a>

```python
deps: Dependencies
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.ejected"></a>

```python
ejected: bool
```

- *Type:* bool

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.files"></a>

```python
files: typing.List[FileBase]
```

- *Type:* typing.List[projen.FileBase]

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitattributes"></a>

```python
gitattributes: GitAttributesFile
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitignore"></a>

```python
gitignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.logger"></a>

```python
logger: Logger
```

- *Type:* projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.name"></a>

```python
name: str
```

- *Type:* str

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.outdir"></a>

```python
outdir: str
```

- *Type:* str

Absolute output directory of this project.

---

##### `package_task`<sup>Required</sup> <a name="package_task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.packageTask"></a>

```python
package_task: Task
```

- *Type:* projen.Task

---

##### `post_compile_task`<sup>Required</sup> <a name="post_compile_task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.postCompileTask"></a>

```python
post_compile_task: Task
```

- *Type:* projen.Task

---

##### `pre_compile_task`<sup>Required</sup> <a name="pre_compile_task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.preCompileTask"></a>

```python
pre_compile_task: Task
```

- *Type:* projen.Task

---

##### `project_build`<sup>Required</sup> <a name="project_build" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projectBuild"></a>

```python
project_build: ProjectBuild
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### `projen_command`<sup>Required</sup> <a name="projen_command" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.root"></a>

```python
root: Project
```

- *Type:* projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tasks"></a>

```python
tasks: Tasks
```

- *Type:* projen.Tasks

Project tasks.

---

##### `test_task`<sup>Required</sup> <a name="test_task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.testTask"></a>

```python
test_task: Task
```

- *Type:* projen.Task

---

##### `default_task`<sup>Optional</sup> <a name="default_task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.defaultTask"></a>

```python
default_task: Task
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `init_project`<sup>Optional</sup> <a name="init_project" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.initProject"></a>

```python
init_project: InitProject
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### `project_type`<sup>Required</sup> <a name="project_type" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projectType"></a>

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType

---

##### `auto_approve`<sup>Optional</sup> <a name="auto_approve" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.autoApprove"></a>

```python
auto_approve: AutoApprove
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.devContainer"></a>

```python
dev_container: DevContainer
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.github"></a>

```python
github: GitHub
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitpod"></a>

```python
gitpod: Gitpod
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.vscode"></a>

```python
vscode: VsCode
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`allow_library_dependencies`~~<sup>Required</sup> <a name="allow_library_dependencies" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.allowLibraryDependencies"></a>

- *Deprecated:* use `package.allowLibraryDependencies`

```python
allow_library_dependencies: bool
```

- *Type:* bool

---

##### `artifacts_directory`<sup>Required</sup> <a name="artifacts_directory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.artifactsDirectory"></a>

```python
artifacts_directory: str
```

- *Type:* str

The build output directory.

An npm tarball will be created under the `js`
subdirectory. For example, if this is set to `dist` (the default), the npm
tarball will be placed under `dist/js/boom-boom-1.2.3.tg`.

---

##### `artifacts_javascript_directory`<sup>Required</sup> <a name="artifacts_javascript_directory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.artifactsJavascriptDirectory"></a>

```python
artifacts_javascript_directory: str
```

- *Type:* str

The location of the npm tarball after build (`${artifactsDirectory}/js`).

---

##### `bundler`<sup>Required</sup> <a name="bundler" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.bundler"></a>

```python
bundler: Bundler
```

- *Type:* projen.javascript.Bundler

---

##### ~~`entrypoint`~~<sup>Required</sup> <a name="entrypoint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.entrypoint"></a>

- *Deprecated:* use `package.entrypoint`

```python
entrypoint: str
```

- *Type:* str

---

##### ~~`manifest`~~<sup>Required</sup> <a name="manifest" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.manifest"></a>

- *Deprecated:* use `package.addField(x, y)`

```python
manifest: typing.Any
```

- *Type:* typing.Any

---

##### `npmrc`<sup>Required</sup> <a name="npmrc" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.npmrc"></a>

```python
npmrc: NpmConfig
```

- *Type:* projen.javascript.NpmConfig

The .npmrc file.

---

##### `package`<sup>Required</sup> <a name="package" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.package"></a>

```python
package: NodePackage
```

- *Type:* projen.javascript.NodePackage

API for managing the node package.

---

##### ~~`package_manager`~~<sup>Required</sup> <a name="package_manager" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.packageManager"></a>

- *Deprecated:* use `package.packageManager`

```python
package_manager: NodePackageManager
```

- *Type:* projen.javascript.NodePackageManager

The package manager to use.

---

##### `run_script_command`<sup>Required</sup> <a name="run_script_command" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.runScriptCommand"></a>

```python
run_script_command: str
```

- *Type:* str

The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager).

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.autoMerge"></a>

```python
auto_merge: AutoMerge
```

- *Type:* projen.github.AutoMerge

Component that sets up mergify for merging approved pull requests.

---

##### `build_workflow`<sup>Optional</sup> <a name="build_workflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildWorkflow"></a>

```python
build_workflow: BuildWorkflow
```

- *Type:* projen.build.BuildWorkflow

The PR build GitHub workflow.

`undefined` if `buildWorkflow` is disabled.

---

##### `build_workflow_job_id`<sup>Optional</sup> <a name="build_workflow_job_id" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildWorkflowJobId"></a>

```python
build_workflow_job_id: str
```

- *Type:* str

The job ID of the build workflow.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.jest"></a>

```python
jest: Jest
```

- *Type:* projen.javascript.Jest

The Jest configuration (if enabled).

---

##### `max_node_version`<sup>Optional</sup> <a name="max_node_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.maxNodeVersion"></a>

```python
max_node_version: str
```

- *Type:* str

Maximum node version required by this package.

---

##### `min_node_version`<sup>Optional</sup> <a name="min_node_version" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.minNodeVersion"></a>

```python
min_node_version: str
```

- *Type:* str

Minimum node.js version required by this package.

---

##### `npmignore`<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.npmignore"></a>

```python
npmignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

The .npmignore file.

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.prettier"></a>

```python
prettier: Prettier
```

- *Type:* projen.javascript.Prettier

---

##### ~~`publisher`~~<sup>Optional</sup> <a name="publisher" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.publisher"></a>

- *Deprecated:* use `release.publisher`.

```python
publisher: Publisher
```

- *Type:* projen.release.Publisher

Package publisher.

This will be `undefined` if the project does not have a
release workflow.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.release"></a>

```python
release: Release
```

- *Type:* projen.release.Release

Release management.

---

##### `upgrade_workflow`<sup>Optional</sup> <a name="upgrade_workflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.upgradeWorkflow"></a>

```python
upgrade_workflow: UpgradeDependencies
```

- *Type:* projen.javascript.UpgradeDependencies

The upgrade workflow.

---

##### `docs_directory`<sup>Required</sup> <a name="docs_directory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.docsDirectory"></a>

```python
docs_directory: str
```

- *Type:* str

---

##### `libdir`<sup>Required</sup> <a name="libdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.libdir"></a>

```python
libdir: str
```

- *Type:* str

The directory in which compiled .js files reside.

---

##### `srcdir`<sup>Required</sup> <a name="srcdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.srcdir"></a>

```python
srcdir: str
```

- *Type:* str

The directory in which the .ts sources reside.

---

##### `testdir`<sup>Required</sup> <a name="testdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.testdir"></a>

```python
testdir: str
```

- *Type:* str

The directory in which tests reside.

---

##### `tsconfig_dev`<sup>Required</sup> <a name="tsconfig_dev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfigDev"></a>

```python
tsconfig_dev: TypescriptConfig
```

- *Type:* projen.javascript.TypescriptConfig

A typescript configuration file which covers all files (sources, tests, projen).

---

##### `watch_task`<sup>Required</sup> <a name="watch_task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.watchTask"></a>

```python
watch_task: Task
```

- *Type:* projen.Task

The "watch" task.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.docgen"></a>

```python
docgen: bool
```

- *Type:* bool

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.eslint"></a>

```python
eslint: Eslint
```

- *Type:* projen.javascript.Eslint

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfig"></a>

```python
tsconfig: TypescriptConfig
```

- *Type:* projen.javascript.TypescriptConfig

---

##### `tsconfig_eslint`<sup>Optional</sup> <a name="tsconfig_eslint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfigEslint"></a>

```python
tsconfig_eslint: TypescriptConfig
```

- *Type:* projen.javascript.TypescriptConfig

---

##### `nx_json`<sup>Required</sup> <a name="nx_json" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.nxJson"></a>

```python
nx_json: JsonFile
```

- *Type:* projen.JsonFile

---

##### `sub_projects`<sup>Required</sup> <a name="sub_projects" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.subProjects"></a>

```python
sub_projects: typing.List[Project]
```

- *Type:* typing.List[projen.Project]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>str</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.DEFAULT_TASK"></a>

```python
DEFAULT_TASK: str
```

- *Type:* str

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### PDKNag <a name="PDKNag" id="aws-prototyping-sdk.pdk_nag.PDKNag"></a>

Helper for create a Nag Enabled App.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pdk_nag.PDKNag.Initializer"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNag()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow">add_resource_suppressions_by_path_no_throw</a></code> | Wrapper around NagSuppressions which does not throw. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.app">app</a></code> | Returns an instance of an App with Nag enabled. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.getStackAccountRegex">get_stack_account_regex</a></code> | Returns a stack account regex. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.getStackPartitionRegex">get_stack_partition_regex</a></code> | Returns a stack partition regex. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.getStackPrefix">get_stack_prefix</a></code> | Returns a prefix comprising of a delimited set of Stack Ids. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.getStackRegionRegex">get_stack_region_regex</a></code> | Returns a stack region regex. |

---

##### `add_resource_suppressions_by_path_no_throw` <a name="add_resource_suppressions_by_path_no_throw" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNag.add_resource_suppressions_by_path_no_throw(
  stack: Stack,
  path: str,
  suppressions: typing.List[NagPackSuppression],
  apply_to_children: bool = None
)
```

Wrapper around NagSuppressions which does not throw.

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.stack"></a>

- *Type:* aws_cdk.Stack

stack instance.

---

###### `path`<sup>Required</sup> <a name="path" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.path"></a>

- *Type:* str

resource path.

---

###### `suppressions`<sup>Required</sup> <a name="suppressions" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.suppressions"></a>

- *Type:* typing.List[cdk_nag.NagPackSuppression]

list of suppressions to apply.

---

###### `apply_to_children`<sup>Optional</sup> <a name="apply_to_children" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.applyToChildren"></a>

- *Type:* bool

whether to apply to children.

---

##### `app` <a name="app" id="aws-prototyping-sdk.pdk_nag.PDKNag.app"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNag.app(
  analytics_reporting: bool = None,
  auto_synth: bool = None,
  context: typing.Mapping[typing.Any] = None,
  default_stack_synthesizer: IReusableStackSynthesizer = None,
  outdir: str = None,
  post_cli_context: typing.Mapping[typing.Any] = None,
  stack_traces: bool = None,
  tree_metadata: bool = None,
  fail_on_error: bool = None,
  fail_on_warning: bool = None,
  nag_packs: typing.List[NagPack] = None
)
```

Returns an instance of an App with Nag enabled.

###### `analytics_reporting`<sup>Optional</sup> <a name="analytics_reporting" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.analyticsReporting"></a>

- *Type:* bool
- *Default:* Value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in the Stacks of this app.

---

###### `auto_synth`<sup>Optional</sup> <a name="auto_synth" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.autoSynth"></a>

- *Type:* bool
- *Default:* true if running via CDK CLI (`CDK_OUTDIR` is set), `false` otherwise

Automatically call `synth()` before the program exits.

If you set this, you don't have to call `synth()` explicitly. Note that
this feature is only available for certain programming languages, and
calling `synth()` is still recommended.

---

###### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.context"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context values for the application.

Context set by the CLI or the `context` key in `cdk.json` has precedence.

Context can be read from any construct using `node.getContext(key)`.

---

###### `default_stack_synthesizer`<sup>Optional</sup> <a name="default_stack_synthesizer" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.defaultStackSynthesizer"></a>

- *Type:* aws_cdk.IReusableStackSynthesizer
- *Default:* A `DefaultStackSynthesizer` with default settings

The stack synthesizer to use by default for all Stacks in the App.

The Stack Synthesizer controls aspects of synthesis and deployment,
like how assets are referenced and what IAM roles to use. For more
information, see the README of the main CDK package.

---

###### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.outdir"></a>

- *Type:* str
- *Default:* If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.   If `CDK_OUTDIR` is not defined, uses a temp directory.

The output directory into which to emit synthesized artifacts.

You should never need to set this value. By default, the value you pass to
the CLI's `--output` flag will be used, and if you change it to a different
directory the CLI will fail to pick up the generated Cloud Assembly.

This property is intended for internal and testing use.

---

###### `post_cli_context`<sup>Optional</sup> <a name="post_cli_context" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.postCliContext"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context values for the application.

Context provided here has precedence over context set by:

- The CLI via --context
- The `context` key in `cdk.json`
- The `AppProps.context` property

This property is recommended over the `AppProps.context` property since you
can make final decision over which context value to take in your app.

Context can be read from any construct using `node.getContext(key)`.

---

*Example*

```python
// context from the CLI and from `cdk.json` are stored in the
// CDK_CONTEXT env variable
const cliContext = JSON.parse(process.env.CDK_CONTEXT!);

// determine whether to take the context passed in the CLI or not
const determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
new App({
  postCliContext: {
    SOMEKEY: determineValue,
  },
});
```


###### `stack_traces`<sup>Optional</sup> <a name="stack_traces" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.stackTraces"></a>

- *Type:* bool
- *Default:* true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.

Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.

---

###### `tree_metadata`<sup>Optional</sup> <a name="tree_metadata" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.treeMetadata"></a>

- *Type:* bool
- *Default:* true

Include construct tree metadata as part of the Cloud Assembly.

---

###### `fail_on_error`<sup>Optional</sup> <a name="fail_on_error" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.failOnError"></a>

- *Type:* bool
- *Default:* false

Determines whether any errors encountered should trigger a test failure.

---

###### `fail_on_warning`<sup>Optional</sup> <a name="fail_on_warning" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.failOnWarning"></a>

- *Type:* bool
- *Default:* false

Determines whether any warnings encountered should trigger a test failure.

---

###### `nag_packs`<sup>Optional</sup> <a name="nag_packs" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.nagPacks"></a>

- *Type:* typing.List[cdk_nag.NagPack]
- *Default:* DEFAULT_NAG_PACKS

Custom nag packs to execute.

---

##### `get_stack_account_regex` <a name="get_stack_account_regex" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackAccountRegex"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNag.get_stack_account_regex(
  stack: Stack
)
```

Returns a stack account regex.

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackAccountRegex.parameter.stack"></a>

- *Type:* aws_cdk.Stack

stack instance.

---

##### `get_stack_partition_regex` <a name="get_stack_partition_regex" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackPartitionRegex"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNag.get_stack_partition_regex(
  stack: Stack
)
```

Returns a stack partition regex.

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackPartitionRegex.parameter.stack"></a>

- *Type:* aws_cdk.Stack

stack instance.

---

##### `get_stack_prefix` <a name="get_stack_prefix" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackPrefix"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNag.get_stack_prefix(
  stack: Stack
)
```

Returns a prefix comprising of a delimited set of Stack Ids.

For example: StackA/NestedStackB/

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackPrefix.parameter.stack"></a>

- *Type:* aws_cdk.Stack

stack instance.

---

##### `get_stack_region_regex` <a name="get_stack_region_regex" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackRegionRegex"></a>

```python
from aws_prototyping_sdk import pdk_nag

pdk_nag.PDKNag.get_stack_region_regex(
  stack: Stack
)
```

Returns a stack region regex.

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackRegionRegex.parameter.stack"></a>

- *Type:* aws_cdk.Stack

stack instance.

---



### PDKPipelineJavaProject <a name="PDKPipelineJavaProject" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject"></a>

Synthesizes a Java Project with a CI/CD pipeline.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.PDKPipelineJavaProject(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  artifact_id: str,
  group_id: str,
  version: str,
  description: str = None,
  packaging: str = None,
  url: str = None,
  compile_options: MavenCompileOptions = None,
  deps: typing.List[str] = None,
  distdir: str = None,
  junit: bool = None,
  junit_options: JunitOptions = None,
  packaging_options: MavenPackagingOptions = None,
  projenrc_java: bool = None,
  projenrc_java_options: ProjenrcOptions = None,
  test_deps: typing.List[str] = None,
  sample: bool = None,
  sample_java_package: str = None,
  build_command: str = None,
  cdkout: str = None,
  context: typing.Mapping[typing.Any] = None,
  feature_flags: bool = None,
  require_approval: ApprovalLevel = None,
  watch_excludes: typing.List[str] = None,
  watch_includes: typing.List[str] = None,
  cdk_version: str,
  cdk_assert: bool = None,
  cdk_assertions: bool = None,
  cdk_dependencies: typing.List[str] = None,
  cdk_dependencies_as_deps: bool = None,
  cdk_test_dependencies: typing.List[str] = None,
  cdk_version_pinning: bool = None,
  constructs_version: str = None,
  main_class: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.artifactId">artifact_id</a></code> | <code>str</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.groupId">group_id</a></code> | <code>str</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.version">version</a></code> | <code>str</code> | This is the last piece of the naming puzzle. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.description">description</a></code> | <code>str</code> | Description of a project is always good. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.packaging">packaging</a></code> | <code>str</code> | Project packaging format. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.url">url</a></code> | <code>str</code> | The URL, like the name, is not required. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.compileOptions">compile_options</a></code> | <code>projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.deps">deps</a></code> | <code>typing.List[str]</code> | List of runtime dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.distdir">distdir</a></code> | <code>str</code> | Final artifact output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.junit">junit</a></code> | <code>bool</code> | Include junit tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.junitOptions">junit_options</a></code> | <code>projen.java.JunitOptions</code> | junit options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.packagingOptions">packaging_options</a></code> | <code>projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJava">projenrc_java</a></code> | <code>bool</code> | Use projenrc in java. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJavaOptions">projenrc_java_options</a></code> | <code>projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.testDeps">test_deps</a></code> | <code>typing.List[str]</code> | List of test dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.sample">sample</a></code> | <code>bool</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.sampleJavaPackage">sample_java_package</a></code> | <code>str</code> | The java package to use for the code sample. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.buildCommand">build_command</a></code> | <code>str</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkout">cdkout</a></code> | <code>str</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.context">context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.featureFlags">feature_flags</a></code> | <code>bool</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.requireApproval">require_approval</a></code> | <code>projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.watchExcludes">watch_excludes</a></code> | <code>typing.List[str]</code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.watchIncludes">watch_includes</a></code> | <code>typing.List[str]</code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkVersion">cdk_version</a></code> | <code>str</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkAssert">cdk_assert</a></code> | <code>bool</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkAssertions">cdk_assertions</a></code> | <code>bool</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkDependencies">cdk_dependencies</a></code> | <code>typing.List[str]</code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkDependenciesAsDeps">cdk_dependencies_as_deps</a></code> | <code>bool</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkTestDependencies">cdk_test_dependencies</a></code> | <code>typing.List[str]</code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkVersionPinning">cdk_version_pinning</a></code> | <code>bool</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.constructsVersion">constructs_version</a></code> | <code>str</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.mainClass">main_class</a></code> | <code>str</code> | The name of the Java class with the static `main()` method. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.name"></a>

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.commitGenerated"></a>

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.gitOptions"></a>

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.logging"></a>

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.outdir"></a>

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.parent"></a>

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenCommand"></a>

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJson"></a>

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.renovatebot"></a>

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.autoMerge"></a>

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.clobber"></a>

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.devContainer"></a>

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.github"></a>

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.githubOptions"></a>

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.gitpod"></a>

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenCredentials"></a>

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.readme"></a>

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.stale"></a>

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.staleOptions"></a>

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.vscode"></a>

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifact_id`<sup>Required</sup> <a name="artifact_id" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.artifactId"></a>

- *Type:* str
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `group_id`<sup>Required</sup> <a name="group_id" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.groupId"></a>

- *Type:* str
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.version"></a>

- *Type:* str
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.description"></a>

- *Type:* str
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.packaging"></a>

- *Type:* str
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.url"></a>

- *Type:* str
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compile_options`<sup>Optional</sup> <a name="compile_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.compileOptions"></a>

- *Type:* projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.deps"></a>

- *Type:* typing.List[str]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.distdir"></a>

- *Type:* str
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.junit"></a>

- *Type:* bool
- *Default:* true

Include junit tests.

---

##### `junit_options`<sup>Optional</sup> <a name="junit_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.junitOptions"></a>

- *Type:* projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packaging_options`<sup>Optional</sup> <a name="packaging_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.packagingOptions"></a>

- *Type:* projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrc_java`<sup>Optional</sup> <a name="projenrc_java" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJava"></a>

- *Type:* bool
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrc_java_options`<sup>Optional</sup> <a name="projenrc_java_options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJavaOptions"></a>

- *Type:* projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `test_deps`<sup>Optional</sup> <a name="test_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.testDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.sample"></a>

- *Type:* bool
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sample_java_package`<sup>Optional</sup> <a name="sample_java_package" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.sampleJavaPackage"></a>

- *Type:* str
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `build_command`<sup>Optional</sup> <a name="build_command" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.buildCommand"></a>

- *Type:* str
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkout"></a>

- *Type:* str
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.context"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `feature_flags`<sup>Optional</sup> <a name="feature_flags" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.featureFlags"></a>

- *Type:* bool
- *Default:* true

Include all feature flags in cdk.json.

---

##### `require_approval`<sup>Optional</sup> <a name="require_approval" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.requireApproval"></a>

- *Type:* projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watch_excludes`<sup>Optional</sup> <a name="watch_excludes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.watchExcludes"></a>

- *Type:* typing.List[str]
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watch_includes`<sup>Optional</sup> <a name="watch_includes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.watchIncludes"></a>

- *Type:* typing.List[str]
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdk_version`<sup>Required</sup> <a name="cdk_version" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkVersion"></a>

- *Type:* str
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdk_assert`~~<sup>Optional</sup> <a name="cdk_assert" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkAssert"></a>

- *Deprecated:* The

- *Type:* bool
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdk_assertions`<sup>Optional</sup> <a name="cdk_assertions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkAssertions"></a>

- *Type:* bool
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdk_dependencies`~~<sup>Optional</sup> <a name="cdk_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

- *Type:* typing.List[str]

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdk_dependencies_as_deps`~~<sup>Optional</sup> <a name="cdk_dependencies_as_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

- *Type:* bool
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdk_test_dependencies`~~<sup>Optional</sup> <a name="cdk_test_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

- *Type:* typing.List[str]

AWS CDK modules required for testing.

---

##### `cdk_version_pinning`<sup>Optional</sup> <a name="cdk_version_pinning" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkVersionPinning"></a>

- *Type:* bool

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructs_version`<sup>Optional</sup> <a name="constructs_version" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.constructsVersion"></a>

- *Type:* str
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `main_class`<sup>Required</sup> <a name="main_class" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.mainClass"></a>

- *Type:* str
- *Default:* "org.acme.MyApp"

The name of the Java class with the static `main()` method.

This method
should call `app.synth()` on the CDK app.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addExcludeFromCleanup">add_exclude_from_cleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addGitIgnore">add_git_ignore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPackageIgnore">add_package_ignore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask">add_task</a></code> | Adds a new task to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTip">add_tip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.annotateGenerated">annotate_generated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.postSynthesize">post_synthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.preSynthesize">pre_synthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.removeTask">remove_task</a></code> | Removes a task from a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.runTaskCommand">run_task_command</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindFile">try_find_file</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindJsonFile">try_find_json_file</a></code> | Finds a json file by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindObjectFile">try_find_object_file</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryRemoveFile">try_remove_file</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addDependency">add_dependency</a></code> | Adds a runtime dependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin">add_plugin</a></code> | Adds a build plugin to the pom. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTestDependency">add_test_dependency</a></code> | Adds a test dependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addCdkDependency">add_cdk_dependency</a></code> | Adds an AWS CDK module dependencies. |

---

##### `add_exclude_from_cleanup` <a name="add_exclude_from_cleanup" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addExcludeFromCleanup"></a>

```python
def add_exclude_from_cleanup(
  globs: str
) -> None
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* str

The glob patterns to match.

---

##### `add_git_ignore` <a name="add_git_ignore" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addGitIgnore"></a>

```python
def add_git_ignore(
  pattern: str
) -> None
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addGitIgnore.parameter.pattern"></a>

- *Type:* str

The glob pattern to ignore.

---

##### `add_package_ignore` <a name="add_package_ignore" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPackageIgnore"></a>

```python
def add_package_ignore(
  _pattern: str
) -> None
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* str

The glob pattern to exclude.

---

##### `add_task` <a name="add_task" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask"></a>

```python
def add_task(
  name: str,
  condition: str = None,
  cwd: str = None,
  description: str = None,
  env: typing.Mapping[str] = None,
  required_env: typing.List[str] = None,
  args: typing.List[str] = None,
  exec: str = None,
  receive_args: bool = None,
  steps: typing.List[TaskStep] = None
) -> Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.name"></a>

- *Type:* str

The task name to add.

---

###### `condition`<sup>Optional</sup> <a name="condition" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.condition"></a>

- *Type:* str

A shell command which determines if the this task should be executed.

If
the program exits with a zero exit code, steps will be executed. A non-zero
code means that task will be skipped.

---

###### `cwd`<sup>Optional</sup> <a name="cwd" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.cwd"></a>

- *Type:* str
- *Default:* process.cwd()

The working directory for all steps in this task (unless overridden by the step).

---

###### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.description"></a>

- *Type:* str
- *Default:* the task name

The description of this build command.

---

###### `env`<sup>Optional</sup> <a name="env" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.env"></a>

- *Type:* typing.Mapping[str]
- *Default:* {}

Defines environment variables for the execution of this task.

Values in this map will be evaluated in a shell, so you can do stuff like `$(echo "foo")`.

---

###### `required_env`<sup>Optional</sup> <a name="required_env" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.requiredEnv"></a>

- *Type:* typing.List[str]

A set of environment variables that must be defined in order to execute this task.

Task execution will fail if one of these is not defined.

---

###### `args`<sup>Optional</sup> <a name="args" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.args"></a>

- *Type:* typing.List[str]
- *Default:* no arguments are passed to the step

Should the provided `exec` shell command receive fixed args.

> [{@link TaskStepOptions.args }]({@link TaskStepOptions.args })

---

###### `exec`<sup>Optional</sup> <a name="exec" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.exec"></a>

- *Type:* str
- *Default:* add steps using `task.exec(command)` or `task.spawn(subtask)`

Shell command to execute as the first command of the task.

---

###### `receive_args`<sup>Optional</sup> <a name="receive_args" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.receiveArgs"></a>

- *Type:* bool
- *Default:* false

Should the provided `exec` shell command receive args passed to the task.

> [{@link TaskStepOptions.receiveArgs }]({@link TaskStepOptions.receiveArgs })

---

###### `steps`<sup>Optional</sup> <a name="steps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.steps"></a>

- *Type:* typing.List[projen.TaskStep]

List of task steps to run.

---

##### ~~`add_tip`~~ <a name="add_tip" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTip"></a>

```python
def add_tip(
  message: str
) -> None
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTip.parameter.message"></a>

- *Type:* str

The message.

---

##### `annotate_generated` <a name="annotate_generated" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.annotateGenerated"></a>

```python
def annotate_generated(
  glob: str
) -> None
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.annotateGenerated.parameter.glob"></a>

- *Type:* str

the glob pattern to match (could be a file path).

---

##### `post_synthesize` <a name="post_synthesize" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.postSynthesize"></a>

```python
def post_synthesize() -> None
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `pre_synthesize` <a name="pre_synthesize" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.preSynthesize"></a>

```python
def pre_synthesize() -> None
```

Called before all components are synthesized.

##### `remove_task` <a name="remove_task" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.removeTask"></a>

```python
def remove_task(
  name: str
) -> Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.removeTask.parameter.name"></a>

- *Type:* str

The name of the task to remove.

---

##### `run_task_command` <a name="run_task_command" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.runTaskCommand"></a>

```python
def run_task_command(
  task: Task
) -> str
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.synth"></a>

```python
def synth() -> None
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `try_find_file` <a name="try_find_file" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindFile"></a>

```python
def try_find_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`try_find_json_file`~~ <a name="try_find_json_file" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindJsonFile"></a>

```python
def try_find_json_file(
  file_path: str
) -> JsonFile
```

Finds a json file by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### `try_find_object_file` <a name="try_find_object_file" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindObjectFile"></a>

```python
def try_find_object_file(
  file_path: str
) -> ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### `try_remove_file` <a name="try_remove_file" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryRemoveFile"></a>

```python
def try_remove_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `add_dependency` <a name="add_dependency" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addDependency"></a>

```python
def add_dependency(
  spec: str
) -> None
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addDependency.parameter.spec"></a>

- *Type:* str

Format `<groupId>/<artifactId>@<semver>`.

---

##### `add_plugin` <a name="add_plugin" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin"></a>

```python
def add_plugin(
  spec: str,
  configuration: typing.Mapping[typing.Any] = None,
  dependencies: typing.List[str] = None,
  executions: typing.List[PluginExecution] = None
) -> Dependency
```

Adds a build plugin to the pom.

The plug in is also added as a BUILD dep to the project.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin.parameter.spec"></a>

- *Type:* str

dependency spec (`group/artifact@version`).

---

###### `configuration`<sup>Optional</sup> <a name="configuration" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin.parameter.configuration"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* {}

Plugin key/value configuration.

---

###### `dependencies`<sup>Optional</sup> <a name="dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin.parameter.dependencies"></a>

- *Type:* typing.List[str]
- *Default:* []

You could configure the dependencies for the plugin.

Dependencies are in `<groupId>/<artifactId>@<semver>` format.

---

###### `executions`<sup>Optional</sup> <a name="executions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin.parameter.executions"></a>

- *Type:* typing.List[projen.java.PluginExecution]
- *Default:* []

Plugin executions.

---

##### `add_test_dependency` <a name="add_test_dependency" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTestDependency"></a>

```python
def add_test_dependency(
  spec: str
) -> None
```

Adds a test dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTestDependency.parameter.spec"></a>

- *Type:* str

Format `<groupId>/<artifactId>@<semver>`.

---

##### ~~`add_cdk_dependency`~~ <a name="add_cdk_dependency" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addCdkDependency"></a>

```python
def add_cdk_dependency(
  modules: str
) -> None
```

Adds an AWS CDK module dependencies.

###### `modules`<sup>Required</sup> <a name="modules" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addCdkDependency.parameter.modules"></a>

- *Type:* str

The list of modules to depend on (e.g. "software.amazon.awscdk/aws-lambda", "software.amazon.awscdk/aws-iam", etc).

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.buildTask">build_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.compileTask">compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.components">components</a></code> | <code>typing.List[projen.Component]</code> | Returns all the components within this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.ejected">ejected</a></code> | <code>bool</code> | Whether or not the project is being ejected. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.files">files</a></code> | <code>typing.List[projen.FileBase]</code> | All files in this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.name">name</a></code> | <code>str</code> | Project name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.outdir">outdir</a></code> | <code>str</code> | Absolute output directory of this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.packageTask">package_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.postCompileTask">post_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.preCompileTask">pre_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projectBuild">project_build</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projenCommand">projen_command</a></code> | <code>str</code> | The command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.testTask">test_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.defaultTask">default_task</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.initProject">init_project</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.autoApprove">auto_approve</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.devContainer">dev_container</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.compile">compile</a></code> | <code>projen.java.MavenCompile</code> | Compile component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.distdir">distdir</a></code> | <code>str</code> | Maven artifact output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.packaging">packaging</a></code> | <code>projen.java.MavenPackaging</code> | Packaging component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.pom">pom</a></code> | <code>projen.java.Pom</code> | API for managing `pom.xml`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.junit">junit</a></code> | <code>projen.java.Junit</code> | JUnit component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projenrc">projenrc</a></code> | <code>projen.java.Projenrc</code> | Projenrc component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkConfig">cdk_config</a></code> | <code>projen.awscdk.CdkConfig</code> | The `cdk.json` file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkDeps">cdk_deps</a></code> | <code>projen.awscdk.AwsCdkDeps</code> | CDK dependency management helper class. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkTasks">cdk_tasks</a></code> | <code>projen.awscdk.CdkTasks</code> | CDK tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainClass">main_class</a></code> | <code>str</code> | The full name of the main class of the java app (package.Class). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainClassName">main_class_name</a></code> | <code>str</code> | The name of the Java class with the static `main()` method. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainPackage">main_package</a></code> | <code>str</code> | The name of the Java package that includes the main class. |

---

##### `build_task`<sup>Required</sup> <a name="build_task" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.buildTask"></a>

```python
build_task: Task
```

- *Type:* projen.Task

---

##### `commit_generated`<sup>Required</sup> <a name="commit_generated" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool

Whether to commit the managed files by default.

---

##### `compile_task`<sup>Required</sup> <a name="compile_task" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.compileTask"></a>

```python
compile_task: Task
```

- *Type:* projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.components"></a>

```python
components: typing.List[Component]
```

- *Type:* typing.List[projen.Component]

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.deps"></a>

```python
deps: Dependencies
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.ejected"></a>

```python
ejected: bool
```

- *Type:* bool

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.files"></a>

```python
files: typing.List[FileBase]
```

- *Type:* typing.List[projen.FileBase]

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitattributes"></a>

```python
gitattributes: GitAttributesFile
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitignore"></a>

```python
gitignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.logger"></a>

```python
logger: Logger
```

- *Type:* projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.name"></a>

```python
name: str
```

- *Type:* str

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.outdir"></a>

```python
outdir: str
```

- *Type:* str

Absolute output directory of this project.

---

##### `package_task`<sup>Required</sup> <a name="package_task" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.packageTask"></a>

```python
package_task: Task
```

- *Type:* projen.Task

---

##### `post_compile_task`<sup>Required</sup> <a name="post_compile_task" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.postCompileTask"></a>

```python
post_compile_task: Task
```

- *Type:* projen.Task

---

##### `pre_compile_task`<sup>Required</sup> <a name="pre_compile_task" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.preCompileTask"></a>

```python
pre_compile_task: Task
```

- *Type:* projen.Task

---

##### `project_build`<sup>Required</sup> <a name="project_build" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projectBuild"></a>

```python
project_build: ProjectBuild
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### `projen_command`<sup>Required</sup> <a name="projen_command" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.root"></a>

```python
root: Project
```

- *Type:* projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.tasks"></a>

```python
tasks: Tasks
```

- *Type:* projen.Tasks

Project tasks.

---

##### `test_task`<sup>Required</sup> <a name="test_task" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.testTask"></a>

```python
test_task: Task
```

- *Type:* projen.Task

---

##### `default_task`<sup>Optional</sup> <a name="default_task" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.defaultTask"></a>

```python
default_task: Task
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `init_project`<sup>Optional</sup> <a name="init_project" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.initProject"></a>

```python
init_project: InitProject
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### `project_type`<sup>Required</sup> <a name="project_type" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projectType"></a>

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType

---

##### `auto_approve`<sup>Optional</sup> <a name="auto_approve" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.autoApprove"></a>

```python
auto_approve: AutoApprove
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.devContainer"></a>

```python
dev_container: DevContainer
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.github"></a>

```python
github: GitHub
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitpod"></a>

```python
gitpod: Gitpod
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.vscode"></a>

```python
vscode: VsCode
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### `compile`<sup>Required</sup> <a name="compile" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.compile"></a>

```python
compile: MavenCompile
```

- *Type:* projen.java.MavenCompile

Compile component.

---

##### `distdir`<sup>Required</sup> <a name="distdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.distdir"></a>

```python
distdir: str
```

- *Type:* str

Maven artifact output directory.

---

##### `packaging`<sup>Required</sup> <a name="packaging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.packaging"></a>

```python
packaging: MavenPackaging
```

- *Type:* projen.java.MavenPackaging

Packaging component.

---

##### `pom`<sup>Required</sup> <a name="pom" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.pom"></a>

```python
pom: Pom
```

- *Type:* projen.java.Pom

API for managing `pom.xml`.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.junit"></a>

```python
junit: Junit
```

- *Type:* projen.java.Junit

JUnit component.

---

##### `projenrc`<sup>Optional</sup> <a name="projenrc" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projenrc"></a>

```python
projenrc: Projenrc
```

- *Type:* projen.java.Projenrc

Projenrc component.

---

##### `cdk_config`<sup>Required</sup> <a name="cdk_config" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkConfig"></a>

```python
cdk_config: CdkConfig
```

- *Type:* projen.awscdk.CdkConfig

The `cdk.json` file.

---

##### `cdk_deps`<sup>Required</sup> <a name="cdk_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkDeps"></a>

```python
cdk_deps: AwsCdkDeps
```

- *Type:* projen.awscdk.AwsCdkDeps

CDK dependency management helper class.

---

##### `cdk_tasks`<sup>Required</sup> <a name="cdk_tasks" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkTasks"></a>

```python
cdk_tasks: CdkTasks
```

- *Type:* projen.awscdk.CdkTasks

CDK tasks.

---

##### `main_class`<sup>Required</sup> <a name="main_class" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainClass"></a>

```python
main_class: str
```

- *Type:* str

The full name of the main class of the java app (package.Class).

---

##### `main_class_name`<sup>Required</sup> <a name="main_class_name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainClassName"></a>

```python
main_class_name: str
```

- *Type:* str

The name of the Java class with the static `main()` method.

---

##### `main_package`<sup>Required</sup> <a name="main_package" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainPackage"></a>

```python
main_package: str
```

- *Type:* str

The name of the Java package that includes the main class.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>str</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.DEFAULT_TASK"></a>

```python
DEFAULT_TASK: str
```

- *Type:* str

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### PDKPipelinePyProject <a name="PDKPipelinePyProject" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject"></a>

Synthesizes a Python Project with a CI/CD pipeline.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.PDKPipelinePyProject(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  author_email: str,
  author_name: str,
  version: str,
  classifiers: typing.List[str] = None,
  description: str = None,
  homepage: str = None,
  license: str = None,
  package_name: str = None,
  poetry_options: PoetryPyprojectOptionsWithoutDeps = None,
  setup_config: typing.Mapping[typing.Any] = None,
  module_name: str,
  deps: typing.List[str] = None,
  dev_deps: typing.List[str] = None,
  pip: bool = None,
  poetry: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projenrc_python: bool = None,
  projenrc_python_options: ProjenrcOptions = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcTsOptions = None,
  pytest: bool = None,
  pytest_options: PytestOptions = None,
  sample: bool = None,
  setuptools: bool = None,
  venv: bool = None,
  venv_options: VenvOptions = None,
  build_command: str = None,
  cdkout: str = None,
  context: typing.Mapping[typing.Any] = None,
  feature_flags: bool = None,
  require_approval: ApprovalLevel = None,
  watch_excludes: typing.List[str] = None,
  watch_includes: typing.List[str] = None,
  cdk_version: str,
  cdk_assert: bool = None,
  cdk_assertions: bool = None,
  cdk_dependencies: typing.List[str] = None,
  cdk_dependencies_as_deps: bool = None,
  cdk_test_dependencies: typing.List[str] = None,
  cdk_version_pinning: bool = None,
  constructs_version: str = None,
  app_entrypoint: str = None,
  testdir: str = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.version">version</a></code> | <code>str</code> | Version of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.classifiers">classifiers</a></code> | <code>typing.List[str]</code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.description">description</a></code> | <code>str</code> | A short description of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.homepage">homepage</a></code> | <code>str</code> | A URL to the website of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.license">license</a></code> | <code>str</code> | License of this package as an SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.packageName">package_name</a></code> | <code>str</code> | Package name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.poetryOptions">poetry_options</a></code> | <code>projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.setupConfig">setup_config</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.moduleName">module_name</a></code> | <code>str</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.deps">deps</a></code> | <code>typing.List[str]</code> | List of runtime dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | List of dev dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.pip">pip</a></code> | <code>bool</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.poetry">poetry</a></code> | <code>bool</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Use projenrc in javascript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcPython">projenrc_python</a></code> | <code>bool</code> | Use projenrc in Python. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcPythonOptions">projenrc_python_options</a></code> | <code>projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use projenrc in TypeScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.pytest">pytest</a></code> | <code>bool</code> | Include pytest tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.pytestOptions">pytest_options</a></code> | <code>projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.sample">sample</a></code> | <code>bool</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.setuptools">setuptools</a></code> | <code>bool</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.venv">venv</a></code> | <code>bool</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.venvOptions">venv_options</a></code> | <code>projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.buildCommand">build_command</a></code> | <code>str</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkout">cdkout</a></code> | <code>str</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.context">context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.featureFlags">feature_flags</a></code> | <code>bool</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.requireApproval">require_approval</a></code> | <code>projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.watchExcludes">watch_excludes</a></code> | <code>typing.List[str]</code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.watchIncludes">watch_includes</a></code> | <code>typing.List[str]</code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkVersion">cdk_version</a></code> | <code>str</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkAssert">cdk_assert</a></code> | <code>bool</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkAssertions">cdk_assertions</a></code> | <code>bool</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkDependencies">cdk_dependencies</a></code> | <code>typing.List[str]</code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkDependenciesAsDeps">cdk_dependencies_as_deps</a></code> | <code>bool</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkTestDependencies">cdk_test_dependencies</a></code> | <code>typing.List[str]</code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkVersionPinning">cdk_version_pinning</a></code> | <code>bool</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.constructsVersion">constructs_version</a></code> | <code>str</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.appEntrypoint">app_entrypoint</a></code> | <code>str</code> | The CDK app's entrypoint (relative to the source directory, which is "src" by default). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.testdir">testdir</a></code> | <code>str</code> | Python sources directory. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.name"></a>

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.commitGenerated"></a>

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.gitOptions"></a>

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.logging"></a>

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.outdir"></a>

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.parent"></a>

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenCommand"></a>

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJson"></a>

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.renovatebot"></a>

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.autoMerge"></a>

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.clobber"></a>

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.devContainer"></a>

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.github"></a>

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.githubOptions"></a>

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.gitpod"></a>

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenCredentials"></a>

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.readme"></a>

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.stale"></a>

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.staleOptions"></a>

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.vscode"></a>

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `author_email`<sup>Required</sup> <a name="author_email" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.authorEmail"></a>

- *Type:* str
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `author_name`<sup>Required</sup> <a name="author_name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.authorName"></a>

- *Type:* str
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.version"></a>

- *Type:* str
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.classifiers"></a>

- *Type:* typing.List[str]

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.description"></a>

- *Type:* str

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.homepage"></a>

- *Type:* str

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.license"></a>

- *Type:* str

License of this package as an SPDX identifier.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.packageName"></a>

- *Type:* str

Package name.

---

##### `poetry_options`<sup>Optional</sup> <a name="poetry_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.poetryOptions"></a>

- *Type:* projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setup_config`<sup>Optional</sup> <a name="setup_config" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.setupConfig"></a>

- *Type:* typing.Mapping[typing.Any]

Additional fields to pass in the setup() function if using setuptools.

---

##### `module_name`<sup>Required</sup> <a name="module_name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.moduleName"></a>

- *Type:* str
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.deps"></a>

- *Type:* typing.List[str]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.devDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.pip"></a>

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.poetry"></a>

- *Type:* bool
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJs"></a>

- *Type:* bool
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrc_python`<sup>Optional</sup> <a name="projenrc_python" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcPython"></a>

- *Type:* bool
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrc_python_options`<sup>Optional</sup> <a name="projenrc_python_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcPythonOptions"></a>

- *Type:* projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcTs"></a>

- *Type:* bool
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.pytest"></a>

- *Type:* bool
- *Default:* true

Include pytest tests.

---

##### `pytest_options`<sup>Optional</sup> <a name="pytest_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.pytestOptions"></a>

- *Type:* projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.sample"></a>

- *Type:* bool
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.setuptools"></a>

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.venv"></a>

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venv_options`<sup>Optional</sup> <a name="venv_options" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.venvOptions"></a>

- *Type:* projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `build_command`<sup>Optional</sup> <a name="build_command" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.buildCommand"></a>

- *Type:* str
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkout"></a>

- *Type:* str
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.context"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `feature_flags`<sup>Optional</sup> <a name="feature_flags" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.featureFlags"></a>

- *Type:* bool
- *Default:* true

Include all feature flags in cdk.json.

---

##### `require_approval`<sup>Optional</sup> <a name="require_approval" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.requireApproval"></a>

- *Type:* projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watch_excludes`<sup>Optional</sup> <a name="watch_excludes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.watchExcludes"></a>

- *Type:* typing.List[str]
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watch_includes`<sup>Optional</sup> <a name="watch_includes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.watchIncludes"></a>

- *Type:* typing.List[str]
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdk_version`<sup>Required</sup> <a name="cdk_version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkVersion"></a>

- *Type:* str
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdk_assert`~~<sup>Optional</sup> <a name="cdk_assert" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkAssert"></a>

- *Deprecated:* The

- *Type:* bool
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdk_assertions`<sup>Optional</sup> <a name="cdk_assertions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkAssertions"></a>

- *Type:* bool
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdk_dependencies`~~<sup>Optional</sup> <a name="cdk_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

- *Type:* typing.List[str]

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdk_dependencies_as_deps`~~<sup>Optional</sup> <a name="cdk_dependencies_as_deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

- *Type:* bool
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdk_test_dependencies`~~<sup>Optional</sup> <a name="cdk_test_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

- *Type:* typing.List[str]

AWS CDK modules required for testing.

---

##### `cdk_version_pinning`<sup>Optional</sup> <a name="cdk_version_pinning" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkVersionPinning"></a>

- *Type:* bool

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructs_version`<sup>Optional</sup> <a name="constructs_version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.constructsVersion"></a>

- *Type:* str
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `app_entrypoint`<sup>Optional</sup> <a name="app_entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.appEntrypoint"></a>

- *Type:* str
- *Default:* "app.py"

The CDK app's entrypoint (relative to the source directory, which is "src" by default).

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.testdir"></a>

- *Type:* str
- *Default:* "tests"

Python sources directory.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addExcludeFromCleanup">add_exclude_from_cleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addGitIgnore">add_git_ignore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addPackageIgnore">add_package_ignore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask">add_task</a></code> | Adds a new task to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTip">add_tip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.annotateGenerated">annotate_generated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.postSynthesize">post_synthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.preSynthesize">pre_synthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.removeTask">remove_task</a></code> | Removes a task from a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.runTaskCommand">run_task_command</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindFile">try_find_file</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindJsonFile">try_find_json_file</a></code> | Finds a json file by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindObjectFile">try_find_object_file</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryRemoveFile">try_remove_file</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDependency">add_dependency</a></code> | Adds a runtime dependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDevDependency">add_dev_dependency</a></code> | Adds a dev dependency. |

---

##### `add_exclude_from_cleanup` <a name="add_exclude_from_cleanup" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addExcludeFromCleanup"></a>

```python
def add_exclude_from_cleanup(
  globs: str
) -> None
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* str

The glob patterns to match.

---

##### `add_git_ignore` <a name="add_git_ignore" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addGitIgnore"></a>

```python
def add_git_ignore(
  pattern: str
) -> None
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addGitIgnore.parameter.pattern"></a>

- *Type:* str

The glob pattern to ignore.

---

##### `add_package_ignore` <a name="add_package_ignore" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addPackageIgnore"></a>

```python
def add_package_ignore(
  _pattern: str
) -> None
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* str

The glob pattern to exclude.

---

##### `add_task` <a name="add_task" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask"></a>

```python
def add_task(
  name: str,
  condition: str = None,
  cwd: str = None,
  description: str = None,
  env: typing.Mapping[str] = None,
  required_env: typing.List[str] = None,
  args: typing.List[str] = None,
  exec: str = None,
  receive_args: bool = None,
  steps: typing.List[TaskStep] = None
) -> Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.name"></a>

- *Type:* str

The task name to add.

---

###### `condition`<sup>Optional</sup> <a name="condition" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.condition"></a>

- *Type:* str

A shell command which determines if the this task should be executed.

If
the program exits with a zero exit code, steps will be executed. A non-zero
code means that task will be skipped.

---

###### `cwd`<sup>Optional</sup> <a name="cwd" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.cwd"></a>

- *Type:* str
- *Default:* process.cwd()

The working directory for all steps in this task (unless overridden by the step).

---

###### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.description"></a>

- *Type:* str
- *Default:* the task name

The description of this build command.

---

###### `env`<sup>Optional</sup> <a name="env" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.env"></a>

- *Type:* typing.Mapping[str]
- *Default:* {}

Defines environment variables for the execution of this task.

Values in this map will be evaluated in a shell, so you can do stuff like `$(echo "foo")`.

---

###### `required_env`<sup>Optional</sup> <a name="required_env" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.requiredEnv"></a>

- *Type:* typing.List[str]

A set of environment variables that must be defined in order to execute this task.

Task execution will fail if one of these is not defined.

---

###### `args`<sup>Optional</sup> <a name="args" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.args"></a>

- *Type:* typing.List[str]
- *Default:* no arguments are passed to the step

Should the provided `exec` shell command receive fixed args.

> [{@link TaskStepOptions.args }]({@link TaskStepOptions.args })

---

###### `exec`<sup>Optional</sup> <a name="exec" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.exec"></a>

- *Type:* str
- *Default:* add steps using `task.exec(command)` or `task.spawn(subtask)`

Shell command to execute as the first command of the task.

---

###### `receive_args`<sup>Optional</sup> <a name="receive_args" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.receiveArgs"></a>

- *Type:* bool
- *Default:* false

Should the provided `exec` shell command receive args passed to the task.

> [{@link TaskStepOptions.receiveArgs }]({@link TaskStepOptions.receiveArgs })

---

###### `steps`<sup>Optional</sup> <a name="steps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.steps"></a>

- *Type:* typing.List[projen.TaskStep]

List of task steps to run.

---

##### ~~`add_tip`~~ <a name="add_tip" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTip"></a>

```python
def add_tip(
  message: str
) -> None
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTip.parameter.message"></a>

- *Type:* str

The message.

---

##### `annotate_generated` <a name="annotate_generated" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.annotateGenerated"></a>

```python
def annotate_generated(
  glob: str
) -> None
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.annotateGenerated.parameter.glob"></a>

- *Type:* str

the glob pattern to match (could be a file path).

---

##### `post_synthesize` <a name="post_synthesize" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.postSynthesize"></a>

```python
def post_synthesize() -> None
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `pre_synthesize` <a name="pre_synthesize" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.preSynthesize"></a>

```python
def pre_synthesize() -> None
```

Called before all components are synthesized.

##### `remove_task` <a name="remove_task" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.removeTask"></a>

```python
def remove_task(
  name: str
) -> Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.removeTask.parameter.name"></a>

- *Type:* str

The name of the task to remove.

---

##### `run_task_command` <a name="run_task_command" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.runTaskCommand"></a>

```python
def run_task_command(
  task: Task
) -> str
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.synth"></a>

```python
def synth() -> None
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `try_find_file` <a name="try_find_file" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindFile"></a>

```python
def try_find_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`try_find_json_file`~~ <a name="try_find_json_file" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindJsonFile"></a>

```python
def try_find_json_file(
  file_path: str
) -> JsonFile
```

Finds a json file by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### `try_find_object_file` <a name="try_find_object_file" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindObjectFile"></a>

```python
def try_find_object_file(
  file_path: str
) -> ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### `try_remove_file` <a name="try_remove_file" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryRemoveFile"></a>

```python
def try_remove_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `add_dependency` <a name="add_dependency" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDependency"></a>

```python
def add_dependency(
  spec: str
) -> None
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDependency.parameter.spec"></a>

- *Type:* str

Format `<module>@<semver>`.

---

##### `add_dev_dependency` <a name="add_dev_dependency" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDevDependency"></a>

```python
def add_dev_dependency(
  spec: str
) -> None
```

Adds a dev dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDevDependency.parameter.spec"></a>

- *Type:* str

Format `<module>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.buildTask">build_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.compileTask">compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.components">components</a></code> | <code>typing.List[projen.Component]</code> | Returns all the components within this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.ejected">ejected</a></code> | <code>bool</code> | Whether or not the project is being ejected. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.files">files</a></code> | <code>typing.List[projen.FileBase]</code> | All files in this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.name">name</a></code> | <code>str</code> | Project name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.outdir">outdir</a></code> | <code>str</code> | Absolute output directory of this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.packageTask">package_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.postCompileTask">post_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.preCompileTask">pre_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projectBuild">project_build</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projenCommand">projen_command</a></code> | <code>str</code> | The command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.testTask">test_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.defaultTask">default_task</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.initProject">init_project</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.autoApprove">auto_approve</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.devContainer">dev_container</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.depsManager">deps_manager</a></code> | <code>projen.python.IPythonDeps</code> | API for managing dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.envManager">env_manager</a></code> | <code>projen.python.IPythonEnv</code> | API for mangaging the Python runtime environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.moduleName">module_name</a></code> | <code>str</code> | Python module name (the project name, with any hyphens or periods replaced with underscores). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.version">version</a></code> | <code>str</code> | Version of the package for distribution (should follow semver). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.packagingManager">packaging_manager</a></code> | <code>projen.python.IPythonPackaging</code> | API for managing packaging the project as a library. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.pytest">pytest</a></code> | <code>projen.python.Pytest</code> | Pytest component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.appEntrypoint">app_entrypoint</a></code> | <code>str</code> | The CDK app entrypoint. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkConfig">cdk_config</a></code> | <code>projen.awscdk.CdkConfig</code> | cdk.json configuration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkDeps">cdk_deps</a></code> | <code>projen.awscdk.AwsCdkDeps</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkTasks">cdk_tasks</a></code> | <code>projen.awscdk.CdkTasks</code> | Common CDK tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkVersion">cdk_version</a></code> | <code>str</code> | The CDK version this app is using. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.testdir">testdir</a></code> | <code>str</code> | The directory in which the python tests reside. |

---

##### `build_task`<sup>Required</sup> <a name="build_task" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.buildTask"></a>

```python
build_task: Task
```

- *Type:* projen.Task

---

##### `commit_generated`<sup>Required</sup> <a name="commit_generated" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool

Whether to commit the managed files by default.

---

##### `compile_task`<sup>Required</sup> <a name="compile_task" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.compileTask"></a>

```python
compile_task: Task
```

- *Type:* projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.components"></a>

```python
components: typing.List[Component]
```

- *Type:* typing.List[projen.Component]

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.deps"></a>

```python
deps: Dependencies
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.ejected"></a>

```python
ejected: bool
```

- *Type:* bool

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.files"></a>

```python
files: typing.List[FileBase]
```

- *Type:* typing.List[projen.FileBase]

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitattributes"></a>

```python
gitattributes: GitAttributesFile
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitignore"></a>

```python
gitignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.logger"></a>

```python
logger: Logger
```

- *Type:* projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.name"></a>

```python
name: str
```

- *Type:* str

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.outdir"></a>

```python
outdir: str
```

- *Type:* str

Absolute output directory of this project.

---

##### `package_task`<sup>Required</sup> <a name="package_task" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.packageTask"></a>

```python
package_task: Task
```

- *Type:* projen.Task

---

##### `post_compile_task`<sup>Required</sup> <a name="post_compile_task" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.postCompileTask"></a>

```python
post_compile_task: Task
```

- *Type:* projen.Task

---

##### `pre_compile_task`<sup>Required</sup> <a name="pre_compile_task" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.preCompileTask"></a>

```python
pre_compile_task: Task
```

- *Type:* projen.Task

---

##### `project_build`<sup>Required</sup> <a name="project_build" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projectBuild"></a>

```python
project_build: ProjectBuild
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### `projen_command`<sup>Required</sup> <a name="projen_command" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.root"></a>

```python
root: Project
```

- *Type:* projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.tasks"></a>

```python
tasks: Tasks
```

- *Type:* projen.Tasks

Project tasks.

---

##### `test_task`<sup>Required</sup> <a name="test_task" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.testTask"></a>

```python
test_task: Task
```

- *Type:* projen.Task

---

##### `default_task`<sup>Optional</sup> <a name="default_task" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.defaultTask"></a>

```python
default_task: Task
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `init_project`<sup>Optional</sup> <a name="init_project" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.initProject"></a>

```python
init_project: InitProject
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### `project_type`<sup>Required</sup> <a name="project_type" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projectType"></a>

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType

---

##### `auto_approve`<sup>Optional</sup> <a name="auto_approve" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.autoApprove"></a>

```python
auto_approve: AutoApprove
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.devContainer"></a>

```python
dev_container: DevContainer
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.github"></a>

```python
github: GitHub
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitpod"></a>

```python
gitpod: Gitpod
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.vscode"></a>

```python
vscode: VsCode
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### `deps_manager`<sup>Required</sup> <a name="deps_manager" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.depsManager"></a>

```python
deps_manager: IPythonDeps
```

- *Type:* projen.python.IPythonDeps

API for managing dependencies.

---

##### `env_manager`<sup>Required</sup> <a name="env_manager" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.envManager"></a>

```python
env_manager: IPythonEnv
```

- *Type:* projen.python.IPythonEnv

API for mangaging the Python runtime environment.

---

##### `module_name`<sup>Required</sup> <a name="module_name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.moduleName"></a>

```python
module_name: str
```

- *Type:* str

Python module name (the project name, with any hyphens or periods replaced with underscores).

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.version"></a>

```python
version: str
```

- *Type:* str

Version of the package for distribution (should follow semver).

---

##### `packaging_manager`<sup>Optional</sup> <a name="packaging_manager" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.packagingManager"></a>

```python
packaging_manager: IPythonPackaging
```

- *Type:* projen.python.IPythonPackaging

API for managing packaging the project as a library.

Only applies when the `projectType` is LIB.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.pytest"></a>

```python
pytest: Pytest
```

- *Type:* projen.python.Pytest

Pytest component.

---

##### `app_entrypoint`<sup>Required</sup> <a name="app_entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.appEntrypoint"></a>

```python
app_entrypoint: str
```

- *Type:* str

The CDK app entrypoint.

---

##### `cdk_config`<sup>Required</sup> <a name="cdk_config" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkConfig"></a>

```python
cdk_config: CdkConfig
```

- *Type:* projen.awscdk.CdkConfig

cdk.json configuration.

---

##### `cdk_deps`<sup>Required</sup> <a name="cdk_deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkDeps"></a>

```python
cdk_deps: AwsCdkDeps
```

- *Type:* projen.awscdk.AwsCdkDeps

---

##### `cdk_tasks`<sup>Required</sup> <a name="cdk_tasks" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkTasks"></a>

```python
cdk_tasks: CdkTasks
```

- *Type:* projen.awscdk.CdkTasks

Common CDK tasks.

---

##### `cdk_version`<sup>Required</sup> <a name="cdk_version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkVersion"></a>

```python
cdk_version: str
```

- *Type:* str

The CDK version this app is using.

---

##### `testdir`<sup>Required</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.testdir"></a>

```python
testdir: str
```

- *Type:* str

The directory in which the python tests reside.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>str</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.DEFAULT_TASK"></a>

```python
DEFAULT_TASK: str
```

- *Type:* str

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### PDKPipelineTsProject <a name="PDKPipelineTsProject" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject"></a>

Synthesizes a Typescript Project with a CI/CD pipeline.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer"></a>

```python
from aws_prototyping_sdk import pipeline

pipeline.PDKPipelineTsProject(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  allow_library_dependencies: bool = None,
  author_email: str = None,
  author_name: str = None,
  author_organization: bool = None,
  author_url: str = None,
  auto_detect_bin: bool = None,
  bin: typing.Mapping[str] = None,
  bugs_email: str = None,
  bugs_url: str = None,
  bundled_deps: typing.List[str] = None,
  code_artifact_options: CodeArtifactOptions = None,
  deps: typing.List[str] = None,
  description: str = None,
  dev_deps: typing.List[str] = None,
  entrypoint: str = None,
  homepage: str = None,
  keywords: typing.List[str] = None,
  license: str = None,
  licensed: bool = None,
  max_node_version: str = None,
  min_node_version: str = None,
  npm_access: NpmAccess = None,
  npm_registry: str = None,
  npm_registry_url: str = None,
  npm_token_secret: str = None,
  package_manager: NodePackageManager = None,
  package_name: str = None,
  peer_dependency_options: PeerDependencyOptions = None,
  peer_deps: typing.List[str] = None,
  pnpm_version: str = None,
  repository: str = None,
  repository_directory: str = None,
  scoped_packages_options: typing.List[ScopedPackagesOptions] = None,
  scripts: typing.Mapping[str] = None,
  stability: str = None,
  jsii_release_version: str = None,
  major_version: typing.Union[int, float] = None,
  min_major_version: typing.Union[int, float] = None,
  npm_dist_tag: str = None,
  post_build_steps: typing.List[JobStep] = None,
  prerelease: str = None,
  publish_dry_run: bool = None,
  publish_tasks: bool = None,
  release_branches: typing.Mapping[BranchOptions] = None,
  release_every_commit: bool = None,
  release_failure_issue: bool = None,
  release_failure_issue_label: str = None,
  release_schedule: str = None,
  release_tag_prefix: str = None,
  release_trigger: ReleaseTrigger = None,
  release_workflow_name: str = None,
  release_workflow_setup_steps: typing.List[JobStep] = None,
  versionrc_options: typing.Mapping[typing.Any] = None,
  workflow_container_image: str = None,
  workflow_runs_on: typing.List[str] = None,
  default_release_branch: str,
  artifacts_directory: str = None,
  auto_approve_upgrades: bool = None,
  build_workflow: bool = None,
  build_workflow_triggers: Triggers = None,
  bundler_options: BundlerOptions = None,
  code_cov: bool = None,
  code_cov_token_secret: str = None,
  copyright_owner: str = None,
  copyright_period: str = None,
  dependabot: bool = None,
  dependabot_options: DependabotOptions = None,
  deps_upgrade: bool = None,
  deps_upgrade_options: UpgradeDependenciesOptions = None,
  gitignore: typing.List[str] = None,
  jest: bool = None,
  jest_options: JestOptions = None,
  mutable_build: bool = None,
  npmignore: typing.List[str] = None,
  npmignore_enabled: bool = None,
  npm_ignore_options: IgnoreFileOptions = None,
  package: bool = None,
  prettier: bool = None,
  prettier_options: PrettierOptions = None,
  projen_dev_dependency: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projen_version: str = None,
  pull_request_template: bool = None,
  pull_request_template_contents: typing.List[str] = None,
  release: bool = None,
  release_to_npm: bool = None,
  release_workflow: bool = None,
  workflow_bootstrap_steps: typing.List[JobStep] = None,
  workflow_git_identity: GitIdentity = None,
  workflow_node_version: str = None,
  disable_tsconfig: bool = None,
  disable_tsconfig_dev: bool = None,
  docgen: bool = None,
  docs_directory: str = None,
  entrypoint_types: str = None,
  eslint: bool = None,
  eslint_options: EslintOptions = None,
  libdir: str = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcOptions = None,
  sample_code: bool = None,
  srcdir: str = None,
  testdir: str = None,
  tsconfig: TypescriptConfigOptions = None,
  tsconfig_dev: TypescriptConfigOptions = None,
  tsconfig_dev_file: str = None,
  typescript_version: str = None,
  build_command: str = None,
  cdkout: str = None,
  context: typing.Mapping[typing.Any] = None,
  feature_flags: bool = None,
  require_approval: ApprovalLevel = None,
  watch_excludes: typing.List[str] = None,
  watch_includes: typing.List[str] = None,
  cdk_version: str,
  cdk_assert: bool = None,
  cdk_assertions: bool = None,
  cdk_dependencies: typing.List[str] = None,
  cdk_dependencies_as_deps: bool = None,
  cdk_test_dependencies: typing.List[str] = None,
  cdk_version_pinning: bool = None,
  constructs_version: str = None,
  app_entrypoint: str = None,
  edge_lambda_auto_discover: bool = None,
  integration_test_auto_discover: bool = None,
  lambda_auto_discover: bool = None,
  lambda_extension_auto_discover: bool = None,
  lambda_options: LambdaFunctionCommonOptions = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorOrganization">author_organization</a></code> | <code>bool</code> | Is the author an organization. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorUrl">author_url</a></code> | <code>str</code> | Author's URL / Website. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoDetectBin">auto_detect_bin</a></code> | <code>bool</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bin">bin</a></code> | <code>typing.Mapping[str]</code> | Binary programs vended with your module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bugsEmail">bugs_email</a></code> | <code>str</code> | The email address to which issues should be reported. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bugsUrl">bugs_url</a></code> | <code>str</code> | The url to your project's issue tracker. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bundledDeps">bundled_deps</a></code> | <code>typing.List[str]</code> | List of dependencies to bundle into this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.codeArtifactOptions">code_artifact_options</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.deps">deps</a></code> | <code>typing.List[str]</code> | Runtime dependencies of this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.description">description</a></code> | <code>str</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | Build dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.entrypoint">entrypoint</a></code> | <code>str</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.homepage">homepage</a></code> | <code>str</code> | Package's Homepage / Website. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.keywords">keywords</a></code> | <code>typing.List[str]</code> | Keywords to include in `package.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.license">license</a></code> | <code>str</code> | License's SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.licensed">licensed</a></code> | <code>bool</code> | Indicates if a license should be added. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmAccess">npm_access</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmRegistry">npm_registry</a></code> | <code>str</code> | The host name of the npm registry to publish to. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmRegistryUrl">npm_registry_url</a></code> | <code>str</code> | The base URL of the npm package registry. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmTokenSecret">npm_token_secret</a></code> | <code>str</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.packageName">package_name</a></code> | <code>str</code> | The "name" in package.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.peerDependencyOptions">peer_dependency_options</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.peerDeps">peer_deps</a></code> | <code>typing.List[str]</code> | Peer dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.pnpmVersion">pnpm_version</a></code> | <code>str</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.repository">repository</a></code> | <code>str</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.repositoryDirectory">repository_directory</a></code> | <code>str</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.scopedPackagesOptions">scoped_packages_options</a></code> | <code>typing.List[projen.javascript.ScopedPackagesOptions]</code> | Options for privately hosted scoped packages. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.scripts">scripts</a></code> | <code>typing.Mapping[str]</code> | npm scripts to include. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.stability">stability</a></code> | <code>str</code> | Package's Stability. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.jsiiReleaseVersion">jsii_release_version</a></code> | <code>str</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.majorVersion">major_version</a></code> | <code>typing.Union[int, float]</code> | Major version to release from the default branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.minMajorVersion">min_major_version</a></code> | <code>typing.Union[int, float]</code> | Minimal Major version to release. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmDistTag">npm_dist_tag</a></code> | <code>str</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.postBuildSteps">post_build_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.prerelease">prerelease</a></code> | <code>str</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.publishDryRun">publish_dry_run</a></code> | <code>bool</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.publishTasks">publish_tasks</a></code> | <code>bool</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseBranches">release_branches</a></code> | <code>typing.Mapping[projen.release.BranchOptions]</code> | Defines additional release branches. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseEveryCommit">release_every_commit</a></code> | <code>bool</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseFailureIssue">release_failure_issue</a></code> | <code>bool</code> | Create a github issue on every failed publishing task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseFailureIssueLabel">release_failure_issue_label</a></code> | <code>str</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseSchedule">release_schedule</a></code> | <code>str</code> | CRON schedule to trigger new releases. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseTagPrefix">release_tag_prefix</a></code> | <code>str</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseTrigger">release_trigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseWorkflowName">release_workflow_name</a></code> | <code>str</code> | The name of the default release workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseWorkflowSetupSteps">release_workflow_setup_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.versionrcOptions">versionrc_options</a></code> | <code>typing.Mapping[typing.Any]</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowContainerImage">workflow_container_image</a></code> | <code>str</code> | Container image to use for GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowRunsOn">workflow_runs_on</a></code> | <code>typing.List[str]</code> | Github Runner selection labels. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.defaultReleaseBranch">default_release_branch</a></code> | <code>str</code> | The name of the main release branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | A directory which will contain build artifacts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoApproveUpgrades">auto_approve_upgrades</a></code> | <code>bool</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.buildWorkflow">build_workflow</a></code> | <code>bool</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.buildWorkflowTriggers">build_workflow_triggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bundlerOptions">bundler_options</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.codeCov">code_cov</a></code> | <code>bool</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.codeCovTokenSecret">code_cov_token_secret</a></code> | <code>str</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.copyrightOwner">copyright_owner</a></code> | <code>str</code> | License copyright owner. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.copyrightPeriod">copyright_period</a></code> | <code>str</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.dependabot">dependabot</a></code> | <code>bool</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.dependabotOptions">dependabot_options</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.depsUpgrade">deps_upgrade</a></code> | <code>bool</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.depsUpgradeOptions">deps_upgrade_options</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitignore">gitignore</a></code> | <code>typing.List[str]</code> | Additional entries to .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.jest">jest</a></code> | <code>bool</code> | Setup jest unit tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.jestOptions">jest_options</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.mutableBuild">mutable_build</a></code> | <code>bool</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmignore">npmignore</a></code> | <code>typing.List[str]</code> | Additional entries to .npmignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmignoreEnabled">npmignore_enabled</a></code> | <code>bool</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmIgnoreOptions">npm_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.package">package</a></code> | <code>bool</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.prettier">prettier</a></code> | <code>bool</code> | Setup prettier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.prettierOptions">prettier_options</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenDevDependency">projen_dev_dependency</a></code> | <code>bool</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenVersion">projen_version</a></code> | <code>str</code> | Version of projen to install. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.pullRequestTemplate">pull_request_template</a></code> | <code>bool</code> | Include a GitHub pull request template. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.pullRequestTemplateContents">pull_request_template_contents</a></code> | <code>typing.List[str]</code> | The contents of the pull request template. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.release">release</a></code> | <code>bool</code> | Add release management to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseToNpm">release_to_npm</a></code> | <code>bool</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseWorkflow">release_workflow</a></code> | <code>bool</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowBootstrapSteps">workflow_bootstrap_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowGitIdentity">workflow_git_identity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowNodeVersion">workflow_node_version</a></code> | <code>str</code> | The node version to use in GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.disableTsconfig">disable_tsconfig</a></code> | <code>bool</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.disableTsconfigDev">disable_tsconfig_dev</a></code> | <code>bool</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.docgen">docgen</a></code> | <code>bool</code> | Docgen by Typedoc. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.docsDirectory">docs_directory</a></code> | <code>str</code> | Docs directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.entrypointTypes">entrypoint_types</a></code> | <code>str</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.eslint">eslint</a></code> | <code>bool</code> | Setup eslint. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.eslintOptions">eslint_options</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.libdir">libdir</a></code> | <code>str</code> | Typescript  artifacts output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.sampleCode">sample_code</a></code> | <code>bool</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.srcdir">srcdir</a></code> | <code>str</code> | Typescript sources directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.testdir">testdir</a></code> | <code>str</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.tsconfigDevFile">tsconfig_dev_file</a></code> | <code>str</code> | The name of the development tsconfig.json file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.typescriptVersion">typescript_version</a></code> | <code>str</code> | TypeScript version to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.buildCommand">build_command</a></code> | <code>str</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkout">cdkout</a></code> | <code>str</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.context">context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.featureFlags">feature_flags</a></code> | <code>bool</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.requireApproval">require_approval</a></code> | <code>projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.watchExcludes">watch_excludes</a></code> | <code>typing.List[str]</code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.watchIncludes">watch_includes</a></code> | <code>typing.List[str]</code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkVersion">cdk_version</a></code> | <code>str</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkAssert">cdk_assert</a></code> | <code>bool</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkAssertions">cdk_assertions</a></code> | <code>bool</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkDependencies">cdk_dependencies</a></code> | <code>typing.List[str]</code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkDependenciesAsDeps">cdk_dependencies_as_deps</a></code> | <code>bool</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkTestDependencies">cdk_test_dependencies</a></code> | <code>typing.List[str]</code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkVersionPinning">cdk_version_pinning</a></code> | <code>bool</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.constructsVersion">constructs_version</a></code> | <code>str</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.appEntrypoint">app_entrypoint</a></code> | <code>str</code> | The CDK app's entrypoint (relative to the source directory, which is "src" by default). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.edgeLambdaAutoDiscover">edge_lambda_auto_discover</a></code> | <code>bool</code> | Automatically adds an `cloudfront.experimental.EdgeFunction` for each `.edge-lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.integrationTestAutoDiscover">integration_test_auto_discover</a></code> | <code>bool</code> | Automatically discovers and creates integration tests for each `.integ.ts` file in under your test directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.lambdaAutoDiscover">lambda_auto_discover</a></code> | <code>bool</code> | Automatically adds an `awscdk.LambdaFunction` for each `.lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.lambdaExtensionAutoDiscover">lambda_extension_auto_discover</a></code> | <code>bool</code> | Automatically adds an `awscdk.LambdaExtension` for each `.lambda-extension.ts` entrypoint in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.lambdaOptions">lambda_options</a></code> | <code>projen.awscdk.LambdaFunctionCommonOptions</code> | Common options for all AWS Lambda functions. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.name"></a>

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.commitGenerated"></a>

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitOptions"></a>

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.logging"></a>

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.outdir"></a>

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.parent"></a>

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenCommand"></a>

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJson"></a>

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.renovatebot"></a>

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoMerge"></a>

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.clobber"></a>

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.devContainer"></a>

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.github"></a>

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.githubOptions"></a>

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitpod"></a>

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenCredentials"></a>

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.readme"></a>

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.stale"></a>

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.staleOptions"></a>

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.vscode"></a>

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allow_library_dependencies`<sup>Optional</sup> <a name="allow_library_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.allowLibraryDependencies"></a>

- *Type:* bool
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `author_email`<sup>Optional</sup> <a name="author_email" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorEmail"></a>

- *Type:* str

Author's e-mail.

---

##### `author_name`<sup>Optional</sup> <a name="author_name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorName"></a>

- *Type:* str

Author's name.

---

##### `author_organization`<sup>Optional</sup> <a name="author_organization" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorOrganization"></a>

- *Type:* bool

Is the author an organization.

---

##### `author_url`<sup>Optional</sup> <a name="author_url" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorUrl"></a>

- *Type:* str

Author's URL / Website.

---

##### `auto_detect_bin`<sup>Optional</sup> <a name="auto_detect_bin" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoDetectBin"></a>

- *Type:* bool
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bin"></a>

- *Type:* typing.Mapping[str]

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugs_email`<sup>Optional</sup> <a name="bugs_email" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bugsEmail"></a>

- *Type:* str

The email address to which issues should be reported.

---

##### `bugs_url`<sup>Optional</sup> <a name="bugs_url" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bugsUrl"></a>

- *Type:* str

The url to your project's issue tracker.

---

##### `bundled_deps`<sup>Optional</sup> <a name="bundled_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bundledDeps"></a>

- *Type:* typing.List[str]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `code_artifact_options`<sup>Optional</sup> <a name="code_artifact_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.codeArtifactOptions"></a>

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.deps"></a>

- *Type:* typing.List[str]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.description"></a>

- *Type:* str

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.devDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.entrypoint"></a>

- *Type:* str
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.homepage"></a>

- *Type:* str

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.keywords"></a>

- *Type:* typing.List[str]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.license"></a>

- *Type:* str
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.licensed"></a>

- *Type:* bool
- *Default:* true

Indicates if a license should be added.

---

##### `max_node_version`<sup>Optional</sup> <a name="max_node_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.maxNodeVersion"></a>

- *Type:* str
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `min_node_version`<sup>Optional</sup> <a name="min_node_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.minNodeVersion"></a>

- *Type:* str
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npm_access`<sup>Optional</sup> <a name="npm_access" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmAccess"></a>

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npm_registry`~~<sup>Optional</sup> <a name="npm_registry" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

- *Type:* str

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npm_registry_url`<sup>Optional</sup> <a name="npm_registry_url" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmRegistryUrl"></a>

- *Type:* str
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npm_token_secret`<sup>Optional</sup> <a name="npm_token_secret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmTokenSecret"></a>

- *Type:* str
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `package_manager`<sup>Optional</sup> <a name="package_manager" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.packageManager"></a>

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.packageName"></a>

- *Type:* str
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peer_dependency_options`<sup>Optional</sup> <a name="peer_dependency_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.peerDependencyOptions"></a>

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peer_deps`<sup>Optional</sup> <a name="peer_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.peerDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpm_version`<sup>Optional</sup> <a name="pnpm_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.pnpmVersion"></a>

- *Type:* str
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.repository"></a>

- *Type:* str

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repository_directory`<sup>Optional</sup> <a name="repository_directory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.repositoryDirectory"></a>

- *Type:* str

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scoped_packages_options`<sup>Optional</sup> <a name="scoped_packages_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.scopedPackagesOptions"></a>

- *Type:* typing.List[projen.javascript.ScopedPackagesOptions]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

- *Type:* typing.Mapping[str]
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.stability"></a>

- *Type:* str

Package's Stability.

---

##### `jsii_release_version`<sup>Optional</sup> <a name="jsii_release_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.jsiiReleaseVersion"></a>

- *Type:* str
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `major_version`<sup>Optional</sup> <a name="major_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.majorVersion"></a>

- *Type:* typing.Union[int, float]
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `min_major_version`<sup>Optional</sup> <a name="min_major_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.minMajorVersion"></a>

- *Type:* typing.Union[int, float]
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npm_dist_tag`<sup>Optional</sup> <a name="npm_dist_tag" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmDistTag"></a>

- *Type:* str
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `post_build_steps`<sup>Optional</sup> <a name="post_build_steps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.postBuildSteps"></a>

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.prerelease"></a>

- *Type:* str
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publish_dry_run`<sup>Optional</sup> <a name="publish_dry_run" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.publishDryRun"></a>

- *Type:* bool
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publish_tasks`<sup>Optional</sup> <a name="publish_tasks" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.publishTasks"></a>

- *Type:* bool
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `release_branches`<sup>Optional</sup> <a name="release_branches" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseBranches"></a>

- *Type:* typing.Mapping[projen.release.BranchOptions]
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`release_every_commit`~~<sup>Optional</sup> <a name="release_every_commit" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

- *Type:* bool
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `release_failure_issue`<sup>Optional</sup> <a name="release_failure_issue" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseFailureIssue"></a>

- *Type:* bool
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `release_failure_issue_label`<sup>Optional</sup> <a name="release_failure_issue_label" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseFailureIssueLabel"></a>

- *Type:* str
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`release_schedule`~~<sup>Optional</sup> <a name="release_schedule" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

- *Type:* str
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `release_tag_prefix`<sup>Optional</sup> <a name="release_tag_prefix" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseTagPrefix"></a>

- *Type:* str
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `release_trigger`<sup>Optional</sup> <a name="release_trigger" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseTrigger"></a>

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `release_workflow_name`<sup>Optional</sup> <a name="release_workflow_name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseWorkflowName"></a>

- *Type:* str
- *Default:* "Release"

The name of the default release workflow.

---

##### `release_workflow_setup_steps`<sup>Optional</sup> <a name="release_workflow_setup_steps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseWorkflowSetupSteps"></a>

- *Type:* typing.List[projen.github.workflows.JobStep]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrc_options`<sup>Optional</sup> <a name="versionrc_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.versionrcOptions"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflow_container_image`<sup>Optional</sup> <a name="workflow_container_image" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowContainerImage"></a>

- *Type:* str
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflow_runs_on`<sup>Optional</sup> <a name="workflow_runs_on" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowRunsOn"></a>

- *Type:* typing.List[str]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `default_release_branch`<sup>Required</sup> <a name="default_release_branch" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.defaultReleaseBranch"></a>

- *Type:* str
- *Default:* "main"

The name of the main release branch.

---

##### `artifacts_directory`<sup>Optional</sup> <a name="artifacts_directory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.artifactsDirectory"></a>

- *Type:* str
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `auto_approve_upgrades`<sup>Optional</sup> <a name="auto_approve_upgrades" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoApproveUpgrades"></a>

- *Type:* bool
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `build_workflow`<sup>Optional</sup> <a name="build_workflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.buildWorkflow"></a>

- *Type:* bool
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `build_workflow_triggers`<sup>Optional</sup> <a name="build_workflow_triggers" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.buildWorkflowTriggers"></a>

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundler_options`<sup>Optional</sup> <a name="bundler_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bundlerOptions"></a>

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `code_cov`<sup>Optional</sup> <a name="code_cov" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.codeCov"></a>

- *Type:* bool
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret.

---

##### `code_cov_token_secret`<sup>Optional</sup> <a name="code_cov_token_secret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.codeCovTokenSecret"></a>

- *Type:* str
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyright_owner`<sup>Optional</sup> <a name="copyright_owner" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.copyrightOwner"></a>

- *Type:* str
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyright_period`<sup>Optional</sup> <a name="copyright_period" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.copyrightPeriod"></a>

- *Type:* str
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.dependabot"></a>

- *Type:* bool
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabot_options`<sup>Optional</sup> <a name="dependabot_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.dependabotOptions"></a>

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `deps_upgrade`<sup>Optional</sup> <a name="deps_upgrade" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.depsUpgrade"></a>

- *Type:* bool
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `deps_upgrade_options`<sup>Optional</sup> <a name="deps_upgrade_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.depsUpgradeOptions"></a>

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitignore"></a>

- *Type:* typing.List[str]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.jest"></a>

- *Type:* bool
- *Default:* true

Setup jest unit tests.

---

##### `jest_options`<sup>Optional</sup> <a name="jest_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.jestOptions"></a>

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutable_build`<sup>Optional</sup> <a name="mutable_build" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.mutableBuild"></a>

- *Type:* bool
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

- *Type:* typing.List[str]

Additional entries to .npmignore.

---

##### `npmignore_enabled`<sup>Optional</sup> <a name="npmignore_enabled" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmignoreEnabled"></a>

- *Type:* bool
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npm_ignore_options`<sup>Optional</sup> <a name="npm_ignore_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.package"></a>

- *Type:* bool
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.prettier"></a>

- *Type:* bool
- *Default:* false

Setup prettier.

---

##### `prettier_options`<sup>Optional</sup> <a name="prettier_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.prettierOptions"></a>

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projen_dev_dependency`<sup>Optional</sup> <a name="projen_dev_dependency" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenDevDependency"></a>

- *Type:* bool
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJs"></a>

- *Type:* bool
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projen_version`<sup>Optional</sup> <a name="projen_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenVersion"></a>

- *Type:* str
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pull_request_template`<sup>Optional</sup> <a name="pull_request_template" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.pullRequestTemplate"></a>

- *Type:* bool
- *Default:* true

Include a GitHub pull request template.

---

##### `pull_request_template_contents`<sup>Optional</sup> <a name="pull_request_template_contents" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.pullRequestTemplateContents"></a>

- *Type:* typing.List[str]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.release"></a>

- *Type:* bool
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `release_to_npm`<sup>Optional</sup> <a name="release_to_npm" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseToNpm"></a>

- *Type:* bool
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`release_workflow`~~<sup>Optional</sup> <a name="release_workflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseWorkflow"></a>

- *Deprecated:* see `release`.

- *Type:* bool
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflow_bootstrap_steps`<sup>Optional</sup> <a name="workflow_bootstrap_steps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowBootstrapSteps"></a>

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflow_git_identity`<sup>Optional</sup> <a name="workflow_git_identity" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowGitIdentity"></a>

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflow_node_version`<sup>Optional</sup> <a name="workflow_node_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowNodeVersion"></a>

- *Type:* str
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `disable_tsconfig`<sup>Optional</sup> <a name="disable_tsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.disableTsconfig"></a>

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disable_tsconfig_dev`<sup>Optional</sup> <a name="disable_tsconfig_dev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.disableTsconfigDev"></a>

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.docgen"></a>

- *Type:* bool
- *Default:* false

Docgen by Typedoc.

---

##### `docs_directory`<sup>Optional</sup> <a name="docs_directory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.docsDirectory"></a>

- *Type:* str
- *Default:* "docs"

Docs directory.

---

##### `entrypoint_types`<sup>Optional</sup> <a name="entrypoint_types" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.entrypointTypes"></a>

- *Type:* str
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.eslint"></a>

- *Type:* bool
- *Default:* true

Setup eslint.

---

##### `eslint_options`<sup>Optional</sup> <a name="eslint_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.eslintOptions"></a>

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.libdir"></a>

- *Type:* str
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcTs"></a>

- *Type:* bool
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sample_code`<sup>Optional</sup> <a name="sample_code" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.sampleCode"></a>

- *Type:* bool
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.srcdir"></a>

- *Type:* str
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.testdir"></a>

- *Type:* str
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.tsconfig"></a>

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfig_dev`<sup>Optional</sup> <a name="tsconfig_dev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.tsconfigDev"></a>

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfig_dev_file`<sup>Optional</sup> <a name="tsconfig_dev_file" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.tsconfigDevFile"></a>

- *Type:* str
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescript_version`<sup>Optional</sup> <a name="typescript_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.typescriptVersion"></a>

- *Type:* str
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `build_command`<sup>Optional</sup> <a name="build_command" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.buildCommand"></a>

- *Type:* str
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkout"></a>

- *Type:* str
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.context"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `feature_flags`<sup>Optional</sup> <a name="feature_flags" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.featureFlags"></a>

- *Type:* bool
- *Default:* true

Include all feature flags in cdk.json.

---

##### `require_approval`<sup>Optional</sup> <a name="require_approval" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.requireApproval"></a>

- *Type:* projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watch_excludes`<sup>Optional</sup> <a name="watch_excludes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.watchExcludes"></a>

- *Type:* typing.List[str]
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watch_includes`<sup>Optional</sup> <a name="watch_includes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.watchIncludes"></a>

- *Type:* typing.List[str]
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdk_version`<sup>Required</sup> <a name="cdk_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkVersion"></a>

- *Type:* str
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdk_assert`~~<sup>Optional</sup> <a name="cdk_assert" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkAssert"></a>

- *Deprecated:* The

- *Type:* bool
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdk_assertions`<sup>Optional</sup> <a name="cdk_assertions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkAssertions"></a>

- *Type:* bool
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdk_dependencies`~~<sup>Optional</sup> <a name="cdk_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

- *Type:* typing.List[str]

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdk_dependencies_as_deps`~~<sup>Optional</sup> <a name="cdk_dependencies_as_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

- *Type:* bool
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdk_test_dependencies`~~<sup>Optional</sup> <a name="cdk_test_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

- *Type:* typing.List[str]

AWS CDK modules required for testing.

---

##### `cdk_version_pinning`<sup>Optional</sup> <a name="cdk_version_pinning" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkVersionPinning"></a>

- *Type:* bool

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructs_version`<sup>Optional</sup> <a name="constructs_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.constructsVersion"></a>

- *Type:* str
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `app_entrypoint`<sup>Optional</sup> <a name="app_entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.appEntrypoint"></a>

- *Type:* str
- *Default:* "main.ts"

The CDK app's entrypoint (relative to the source directory, which is "src" by default).

---

##### `edge_lambda_auto_discover`<sup>Optional</sup> <a name="edge_lambda_auto_discover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.edgeLambdaAutoDiscover"></a>

- *Type:* bool
- *Default:* true

Automatically adds an `cloudfront.experimental.EdgeFunction` for each `.edge-lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `integration_test_auto_discover`<sup>Optional</sup> <a name="integration_test_auto_discover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.integrationTestAutoDiscover"></a>

- *Type:* bool
- *Default:* true

Automatically discovers and creates integration tests for each `.integ.ts` file in under your test directory.

---

##### `lambda_auto_discover`<sup>Optional</sup> <a name="lambda_auto_discover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.lambdaAutoDiscover"></a>

- *Type:* bool
- *Default:* true

Automatically adds an `awscdk.LambdaFunction` for each `.lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `lambda_extension_auto_discover`<sup>Optional</sup> <a name="lambda_extension_auto_discover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.lambdaExtensionAutoDiscover"></a>

- *Type:* bool
- *Default:* true

Automatically adds an `awscdk.LambdaExtension` for each `.lambda-extension.ts` entrypoint in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `lambda_options`<sup>Optional</sup> <a name="lambda_options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.lambdaOptions"></a>

- *Type:* projen.awscdk.LambdaFunctionCommonOptions
- *Default:* default options

Common options for all AWS Lambda functions.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addExcludeFromCleanup">add_exclude_from_cleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addGitIgnore">add_git_ignore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPackageIgnore">add_package_ignore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask">add_task</a></code> | Adds a new task to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTip">add_tip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.annotateGenerated">annotate_generated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.postSynthesize">post_synthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.preSynthesize">pre_synthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeTask">remove_task</a></code> | Removes a task from a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.runTaskCommand">run_task_command</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindFile">try_find_file</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindJsonFile">try_find_json_file</a></code> | Finds a json file by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindObjectFile">try_find_object_file</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryRemoveFile">try_remove_file</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBins">add_bins</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBundledDeps">add_bundled_deps</a></code> | Defines bundled dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCompileCommand">add_compile_command</a></code> | DEPRECATED. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDeps">add_deps</a></code> | Defines normal dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDevDeps">add_dev_deps</a></code> | Defines development/test dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addFields">add_fields</a></code> | Directly set fields in `package.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addKeywords">add_keywords</a></code> | Adds keywords to package.json (deduplicated). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPeerDeps">add_peer_deps</a></code> | Defines peer dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addScripts">add_scripts</a></code> | Replaces the contents of multiple npm package.json scripts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTestCommand">add_test_command</a></code> | DEPRECATED. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.hasScript">has_script</a></code> | Indicates if a script by the name name is defined. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeScript">remove_script</a></code> | Removes the npm script (always successful). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.renderWorkflowSetup">render_workflow_setup</a></code> | Returns the set of workflow steps which should be executed to bootstrap a workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.setScript">set_script</a></code> | Replaces the contents of an npm package.json script. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCdkDependency">add_cdk_dependency</a></code> | Adds an AWS CDK module dependencies. |

---

##### `add_exclude_from_cleanup` <a name="add_exclude_from_cleanup" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addExcludeFromCleanup"></a>

```python
def add_exclude_from_cleanup(
  globs: str
) -> None
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* str

The glob patterns to match.

---

##### `add_git_ignore` <a name="add_git_ignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addGitIgnore"></a>

```python
def add_git_ignore(
  pattern: str
) -> None
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addGitIgnore.parameter.pattern"></a>

- *Type:* str

The glob pattern to ignore.

---

##### `add_package_ignore` <a name="add_package_ignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPackageIgnore"></a>

```python
def add_package_ignore(
  pattern: str
) -> None
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPackageIgnore.parameter.pattern"></a>

- *Type:* str

---

##### `add_task` <a name="add_task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask"></a>

```python
def add_task(
  name: str,
  condition: str = None,
  cwd: str = None,
  description: str = None,
  env: typing.Mapping[str] = None,
  required_env: typing.List[str] = None,
  args: typing.List[str] = None,
  exec: str = None,
  receive_args: bool = None,
  steps: typing.List[TaskStep] = None
) -> Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.name"></a>

- *Type:* str

The task name to add.

---

###### `condition`<sup>Optional</sup> <a name="condition" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.condition"></a>

- *Type:* str

A shell command which determines if the this task should be executed.

If
the program exits with a zero exit code, steps will be executed. A non-zero
code means that task will be skipped.

---

###### `cwd`<sup>Optional</sup> <a name="cwd" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.cwd"></a>

- *Type:* str
- *Default:* process.cwd()

The working directory for all steps in this task (unless overridden by the step).

---

###### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.description"></a>

- *Type:* str
- *Default:* the task name

The description of this build command.

---

###### `env`<sup>Optional</sup> <a name="env" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.env"></a>

- *Type:* typing.Mapping[str]
- *Default:* {}

Defines environment variables for the execution of this task.

Values in this map will be evaluated in a shell, so you can do stuff like `$(echo "foo")`.

---

###### `required_env`<sup>Optional</sup> <a name="required_env" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.requiredEnv"></a>

- *Type:* typing.List[str]

A set of environment variables that must be defined in order to execute this task.

Task execution will fail if one of these is not defined.

---

###### `args`<sup>Optional</sup> <a name="args" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.args"></a>

- *Type:* typing.List[str]
- *Default:* no arguments are passed to the step

Should the provided `exec` shell command receive fixed args.

> [{@link TaskStepOptions.args }]({@link TaskStepOptions.args })

---

###### `exec`<sup>Optional</sup> <a name="exec" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.exec"></a>

- *Type:* str
- *Default:* add steps using `task.exec(command)` or `task.spawn(subtask)`

Shell command to execute as the first command of the task.

---

###### `receive_args`<sup>Optional</sup> <a name="receive_args" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.receiveArgs"></a>

- *Type:* bool
- *Default:* false

Should the provided `exec` shell command receive args passed to the task.

> [{@link TaskStepOptions.receiveArgs }]({@link TaskStepOptions.receiveArgs })

---

###### `steps`<sup>Optional</sup> <a name="steps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.steps"></a>

- *Type:* typing.List[projen.TaskStep]

List of task steps to run.

---

##### ~~`add_tip`~~ <a name="add_tip" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTip"></a>

```python
def add_tip(
  message: str
) -> None
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTip.parameter.message"></a>

- *Type:* str

The message.

---

##### `annotate_generated` <a name="annotate_generated" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.annotateGenerated"></a>

```python
def annotate_generated(
  glob: str
) -> None
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.annotateGenerated.parameter.glob"></a>

- *Type:* str

the glob pattern to match (could be a file path).

---

##### `post_synthesize` <a name="post_synthesize" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.postSynthesize"></a>

```python
def post_synthesize() -> None
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `pre_synthesize` <a name="pre_synthesize" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.preSynthesize"></a>

```python
def pre_synthesize() -> None
```

Called before all components are synthesized.

##### `remove_task` <a name="remove_task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeTask"></a>

```python
def remove_task(
  name: str
) -> Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeTask.parameter.name"></a>

- *Type:* str

The name of the task to remove.

---

##### `run_task_command` <a name="run_task_command" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.runTaskCommand"></a>

```python
def run_task_command(
  task: Task
) -> str
```

Returns the shell command to execute in order to run a task.

This will
typically be `npx projen TASK`.

###### `task`<sup>Required</sup> <a name="task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.synth"></a>

```python
def synth() -> None
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `try_find_file` <a name="try_find_file" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindFile"></a>

```python
def try_find_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`try_find_json_file`~~ <a name="try_find_json_file" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindJsonFile"></a>

```python
def try_find_json_file(
  file_path: str
) -> JsonFile
```

Finds a json file by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### `try_find_object_file` <a name="try_find_object_file" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindObjectFile"></a>

```python
def try_find_object_file(
  file_path: str
) -> ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### `try_remove_file` <a name="try_remove_file" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryRemoveFile"></a>

```python
def try_remove_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `file_path`<sup>Required</sup> <a name="file_path" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `add_bins` <a name="add_bins" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBins"></a>

```python
def add_bins(
  bins: typing.Mapping[str]
) -> None
```

###### `bins`<sup>Required</sup> <a name="bins" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBins.parameter.bins"></a>

- *Type:* typing.Mapping[str]

---

##### `add_bundled_deps` <a name="add_bundled_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBundledDeps"></a>

```python
def add_bundled_deps(
  deps: str
) -> None
```

Defines bundled dependencies.

Bundled dependencies will be added as normal dependencies as well as to the
`bundledDependencies` section of your `package.json`.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBundledDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`add_compile_command`~~ <a name="add_compile_command" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCompileCommand"></a>

```python
def add_compile_command(
  commands: str
) -> None
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCompileCommand.parameter.commands"></a>

- *Type:* str

---

##### `add_deps` <a name="add_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDeps"></a>

```python
def add_deps(
  deps: str
) -> None
```

Defines normal dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `add_dev_deps` <a name="add_dev_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDevDeps"></a>

```python
def add_dev_deps(
  deps: str
) -> None
```

Defines development/test dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDevDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `add_fields` <a name="add_fields" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addFields"></a>

```python
def add_fields(
  fields: typing.Mapping[typing.Any]
) -> None
```

Directly set fields in `package.json`.

###### `fields`<sup>Required</sup> <a name="fields" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addFields.parameter.fields"></a>

- *Type:* typing.Mapping[typing.Any]

The fields to set.

---

##### `add_keywords` <a name="add_keywords" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addKeywords"></a>

```python
def add_keywords(
  keywords: str
) -> None
```

Adds keywords to package.json (deduplicated).

###### `keywords`<sup>Required</sup> <a name="keywords" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addKeywords.parameter.keywords"></a>

- *Type:* str

The keywords to add.

---

##### `add_peer_deps` <a name="add_peer_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPeerDeps"></a>

```python
def add_peer_deps(
  deps: str
) -> None
```

Defines peer dependencies.

When adding peer dependencies, a devDependency will also be added on the
pinned version of the declared peer. This will ensure that you are testing
your code against the minimum version required from your consumers.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPeerDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `add_scripts` <a name="add_scripts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addScripts"></a>

```python
def add_scripts(
  scripts: typing.Mapping[str]
) -> None
```

Replaces the contents of multiple npm package.json scripts.

###### `scripts`<sup>Required</sup> <a name="scripts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addScripts.parameter.scripts"></a>

- *Type:* typing.Mapping[str]

The scripts to set.

---

##### ~~`add_test_command`~~ <a name="add_test_command" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTestCommand"></a>

```python
def add_test_command(
  commands: str
) -> None
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTestCommand.parameter.commands"></a>

- *Type:* str

---

##### ~~`has_script`~~ <a name="has_script" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.hasScript"></a>

```python
def has_script(
  name: str
) -> bool
```

Indicates if a script by the name name is defined.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.hasScript.parameter.name"></a>

- *Type:* str

The name of the script.

---

##### `remove_script` <a name="remove_script" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeScript"></a>

```python
def remove_script(
  name: str
) -> None
```

Removes the npm script (always successful).

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeScript.parameter.name"></a>

- *Type:* str

The name of the script.

---

##### `render_workflow_setup` <a name="render_workflow_setup" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.renderWorkflowSetup"></a>

```python
def render_workflow_setup(
  mutable: bool = None
) -> typing.List[JobStep]
```

Returns the set of workflow steps which should be executed to bootstrap a workflow.

###### `mutable`<sup>Optional</sup> <a name="mutable" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.renderWorkflowSetup.parameter.mutable"></a>

- *Type:* bool
- *Default:* false

Should the pacakge lockfile be updated?

---

##### `set_script` <a name="set_script" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.setScript"></a>

```python
def set_script(
  name: str,
  command: str
) -> None
```

Replaces the contents of an npm package.json script.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.setScript.parameter.name"></a>

- *Type:* str

The script name.

---

###### `command`<sup>Required</sup> <a name="command" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.setScript.parameter.command"></a>

- *Type:* str

The command to execute.

---

##### `add_cdk_dependency` <a name="add_cdk_dependency" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCdkDependency"></a>

```python
def add_cdk_dependency(
  modules: str
) -> None
```

Adds an AWS CDK module dependencies.

###### `modules`<sup>Required</sup> <a name="modules" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCdkDependency.parameter.modules"></a>

- *Type:* str

The list of modules to depend on.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildTask">build_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.compileTask">compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.components">components</a></code> | <code>typing.List[projen.Component]</code> | Returns all the components within this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.ejected">ejected</a></code> | <code>bool</code> | Whether or not the project is being ejected. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.files">files</a></code> | <code>typing.List[projen.FileBase]</code> | All files in this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.name">name</a></code> | <code>str</code> | Project name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.outdir">outdir</a></code> | <code>str</code> | Absolute output directory of this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.packageTask">package_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.postCompileTask">post_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.preCompileTask">pre_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projectBuild">project_build</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projenCommand">projen_command</a></code> | <code>str</code> | The command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.testTask">test_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.defaultTask">default_task</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.initProject">init_project</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.autoApprove">auto_approve</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.devContainer">dev_container</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | The build output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.artifactsJavascriptDirectory">artifacts_javascript_directory</a></code> | <code>str</code> | The location of the npm tarball after build (`${artifactsDirectory}/js`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.bundler">bundler</a></code> | <code>projen.javascript.Bundler</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.entrypoint">entrypoint</a></code> | <code>str</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.manifest">manifest</a></code> | <code>typing.Any</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.npmrc">npmrc</a></code> | <code>projen.javascript.NpmConfig</code> | The .npmrc file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.package">package</a></code> | <code>projen.javascript.NodePackage</code> | API for managing the node package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The package manager to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.runScriptCommand">run_script_command</a></code> | <code>str</code> | The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.autoMerge">auto_merge</a></code> | <code>projen.github.AutoMerge</code> | Component that sets up mergify for merging approved pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildWorkflow">build_workflow</a></code> | <code>projen.build.BuildWorkflow</code> | The PR build GitHub workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildWorkflowJobId">build_workflow_job_id</a></code> | <code>str</code> | The job ID of the build workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.jest">jest</a></code> | <code>projen.javascript.Jest</code> | The Jest configuration (if enabled). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Maximum node version required by this package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum node.js version required by this package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.npmignore">npmignore</a></code> | <code>projen.IgnoreFile</code> | The .npmignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.prettier">prettier</a></code> | <code>projen.javascript.Prettier</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.publisher">publisher</a></code> | <code>projen.release.Publisher</code> | Package publisher. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.release">release</a></code> | <code>projen.release.Release</code> | Release management. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.upgradeWorkflow">upgrade_workflow</a></code> | <code>projen.javascript.UpgradeDependencies</code> | The upgrade workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.docsDirectory">docs_directory</a></code> | <code>str</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.libdir">libdir</a></code> | <code>str</code> | The directory in which compiled .js files reside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.srcdir">srcdir</a></code> | <code>str</code> | The directory in which the .ts sources reside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.testdir">testdir</a></code> | <code>str</code> | The directory in which tests reside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfig</code> | A typescript configuration file which covers all files (sources, tests, projen). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.watchTask">watch_task</a></code> | <code>projen.Task</code> | The "watch" task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.docgen">docgen</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.eslint">eslint</a></code> | <code>projen.javascript.Eslint</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfigEslint">tsconfig_eslint</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.appEntrypoint">app_entrypoint</a></code> | <code>str</code> | The CDK app entrypoint. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkConfig">cdk_config</a></code> | <code>projen.awscdk.CdkConfig</code> | cdk.json configuration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkDeps">cdk_deps</a></code> | <code>projen.awscdk.AwsCdkDeps</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkTasks">cdk_tasks</a></code> | <code>projen.awscdk.CdkTasks</code> | Common CDK tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkVersion">cdk_version</a></code> | <code>str</code> | The CDK version this app is using. |

---

##### `build_task`<sup>Required</sup> <a name="build_task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildTask"></a>

```python
build_task: Task
```

- *Type:* projen.Task

---

##### `commit_generated`<sup>Required</sup> <a name="commit_generated" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool

Whether to commit the managed files by default.

---

##### `compile_task`<sup>Required</sup> <a name="compile_task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.compileTask"></a>

```python
compile_task: Task
```

- *Type:* projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.components"></a>

```python
components: typing.List[Component]
```

- *Type:* typing.List[projen.Component]

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.deps"></a>

```python
deps: Dependencies
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.ejected"></a>

```python
ejected: bool
```

- *Type:* bool

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.files"></a>

```python
files: typing.List[FileBase]
```

- *Type:* typing.List[projen.FileBase]

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitattributes"></a>

```python
gitattributes: GitAttributesFile
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitignore"></a>

```python
gitignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.logger"></a>

```python
logger: Logger
```

- *Type:* projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.name"></a>

```python
name: str
```

- *Type:* str

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.outdir"></a>

```python
outdir: str
```

- *Type:* str

Absolute output directory of this project.

---

##### `package_task`<sup>Required</sup> <a name="package_task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.packageTask"></a>

```python
package_task: Task
```

- *Type:* projen.Task

---

##### `post_compile_task`<sup>Required</sup> <a name="post_compile_task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.postCompileTask"></a>

```python
post_compile_task: Task
```

- *Type:* projen.Task

---

##### `pre_compile_task`<sup>Required</sup> <a name="pre_compile_task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.preCompileTask"></a>

```python
pre_compile_task: Task
```

- *Type:* projen.Task

---

##### `project_build`<sup>Required</sup> <a name="project_build" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projectBuild"></a>

```python
project_build: ProjectBuild
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### `projen_command`<sup>Required</sup> <a name="projen_command" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.root"></a>

```python
root: Project
```

- *Type:* projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tasks"></a>

```python
tasks: Tasks
```

- *Type:* projen.Tasks

Project tasks.

---

##### `test_task`<sup>Required</sup> <a name="test_task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.testTask"></a>

```python
test_task: Task
```

- *Type:* projen.Task

---

##### `default_task`<sup>Optional</sup> <a name="default_task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.defaultTask"></a>

```python
default_task: Task
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `init_project`<sup>Optional</sup> <a name="init_project" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.initProject"></a>

```python
init_project: InitProject
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### `project_type`<sup>Required</sup> <a name="project_type" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projectType"></a>

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType

---

##### `auto_approve`<sup>Optional</sup> <a name="auto_approve" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.autoApprove"></a>

```python
auto_approve: AutoApprove
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.devContainer"></a>

```python
dev_container: DevContainer
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.github"></a>

```python
github: GitHub
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitpod"></a>

```python
gitpod: Gitpod
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.vscode"></a>

```python
vscode: VsCode
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`allow_library_dependencies`~~<sup>Required</sup> <a name="allow_library_dependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.allowLibraryDependencies"></a>

- *Deprecated:* use `package.allowLibraryDependencies`

```python
allow_library_dependencies: bool
```

- *Type:* bool

---

##### `artifacts_directory`<sup>Required</sup> <a name="artifacts_directory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.artifactsDirectory"></a>

```python
artifacts_directory: str
```

- *Type:* str

The build output directory.

An npm tarball will be created under the `js`
subdirectory. For example, if this is set to `dist` (the default), the npm
tarball will be placed under `dist/js/boom-boom-1.2.3.tg`.

---

##### `artifacts_javascript_directory`<sup>Required</sup> <a name="artifacts_javascript_directory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.artifactsJavascriptDirectory"></a>

```python
artifacts_javascript_directory: str
```

- *Type:* str

The location of the npm tarball after build (`${artifactsDirectory}/js`).

---

##### `bundler`<sup>Required</sup> <a name="bundler" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.bundler"></a>

```python
bundler: Bundler
```

- *Type:* projen.javascript.Bundler

---

##### ~~`entrypoint`~~<sup>Required</sup> <a name="entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.entrypoint"></a>

- *Deprecated:* use `package.entrypoint`

```python
entrypoint: str
```

- *Type:* str

---

##### ~~`manifest`~~<sup>Required</sup> <a name="manifest" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.manifest"></a>

- *Deprecated:* use `package.addField(x, y)`

```python
manifest: typing.Any
```

- *Type:* typing.Any

---

##### `npmrc`<sup>Required</sup> <a name="npmrc" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.npmrc"></a>

```python
npmrc: NpmConfig
```

- *Type:* projen.javascript.NpmConfig

The .npmrc file.

---

##### `package`<sup>Required</sup> <a name="package" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.package"></a>

```python
package: NodePackage
```

- *Type:* projen.javascript.NodePackage

API for managing the node package.

---

##### ~~`package_manager`~~<sup>Required</sup> <a name="package_manager" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.packageManager"></a>

- *Deprecated:* use `package.packageManager`

```python
package_manager: NodePackageManager
```

- *Type:* projen.javascript.NodePackageManager

The package manager to use.

---

##### `run_script_command`<sup>Required</sup> <a name="run_script_command" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.runScriptCommand"></a>

```python
run_script_command: str
```

- *Type:* str

The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager).

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.autoMerge"></a>

```python
auto_merge: AutoMerge
```

- *Type:* projen.github.AutoMerge

Component that sets up mergify for merging approved pull requests.

---

##### `build_workflow`<sup>Optional</sup> <a name="build_workflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildWorkflow"></a>

```python
build_workflow: BuildWorkflow
```

- *Type:* projen.build.BuildWorkflow

The PR build GitHub workflow.

`undefined` if `buildWorkflow` is disabled.

---

##### `build_workflow_job_id`<sup>Optional</sup> <a name="build_workflow_job_id" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildWorkflowJobId"></a>

```python
build_workflow_job_id: str
```

- *Type:* str

The job ID of the build workflow.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.jest"></a>

```python
jest: Jest
```

- *Type:* projen.javascript.Jest

The Jest configuration (if enabled).

---

##### `max_node_version`<sup>Optional</sup> <a name="max_node_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.maxNodeVersion"></a>

```python
max_node_version: str
```

- *Type:* str

Maximum node version required by this package.

---

##### `min_node_version`<sup>Optional</sup> <a name="min_node_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.minNodeVersion"></a>

```python
min_node_version: str
```

- *Type:* str

Minimum node.js version required by this package.

---

##### `npmignore`<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.npmignore"></a>

```python
npmignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

The .npmignore file.

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.prettier"></a>

```python
prettier: Prettier
```

- *Type:* projen.javascript.Prettier

---

##### ~~`publisher`~~<sup>Optional</sup> <a name="publisher" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.publisher"></a>

- *Deprecated:* use `release.publisher`.

```python
publisher: Publisher
```

- *Type:* projen.release.Publisher

Package publisher.

This will be `undefined` if the project does not have a
release workflow.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.release"></a>

```python
release: Release
```

- *Type:* projen.release.Release

Release management.

---

##### `upgrade_workflow`<sup>Optional</sup> <a name="upgrade_workflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.upgradeWorkflow"></a>

```python
upgrade_workflow: UpgradeDependencies
```

- *Type:* projen.javascript.UpgradeDependencies

The upgrade workflow.

---

##### `docs_directory`<sup>Required</sup> <a name="docs_directory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.docsDirectory"></a>

```python
docs_directory: str
```

- *Type:* str

---

##### `libdir`<sup>Required</sup> <a name="libdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.libdir"></a>

```python
libdir: str
```

- *Type:* str

The directory in which compiled .js files reside.

---

##### `srcdir`<sup>Required</sup> <a name="srcdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.srcdir"></a>

```python
srcdir: str
```

- *Type:* str

The directory in which the .ts sources reside.

---

##### `testdir`<sup>Required</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.testdir"></a>

```python
testdir: str
```

- *Type:* str

The directory in which tests reside.

---

##### `tsconfig_dev`<sup>Required</sup> <a name="tsconfig_dev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfigDev"></a>

```python
tsconfig_dev: TypescriptConfig
```

- *Type:* projen.javascript.TypescriptConfig

A typescript configuration file which covers all files (sources, tests, projen).

---

##### `watch_task`<sup>Required</sup> <a name="watch_task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.watchTask"></a>

```python
watch_task: Task
```

- *Type:* projen.Task

The "watch" task.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.docgen"></a>

```python
docgen: bool
```

- *Type:* bool

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.eslint"></a>

```python
eslint: Eslint
```

- *Type:* projen.javascript.Eslint

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfig"></a>

```python
tsconfig: TypescriptConfig
```

- *Type:* projen.javascript.TypescriptConfig

---

##### `tsconfig_eslint`<sup>Optional</sup> <a name="tsconfig_eslint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfigEslint"></a>

```python
tsconfig_eslint: TypescriptConfig
```

- *Type:* projen.javascript.TypescriptConfig

---

##### `app_entrypoint`<sup>Required</sup> <a name="app_entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.appEntrypoint"></a>

```python
app_entrypoint: str
```

- *Type:* str

The CDK app entrypoint.

---

##### `cdk_config`<sup>Required</sup> <a name="cdk_config" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkConfig"></a>

```python
cdk_config: CdkConfig
```

- *Type:* projen.awscdk.CdkConfig

cdk.json configuration.

---

##### `cdk_deps`<sup>Required</sup> <a name="cdk_deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkDeps"></a>

```python
cdk_deps: AwsCdkDeps
```

- *Type:* projen.awscdk.AwsCdkDeps

---

##### `cdk_tasks`<sup>Required</sup> <a name="cdk_tasks" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkTasks"></a>

```python
cdk_tasks: CdkTasks
```

- *Type:* projen.awscdk.CdkTasks

Common CDK tasks.

---

##### `cdk_version`<sup>Required</sup> <a name="cdk_version" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkVersion"></a>

```python
cdk_version: str
```

- *Type:* str

The CDK version this app is using.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>str</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.DEFAULT_TASK"></a>

```python
DEFAULT_TASK: str
```

- *Type:* str

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---


