> **DEPRECATION NOTICE:** The `aws-prototyping-sdk` is on path to deprecation. This package is simply a wrapper around the individual `@aws-prototyping-skd/*` packages and has no unique code aside from bundling the other packages. Due to lack of significant value compared to maintenance overhead, this package will be deprecated soon in favor of using the individual packages directly. Please use the individual packages starting now to prevent future migration and loss of update capabilities.

The aws-prototyping-sdk provides stable CDK and Projen constructs, allowing developers to have access to higher level abstractions than provided by the CDK or Projen alone.

For detailed documentation, please refer to the [documentation website](https://aws.github.io/aws-prototyping-sdk/).

## Bundling

This package simply bundles various packages from the `@aws-prototyping-sdk` namespace which have been marked as `stable`. As such, not all constructs or classes may be exported from this package and will need to be explicitly imported by creating a dependency on the individual packages.

To illustrate, at the time of writing the following individual packages are published:

```
@aws-prototyping-sdk
        |_ pipeline       : [stable]
        |_ nx-monorepo    : [stable]
        |_ static-website : [experimental]
        |_ identity       : [experimental]
```

The aws-prototyping-sdk package will bundle all stable packages and export them as namespaces as follows:

```
aws-prototyping-sdk
        |_ pipeline
        |_ nx_monorepo
```

This means if you wanted to access the PDKPipeline which is a stable construct, you simply add a dependency on the `aws-prototyping-sdk` and import it as follows:

```java
// Example automatically generated from non-compiling source. May contain errors.
import aws.prototyping.sdk.nx_monorepo.*;
import aws.prototyping.sdk.pipeline.*;
```

To import `experimental` constructs, a dependency on the individual package is required. In the case of `static-website`, a dependency on `@aws-prototyping-sdk/static-website` is required. The constructs can then be imported as follows:

```java
// Example automatically generated from non-compiling source. May contain errors.
import aws.prototyping.sdk.static.website.StaticWebsite;
```
# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### PDKNagApp <a name="PDKNagApp" id="aws-prototyping-sdk.pdk_nag.PDKNagApp"></a>

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNagApp;

PDKNagApp.Builder.create()
//  .analyticsReporting(java.lang.Boolean)
//  .autoSynth(java.lang.Boolean)
//  .context(java.util.Map<java.lang.String, java.lang.Object>)
//  .defaultStackSynthesizer(IReusableStackSynthesizer)
//  .outdir(java.lang.String)
//  .postCliContext(java.util.Map<java.lang.String, java.lang.Object>)
//  .stackTraces(java.lang.Boolean)
//  .treeMetadata(java.lang.Boolean)
//  .failOnError(java.lang.Boolean)
//  .failOnWarning(java.lang.Boolean)
//  .nagPacks(java.util.List<NagPack>)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.analyticsReporting">analyticsReporting</a></code> | <code>java.lang.Boolean</code> | Include runtime versioning information in the Stacks of this app. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.autoSynth">autoSynth</a></code> | <code>java.lang.Boolean</code> | Automatically call `synth()` before the program exits. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.context">context</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context values for the application. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.defaultStackSynthesizer">defaultStackSynthesizer</a></code> | <code>software.amazon.awscdk.IReusableStackSynthesizer</code> | The stack synthesizer to use by default for all Stacks in the App. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.outdir">outdir</a></code> | <code>java.lang.String</code> | The output directory into which to emit synthesized artifacts. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.postCliContext">postCliContext</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context values for the application. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.stackTraces">stackTraces</a></code> | <code>java.lang.Boolean</code> | Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.treeMetadata">treeMetadata</a></code> | <code>java.lang.Boolean</code> | Include construct tree metadata as part of the Cloud Assembly. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.failOnError">failOnError</a></code> | <code>java.lang.Boolean</code> | Determines whether any errors encountered should trigger a test failure. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.failOnWarning">failOnWarning</a></code> | <code>java.lang.Boolean</code> | Determines whether any warnings encountered should trigger a test failure. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.nagPacks">nagPacks</a></code> | <code>java.util.List<io.github.cdklabs.cdknag.NagPack></code> | Custom nag packs to execute. |

---

##### `analyticsReporting`<sup>Optional</sup> <a name="analyticsReporting" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.analyticsReporting"></a>

- *Type:* java.lang.Boolean
- *Default:* Value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in the Stacks of this app.

---

##### `autoSynth`<sup>Optional</sup> <a name="autoSynth" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.autoSynth"></a>

- *Type:* java.lang.Boolean
- *Default:* true if running via CDK CLI (`CDK_OUTDIR` is set), `false` otherwise

Automatically call `synth()` before the program exits.

If you set this, you don't have to call `synth()` explicitly. Note that
this feature is only available for certain programming languages, and
calling `synth()` is still recommended.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.context"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context values for the application.

Context set by the CLI or the `context` key in `cdk.json` has precedence.

Context can be read from any construct using `node.getContext(key)`.

---

##### `defaultStackSynthesizer`<sup>Optional</sup> <a name="defaultStackSynthesizer" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.defaultStackSynthesizer"></a>

- *Type:* software.amazon.awscdk.IReusableStackSynthesizer
- *Default:* A `DefaultStackSynthesizer` with default settings

The stack synthesizer to use by default for all Stacks in the App.

The Stack Synthesizer controls aspects of synthesis and deployment,
like how assets are referenced and what IAM roles to use. For more
information, see the README of the main CDK package.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.outdir"></a>

- *Type:* java.lang.String
- *Default:* If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.   If `CDK_OUTDIR` is not defined, uses a temp directory.

The output directory into which to emit synthesized artifacts.

You should never need to set this value. By default, the value you pass to
the CLI's `--output` flag will be used, and if you change it to a different
directory the CLI will fail to pick up the generated Cloud Assembly.

This property is intended for internal and testing use.

---

##### `postCliContext`<sup>Optional</sup> <a name="postCliContext" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.postCliContext"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context values for the application.

Context provided here has precedence over context set by:

- The CLI via --context
- The `context` key in `cdk.json`
- The `AppProps.context` property

This property is recommended over the `AppProps.context` property since you
can make final decision over which context value to take in your app.

Context can be read from any construct using `node.getContext(key)`.

---

*Example*

```java
// context from the CLI and from `cdk.json` are stored in the
// CDK_CONTEXT env variable
const cliContext = JSON.parse(process.env.CDK_CONTEXT!);

// determine whether to take the context passed in the CLI or not
const determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
new App({
  postCliContext: {
    SOMEKEY: determineValue,
  },
});
```


##### `stackTraces`<sup>Optional</sup> <a name="stackTraces" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.stackTraces"></a>

- *Type:* java.lang.Boolean
- *Default:* true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.

Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.

---

##### `treeMetadata`<sup>Optional</sup> <a name="treeMetadata" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.treeMetadata"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include construct tree metadata as part of the Cloud Assembly.

---

##### `failOnError`<sup>Optional</sup> <a name="failOnError" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.failOnError"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Determines whether any errors encountered should trigger a test failure.

---

##### `failOnWarning`<sup>Optional</sup> <a name="failOnWarning" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.failOnWarning"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Determines whether any warnings encountered should trigger a test failure.

---

##### `nagPacks`<sup>Optional</sup> <a name="nagPacks" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.Initializer.parameter.nagPacks"></a>

- *Type:* java.util.List<io.github.cdklabs.cdknag.NagPack>
- *Default:* DEFAULT_NAG_PACKS

Custom nag packs to execute.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.synth">synth</a></code> | Synthesize this stage into a cloud assembly. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.addNagResult">addNagResult</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.nagResults">nagResults</a></code> | Returns a list of NagResult. |

---

##### `toString` <a name="toString" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.toString"></a>

```java
public java.lang.String toString()
```

Returns a string representation of this construct.

##### `synth` <a name="synth" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.synth"></a>

```java
public CloudAssembly synth()
public CloudAssembly synth(StageSynthesisOptions options)
```

Synthesize this stage into a cloud assembly.

Once an assembly has been synthesized, it cannot be modified. Subsequent
calls will return the same assembly.

###### `options`<sup>Optional</sup> <a name="options" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.synth.parameter.options"></a>

- *Type:* software.amazon.awscdk.StageSynthesisOptions

---

##### `addNagResult` <a name="addNagResult" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.addNagResult"></a>

```java
public void addNagResult(NagResult result)
```

###### `result`<sup>Required</sup> <a name="result" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.addNagResult.parameter.result"></a>

- *Type:* software.aws.awsprototypingsdk.pdknag.NagResult

---

##### `nagResults` <a name="nagResults" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.nagResults"></a>

```java
public java.util.List<NagResult> nagResults()
```

Returns a list of NagResult.

Note: app.synth() must be called before this to retrieve results.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.isStage">isStage</a></code> | Test whether the given construct is a stage. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.of">of</a></code> | Return the stage this construct is contained with, if available. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.isApp">isApp</a></code> | Checks if an object is an instance of the `App` class. |

---

##### `isConstruct` <a name="isConstruct" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isConstruct"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNagApp;

PDKNagApp.isConstruct(java.lang.Object x)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isConstruct.parameter.x"></a>

- *Type:* java.lang.Object

Any object.

---

##### `isStage` <a name="isStage" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isStage"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNagApp;

PDKNagApp.isStage(java.lang.Object x)
```

Test whether the given construct is a stage.

###### `x`<sup>Required</sup> <a name="x" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isStage.parameter.x"></a>

- *Type:* java.lang.Object

---

##### `of` <a name="of" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.of"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNagApp;

PDKNagApp.of(IConstruct construct)
```

Return the stage this construct is contained with, if available.

If called
on a nested stage, returns its parent.

###### `construct`<sup>Required</sup> <a name="construct" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.of.parameter.construct"></a>

- *Type:* software.constructs.IConstruct

---

##### `isApp` <a name="isApp" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isApp"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNagApp;

PDKNagApp.isApp(java.lang.Object obj)
```

Checks if an object is an instance of the `App` class.

###### `obj`<sup>Required</sup> <a name="obj" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.isApp.parameter.obj"></a>

- *Type:* java.lang.Object

The object to evaluate.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.node">node</a></code> | <code>software.constructs.Node</code> | The tree node. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.artifactId">artifactId</a></code> | <code>java.lang.String</code> | Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.assetOutdir">assetOutdir</a></code> | <code>java.lang.String</code> | The cloud assembly asset output directory. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The cloud assembly output directory. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.stageName">stageName</a></code> | <code>java.lang.String</code> | The name of the stage. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.account">account</a></code> | <code>java.lang.String</code> | The default account for all resources defined within this stage. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.parentStage">parentStage</a></code> | <code>software.amazon.awscdk.Stage</code> | The parent stage or `undefined` if this is the app. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.region">region</a></code> | <code>java.lang.String</code> | The default region for all resources defined within this stage. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagApp.property.nagPacks">nagPacks</a></code> | <code>java.util.List<io.github.cdklabs.cdknag.NagPack></code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.node"></a>

```java
public Node getNode();
```

- *Type:* software.constructs.Node

The tree node.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.artifactId"></a>

```java
public java.lang.String getArtifactId();
```

- *Type:* java.lang.String

Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string.

Derived from the construct path.

---

##### `assetOutdir`<sup>Required</sup> <a name="assetOutdir" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.assetOutdir"></a>

```java
public java.lang.String getAssetOutdir();
```

- *Type:* java.lang.String

The cloud assembly asset output directory.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String

The cloud assembly output directory.

---

##### `stageName`<sup>Required</sup> <a name="stageName" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.stageName"></a>

```java
public java.lang.String getStageName();
```

- *Type:* java.lang.String

The name of the stage.

Based on names of the parent stages separated by
hypens.

---

##### `account`<sup>Optional</sup> <a name="account" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.account"></a>

```java
public java.lang.String getAccount();
```

- *Type:* java.lang.String

The default account for all resources defined within this stage.

---

##### `parentStage`<sup>Optional</sup> <a name="parentStage" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.parentStage"></a>

```java
public Stage getParentStage();
```

- *Type:* software.amazon.awscdk.Stage

The parent stage or `undefined` if this is the app.

*

---

##### `region`<sup>Optional</sup> <a name="region" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.region"></a>

```java
public java.lang.String getRegion();
```

- *Type:* java.lang.String

The default region for all resources defined within this stage.

---

##### `nagPacks`<sup>Required</sup> <a name="nagPacks" id="aws-prototyping-sdk.pdk_nag.PDKNagApp.property.nagPacks"></a>

```java
public java.util.List<NagPack> getNagPacks();
```

- *Type:* java.util.List<io.github.cdklabs.cdknag.NagPack>

---


### PDKPipeline <a name="PDKPipeline" id="aws-prototyping-sdk.pipeline.PDKPipeline"></a>

An extension to CodePipeline which configures sane defaults for a NX Monorepo codebase.

In addition to this, it also creates a CodeCommit repository with
automated PR builds and approvals.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pipeline.PDKPipeline;

PDKPipeline.Builder.create(Construct scope, java.lang.String id)
    .synth(IFileSetProducer)
//  .assetPublishingCodeBuildDefaults(CodeBuildOptions)
//  .cliVersion(java.lang.String)
//  .codeBuildDefaults(CodeBuildOptions)
//  .codePipeline(Pipeline)
//  .crossAccountKeys(java.lang.Boolean)
//  .dockerCredentials(java.util.List<DockerCredential>)
//  .dockerEnabledForSelfMutation(java.lang.Boolean)
//  .dockerEnabledForSynth(java.lang.Boolean)
//  .enableKeyRotation(java.lang.Boolean)
//  .pipelineName(java.lang.String)
//  .publishAssetsInParallel(java.lang.Boolean)
//  .reuseCrossRegionSupportStacks(java.lang.Boolean)
//  .role(IRole)
//  .selfMutation(java.lang.Boolean)
//  .selfMutationCodeBuildDefaults(CodeBuildOptions)
//  .synthCodeBuildDefaults(CodeBuildOptions)
//  .useChangeSets(java.lang.Boolean)
    .primarySynthDirectory(java.lang.String)
    .repositoryName(java.lang.String)
//  .codeCommitRemovalPolicy(RemovalPolicy)
//  .defaultBranchName(java.lang.String)
//  .sonarCodeScannerConfig(SonarCodeScannerConfig)
//  .synthShellStepPartialProps(ShellStepProps)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.scope">scope</a></code> | <code>software.constructs.Construct</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.id">id</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.synth">synth</a></code> | <code>software.amazon.awscdk.pipelines.IFileSetProducer</code> | The build step that produces the CDK Cloud Assembly. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.assetPublishingCodeBuildDefaults">assetPublishingCodeBuildDefaults</a></code> | <code>software.amazon.awscdk.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the asset publishing CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.cliVersion">cliVersion</a></code> | <code>java.lang.String</code> | CDK CLI version to use in self-mutation and asset publishing steps. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.codeBuildDefaults">codeBuildDefaults</a></code> | <code>software.amazon.awscdk.pipelines.CodeBuildOptions</code> | Customize the CodeBuild projects created for this pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.codePipeline">codePipeline</a></code> | <code>software.amazon.awscdk.services.codepipeline.Pipeline</code> | An existing Pipeline to be reused and built upon. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.crossAccountKeys">crossAccountKeys</a></code> | <code>java.lang.Boolean</code> | Create KMS keys for the artifact buckets, allowing cross-account deployments. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.dockerCredentials">dockerCredentials</a></code> | <code>java.util.List<software.amazon.awscdk.pipelines.DockerCredential></code> | A list of credentials used to authenticate to Docker registries. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.dockerEnabledForSelfMutation">dockerEnabledForSelfMutation</a></code> | <code>java.lang.Boolean</code> | Enable Docker for the self-mutate step. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.dockerEnabledForSynth">dockerEnabledForSynth</a></code> | <code>java.lang.Boolean</code> | Enable Docker for the 'synth' step. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.enableKeyRotation">enableKeyRotation</a></code> | <code>java.lang.Boolean</code> | Enable KMS key rotation for the generated KMS keys. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.pipelineName">pipelineName</a></code> | <code>java.lang.String</code> | The name of the CodePipeline pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.publishAssetsInParallel">publishAssetsInParallel</a></code> | <code>java.lang.Boolean</code> | Publish assets in multiple CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.reuseCrossRegionSupportStacks">reuseCrossRegionSupportStacks</a></code> | <code>java.lang.Boolean</code> | Reuse the same cross region support stack for all pipelines in the App. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.role">role</a></code> | <code>software.amazon.awscdk.services.iam.IRole</code> | The IAM role to be assumed by this Pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.selfMutation">selfMutation</a></code> | <code>java.lang.Boolean</code> | Whether the pipeline will update itself. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.selfMutationCodeBuildDefaults">selfMutationCodeBuildDefaults</a></code> | <code>software.amazon.awscdk.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the self mutation CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.synthCodeBuildDefaults">synthCodeBuildDefaults</a></code> | <code>software.amazon.awscdk.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the synthesize CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.useChangeSets">useChangeSets</a></code> | <code>java.lang.Boolean</code> | Deploy every stack by creating a change set and executing it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.primarySynthDirectory">primarySynthDirectory</a></code> | <code>java.lang.String</code> | Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.repositoryName">repositoryName</a></code> | <code>java.lang.String</code> | Name of the CodeCommit repository to create. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.codeCommitRemovalPolicy">codeCommitRemovalPolicy</a></code> | <code>software.amazon.awscdk.RemovalPolicy</code> | Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.defaultBranchName">defaultBranchName</a></code> | <code>java.lang.String</code> | Branch to trigger the pipeline execution. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.sonarCodeScannerConfig">sonarCodeScannerConfig</a></code> | <code>software.aws.awsprototypingsdk.pipeline.SonarCodeScannerConfig</code> | Configuration for enabling Sonarqube code scanning on a successful synth. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.synthShellStepPartialProps">synthShellStepPartialProps</a></code> | <code>software.amazon.awscdk.pipelines.ShellStepProps</code> | PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.scope"></a>

- *Type:* software.constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.id"></a>

- *Type:* java.lang.String

---

##### `synth`<sup>Required</sup> <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.synth"></a>

- *Type:* software.amazon.awscdk.pipelines.IFileSetProducer

The build step that produces the CDK Cloud Assembly.

The primary output of this step needs to be the `cdk.out` directory
generated by the `cdk synth` command.

If you use a `ShellStep` here and you don't configure an output directory,
the output directory will automatically be assumed to be `cdk.out`.

---

##### `assetPublishingCodeBuildDefaults`<sup>Optional</sup> <a name="assetPublishingCodeBuildDefaults" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.assetPublishingCodeBuildDefaults"></a>

- *Type:* software.amazon.awscdk.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the asset publishing CodeBuild projects.

---

##### `cliVersion`<sup>Optional</sup> <a name="cliVersion" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.cliVersion"></a>

- *Type:* java.lang.String
- *Default:* Latest version

CDK CLI version to use in self-mutation and asset publishing steps.

If you want to lock the CDK CLI version used in the pipeline, by steps
that are automatically generated for you, specify the version here.

We recommend you do not specify this value, as not specifying it always
uses the latest CLI version which is backwards compatible with old versions.

If you do specify it, be aware that this version should always be equal to or higher than the
version of the CDK framework used by the CDK app, when the CDK commands are
run during your pipeline execution. When you change this version, the *next
time* the `SelfMutate` step runs it will still be using the CLI of the the
*previous* version that was in this property: it will only start using the
new version after `SelfMutate` completes successfully. That means that if
you want to update both framework and CLI version, you should update the
CLI version first, commit, push and deploy, and only then update the
framework version.

---

##### `codeBuildDefaults`<sup>Optional</sup> <a name="codeBuildDefaults" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.codeBuildDefaults"></a>

- *Type:* software.amazon.awscdk.pipelines.CodeBuildOptions
- *Default:* All projects run non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_6_0

Customize the CodeBuild projects created for this pipeline.

---

##### `codePipeline`<sup>Optional</sup> <a name="codePipeline" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.codePipeline"></a>

- *Type:* software.amazon.awscdk.services.codepipeline.Pipeline
- *Default:* a new underlying pipeline is created.

An existing Pipeline to be reused and built upon.

[disable-awslint:ref-via-interface]

---

##### `crossAccountKeys`<sup>Optional</sup> <a name="crossAccountKeys" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.crossAccountKeys"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Create KMS keys for the artifact buckets, allowing cross-account deployments.

The artifact buckets have to be encrypted to support deploying CDK apps to
another account, so if you want to do that or want to have your artifact
buckets encrypted, be sure to set this value to `true`.

Be aware there is a cost associated with maintaining the KMS keys.

---

##### `dockerCredentials`<sup>Optional</sup> <a name="dockerCredentials" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.dockerCredentials"></a>

- *Type:* java.util.List<software.amazon.awscdk.pipelines.DockerCredential>
- *Default:* []

A list of credentials used to authenticate to Docker registries.

Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.

---

##### `dockerEnabledForSelfMutation`<sup>Optional</sup> <a name="dockerEnabledForSelfMutation" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.dockerEnabledForSelfMutation"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Enable Docker for the self-mutate step.

Set this to true if the pipeline itself uses Docker container assets
(for example, if you use `LinuxBuildImage.fromAsset()` as the build
image of a CodeBuild step in the pipeline).

You do not need to set it if you build Docker image assets in the
application Stages and Stacks that are *deployed* by this pipeline.

Configures privileged mode for the self-mutation CodeBuild action.

If you are about to turn this on in an already-deployed Pipeline,
set the value to `true` first, commit and allow the pipeline to
self-update, and only then use the Docker asset in the pipeline.

---

##### `dockerEnabledForSynth`<sup>Optional</sup> <a name="dockerEnabledForSynth" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.dockerEnabledForSynth"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Enable Docker for the 'synth' step.

Set this to true if you are using file assets that require
"bundling" anywhere in your application (meaning an asset
compilation step will be run with the tools provided by
a Docker image), both for the Pipeline stack as well as the
application stacks.

A common way to use bundling assets in your application is by
using the `@aws-cdk/aws-lambda-nodejs` library.

Configures privileged mode for the synth CodeBuild action.

If you are about to turn this on in an already-deployed Pipeline,
set the value to `true` first, commit and allow the pipeline to
self-update, and only then use the bundled asset.

---

##### `enableKeyRotation`<sup>Optional</sup> <a name="enableKeyRotation" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.enableKeyRotation"></a>

- *Type:* java.lang.Boolean
- *Default:* false (key rotation is disabled)

Enable KMS key rotation for the generated KMS keys.

By default KMS key rotation is disabled, but will add
additional costs when enabled.

---

##### `pipelineName`<sup>Optional</sup> <a name="pipelineName" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.pipelineName"></a>

- *Type:* java.lang.String
- *Default:* Automatically generated

The name of the CodePipeline pipeline.

---

##### `publishAssetsInParallel`<sup>Optional</sup> <a name="publishAssetsInParallel" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.publishAssetsInParallel"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Publish assets in multiple CodeBuild projects.

If set to false, use one Project per type to publish all assets.

Publishing in parallel improves concurrency and may reduce publishing
latency, but may also increase overall provisioning time of the CodeBuild
projects.

Experiment and see what value works best for you.

---

##### `reuseCrossRegionSupportStacks`<sup>Optional</sup> <a name="reuseCrossRegionSupportStacks" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.reuseCrossRegionSupportStacks"></a>

- *Type:* java.lang.Boolean
- *Default:* true (Use the same support stack for all pipelines in App)

Reuse the same cross region support stack for all pipelines in the App.

---

##### `role`<sup>Optional</sup> <a name="role" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.role"></a>

- *Type:* software.amazon.awscdk.services.iam.IRole
- *Default:* A new role is created

The IAM role to be assumed by this Pipeline.

---

##### `selfMutation`<sup>Optional</sup> <a name="selfMutation" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.selfMutation"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Whether the pipeline will update itself.

This needs to be set to `true` to allow the pipeline to reconfigure
itself when assets or stages are being added to it, and `true` is the
recommended setting.

You can temporarily set this to `false` while you are iterating
on the pipeline itself and prefer to deploy changes using `cdk deploy`.

---

##### `selfMutationCodeBuildDefaults`<sup>Optional</sup> <a name="selfMutationCodeBuildDefaults" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.selfMutationCodeBuildDefaults"></a>

- *Type:* software.amazon.awscdk.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the self mutation CodeBuild projects.

---

##### `synthCodeBuildDefaults`<sup>Optional</sup> <a name="synthCodeBuildDefaults" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.synthCodeBuildDefaults"></a>

- *Type:* software.amazon.awscdk.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the synthesize CodeBuild projects.

---

##### `useChangeSets`<sup>Optional</sup> <a name="useChangeSets" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.useChangeSets"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Deploy every stack by creating a change set and executing it.

When enabled, creates a "Prepare" and "Execute" action for each stack. Disable
to deploy the stack in one pipeline action.

---

##### `primarySynthDirectory`<sup>Required</sup> <a name="primarySynthDirectory" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.primarySynthDirectory"></a>

- *Type:* java.lang.String

Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out.

---

##### `repositoryName`<sup>Required</sup> <a name="repositoryName" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.repositoryName"></a>

- *Type:* java.lang.String

Name of the CodeCommit repository to create.

---

##### `codeCommitRemovalPolicy`<sup>Optional</sup> <a name="codeCommitRemovalPolicy" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.codeCommitRemovalPolicy"></a>

- *Type:* software.amazon.awscdk.RemovalPolicy

Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation.

---

##### `defaultBranchName`<sup>Optional</sup> <a name="defaultBranchName" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.defaultBranchName"></a>

- *Type:* java.lang.String
- *Default:* mainline

Branch to trigger the pipeline execution.

---

##### `sonarCodeScannerConfig`<sup>Optional</sup> <a name="sonarCodeScannerConfig" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.sonarCodeScannerConfig"></a>

- *Type:* software.aws.awsprototypingsdk.pipeline.SonarCodeScannerConfig
- *Default:* undefined

Configuration for enabling Sonarqube code scanning on a successful synth.

---

##### `synthShellStepPartialProps`<sup>Optional</sup> <a name="synthShellStepPartialProps" id="aws-prototyping-sdk.pipeline.PDKPipeline.Initializer.parameter.synthShellStepPartialProps"></a>

- *Type:* software.amazon.awscdk.pipelines.ShellStepProps

PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands.

To override these defaults
and/or provide additional inputs, specify env settings, etc you can provide
a partial ShellStepProps.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.addStage">addStage</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.buildPipeline">buildPipeline</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.suppressCDKViolations">suppressCDKViolations</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="aws-prototyping-sdk.pipeline.PDKPipeline.toString"></a>

```java
public java.lang.String toString()
```

Returns a string representation of this construct.

##### `addStage` <a name="addStage" id="aws-prototyping-sdk.pipeline.PDKPipeline.addStage"></a>

```java
public StageDeployment addStage(Stage stage)
public StageDeployment addStage(Stage stage, AddStageOpts options)
```

###### `stage`<sup>Required</sup> <a name="stage" id="aws-prototyping-sdk.pipeline.PDKPipeline.addStage.parameter.stage"></a>

- *Type:* software.amazon.awscdk.Stage

---

###### `options`<sup>Optional</sup> <a name="options" id="aws-prototyping-sdk.pipeline.PDKPipeline.addStage.parameter.options"></a>

- *Type:* software.amazon.awscdk.pipelines.AddStageOpts

---

##### `buildPipeline` <a name="buildPipeline" id="aws-prototyping-sdk.pipeline.PDKPipeline.buildPipeline"></a>

```java
public void buildPipeline()
```

##### `suppressCDKViolations` <a name="suppressCDKViolations" id="aws-prototyping-sdk.pipeline.PDKPipeline.suppressCDKViolations"></a>

```java
public void suppressCDKViolations()
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="aws-prototyping-sdk.pipeline.PDKPipeline.isConstruct"></a>

```java
import software.aws.awsprototypingsdk.pipeline.PDKPipeline;

PDKPipeline.isConstruct(java.lang.Object x)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="aws-prototyping-sdk.pipeline.PDKPipeline.isConstruct.parameter.x"></a>

- *Type:* java.lang.Object

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.property.node">node</a></code> | <code>software.constructs.Node</code> | The tree node. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.property.codePipeline">codePipeline</a></code> | <code>software.amazon.awscdk.pipelines.CodePipeline</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipeline.property.codeRepository">codeRepository</a></code> | <code>software.amazon.awscdk.services.codecommit.Repository</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="aws-prototyping-sdk.pipeline.PDKPipeline.property.node"></a>

```java
public Node getNode();
```

- *Type:* software.constructs.Node

The tree node.

---

##### `codePipeline`<sup>Required</sup> <a name="codePipeline" id="aws-prototyping-sdk.pipeline.PDKPipeline.property.codePipeline"></a>

```java
public CodePipeline getCodePipeline();
```

- *Type:* software.amazon.awscdk.pipelines.CodePipeline

---

##### `codeRepository`<sup>Required</sup> <a name="codeRepository" id="aws-prototyping-sdk.pipeline.PDKPipeline.property.codeRepository"></a>

```java
public Repository getCodeRepository();
```

- *Type:* software.amazon.awscdk.services.codecommit.Repository

---


### SonarCodeScanner <a name="SonarCodeScanner" id="aws-prototyping-sdk.pipeline.SonarCodeScanner"></a>

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pipeline.SonarCodeScanner;

SonarCodeScanner.Builder.create(Construct scope, java.lang.String id)
    .sonarqubeAuthorizedGroup(java.lang.String)
    .sonarqubeDefaultProfileOrGateName(java.lang.String)
    .sonarqubeEndpoint(java.lang.String)
    .sonarqubeProjectName(java.lang.String)
//  .cdkOutDir(java.lang.String)
//  .cfnNagIgnorePath(java.lang.String)
//  .excludeGlobsForScan(java.util.List<java.lang.String>)
//  .includeGlobsForScan(java.util.List<java.lang.String>)
//  .preArchiveCommands(java.util.List<java.lang.String>)
//  .sonarqubeSpecificProfileOrGateName(java.lang.String)
//  .sonarqubeTags(java.util.List<java.lang.String>)
    .artifactBucketArn(java.lang.String)
    .synthBuildArn(java.lang.String)
//  .artifactBucketKeyArn(java.lang.String)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.scope">scope</a></code> | <code>software.constructs.Construct</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.id">id</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeAuthorizedGroup">sonarqubeAuthorizedGroup</a></code> | <code>java.lang.String</code> | Group name in Sonarqube with access to administer this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeDefaultProfileOrGateName">sonarqubeDefaultProfileOrGateName</a></code> | <code>java.lang.String</code> | Default profile/gate name i.e: your org profile. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeEndpoint">sonarqubeEndpoint</a></code> | <code>java.lang.String</code> | endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeProjectName">sonarqubeProjectName</a></code> | <code>java.lang.String</code> | Name of the project to create in Sonarqube. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.cdkOutDir">cdkOutDir</a></code> | <code>java.lang.String</code> | directory containing the synthesized cdk resources. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.cfnNagIgnorePath">cfnNagIgnorePath</a></code> | <code>java.lang.String</code> | path to a file containing the cfn nag suppression rules. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.excludeGlobsForScan">excludeGlobsForScan</a></code> | <code>java.util.List<java.lang.String></code> | glob patterns to exclude from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.includeGlobsForScan">includeGlobsForScan</a></code> | <code>java.util.List<java.lang.String></code> | glob patterns to include from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.preArchiveCommands">preArchiveCommands</a></code> | <code>java.util.List<java.lang.String></code> | Hook which allows custom commands to be executed before the process commences the archival process. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeSpecificProfileOrGateName">sonarqubeSpecificProfileOrGateName</a></code> | <code>java.lang.String</code> | Specific profile/gate name i.e: language specific. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeTags">sonarqubeTags</a></code> | <code>java.util.List<java.lang.String></code> | Tags to associate with this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.artifactBucketArn">artifactBucketArn</a></code> | <code>java.lang.String</code> | S3 bucket ARN containing the built artifacts from the synth build. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.synthBuildArn">synthBuildArn</a></code> | <code>java.lang.String</code> | ARN for the CodeBuild task responsible for executing the synth command. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.artifactBucketKeyArn">artifactBucketKeyArn</a></code> | <code>java.lang.String</code> | Artifact bucket key ARN used to encrypt the artifacts. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.scope"></a>

- *Type:* software.constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.id"></a>

- *Type:* java.lang.String

---

##### `sonarqubeAuthorizedGroup`<sup>Required</sup> <a name="sonarqubeAuthorizedGroup" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeAuthorizedGroup"></a>

- *Type:* java.lang.String

Group name in Sonarqube with access to administer this project.

---

##### `sonarqubeDefaultProfileOrGateName`<sup>Required</sup> <a name="sonarqubeDefaultProfileOrGateName" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeDefaultProfileOrGateName"></a>

- *Type:* java.lang.String

Default profile/gate name i.e: your org profile.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqubeEndpoint`<sup>Required</sup> <a name="sonarqubeEndpoint" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeEndpoint"></a>

- *Type:* java.lang.String

endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>.

Note: Ensure a trailing '/' is not included.

---

##### `sonarqubeProjectName`<sup>Required</sup> <a name="sonarqubeProjectName" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeProjectName"></a>

- *Type:* java.lang.String

Name of the project to create in Sonarqube.

---

##### `cdkOutDir`<sup>Optional</sup> <a name="cdkOutDir" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.cdkOutDir"></a>

- *Type:* java.lang.String

directory containing the synthesized cdk resources.

---

##### `cfnNagIgnorePath`<sup>Optional</sup> <a name="cfnNagIgnorePath" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.cfnNagIgnorePath"></a>

- *Type:* java.lang.String

path to a file containing the cfn nag suppression rules.

---

##### `excludeGlobsForScan`<sup>Optional</sup> <a name="excludeGlobsForScan" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.excludeGlobsForScan"></a>

- *Type:* java.util.List<java.lang.String>

glob patterns to exclude from sonar scan.

---

##### `includeGlobsForScan`<sup>Optional</sup> <a name="includeGlobsForScan" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.includeGlobsForScan"></a>

- *Type:* java.util.List<java.lang.String>

glob patterns to include from sonar scan.

---

##### `preArchiveCommands`<sup>Optional</sup> <a name="preArchiveCommands" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.preArchiveCommands"></a>

- *Type:* java.util.List<java.lang.String>

Hook which allows custom commands to be executed before the process commences the archival process.

---

##### `sonarqubeSpecificProfileOrGateName`<sup>Optional</sup> <a name="sonarqubeSpecificProfileOrGateName" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeSpecificProfileOrGateName"></a>

- *Type:* java.lang.String

Specific profile/gate name i.e: language specific.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqubeTags`<sup>Optional</sup> <a name="sonarqubeTags" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.sonarqubeTags"></a>

- *Type:* java.util.List<java.lang.String>

Tags to associate with this project.

---

##### `artifactBucketArn`<sup>Required</sup> <a name="artifactBucketArn" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.artifactBucketArn"></a>

- *Type:* java.lang.String

S3 bucket ARN containing the built artifacts from the synth build.

---

##### `synthBuildArn`<sup>Required</sup> <a name="synthBuildArn" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.synthBuildArn"></a>

- *Type:* java.lang.String

ARN for the CodeBuild task responsible for executing the synth command.

---

##### `artifactBucketKeyArn`<sup>Optional</sup> <a name="artifactBucketKeyArn" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.Initializer.parameter.artifactBucketKeyArn"></a>

- *Type:* java.lang.String

Artifact bucket key ARN used to encrypt the artifacts.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.toString"></a>

```java
public java.lang.String toString()
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.isConstruct"></a>

```java
import software.aws.awsprototypingsdk.pipeline.SonarCodeScanner;

SonarCodeScanner.isConstruct(java.lang.Object x)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.isConstruct.parameter.x"></a>

- *Type:* java.lang.Object

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScanner.property.node">node</a></code> | <code>software.constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="aws-prototyping-sdk.pipeline.SonarCodeScanner.property.node"></a>

```java
public Node getNode();
```

- *Type:* software.constructs.Node

The tree node.

---


## Structs <a name="Structs" id="Structs"></a>

### Message <a name="Message" id="aws-prototyping-sdk.pdk_nag.Message"></a>

Message instance.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pdk_nag.Message.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pdknag.Message;

Message.builder()
    .messageDescription(java.lang.String)
    .messageType(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.Message.property.messageDescription">messageDescription</a></code> | <code>java.lang.String</code> | Message description. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.Message.property.messageType">messageType</a></code> | <code>java.lang.String</code> | Message type as returned from cdk-nag. |

---

##### `messageDescription`<sup>Required</sup> <a name="messageDescription" id="aws-prototyping-sdk.pdk_nag.Message.property.messageDescription"></a>

```java
public java.lang.String getMessageDescription();
```

- *Type:* java.lang.String

Message description.

---

##### `messageType`<sup>Required</sup> <a name="messageType" id="aws-prototyping-sdk.pdk_nag.Message.property.messageType"></a>

```java
public java.lang.String getMessageType();
```

- *Type:* java.lang.String

Message type as returned from cdk-nag.

---

### MonorepoUpgradeDepsOptions <a name="MonorepoUpgradeDepsOptions" id="aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions"></a>

Configuration for Monorepo Upgrade Deps task.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.nxmonorepo.MonorepoUpgradeDepsOptions;

MonorepoUpgradeDepsOptions.builder()
//  .syncpackConfig(SyncpackConfig)
//  .taskName(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.property.syncpackConfig">syncpackConfig</a></code> | <code>software.aws.awsprototypingsdk.nxmonorepo.SyncpackConfig</code> | Syncpack configuration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.property.taskName">taskName</a></code> | <code>java.lang.String</code> | Name of the task to create. |

---

##### `syncpackConfig`<sup>Optional</sup> <a name="syncpackConfig" id="aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.property.syncpackConfig"></a>

```java
public SyncpackConfig getSyncpackConfig();
```

- *Type:* software.aws.awsprototypingsdk.nxmonorepo.SyncpackConfig
- *Default:* SyncpackConfig.DEFAULT_CONFIG

Syncpack configuration.

No merging is performed and as such a complete syncpackConfig is required if supplied.

---

##### `taskName`<sup>Optional</sup> <a name="taskName" id="aws-prototyping-sdk.nx_monorepo.MonorepoUpgradeDepsOptions.property.taskName"></a>

```java
public java.lang.String getTaskName();
```

- *Type:* java.lang.String
- *Default:* upgrade-deps

Name of the task to create.

---

### NagResult <a name="NagResult" id="aws-prototyping-sdk.pdk_nag.NagResult"></a>

Nag result.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pdk_nag.NagResult.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pdknag.NagResult;

NagResult.builder()
    .messages(java.util.List<Message>)
    .resource(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.NagResult.property.messages">messages</a></code> | <code>java.util.List<software.aws.awsprototypingsdk.pdknag.Message></code> | List of messages. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.NagResult.property.resource">resource</a></code> | <code>java.lang.String</code> | Resource which triggered the message. |

---

##### `messages`<sup>Required</sup> <a name="messages" id="aws-prototyping-sdk.pdk_nag.NagResult.property.messages"></a>

```java
public java.util.List<Message> getMessages();
```

- *Type:* java.util.List<software.aws.awsprototypingsdk.pdknag.Message>

List of messages.

---

##### `resource`<sup>Required</sup> <a name="resource" id="aws-prototyping-sdk.pdk_nag.NagResult.property.resource"></a>

```java
public java.lang.String getResource();
```

- *Type:* java.lang.String

Resource which triggered the message.

---

### NxMonorepoProjectOptions <a name="NxMonorepoProjectOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions"></a>

Configuration options for the NxMonorepoProject.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.nxmonorepo.NxMonorepoProjectOptions;

NxMonorepoProjectOptions.builder()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
//  .allowLibraryDependencies(java.lang.Boolean)
//  .authorEmail(java.lang.String)
//  .authorName(java.lang.String)
//  .authorOrganization(java.lang.Boolean)
//  .authorUrl(java.lang.String)
//  .autoDetectBin(java.lang.Boolean)
//  .bin(java.util.Map<java.lang.String, java.lang.String>)
//  .bugsEmail(java.lang.String)
//  .bugsUrl(java.lang.String)
//  .bundledDeps(java.util.List<java.lang.String>)
//  .codeArtifactOptions(CodeArtifactOptions)
//  .deps(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .devDeps(java.util.List<java.lang.String>)
//  .entrypoint(java.lang.String)
//  .homepage(java.lang.String)
//  .keywords(java.util.List<java.lang.String>)
//  .license(java.lang.String)
//  .licensed(java.lang.Boolean)
//  .maxNodeVersion(java.lang.String)
//  .minNodeVersion(java.lang.String)
//  .npmAccess(NpmAccess)
//  .npmRegistry(java.lang.String)
//  .npmRegistryUrl(java.lang.String)
//  .npmTokenSecret(java.lang.String)
//  .packageManager(NodePackageManager)
//  .packageName(java.lang.String)
//  .peerDependencyOptions(PeerDependencyOptions)
//  .peerDeps(java.util.List<java.lang.String>)
//  .pnpmVersion(java.lang.String)
//  .repository(java.lang.String)
//  .repositoryDirectory(java.lang.String)
//  .scopedPackagesOptions(java.util.List<ScopedPackagesOptions>)
//  .scripts(java.util.Map<java.lang.String, java.lang.String>)
//  .stability(java.lang.String)
//  .jsiiReleaseVersion(java.lang.String)
//  .majorVersion(java.lang.Number)
//  .minMajorVersion(java.lang.Number)
//  .npmDistTag(java.lang.String)
//  .postBuildSteps(java.util.List<JobStep>)
//  .prerelease(java.lang.String)
//  .publishDryRun(java.lang.Boolean)
//  .publishTasks(java.lang.Boolean)
//  .releaseBranches(java.util.Map<java.lang.String, BranchOptions>)
//  .releaseEveryCommit(java.lang.Boolean)
//  .releaseFailureIssue(java.lang.Boolean)
//  .releaseFailureIssueLabel(java.lang.String)
//  .releaseSchedule(java.lang.String)
//  .releaseTagPrefix(java.lang.String)
//  .releaseTrigger(ReleaseTrigger)
//  .releaseWorkflowName(java.lang.String)
//  .releaseWorkflowSetupSteps(java.util.List<JobStep>)
//  .versionrcOptions(java.util.Map<java.lang.String, java.lang.Object>)
//  .workflowContainerImage(java.lang.String)
//  .workflowRunsOn(java.util.List<java.lang.String>)
    .defaultReleaseBranch(java.lang.String)
//  .artifactsDirectory(java.lang.String)
//  .autoApproveUpgrades(java.lang.Boolean)
//  .buildWorkflow(java.lang.Boolean)
//  .buildWorkflowTriggers(Triggers)
//  .bundlerOptions(BundlerOptions)
//  .codeCov(java.lang.Boolean)
//  .codeCovTokenSecret(java.lang.String)
//  .copyrightOwner(java.lang.String)
//  .copyrightPeriod(java.lang.String)
//  .dependabot(java.lang.Boolean)
//  .dependabotOptions(DependabotOptions)
//  .depsUpgrade(java.lang.Boolean)
//  .depsUpgradeOptions(UpgradeDependenciesOptions)
//  .gitignore(java.util.List<java.lang.String>)
//  .jest(java.lang.Boolean)
//  .jestOptions(JestOptions)
//  .mutableBuild(java.lang.Boolean)
//  .npmignore(java.util.List<java.lang.String>)
//  .npmignoreEnabled(java.lang.Boolean)
//  .npmIgnoreOptions(IgnoreFileOptions)
//  .package(java.lang.Boolean)
//  .prettier(java.lang.Boolean)
//  .prettierOptions(PrettierOptions)
//  .projenDevDependency(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenVersion(java.lang.String)
//  .pullRequestTemplate(java.lang.Boolean)
//  .pullRequestTemplateContents(java.util.List<java.lang.String>)
//  .release(java.lang.Boolean)
//  .releaseToNpm(java.lang.Boolean)
//  .releaseWorkflow(java.lang.Boolean)
//  .workflowBootstrapSteps(java.util.List<JobStep>)
//  .workflowGitIdentity(GitIdentity)
//  .workflowNodeVersion(java.lang.String)
//  .disableTsconfig(java.lang.Boolean)
//  .disableTsconfigDev(java.lang.Boolean)
//  .docgen(java.lang.Boolean)
//  .docsDirectory(java.lang.String)
//  .entrypointTypes(java.lang.String)
//  .eslint(java.lang.Boolean)
//  .eslintOptions(EslintOptions)
//  .libdir(java.lang.String)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcOptions)
//  .sampleCode(java.lang.Boolean)
//  .srcdir(java.lang.String)
//  .testdir(java.lang.String)
//  .tsconfig(TypescriptConfigOptions)
//  .tsconfigDev(TypescriptConfigOptions)
//  .tsconfigDevFile(java.lang.String)
//  .typescriptVersion(java.lang.String)
//  .monorepoUpgradeDeps(java.lang.Boolean)
//  .monorepoUpgradeDepsOptions(MonorepoUpgradeDepsOptions)
//  .nxConfig(WorkspaceConfig)
//  .workspaceConfig(WorkspaceConfig)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>java.lang.Boolean</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorOrganization">authorOrganization</a></code> | <code>java.lang.Boolean</code> | Is the author an organization. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorUrl">authorUrl</a></code> | <code>java.lang.String</code> | Author's URL / Website. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoDetectBin">autoDetectBin</a></code> | <code>java.lang.Boolean</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bin">bin</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Binary programs vended with your module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bugsEmail">bugsEmail</a></code> | <code>java.lang.String</code> | The email address to which issues should be reported. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bugsUrl">bugsUrl</a></code> | <code>java.lang.String</code> | The url to your project's issue tracker. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bundledDeps">bundledDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dependencies to bundle into this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeArtifactOptions">codeArtifactOptions</a></code> | <code>io.github.cdklabs.projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | Runtime dependencies of this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.description">description</a></code> | <code>java.lang.String</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | Build dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.entrypoint">entrypoint</a></code> | <code>java.lang.String</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.homepage">homepage</a></code> | <code>java.lang.String</code> | Package's Homepage / Website. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.keywords">keywords</a></code> | <code>java.util.List<java.lang.String></code> | Keywords to include in `package.json`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.license">license</a></code> | <code>java.lang.String</code> | License's SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.licensed">licensed</a></code> | <code>java.lang.Boolean</code> | Indicates if a license should be added. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.maxNodeVersion">maxNodeVersion</a></code> | <code>java.lang.String</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.minNodeVersion">minNodeVersion</a></code> | <code>java.lang.String</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmAccess">npmAccess</a></code> | <code>io.github.cdklabs.projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmRegistry">npmRegistry</a></code> | <code>java.lang.String</code> | The host name of the npm registry to publish to. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmRegistryUrl">npmRegistryUrl</a></code> | <code>java.lang.String</code> | The base URL of the npm package registry. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmTokenSecret">npmTokenSecret</a></code> | <code>java.lang.String</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.packageManager">packageManager</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.packageName">packageName</a></code> | <code>java.lang.String</code> | The "name" in package.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.peerDependencyOptions">peerDependencyOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.peerDeps">peerDeps</a></code> | <code>java.util.List<java.lang.String></code> | Peer dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pnpmVersion">pnpmVersion</a></code> | <code>java.lang.String</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.repository">repository</a></code> | <code>java.lang.String</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.repositoryDirectory">repositoryDirectory</a></code> | <code>java.lang.String</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.scopedPackagesOptions">scopedPackagesOptions</a></code> | <code>java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions></code> | Options for privately hosted scoped packages. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.scripts">scripts</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | npm scripts to include. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.stability">stability</a></code> | <code>java.lang.String</code> | Package's Stability. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jsiiReleaseVersion">jsiiReleaseVersion</a></code> | <code>java.lang.String</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.majorVersion">majorVersion</a></code> | <code>java.lang.Number</code> | Major version to release from the default branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.minMajorVersion">minMajorVersion</a></code> | <code>java.lang.Number</code> | Minimal Major version to release. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmDistTag">npmDistTag</a></code> | <code>java.lang.String</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.postBuildSteps">postBuildSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prerelease">prerelease</a></code> | <code>java.lang.String</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.publishDryRun">publishDryRun</a></code> | <code>java.lang.Boolean</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.publishTasks">publishTasks</a></code> | <code>java.lang.Boolean</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseBranches">releaseBranches</a></code> | <code>java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions></code> | Defines additional release branches. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseEveryCommit">releaseEveryCommit</a></code> | <code>java.lang.Boolean</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseFailureIssue">releaseFailureIssue</a></code> | <code>java.lang.Boolean</code> | Create a github issue on every failed publishing task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseFailureIssueLabel">releaseFailureIssueLabel</a></code> | <code>java.lang.String</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseSchedule">releaseSchedule</a></code> | <code>java.lang.String</code> | CRON schedule to trigger new releases. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseTagPrefix">releaseTagPrefix</a></code> | <code>java.lang.String</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseTrigger">releaseTrigger</a></code> | <code>io.github.cdklabs.projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflowName">releaseWorkflowName</a></code> | <code>java.lang.String</code> | The name of the default release workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflowSetupSteps">releaseWorkflowSetupSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.versionrcOptions">versionrcOptions</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowContainerImage">workflowContainerImage</a></code> | <code>java.lang.String</code> | Container image to use for GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowRunsOn">workflowRunsOn</a></code> | <code>java.util.List<java.lang.String></code> | Github Runner selection labels. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.defaultReleaseBranch">defaultReleaseBranch</a></code> | <code>java.lang.String</code> | The name of the main release branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.artifactsDirectory">artifactsDirectory</a></code> | <code>java.lang.String</code> | A directory which will contain build artifacts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoApproveUpgrades">autoApproveUpgrades</a></code> | <code>java.lang.Boolean</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.buildWorkflow">buildWorkflow</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.buildWorkflowTriggers">buildWorkflowTriggers</a></code> | <code>io.github.cdklabs.projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bundlerOptions">bundlerOptions</a></code> | <code>io.github.cdklabs.projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeCov">codeCov</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeCovTokenSecret">codeCovTokenSecret</a></code> | <code>java.lang.String</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.copyrightOwner">copyrightOwner</a></code> | <code>java.lang.String</code> | License copyright owner. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.copyrightPeriod">copyrightPeriod</a></code> | <code>java.lang.String</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.dependabot">dependabot</a></code> | <code>java.lang.Boolean</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.dependabotOptions">dependabotOptions</a></code> | <code>io.github.cdklabs.projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.depsUpgrade">depsUpgrade</a></code> | <code>java.lang.Boolean</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.depsUpgradeOptions">depsUpgradeOptions</a></code> | <code>io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitignore">gitignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .gitignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jest">jest</a></code> | <code>java.lang.Boolean</code> | Setup jest unit tests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jestOptions">jestOptions</a></code> | <code>io.github.cdklabs.projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mutableBuild">mutableBuild</a></code> | <code>java.lang.Boolean</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmignore">npmignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .npmignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmignoreEnabled">npmignoreEnabled</a></code> | <code>java.lang.Boolean</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmIgnoreOptions">npmIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.package">package</a></code> | <code>java.lang.Boolean</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prettier">prettier</a></code> | <code>java.lang.Boolean</code> | Setup prettier. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prettierOptions">prettierOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenDevDependency">projenDevDependency</a></code> | <code>java.lang.Boolean</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenVersion">projenVersion</a></code> | <code>java.lang.String</code> | Version of projen to install. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pullRequestTemplate">pullRequestTemplate</a></code> | <code>java.lang.Boolean</code> | Include a GitHub pull request template. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pullRequestTemplateContents">pullRequestTemplateContents</a></code> | <code>java.util.List<java.lang.String></code> | The contents of the pull request template. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.release">release</a></code> | <code>java.lang.Boolean</code> | Add release management to this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseToNpm">releaseToNpm</a></code> | <code>java.lang.Boolean</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflow">releaseWorkflow</a></code> | <code>java.lang.Boolean</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowBootstrapSteps">workflowBootstrapSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowGitIdentity">workflowGitIdentity</a></code> | <code>io.github.cdklabs.projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowNodeVersion">workflowNodeVersion</a></code> | <code>java.lang.String</code> | The node version to use in GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.disableTsconfig">disableTsconfig</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.disableTsconfigDev">disableTsconfigDev</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.docgen">docgen</a></code> | <code>java.lang.Boolean</code> | Docgen by Typedoc. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.docsDirectory">docsDirectory</a></code> | <code>java.lang.String</code> | Docs directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.entrypointTypes">entrypointTypes</a></code> | <code>java.lang.String</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.eslint">eslint</a></code> | <code>java.lang.Boolean</code> | Setup eslint. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.eslintOptions">eslintOptions</a></code> | <code>io.github.cdklabs.projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.libdir">libdir</a></code> | <code>java.lang.String</code> | Typescript  artifacts output directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.sampleCode">sampleCode</a></code> | <code>java.lang.Boolean</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.srcdir">srcdir</a></code> | <code>java.lang.String</code> | Typescript sources directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.testdir">testdir</a></code> | <code>java.lang.String</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfig">tsconfig</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfigDev">tsconfigDev</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfigDevFile">tsconfigDevFile</a></code> | <code>java.lang.String</code> | The name of the development tsconfig.json file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.typescriptVersion">typescriptVersion</a></code> | <code>java.lang.String</code> | TypeScript version to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDeps">monorepoUpgradeDeps</a></code> | <code>java.lang.Boolean</code> | Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDepsOptions">monorepoUpgradeDepsOptions</a></code> | <code>software.aws.awsprototypingsdk.nxmonorepo.MonorepoUpgradeDepsOptions</code> | Monorepo Upgrade Deps options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.nxConfig">nxConfig</a></code> | <code>software.aws.awsprototypingsdk.nxmonorepo.Nx.WorkspaceConfig</code> | Configuration for NX. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workspaceConfig">workspaceConfig</a></code> | <code>software.aws.awsprototypingsdk.nxmonorepo.WorkspaceConfig</code> | Configuration for workspace. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitIgnoreOptions"></a>

```java
public IgnoreFileOptions getGitIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitOptions"></a>

```java
public GitOptions getGitOptions();
```

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.logging"></a>

```java
public LoggerOptions getLogging();
```

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJson"></a>

```java
public java.lang.Boolean getProjenrcJson();
```

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJsonOptions"></a>

```java
public ProjenrcJsonOptions getProjenrcJsonOptions();
```

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.renovatebot"></a>

```java
public java.lang.Boolean getRenovatebot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.renovatebotOptions"></a>

```java
public RenovatebotOptions getRenovatebotOptions();
```

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoApproveOptions"></a>

```java
public AutoApproveOptions getAutoApproveOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoMerge"></a>

```java
public java.lang.Boolean getAutoMerge();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoMergeOptions"></a>

```java
public AutoMergeOptions getAutoMergeOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.clobber"></a>

```java
public java.lang.Boolean getClobber();
```

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.devContainer"></a>

```java
public java.lang.Boolean getDevContainer();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.github"></a>

```java
public java.lang.Boolean getGithub();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.githubOptions"></a>

```java
public GitHubOptions getGithubOptions();
```

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitpod"></a>

```java
public java.lang.Boolean getGitpod();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```java
public java.lang.Boolean getMergify();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```java
public MergifyOptions getMergifyOptions();
```

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenCredentials"></a>

```java
public GithubCredentials getProjenCredentials();
```

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```java
public java.lang.String getProjenTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.readme"></a>

```java
public SampleReadmeProps getReadme();
```

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.stale"></a>

```java
public java.lang.Boolean getStale();
```

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.staleOptions"></a>

```java
public StaleOptions getStaleOptions();
```

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.vscode"></a>

```java
public java.lang.Boolean getVscode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allowLibraryDependencies`<sup>Optional</sup> <a name="allowLibraryDependencies" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.allowLibraryDependencies"></a>

```java
public java.lang.Boolean getAllowLibraryDependencies();
```

- *Type:* java.lang.Boolean
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `authorEmail`<sup>Optional</sup> <a name="authorEmail" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorEmail"></a>

```java
public java.lang.String getAuthorEmail();
```

- *Type:* java.lang.String

Author's e-mail.

---

##### `authorName`<sup>Optional</sup> <a name="authorName" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorName"></a>

```java
public java.lang.String getAuthorName();
```

- *Type:* java.lang.String

Author's name.

---

##### `authorOrganization`<sup>Optional</sup> <a name="authorOrganization" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorOrganization"></a>

```java
public java.lang.Boolean getAuthorOrganization();
```

- *Type:* java.lang.Boolean

Is the author an organization.

---

##### `authorUrl`<sup>Optional</sup> <a name="authorUrl" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.authorUrl"></a>

```java
public java.lang.String getAuthorUrl();
```

- *Type:* java.lang.String

Author's URL / Website.

---

##### `autoDetectBin`<sup>Optional</sup> <a name="autoDetectBin" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoDetectBin"></a>

```java
public java.lang.Boolean getAutoDetectBin();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bin"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getBin();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugsEmail`<sup>Optional</sup> <a name="bugsEmail" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bugsEmail"></a>

```java
public java.lang.String getBugsEmail();
```

- *Type:* java.lang.String

The email address to which issues should be reported.

---

##### `bugsUrl`<sup>Optional</sup> <a name="bugsUrl" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bugsUrl"></a>

```java
public java.lang.String getBugsUrl();
```

- *Type:* java.lang.String

The url to your project's issue tracker.

---

##### `bundledDeps`<sup>Optional</sup> <a name="bundledDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bundledDeps"></a>

```java
public java.util.List<java.lang.String> getBundledDeps();
```

- *Type:* java.util.List<java.lang.String>

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `codeArtifactOptions`<sup>Optional</sup> <a name="codeArtifactOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeArtifactOptions"></a>

```java
public CodeArtifactOptions getCodeArtifactOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.deps"></a>

```java
public java.util.List<java.lang.String> getDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.devDeps"></a>

```java
public java.util.List<java.lang.String> getDevDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.entrypoint"></a>

```java
public java.lang.String getEntrypoint();
```

- *Type:* java.lang.String
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.homepage"></a>

```java
public java.lang.String getHomepage();
```

- *Type:* java.lang.String

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.keywords"></a>

```java
public java.util.List<java.lang.String> getKeywords();
```

- *Type:* java.util.List<java.lang.String>

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.license"></a>

```java
public java.lang.String getLicense();
```

- *Type:* java.lang.String
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.licensed"></a>

```java
public java.lang.Boolean getLicensed();
```

- *Type:* java.lang.Boolean
- *Default:* true

Indicates if a license should be added.

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.maxNodeVersion"></a>

```java
public java.lang.String getMaxNodeVersion();
```

- *Type:* java.lang.String
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.minNodeVersion"></a>

```java
public java.lang.String getMinNodeVersion();
```

- *Type:* java.lang.String
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npmAccess`<sup>Optional</sup> <a name="npmAccess" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmAccess"></a>

```java
public NpmAccess getNpmAccess();
```

- *Type:* io.github.cdklabs.projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npmRegistry`~~<sup>Optional</sup> <a name="npmRegistry" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```java
public java.lang.String getNpmRegistry();
```

- *Type:* java.lang.String

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npmRegistryUrl`<sup>Optional</sup> <a name="npmRegistryUrl" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmRegistryUrl"></a>

```java
public java.lang.String getNpmRegistryUrl();
```

- *Type:* java.lang.String
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npmTokenSecret`<sup>Optional</sup> <a name="npmTokenSecret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmTokenSecret"></a>

```java
public java.lang.String getNpmTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `packageManager`<sup>Optional</sup> <a name="packageManager" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.packageManager"></a>

```java
public NodePackageManager getPackageManager();
```

- *Type:* io.github.cdklabs.projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.packageName"></a>

```java
public java.lang.String getPackageName();
```

- *Type:* java.lang.String
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peerDependencyOptions`<sup>Optional</sup> <a name="peerDependencyOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.peerDependencyOptions"></a>

```java
public PeerDependencyOptions getPeerDependencyOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peerDeps`<sup>Optional</sup> <a name="peerDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.peerDeps"></a>

```java
public java.util.List<java.lang.String> getPeerDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpmVersion`<sup>Optional</sup> <a name="pnpmVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pnpmVersion"></a>

```java
public java.lang.String getPnpmVersion();
```

- *Type:* java.lang.String
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.repository"></a>

```java
public java.lang.String getRepository();
```

- *Type:* java.lang.String

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repositoryDirectory`<sup>Optional</sup> <a name="repositoryDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.repositoryDirectory"></a>

```java
public java.lang.String getRepositoryDirectory();
```

- *Type:* java.lang.String

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scopedPackagesOptions`<sup>Optional</sup> <a name="scopedPackagesOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.scopedPackagesOptions"></a>

```java
public java.util.List<ScopedPackagesOptions> getScopedPackagesOptions();
```

- *Type:* java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions>
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```java
public java.util.Map<java.lang.String, java.lang.String> getScripts();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.stability"></a>

```java
public java.lang.String getStability();
```

- *Type:* java.lang.String

Package's Stability.

---

##### `jsiiReleaseVersion`<sup>Optional</sup> <a name="jsiiReleaseVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jsiiReleaseVersion"></a>

```java
public java.lang.String getJsiiReleaseVersion();
```

- *Type:* java.lang.String
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `majorVersion`<sup>Optional</sup> <a name="majorVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.majorVersion"></a>

```java
public java.lang.Number getMajorVersion();
```

- *Type:* java.lang.Number
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `minMajorVersion`<sup>Optional</sup> <a name="minMajorVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.minMajorVersion"></a>

```java
public java.lang.Number getMinMajorVersion();
```

- *Type:* java.lang.Number
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npmDistTag`<sup>Optional</sup> <a name="npmDistTag" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmDistTag"></a>

```java
public java.lang.String getNpmDistTag();
```

- *Type:* java.lang.String
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `postBuildSteps`<sup>Optional</sup> <a name="postBuildSteps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.postBuildSteps"></a>

```java
public java.util.List<JobStep> getPostBuildSteps();
```

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prerelease"></a>

```java
public java.lang.String getPrerelease();
```

- *Type:* java.lang.String
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publishDryRun`<sup>Optional</sup> <a name="publishDryRun" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.publishDryRun"></a>

```java
public java.lang.Boolean getPublishDryRun();
```

- *Type:* java.lang.Boolean
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publishTasks`<sup>Optional</sup> <a name="publishTasks" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.publishTasks"></a>

```java
public java.lang.Boolean getPublishTasks();
```

- *Type:* java.lang.Boolean
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `releaseBranches`<sup>Optional</sup> <a name="releaseBranches" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseBranches"></a>

```java
public java.util.Map<java.lang.String, BranchOptions> getReleaseBranches();
```

- *Type:* java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions>
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`releaseEveryCommit`~~<sup>Optional</sup> <a name="releaseEveryCommit" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```java
public java.lang.Boolean getReleaseEveryCommit();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `releaseFailureIssue`<sup>Optional</sup> <a name="releaseFailureIssue" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseFailureIssue"></a>

```java
public java.lang.Boolean getReleaseFailureIssue();
```

- *Type:* java.lang.Boolean
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `releaseFailureIssueLabel`<sup>Optional</sup> <a name="releaseFailureIssueLabel" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseFailureIssueLabel"></a>

```java
public java.lang.String getReleaseFailureIssueLabel();
```

- *Type:* java.lang.String
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`releaseSchedule`~~<sup>Optional</sup> <a name="releaseSchedule" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```java
public java.lang.String getReleaseSchedule();
```

- *Type:* java.lang.String
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `releaseTagPrefix`<sup>Optional</sup> <a name="releaseTagPrefix" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseTagPrefix"></a>

```java
public java.lang.String getReleaseTagPrefix();
```

- *Type:* java.lang.String
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `releaseTrigger`<sup>Optional</sup> <a name="releaseTrigger" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseTrigger"></a>

```java
public ReleaseTrigger getReleaseTrigger();
```

- *Type:* io.github.cdklabs.projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `releaseWorkflowName`<sup>Optional</sup> <a name="releaseWorkflowName" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflowName"></a>

```java
public java.lang.String getReleaseWorkflowName();
```

- *Type:* java.lang.String
- *Default:* "Release"

The name of the default release workflow.

---

##### `releaseWorkflowSetupSteps`<sup>Optional</sup> <a name="releaseWorkflowSetupSteps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflowSetupSteps"></a>

```java
public java.util.List<JobStep> getReleaseWorkflowSetupSteps();
```

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrcOptions`<sup>Optional</sup> <a name="versionrcOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.versionrcOptions"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getVersionrcOptions();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflowContainerImage`<sup>Optional</sup> <a name="workflowContainerImage" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowContainerImage"></a>

```java
public java.lang.String getWorkflowContainerImage();
```

- *Type:* java.lang.String
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflowRunsOn`<sup>Optional</sup> <a name="workflowRunsOn" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowRunsOn"></a>

```java
public java.util.List<java.lang.String> getWorkflowRunsOn();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `defaultReleaseBranch`<sup>Required</sup> <a name="defaultReleaseBranch" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.defaultReleaseBranch"></a>

```java
public java.lang.String getDefaultReleaseBranch();
```

- *Type:* java.lang.String
- *Default:* "main"

The name of the main release branch.

---

##### `artifactsDirectory`<sup>Optional</sup> <a name="artifactsDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.artifactsDirectory"></a>

```java
public java.lang.String getArtifactsDirectory();
```

- *Type:* java.lang.String
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `autoApproveUpgrades`<sup>Optional</sup> <a name="autoApproveUpgrades" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.autoApproveUpgrades"></a>

```java
public java.lang.Boolean getAutoApproveUpgrades();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.buildWorkflow"></a>

```java
public java.lang.Boolean getBuildWorkflow();
```

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `buildWorkflowTriggers`<sup>Optional</sup> <a name="buildWorkflowTriggers" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.buildWorkflowTriggers"></a>

```java
public Triggers getBuildWorkflowTriggers();
```

- *Type:* io.github.cdklabs.projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundlerOptions`<sup>Optional</sup> <a name="bundlerOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.bundlerOptions"></a>

```java
public BundlerOptions getBundlerOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `codeCov`<sup>Optional</sup> <a name="codeCov" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeCov"></a>

```java
public java.lang.Boolean getCodeCov();
```

- *Type:* java.lang.Boolean
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret.

---

##### `codeCovTokenSecret`<sup>Optional</sup> <a name="codeCovTokenSecret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.codeCovTokenSecret"></a>

```java
public java.lang.String getCodeCovTokenSecret();
```

- *Type:* java.lang.String
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyrightOwner`<sup>Optional</sup> <a name="copyrightOwner" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.copyrightOwner"></a>

```java
public java.lang.String getCopyrightOwner();
```

- *Type:* java.lang.String
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyrightPeriod`<sup>Optional</sup> <a name="copyrightPeriod" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.copyrightPeriod"></a>

```java
public java.lang.String getCopyrightPeriod();
```

- *Type:* java.lang.String
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.dependabot"></a>

```java
public java.lang.Boolean getDependabot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabotOptions`<sup>Optional</sup> <a name="dependabotOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.dependabotOptions"></a>

```java
public DependabotOptions getDependabotOptions();
```

- *Type:* io.github.cdklabs.projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `depsUpgrade`<sup>Optional</sup> <a name="depsUpgrade" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.depsUpgrade"></a>

```java
public java.lang.Boolean getDepsUpgrade();
```

- *Type:* java.lang.Boolean
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `depsUpgradeOptions`<sup>Optional</sup> <a name="depsUpgradeOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.depsUpgradeOptions"></a>

```java
public UpgradeDependenciesOptions getDepsUpgradeOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.gitignore"></a>

```java
public java.util.List<java.lang.String> getGitignore();
```

- *Type:* java.util.List<java.lang.String>

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jest"></a>

```java
public java.lang.Boolean getJest();
```

- *Type:* java.lang.Boolean
- *Default:* true

Setup jest unit tests.

---

##### `jestOptions`<sup>Optional</sup> <a name="jestOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.jestOptions"></a>

```java
public JestOptions getJestOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutableBuild`<sup>Optional</sup> <a name="mutableBuild" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.mutableBuild"></a>

```java
public java.lang.Boolean getMutableBuild();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```java
public java.util.List<java.lang.String> getNpmignore();
```

- *Type:* java.util.List<java.lang.String>

Additional entries to .npmignore.

---

##### `npmignoreEnabled`<sup>Optional</sup> <a name="npmignoreEnabled" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmignoreEnabled"></a>

```java
public java.lang.Boolean getNpmignoreEnabled();
```

- *Type:* java.lang.Boolean
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npmIgnoreOptions`<sup>Optional</sup> <a name="npmIgnoreOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.npmIgnoreOptions"></a>

```java
public IgnoreFileOptions getNpmIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.package"></a>

```java
public java.lang.Boolean getPackage();
```

- *Type:* java.lang.Boolean
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prettier"></a>

```java
public java.lang.Boolean getPrettier();
```

- *Type:* java.lang.Boolean
- *Default:* false

Setup prettier.

---

##### `prettierOptions`<sup>Optional</sup> <a name="prettierOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.prettierOptions"></a>

```java
public PrettierOptions getPrettierOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projenDevDependency`<sup>Optional</sup> <a name="projenDevDependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenDevDependency"></a>

```java
public java.lang.Boolean getProjenDevDependency();
```

- *Type:* java.lang.Boolean
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJs"></a>

```java
public java.lang.Boolean getProjenrcJs();
```

- *Type:* java.lang.Boolean
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcJsOptions"></a>

```java
public ProjenrcOptions getProjenrcJsOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projenVersion`<sup>Optional</sup> <a name="projenVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenVersion"></a>

```java
public java.lang.String getProjenVersion();
```

- *Type:* java.lang.String
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pullRequestTemplate`<sup>Optional</sup> <a name="pullRequestTemplate" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pullRequestTemplate"></a>

```java
public java.lang.Boolean getPullRequestTemplate();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include a GitHub pull request template.

---

##### `pullRequestTemplateContents`<sup>Optional</sup> <a name="pullRequestTemplateContents" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.pullRequestTemplateContents"></a>

```java
public java.util.List<java.lang.String> getPullRequestTemplateContents();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.release"></a>

```java
public java.lang.Boolean getRelease();
```

- *Type:* java.lang.Boolean
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `releaseToNpm`<sup>Optional</sup> <a name="releaseToNpm" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseToNpm"></a>

```java
public java.lang.Boolean getReleaseToNpm();
```

- *Type:* java.lang.Boolean
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`releaseWorkflow`~~<sup>Optional</sup> <a name="releaseWorkflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```java
public java.lang.Boolean getReleaseWorkflow();
```

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflowBootstrapSteps`<sup>Optional</sup> <a name="workflowBootstrapSteps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowBootstrapSteps"></a>

```java
public java.util.List<JobStep> getWorkflowBootstrapSteps();
```

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflowGitIdentity`<sup>Optional</sup> <a name="workflowGitIdentity" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowGitIdentity"></a>

```java
public GitIdentity getWorkflowGitIdentity();
```

- *Type:* io.github.cdklabs.projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflowNodeVersion`<sup>Optional</sup> <a name="workflowNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workflowNodeVersion"></a>

```java
public java.lang.String getWorkflowNodeVersion();
```

- *Type:* java.lang.String
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `disableTsconfig`<sup>Optional</sup> <a name="disableTsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.disableTsconfig"></a>

```java
public java.lang.Boolean getDisableTsconfig();
```

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disableTsconfigDev`<sup>Optional</sup> <a name="disableTsconfigDev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.disableTsconfigDev"></a>

```java
public java.lang.Boolean getDisableTsconfigDev();
```

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.docgen"></a>

```java
public java.lang.Boolean getDocgen();
```

- *Type:* java.lang.Boolean
- *Default:* false

Docgen by Typedoc.

---

##### `docsDirectory`<sup>Optional</sup> <a name="docsDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.docsDirectory"></a>

```java
public java.lang.String getDocsDirectory();
```

- *Type:* java.lang.String
- *Default:* "docs"

Docs directory.

---

##### `entrypointTypes`<sup>Optional</sup> <a name="entrypointTypes" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.entrypointTypes"></a>

```java
public java.lang.String getEntrypointTypes();
```

- *Type:* java.lang.String
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.eslint"></a>

```java
public java.lang.Boolean getEslint();
```

- *Type:* java.lang.Boolean
- *Default:* true

Setup eslint.

---

##### `eslintOptions`<sup>Optional</sup> <a name="eslintOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.eslintOptions"></a>

```java
public EslintOptions getEslintOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.libdir"></a>

```java
public java.lang.String getLibdir();
```

- *Type:* java.lang.String
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcTs"></a>

```java
public java.lang.Boolean getProjenrcTs();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.projenrcTsOptions"></a>

```java
public ProjenrcOptions getProjenrcTsOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sampleCode`<sup>Optional</sup> <a name="sampleCode" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.sampleCode"></a>

```java
public java.lang.Boolean getSampleCode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.srcdir"></a>

```java
public java.lang.String getSrcdir();
```

- *Type:* java.lang.String
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.testdir"></a>

```java
public java.lang.String getTestdir();
```

- *Type:* java.lang.String
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfig"></a>

```java
public TypescriptConfigOptions getTsconfig();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfigDev`<sup>Optional</sup> <a name="tsconfigDev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfigDev"></a>

```java
public TypescriptConfigOptions getTsconfigDev();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfigDevFile`<sup>Optional</sup> <a name="tsconfigDevFile" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.tsconfigDevFile"></a>

```java
public java.lang.String getTsconfigDevFile();
```

- *Type:* java.lang.String
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescriptVersion`<sup>Optional</sup> <a name="typescriptVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.typescriptVersion"></a>

```java
public java.lang.String getTypescriptVersion();
```

- *Type:* java.lang.String
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `monorepoUpgradeDeps`<sup>Optional</sup> <a name="monorepoUpgradeDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDeps"></a>

```java
public java.lang.Boolean getMonorepoUpgradeDeps();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies.

---

##### `monorepoUpgradeDepsOptions`<sup>Optional</sup> <a name="monorepoUpgradeDepsOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.monorepoUpgradeDepsOptions"></a>

```java
public MonorepoUpgradeDepsOptions getMonorepoUpgradeDepsOptions();
```

- *Type:* software.aws.awsprototypingsdk.nxmonorepo.MonorepoUpgradeDepsOptions
- *Default:* undefined

Monorepo Upgrade Deps options.

This is only used if monorepoUpgradeDeps is true.

---

##### `nxConfig`<sup>Optional</sup> <a name="nxConfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.nxConfig"></a>

```java
public WorkspaceConfig getNxConfig();
```

- *Type:* software.aws.awsprototypingsdk.nxmonorepo.Nx.WorkspaceConfig

Configuration for NX.

---

##### `workspaceConfig`<sup>Optional</sup> <a name="workspaceConfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProjectOptions.property.workspaceConfig"></a>

```java
public WorkspaceConfig getWorkspaceConfig();
```

- *Type:* software.aws.awsprototypingsdk.nxmonorepo.WorkspaceConfig

Configuration for workspace.

---

### NxRunManyOptions <a name="NxRunManyOptions" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions"></a>

> [https://nx.dev/packages/nx/documents/run-many#options](https://nx.dev/packages/nx/documents/run-many#options)

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.nxmonorepo.NxRunManyOptions;

NxRunManyOptions.builder()
    .target(java.lang.String)
//  .configuration(java.lang.String)
//  .exclude(java.lang.String)
//  .ignoreCycles(java.lang.Boolean)
//  .noBail(java.lang.Boolean)
//  .outputStyle(java.lang.String)
//  .parallel(java.lang.Number)
//  .projects(java.util.List<java.lang.String>)
//  .runner(java.lang.String)
//  .skipCache(java.lang.Boolean)
//  .verbose(java.lang.Boolean)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.target">target</a></code> | <code>java.lang.String</code> | Task to run for affected projects. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.configuration">configuration</a></code> | <code>java.lang.String</code> | This is the configuration to use when performing tasks on projects. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.exclude">exclude</a></code> | <code>java.lang.String</code> | Exclude certain projects from being processed. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.ignoreCycles">ignoreCycles</a></code> | <code>java.lang.Boolean</code> | Ignore cycles in the task graph. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.noBail">noBail</a></code> | <code>java.lang.Boolean</code> | Do not stop command execution after the first failed task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.outputStyle">outputStyle</a></code> | <code>java.lang.String</code> | Defines how Nx emits outputs tasks logs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.parallel">parallel</a></code> | <code>java.lang.Number</code> | Max number of parallel processes. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.projects">projects</a></code> | <code>java.util.List<java.lang.String></code> | Project to run as list project names and/or patterns. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.runner">runner</a></code> | <code>java.lang.String</code> | This is the name of the tasks runner configuration in nx.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.skipCache">skipCache</a></code> | <code>java.lang.Boolean</code> | Rerun the tasks even when the results are available in the cache. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.verbose">verbose</a></code> | <code>java.lang.Boolean</code> | Prints additional information about the commands (e.g. stack traces). |

---

##### `target`<sup>Required</sup> <a name="target" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.target"></a>

```java
public java.lang.String getTarget();
```

- *Type:* java.lang.String

Task to run for affected projects.

---

##### `configuration`<sup>Optional</sup> <a name="configuration" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.configuration"></a>

```java
public java.lang.String getConfiguration();
```

- *Type:* java.lang.String

This is the configuration to use when performing tasks on projects.

---

##### `exclude`<sup>Optional</sup> <a name="exclude" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.exclude"></a>

```java
public java.lang.String getExclude();
```

- *Type:* java.lang.String

Exclude certain projects from being processed.

---

##### `ignoreCycles`<sup>Optional</sup> <a name="ignoreCycles" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.ignoreCycles"></a>

```java
public java.lang.Boolean getIgnoreCycles();
```

- *Type:* java.lang.Boolean

Ignore cycles in the task graph.

---

##### `noBail`<sup>Optional</sup> <a name="noBail" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.noBail"></a>

```java
public java.lang.Boolean getNoBail();
```

- *Type:* java.lang.Boolean

Do not stop command execution after the first failed task.

---

##### `outputStyle`<sup>Optional</sup> <a name="outputStyle" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.outputStyle"></a>

```java
public java.lang.String getOutputStyle();
```

- *Type:* java.lang.String
- *Default:* "stream"

Defines how Nx emits outputs tasks logs.

---

##### `parallel`<sup>Optional</sup> <a name="parallel" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.parallel"></a>

```java
public java.lang.Number getParallel();
```

- *Type:* java.lang.Number
- *Default:* 3

Max number of parallel processes.

---

##### `projects`<sup>Optional</sup> <a name="projects" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.projects"></a>

```java
public java.util.List<java.lang.String> getProjects();
```

- *Type:* java.util.List<java.lang.String>

Project to run as list project names and/or patterns.

---

##### `runner`<sup>Optional</sup> <a name="runner" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.runner"></a>

```java
public java.lang.String getRunner();
```

- *Type:* java.lang.String

This is the name of the tasks runner configuration in nx.json.

---

##### `skipCache`<sup>Optional</sup> <a name="skipCache" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.skipCache"></a>

```java
public java.lang.Boolean getSkipCache();
```

- *Type:* java.lang.Boolean

Rerun the tasks even when the results are available in the cache.

---

##### `verbose`<sup>Optional</sup> <a name="verbose" id="aws-prototyping-sdk.nx_monorepo.NxRunManyOptions.property.verbose"></a>

```java
public java.lang.Boolean getVerbose();
```

- *Type:* java.lang.Boolean

Prints additional information about the commands (e.g. stack traces).

---

### PDKNagAppProps <a name="PDKNagAppProps" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNagAppProps;

PDKNagAppProps.builder()
//  .analyticsReporting(java.lang.Boolean)
//  .autoSynth(java.lang.Boolean)
//  .context(java.util.Map<java.lang.String, java.lang.Object>)
//  .defaultStackSynthesizer(IReusableStackSynthesizer)
//  .outdir(java.lang.String)
//  .postCliContext(java.util.Map<java.lang.String, java.lang.Object>)
//  .stackTraces(java.lang.Boolean)
//  .treeMetadata(java.lang.Boolean)
//  .failOnError(java.lang.Boolean)
//  .failOnWarning(java.lang.Boolean)
//  .nagPacks(java.util.List<NagPack>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.analyticsReporting">analyticsReporting</a></code> | <code>java.lang.Boolean</code> | Include runtime versioning information in the Stacks of this app. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.autoSynth">autoSynth</a></code> | <code>java.lang.Boolean</code> | Automatically call `synth()` before the program exits. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.context">context</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context values for the application. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.defaultStackSynthesizer">defaultStackSynthesizer</a></code> | <code>software.amazon.awscdk.IReusableStackSynthesizer</code> | The stack synthesizer to use by default for all Stacks in the App. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The output directory into which to emit synthesized artifacts. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.postCliContext">postCliContext</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context values for the application. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.stackTraces">stackTraces</a></code> | <code>java.lang.Boolean</code> | Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.treeMetadata">treeMetadata</a></code> | <code>java.lang.Boolean</code> | Include construct tree metadata as part of the Cloud Assembly. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.failOnError">failOnError</a></code> | <code>java.lang.Boolean</code> | Determines whether any errors encountered should trigger a test failure. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.failOnWarning">failOnWarning</a></code> | <code>java.lang.Boolean</code> | Determines whether any warnings encountered should trigger a test failure. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.nagPacks">nagPacks</a></code> | <code>java.util.List<io.github.cdklabs.cdknag.NagPack></code> | Custom nag packs to execute. |

---

##### `analyticsReporting`<sup>Optional</sup> <a name="analyticsReporting" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.analyticsReporting"></a>

```java
public java.lang.Boolean getAnalyticsReporting();
```

- *Type:* java.lang.Boolean
- *Default:* Value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in the Stacks of this app.

---

##### `autoSynth`<sup>Optional</sup> <a name="autoSynth" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.autoSynth"></a>

```java
public java.lang.Boolean getAutoSynth();
```

- *Type:* java.lang.Boolean
- *Default:* true if running via CDK CLI (`CDK_OUTDIR` is set), `false` otherwise

Automatically call `synth()` before the program exits.

If you set this, you don't have to call `synth()` explicitly. Note that
this feature is only available for certain programming languages, and
calling `synth()` is still recommended.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.context"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getContext();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context values for the application.

Context set by the CLI or the `context` key in `cdk.json` has precedence.

Context can be read from any construct using `node.getContext(key)`.

---

##### `defaultStackSynthesizer`<sup>Optional</sup> <a name="defaultStackSynthesizer" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.defaultStackSynthesizer"></a>

```java
public IReusableStackSynthesizer getDefaultStackSynthesizer();
```

- *Type:* software.amazon.awscdk.IReusableStackSynthesizer
- *Default:* A `DefaultStackSynthesizer` with default settings

The stack synthesizer to use by default for all Stacks in the App.

The Stack Synthesizer controls aspects of synthesis and deployment,
like how assets are referenced and what IAM roles to use. For more
information, see the README of the main CDK package.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String
- *Default:* If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.   If `CDK_OUTDIR` is not defined, uses a temp directory.

The output directory into which to emit synthesized artifacts.

You should never need to set this value. By default, the value you pass to
the CLI's `--output` flag will be used, and if you change it to a different
directory the CLI will fail to pick up the generated Cloud Assembly.

This property is intended for internal and testing use.

---

##### `postCliContext`<sup>Optional</sup> <a name="postCliContext" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.postCliContext"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getPostCliContext();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context values for the application.

Context provided here has precedence over context set by:

- The CLI via --context
- The `context` key in `cdk.json`
- The `AppProps.context` property

This property is recommended over the `AppProps.context` property since you
can make final decision over which context value to take in your app.

Context can be read from any construct using `node.getContext(key)`.

---

*Example*

```java
// context from the CLI and from `cdk.json` are stored in the
// CDK_CONTEXT env variable
const cliContext = JSON.parse(process.env.CDK_CONTEXT!);

// determine whether to take the context passed in the CLI or not
const determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
new App({
  postCliContext: {
    SOMEKEY: determineValue,
  },
});
```


##### `stackTraces`<sup>Optional</sup> <a name="stackTraces" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.stackTraces"></a>

```java
public java.lang.Boolean getStackTraces();
```

- *Type:* java.lang.Boolean
- *Default:* true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.

Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.

---

##### `treeMetadata`<sup>Optional</sup> <a name="treeMetadata" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.treeMetadata"></a>

```java
public java.lang.Boolean getTreeMetadata();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include construct tree metadata as part of the Cloud Assembly.

---

##### `failOnError`<sup>Optional</sup> <a name="failOnError" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.failOnError"></a>

```java
public java.lang.Boolean getFailOnError();
```

- *Type:* java.lang.Boolean
- *Default:* false

Determines whether any errors encountered should trigger a test failure.

---

##### `failOnWarning`<sup>Optional</sup> <a name="failOnWarning" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.failOnWarning"></a>

```java
public java.lang.Boolean getFailOnWarning();
```

- *Type:* java.lang.Boolean
- *Default:* false

Determines whether any warnings encountered should trigger a test failure.

---

##### `nagPacks`<sup>Optional</sup> <a name="nagPacks" id="aws-prototyping-sdk.pdk_nag.PDKNagAppProps.property.nagPacks"></a>

```java
public java.util.List<NagPack> getNagPacks();
```

- *Type:* java.util.List<io.github.cdklabs.cdknag.NagPack>
- *Default:* DEFAULT_NAG_PACKS

Custom nag packs to execute.

---

### PDKPipelineJavaProjectOptions <a name="PDKPipelineJavaProjectOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions"></a>

Configuration options for the PDKPipelineJavaProject.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pipeline.PDKPipelineJavaProjectOptions;

PDKPipelineJavaProjectOptions.builder()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
    .artifactId(java.lang.String)
    .groupId(java.lang.String)
    .version(java.lang.String)
//  .description(java.lang.String)
//  .packaging(java.lang.String)
//  .url(java.lang.String)
//  .compileOptions(MavenCompileOptions)
//  .deps(java.util.List<java.lang.String>)
//  .distdir(java.lang.String)
//  .junit(java.lang.Boolean)
//  .junitOptions(JunitOptions)
//  .packagingOptions(MavenPackagingOptions)
//  .projenrcJava(java.lang.Boolean)
//  .projenrcJavaOptions(ProjenrcOptions)
//  .testDeps(java.util.List<java.lang.String>)
//  .sample(java.lang.Boolean)
//  .sampleJavaPackage(java.lang.String)
//  .buildCommand(java.lang.String)
//  .cdkout(java.lang.String)
//  .context(java.util.Map<java.lang.String, java.lang.Object>)
//  .featureFlags(java.lang.Boolean)
//  .requireApproval(ApprovalLevel)
//  .watchExcludes(java.util.List<java.lang.String>)
//  .watchIncludes(java.util.List<java.lang.String>)
    .cdkVersion(java.lang.String)
//  .cdkAssert(java.lang.Boolean)
//  .cdkAssertions(java.lang.Boolean)
//  .cdkDependencies(java.util.List<java.lang.String>)
//  .cdkDependenciesAsDeps(java.lang.Boolean)
//  .cdkTestDependencies(java.util.List<java.lang.String>)
//  .cdkVersionPinning(java.lang.Boolean)
//  .constructsVersion(java.lang.String)
    .mainClass(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.artifactId">artifactId</a></code> | <code>java.lang.String</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.groupId">groupId</a></code> | <code>java.lang.String</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.version">version</a></code> | <code>java.lang.String</code> | This is the last piece of the naming puzzle. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.description">description</a></code> | <code>java.lang.String</code> | Description of a project is always good. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.packaging">packaging</a></code> | <code>java.lang.String</code> | Project packaging format. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.url">url</a></code> | <code>java.lang.String</code> | The URL, like the name, is not required. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.compileOptions">compileOptions</a></code> | <code>io.github.cdklabs.projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | List of runtime dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.distdir">distdir</a></code> | <code>java.lang.String</code> | Final artifact output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.junit">junit</a></code> | <code>java.lang.Boolean</code> | Include junit tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.junitOptions">junitOptions</a></code> | <code>io.github.cdklabs.projen.java.JunitOptions</code> | junit options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.packagingOptions">packagingOptions</a></code> | <code>io.github.cdklabs.projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJava">projenrcJava</a></code> | <code>java.lang.Boolean</code> | Use projenrc in java. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJavaOptions">projenrcJavaOptions</a></code> | <code>io.github.cdklabs.projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.testDeps">testDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of test dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.sample">sample</a></code> | <code>java.lang.Boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.sampleJavaPackage">sampleJavaPackage</a></code> | <code>java.lang.String</code> | The java package to use for the code sample. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.buildCommand">buildCommand</a></code> | <code>java.lang.String</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkout">cdkout</a></code> | <code>java.lang.String</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.context">context</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.featureFlags">featureFlags</a></code> | <code>java.lang.Boolean</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.requireApproval">requireApproval</a></code> | <code>io.github.cdklabs.projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.watchExcludes">watchExcludes</a></code> | <code>java.util.List<java.lang.String></code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.watchIncludes">watchIncludes</a></code> | <code>java.util.List<java.lang.String></code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkVersion">cdkVersion</a></code> | <code>java.lang.String</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkAssert">cdkAssert</a></code> | <code>java.lang.Boolean</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkAssertions">cdkAssertions</a></code> | <code>java.lang.Boolean</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkDependencies">cdkDependencies</a></code> | <code>java.util.List<java.lang.String></code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkDependenciesAsDeps">cdkDependenciesAsDeps</a></code> | <code>java.lang.Boolean</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkTestDependencies">cdkTestDependencies</a></code> | <code>java.util.List<java.lang.String></code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkVersionPinning">cdkVersionPinning</a></code> | <code>java.lang.Boolean</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.constructsVersion">constructsVersion</a></code> | <code>java.lang.String</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mainClass">mainClass</a></code> | <code>java.lang.String</code> | The name of the Java class with the static `main()` method. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitIgnoreOptions"></a>

```java
public IgnoreFileOptions getGitIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitOptions"></a>

```java
public GitOptions getGitOptions();
```

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.logging"></a>

```java
public LoggerOptions getLogging();
```

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJson"></a>

```java
public java.lang.Boolean getProjenrcJson();
```

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJsonOptions"></a>

```java
public ProjenrcJsonOptions getProjenrcJsonOptions();
```

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.renovatebot"></a>

```java
public java.lang.Boolean getRenovatebot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.renovatebotOptions"></a>

```java
public RenovatebotOptions getRenovatebotOptions();
```

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoApproveOptions"></a>

```java
public AutoApproveOptions getAutoApproveOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoMerge"></a>

```java
public java.lang.Boolean getAutoMerge();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.autoMergeOptions"></a>

```java
public AutoMergeOptions getAutoMergeOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.clobber"></a>

```java
public java.lang.Boolean getClobber();
```

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.devContainer"></a>

```java
public java.lang.Boolean getDevContainer();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.github"></a>

```java
public java.lang.Boolean getGithub();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.githubOptions"></a>

```java
public GitHubOptions getGithubOptions();
```

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.gitpod"></a>

```java
public java.lang.Boolean getGitpod();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```java
public java.lang.Boolean getMergify();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```java
public MergifyOptions getMergifyOptions();
```

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenCredentials"></a>

```java
public GithubCredentials getProjenCredentials();
```

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```java
public java.lang.String getProjenTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.readme"></a>

```java
public SampleReadmeProps getReadme();
```

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.stale"></a>

```java
public java.lang.Boolean getStale();
```

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.staleOptions"></a>

```java
public StaleOptions getStaleOptions();
```

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.vscode"></a>

```java
public java.lang.Boolean getVscode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.artifactId"></a>

```java
public java.lang.String getArtifactId();
```

- *Type:* java.lang.String
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.groupId"></a>

```java
public java.lang.String getGroupId();
```

- *Type:* java.lang.String
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.version"></a>

```java
public java.lang.String getVersion();
```

- *Type:* java.lang.String
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.packaging"></a>

```java
public java.lang.String getPackaging();
```

- *Type:* java.lang.String
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.url"></a>

```java
public java.lang.String getUrl();
```

- *Type:* java.lang.String
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compileOptions`<sup>Optional</sup> <a name="compileOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.compileOptions"></a>

```java
public MavenCompileOptions getCompileOptions();
```

- *Type:* io.github.cdklabs.projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.deps"></a>

```java
public java.util.List<java.lang.String> getDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.distdir"></a>

```java
public java.lang.String getDistdir();
```

- *Type:* java.lang.String
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.junit"></a>

```java
public java.lang.Boolean getJunit();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include junit tests.

---

##### `junitOptions`<sup>Optional</sup> <a name="junitOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.junitOptions"></a>

```java
public JunitOptions getJunitOptions();
```

- *Type:* io.github.cdklabs.projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packagingOptions`<sup>Optional</sup> <a name="packagingOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.packagingOptions"></a>

```java
public MavenPackagingOptions getPackagingOptions();
```

- *Type:* io.github.cdklabs.projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrcJava`<sup>Optional</sup> <a name="projenrcJava" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJava"></a>

```java
public java.lang.Boolean getProjenrcJava();
```

- *Type:* java.lang.Boolean
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrcJavaOptions`<sup>Optional</sup> <a name="projenrcJavaOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.projenrcJavaOptions"></a>

```java
public ProjenrcOptions getProjenrcJavaOptions();
```

- *Type:* io.github.cdklabs.projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `testDeps`<sup>Optional</sup> <a name="testDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.testDeps"></a>

```java
public java.util.List<java.lang.String> getTestDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.sample"></a>

```java
public java.lang.Boolean getSample();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sampleJavaPackage`<sup>Optional</sup> <a name="sampleJavaPackage" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.sampleJavaPackage"></a>

```java
public java.lang.String getSampleJavaPackage();
```

- *Type:* java.lang.String
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `buildCommand`<sup>Optional</sup> <a name="buildCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.buildCommand"></a>

```java
public java.lang.String getBuildCommand();
```

- *Type:* java.lang.String
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkout"></a>

```java
public java.lang.String getCdkout();
```

- *Type:* java.lang.String
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.context"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getContext();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `featureFlags`<sup>Optional</sup> <a name="featureFlags" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.featureFlags"></a>

```java
public java.lang.Boolean getFeatureFlags();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include all feature flags in cdk.json.

---

##### `requireApproval`<sup>Optional</sup> <a name="requireApproval" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.requireApproval"></a>

```java
public ApprovalLevel getRequireApproval();
```

- *Type:* io.github.cdklabs.projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watchExcludes`<sup>Optional</sup> <a name="watchExcludes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.watchExcludes"></a>

```java
public java.util.List<java.lang.String> getWatchExcludes();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watchIncludes`<sup>Optional</sup> <a name="watchIncludes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.watchIncludes"></a>

```java
public java.util.List<java.lang.String> getWatchIncludes();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkVersion"></a>

```java
public java.lang.String getCdkVersion();
```

- *Type:* java.lang.String
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdkAssert`~~<sup>Optional</sup> <a name="cdkAssert" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkAssert"></a>

- *Deprecated:* The

```java
public java.lang.Boolean getCdkAssert();
```

- *Type:* java.lang.Boolean
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdkAssertions`<sup>Optional</sup> <a name="cdkAssertions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkAssertions"></a>

```java
public java.lang.Boolean getCdkAssertions();
```

- *Type:* java.lang.Boolean
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdkDependencies`~~<sup>Optional</sup> <a name="cdkDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

```java
public java.util.List<java.lang.String> getCdkDependencies();
```

- *Type:* java.util.List<java.lang.String>

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdkDependenciesAsDeps`~~<sup>Optional</sup> <a name="cdkDependenciesAsDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

```java
public java.lang.Boolean getCdkDependenciesAsDeps();
```

- *Type:* java.lang.Boolean
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdkTestDependencies`~~<sup>Optional</sup> <a name="cdkTestDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

```java
public java.util.List<java.lang.String> getCdkTestDependencies();
```

- *Type:* java.util.List<java.lang.String>

AWS CDK modules required for testing.

---

##### `cdkVersionPinning`<sup>Optional</sup> <a name="cdkVersionPinning" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.cdkVersionPinning"></a>

```java
public java.lang.Boolean getCdkVersionPinning();
```

- *Type:* java.lang.Boolean

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructsVersion`<sup>Optional</sup> <a name="constructsVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.constructsVersion"></a>

```java
public java.lang.String getConstructsVersion();
```

- *Type:* java.lang.String
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `mainClass`<sup>Required</sup> <a name="mainClass" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProjectOptions.property.mainClass"></a>

```java
public java.lang.String getMainClass();
```

- *Type:* java.lang.String
- *Default:* "org.acme.MyApp"

The name of the Java class with the static `main()` method.

This method
should call `app.synth()` on the CDK app.

---

### PDKPipelineProps <a name="PDKPipelineProps" id="aws-prototyping-sdk.pipeline.PDKPipelineProps"></a>

Properties to configure the PDKPipeline.

Note: Due to limitations with JSII and generic support it should be noted that
the synth, synthShellStepPartialProps.input and
synthShellStepPartialProps.primaryOutputDirectory properties will be ignored
if passed in to this construct.

synthShellStepPartialProps.commands is marked as a required field, however
if you pass in [] the default commands of this construct will be retained.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pipeline.PDKPipelineProps;

PDKPipelineProps.builder()
    .synth(IFileSetProducer)
//  .assetPublishingCodeBuildDefaults(CodeBuildOptions)
//  .cliVersion(java.lang.String)
//  .codeBuildDefaults(CodeBuildOptions)
//  .codePipeline(Pipeline)
//  .crossAccountKeys(java.lang.Boolean)
//  .dockerCredentials(java.util.List<DockerCredential>)
//  .dockerEnabledForSelfMutation(java.lang.Boolean)
//  .dockerEnabledForSynth(java.lang.Boolean)
//  .enableKeyRotation(java.lang.Boolean)
//  .pipelineName(java.lang.String)
//  .publishAssetsInParallel(java.lang.Boolean)
//  .reuseCrossRegionSupportStacks(java.lang.Boolean)
//  .role(IRole)
//  .selfMutation(java.lang.Boolean)
//  .selfMutationCodeBuildDefaults(CodeBuildOptions)
//  .synthCodeBuildDefaults(CodeBuildOptions)
//  .useChangeSets(java.lang.Boolean)
    .primarySynthDirectory(java.lang.String)
    .repositoryName(java.lang.String)
//  .codeCommitRemovalPolicy(RemovalPolicy)
//  .defaultBranchName(java.lang.String)
//  .sonarCodeScannerConfig(SonarCodeScannerConfig)
//  .synthShellStepPartialProps(ShellStepProps)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synth">synth</a></code> | <code>software.amazon.awscdk.pipelines.IFileSetProducer</code> | The build step that produces the CDK Cloud Assembly. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.assetPublishingCodeBuildDefaults">assetPublishingCodeBuildDefaults</a></code> | <code>software.amazon.awscdk.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the asset publishing CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.cliVersion">cliVersion</a></code> | <code>java.lang.String</code> | CDK CLI version to use in self-mutation and asset publishing steps. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codeBuildDefaults">codeBuildDefaults</a></code> | <code>software.amazon.awscdk.pipelines.CodeBuildOptions</code> | Customize the CodeBuild projects created for this pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codePipeline">codePipeline</a></code> | <code>software.amazon.awscdk.services.codepipeline.Pipeline</code> | An existing Pipeline to be reused and built upon. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.crossAccountKeys">crossAccountKeys</a></code> | <code>java.lang.Boolean</code> | Create KMS keys for the artifact buckets, allowing cross-account deployments. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerCredentials">dockerCredentials</a></code> | <code>java.util.List<software.amazon.awscdk.pipelines.DockerCredential></code> | A list of credentials used to authenticate to Docker registries. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerEnabledForSelfMutation">dockerEnabledForSelfMutation</a></code> | <code>java.lang.Boolean</code> | Enable Docker for the self-mutate step. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerEnabledForSynth">dockerEnabledForSynth</a></code> | <code>java.lang.Boolean</code> | Enable Docker for the 'synth' step. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.enableKeyRotation">enableKeyRotation</a></code> | <code>java.lang.Boolean</code> | Enable KMS key rotation for the generated KMS keys. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.pipelineName">pipelineName</a></code> | <code>java.lang.String</code> | The name of the CodePipeline pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.publishAssetsInParallel">publishAssetsInParallel</a></code> | <code>java.lang.Boolean</code> | Publish assets in multiple CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.reuseCrossRegionSupportStacks">reuseCrossRegionSupportStacks</a></code> | <code>java.lang.Boolean</code> | Reuse the same cross region support stack for all pipelines in the App. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.role">role</a></code> | <code>software.amazon.awscdk.services.iam.IRole</code> | The IAM role to be assumed by this Pipeline. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.selfMutation">selfMutation</a></code> | <code>java.lang.Boolean</code> | Whether the pipeline will update itself. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.selfMutationCodeBuildDefaults">selfMutationCodeBuildDefaults</a></code> | <code>software.amazon.awscdk.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the self mutation CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synthCodeBuildDefaults">synthCodeBuildDefaults</a></code> | <code>software.amazon.awscdk.pipelines.CodeBuildOptions</code> | Additional customizations to apply to the synthesize CodeBuild projects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.useChangeSets">useChangeSets</a></code> | <code>java.lang.Boolean</code> | Deploy every stack by creating a change set and executing it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.primarySynthDirectory">primarySynthDirectory</a></code> | <code>java.lang.String</code> | Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.repositoryName">repositoryName</a></code> | <code>java.lang.String</code> | Name of the CodeCommit repository to create. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codeCommitRemovalPolicy">codeCommitRemovalPolicy</a></code> | <code>software.amazon.awscdk.RemovalPolicy</code> | Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.defaultBranchName">defaultBranchName</a></code> | <code>java.lang.String</code> | Branch to trigger the pipeline execution. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.sonarCodeScannerConfig">sonarCodeScannerConfig</a></code> | <code>software.aws.awsprototypingsdk.pipeline.SonarCodeScannerConfig</code> | Configuration for enabling Sonarqube code scanning on a successful synth. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synthShellStepPartialProps">synthShellStepPartialProps</a></code> | <code>software.amazon.awscdk.pipelines.ShellStepProps</code> | PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands. |

---

##### `synth`<sup>Required</sup> <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synth"></a>

```java
public IFileSetProducer getSynth();
```

- *Type:* software.amazon.awscdk.pipelines.IFileSetProducer

The build step that produces the CDK Cloud Assembly.

The primary output of this step needs to be the `cdk.out` directory
generated by the `cdk synth` command.

If you use a `ShellStep` here and you don't configure an output directory,
the output directory will automatically be assumed to be `cdk.out`.

---

##### `assetPublishingCodeBuildDefaults`<sup>Optional</sup> <a name="assetPublishingCodeBuildDefaults" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.assetPublishingCodeBuildDefaults"></a>

```java
public CodeBuildOptions getAssetPublishingCodeBuildDefaults();
```

- *Type:* software.amazon.awscdk.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the asset publishing CodeBuild projects.

---

##### `cliVersion`<sup>Optional</sup> <a name="cliVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.cliVersion"></a>

```java
public java.lang.String getCliVersion();
```

- *Type:* java.lang.String
- *Default:* Latest version

CDK CLI version to use in self-mutation and asset publishing steps.

If you want to lock the CDK CLI version used in the pipeline, by steps
that are automatically generated for you, specify the version here.

We recommend you do not specify this value, as not specifying it always
uses the latest CLI version which is backwards compatible with old versions.

If you do specify it, be aware that this version should always be equal to or higher than the
version of the CDK framework used by the CDK app, when the CDK commands are
run during your pipeline execution. When you change this version, the *next
time* the `SelfMutate` step runs it will still be using the CLI of the the
*previous* version that was in this property: it will only start using the
new version after `SelfMutate` completes successfully. That means that if
you want to update both framework and CLI version, you should update the
CLI version first, commit, push and deploy, and only then update the
framework version.

---

##### `codeBuildDefaults`<sup>Optional</sup> <a name="codeBuildDefaults" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codeBuildDefaults"></a>

```java
public CodeBuildOptions getCodeBuildDefaults();
```

- *Type:* software.amazon.awscdk.pipelines.CodeBuildOptions
- *Default:* All projects run non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_6_0

Customize the CodeBuild projects created for this pipeline.

---

##### `codePipeline`<sup>Optional</sup> <a name="codePipeline" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codePipeline"></a>

```java
public Pipeline getCodePipeline();
```

- *Type:* software.amazon.awscdk.services.codepipeline.Pipeline
- *Default:* a new underlying pipeline is created.

An existing Pipeline to be reused and built upon.

[disable-awslint:ref-via-interface]

---

##### `crossAccountKeys`<sup>Optional</sup> <a name="crossAccountKeys" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.crossAccountKeys"></a>

```java
public java.lang.Boolean getCrossAccountKeys();
```

- *Type:* java.lang.Boolean
- *Default:* false

Create KMS keys for the artifact buckets, allowing cross-account deployments.

The artifact buckets have to be encrypted to support deploying CDK apps to
another account, so if you want to do that or want to have your artifact
buckets encrypted, be sure to set this value to `true`.

Be aware there is a cost associated with maintaining the KMS keys.

---

##### `dockerCredentials`<sup>Optional</sup> <a name="dockerCredentials" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerCredentials"></a>

```java
public java.util.List<DockerCredential> getDockerCredentials();
```

- *Type:* java.util.List<software.amazon.awscdk.pipelines.DockerCredential>
- *Default:* []

A list of credentials used to authenticate to Docker registries.

Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.

---

##### `dockerEnabledForSelfMutation`<sup>Optional</sup> <a name="dockerEnabledForSelfMutation" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerEnabledForSelfMutation"></a>

```java
public java.lang.Boolean getDockerEnabledForSelfMutation();
```

- *Type:* java.lang.Boolean
- *Default:* false

Enable Docker for the self-mutate step.

Set this to true if the pipeline itself uses Docker container assets
(for example, if you use `LinuxBuildImage.fromAsset()` as the build
image of a CodeBuild step in the pipeline).

You do not need to set it if you build Docker image assets in the
application Stages and Stacks that are *deployed* by this pipeline.

Configures privileged mode for the self-mutation CodeBuild action.

If you are about to turn this on in an already-deployed Pipeline,
set the value to `true` first, commit and allow the pipeline to
self-update, and only then use the Docker asset in the pipeline.

---

##### `dockerEnabledForSynth`<sup>Optional</sup> <a name="dockerEnabledForSynth" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.dockerEnabledForSynth"></a>

```java
public java.lang.Boolean getDockerEnabledForSynth();
```

- *Type:* java.lang.Boolean
- *Default:* false

Enable Docker for the 'synth' step.

Set this to true if you are using file assets that require
"bundling" anywhere in your application (meaning an asset
compilation step will be run with the tools provided by
a Docker image), both for the Pipeline stack as well as the
application stacks.

A common way to use bundling assets in your application is by
using the `@aws-cdk/aws-lambda-nodejs` library.

Configures privileged mode for the synth CodeBuild action.

If you are about to turn this on in an already-deployed Pipeline,
set the value to `true` first, commit and allow the pipeline to
self-update, and only then use the bundled asset.

---

##### `enableKeyRotation`<sup>Optional</sup> <a name="enableKeyRotation" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.enableKeyRotation"></a>

```java
public java.lang.Boolean getEnableKeyRotation();
```

- *Type:* java.lang.Boolean
- *Default:* false (key rotation is disabled)

Enable KMS key rotation for the generated KMS keys.

By default KMS key rotation is disabled, but will add
additional costs when enabled.

---

##### `pipelineName`<sup>Optional</sup> <a name="pipelineName" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.pipelineName"></a>

```java
public java.lang.String getPipelineName();
```

- *Type:* java.lang.String
- *Default:* Automatically generated

The name of the CodePipeline pipeline.

---

##### `publishAssetsInParallel`<sup>Optional</sup> <a name="publishAssetsInParallel" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.publishAssetsInParallel"></a>

```java
public java.lang.Boolean getPublishAssetsInParallel();
```

- *Type:* java.lang.Boolean
- *Default:* true

Publish assets in multiple CodeBuild projects.

If set to false, use one Project per type to publish all assets.

Publishing in parallel improves concurrency and may reduce publishing
latency, but may also increase overall provisioning time of the CodeBuild
projects.

Experiment and see what value works best for you.

---

##### `reuseCrossRegionSupportStacks`<sup>Optional</sup> <a name="reuseCrossRegionSupportStacks" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.reuseCrossRegionSupportStacks"></a>

```java
public java.lang.Boolean getReuseCrossRegionSupportStacks();
```

- *Type:* java.lang.Boolean
- *Default:* true (Use the same support stack for all pipelines in App)

Reuse the same cross region support stack for all pipelines in the App.

---

##### `role`<sup>Optional</sup> <a name="role" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.role"></a>

```java
public IRole getRole();
```

- *Type:* software.amazon.awscdk.services.iam.IRole
- *Default:* A new role is created

The IAM role to be assumed by this Pipeline.

---

##### `selfMutation`<sup>Optional</sup> <a name="selfMutation" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.selfMutation"></a>

```java
public java.lang.Boolean getSelfMutation();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether the pipeline will update itself.

This needs to be set to `true` to allow the pipeline to reconfigure
itself when assets or stages are being added to it, and `true` is the
recommended setting.

You can temporarily set this to `false` while you are iterating
on the pipeline itself and prefer to deploy changes using `cdk deploy`.

---

##### `selfMutationCodeBuildDefaults`<sup>Optional</sup> <a name="selfMutationCodeBuildDefaults" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.selfMutationCodeBuildDefaults"></a>

```java
public CodeBuildOptions getSelfMutationCodeBuildDefaults();
```

- *Type:* software.amazon.awscdk.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the self mutation CodeBuild projects.

---

##### `synthCodeBuildDefaults`<sup>Optional</sup> <a name="synthCodeBuildDefaults" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synthCodeBuildDefaults"></a>

```java
public CodeBuildOptions getSynthCodeBuildDefaults();
```

- *Type:* software.amazon.awscdk.pipelines.CodeBuildOptions
- *Default:* Only `codeBuildDefaults` are applied

Additional customizations to apply to the synthesize CodeBuild projects.

---

##### `useChangeSets`<sup>Optional</sup> <a name="useChangeSets" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.useChangeSets"></a>

```java
public java.lang.Boolean getUseChangeSets();
```

- *Type:* java.lang.Boolean
- *Default:* true

Deploy every stack by creating a change set and executing it.

When enabled, creates a "Prepare" and "Execute" action for each stack. Disable
to deploy the stack in one pipeline action.

---

##### `primarySynthDirectory`<sup>Required</sup> <a name="primarySynthDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.primarySynthDirectory"></a>

```java
public java.lang.String getPrimarySynthDirectory();
```

- *Type:* java.lang.String

Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out.

---

##### `repositoryName`<sup>Required</sup> <a name="repositoryName" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.repositoryName"></a>

```java
public java.lang.String getRepositoryName();
```

- *Type:* java.lang.String

Name of the CodeCommit repository to create.

---

##### `codeCommitRemovalPolicy`<sup>Optional</sup> <a name="codeCommitRemovalPolicy" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.codeCommitRemovalPolicy"></a>

```java
public RemovalPolicy getCodeCommitRemovalPolicy();
```

- *Type:* software.amazon.awscdk.RemovalPolicy

Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation.

---

##### `defaultBranchName`<sup>Optional</sup> <a name="defaultBranchName" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.defaultBranchName"></a>

```java
public java.lang.String getDefaultBranchName();
```

- *Type:* java.lang.String
- *Default:* mainline

Branch to trigger the pipeline execution.

---

##### `sonarCodeScannerConfig`<sup>Optional</sup> <a name="sonarCodeScannerConfig" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.sonarCodeScannerConfig"></a>

```java
public SonarCodeScannerConfig getSonarCodeScannerConfig();
```

- *Type:* software.aws.awsprototypingsdk.pipeline.SonarCodeScannerConfig
- *Default:* undefined

Configuration for enabling Sonarqube code scanning on a successful synth.

---

##### `synthShellStepPartialProps`<sup>Optional</sup> <a name="synthShellStepPartialProps" id="aws-prototyping-sdk.pipeline.PDKPipelineProps.property.synthShellStepPartialProps"></a>

```java
public ShellStepProps getSynthShellStepPartialProps();
```

- *Type:* software.amazon.awscdk.pipelines.ShellStepProps

PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands.

To override these defaults
and/or provide additional inputs, specify env settings, etc you can provide
a partial ShellStepProps.

---

### PDKPipelinePyProjectOptions <a name="PDKPipelinePyProjectOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions"></a>

Configuration options for the PDKPipelinePyProject.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pipeline.PDKPipelinePyProjectOptions;

PDKPipelinePyProjectOptions.builder()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
    .authorEmail(java.lang.String)
    .authorName(java.lang.String)
    .version(java.lang.String)
//  .classifiers(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .homepage(java.lang.String)
//  .license(java.lang.String)
//  .packageName(java.lang.String)
//  .poetryOptions(PoetryPyprojectOptionsWithoutDeps)
//  .setupConfig(java.util.Map<java.lang.String, java.lang.Object>)
    .moduleName(java.lang.String)
//  .deps(java.util.List<java.lang.String>)
//  .devDeps(java.util.List<java.lang.String>)
//  .pip(java.lang.Boolean)
//  .poetry(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenrcPython(java.lang.Boolean)
//  .projenrcPythonOptions(ProjenrcOptions)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcTsOptions)
//  .pytest(java.lang.Boolean)
//  .pytestOptions(PytestOptions)
//  .sample(java.lang.Boolean)
//  .setuptools(java.lang.Boolean)
//  .venv(java.lang.Boolean)
//  .venvOptions(VenvOptions)
//  .buildCommand(java.lang.String)
//  .cdkout(java.lang.String)
//  .context(java.util.Map<java.lang.String, java.lang.Object>)
//  .featureFlags(java.lang.Boolean)
//  .requireApproval(ApprovalLevel)
//  .watchExcludes(java.util.List<java.lang.String>)
//  .watchIncludes(java.util.List<java.lang.String>)
    .cdkVersion(java.lang.String)
//  .cdkAssert(java.lang.Boolean)
//  .cdkAssertions(java.lang.Boolean)
//  .cdkDependencies(java.util.List<java.lang.String>)
//  .cdkDependenciesAsDeps(java.lang.Boolean)
//  .cdkTestDependencies(java.util.List<java.lang.String>)
//  .cdkVersionPinning(java.lang.Boolean)
//  .constructsVersion(java.lang.String)
//  .appEntrypoint(java.lang.String)
//  .testdir(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.version">version</a></code> | <code>java.lang.String</code> | Version of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.classifiers">classifiers</a></code> | <code>java.util.List<java.lang.String></code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.description">description</a></code> | <code>java.lang.String</code> | A short description of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.homepage">homepage</a></code> | <code>java.lang.String</code> | A URL to the website of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.license">license</a></code> | <code>java.lang.String</code> | License of this package as an SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.packageName">packageName</a></code> | <code>java.lang.String</code> | Package name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.poetryOptions">poetryOptions</a></code> | <code>io.github.cdklabs.projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.setupConfig">setupConfig</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.moduleName">moduleName</a></code> | <code>java.lang.String</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | List of runtime dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dev dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pip">pip</a></code> | <code>java.lang.Boolean</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.poetry">poetry</a></code> | <code>java.lang.Boolean</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Use projenrc in javascript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcPython">projenrcPython</a></code> | <code>java.lang.Boolean</code> | Use projenrc in Python. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcPythonOptions">projenrcPythonOptions</a></code> | <code>io.github.cdklabs.projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use projenrc in TypeScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pytest">pytest</a></code> | <code>java.lang.Boolean</code> | Include pytest tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pytestOptions">pytestOptions</a></code> | <code>io.github.cdklabs.projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.sample">sample</a></code> | <code>java.lang.Boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.setuptools">setuptools</a></code> | <code>java.lang.Boolean</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.venv">venv</a></code> | <code>java.lang.Boolean</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.venvOptions">venvOptions</a></code> | <code>io.github.cdklabs.projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.buildCommand">buildCommand</a></code> | <code>java.lang.String</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkout">cdkout</a></code> | <code>java.lang.String</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.context">context</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.featureFlags">featureFlags</a></code> | <code>java.lang.Boolean</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.requireApproval">requireApproval</a></code> | <code>io.github.cdklabs.projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.watchExcludes">watchExcludes</a></code> | <code>java.util.List<java.lang.String></code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.watchIncludes">watchIncludes</a></code> | <code>java.util.List<java.lang.String></code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkVersion">cdkVersion</a></code> | <code>java.lang.String</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkAssert">cdkAssert</a></code> | <code>java.lang.Boolean</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkAssertions">cdkAssertions</a></code> | <code>java.lang.Boolean</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkDependencies">cdkDependencies</a></code> | <code>java.util.List<java.lang.String></code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkDependenciesAsDeps">cdkDependenciesAsDeps</a></code> | <code>java.lang.Boolean</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkTestDependencies">cdkTestDependencies</a></code> | <code>java.util.List<java.lang.String></code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkVersionPinning">cdkVersionPinning</a></code> | <code>java.lang.Boolean</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.constructsVersion">constructsVersion</a></code> | <code>java.lang.String</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.appEntrypoint">appEntrypoint</a></code> | <code>java.lang.String</code> | The CDK app's entrypoint (relative to the source directory, which is "src" by default). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.testdir">testdir</a></code> | <code>java.lang.String</code> | Python sources directory. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitIgnoreOptions"></a>

```java
public IgnoreFileOptions getGitIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitOptions"></a>

```java
public GitOptions getGitOptions();
```

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.logging"></a>

```java
public LoggerOptions getLogging();
```

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJson"></a>

```java
public java.lang.Boolean getProjenrcJson();
```

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJsonOptions"></a>

```java
public ProjenrcJsonOptions getProjenrcJsonOptions();
```

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.renovatebot"></a>

```java
public java.lang.Boolean getRenovatebot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.renovatebotOptions"></a>

```java
public RenovatebotOptions getRenovatebotOptions();
```

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoApproveOptions"></a>

```java
public AutoApproveOptions getAutoApproveOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoMerge"></a>

```java
public java.lang.Boolean getAutoMerge();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.autoMergeOptions"></a>

```java
public AutoMergeOptions getAutoMergeOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.clobber"></a>

```java
public java.lang.Boolean getClobber();
```

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.devContainer"></a>

```java
public java.lang.Boolean getDevContainer();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.github"></a>

```java
public java.lang.Boolean getGithub();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.githubOptions"></a>

```java
public GitHubOptions getGithubOptions();
```

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.gitpod"></a>

```java
public java.lang.Boolean getGitpod();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```java
public java.lang.Boolean getMergify();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```java
public MergifyOptions getMergifyOptions();
```

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenCredentials"></a>

```java
public GithubCredentials getProjenCredentials();
```

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```java
public java.lang.String getProjenTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.readme"></a>

```java
public SampleReadmeProps getReadme();
```

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.stale"></a>

```java
public java.lang.Boolean getStale();
```

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.staleOptions"></a>

```java
public StaleOptions getStaleOptions();
```

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.vscode"></a>

```java
public java.lang.Boolean getVscode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `authorEmail`<sup>Required</sup> <a name="authorEmail" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.authorEmail"></a>

```java
public java.lang.String getAuthorEmail();
```

- *Type:* java.lang.String
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `authorName`<sup>Required</sup> <a name="authorName" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.authorName"></a>

```java
public java.lang.String getAuthorName();
```

- *Type:* java.lang.String
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.version"></a>

```java
public java.lang.String getVersion();
```

- *Type:* java.lang.String
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.classifiers"></a>

```java
public java.util.List<java.lang.String> getClassifiers();
```

- *Type:* java.util.List<java.lang.String>

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.homepage"></a>

```java
public java.lang.String getHomepage();
```

- *Type:* java.lang.String

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.license"></a>

```java
public java.lang.String getLicense();
```

- *Type:* java.lang.String

License of this package as an SPDX identifier.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.packageName"></a>

```java
public java.lang.String getPackageName();
```

- *Type:* java.lang.String

Package name.

---

##### `poetryOptions`<sup>Optional</sup> <a name="poetryOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.poetryOptions"></a>

```java
public PoetryPyprojectOptionsWithoutDeps getPoetryOptions();
```

- *Type:* io.github.cdklabs.projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setupConfig`<sup>Optional</sup> <a name="setupConfig" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.setupConfig"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getSetupConfig();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>

Additional fields to pass in the setup() function if using setuptools.

---

##### `moduleName`<sup>Required</sup> <a name="moduleName" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.moduleName"></a>

```java
public java.lang.String getModuleName();
```

- *Type:* java.lang.String
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.deps"></a>

```java
public java.util.List<java.lang.String> getDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.devDeps"></a>

```java
public java.util.List<java.lang.String> getDevDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pip"></a>

```java
public java.lang.Boolean getPip();
```

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.poetry"></a>

```java
public java.lang.Boolean getPoetry();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJs"></a>

```java
public java.lang.Boolean getProjenrcJs();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcJsOptions"></a>

```java
public ProjenrcOptions getProjenrcJsOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrcPython`<sup>Optional</sup> <a name="projenrcPython" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcPython"></a>

```java
public java.lang.Boolean getProjenrcPython();
```

- *Type:* java.lang.Boolean
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrcPythonOptions`<sup>Optional</sup> <a name="projenrcPythonOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcPythonOptions"></a>

```java
public ProjenrcOptions getProjenrcPythonOptions();
```

- *Type:* io.github.cdklabs.projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcTs"></a>

```java
public java.lang.Boolean getProjenrcTs();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.projenrcTsOptions"></a>

```java
public ProjenrcTsOptions getProjenrcTsOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pytest"></a>

```java
public java.lang.Boolean getPytest();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include pytest tests.

---

##### `pytestOptions`<sup>Optional</sup> <a name="pytestOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.pytestOptions"></a>

```java
public PytestOptions getPytestOptions();
```

- *Type:* io.github.cdklabs.projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.sample"></a>

```java
public java.lang.Boolean getSample();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.setuptools"></a>

```java
public java.lang.Boolean getSetuptools();
```

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.venv"></a>

```java
public java.lang.Boolean getVenv();
```

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venvOptions`<sup>Optional</sup> <a name="venvOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.venvOptions"></a>

```java
public VenvOptions getVenvOptions();
```

- *Type:* io.github.cdklabs.projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `buildCommand`<sup>Optional</sup> <a name="buildCommand" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.buildCommand"></a>

```java
public java.lang.String getBuildCommand();
```

- *Type:* java.lang.String
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkout"></a>

```java
public java.lang.String getCdkout();
```

- *Type:* java.lang.String
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.context"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getContext();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `featureFlags`<sup>Optional</sup> <a name="featureFlags" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.featureFlags"></a>

```java
public java.lang.Boolean getFeatureFlags();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include all feature flags in cdk.json.

---

##### `requireApproval`<sup>Optional</sup> <a name="requireApproval" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.requireApproval"></a>

```java
public ApprovalLevel getRequireApproval();
```

- *Type:* io.github.cdklabs.projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watchExcludes`<sup>Optional</sup> <a name="watchExcludes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.watchExcludes"></a>

```java
public java.util.List<java.lang.String> getWatchExcludes();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watchIncludes`<sup>Optional</sup> <a name="watchIncludes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.watchIncludes"></a>

```java
public java.util.List<java.lang.String> getWatchIncludes();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkVersion"></a>

```java
public java.lang.String getCdkVersion();
```

- *Type:* java.lang.String
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdkAssert`~~<sup>Optional</sup> <a name="cdkAssert" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkAssert"></a>

- *Deprecated:* The

```java
public java.lang.Boolean getCdkAssert();
```

- *Type:* java.lang.Boolean
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdkAssertions`<sup>Optional</sup> <a name="cdkAssertions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkAssertions"></a>

```java
public java.lang.Boolean getCdkAssertions();
```

- *Type:* java.lang.Boolean
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdkDependencies`~~<sup>Optional</sup> <a name="cdkDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

```java
public java.util.List<java.lang.String> getCdkDependencies();
```

- *Type:* java.util.List<java.lang.String>

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdkDependenciesAsDeps`~~<sup>Optional</sup> <a name="cdkDependenciesAsDeps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

```java
public java.lang.Boolean getCdkDependenciesAsDeps();
```

- *Type:* java.lang.Boolean
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdkTestDependencies`~~<sup>Optional</sup> <a name="cdkTestDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

```java
public java.util.List<java.lang.String> getCdkTestDependencies();
```

- *Type:* java.util.List<java.lang.String>

AWS CDK modules required for testing.

---

##### `cdkVersionPinning`<sup>Optional</sup> <a name="cdkVersionPinning" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.cdkVersionPinning"></a>

```java
public java.lang.Boolean getCdkVersionPinning();
```

- *Type:* java.lang.Boolean

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructsVersion`<sup>Optional</sup> <a name="constructsVersion" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.constructsVersion"></a>

```java
public java.lang.String getConstructsVersion();
```

- *Type:* java.lang.String
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `appEntrypoint`<sup>Optional</sup> <a name="appEntrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.appEntrypoint"></a>

```java
public java.lang.String getAppEntrypoint();
```

- *Type:* java.lang.String
- *Default:* "app.py"

The CDK app's entrypoint (relative to the source directory, which is "src" by default).

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProjectOptions.property.testdir"></a>

```java
public java.lang.String getTestdir();
```

- *Type:* java.lang.String
- *Default:* "tests"

Python sources directory.

---

### PDKPipelineTsProjectOptions <a name="PDKPipelineTsProjectOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions"></a>

Configuration options for the PDKPipelineTsProject.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pipeline.PDKPipelineTsProjectOptions;

PDKPipelineTsProjectOptions.builder()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
//  .allowLibraryDependencies(java.lang.Boolean)
//  .authorEmail(java.lang.String)
//  .authorName(java.lang.String)
//  .authorOrganization(java.lang.Boolean)
//  .authorUrl(java.lang.String)
//  .autoDetectBin(java.lang.Boolean)
//  .bin(java.util.Map<java.lang.String, java.lang.String>)
//  .bugsEmail(java.lang.String)
//  .bugsUrl(java.lang.String)
//  .bundledDeps(java.util.List<java.lang.String>)
//  .codeArtifactOptions(CodeArtifactOptions)
//  .deps(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .devDeps(java.util.List<java.lang.String>)
//  .entrypoint(java.lang.String)
//  .homepage(java.lang.String)
//  .keywords(java.util.List<java.lang.String>)
//  .license(java.lang.String)
//  .licensed(java.lang.Boolean)
//  .maxNodeVersion(java.lang.String)
//  .minNodeVersion(java.lang.String)
//  .npmAccess(NpmAccess)
//  .npmRegistry(java.lang.String)
//  .npmRegistryUrl(java.lang.String)
//  .npmTokenSecret(java.lang.String)
//  .packageManager(NodePackageManager)
//  .packageName(java.lang.String)
//  .peerDependencyOptions(PeerDependencyOptions)
//  .peerDeps(java.util.List<java.lang.String>)
//  .pnpmVersion(java.lang.String)
//  .repository(java.lang.String)
//  .repositoryDirectory(java.lang.String)
//  .scopedPackagesOptions(java.util.List<ScopedPackagesOptions>)
//  .scripts(java.util.Map<java.lang.String, java.lang.String>)
//  .stability(java.lang.String)
//  .jsiiReleaseVersion(java.lang.String)
//  .majorVersion(java.lang.Number)
//  .minMajorVersion(java.lang.Number)
//  .npmDistTag(java.lang.String)
//  .postBuildSteps(java.util.List<JobStep>)
//  .prerelease(java.lang.String)
//  .publishDryRun(java.lang.Boolean)
//  .publishTasks(java.lang.Boolean)
//  .releaseBranches(java.util.Map<java.lang.String, BranchOptions>)
//  .releaseEveryCommit(java.lang.Boolean)
//  .releaseFailureIssue(java.lang.Boolean)
//  .releaseFailureIssueLabel(java.lang.String)
//  .releaseSchedule(java.lang.String)
//  .releaseTagPrefix(java.lang.String)
//  .releaseTrigger(ReleaseTrigger)
//  .releaseWorkflowName(java.lang.String)
//  .releaseWorkflowSetupSteps(java.util.List<JobStep>)
//  .versionrcOptions(java.util.Map<java.lang.String, java.lang.Object>)
//  .workflowContainerImage(java.lang.String)
//  .workflowRunsOn(java.util.List<java.lang.String>)
    .defaultReleaseBranch(java.lang.String)
//  .artifactsDirectory(java.lang.String)
//  .autoApproveUpgrades(java.lang.Boolean)
//  .buildWorkflow(java.lang.Boolean)
//  .buildWorkflowTriggers(Triggers)
//  .bundlerOptions(BundlerOptions)
//  .codeCov(java.lang.Boolean)
//  .codeCovTokenSecret(java.lang.String)
//  .copyrightOwner(java.lang.String)
//  .copyrightPeriod(java.lang.String)
//  .dependabot(java.lang.Boolean)
//  .dependabotOptions(DependabotOptions)
//  .depsUpgrade(java.lang.Boolean)
//  .depsUpgradeOptions(UpgradeDependenciesOptions)
//  .gitignore(java.util.List<java.lang.String>)
//  .jest(java.lang.Boolean)
//  .jestOptions(JestOptions)
//  .mutableBuild(java.lang.Boolean)
//  .npmignore(java.util.List<java.lang.String>)
//  .npmignoreEnabled(java.lang.Boolean)
//  .npmIgnoreOptions(IgnoreFileOptions)
//  .package(java.lang.Boolean)
//  .prettier(java.lang.Boolean)
//  .prettierOptions(PrettierOptions)
//  .projenDevDependency(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenVersion(java.lang.String)
//  .pullRequestTemplate(java.lang.Boolean)
//  .pullRequestTemplateContents(java.util.List<java.lang.String>)
//  .release(java.lang.Boolean)
//  .releaseToNpm(java.lang.Boolean)
//  .releaseWorkflow(java.lang.Boolean)
//  .workflowBootstrapSteps(java.util.List<JobStep>)
//  .workflowGitIdentity(GitIdentity)
//  .workflowNodeVersion(java.lang.String)
//  .disableTsconfig(java.lang.Boolean)
//  .disableTsconfigDev(java.lang.Boolean)
//  .docgen(java.lang.Boolean)
//  .docsDirectory(java.lang.String)
//  .entrypointTypes(java.lang.String)
//  .eslint(java.lang.Boolean)
//  .eslintOptions(EslintOptions)
//  .libdir(java.lang.String)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcOptions)
//  .sampleCode(java.lang.Boolean)
//  .srcdir(java.lang.String)
//  .testdir(java.lang.String)
//  .tsconfig(TypescriptConfigOptions)
//  .tsconfigDev(TypescriptConfigOptions)
//  .tsconfigDevFile(java.lang.String)
//  .typescriptVersion(java.lang.String)
//  .buildCommand(java.lang.String)
//  .cdkout(java.lang.String)
//  .context(java.util.Map<java.lang.String, java.lang.Object>)
//  .featureFlags(java.lang.Boolean)
//  .requireApproval(ApprovalLevel)
//  .watchExcludes(java.util.List<java.lang.String>)
//  .watchIncludes(java.util.List<java.lang.String>)
    .cdkVersion(java.lang.String)
//  .cdkAssert(java.lang.Boolean)
//  .cdkAssertions(java.lang.Boolean)
//  .cdkDependencies(java.util.List<java.lang.String>)
//  .cdkDependenciesAsDeps(java.lang.Boolean)
//  .cdkTestDependencies(java.util.List<java.lang.String>)
//  .cdkVersionPinning(java.lang.Boolean)
//  .constructsVersion(java.lang.String)
//  .appEntrypoint(java.lang.String)
//  .edgeLambdaAutoDiscover(java.lang.Boolean)
//  .integrationTestAutoDiscover(java.lang.Boolean)
//  .lambdaAutoDiscover(java.lang.Boolean)
//  .lambdaExtensionAutoDiscover(java.lang.Boolean)
//  .lambdaOptions(LambdaFunctionCommonOptions)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>java.lang.Boolean</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorOrganization">authorOrganization</a></code> | <code>java.lang.Boolean</code> | Is the author an organization. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorUrl">authorUrl</a></code> | <code>java.lang.String</code> | Author's URL / Website. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoDetectBin">autoDetectBin</a></code> | <code>java.lang.Boolean</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bin">bin</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Binary programs vended with your module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bugsEmail">bugsEmail</a></code> | <code>java.lang.String</code> | The email address to which issues should be reported. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bugsUrl">bugsUrl</a></code> | <code>java.lang.String</code> | The url to your project's issue tracker. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bundledDeps">bundledDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dependencies to bundle into this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeArtifactOptions">codeArtifactOptions</a></code> | <code>io.github.cdklabs.projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | Runtime dependencies of this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.description">description</a></code> | <code>java.lang.String</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | Build dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.entrypoint">entrypoint</a></code> | <code>java.lang.String</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.homepage">homepage</a></code> | <code>java.lang.String</code> | Package's Homepage / Website. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.keywords">keywords</a></code> | <code>java.util.List<java.lang.String></code> | Keywords to include in `package.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.license">license</a></code> | <code>java.lang.String</code> | License's SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.licensed">licensed</a></code> | <code>java.lang.Boolean</code> | Indicates if a license should be added. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.maxNodeVersion">maxNodeVersion</a></code> | <code>java.lang.String</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.minNodeVersion">minNodeVersion</a></code> | <code>java.lang.String</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmAccess">npmAccess</a></code> | <code>io.github.cdklabs.projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmRegistry">npmRegistry</a></code> | <code>java.lang.String</code> | The host name of the npm registry to publish to. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmRegistryUrl">npmRegistryUrl</a></code> | <code>java.lang.String</code> | The base URL of the npm package registry. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmTokenSecret">npmTokenSecret</a></code> | <code>java.lang.String</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.packageManager">packageManager</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.packageName">packageName</a></code> | <code>java.lang.String</code> | The "name" in package.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.peerDependencyOptions">peerDependencyOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.peerDeps">peerDeps</a></code> | <code>java.util.List<java.lang.String></code> | Peer dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pnpmVersion">pnpmVersion</a></code> | <code>java.lang.String</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.repository">repository</a></code> | <code>java.lang.String</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.repositoryDirectory">repositoryDirectory</a></code> | <code>java.lang.String</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.scopedPackagesOptions">scopedPackagesOptions</a></code> | <code>java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions></code> | Options for privately hosted scoped packages. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.scripts">scripts</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | npm scripts to include. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.stability">stability</a></code> | <code>java.lang.String</code> | Package's Stability. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jsiiReleaseVersion">jsiiReleaseVersion</a></code> | <code>java.lang.String</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.majorVersion">majorVersion</a></code> | <code>java.lang.Number</code> | Major version to release from the default branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.minMajorVersion">minMajorVersion</a></code> | <code>java.lang.Number</code> | Minimal Major version to release. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmDistTag">npmDistTag</a></code> | <code>java.lang.String</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.postBuildSteps">postBuildSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prerelease">prerelease</a></code> | <code>java.lang.String</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.publishDryRun">publishDryRun</a></code> | <code>java.lang.Boolean</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.publishTasks">publishTasks</a></code> | <code>java.lang.Boolean</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseBranches">releaseBranches</a></code> | <code>java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions></code> | Defines additional release branches. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseEveryCommit">releaseEveryCommit</a></code> | <code>java.lang.Boolean</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseFailureIssue">releaseFailureIssue</a></code> | <code>java.lang.Boolean</code> | Create a github issue on every failed publishing task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseFailureIssueLabel">releaseFailureIssueLabel</a></code> | <code>java.lang.String</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseSchedule">releaseSchedule</a></code> | <code>java.lang.String</code> | CRON schedule to trigger new releases. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseTagPrefix">releaseTagPrefix</a></code> | <code>java.lang.String</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseTrigger">releaseTrigger</a></code> | <code>io.github.cdklabs.projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflowName">releaseWorkflowName</a></code> | <code>java.lang.String</code> | The name of the default release workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflowSetupSteps">releaseWorkflowSetupSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.versionrcOptions">versionrcOptions</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowContainerImage">workflowContainerImage</a></code> | <code>java.lang.String</code> | Container image to use for GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowRunsOn">workflowRunsOn</a></code> | <code>java.util.List<java.lang.String></code> | Github Runner selection labels. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.defaultReleaseBranch">defaultReleaseBranch</a></code> | <code>java.lang.String</code> | The name of the main release branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.artifactsDirectory">artifactsDirectory</a></code> | <code>java.lang.String</code> | A directory which will contain build artifacts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoApproveUpgrades">autoApproveUpgrades</a></code> | <code>java.lang.Boolean</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildWorkflow">buildWorkflow</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildWorkflowTriggers">buildWorkflowTriggers</a></code> | <code>io.github.cdklabs.projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bundlerOptions">bundlerOptions</a></code> | <code>io.github.cdklabs.projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeCov">codeCov</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeCovTokenSecret">codeCovTokenSecret</a></code> | <code>java.lang.String</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.copyrightOwner">copyrightOwner</a></code> | <code>java.lang.String</code> | License copyright owner. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.copyrightPeriod">copyrightPeriod</a></code> | <code>java.lang.String</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.dependabot">dependabot</a></code> | <code>java.lang.Boolean</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.dependabotOptions">dependabotOptions</a></code> | <code>io.github.cdklabs.projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.depsUpgrade">depsUpgrade</a></code> | <code>java.lang.Boolean</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.depsUpgradeOptions">depsUpgradeOptions</a></code> | <code>io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitignore">gitignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jest">jest</a></code> | <code>java.lang.Boolean</code> | Setup jest unit tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jestOptions">jestOptions</a></code> | <code>io.github.cdklabs.projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mutableBuild">mutableBuild</a></code> | <code>java.lang.Boolean</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmignore">npmignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .npmignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmignoreEnabled">npmignoreEnabled</a></code> | <code>java.lang.Boolean</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmIgnoreOptions">npmIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.package">package</a></code> | <code>java.lang.Boolean</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prettier">prettier</a></code> | <code>java.lang.Boolean</code> | Setup prettier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prettierOptions">prettierOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenDevDependency">projenDevDependency</a></code> | <code>java.lang.Boolean</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenVersion">projenVersion</a></code> | <code>java.lang.String</code> | Version of projen to install. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pullRequestTemplate">pullRequestTemplate</a></code> | <code>java.lang.Boolean</code> | Include a GitHub pull request template. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pullRequestTemplateContents">pullRequestTemplateContents</a></code> | <code>java.util.List<java.lang.String></code> | The contents of the pull request template. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.release">release</a></code> | <code>java.lang.Boolean</code> | Add release management to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseToNpm">releaseToNpm</a></code> | <code>java.lang.Boolean</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflow">releaseWorkflow</a></code> | <code>java.lang.Boolean</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowBootstrapSteps">workflowBootstrapSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowGitIdentity">workflowGitIdentity</a></code> | <code>io.github.cdklabs.projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowNodeVersion">workflowNodeVersion</a></code> | <code>java.lang.String</code> | The node version to use in GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.disableTsconfig">disableTsconfig</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.disableTsconfigDev">disableTsconfigDev</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.docgen">docgen</a></code> | <code>java.lang.Boolean</code> | Docgen by Typedoc. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.docsDirectory">docsDirectory</a></code> | <code>java.lang.String</code> | Docs directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.entrypointTypes">entrypointTypes</a></code> | <code>java.lang.String</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.eslint">eslint</a></code> | <code>java.lang.Boolean</code> | Setup eslint. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.eslintOptions">eslintOptions</a></code> | <code>io.github.cdklabs.projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.libdir">libdir</a></code> | <code>java.lang.String</code> | Typescript  artifacts output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.sampleCode">sampleCode</a></code> | <code>java.lang.Boolean</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.srcdir">srcdir</a></code> | <code>java.lang.String</code> | Typescript sources directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.testdir">testdir</a></code> | <code>java.lang.String</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfig">tsconfig</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfigDev">tsconfigDev</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfigDevFile">tsconfigDevFile</a></code> | <code>java.lang.String</code> | The name of the development tsconfig.json file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.typescriptVersion">typescriptVersion</a></code> | <code>java.lang.String</code> | TypeScript version to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildCommand">buildCommand</a></code> | <code>java.lang.String</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkout">cdkout</a></code> | <code>java.lang.String</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.context">context</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.featureFlags">featureFlags</a></code> | <code>java.lang.Boolean</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.requireApproval">requireApproval</a></code> | <code>io.github.cdklabs.projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.watchExcludes">watchExcludes</a></code> | <code>java.util.List<java.lang.String></code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.watchIncludes">watchIncludes</a></code> | <code>java.util.List<java.lang.String></code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkVersion">cdkVersion</a></code> | <code>java.lang.String</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkAssert">cdkAssert</a></code> | <code>java.lang.Boolean</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkAssertions">cdkAssertions</a></code> | <code>java.lang.Boolean</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkDependencies">cdkDependencies</a></code> | <code>java.util.List<java.lang.String></code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkDependenciesAsDeps">cdkDependenciesAsDeps</a></code> | <code>java.lang.Boolean</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkTestDependencies">cdkTestDependencies</a></code> | <code>java.util.List<java.lang.String></code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkVersionPinning">cdkVersionPinning</a></code> | <code>java.lang.Boolean</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.constructsVersion">constructsVersion</a></code> | <code>java.lang.String</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.appEntrypoint">appEntrypoint</a></code> | <code>java.lang.String</code> | The CDK app's entrypoint (relative to the source directory, which is "src" by default). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.edgeLambdaAutoDiscover">edgeLambdaAutoDiscover</a></code> | <code>java.lang.Boolean</code> | Automatically adds an `cloudfront.experimental.EdgeFunction` for each `.edge-lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.integrationTestAutoDiscover">integrationTestAutoDiscover</a></code> | <code>java.lang.Boolean</code> | Automatically discovers and creates integration tests for each `.integ.ts` file in under your test directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaAutoDiscover">lambdaAutoDiscover</a></code> | <code>java.lang.Boolean</code> | Automatically adds an `awscdk.LambdaFunction` for each `.lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaExtensionAutoDiscover">lambdaExtensionAutoDiscover</a></code> | <code>java.lang.Boolean</code> | Automatically adds an `awscdk.LambdaExtension` for each `.lambda-extension.ts` entrypoint in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaOptions">lambdaOptions</a></code> | <code>io.github.cdklabs.projen.awscdk.LambdaFunctionCommonOptions</code> | Common options for all AWS Lambda functions. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitIgnoreOptions"></a>

```java
public IgnoreFileOptions getGitIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitOptions"></a>

```java
public GitOptions getGitOptions();
```

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.logging"></a>

```java
public LoggerOptions getLogging();
```

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJson"></a>

```java
public java.lang.Boolean getProjenrcJson();
```

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJsonOptions"></a>

```java
public ProjenrcJsonOptions getProjenrcJsonOptions();
```

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.renovatebot"></a>

```java
public java.lang.Boolean getRenovatebot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.renovatebotOptions"></a>

```java
public RenovatebotOptions getRenovatebotOptions();
```

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoApproveOptions"></a>

```java
public AutoApproveOptions getAutoApproveOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoMerge"></a>

```java
public java.lang.Boolean getAutoMerge();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoMergeOptions"></a>

```java
public AutoMergeOptions getAutoMergeOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.clobber"></a>

```java
public java.lang.Boolean getClobber();
```

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.devContainer"></a>

```java
public java.lang.Boolean getDevContainer();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.github"></a>

```java
public java.lang.Boolean getGithub();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.githubOptions"></a>

```java
public GitHubOptions getGithubOptions();
```

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitpod"></a>

```java
public java.lang.Boolean getGitpod();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```java
public java.lang.Boolean getMergify();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```java
public MergifyOptions getMergifyOptions();
```

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenCredentials"></a>

```java
public GithubCredentials getProjenCredentials();
```

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```java
public java.lang.String getProjenTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.readme"></a>

```java
public SampleReadmeProps getReadme();
```

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.stale"></a>

```java
public java.lang.Boolean getStale();
```

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.staleOptions"></a>

```java
public StaleOptions getStaleOptions();
```

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.vscode"></a>

```java
public java.lang.Boolean getVscode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allowLibraryDependencies`<sup>Optional</sup> <a name="allowLibraryDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.allowLibraryDependencies"></a>

```java
public java.lang.Boolean getAllowLibraryDependencies();
```

- *Type:* java.lang.Boolean
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `authorEmail`<sup>Optional</sup> <a name="authorEmail" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorEmail"></a>

```java
public java.lang.String getAuthorEmail();
```

- *Type:* java.lang.String

Author's e-mail.

---

##### `authorName`<sup>Optional</sup> <a name="authorName" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorName"></a>

```java
public java.lang.String getAuthorName();
```

- *Type:* java.lang.String

Author's name.

---

##### `authorOrganization`<sup>Optional</sup> <a name="authorOrganization" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorOrganization"></a>

```java
public java.lang.Boolean getAuthorOrganization();
```

- *Type:* java.lang.Boolean

Is the author an organization.

---

##### `authorUrl`<sup>Optional</sup> <a name="authorUrl" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.authorUrl"></a>

```java
public java.lang.String getAuthorUrl();
```

- *Type:* java.lang.String

Author's URL / Website.

---

##### `autoDetectBin`<sup>Optional</sup> <a name="autoDetectBin" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoDetectBin"></a>

```java
public java.lang.Boolean getAutoDetectBin();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bin"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getBin();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugsEmail`<sup>Optional</sup> <a name="bugsEmail" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bugsEmail"></a>

```java
public java.lang.String getBugsEmail();
```

- *Type:* java.lang.String

The email address to which issues should be reported.

---

##### `bugsUrl`<sup>Optional</sup> <a name="bugsUrl" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bugsUrl"></a>

```java
public java.lang.String getBugsUrl();
```

- *Type:* java.lang.String

The url to your project's issue tracker.

---

##### `bundledDeps`<sup>Optional</sup> <a name="bundledDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bundledDeps"></a>

```java
public java.util.List<java.lang.String> getBundledDeps();
```

- *Type:* java.util.List<java.lang.String>

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `codeArtifactOptions`<sup>Optional</sup> <a name="codeArtifactOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeArtifactOptions"></a>

```java
public CodeArtifactOptions getCodeArtifactOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.deps"></a>

```java
public java.util.List<java.lang.String> getDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.devDeps"></a>

```java
public java.util.List<java.lang.String> getDevDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.entrypoint"></a>

```java
public java.lang.String getEntrypoint();
```

- *Type:* java.lang.String
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.homepage"></a>

```java
public java.lang.String getHomepage();
```

- *Type:* java.lang.String

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.keywords"></a>

```java
public java.util.List<java.lang.String> getKeywords();
```

- *Type:* java.util.List<java.lang.String>

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.license"></a>

```java
public java.lang.String getLicense();
```

- *Type:* java.lang.String
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.licensed"></a>

```java
public java.lang.Boolean getLicensed();
```

- *Type:* java.lang.Boolean
- *Default:* true

Indicates if a license should be added.

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.maxNodeVersion"></a>

```java
public java.lang.String getMaxNodeVersion();
```

- *Type:* java.lang.String
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.minNodeVersion"></a>

```java
public java.lang.String getMinNodeVersion();
```

- *Type:* java.lang.String
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npmAccess`<sup>Optional</sup> <a name="npmAccess" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmAccess"></a>

```java
public NpmAccess getNpmAccess();
```

- *Type:* io.github.cdklabs.projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npmRegistry`~~<sup>Optional</sup> <a name="npmRegistry" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```java
public java.lang.String getNpmRegistry();
```

- *Type:* java.lang.String

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npmRegistryUrl`<sup>Optional</sup> <a name="npmRegistryUrl" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmRegistryUrl"></a>

```java
public java.lang.String getNpmRegistryUrl();
```

- *Type:* java.lang.String
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npmTokenSecret`<sup>Optional</sup> <a name="npmTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmTokenSecret"></a>

```java
public java.lang.String getNpmTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `packageManager`<sup>Optional</sup> <a name="packageManager" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.packageManager"></a>

```java
public NodePackageManager getPackageManager();
```

- *Type:* io.github.cdklabs.projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.packageName"></a>

```java
public java.lang.String getPackageName();
```

- *Type:* java.lang.String
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peerDependencyOptions`<sup>Optional</sup> <a name="peerDependencyOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.peerDependencyOptions"></a>

```java
public PeerDependencyOptions getPeerDependencyOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peerDeps`<sup>Optional</sup> <a name="peerDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.peerDeps"></a>

```java
public java.util.List<java.lang.String> getPeerDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpmVersion`<sup>Optional</sup> <a name="pnpmVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pnpmVersion"></a>

```java
public java.lang.String getPnpmVersion();
```

- *Type:* java.lang.String
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.repository"></a>

```java
public java.lang.String getRepository();
```

- *Type:* java.lang.String

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repositoryDirectory`<sup>Optional</sup> <a name="repositoryDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.repositoryDirectory"></a>

```java
public java.lang.String getRepositoryDirectory();
```

- *Type:* java.lang.String

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scopedPackagesOptions`<sup>Optional</sup> <a name="scopedPackagesOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.scopedPackagesOptions"></a>

```java
public java.util.List<ScopedPackagesOptions> getScopedPackagesOptions();
```

- *Type:* java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions>
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```java
public java.util.Map<java.lang.String, java.lang.String> getScripts();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.stability"></a>

```java
public java.lang.String getStability();
```

- *Type:* java.lang.String

Package's Stability.

---

##### `jsiiReleaseVersion`<sup>Optional</sup> <a name="jsiiReleaseVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jsiiReleaseVersion"></a>

```java
public java.lang.String getJsiiReleaseVersion();
```

- *Type:* java.lang.String
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `majorVersion`<sup>Optional</sup> <a name="majorVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.majorVersion"></a>

```java
public java.lang.Number getMajorVersion();
```

- *Type:* java.lang.Number
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `minMajorVersion`<sup>Optional</sup> <a name="minMajorVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.minMajorVersion"></a>

```java
public java.lang.Number getMinMajorVersion();
```

- *Type:* java.lang.Number
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npmDistTag`<sup>Optional</sup> <a name="npmDistTag" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmDistTag"></a>

```java
public java.lang.String getNpmDistTag();
```

- *Type:* java.lang.String
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `postBuildSteps`<sup>Optional</sup> <a name="postBuildSteps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.postBuildSteps"></a>

```java
public java.util.List<JobStep> getPostBuildSteps();
```

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prerelease"></a>

```java
public java.lang.String getPrerelease();
```

- *Type:* java.lang.String
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publishDryRun`<sup>Optional</sup> <a name="publishDryRun" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.publishDryRun"></a>

```java
public java.lang.Boolean getPublishDryRun();
```

- *Type:* java.lang.Boolean
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publishTasks`<sup>Optional</sup> <a name="publishTasks" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.publishTasks"></a>

```java
public java.lang.Boolean getPublishTasks();
```

- *Type:* java.lang.Boolean
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `releaseBranches`<sup>Optional</sup> <a name="releaseBranches" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseBranches"></a>

```java
public java.util.Map<java.lang.String, BranchOptions> getReleaseBranches();
```

- *Type:* java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions>
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`releaseEveryCommit`~~<sup>Optional</sup> <a name="releaseEveryCommit" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```java
public java.lang.Boolean getReleaseEveryCommit();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `releaseFailureIssue`<sup>Optional</sup> <a name="releaseFailureIssue" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseFailureIssue"></a>

```java
public java.lang.Boolean getReleaseFailureIssue();
```

- *Type:* java.lang.Boolean
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `releaseFailureIssueLabel`<sup>Optional</sup> <a name="releaseFailureIssueLabel" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseFailureIssueLabel"></a>

```java
public java.lang.String getReleaseFailureIssueLabel();
```

- *Type:* java.lang.String
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`releaseSchedule`~~<sup>Optional</sup> <a name="releaseSchedule" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```java
public java.lang.String getReleaseSchedule();
```

- *Type:* java.lang.String
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `releaseTagPrefix`<sup>Optional</sup> <a name="releaseTagPrefix" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseTagPrefix"></a>

```java
public java.lang.String getReleaseTagPrefix();
```

- *Type:* java.lang.String
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `releaseTrigger`<sup>Optional</sup> <a name="releaseTrigger" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseTrigger"></a>

```java
public ReleaseTrigger getReleaseTrigger();
```

- *Type:* io.github.cdklabs.projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `releaseWorkflowName`<sup>Optional</sup> <a name="releaseWorkflowName" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflowName"></a>

```java
public java.lang.String getReleaseWorkflowName();
```

- *Type:* java.lang.String
- *Default:* "Release"

The name of the default release workflow.

---

##### `releaseWorkflowSetupSteps`<sup>Optional</sup> <a name="releaseWorkflowSetupSteps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflowSetupSteps"></a>

```java
public java.util.List<JobStep> getReleaseWorkflowSetupSteps();
```

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrcOptions`<sup>Optional</sup> <a name="versionrcOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.versionrcOptions"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getVersionrcOptions();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflowContainerImage`<sup>Optional</sup> <a name="workflowContainerImage" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowContainerImage"></a>

```java
public java.lang.String getWorkflowContainerImage();
```

- *Type:* java.lang.String
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflowRunsOn`<sup>Optional</sup> <a name="workflowRunsOn" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowRunsOn"></a>

```java
public java.util.List<java.lang.String> getWorkflowRunsOn();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `defaultReleaseBranch`<sup>Required</sup> <a name="defaultReleaseBranch" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.defaultReleaseBranch"></a>

```java
public java.lang.String getDefaultReleaseBranch();
```

- *Type:* java.lang.String
- *Default:* "main"

The name of the main release branch.

---

##### `artifactsDirectory`<sup>Optional</sup> <a name="artifactsDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.artifactsDirectory"></a>

```java
public java.lang.String getArtifactsDirectory();
```

- *Type:* java.lang.String
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `autoApproveUpgrades`<sup>Optional</sup> <a name="autoApproveUpgrades" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.autoApproveUpgrades"></a>

```java
public java.lang.Boolean getAutoApproveUpgrades();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildWorkflow"></a>

```java
public java.lang.Boolean getBuildWorkflow();
```

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `buildWorkflowTriggers`<sup>Optional</sup> <a name="buildWorkflowTriggers" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildWorkflowTriggers"></a>

```java
public Triggers getBuildWorkflowTriggers();
```

- *Type:* io.github.cdklabs.projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundlerOptions`<sup>Optional</sup> <a name="bundlerOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.bundlerOptions"></a>

```java
public BundlerOptions getBundlerOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `codeCov`<sup>Optional</sup> <a name="codeCov" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeCov"></a>

```java
public java.lang.Boolean getCodeCov();
```

- *Type:* java.lang.Boolean
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret.

---

##### `codeCovTokenSecret`<sup>Optional</sup> <a name="codeCovTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.codeCovTokenSecret"></a>

```java
public java.lang.String getCodeCovTokenSecret();
```

- *Type:* java.lang.String
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyrightOwner`<sup>Optional</sup> <a name="copyrightOwner" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.copyrightOwner"></a>

```java
public java.lang.String getCopyrightOwner();
```

- *Type:* java.lang.String
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyrightPeriod`<sup>Optional</sup> <a name="copyrightPeriod" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.copyrightPeriod"></a>

```java
public java.lang.String getCopyrightPeriod();
```

- *Type:* java.lang.String
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.dependabot"></a>

```java
public java.lang.Boolean getDependabot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabotOptions`<sup>Optional</sup> <a name="dependabotOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.dependabotOptions"></a>

```java
public DependabotOptions getDependabotOptions();
```

- *Type:* io.github.cdklabs.projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `depsUpgrade`<sup>Optional</sup> <a name="depsUpgrade" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.depsUpgrade"></a>

```java
public java.lang.Boolean getDepsUpgrade();
```

- *Type:* java.lang.Boolean
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `depsUpgradeOptions`<sup>Optional</sup> <a name="depsUpgradeOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.depsUpgradeOptions"></a>

```java
public UpgradeDependenciesOptions getDepsUpgradeOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.gitignore"></a>

```java
public java.util.List<java.lang.String> getGitignore();
```

- *Type:* java.util.List<java.lang.String>

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jest"></a>

```java
public java.lang.Boolean getJest();
```

- *Type:* java.lang.Boolean
- *Default:* true

Setup jest unit tests.

---

##### `jestOptions`<sup>Optional</sup> <a name="jestOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.jestOptions"></a>

```java
public JestOptions getJestOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutableBuild`<sup>Optional</sup> <a name="mutableBuild" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.mutableBuild"></a>

```java
public java.lang.Boolean getMutableBuild();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```java
public java.util.List<java.lang.String> getNpmignore();
```

- *Type:* java.util.List<java.lang.String>

Additional entries to .npmignore.

---

##### `npmignoreEnabled`<sup>Optional</sup> <a name="npmignoreEnabled" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmignoreEnabled"></a>

```java
public java.lang.Boolean getNpmignoreEnabled();
```

- *Type:* java.lang.Boolean
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npmIgnoreOptions`<sup>Optional</sup> <a name="npmIgnoreOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.npmIgnoreOptions"></a>

```java
public IgnoreFileOptions getNpmIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.package"></a>

```java
public java.lang.Boolean getPackage();
```

- *Type:* java.lang.Boolean
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prettier"></a>

```java
public java.lang.Boolean getPrettier();
```

- *Type:* java.lang.Boolean
- *Default:* false

Setup prettier.

---

##### `prettierOptions`<sup>Optional</sup> <a name="prettierOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.prettierOptions"></a>

```java
public PrettierOptions getPrettierOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projenDevDependency`<sup>Optional</sup> <a name="projenDevDependency" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenDevDependency"></a>

```java
public java.lang.Boolean getProjenDevDependency();
```

- *Type:* java.lang.Boolean
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJs"></a>

```java
public java.lang.Boolean getProjenrcJs();
```

- *Type:* java.lang.Boolean
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcJsOptions"></a>

```java
public ProjenrcOptions getProjenrcJsOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projenVersion`<sup>Optional</sup> <a name="projenVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenVersion"></a>

```java
public java.lang.String getProjenVersion();
```

- *Type:* java.lang.String
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pullRequestTemplate`<sup>Optional</sup> <a name="pullRequestTemplate" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pullRequestTemplate"></a>

```java
public java.lang.Boolean getPullRequestTemplate();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include a GitHub pull request template.

---

##### `pullRequestTemplateContents`<sup>Optional</sup> <a name="pullRequestTemplateContents" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.pullRequestTemplateContents"></a>

```java
public java.util.List<java.lang.String> getPullRequestTemplateContents();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.release"></a>

```java
public java.lang.Boolean getRelease();
```

- *Type:* java.lang.Boolean
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `releaseToNpm`<sup>Optional</sup> <a name="releaseToNpm" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseToNpm"></a>

```java
public java.lang.Boolean getReleaseToNpm();
```

- *Type:* java.lang.Boolean
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`releaseWorkflow`~~<sup>Optional</sup> <a name="releaseWorkflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```java
public java.lang.Boolean getReleaseWorkflow();
```

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflowBootstrapSteps`<sup>Optional</sup> <a name="workflowBootstrapSteps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowBootstrapSteps"></a>

```java
public java.util.List<JobStep> getWorkflowBootstrapSteps();
```

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflowGitIdentity`<sup>Optional</sup> <a name="workflowGitIdentity" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowGitIdentity"></a>

```java
public GitIdentity getWorkflowGitIdentity();
```

- *Type:* io.github.cdklabs.projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflowNodeVersion`<sup>Optional</sup> <a name="workflowNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.workflowNodeVersion"></a>

```java
public java.lang.String getWorkflowNodeVersion();
```

- *Type:* java.lang.String
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `disableTsconfig`<sup>Optional</sup> <a name="disableTsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.disableTsconfig"></a>

```java
public java.lang.Boolean getDisableTsconfig();
```

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disableTsconfigDev`<sup>Optional</sup> <a name="disableTsconfigDev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.disableTsconfigDev"></a>

```java
public java.lang.Boolean getDisableTsconfigDev();
```

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.docgen"></a>

```java
public java.lang.Boolean getDocgen();
```

- *Type:* java.lang.Boolean
- *Default:* false

Docgen by Typedoc.

---

##### `docsDirectory`<sup>Optional</sup> <a name="docsDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.docsDirectory"></a>

```java
public java.lang.String getDocsDirectory();
```

- *Type:* java.lang.String
- *Default:* "docs"

Docs directory.

---

##### `entrypointTypes`<sup>Optional</sup> <a name="entrypointTypes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.entrypointTypes"></a>

```java
public java.lang.String getEntrypointTypes();
```

- *Type:* java.lang.String
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.eslint"></a>

```java
public java.lang.Boolean getEslint();
```

- *Type:* java.lang.Boolean
- *Default:* true

Setup eslint.

---

##### `eslintOptions`<sup>Optional</sup> <a name="eslintOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.eslintOptions"></a>

```java
public EslintOptions getEslintOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.libdir"></a>

```java
public java.lang.String getLibdir();
```

- *Type:* java.lang.String
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcTs"></a>

```java
public java.lang.Boolean getProjenrcTs();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.projenrcTsOptions"></a>

```java
public ProjenrcOptions getProjenrcTsOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sampleCode`<sup>Optional</sup> <a name="sampleCode" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.sampleCode"></a>

```java
public java.lang.Boolean getSampleCode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.srcdir"></a>

```java
public java.lang.String getSrcdir();
```

- *Type:* java.lang.String
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.testdir"></a>

```java
public java.lang.String getTestdir();
```

- *Type:* java.lang.String
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfig"></a>

```java
public TypescriptConfigOptions getTsconfig();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfigDev`<sup>Optional</sup> <a name="tsconfigDev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfigDev"></a>

```java
public TypescriptConfigOptions getTsconfigDev();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfigDevFile`<sup>Optional</sup> <a name="tsconfigDevFile" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.tsconfigDevFile"></a>

```java
public java.lang.String getTsconfigDevFile();
```

- *Type:* java.lang.String
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescriptVersion`<sup>Optional</sup> <a name="typescriptVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.typescriptVersion"></a>

```java
public java.lang.String getTypescriptVersion();
```

- *Type:* java.lang.String
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `buildCommand`<sup>Optional</sup> <a name="buildCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.buildCommand"></a>

```java
public java.lang.String getBuildCommand();
```

- *Type:* java.lang.String
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkout"></a>

```java
public java.lang.String getCdkout();
```

- *Type:* java.lang.String
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.context"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getContext();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `featureFlags`<sup>Optional</sup> <a name="featureFlags" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.featureFlags"></a>

```java
public java.lang.Boolean getFeatureFlags();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include all feature flags in cdk.json.

---

##### `requireApproval`<sup>Optional</sup> <a name="requireApproval" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.requireApproval"></a>

```java
public ApprovalLevel getRequireApproval();
```

- *Type:* io.github.cdklabs.projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watchExcludes`<sup>Optional</sup> <a name="watchExcludes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.watchExcludes"></a>

```java
public java.util.List<java.lang.String> getWatchExcludes();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watchIncludes`<sup>Optional</sup> <a name="watchIncludes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.watchIncludes"></a>

```java
public java.util.List<java.lang.String> getWatchIncludes();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkVersion"></a>

```java
public java.lang.String getCdkVersion();
```

- *Type:* java.lang.String
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdkAssert`~~<sup>Optional</sup> <a name="cdkAssert" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkAssert"></a>

- *Deprecated:* The

```java
public java.lang.Boolean getCdkAssert();
```

- *Type:* java.lang.Boolean
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdkAssertions`<sup>Optional</sup> <a name="cdkAssertions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkAssertions"></a>

```java
public java.lang.Boolean getCdkAssertions();
```

- *Type:* java.lang.Boolean
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdkDependencies`~~<sup>Optional</sup> <a name="cdkDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

```java
public java.util.List<java.lang.String> getCdkDependencies();
```

- *Type:* java.util.List<java.lang.String>

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdkDependenciesAsDeps`~~<sup>Optional</sup> <a name="cdkDependenciesAsDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

```java
public java.lang.Boolean getCdkDependenciesAsDeps();
```

- *Type:* java.lang.Boolean
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdkTestDependencies`~~<sup>Optional</sup> <a name="cdkTestDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

```java
public java.util.List<java.lang.String> getCdkTestDependencies();
```

- *Type:* java.util.List<java.lang.String>

AWS CDK modules required for testing.

---

##### `cdkVersionPinning`<sup>Optional</sup> <a name="cdkVersionPinning" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.cdkVersionPinning"></a>

```java
public java.lang.Boolean getCdkVersionPinning();
```

- *Type:* java.lang.Boolean

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructsVersion`<sup>Optional</sup> <a name="constructsVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.constructsVersion"></a>

```java
public java.lang.String getConstructsVersion();
```

- *Type:* java.lang.String
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `appEntrypoint`<sup>Optional</sup> <a name="appEntrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.appEntrypoint"></a>

```java
public java.lang.String getAppEntrypoint();
```

- *Type:* java.lang.String
- *Default:* "main.ts"

The CDK app's entrypoint (relative to the source directory, which is "src" by default).

---

##### `edgeLambdaAutoDiscover`<sup>Optional</sup> <a name="edgeLambdaAutoDiscover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.edgeLambdaAutoDiscover"></a>

```java
public java.lang.Boolean getEdgeLambdaAutoDiscover();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically adds an `cloudfront.experimental.EdgeFunction` for each `.edge-lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `integrationTestAutoDiscover`<sup>Optional</sup> <a name="integrationTestAutoDiscover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.integrationTestAutoDiscover"></a>

```java
public java.lang.Boolean getIntegrationTestAutoDiscover();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically discovers and creates integration tests for each `.integ.ts` file in under your test directory.

---

##### `lambdaAutoDiscover`<sup>Optional</sup> <a name="lambdaAutoDiscover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaAutoDiscover"></a>

```java
public java.lang.Boolean getLambdaAutoDiscover();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically adds an `awscdk.LambdaFunction` for each `.lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `lambdaExtensionAutoDiscover`<sup>Optional</sup> <a name="lambdaExtensionAutoDiscover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaExtensionAutoDiscover"></a>

```java
public java.lang.Boolean getLambdaExtensionAutoDiscover();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically adds an `awscdk.LambdaExtension` for each `.lambda-extension.ts` entrypoint in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `lambdaOptions`<sup>Optional</sup> <a name="lambdaOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProjectOptions.property.lambdaOptions"></a>

```java
public LambdaFunctionCommonOptions getLambdaOptions();
```

- *Type:* io.github.cdklabs.projen.awscdk.LambdaFunctionCommonOptions
- *Default:* default options

Common options for all AWS Lambda functions.

---

### SemverGroup <a name="SemverGroup" id="aws-prototyping-sdk.nx_monorepo.SemverGroup"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.Initializer"></a>

```java
import software.aws.awsprototypingsdk.nxmonorepo.SemverGroup;

SemverGroup.builder()
    .dependencies(java.util.List<java.lang.String>)
    .packages(java.util.List<java.lang.String>)
    .range(java.lang.String)
//  .dependencyTypes(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SemverGroup.property.dependencies">dependencies</a></code> | <code>java.util.List<java.lang.String></code> | the names of the dependencies (eg. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SemverGroup.property.packages">packages</a></code> | <code>java.util.List<java.lang.String></code> | the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SemverGroup.property.range">range</a></code> | <code>java.lang.String</code> | the semver range which dependencies in this group should use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SemverGroup.property.dependencyTypes">dependencyTypes</a></code> | <code>java.util.List<java.lang.String></code> | optionally only apply this group to dependencies of the provided types. |

---

##### `dependencies`<sup>Required</sup> <a name="dependencies" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.property.dependencies"></a>

```java
public java.util.List<java.lang.String> getDependencies();
```

- *Type:* java.util.List<java.lang.String>

the names of the dependencies (eg.

"lodash") which belong to this group

---

##### `packages`<sup>Required</sup> <a name="packages" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.property.packages"></a>

```java
public java.util.List<java.lang.String> getPackages();
```

- *Type:* java.util.List<java.lang.String>

the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name.

---

##### `range`<sup>Required</sup> <a name="range" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.property.range"></a>

```java
public java.lang.String getRange();
```

- *Type:* java.lang.String

the semver range which dependencies in this group should use.

---

##### `dependencyTypes`<sup>Optional</sup> <a name="dependencyTypes" id="aws-prototyping-sdk.nx_monorepo.SemverGroup.property.dependencyTypes"></a>

```java
public java.util.List<java.lang.String> getDependencyTypes();
```

- *Type:* java.util.List<java.lang.String>

optionally only apply this group to dependencies of the provided types.

---

### SonarCodeScannerConfig <a name="SonarCodeScannerConfig" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pipeline.SonarCodeScannerConfig;

SonarCodeScannerConfig.builder()
    .sonarqubeAuthorizedGroup(java.lang.String)
    .sonarqubeDefaultProfileOrGateName(java.lang.String)
    .sonarqubeEndpoint(java.lang.String)
    .sonarqubeProjectName(java.lang.String)
//  .cdkOutDir(java.lang.String)
//  .cfnNagIgnorePath(java.lang.String)
//  .excludeGlobsForScan(java.util.List<java.lang.String>)
//  .includeGlobsForScan(java.util.List<java.lang.String>)
//  .preArchiveCommands(java.util.List<java.lang.String>)
//  .sonarqubeSpecificProfileOrGateName(java.lang.String)
//  .sonarqubeTags(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeAuthorizedGroup">sonarqubeAuthorizedGroup</a></code> | <code>java.lang.String</code> | Group name in Sonarqube with access to administer this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeDefaultProfileOrGateName">sonarqubeDefaultProfileOrGateName</a></code> | <code>java.lang.String</code> | Default profile/gate name i.e: your org profile. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeEndpoint">sonarqubeEndpoint</a></code> | <code>java.lang.String</code> | endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeProjectName">sonarqubeProjectName</a></code> | <code>java.lang.String</code> | Name of the project to create in Sonarqube. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.cdkOutDir">cdkOutDir</a></code> | <code>java.lang.String</code> | directory containing the synthesized cdk resources. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.cfnNagIgnorePath">cfnNagIgnorePath</a></code> | <code>java.lang.String</code> | path to a file containing the cfn nag suppression rules. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.excludeGlobsForScan">excludeGlobsForScan</a></code> | <code>java.util.List<java.lang.String></code> | glob patterns to exclude from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.includeGlobsForScan">includeGlobsForScan</a></code> | <code>java.util.List<java.lang.String></code> | glob patterns to include from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.preArchiveCommands">preArchiveCommands</a></code> | <code>java.util.List<java.lang.String></code> | Hook which allows custom commands to be executed before the process commences the archival process. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeSpecificProfileOrGateName">sonarqubeSpecificProfileOrGateName</a></code> | <code>java.lang.String</code> | Specific profile/gate name i.e: language specific. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeTags">sonarqubeTags</a></code> | <code>java.util.List<java.lang.String></code> | Tags to associate with this project. |

---

##### `sonarqubeAuthorizedGroup`<sup>Required</sup> <a name="sonarqubeAuthorizedGroup" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeAuthorizedGroup"></a>

```java
public java.lang.String getSonarqubeAuthorizedGroup();
```

- *Type:* java.lang.String

Group name in Sonarqube with access to administer this project.

---

##### `sonarqubeDefaultProfileOrGateName`<sup>Required</sup> <a name="sonarqubeDefaultProfileOrGateName" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeDefaultProfileOrGateName"></a>

```java
public java.lang.String getSonarqubeDefaultProfileOrGateName();
```

- *Type:* java.lang.String

Default profile/gate name i.e: your org profile.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqubeEndpoint`<sup>Required</sup> <a name="sonarqubeEndpoint" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeEndpoint"></a>

```java
public java.lang.String getSonarqubeEndpoint();
```

- *Type:* java.lang.String

endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>.

Note: Ensure a trailing '/' is not included.

---

##### `sonarqubeProjectName`<sup>Required</sup> <a name="sonarqubeProjectName" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeProjectName"></a>

```java
public java.lang.String getSonarqubeProjectName();
```

- *Type:* java.lang.String

Name of the project to create in Sonarqube.

---

##### `cdkOutDir`<sup>Optional</sup> <a name="cdkOutDir" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.cdkOutDir"></a>

```java
public java.lang.String getCdkOutDir();
```

- *Type:* java.lang.String

directory containing the synthesized cdk resources.

---

##### `cfnNagIgnorePath`<sup>Optional</sup> <a name="cfnNagIgnorePath" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.cfnNagIgnorePath"></a>

```java
public java.lang.String getCfnNagIgnorePath();
```

- *Type:* java.lang.String

path to a file containing the cfn nag suppression rules.

---

##### `excludeGlobsForScan`<sup>Optional</sup> <a name="excludeGlobsForScan" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.excludeGlobsForScan"></a>

```java
public java.util.List<java.lang.String> getExcludeGlobsForScan();
```

- *Type:* java.util.List<java.lang.String>

glob patterns to exclude from sonar scan.

---

##### `includeGlobsForScan`<sup>Optional</sup> <a name="includeGlobsForScan" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.includeGlobsForScan"></a>

```java
public java.util.List<java.lang.String> getIncludeGlobsForScan();
```

- *Type:* java.util.List<java.lang.String>

glob patterns to include from sonar scan.

---

##### `preArchiveCommands`<sup>Optional</sup> <a name="preArchiveCommands" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.preArchiveCommands"></a>

```java
public java.util.List<java.lang.String> getPreArchiveCommands();
```

- *Type:* java.util.List<java.lang.String>

Hook which allows custom commands to be executed before the process commences the archival process.

---

##### `sonarqubeSpecificProfileOrGateName`<sup>Optional</sup> <a name="sonarqubeSpecificProfileOrGateName" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeSpecificProfileOrGateName"></a>

```java
public java.lang.String getSonarqubeSpecificProfileOrGateName();
```

- *Type:* java.lang.String

Specific profile/gate name i.e: language specific.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqubeTags`<sup>Optional</sup> <a name="sonarqubeTags" id="aws-prototyping-sdk.pipeline.SonarCodeScannerConfig.property.sonarqubeTags"></a>

```java
public java.util.List<java.lang.String> getSonarqubeTags();
```

- *Type:* java.util.List<java.lang.String>

Tags to associate with this project.

---

### SonarCodeScannerProps <a name="SonarCodeScannerProps" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps"></a>

SonarCodeScanners properties.

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pipeline.SonarCodeScannerProps;

SonarCodeScannerProps.builder()
    .sonarqubeAuthorizedGroup(java.lang.String)
    .sonarqubeDefaultProfileOrGateName(java.lang.String)
    .sonarqubeEndpoint(java.lang.String)
    .sonarqubeProjectName(java.lang.String)
//  .cdkOutDir(java.lang.String)
//  .cfnNagIgnorePath(java.lang.String)
//  .excludeGlobsForScan(java.util.List<java.lang.String>)
//  .includeGlobsForScan(java.util.List<java.lang.String>)
//  .preArchiveCommands(java.util.List<java.lang.String>)
//  .sonarqubeSpecificProfileOrGateName(java.lang.String)
//  .sonarqubeTags(java.util.List<java.lang.String>)
    .artifactBucketArn(java.lang.String)
    .synthBuildArn(java.lang.String)
//  .artifactBucketKeyArn(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeAuthorizedGroup">sonarqubeAuthorizedGroup</a></code> | <code>java.lang.String</code> | Group name in Sonarqube with access to administer this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeDefaultProfileOrGateName">sonarqubeDefaultProfileOrGateName</a></code> | <code>java.lang.String</code> | Default profile/gate name i.e: your org profile. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeEndpoint">sonarqubeEndpoint</a></code> | <code>java.lang.String</code> | endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeProjectName">sonarqubeProjectName</a></code> | <code>java.lang.String</code> | Name of the project to create in Sonarqube. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.cdkOutDir">cdkOutDir</a></code> | <code>java.lang.String</code> | directory containing the synthesized cdk resources. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.cfnNagIgnorePath">cfnNagIgnorePath</a></code> | <code>java.lang.String</code> | path to a file containing the cfn nag suppression rules. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.excludeGlobsForScan">excludeGlobsForScan</a></code> | <code>java.util.List<java.lang.String></code> | glob patterns to exclude from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.includeGlobsForScan">includeGlobsForScan</a></code> | <code>java.util.List<java.lang.String></code> | glob patterns to include from sonar scan. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.preArchiveCommands">preArchiveCommands</a></code> | <code>java.util.List<java.lang.String></code> | Hook which allows custom commands to be executed before the process commences the archival process. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeSpecificProfileOrGateName">sonarqubeSpecificProfileOrGateName</a></code> | <code>java.lang.String</code> | Specific profile/gate name i.e: language specific. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeTags">sonarqubeTags</a></code> | <code>java.util.List<java.lang.String></code> | Tags to associate with this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.artifactBucketArn">artifactBucketArn</a></code> | <code>java.lang.String</code> | S3 bucket ARN containing the built artifacts from the synth build. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.synthBuildArn">synthBuildArn</a></code> | <code>java.lang.String</code> | ARN for the CodeBuild task responsible for executing the synth command. |
| <code><a href="#aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.artifactBucketKeyArn">artifactBucketKeyArn</a></code> | <code>java.lang.String</code> | Artifact bucket key ARN used to encrypt the artifacts. |

---

##### `sonarqubeAuthorizedGroup`<sup>Required</sup> <a name="sonarqubeAuthorizedGroup" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeAuthorizedGroup"></a>

```java
public java.lang.String getSonarqubeAuthorizedGroup();
```

- *Type:* java.lang.String

Group name in Sonarqube with access to administer this project.

---

##### `sonarqubeDefaultProfileOrGateName`<sup>Required</sup> <a name="sonarqubeDefaultProfileOrGateName" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeDefaultProfileOrGateName"></a>

```java
public java.lang.String getSonarqubeDefaultProfileOrGateName();
```

- *Type:* java.lang.String

Default profile/gate name i.e: your org profile.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqubeEndpoint`<sup>Required</sup> <a name="sonarqubeEndpoint" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeEndpoint"></a>

```java
public java.lang.String getSonarqubeEndpoint();
```

- *Type:* java.lang.String

endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>.

Note: Ensure a trailing '/' is not included.

---

##### `sonarqubeProjectName`<sup>Required</sup> <a name="sonarqubeProjectName" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeProjectName"></a>

```java
public java.lang.String getSonarqubeProjectName();
```

- *Type:* java.lang.String

Name of the project to create in Sonarqube.

---

##### `cdkOutDir`<sup>Optional</sup> <a name="cdkOutDir" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.cdkOutDir"></a>

```java
public java.lang.String getCdkOutDir();
```

- *Type:* java.lang.String

directory containing the synthesized cdk resources.

---

##### `cfnNagIgnorePath`<sup>Optional</sup> <a name="cfnNagIgnorePath" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.cfnNagIgnorePath"></a>

```java
public java.lang.String getCfnNagIgnorePath();
```

- *Type:* java.lang.String

path to a file containing the cfn nag suppression rules.

---

##### `excludeGlobsForScan`<sup>Optional</sup> <a name="excludeGlobsForScan" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.excludeGlobsForScan"></a>

```java
public java.util.List<java.lang.String> getExcludeGlobsForScan();
```

- *Type:* java.util.List<java.lang.String>

glob patterns to exclude from sonar scan.

---

##### `includeGlobsForScan`<sup>Optional</sup> <a name="includeGlobsForScan" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.includeGlobsForScan"></a>

```java
public java.util.List<java.lang.String> getIncludeGlobsForScan();
```

- *Type:* java.util.List<java.lang.String>

glob patterns to include from sonar scan.

---

##### `preArchiveCommands`<sup>Optional</sup> <a name="preArchiveCommands" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.preArchiveCommands"></a>

```java
public java.util.List<java.lang.String> getPreArchiveCommands();
```

- *Type:* java.util.List<java.lang.String>

Hook which allows custom commands to be executed before the process commences the archival process.

---

##### `sonarqubeSpecificProfileOrGateName`<sup>Optional</sup> <a name="sonarqubeSpecificProfileOrGateName" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeSpecificProfileOrGateName"></a>

```java
public java.lang.String getSonarqubeSpecificProfileOrGateName();
```

- *Type:* java.lang.String

Specific profile/gate name i.e: language specific.

Note: These need to be set up in Sonarqube manually.

---

##### `sonarqubeTags`<sup>Optional</sup> <a name="sonarqubeTags" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.sonarqubeTags"></a>

```java
public java.util.List<java.lang.String> getSonarqubeTags();
```

- *Type:* java.util.List<java.lang.String>

Tags to associate with this project.

---

##### `artifactBucketArn`<sup>Required</sup> <a name="artifactBucketArn" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.artifactBucketArn"></a>

```java
public java.lang.String getArtifactBucketArn();
```

- *Type:* java.lang.String

S3 bucket ARN containing the built artifacts from the synth build.

---

##### `synthBuildArn`<sup>Required</sup> <a name="synthBuildArn" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.synthBuildArn"></a>

```java
public java.lang.String getSynthBuildArn();
```

- *Type:* java.lang.String

ARN for the CodeBuild task responsible for executing the synth command.

---

##### `artifactBucketKeyArn`<sup>Optional</sup> <a name="artifactBucketKeyArn" id="aws-prototyping-sdk.pipeline.SonarCodeScannerProps.property.artifactBucketKeyArn"></a>

```java
public java.lang.String getArtifactBucketKeyArn();
```

- *Type:* java.lang.String

Artifact bucket key ARN used to encrypt the artifacts.

---

### SyncpackConfig <a name="SyncpackConfig" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.Initializer"></a>

```java
import software.aws.awsprototypingsdk.nxmonorepo.SyncpackConfig;

SyncpackConfig.builder()
    .dependencyTypes(java.util.List<java.lang.String>)
    .dev(java.lang.Boolean)
    .filter(java.lang.String)
    .indent(java.lang.String)
    .overrides(java.lang.Boolean)
    .peer(java.lang.Boolean)
    .pnpmOverrides(java.lang.Boolean)
    .prod(java.lang.Boolean)
    .resolutions(java.lang.Boolean)
    .semverGroups(java.util.List<SemverGroup>)
    .semverRange(java.lang.String)
    .sortAz(java.util.List<java.lang.String>)
    .sortFirst(java.util.List<java.lang.String>)
    .source(java.util.List<java.lang.String>)
    .versionGroups(java.util.List<VersionGroup>)
    .workspace(java.lang.Boolean)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.dependencyTypes">dependencyTypes</a></code> | <code>java.util.List<java.lang.String></code> | which dependency properties to search within. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.dev">dev</a></code> | <code>java.lang.Boolean</code> | whether to search within devDependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.filter">filter</a></code> | <code>java.lang.String</code> | a string which will be passed to `new RegExp()` to match against package names that should be included. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.indent">indent</a></code> | <code>java.lang.String</code> | the character(s) to be used to indent your package.json files when writing to disk. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.overrides">overrides</a></code> | <code>java.lang.Boolean</code> | whether to search within npm overrides. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.peer">peer</a></code> | <code>java.lang.Boolean</code> | whether to search within peerDependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.pnpmOverrides">pnpmOverrides</a></code> | <code>java.lang.Boolean</code> | whether to search within pnpm overrides. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.prod">prod</a></code> | <code>java.lang.Boolean</code> | whether to search within dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.resolutions">resolutions</a></code> | <code>java.lang.Boolean</code> | whether to search within yarn resolutions. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.semverGroups">semverGroups</a></code> | <code>java.util.List<software.aws.awsprototypingsdk.nxmonorepo.SemverGroup></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.semverRange">semverRange</a></code> | <code>java.lang.String</code> | defaults to `""` to ensure that exact dependency versions are used instead of loose ranges. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.sortAz">sortAz</a></code> | <code>java.util.List<java.lang.String></code> | which fields within package.json files should be sorted alphabetically. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.sortFirst">sortFirst</a></code> | <code>java.util.List<java.lang.String></code> | which fields within package.json files should appear at the top, and in what order. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.source">source</a></code> | <code>java.util.List<java.lang.String></code> | glob patterns for package.json file locations. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.versionGroups">versionGroups</a></code> | <code>java.util.List<software.aws.awsprototypingsdk.nxmonorepo.VersionGroup></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.workspace">workspace</a></code> | <code>java.lang.Boolean</code> | whether to include the versions of the `--source` packages developed in your workspace/monorepo as part of the search for versions to sync. |

---

##### `dependencyTypes`<sup>Required</sup> <a name="dependencyTypes" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.dependencyTypes"></a>

```java
public java.util.List<java.lang.String> getDependencyTypes();
```

- *Type:* java.util.List<java.lang.String>

which dependency properties to search within.

---

##### `dev`<sup>Required</sup> <a name="dev" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.dev"></a>

```java
public java.lang.Boolean getDev();
```

- *Type:* java.lang.Boolean

whether to search within devDependencies.

---

##### `filter`<sup>Required</sup> <a name="filter" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.filter"></a>

```java
public java.lang.String getFilter();
```

- *Type:* java.lang.String

a string which will be passed to `new RegExp()` to match against package names that should be included.

---

##### `indent`<sup>Required</sup> <a name="indent" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.indent"></a>

```java
public java.lang.String getIndent();
```

- *Type:* java.lang.String

the character(s) to be used to indent your package.json files when writing to disk.

---

##### `overrides`<sup>Required</sup> <a name="overrides" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.overrides"></a>

```java
public java.lang.Boolean getOverrides();
```

- *Type:* java.lang.Boolean

whether to search within npm overrides.

---

##### `peer`<sup>Required</sup> <a name="peer" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.peer"></a>

```java
public java.lang.Boolean getPeer();
```

- *Type:* java.lang.Boolean

whether to search within peerDependencies.

---

##### `pnpmOverrides`<sup>Required</sup> <a name="pnpmOverrides" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.pnpmOverrides"></a>

```java
public java.lang.Boolean getPnpmOverrides();
```

- *Type:* java.lang.Boolean

whether to search within pnpm overrides.

---

##### `prod`<sup>Required</sup> <a name="prod" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.prod"></a>

```java
public java.lang.Boolean getProd();
```

- *Type:* java.lang.Boolean

whether to search within dependencies.

---

##### `resolutions`<sup>Required</sup> <a name="resolutions" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.resolutions"></a>

```java
public java.lang.Boolean getResolutions();
```

- *Type:* java.lang.Boolean

whether to search within yarn resolutions.

---

##### `semverGroups`<sup>Required</sup> <a name="semverGroups" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.semverGroups"></a>

```java
public java.util.List<SemverGroup> getSemverGroups();
```

- *Type:* java.util.List<software.aws.awsprototypingsdk.nxmonorepo.SemverGroup>

---

##### `semverRange`<sup>Required</sup> <a name="semverRange" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.semverRange"></a>

```java
public java.lang.String getSemverRange();
```

- *Type:* java.lang.String

defaults to `""` to ensure that exact dependency versions are used instead of loose ranges.

---

##### `sortAz`<sup>Required</sup> <a name="sortAz" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.sortAz"></a>

```java
public java.util.List<java.lang.String> getSortAz();
```

- *Type:* java.util.List<java.lang.String>

which fields within package.json files should be sorted alphabetically.

---

##### `sortFirst`<sup>Required</sup> <a name="sortFirst" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.sortFirst"></a>

```java
public java.util.List<java.lang.String> getSortFirst();
```

- *Type:* java.util.List<java.lang.String>

which fields within package.json files should appear at the top, and in what order.

---

##### `source`<sup>Required</sup> <a name="source" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.source"></a>

```java
public java.util.List<java.lang.String> getSource();
```

- *Type:* java.util.List<java.lang.String>

glob patterns for package.json file locations.

---

##### `versionGroups`<sup>Required</sup> <a name="versionGroups" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.versionGroups"></a>

```java
public java.util.List<VersionGroup> getVersionGroups();
```

- *Type:* java.util.List<software.aws.awsprototypingsdk.nxmonorepo.VersionGroup>

---

##### `workspace`<sup>Required</sup> <a name="workspace" id="aws-prototyping-sdk.nx_monorepo.SyncpackConfig.property.workspace"></a>

```java
public java.lang.Boolean getWorkspace();
```

- *Type:* java.lang.Boolean

whether to include the versions of the `--source` packages developed in your workspace/monorepo as part of the search for versions to sync.

---

### VersionGroup <a name="VersionGroup" id="aws-prototyping-sdk.nx_monorepo.VersionGroup"></a>

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.Initializer"></a>

```java
import software.aws.awsprototypingsdk.nxmonorepo.VersionGroup;

VersionGroup.builder()
    .dependencies(java.util.List<java.lang.String>)
    .packages(java.util.List<java.lang.String>)
//  .dependencyTypes(java.util.List<java.lang.String>)
//  .isBanned(java.lang.Boolean)
//  .pinVersion(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.dependencies">dependencies</a></code> | <code>java.util.List<java.lang.String></code> | the names of the dependencies (eg. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.packages">packages</a></code> | <code>java.util.List<java.lang.String></code> | the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.dependencyTypes">dependencyTypes</a></code> | <code>java.util.List<java.lang.String></code> | optionally only apply this group to dependencies of the provided types. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.isBanned">isBanned</a></code> | <code>java.lang.Boolean</code> | optionally force all dependencies in this group to be removed. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.VersionGroup.property.pinVersion">pinVersion</a></code> | <code>java.lang.String</code> | optionally force all dependencies in this group to have this version. |

---

##### `dependencies`<sup>Required</sup> <a name="dependencies" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.dependencies"></a>

```java
public java.util.List<java.lang.String> getDependencies();
```

- *Type:* java.util.List<java.lang.String>

the names of the dependencies (eg.

"lodash") which belong to this group

---

##### `packages`<sup>Required</sup> <a name="packages" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.packages"></a>

```java
public java.util.List<java.lang.String> getPackages();
```

- *Type:* java.util.List<java.lang.String>

the names of packages in your monorepo which belong to this group, taken from the "name" field in package.json, not the package directory name.

---

##### `dependencyTypes`<sup>Optional</sup> <a name="dependencyTypes" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.dependencyTypes"></a>

```java
public java.util.List<java.lang.String> getDependencyTypes();
```

- *Type:* java.util.List<java.lang.String>

optionally only apply this group to dependencies of the provided types.

---

##### `isBanned`<sup>Optional</sup> <a name="isBanned" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.isBanned"></a>

```java
public java.lang.Boolean getIsBanned();
```

- *Type:* java.lang.Boolean

optionally force all dependencies in this group to be removed.

---

##### `pinVersion`<sup>Optional</sup> <a name="pinVersion" id="aws-prototyping-sdk.nx_monorepo.VersionGroup.property.pinVersion"></a>

```java
public java.lang.String getPinVersion();
```

- *Type:* java.lang.String

optionally force all dependencies in this group to have this version.

---

### WorkspaceConfig <a name="WorkspaceConfig" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig"></a>

Workspace configurations.

> [https://classic.yarnpkg.com/lang/en/docs/workspaces/](https://classic.yarnpkg.com/lang/en/docs/workspaces/)

#### Initializer <a name="Initializer" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.Initializer"></a>

```java
import software.aws.awsprototypingsdk.nxmonorepo.WorkspaceConfig;

WorkspaceConfig.builder()
//  .additionalPackages(java.util.List<java.lang.String>)
//  .disableNoHoistBundled(java.lang.Boolean)
//  .linkLocalWorkspaceBins(java.lang.Boolean)
//  .noHoist(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.additionalPackages">additionalPackages</a></code> | <code>java.util.List<java.lang.String></code> | List of additional package globs to include in the workspace. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.disableNoHoistBundled">disableNoHoistBundled</a></code> | <code>java.lang.Boolean</code> | Disable automatically applying `noHoist` logic for all sub-project "bundledDependencies". |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.linkLocalWorkspaceBins">linkLocalWorkspaceBins</a></code> | <code>java.lang.Boolean</code> | Links all local workspace project bins so they can be used for local development. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.noHoist">noHoist</a></code> | <code>java.util.List<java.lang.String></code> | List of package globs to exclude from hoisting in the workspace. |

---

##### `additionalPackages`<sup>Optional</sup> <a name="additionalPackages" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.additionalPackages"></a>

```java
public java.util.List<java.lang.String> getAdditionalPackages();
```

- *Type:* java.util.List<java.lang.String>

List of additional package globs to include in the workspace.

All packages which are parented by the monorepo are automatically added to the workspace, but you can use this
property to specify any additional paths to packages which may not be managed by projen.

---

##### `disableNoHoistBundled`<sup>Optional</sup> <a name="disableNoHoistBundled" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.disableNoHoistBundled"></a>

```java
public java.lang.Boolean getDisableNoHoistBundled();
```

- *Type:* java.lang.Boolean
- *Default:* false

Disable automatically applying `noHoist` logic for all sub-project "bundledDependencies".

---

##### `linkLocalWorkspaceBins`<sup>Optional</sup> <a name="linkLocalWorkspaceBins" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.linkLocalWorkspaceBins"></a>

```java
public java.lang.Boolean getLinkLocalWorkspaceBins();
```

- *Type:* java.lang.Boolean

Links all local workspace project bins so they can be used for local development.

Package bins are only linked when installed from the registry, however it is very useful
for monorepo development to also utilize these bin scripts. When enabled, this flag will
recursively link all bins from packages.json files to the root node_modules/.bin.

---

##### `noHoist`<sup>Optional</sup> <a name="noHoist" id="aws-prototyping-sdk.nx_monorepo.WorkspaceConfig.property.noHoist"></a>

```java
public java.util.List<java.lang.String> getNoHoist();
```

- *Type:* java.util.List<java.lang.String>

List of package globs to exclude from hoisting in the workspace.

> [https://classic.yarnpkg.com/blog/2018/02/15/nohoist/](https://classic.yarnpkg.com/blog/2018/02/15/nohoist/)

---

## Classes <a name="Classes" id="Classes"></a>

### AwsPrototypingChecks <a name="AwsPrototypingChecks" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks"></a>

Check best practices for prototypes.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pdknag.AwsPrototypingChecks;

AwsPrototypingChecks.Builder.create()
//  .logIgnores(java.lang.Boolean)
//  .reports(java.lang.Boolean)
//  .suppressionIgnoreCondition(INagSuppressionIgnore)
//  .verbose(java.lang.Boolean)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.logIgnores">logIgnores</a></code> | <code>java.lang.Boolean</code> | Whether or not to log triggered rules that have been suppressed as informational messages (default: false). |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.reports">reports</a></code> | <code>java.lang.Boolean</code> | Whether or not to generate CSV compliance reports for applied Stacks in the App's output directory (default: true). |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.suppressionIgnoreCondition">suppressionIgnoreCondition</a></code> | <code>io.github.cdklabs.cdknag.INagSuppressionIgnore</code> | Conditionally prevent rules from being suppressed (default: no user provided condition). |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.verbose">verbose</a></code> | <code>java.lang.Boolean</code> | Whether or not to enable extended explanatory descriptions on warning, error, and logged ignore messages (default: false). |

---

##### `logIgnores`<sup>Optional</sup> <a name="logIgnores" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.logIgnores"></a>

- *Type:* java.lang.Boolean

Whether or not to log triggered rules that have been suppressed as informational messages (default: false).

---

##### `reports`<sup>Optional</sup> <a name="reports" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.reports"></a>

- *Type:* java.lang.Boolean

Whether or not to generate CSV compliance reports for applied Stacks in the App's output directory (default: true).

---

##### `suppressionIgnoreCondition`<sup>Optional</sup> <a name="suppressionIgnoreCondition" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.suppressionIgnoreCondition"></a>

- *Type:* io.github.cdklabs.cdknag.INagSuppressionIgnore

Conditionally prevent rules from being suppressed (default: no user provided condition).

---

##### `verbose`<sup>Optional</sup> <a name="verbose" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.Initializer.parameter.verbose"></a>

- *Type:* java.lang.Boolean

Whether or not to enable extended explanatory descriptions on warning, error, and logged ignore messages (default: false).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.visit">visit</a></code> | Check if CfnResource and apply rules. |

---

##### `visit` <a name="visit" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.visit"></a>

```java
public void visit(IConstruct node)
```

Check if CfnResource and apply rules.

###### `node`<sup>Required</sup> <a name="node" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.visit.parameter.node"></a>

- *Type:* software.constructs.IConstruct

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.property.readPackName">readPackName</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.property.readReportStacks">readReportStacks</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |

---

##### `readPackName`<sup>Required</sup> <a name="readPackName" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.property.readPackName"></a>

```java
public java.lang.String getReadPackName();
```

- *Type:* java.lang.String

---

##### `readReportStacks`<sup>Required</sup> <a name="readReportStacks" id="aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks.property.readReportStacks"></a>

```java
public java.util.List<java.lang.String> getReadReportStacks();
```

- *Type:* java.util.List<java.lang.String>

---


### NxMonorepoProject <a name="NxMonorepoProject" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject"></a>

This project type will bootstrap a NX based monorepo with support for polygot builds, build caching, dependency graph visualization and much more.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer"></a>

```java
import software.aws.awsprototypingsdk.nxmonorepo.NxMonorepoProject;

NxMonorepoProject.Builder.create()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
//  .allowLibraryDependencies(java.lang.Boolean)
//  .authorEmail(java.lang.String)
//  .authorName(java.lang.String)
//  .authorOrganization(java.lang.Boolean)
//  .authorUrl(java.lang.String)
//  .autoDetectBin(java.lang.Boolean)
//  .bin(java.util.Map<java.lang.String, java.lang.String>)
//  .bugsEmail(java.lang.String)
//  .bugsUrl(java.lang.String)
//  .bundledDeps(java.util.List<java.lang.String>)
//  .codeArtifactOptions(CodeArtifactOptions)
//  .deps(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .devDeps(java.util.List<java.lang.String>)
//  .entrypoint(java.lang.String)
//  .homepage(java.lang.String)
//  .keywords(java.util.List<java.lang.String>)
//  .license(java.lang.String)
//  .licensed(java.lang.Boolean)
//  .maxNodeVersion(java.lang.String)
//  .minNodeVersion(java.lang.String)
//  .npmAccess(NpmAccess)
//  .npmRegistry(java.lang.String)
//  .npmRegistryUrl(java.lang.String)
//  .npmTokenSecret(java.lang.String)
//  .packageManager(NodePackageManager)
//  .packageName(java.lang.String)
//  .peerDependencyOptions(PeerDependencyOptions)
//  .peerDeps(java.util.List<java.lang.String>)
//  .pnpmVersion(java.lang.String)
//  .repository(java.lang.String)
//  .repositoryDirectory(java.lang.String)
//  .scopedPackagesOptions(java.util.List<ScopedPackagesOptions>)
//  .scripts(java.util.Map<java.lang.String, java.lang.String>)
//  .stability(java.lang.String)
//  .jsiiReleaseVersion(java.lang.String)
//  .majorVersion(java.lang.Number)
//  .minMajorVersion(java.lang.Number)
//  .npmDistTag(java.lang.String)
//  .postBuildSteps(java.util.List<JobStep>)
//  .prerelease(java.lang.String)
//  .publishDryRun(java.lang.Boolean)
//  .publishTasks(java.lang.Boolean)
//  .releaseBranches(java.util.Map<java.lang.String, BranchOptions>)
//  .releaseEveryCommit(java.lang.Boolean)
//  .releaseFailureIssue(java.lang.Boolean)
//  .releaseFailureIssueLabel(java.lang.String)
//  .releaseSchedule(java.lang.String)
//  .releaseTagPrefix(java.lang.String)
//  .releaseTrigger(ReleaseTrigger)
//  .releaseWorkflowName(java.lang.String)
//  .releaseWorkflowSetupSteps(java.util.List<JobStep>)
//  .versionrcOptions(java.util.Map<java.lang.String, java.lang.Object>)
//  .workflowContainerImage(java.lang.String)
//  .workflowRunsOn(java.util.List<java.lang.String>)
    .defaultReleaseBranch(java.lang.String)
//  .artifactsDirectory(java.lang.String)
//  .autoApproveUpgrades(java.lang.Boolean)
//  .buildWorkflow(java.lang.Boolean)
//  .buildWorkflowTriggers(Triggers)
//  .bundlerOptions(BundlerOptions)
//  .codeCov(java.lang.Boolean)
//  .codeCovTokenSecret(java.lang.String)
//  .copyrightOwner(java.lang.String)
//  .copyrightPeriod(java.lang.String)
//  .dependabot(java.lang.Boolean)
//  .dependabotOptions(DependabotOptions)
//  .depsUpgrade(java.lang.Boolean)
//  .depsUpgradeOptions(UpgradeDependenciesOptions)
//  .gitignore(java.util.List<java.lang.String>)
//  .jest(java.lang.Boolean)
//  .jestOptions(JestOptions)
//  .mutableBuild(java.lang.Boolean)
//  .npmignore(java.util.List<java.lang.String>)
//  .npmignoreEnabled(java.lang.Boolean)
//  .npmIgnoreOptions(IgnoreFileOptions)
//  .package(java.lang.Boolean)
//  .prettier(java.lang.Boolean)
//  .prettierOptions(PrettierOptions)
//  .projenDevDependency(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenVersion(java.lang.String)
//  .pullRequestTemplate(java.lang.Boolean)
//  .pullRequestTemplateContents(java.util.List<java.lang.String>)
//  .release(java.lang.Boolean)
//  .releaseToNpm(java.lang.Boolean)
//  .releaseWorkflow(java.lang.Boolean)
//  .workflowBootstrapSteps(java.util.List<JobStep>)
//  .workflowGitIdentity(GitIdentity)
//  .workflowNodeVersion(java.lang.String)
//  .disableTsconfig(java.lang.Boolean)
//  .disableTsconfigDev(java.lang.Boolean)
//  .docgen(java.lang.Boolean)
//  .docsDirectory(java.lang.String)
//  .entrypointTypes(java.lang.String)
//  .eslint(java.lang.Boolean)
//  .eslintOptions(EslintOptions)
//  .libdir(java.lang.String)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcOptions)
//  .sampleCode(java.lang.Boolean)
//  .srcdir(java.lang.String)
//  .testdir(java.lang.String)
//  .tsconfig(TypescriptConfigOptions)
//  .tsconfigDev(TypescriptConfigOptions)
//  .tsconfigDevFile(java.lang.String)
//  .typescriptVersion(java.lang.String)
//  .monorepoUpgradeDeps(java.lang.Boolean)
//  .monorepoUpgradeDepsOptions(MonorepoUpgradeDepsOptions)
//  .nxConfig(WorkspaceConfig)
//  .workspaceConfig(WorkspaceConfig)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>java.lang.Boolean</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorOrganization">authorOrganization</a></code> | <code>java.lang.Boolean</code> | Is the author an organization. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorUrl">authorUrl</a></code> | <code>java.lang.String</code> | Author's URL / Website. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoDetectBin">autoDetectBin</a></code> | <code>java.lang.Boolean</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bin">bin</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Binary programs vended with your module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bugsEmail">bugsEmail</a></code> | <code>java.lang.String</code> | The email address to which issues should be reported. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bugsUrl">bugsUrl</a></code> | <code>java.lang.String</code> | The url to your project's issue tracker. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bundledDeps">bundledDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dependencies to bundle into this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.codeArtifactOptions">codeArtifactOptions</a></code> | <code>io.github.cdklabs.projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | Runtime dependencies of this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.description">description</a></code> | <code>java.lang.String</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | Build dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.entrypoint">entrypoint</a></code> | <code>java.lang.String</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.homepage">homepage</a></code> | <code>java.lang.String</code> | Package's Homepage / Website. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.keywords">keywords</a></code> | <code>java.util.List<java.lang.String></code> | Keywords to include in `package.json`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.license">license</a></code> | <code>java.lang.String</code> | License's SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.licensed">licensed</a></code> | <code>java.lang.Boolean</code> | Indicates if a license should be added. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.maxNodeVersion">maxNodeVersion</a></code> | <code>java.lang.String</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.minNodeVersion">minNodeVersion</a></code> | <code>java.lang.String</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmAccess">npmAccess</a></code> | <code>io.github.cdklabs.projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmRegistry">npmRegistry</a></code> | <code>java.lang.String</code> | The host name of the npm registry to publish to. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmRegistryUrl">npmRegistryUrl</a></code> | <code>java.lang.String</code> | The base URL of the npm package registry. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmTokenSecret">npmTokenSecret</a></code> | <code>java.lang.String</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.packageManager">packageManager</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.packageName">packageName</a></code> | <code>java.lang.String</code> | The "name" in package.json. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.peerDependencyOptions">peerDependencyOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.peerDeps">peerDeps</a></code> | <code>java.util.List<java.lang.String></code> | Peer dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.pnpmVersion">pnpmVersion</a></code> | <code>java.lang.String</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.repository">repository</a></code> | <code>java.lang.String</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.repositoryDirectory">repositoryDirectory</a></code> | <code>java.lang.String</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.scopedPackagesOptions">scopedPackagesOptions</a></code> | <code>java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions></code> | Options for privately hosted scoped packages. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.scripts">scripts</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | npm scripts to include. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.stability">stability</a></code> | <code>java.lang.String</code> | Package's Stability. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.jsiiReleaseVersion">jsiiReleaseVersion</a></code> | <code>java.lang.String</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.majorVersion">majorVersion</a></code> | <code>java.lang.Number</code> | Major version to release from the default branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.minMajorVersion">minMajorVersion</a></code> | <code>java.lang.Number</code> | Minimal Major version to release. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmDistTag">npmDistTag</a></code> | <code>java.lang.String</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.postBuildSteps">postBuildSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.prerelease">prerelease</a></code> | <code>java.lang.String</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.publishDryRun">publishDryRun</a></code> | <code>java.lang.Boolean</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.publishTasks">publishTasks</a></code> | <code>java.lang.Boolean</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseBranches">releaseBranches</a></code> | <code>java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions></code> | Defines additional release branches. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseEveryCommit">releaseEveryCommit</a></code> | <code>java.lang.Boolean</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseFailureIssue">releaseFailureIssue</a></code> | <code>java.lang.Boolean</code> | Create a github issue on every failed publishing task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseFailureIssueLabel">releaseFailureIssueLabel</a></code> | <code>java.lang.String</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseSchedule">releaseSchedule</a></code> | <code>java.lang.String</code> | CRON schedule to trigger new releases. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseTagPrefix">releaseTagPrefix</a></code> | <code>java.lang.String</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseTrigger">releaseTrigger</a></code> | <code>io.github.cdklabs.projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflowName">releaseWorkflowName</a></code> | <code>java.lang.String</code> | The name of the default release workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflowSetupSteps">releaseWorkflowSetupSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.versionrcOptions">versionrcOptions</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowContainerImage">workflowContainerImage</a></code> | <code>java.lang.String</code> | Container image to use for GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowRunsOn">workflowRunsOn</a></code> | <code>java.util.List<java.lang.String></code> | Github Runner selection labels. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.defaultReleaseBranch">defaultReleaseBranch</a></code> | <code>java.lang.String</code> | The name of the main release branch. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.artifactsDirectory">artifactsDirectory</a></code> | <code>java.lang.String</code> | A directory which will contain build artifacts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoApproveUpgrades">autoApproveUpgrades</a></code> | <code>java.lang.Boolean</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.buildWorkflow">buildWorkflow</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.buildWorkflowTriggers">buildWorkflowTriggers</a></code> | <code>io.github.cdklabs.projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bundlerOptions">bundlerOptions</a></code> | <code>io.github.cdklabs.projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.codeCov">codeCov</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.codeCovTokenSecret">codeCovTokenSecret</a></code> | <code>java.lang.String</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.copyrightOwner">copyrightOwner</a></code> | <code>java.lang.String</code> | License copyright owner. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.copyrightPeriod">copyrightPeriod</a></code> | <code>java.lang.String</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.dependabot">dependabot</a></code> | <code>java.lang.Boolean</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.dependabotOptions">dependabotOptions</a></code> | <code>io.github.cdklabs.projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.depsUpgrade">depsUpgrade</a></code> | <code>java.lang.Boolean</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.depsUpgradeOptions">depsUpgradeOptions</a></code> | <code>io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitignore">gitignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .gitignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.jest">jest</a></code> | <code>java.lang.Boolean</code> | Setup jest unit tests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.jestOptions">jestOptions</a></code> | <code>io.github.cdklabs.projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.mutableBuild">mutableBuild</a></code> | <code>java.lang.Boolean</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmignore">npmignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .npmignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmignoreEnabled">npmignoreEnabled</a></code> | <code>java.lang.Boolean</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmIgnoreOptions">npmIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.package">package</a></code> | <code>java.lang.Boolean</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.prettier">prettier</a></code> | <code>java.lang.Boolean</code> | Setup prettier. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.prettierOptions">prettierOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenDevDependency">projenDevDependency</a></code> | <code>java.lang.Boolean</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenVersion">projenVersion</a></code> | <code>java.lang.String</code> | Version of projen to install. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.pullRequestTemplate">pullRequestTemplate</a></code> | <code>java.lang.Boolean</code> | Include a GitHub pull request template. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.pullRequestTemplateContents">pullRequestTemplateContents</a></code> | <code>java.util.List<java.lang.String></code> | The contents of the pull request template. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.release">release</a></code> | <code>java.lang.Boolean</code> | Add release management to this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseToNpm">releaseToNpm</a></code> | <code>java.lang.Boolean</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflow">releaseWorkflow</a></code> | <code>java.lang.Boolean</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowBootstrapSteps">workflowBootstrapSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowGitIdentity">workflowGitIdentity</a></code> | <code>io.github.cdklabs.projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowNodeVersion">workflowNodeVersion</a></code> | <code>java.lang.String</code> | The node version to use in GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.disableTsconfig">disableTsconfig</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.disableTsconfigDev">disableTsconfigDev</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.docgen">docgen</a></code> | <code>java.lang.Boolean</code> | Docgen by Typedoc. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.docsDirectory">docsDirectory</a></code> | <code>java.lang.String</code> | Docs directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.entrypointTypes">entrypointTypes</a></code> | <code>java.lang.String</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.eslint">eslint</a></code> | <code>java.lang.Boolean</code> | Setup eslint. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.eslintOptions">eslintOptions</a></code> | <code>io.github.cdklabs.projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.libdir">libdir</a></code> | <code>java.lang.String</code> | Typescript  artifacts output directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.sampleCode">sampleCode</a></code> | <code>java.lang.Boolean</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.srcdir">srcdir</a></code> | <code>java.lang.String</code> | Typescript sources directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.testdir">testdir</a></code> | <code>java.lang.String</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.tsconfig">tsconfig</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.tsconfigDev">tsconfigDev</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.tsconfigDevFile">tsconfigDevFile</a></code> | <code>java.lang.String</code> | The name of the development tsconfig.json file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.typescriptVersion">typescriptVersion</a></code> | <code>java.lang.String</code> | TypeScript version to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.monorepoUpgradeDeps">monorepoUpgradeDeps</a></code> | <code>java.lang.Boolean</code> | Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.monorepoUpgradeDepsOptions">monorepoUpgradeDepsOptions</a></code> | <code>software.aws.awsprototypingsdk.nxmonorepo.MonorepoUpgradeDepsOptions</code> | Monorepo Upgrade Deps options. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.nxConfig">nxConfig</a></code> | <code>software.aws.awsprototypingsdk.nxmonorepo.Nx.WorkspaceConfig</code> | Configuration for NX. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workspaceConfig">workspaceConfig</a></code> | <code>software.aws.awsprototypingsdk.nxmonorepo.WorkspaceConfig</code> | Configuration for workspace. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.name"></a>

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.commitGenerated"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitOptions"></a>

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.logging"></a>

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.outdir"></a>

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.parent"></a>

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenCommand"></a>

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJson"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.renovatebot"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoMerge"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.clobber"></a>

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.devContainer"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.github"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.githubOptions"></a>

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitpod"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenCredentials"></a>

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.readme"></a>

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.stale"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.staleOptions"></a>

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.vscode"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allowLibraryDependencies`<sup>Optional</sup> <a name="allowLibraryDependencies" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.allowLibraryDependencies"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `authorEmail`<sup>Optional</sup> <a name="authorEmail" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorEmail"></a>

- *Type:* java.lang.String

Author's e-mail.

---

##### `authorName`<sup>Optional</sup> <a name="authorName" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorName"></a>

- *Type:* java.lang.String

Author's name.

---

##### `authorOrganization`<sup>Optional</sup> <a name="authorOrganization" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorOrganization"></a>

- *Type:* java.lang.Boolean

Is the author an organization.

---

##### `authorUrl`<sup>Optional</sup> <a name="authorUrl" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.authorUrl"></a>

- *Type:* java.lang.String

Author's URL / Website.

---

##### `autoDetectBin`<sup>Optional</sup> <a name="autoDetectBin" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoDetectBin"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bin"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugsEmail`<sup>Optional</sup> <a name="bugsEmail" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bugsEmail"></a>

- *Type:* java.lang.String

The email address to which issues should be reported.

---

##### `bugsUrl`<sup>Optional</sup> <a name="bugsUrl" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bugsUrl"></a>

- *Type:* java.lang.String

The url to your project's issue tracker.

---

##### `bundledDeps`<sup>Optional</sup> <a name="bundledDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bundledDeps"></a>

- *Type:* java.util.List<java.lang.String>

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `codeArtifactOptions`<sup>Optional</sup> <a name="codeArtifactOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.codeArtifactOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.deps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.description"></a>

- *Type:* java.lang.String

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.devDeps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.entrypoint"></a>

- *Type:* java.lang.String
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.homepage"></a>

- *Type:* java.lang.String

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.keywords"></a>

- *Type:* java.util.List<java.lang.String>

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.license"></a>

- *Type:* java.lang.String
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.licensed"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Indicates if a license should be added.

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.maxNodeVersion"></a>

- *Type:* java.lang.String
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.minNodeVersion"></a>

- *Type:* java.lang.String
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npmAccess`<sup>Optional</sup> <a name="npmAccess" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmAccess"></a>

- *Type:* io.github.cdklabs.projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npmRegistry`~~<sup>Optional</sup> <a name="npmRegistry" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

- *Type:* java.lang.String

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npmRegistryUrl`<sup>Optional</sup> <a name="npmRegistryUrl" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmRegistryUrl"></a>

- *Type:* java.lang.String
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npmTokenSecret`<sup>Optional</sup> <a name="npmTokenSecret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmTokenSecret"></a>

- *Type:* java.lang.String
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `packageManager`<sup>Optional</sup> <a name="packageManager" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.packageManager"></a>

- *Type:* io.github.cdklabs.projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.packageName"></a>

- *Type:* java.lang.String
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peerDependencyOptions`<sup>Optional</sup> <a name="peerDependencyOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.peerDependencyOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peerDeps`<sup>Optional</sup> <a name="peerDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.peerDeps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpmVersion`<sup>Optional</sup> <a name="pnpmVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.pnpmVersion"></a>

- *Type:* java.lang.String
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.repository"></a>

- *Type:* java.lang.String

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repositoryDirectory`<sup>Optional</sup> <a name="repositoryDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.repositoryDirectory"></a>

- *Type:* java.lang.String

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scopedPackagesOptions`<sup>Optional</sup> <a name="scopedPackagesOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.scopedPackagesOptions"></a>

- *Type:* java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions>
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

- *Type:* java.util.Map<java.lang.String, java.lang.String>
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.stability"></a>

- *Type:* java.lang.String

Package's Stability.

---

##### `jsiiReleaseVersion`<sup>Optional</sup> <a name="jsiiReleaseVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.jsiiReleaseVersion"></a>

- *Type:* java.lang.String
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `majorVersion`<sup>Optional</sup> <a name="majorVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.majorVersion"></a>

- *Type:* java.lang.Number
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `minMajorVersion`<sup>Optional</sup> <a name="minMajorVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.minMajorVersion"></a>

- *Type:* java.lang.Number
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npmDistTag`<sup>Optional</sup> <a name="npmDistTag" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmDistTag"></a>

- *Type:* java.lang.String
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `postBuildSteps`<sup>Optional</sup> <a name="postBuildSteps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.postBuildSteps"></a>

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.prerelease"></a>

- *Type:* java.lang.String
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publishDryRun`<sup>Optional</sup> <a name="publishDryRun" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.publishDryRun"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publishTasks`<sup>Optional</sup> <a name="publishTasks" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.publishTasks"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `releaseBranches`<sup>Optional</sup> <a name="releaseBranches" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseBranches"></a>

- *Type:* java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions>
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`releaseEveryCommit`~~<sup>Optional</sup> <a name="releaseEveryCommit" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

- *Type:* java.lang.Boolean
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `releaseFailureIssue`<sup>Optional</sup> <a name="releaseFailureIssue" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseFailureIssue"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `releaseFailureIssueLabel`<sup>Optional</sup> <a name="releaseFailureIssueLabel" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseFailureIssueLabel"></a>

- *Type:* java.lang.String
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`releaseSchedule`~~<sup>Optional</sup> <a name="releaseSchedule" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

- *Type:* java.lang.String
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `releaseTagPrefix`<sup>Optional</sup> <a name="releaseTagPrefix" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseTagPrefix"></a>

- *Type:* java.lang.String
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `releaseTrigger`<sup>Optional</sup> <a name="releaseTrigger" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseTrigger"></a>

- *Type:* io.github.cdklabs.projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `releaseWorkflowName`<sup>Optional</sup> <a name="releaseWorkflowName" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflowName"></a>

- *Type:* java.lang.String
- *Default:* "Release"

The name of the default release workflow.

---

##### `releaseWorkflowSetupSteps`<sup>Optional</sup> <a name="releaseWorkflowSetupSteps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflowSetupSteps"></a>

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrcOptions`<sup>Optional</sup> <a name="versionrcOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.versionrcOptions"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflowContainerImage`<sup>Optional</sup> <a name="workflowContainerImage" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowContainerImage"></a>

- *Type:* java.lang.String
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflowRunsOn`<sup>Optional</sup> <a name="workflowRunsOn" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowRunsOn"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `defaultReleaseBranch`<sup>Required</sup> <a name="defaultReleaseBranch" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.defaultReleaseBranch"></a>

- *Type:* java.lang.String
- *Default:* "main"

The name of the main release branch.

---

##### `artifactsDirectory`<sup>Optional</sup> <a name="artifactsDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.artifactsDirectory"></a>

- *Type:* java.lang.String
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `autoApproveUpgrades`<sup>Optional</sup> <a name="autoApproveUpgrades" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.autoApproveUpgrades"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.buildWorkflow"></a>

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `buildWorkflowTriggers`<sup>Optional</sup> <a name="buildWorkflowTriggers" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.buildWorkflowTriggers"></a>

- *Type:* io.github.cdklabs.projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundlerOptions`<sup>Optional</sup> <a name="bundlerOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.bundlerOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `codeCov`<sup>Optional</sup> <a name="codeCov" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.codeCov"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret.

---

##### `codeCovTokenSecret`<sup>Optional</sup> <a name="codeCovTokenSecret" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.codeCovTokenSecret"></a>

- *Type:* java.lang.String
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyrightOwner`<sup>Optional</sup> <a name="copyrightOwner" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.copyrightOwner"></a>

- *Type:* java.lang.String
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyrightPeriod`<sup>Optional</sup> <a name="copyrightPeriod" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.copyrightPeriod"></a>

- *Type:* java.lang.String
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.dependabot"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabotOptions`<sup>Optional</sup> <a name="dependabotOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.dependabotOptions"></a>

- *Type:* io.github.cdklabs.projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `depsUpgrade`<sup>Optional</sup> <a name="depsUpgrade" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.depsUpgrade"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `depsUpgradeOptions`<sup>Optional</sup> <a name="depsUpgradeOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.depsUpgradeOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.gitignore"></a>

- *Type:* java.util.List<java.lang.String>

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.jest"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Setup jest unit tests.

---

##### `jestOptions`<sup>Optional</sup> <a name="jestOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.jestOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutableBuild`<sup>Optional</sup> <a name="mutableBuild" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.mutableBuild"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

- *Type:* java.util.List<java.lang.String>

Additional entries to .npmignore.

---

##### `npmignoreEnabled`<sup>Optional</sup> <a name="npmignoreEnabled" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmignoreEnabled"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npmIgnoreOptions`<sup>Optional</sup> <a name="npmIgnoreOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.npmIgnoreOptions"></a>

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.package"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.prettier"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Setup prettier.

---

##### `prettierOptions`<sup>Optional</sup> <a name="prettierOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.prettierOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projenDevDependency`<sup>Optional</sup> <a name="projenDevDependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenDevDependency"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJs"></a>

- *Type:* java.lang.Boolean
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projenVersion`<sup>Optional</sup> <a name="projenVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenVersion"></a>

- *Type:* java.lang.String
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pullRequestTemplate`<sup>Optional</sup> <a name="pullRequestTemplate" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.pullRequestTemplate"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include a GitHub pull request template.

---

##### `pullRequestTemplateContents`<sup>Optional</sup> <a name="pullRequestTemplateContents" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.pullRequestTemplateContents"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.release"></a>

- *Type:* java.lang.Boolean
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `releaseToNpm`<sup>Optional</sup> <a name="releaseToNpm" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseToNpm"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`releaseWorkflow`~~<sup>Optional</sup> <a name="releaseWorkflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.releaseWorkflow"></a>

- *Deprecated:* see `release`.

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflowBootstrapSteps`<sup>Optional</sup> <a name="workflowBootstrapSteps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowBootstrapSteps"></a>

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflowGitIdentity`<sup>Optional</sup> <a name="workflowGitIdentity" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowGitIdentity"></a>

- *Type:* io.github.cdklabs.projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflowNodeVersion`<sup>Optional</sup> <a name="workflowNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workflowNodeVersion"></a>

- *Type:* java.lang.String
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `disableTsconfig`<sup>Optional</sup> <a name="disableTsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.disableTsconfig"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disableTsconfigDev`<sup>Optional</sup> <a name="disableTsconfigDev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.disableTsconfigDev"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.docgen"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Docgen by Typedoc.

---

##### `docsDirectory`<sup>Optional</sup> <a name="docsDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.docsDirectory"></a>

- *Type:* java.lang.String
- *Default:* "docs"

Docs directory.

---

##### `entrypointTypes`<sup>Optional</sup> <a name="entrypointTypes" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.entrypointTypes"></a>

- *Type:* java.lang.String
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.eslint"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Setup eslint.

---

##### `eslintOptions`<sup>Optional</sup> <a name="eslintOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.eslintOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.libdir"></a>

- *Type:* java.lang.String
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcTs"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sampleCode`<sup>Optional</sup> <a name="sampleCode" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.sampleCode"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.srcdir"></a>

- *Type:* java.lang.String
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.testdir"></a>

- *Type:* java.lang.String
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.tsconfig"></a>

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfigDev`<sup>Optional</sup> <a name="tsconfigDev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.tsconfigDev"></a>

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfigDevFile`<sup>Optional</sup> <a name="tsconfigDevFile" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.tsconfigDevFile"></a>

- *Type:* java.lang.String
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescriptVersion`<sup>Optional</sup> <a name="typescriptVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.typescriptVersion"></a>

- *Type:* java.lang.String
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `monorepoUpgradeDeps`<sup>Optional</sup> <a name="monorepoUpgradeDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.monorepoUpgradeDeps"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Whether to include an upgrade-deps task at the root of the monorepo which will upgrade all dependencies.

---

##### `monorepoUpgradeDepsOptions`<sup>Optional</sup> <a name="monorepoUpgradeDepsOptions" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.monorepoUpgradeDepsOptions"></a>

- *Type:* software.aws.awsprototypingsdk.nxmonorepo.MonorepoUpgradeDepsOptions
- *Default:* undefined

Monorepo Upgrade Deps options.

This is only used if monorepoUpgradeDeps is true.

---

##### `nxConfig`<sup>Optional</sup> <a name="nxConfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.nxConfig"></a>

- *Type:* software.aws.awsprototypingsdk.nxmonorepo.Nx.WorkspaceConfig

Configuration for NX.

---

##### `workspaceConfig`<sup>Optional</sup> <a name="workspaceConfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.Initializer.parameter.workspaceConfig"></a>

- *Type:* software.aws.awsprototypingsdk.nxmonorepo.WorkspaceConfig

Configuration for workspace.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBins">addBins</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBundledDeps">addBundledDeps</a></code> | Defines bundled dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addCompileCommand">addCompileCommand</a></code> | DEPRECATED. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDeps">addDeps</a></code> | Defines normal dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDevDeps">addDevDeps</a></code> | Defines development/test dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addFields">addFields</a></code> | Directly set fields in `package.json`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addKeywords">addKeywords</a></code> | Adds keywords to package.json (deduplicated). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPeerDeps">addPeerDeps</a></code> | Defines peer dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addScripts">addScripts</a></code> | Replaces the contents of multiple npm package.json scripts. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTestCommand">addTestCommand</a></code> | DEPRECATED. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.hasScript">hasScript</a></code> | Indicates if a script by the name name is defined. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeScript">removeScript</a></code> | Removes the npm script (always successful). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.renderWorkflowSetup">renderWorkflowSetup</a></code> | Returns the set of workflow steps which should be executed to bootstrap a workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.setScript">setScript</a></code> | Replaces the contents of an npm package.json script. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addImplicitDependency">addImplicitDependency</a></code> | Create an implicit dependency between two Projects. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addJavaDependency">addJavaDependency</a></code> | Adds a dependency between two Java Projects in the monorepo. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask">addNxRunManyTask</a></code> | Add project task that executes `npx nx run-many ...` style command. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPythonPoetryDependency">addPythonPoetryDependency</a></code> | Adds a dependency between two Python Projects in the monorepo. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addWorkspacePackages">addWorkspacePackages</a></code> | Add one or more additional package globs to the workspace. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand">formatNxRunManyCommand</a></code> | Helper to format `npx nx run-many ...` style command. |

---

##### `addExcludeFromCleanup` <a name="addExcludeFromCleanup" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addExcludeFromCleanup"></a>

```java
public void addExcludeFromCleanup(java.lang.String globs)
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* java.lang.String

The glob patterns to match.

---

##### `addGitIgnore` <a name="addGitIgnore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addGitIgnore"></a>

```java
public void addGitIgnore(java.lang.String pattern)
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addGitIgnore.parameter.pattern"></a>

- *Type:* java.lang.String

The glob pattern to ignore.

---

##### `addPackageIgnore` <a name="addPackageIgnore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPackageIgnore"></a>

```java
public void addPackageIgnore(java.lang.String pattern)
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPackageIgnore.parameter.pattern"></a>

- *Type:* java.lang.String

---

##### `addTask` <a name="addTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask"></a>

```java
public Task addTask(java.lang.String name)
public Task addTask(java.lang.String name, TaskOptions props)
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.name"></a>

- *Type:* java.lang.String

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTask.parameter.props"></a>

- *Type:* io.github.cdklabs.projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTip"></a>

```java
public void addTip(java.lang.String message)
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTip.parameter.message"></a>

- *Type:* java.lang.String

The message.

---

##### `annotateGenerated` <a name="annotateGenerated" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.annotateGenerated"></a>

```java
public void annotateGenerated(java.lang.String glob)
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.annotateGenerated.parameter.glob"></a>

- *Type:* java.lang.String

the glob pattern to match (could be a file path).

---

##### `postSynthesize` <a name="postSynthesize" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.postSynthesize"></a>

```java
public void postSynthesize()
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `preSynthesize` <a name="preSynthesize" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.preSynthesize"></a>

```java
public void preSynthesize()
```

Called before all components are synthesized.

##### `removeTask` <a name="removeTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeTask"></a>

```java
public Task removeTask(java.lang.String name)
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeTask.parameter.name"></a>

- *Type:* java.lang.String

The name of the task to remove.

---

##### `runTaskCommand` <a name="runTaskCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.runTaskCommand"></a>

```java
public java.lang.String runTaskCommand(Task task)
```

Returns the shell command to execute in order to run a task.

This will
typically be `npx projen TASK`.

###### `task`<sup>Required</sup> <a name="task" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.runTaskCommand.parameter.task"></a>

- *Type:* io.github.cdklabs.projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.synth"></a>

```java
public void synth()
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `tryFindFile` <a name="tryFindFile" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindFile"></a>

```java
public FileBase tryFindFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindJsonFile"></a>

```java
public JsonFile tryFindJsonFile(java.lang.String filePath)
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### `tryFindObjectFile` <a name="tryFindObjectFile" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindObjectFile"></a>

```java
public ObjectFile tryFindObjectFile(java.lang.String filePath)
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### `tryRemoveFile` <a name="tryRemoveFile" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryRemoveFile"></a>

```java
public FileBase tryRemoveFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `addBins` <a name="addBins" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBins"></a>

```java
public void addBins(java.util.Map<java.lang.String, java.lang.String> bins)
```

###### `bins`<sup>Required</sup> <a name="bins" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBins.parameter.bins"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### `addBundledDeps` <a name="addBundledDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBundledDeps"></a>

```java
public void addBundledDeps(java.lang.String deps)
```

Defines bundled dependencies.

Bundled dependencies will be added as normal dependencies as well as to the
`bundledDependencies` section of your `package.json`.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addBundledDeps.parameter.deps"></a>

- *Type:* java.lang.String

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addCompileCommand`~~ <a name="addCompileCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addCompileCommand"></a>

```java
public void addCompileCommand(java.lang.String commands)
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addCompileCommand.parameter.commands"></a>

- *Type:* java.lang.String

---

##### `addDeps` <a name="addDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDeps"></a>

```java
public void addDeps(java.lang.String deps)
```

Defines normal dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDeps.parameter.deps"></a>

- *Type:* java.lang.String

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `addDevDeps` <a name="addDevDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDevDeps"></a>

```java
public void addDevDeps(java.lang.String deps)
```

Defines development/test dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addDevDeps.parameter.deps"></a>

- *Type:* java.lang.String

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `addFields` <a name="addFields" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addFields"></a>

```java
public void addFields(java.util.Map<java.lang.String, java.lang.Object> fields)
```

Directly set fields in `package.json`.

###### `fields`<sup>Required</sup> <a name="fields" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addFields.parameter.fields"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>

The fields to set.

---

##### `addKeywords` <a name="addKeywords" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addKeywords"></a>

```java
public void addKeywords(java.lang.String keywords)
```

Adds keywords to package.json (deduplicated).

###### `keywords`<sup>Required</sup> <a name="keywords" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addKeywords.parameter.keywords"></a>

- *Type:* java.lang.String

The keywords to add.

---

##### `addPeerDeps` <a name="addPeerDeps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPeerDeps"></a>

```java
public void addPeerDeps(java.lang.String deps)
```

Defines peer dependencies.

When adding peer dependencies, a devDependency will also be added on the
pinned version of the declared peer. This will ensure that you are testing
your code against the minimum version required from your consumers.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPeerDeps.parameter.deps"></a>

- *Type:* java.lang.String

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `addScripts` <a name="addScripts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addScripts"></a>

```java
public void addScripts(java.util.Map<java.lang.String, java.lang.String> scripts)
```

Replaces the contents of multiple npm package.json scripts.

###### `scripts`<sup>Required</sup> <a name="scripts" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addScripts.parameter.scripts"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The scripts to set.

---

##### ~~`addTestCommand`~~ <a name="addTestCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTestCommand"></a>

```java
public void addTestCommand(java.lang.String commands)
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addTestCommand.parameter.commands"></a>

- *Type:* java.lang.String

---

##### ~~`hasScript`~~ <a name="hasScript" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.hasScript"></a>

```java
public java.lang.Boolean hasScript(java.lang.String name)
```

Indicates if a script by the name name is defined.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.hasScript.parameter.name"></a>

- *Type:* java.lang.String

The name of the script.

---

##### `removeScript` <a name="removeScript" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeScript"></a>

```java
public void removeScript(java.lang.String name)
```

Removes the npm script (always successful).

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.removeScript.parameter.name"></a>

- *Type:* java.lang.String

The name of the script.

---

##### `renderWorkflowSetup` <a name="renderWorkflowSetup" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.renderWorkflowSetup"></a>

```java
public java.util.List<JobStep> renderWorkflowSetup()
public java.util.List<JobStep> renderWorkflowSetup(RenderWorkflowSetupOptions options)
```

Returns the set of workflow steps which should be executed to bootstrap a workflow.

###### `options`<sup>Optional</sup> <a name="options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.renderWorkflowSetup.parameter.options"></a>

- *Type:* io.github.cdklabs.projen.javascript.RenderWorkflowSetupOptions

Options.

---

##### `setScript` <a name="setScript" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.setScript"></a>

```java
public void setScript(java.lang.String name, java.lang.String command)
```

Replaces the contents of an npm package.json script.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.setScript.parameter.name"></a>

- *Type:* java.lang.String

The script name.

---

###### `command`<sup>Required</sup> <a name="command" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.setScript.parameter.command"></a>

- *Type:* java.lang.String

The command to execute.

---

##### `addImplicitDependency` <a name="addImplicitDependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addImplicitDependency"></a>

```java
public void addImplicitDependency(Project dependent, java.lang.String OR Project dependee)
```

Create an implicit dependency between two Projects.

This is typically
used in polygot repos where a Typescript project wants a build dependency
on a Python project as an example.

###### `dependent`<sup>Required</sup> <a name="dependent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addImplicitDependency.parameter.dependent"></a>

- *Type:* io.github.cdklabs.projen.Project

project you want to have the dependency.

---

###### `dependee`<sup>Required</sup> <a name="dependee" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addImplicitDependency.parameter.dependee"></a>

- *Type:* java.lang.String OR io.github.cdklabs.projen.Project

project you wish to depend on.

---

##### `addJavaDependency` <a name="addJavaDependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addJavaDependency"></a>

```java
public void addJavaDependency(JavaProject dependent, JavaProject dependee)
```

Adds a dependency between two Java Projects in the monorepo.

###### `dependent`<sup>Required</sup> <a name="dependent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addJavaDependency.parameter.dependent"></a>

- *Type:* io.github.cdklabs.projen.java.JavaProject

project you want to have the dependency.

---

###### `dependee`<sup>Required</sup> <a name="dependee" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addJavaDependency.parameter.dependee"></a>

- *Type:* io.github.cdklabs.projen.java.JavaProject

project you wish to depend on.

---

##### `addNxRunManyTask` <a name="addNxRunManyTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask"></a>

```java
public Task addNxRunManyTask(java.lang.String name, NxRunManyOptions options)
```

Add project task that executes `npx nx run-many ...` style command.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.name"></a>

- *Type:* java.lang.String

---

###### `options`<sup>Required</sup> <a name="options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addNxRunManyTask.parameter.options"></a>

- *Type:* software.aws.awsprototypingsdk.nxmonorepo.NxRunManyOptions

---

##### `addPythonPoetryDependency` <a name="addPythonPoetryDependency" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPythonPoetryDependency"></a>

```java
public void addPythonPoetryDependency(PythonProject dependent, PythonProject dependee)
```

Adds a dependency between two Python Projects in the monorepo.

The dependent must have Poetry enabled.

###### `dependent`<sup>Required</sup> <a name="dependent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPythonPoetryDependency.parameter.dependent"></a>

- *Type:* io.github.cdklabs.projen.python.PythonProject

project you want to have the dependency (must be a Poetry Python Project).

---

###### `dependee`<sup>Required</sup> <a name="dependee" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addPythonPoetryDependency.parameter.dependee"></a>

- *Type:* io.github.cdklabs.projen.python.PythonProject

project you wish to depend on.

---

##### `addWorkspacePackages` <a name="addWorkspacePackages" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addWorkspacePackages"></a>

```java
public void addWorkspacePackages(java.lang.String packageGlobs)
```

Add one or more additional package globs to the workspace.

###### `packageGlobs`<sup>Required</sup> <a name="packageGlobs" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.addWorkspacePackages.parameter.packageGlobs"></a>

- *Type:* java.lang.String

paths to the package to include in the workspace (for example packages/my-package).

---

##### `formatNxRunManyCommand` <a name="formatNxRunManyCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand"></a>

```java
public java.lang.String formatNxRunManyCommand(NxRunManyOptions options)
```

Helper to format `npx nx run-many ...` style command.

###### `options`<sup>Required</sup> <a name="options" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.formatNxRunManyCommand.parameter.options"></a>

- *Type:* software.aws.awsprototypingsdk.nxmonorepo.NxRunManyOptions

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildTask">buildTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.compileTask">compileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.components">components</a></code> | <code>java.util.List<io.github.cdklabs.projen.Component></code> | Returns all the components within this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.deps">deps</a></code> | <code>io.github.cdklabs.projen.Dependencies</code> | Project dependencies. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.ejected">ejected</a></code> | <code>java.lang.Boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.files">files</a></code> | <code>java.util.List<io.github.cdklabs.projen.FileBase></code> | All files in this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitattributes">gitattributes</a></code> | <code>io.github.cdklabs.projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitignore">gitignore</a></code> | <code>io.github.cdklabs.projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.logger">logger</a></code> | <code>io.github.cdklabs.projen.Logger</code> | Logging utilities. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.name">name</a></code> | <code>java.lang.String</code> | Project name. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.outdir">outdir</a></code> | <code>java.lang.String</code> | Absolute output directory of this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.packageTask">packageTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.postCompileTask">postCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.preCompileTask">preCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projectBuild">projectBuild</a></code> | <code>io.github.cdklabs.projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.root">root</a></code> | <code>io.github.cdklabs.projen.Project</code> | The root project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tasks">tasks</a></code> | <code>io.github.cdklabs.projen.Tasks</code> | Project tasks. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.testTask">testTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.defaultTask">defaultTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.initProject">initProject</a></code> | <code>io.github.cdklabs.projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | A parent project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.autoApprove">autoApprove</a></code> | <code>io.github.cdklabs.projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.devContainer">devContainer</a></code> | <code>io.github.cdklabs.projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.github">github</a></code> | <code>io.github.cdklabs.projen.github.GitHub</code> | Access all github components. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitpod">gitpod</a></code> | <code>io.github.cdklabs.projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.vscode">vscode</a></code> | <code>io.github.cdklabs.projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>java.lang.Boolean</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.artifactsDirectory">artifactsDirectory</a></code> | <code>java.lang.String</code> | The build output directory. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.artifactsJavascriptDirectory">artifactsJavascriptDirectory</a></code> | <code>java.lang.String</code> | The location of the npm tarball after build (`${artifactsDirectory}/js`). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.bundler">bundler</a></code> | <code>io.github.cdklabs.projen.javascript.Bundler</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.entrypoint">entrypoint</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.manifest">manifest</a></code> | <code>java.lang.Object</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.npmrc">npmrc</a></code> | <code>io.github.cdklabs.projen.javascript.NpmConfig</code> | The .npmrc file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.package">package</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackage</code> | API for managing the node package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.packageManager">packageManager</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackageManager</code> | The package manager to use. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.runScriptCommand">runScriptCommand</a></code> | <code>java.lang.String</code> | The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.autoMerge">autoMerge</a></code> | <code>io.github.cdklabs.projen.github.AutoMerge</code> | Component that sets up mergify for merging approved pull requests. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildWorkflow">buildWorkflow</a></code> | <code>io.github.cdklabs.projen.build.BuildWorkflow</code> | The PR build GitHub workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildWorkflowJobId">buildWorkflowJobId</a></code> | <code>java.lang.String</code> | The job ID of the build workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.jest">jest</a></code> | <code>io.github.cdklabs.projen.javascript.Jest</code> | The Jest configuration (if enabled). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.maxNodeVersion">maxNodeVersion</a></code> | <code>java.lang.String</code> | Maximum node version required by this package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.minNodeVersion">minNodeVersion</a></code> | <code>java.lang.String</code> | Minimum node.js version required by this package. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.npmignore">npmignore</a></code> | <code>io.github.cdklabs.projen.IgnoreFile</code> | The .npmignore file. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.prettier">prettier</a></code> | <code>io.github.cdklabs.projen.javascript.Prettier</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.publisher">publisher</a></code> | <code>io.github.cdklabs.projen.release.Publisher</code> | Package publisher. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.release">release</a></code> | <code>io.github.cdklabs.projen.release.Release</code> | Release management. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.upgradeWorkflow">upgradeWorkflow</a></code> | <code>io.github.cdklabs.projen.javascript.UpgradeDependencies</code> | The upgrade workflow. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.docsDirectory">docsDirectory</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.libdir">libdir</a></code> | <code>java.lang.String</code> | The directory in which compiled .js files reside. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.srcdir">srcdir</a></code> | <code>java.lang.String</code> | The directory in which the .ts sources reside. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.testdir">testdir</a></code> | <code>java.lang.String</code> | The directory in which tests reside. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfigDev">tsconfigDev</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfig</code> | A typescript configuration file which covers all files (sources, tests, projen). |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.watchTask">watchTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | The "watch" task. |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.docgen">docgen</a></code> | <code>java.lang.Boolean</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.eslint">eslint</a></code> | <code>io.github.cdklabs.projen.javascript.Eslint</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfig">tsconfig</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfigEslint">tsconfigEslint</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.nxJson">nxJson</a></code> | <code>io.github.cdklabs.projen.JsonFile</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.subProjects">subProjects</a></code> | <code>java.util.List<io.github.cdklabs.projen.Project></code> | *No description.* |

---

##### `buildTask`<sup>Required</sup> <a name="buildTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildTask"></a>

```java
public Task getBuildTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `commitGenerated`<sup>Required</sup> <a name="commitGenerated" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean

Whether to commit the managed files by default.

---

##### `compileTask`<sup>Required</sup> <a name="compileTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.compileTask"></a>

```java
public Task getCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.components"></a>

```java
public java.util.List<Component> getComponents();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Component>

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.deps"></a>

```java
public Dependencies getDeps();
```

- *Type:* io.github.cdklabs.projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.ejected"></a>

```java
public java.lang.Boolean getEjected();
```

- *Type:* java.lang.Boolean

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.files"></a>

```java
public java.util.List<FileBase> getFiles();
```

- *Type:* java.util.List<io.github.cdklabs.projen.FileBase>

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitattributes"></a>

```java
public GitAttributesFile getGitattributes();
```

- *Type:* io.github.cdklabs.projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitignore"></a>

```java
public IgnoreFile getGitignore();
```

- *Type:* io.github.cdklabs.projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.logger"></a>

```java
public Logger getLogger();
```

- *Type:* io.github.cdklabs.projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String

Absolute output directory of this project.

---

##### `packageTask`<sup>Required</sup> <a name="packageTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.packageTask"></a>

```java
public Task getPackageTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `postCompileTask`<sup>Required</sup> <a name="postCompileTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.postCompileTask"></a>

```java
public Task getPostCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `preCompileTask`<sup>Required</sup> <a name="preCompileTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.preCompileTask"></a>

```java
public Task getPreCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `projectBuild`<sup>Required</sup> <a name="projectBuild" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projectBuild"></a>

```java
public ProjectBuild getProjectBuild();
```

- *Type:* io.github.cdklabs.projen.ProjectBuild

Manages the build process of the project.

---

##### `projenCommand`<sup>Required</sup> <a name="projenCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.root"></a>

```java
public Project getRoot();
```

- *Type:* io.github.cdklabs.projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tasks"></a>

```java
public Tasks getTasks();
```

- *Type:* io.github.cdklabs.projen.Tasks

Project tasks.

---

##### `testTask`<sup>Required</sup> <a name="testTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.testTask"></a>

```java
public Task getTestTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `defaultTask`<sup>Optional</sup> <a name="defaultTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.defaultTask"></a>

```java
public Task getDefaultTask();
```

- *Type:* io.github.cdklabs.projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `initProject`<sup>Optional</sup> <a name="initProject" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.initProject"></a>

```java
public InitProject getInitProject();
```

- *Type:* io.github.cdklabs.projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

A parent project.

If undefined, this is the root project.

---

##### `projectType`<sup>Required</sup> <a name="projectType" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.projectType"></a>

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType

---

##### `autoApprove`<sup>Optional</sup> <a name="autoApprove" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.autoApprove"></a>

```java
public AutoApprove getAutoApprove();
```

- *Type:* io.github.cdklabs.projen.github.AutoApprove

Auto approve set up for this project.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.devContainer"></a>

```java
public DevContainer getDevContainer();
```

- *Type:* io.github.cdklabs.projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.github"></a>

```java
public GitHub getGithub();
```

- *Type:* io.github.cdklabs.projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.gitpod"></a>

```java
public Gitpod getGitpod();
```

- *Type:* io.github.cdklabs.projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.vscode"></a>

```java
public VsCode getVscode();
```

- *Type:* io.github.cdklabs.projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`allowLibraryDependencies`~~<sup>Required</sup> <a name="allowLibraryDependencies" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.allowLibraryDependencies"></a>

- *Deprecated:* use `package.allowLibraryDependencies`

```java
public java.lang.Boolean getAllowLibraryDependencies();
```

- *Type:* java.lang.Boolean

---

##### `artifactsDirectory`<sup>Required</sup> <a name="artifactsDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.artifactsDirectory"></a>

```java
public java.lang.String getArtifactsDirectory();
```

- *Type:* java.lang.String

The build output directory.

An npm tarball will be created under the `js`
subdirectory. For example, if this is set to `dist` (the default), the npm
tarball will be placed under `dist/js/boom-boom-1.2.3.tg`.

---

##### `artifactsJavascriptDirectory`<sup>Required</sup> <a name="artifactsJavascriptDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.artifactsJavascriptDirectory"></a>

```java
public java.lang.String getArtifactsJavascriptDirectory();
```

- *Type:* java.lang.String

The location of the npm tarball after build (`${artifactsDirectory}/js`).

---

##### `bundler`<sup>Required</sup> <a name="bundler" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.bundler"></a>

```java
public Bundler getBundler();
```

- *Type:* io.github.cdklabs.projen.javascript.Bundler

---

##### ~~`entrypoint`~~<sup>Required</sup> <a name="entrypoint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.entrypoint"></a>

- *Deprecated:* use `package.entrypoint`

```java
public java.lang.String getEntrypoint();
```

- *Type:* java.lang.String

---

##### ~~`manifest`~~<sup>Required</sup> <a name="manifest" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.manifest"></a>

- *Deprecated:* use `package.addField(x, y)`

```java
public java.lang.Object getManifest();
```

- *Type:* java.lang.Object

---

##### `npmrc`<sup>Required</sup> <a name="npmrc" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.npmrc"></a>

```java
public NpmConfig getNpmrc();
```

- *Type:* io.github.cdklabs.projen.javascript.NpmConfig

The .npmrc file.

---

##### `package`<sup>Required</sup> <a name="package" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.package"></a>

```java
public NodePackage getPackage();
```

- *Type:* io.github.cdklabs.projen.javascript.NodePackage

API for managing the node package.

---

##### ~~`packageManager`~~<sup>Required</sup> <a name="packageManager" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.packageManager"></a>

- *Deprecated:* use `package.packageManager`

```java
public NodePackageManager getPackageManager();
```

- *Type:* io.github.cdklabs.projen.javascript.NodePackageManager

The package manager to use.

---

##### `runScriptCommand`<sup>Required</sup> <a name="runScriptCommand" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.runScriptCommand"></a>

```java
public java.lang.String getRunScriptCommand();
```

- *Type:* java.lang.String

The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager).

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.autoMerge"></a>

```java
public AutoMerge getAutoMerge();
```

- *Type:* io.github.cdklabs.projen.github.AutoMerge

Component that sets up mergify for merging approved pull requests.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildWorkflow"></a>

```java
public BuildWorkflow getBuildWorkflow();
```

- *Type:* io.github.cdklabs.projen.build.BuildWorkflow

The PR build GitHub workflow.

`undefined` if `buildWorkflow` is disabled.

---

##### `buildWorkflowJobId`<sup>Optional</sup> <a name="buildWorkflowJobId" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.buildWorkflowJobId"></a>

```java
public java.lang.String getBuildWorkflowJobId();
```

- *Type:* java.lang.String

The job ID of the build workflow.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.jest"></a>

```java
public Jest getJest();
```

- *Type:* io.github.cdklabs.projen.javascript.Jest

The Jest configuration (if enabled).

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.maxNodeVersion"></a>

```java
public java.lang.String getMaxNodeVersion();
```

- *Type:* java.lang.String

Maximum node version required by this package.

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.minNodeVersion"></a>

```java
public java.lang.String getMinNodeVersion();
```

- *Type:* java.lang.String

Minimum node.js version required by this package.

---

##### `npmignore`<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.npmignore"></a>

```java
public IgnoreFile getNpmignore();
```

- *Type:* io.github.cdklabs.projen.IgnoreFile

The .npmignore file.

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.prettier"></a>

```java
public Prettier getPrettier();
```

- *Type:* io.github.cdklabs.projen.javascript.Prettier

---

##### ~~`publisher`~~<sup>Optional</sup> <a name="publisher" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.publisher"></a>

- *Deprecated:* use `release.publisher`.

```java
public Publisher getPublisher();
```

- *Type:* io.github.cdklabs.projen.release.Publisher

Package publisher.

This will be `undefined` if the project does not have a
release workflow.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.release"></a>

```java
public Release getRelease();
```

- *Type:* io.github.cdklabs.projen.release.Release

Release management.

---

##### `upgradeWorkflow`<sup>Optional</sup> <a name="upgradeWorkflow" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.upgradeWorkflow"></a>

```java
public UpgradeDependencies getUpgradeWorkflow();
```

- *Type:* io.github.cdklabs.projen.javascript.UpgradeDependencies

The upgrade workflow.

---

##### `docsDirectory`<sup>Required</sup> <a name="docsDirectory" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.docsDirectory"></a>

```java
public java.lang.String getDocsDirectory();
```

- *Type:* java.lang.String

---

##### `libdir`<sup>Required</sup> <a name="libdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.libdir"></a>

```java
public java.lang.String getLibdir();
```

- *Type:* java.lang.String

The directory in which compiled .js files reside.

---

##### `srcdir`<sup>Required</sup> <a name="srcdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.srcdir"></a>

```java
public java.lang.String getSrcdir();
```

- *Type:* java.lang.String

The directory in which the .ts sources reside.

---

##### `testdir`<sup>Required</sup> <a name="testdir" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.testdir"></a>

```java
public java.lang.String getTestdir();
```

- *Type:* java.lang.String

The directory in which tests reside.

---

##### `tsconfigDev`<sup>Required</sup> <a name="tsconfigDev" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfigDev"></a>

```java
public TypescriptConfig getTsconfigDev();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfig

A typescript configuration file which covers all files (sources, tests, projen).

---

##### `watchTask`<sup>Required</sup> <a name="watchTask" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.watchTask"></a>

```java
public Task getWatchTask();
```

- *Type:* io.github.cdklabs.projen.Task

The "watch" task.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.docgen"></a>

```java
public java.lang.Boolean getDocgen();
```

- *Type:* java.lang.Boolean

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.eslint"></a>

```java
public Eslint getEslint();
```

- *Type:* io.github.cdklabs.projen.javascript.Eslint

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfig"></a>

```java
public TypescriptConfig getTsconfig();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfig

---

##### `tsconfigEslint`<sup>Optional</sup> <a name="tsconfigEslint" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.tsconfigEslint"></a>

```java
public TypescriptConfig getTsconfigEslint();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfig

---

##### `nxJson`<sup>Required</sup> <a name="nxJson" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.nxJson"></a>

```java
public JsonFile getNxJson();
```

- *Type:* io.github.cdklabs.projen.JsonFile

---

##### `subProjects`<sup>Required</sup> <a name="subProjects" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.subProjects"></a>

```java
public java.util.List<Project> getSubProjects();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Project>

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>java.lang.String</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="aws-prototyping-sdk.nx_monorepo.NxMonorepoProject.property.DEFAULT_TASK"></a>

```java
public java.lang.String getDefaultTask();
```

- *Type:* java.lang.String

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### PDKNag <a name="PDKNag" id="aws-prototyping-sdk.pdk_nag.PDKNag"></a>

Helper for create a Nag Enabled App.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pdk_nag.PDKNag.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

new PDKNag();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow">addResourceSuppressionsByPathNoThrow</a></code> | Wrapper around NagSuppressions which does not throw. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.app">app</a></code> | Returns an instance of an App with Nag enabled. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.getStackAccountRegex">getStackAccountRegex</a></code> | Returns a stack account regex. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.getStackPartitionRegex">getStackPartitionRegex</a></code> | Returns a stack partition regex. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.getStackPrefix">getStackPrefix</a></code> | Returns a prefix comprising of a delimited set of Stack Ids. |
| <code><a href="#aws-prototyping-sdk.pdk_nag.PDKNag.getStackRegionRegex">getStackRegionRegex</a></code> | Returns a stack region regex. |

---

##### `addResourceSuppressionsByPathNoThrow` <a name="addResourceSuppressionsByPathNoThrow" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

PDKNag.addResourceSuppressionsByPathNoThrow(Stack stack, java.lang.String path, java.util.List<NagPackSuppression> suppressions),PDKNag.addResourceSuppressionsByPathNoThrow(Stack stack, java.lang.String path, java.util.List<NagPackSuppression> suppressions, java.lang.Boolean applyToChildren)
```

Wrapper around NagSuppressions which does not throw.

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.stack"></a>

- *Type:* software.amazon.awscdk.Stack

stack instance.

---

###### `path`<sup>Required</sup> <a name="path" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.path"></a>

- *Type:* java.lang.String

resource path.

---

###### `suppressions`<sup>Required</sup> <a name="suppressions" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.suppressions"></a>

- *Type:* java.util.List<io.github.cdklabs.cdknag.NagPackSuppression>

list of suppressions to apply.

---

###### `applyToChildren`<sup>Optional</sup> <a name="applyToChildren" id="aws-prototyping-sdk.pdk_nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.applyToChildren"></a>

- *Type:* java.lang.Boolean

whether to apply to children.

---

##### `app` <a name="app" id="aws-prototyping-sdk.pdk_nag.PDKNag.app"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

PDKNag.app(),PDKNag.app(PDKNagAppProps props)
```

Returns an instance of an App with Nag enabled.

###### `props`<sup>Optional</sup> <a name="props" id="aws-prototyping-sdk.pdk_nag.PDKNag.app.parameter.props"></a>

- *Type:* software.aws.awsprototypingsdk.pdknag.PDKNagAppProps

props to initialize the app with.

---

##### `getStackAccountRegex` <a name="getStackAccountRegex" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackAccountRegex"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

PDKNag.getStackAccountRegex(Stack stack)
```

Returns a stack account regex.

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackAccountRegex.parameter.stack"></a>

- *Type:* software.amazon.awscdk.Stack

stack instance.

---

##### `getStackPartitionRegex` <a name="getStackPartitionRegex" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackPartitionRegex"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

PDKNag.getStackPartitionRegex(Stack stack)
```

Returns a stack partition regex.

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackPartitionRegex.parameter.stack"></a>

- *Type:* software.amazon.awscdk.Stack

stack instance.

---

##### `getStackPrefix` <a name="getStackPrefix" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackPrefix"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

PDKNag.getStackPrefix(Stack stack)
```

Returns a prefix comprising of a delimited set of Stack Ids.

For example: StackA/NestedStackB/

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackPrefix.parameter.stack"></a>

- *Type:* software.amazon.awscdk.Stack

stack instance.

---

##### `getStackRegionRegex` <a name="getStackRegionRegex" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackRegionRegex"></a>

```java
import software.aws.awsprototypingsdk.pdknag.PDKNag;

PDKNag.getStackRegionRegex(Stack stack)
```

Returns a stack region regex.

###### `stack`<sup>Required</sup> <a name="stack" id="aws-prototyping-sdk.pdk_nag.PDKNag.getStackRegionRegex.parameter.stack"></a>

- *Type:* software.amazon.awscdk.Stack

stack instance.

---



### PDKPipelineJavaProject <a name="PDKPipelineJavaProject" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject"></a>

Synthesizes a Java Project with a CI/CD pipeline.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pipeline.PDKPipelineJavaProject;

PDKPipelineJavaProject.Builder.create()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
    .artifactId(java.lang.String)
    .groupId(java.lang.String)
    .version(java.lang.String)
//  .description(java.lang.String)
//  .packaging(java.lang.String)
//  .url(java.lang.String)
//  .compileOptions(MavenCompileOptions)
//  .deps(java.util.List<java.lang.String>)
//  .distdir(java.lang.String)
//  .junit(java.lang.Boolean)
//  .junitOptions(JunitOptions)
//  .packagingOptions(MavenPackagingOptions)
//  .projenrcJava(java.lang.Boolean)
//  .projenrcJavaOptions(ProjenrcOptions)
//  .testDeps(java.util.List<java.lang.String>)
//  .sample(java.lang.Boolean)
//  .sampleJavaPackage(java.lang.String)
//  .buildCommand(java.lang.String)
//  .cdkout(java.lang.String)
//  .context(java.util.Map<java.lang.String, java.lang.Object>)
//  .featureFlags(java.lang.Boolean)
//  .requireApproval(ApprovalLevel)
//  .watchExcludes(java.util.List<java.lang.String>)
//  .watchIncludes(java.util.List<java.lang.String>)
    .cdkVersion(java.lang.String)
//  .cdkAssert(java.lang.Boolean)
//  .cdkAssertions(java.lang.Boolean)
//  .cdkDependencies(java.util.List<java.lang.String>)
//  .cdkDependenciesAsDeps(java.lang.Boolean)
//  .cdkTestDependencies(java.util.List<java.lang.String>)
//  .cdkVersionPinning(java.lang.Boolean)
//  .constructsVersion(java.lang.String)
    .mainClass(java.lang.String)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.artifactId">artifactId</a></code> | <code>java.lang.String</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.groupId">groupId</a></code> | <code>java.lang.String</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.version">version</a></code> | <code>java.lang.String</code> | This is the last piece of the naming puzzle. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.description">description</a></code> | <code>java.lang.String</code> | Description of a project is always good. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.packaging">packaging</a></code> | <code>java.lang.String</code> | Project packaging format. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.url">url</a></code> | <code>java.lang.String</code> | The URL, like the name, is not required. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.compileOptions">compileOptions</a></code> | <code>io.github.cdklabs.projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | List of runtime dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.distdir">distdir</a></code> | <code>java.lang.String</code> | Final artifact output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.junit">junit</a></code> | <code>java.lang.Boolean</code> | Include junit tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.junitOptions">junitOptions</a></code> | <code>io.github.cdklabs.projen.java.JunitOptions</code> | junit options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.packagingOptions">packagingOptions</a></code> | <code>io.github.cdklabs.projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJava">projenrcJava</a></code> | <code>java.lang.Boolean</code> | Use projenrc in java. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJavaOptions">projenrcJavaOptions</a></code> | <code>io.github.cdklabs.projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.testDeps">testDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of test dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.sample">sample</a></code> | <code>java.lang.Boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.sampleJavaPackage">sampleJavaPackage</a></code> | <code>java.lang.String</code> | The java package to use for the code sample. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.buildCommand">buildCommand</a></code> | <code>java.lang.String</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkout">cdkout</a></code> | <code>java.lang.String</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.context">context</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.featureFlags">featureFlags</a></code> | <code>java.lang.Boolean</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.requireApproval">requireApproval</a></code> | <code>io.github.cdklabs.projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.watchExcludes">watchExcludes</a></code> | <code>java.util.List<java.lang.String></code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.watchIncludes">watchIncludes</a></code> | <code>java.util.List<java.lang.String></code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkVersion">cdkVersion</a></code> | <code>java.lang.String</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkAssert">cdkAssert</a></code> | <code>java.lang.Boolean</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkAssertions">cdkAssertions</a></code> | <code>java.lang.Boolean</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkDependencies">cdkDependencies</a></code> | <code>java.util.List<java.lang.String></code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkDependenciesAsDeps">cdkDependenciesAsDeps</a></code> | <code>java.lang.Boolean</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkTestDependencies">cdkTestDependencies</a></code> | <code>java.util.List<java.lang.String></code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkVersionPinning">cdkVersionPinning</a></code> | <code>java.lang.Boolean</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.constructsVersion">constructsVersion</a></code> | <code>java.lang.String</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.mainClass">mainClass</a></code> | <code>java.lang.String</code> | The name of the Java class with the static `main()` method. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.name"></a>

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.commitGenerated"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.gitOptions"></a>

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.logging"></a>

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.outdir"></a>

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.parent"></a>

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenCommand"></a>

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJson"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.renovatebot"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.autoMerge"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.clobber"></a>

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.devContainer"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.github"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.githubOptions"></a>

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.gitpod"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenCredentials"></a>

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.readme"></a>

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.stale"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.staleOptions"></a>

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.vscode"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.artifactId"></a>

- *Type:* java.lang.String
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.groupId"></a>

- *Type:* java.lang.String
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.version"></a>

- *Type:* java.lang.String
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.description"></a>

- *Type:* java.lang.String
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.packaging"></a>

- *Type:* java.lang.String
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.url"></a>

- *Type:* java.lang.String
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compileOptions`<sup>Optional</sup> <a name="compileOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.compileOptions"></a>

- *Type:* io.github.cdklabs.projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.deps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.distdir"></a>

- *Type:* java.lang.String
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.junit"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include junit tests.

---

##### `junitOptions`<sup>Optional</sup> <a name="junitOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.junitOptions"></a>

- *Type:* io.github.cdklabs.projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packagingOptions`<sup>Optional</sup> <a name="packagingOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.packagingOptions"></a>

- *Type:* io.github.cdklabs.projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrcJava`<sup>Optional</sup> <a name="projenrcJava" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJava"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrcJavaOptions`<sup>Optional</sup> <a name="projenrcJavaOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.projenrcJavaOptions"></a>

- *Type:* io.github.cdklabs.projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `testDeps`<sup>Optional</sup> <a name="testDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.testDeps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.sample"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sampleJavaPackage`<sup>Optional</sup> <a name="sampleJavaPackage" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.sampleJavaPackage"></a>

- *Type:* java.lang.String
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `buildCommand`<sup>Optional</sup> <a name="buildCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.buildCommand"></a>

- *Type:* java.lang.String
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkout"></a>

- *Type:* java.lang.String
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.context"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `featureFlags`<sup>Optional</sup> <a name="featureFlags" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.featureFlags"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include all feature flags in cdk.json.

---

##### `requireApproval`<sup>Optional</sup> <a name="requireApproval" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.requireApproval"></a>

- *Type:* io.github.cdklabs.projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watchExcludes`<sup>Optional</sup> <a name="watchExcludes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.watchExcludes"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watchIncludes`<sup>Optional</sup> <a name="watchIncludes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.watchIncludes"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkVersion"></a>

- *Type:* java.lang.String
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdkAssert`~~<sup>Optional</sup> <a name="cdkAssert" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkAssert"></a>

- *Deprecated:* The

- *Type:* java.lang.Boolean
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdkAssertions`<sup>Optional</sup> <a name="cdkAssertions" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkAssertions"></a>

- *Type:* java.lang.Boolean
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdkDependencies`~~<sup>Optional</sup> <a name="cdkDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

- *Type:* java.util.List<java.lang.String>

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdkDependenciesAsDeps`~~<sup>Optional</sup> <a name="cdkDependenciesAsDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

- *Type:* java.lang.Boolean
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdkTestDependencies`~~<sup>Optional</sup> <a name="cdkTestDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

- *Type:* java.util.List<java.lang.String>

AWS CDK modules required for testing.

---

##### `cdkVersionPinning`<sup>Optional</sup> <a name="cdkVersionPinning" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.cdkVersionPinning"></a>

- *Type:* java.lang.Boolean

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructsVersion`<sup>Optional</sup> <a name="constructsVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.constructsVersion"></a>

- *Type:* java.lang.String
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `mainClass`<sup>Required</sup> <a name="mainClass" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.Initializer.parameter.mainClass"></a>

- *Type:* java.lang.String
- *Default:* "org.acme.MyApp"

The name of the Java class with the static `main()` method.

This method
should call `app.synth()` on the CDK app.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addDependency">addDependency</a></code> | Adds a runtime dependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin">addPlugin</a></code> | Adds a build plugin to the pom. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTestDependency">addTestDependency</a></code> | Adds a test dependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addCdkDependency">addCdkDependency</a></code> | Adds an AWS CDK module dependencies. |

---

##### `addExcludeFromCleanup` <a name="addExcludeFromCleanup" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addExcludeFromCleanup"></a>

```java
public void addExcludeFromCleanup(java.lang.String globs)
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* java.lang.String

The glob patterns to match.

---

##### `addGitIgnore` <a name="addGitIgnore" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addGitIgnore"></a>

```java
public void addGitIgnore(java.lang.String pattern)
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addGitIgnore.parameter.pattern"></a>

- *Type:* java.lang.String

The glob pattern to ignore.

---

##### `addPackageIgnore` <a name="addPackageIgnore" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPackageIgnore"></a>

```java
public void addPackageIgnore(java.lang.String _pattern)
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* java.lang.String

The glob pattern to exclude.

---

##### `addTask` <a name="addTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask"></a>

```java
public Task addTask(java.lang.String name)
public Task addTask(java.lang.String name, TaskOptions props)
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.name"></a>

- *Type:* java.lang.String

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTask.parameter.props"></a>

- *Type:* io.github.cdklabs.projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTip"></a>

```java
public void addTip(java.lang.String message)
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTip.parameter.message"></a>

- *Type:* java.lang.String

The message.

---

##### `annotateGenerated` <a name="annotateGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.annotateGenerated"></a>

```java
public void annotateGenerated(java.lang.String glob)
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.annotateGenerated.parameter.glob"></a>

- *Type:* java.lang.String

the glob pattern to match (could be a file path).

---

##### `postSynthesize` <a name="postSynthesize" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.postSynthesize"></a>

```java
public void postSynthesize()
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `preSynthesize` <a name="preSynthesize" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.preSynthesize"></a>

```java
public void preSynthesize()
```

Called before all components are synthesized.

##### `removeTask` <a name="removeTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.removeTask"></a>

```java
public Task removeTask(java.lang.String name)
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.removeTask.parameter.name"></a>

- *Type:* java.lang.String

The name of the task to remove.

---

##### `runTaskCommand` <a name="runTaskCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.runTaskCommand"></a>

```java
public java.lang.String runTaskCommand(Task task)
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.runTaskCommand.parameter.task"></a>

- *Type:* io.github.cdklabs.projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.synth"></a>

```java
public void synth()
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `tryFindFile` <a name="tryFindFile" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindFile"></a>

```java
public FileBase tryFindFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindJsonFile"></a>

```java
public JsonFile tryFindJsonFile(java.lang.String filePath)
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### `tryFindObjectFile` <a name="tryFindObjectFile" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindObjectFile"></a>

```java
public ObjectFile tryFindObjectFile(java.lang.String filePath)
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### `tryRemoveFile` <a name="tryRemoveFile" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryRemoveFile"></a>

```java
public FileBase tryRemoveFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `addDependency` <a name="addDependency" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addDependency"></a>

```java
public void addDependency(java.lang.String spec)
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addDependency.parameter.spec"></a>

- *Type:* java.lang.String

Format `<groupId>/<artifactId>@<semver>`.

---

##### `addPlugin` <a name="addPlugin" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin"></a>

```java
public Dependency addPlugin(java.lang.String spec)
public Dependency addPlugin(java.lang.String spec, PluginOptions options)
```

Adds a build plugin to the pom.

The plug in is also added as a BUILD dep to the project.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin.parameter.spec"></a>

- *Type:* java.lang.String

dependency spec (`group/artifact@version`).

---

###### `options`<sup>Optional</sup> <a name="options" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addPlugin.parameter.options"></a>

- *Type:* io.github.cdklabs.projen.java.PluginOptions

plugin options.

---

##### `addTestDependency` <a name="addTestDependency" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTestDependency"></a>

```java
public void addTestDependency(java.lang.String spec)
```

Adds a test dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addTestDependency.parameter.spec"></a>

- *Type:* java.lang.String

Format `<groupId>/<artifactId>@<semver>`.

---

##### ~~`addCdkDependency`~~ <a name="addCdkDependency" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addCdkDependency"></a>

```java
public void addCdkDependency(java.lang.String modules)
```

Adds an AWS CDK module dependencies.

###### `modules`<sup>Required</sup> <a name="modules" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.addCdkDependency.parameter.modules"></a>

- *Type:* java.lang.String

The list of modules to depend on (e.g. "software.amazon.awscdk/aws-lambda", "software.amazon.awscdk/aws-iam", etc).

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.buildTask">buildTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.compileTask">compileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.components">components</a></code> | <code>java.util.List<io.github.cdklabs.projen.Component></code> | Returns all the components within this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.deps">deps</a></code> | <code>io.github.cdklabs.projen.Dependencies</code> | Project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.ejected">ejected</a></code> | <code>java.lang.Boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.files">files</a></code> | <code>java.util.List<io.github.cdklabs.projen.FileBase></code> | All files in this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitattributes">gitattributes</a></code> | <code>io.github.cdklabs.projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitignore">gitignore</a></code> | <code>io.github.cdklabs.projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.logger">logger</a></code> | <code>io.github.cdklabs.projen.Logger</code> | Logging utilities. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.name">name</a></code> | <code>java.lang.String</code> | Project name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.outdir">outdir</a></code> | <code>java.lang.String</code> | Absolute output directory of this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.packageTask">packageTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.postCompileTask">postCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.preCompileTask">preCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projectBuild">projectBuild</a></code> | <code>io.github.cdklabs.projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.root">root</a></code> | <code>io.github.cdklabs.projen.Project</code> | The root project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.tasks">tasks</a></code> | <code>io.github.cdklabs.projen.Tasks</code> | Project tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.testTask">testTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.defaultTask">defaultTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.initProject">initProject</a></code> | <code>io.github.cdklabs.projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | A parent project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.autoApprove">autoApprove</a></code> | <code>io.github.cdklabs.projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.devContainer">devContainer</a></code> | <code>io.github.cdklabs.projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.github">github</a></code> | <code>io.github.cdklabs.projen.github.GitHub</code> | Access all github components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitpod">gitpod</a></code> | <code>io.github.cdklabs.projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.vscode">vscode</a></code> | <code>io.github.cdklabs.projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.compile">compile</a></code> | <code>io.github.cdklabs.projen.java.MavenCompile</code> | Compile component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.distdir">distdir</a></code> | <code>java.lang.String</code> | Maven artifact output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.packaging">packaging</a></code> | <code>io.github.cdklabs.projen.java.MavenPackaging</code> | Packaging component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.pom">pom</a></code> | <code>io.github.cdklabs.projen.java.Pom</code> | API for managing `pom.xml`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.junit">junit</a></code> | <code>io.github.cdklabs.projen.java.Junit</code> | JUnit component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projenrc">projenrc</a></code> | <code>io.github.cdklabs.projen.java.Projenrc</code> | Projenrc component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkConfig">cdkConfig</a></code> | <code>io.github.cdklabs.projen.awscdk.CdkConfig</code> | The `cdk.json` file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkDeps">cdkDeps</a></code> | <code>io.github.cdklabs.projen.awscdk.AwsCdkDeps</code> | CDK dependency management helper class. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkTasks">cdkTasks</a></code> | <code>io.github.cdklabs.projen.awscdk.CdkTasks</code> | CDK tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainClass">mainClass</a></code> | <code>java.lang.String</code> | The full name of the main class of the java app (package.Class). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainClassName">mainClassName</a></code> | <code>java.lang.String</code> | The name of the Java class with the static `main()` method. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainPackage">mainPackage</a></code> | <code>java.lang.String</code> | The name of the Java package that includes the main class. |

---

##### `buildTask`<sup>Required</sup> <a name="buildTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.buildTask"></a>

```java
public Task getBuildTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `commitGenerated`<sup>Required</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean

Whether to commit the managed files by default.

---

##### `compileTask`<sup>Required</sup> <a name="compileTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.compileTask"></a>

```java
public Task getCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.components"></a>

```java
public java.util.List<Component> getComponents();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Component>

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.deps"></a>

```java
public Dependencies getDeps();
```

- *Type:* io.github.cdklabs.projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.ejected"></a>

```java
public java.lang.Boolean getEjected();
```

- *Type:* java.lang.Boolean

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.files"></a>

```java
public java.util.List<FileBase> getFiles();
```

- *Type:* java.util.List<io.github.cdklabs.projen.FileBase>

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitattributes"></a>

```java
public GitAttributesFile getGitattributes();
```

- *Type:* io.github.cdklabs.projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitignore"></a>

```java
public IgnoreFile getGitignore();
```

- *Type:* io.github.cdklabs.projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.logger"></a>

```java
public Logger getLogger();
```

- *Type:* io.github.cdklabs.projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String

Absolute output directory of this project.

---

##### `packageTask`<sup>Required</sup> <a name="packageTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.packageTask"></a>

```java
public Task getPackageTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `postCompileTask`<sup>Required</sup> <a name="postCompileTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.postCompileTask"></a>

```java
public Task getPostCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `preCompileTask`<sup>Required</sup> <a name="preCompileTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.preCompileTask"></a>

```java
public Task getPreCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `projectBuild`<sup>Required</sup> <a name="projectBuild" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projectBuild"></a>

```java
public ProjectBuild getProjectBuild();
```

- *Type:* io.github.cdklabs.projen.ProjectBuild

Manages the build process of the project.

---

##### `projenCommand`<sup>Required</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.root"></a>

```java
public Project getRoot();
```

- *Type:* io.github.cdklabs.projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.tasks"></a>

```java
public Tasks getTasks();
```

- *Type:* io.github.cdklabs.projen.Tasks

Project tasks.

---

##### `testTask`<sup>Required</sup> <a name="testTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.testTask"></a>

```java
public Task getTestTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `defaultTask`<sup>Optional</sup> <a name="defaultTask" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.defaultTask"></a>

```java
public Task getDefaultTask();
```

- *Type:* io.github.cdklabs.projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `initProject`<sup>Optional</sup> <a name="initProject" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.initProject"></a>

```java
public InitProject getInitProject();
```

- *Type:* io.github.cdklabs.projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

A parent project.

If undefined, this is the root project.

---

##### `projectType`<sup>Required</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projectType"></a>

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType

---

##### `autoApprove`<sup>Optional</sup> <a name="autoApprove" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.autoApprove"></a>

```java
public AutoApprove getAutoApprove();
```

- *Type:* io.github.cdklabs.projen.github.AutoApprove

Auto approve set up for this project.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.devContainer"></a>

```java
public DevContainer getDevContainer();
```

- *Type:* io.github.cdklabs.projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.github"></a>

```java
public GitHub getGithub();
```

- *Type:* io.github.cdklabs.projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.gitpod"></a>

```java
public Gitpod getGitpod();
```

- *Type:* io.github.cdklabs.projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.vscode"></a>

```java
public VsCode getVscode();
```

- *Type:* io.github.cdklabs.projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### `compile`<sup>Required</sup> <a name="compile" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.compile"></a>

```java
public MavenCompile getCompile();
```

- *Type:* io.github.cdklabs.projen.java.MavenCompile

Compile component.

---

##### `distdir`<sup>Required</sup> <a name="distdir" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.distdir"></a>

```java
public java.lang.String getDistdir();
```

- *Type:* java.lang.String

Maven artifact output directory.

---

##### `packaging`<sup>Required</sup> <a name="packaging" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.packaging"></a>

```java
public MavenPackaging getPackaging();
```

- *Type:* io.github.cdklabs.projen.java.MavenPackaging

Packaging component.

---

##### `pom`<sup>Required</sup> <a name="pom" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.pom"></a>

```java
public Pom getPom();
```

- *Type:* io.github.cdklabs.projen.java.Pom

API for managing `pom.xml`.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.junit"></a>

```java
public Junit getJunit();
```

- *Type:* io.github.cdklabs.projen.java.Junit

JUnit component.

---

##### `projenrc`<sup>Optional</sup> <a name="projenrc" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.projenrc"></a>

```java
public Projenrc getProjenrc();
```

- *Type:* io.github.cdklabs.projen.java.Projenrc

Projenrc component.

---

##### `cdkConfig`<sup>Required</sup> <a name="cdkConfig" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkConfig"></a>

```java
public CdkConfig getCdkConfig();
```

- *Type:* io.github.cdklabs.projen.awscdk.CdkConfig

The `cdk.json` file.

---

##### `cdkDeps`<sup>Required</sup> <a name="cdkDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkDeps"></a>

```java
public AwsCdkDeps getCdkDeps();
```

- *Type:* io.github.cdklabs.projen.awscdk.AwsCdkDeps

CDK dependency management helper class.

---

##### `cdkTasks`<sup>Required</sup> <a name="cdkTasks" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.cdkTasks"></a>

```java
public CdkTasks getCdkTasks();
```

- *Type:* io.github.cdklabs.projen.awscdk.CdkTasks

CDK tasks.

---

##### `mainClass`<sup>Required</sup> <a name="mainClass" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainClass"></a>

```java
public java.lang.String getMainClass();
```

- *Type:* java.lang.String

The full name of the main class of the java app (package.Class).

---

##### `mainClassName`<sup>Required</sup> <a name="mainClassName" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainClassName"></a>

```java
public java.lang.String getMainClassName();
```

- *Type:* java.lang.String

The name of the Java class with the static `main()` method.

---

##### `mainPackage`<sup>Required</sup> <a name="mainPackage" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.mainPackage"></a>

```java
public java.lang.String getMainPackage();
```

- *Type:* java.lang.String

The name of the Java package that includes the main class.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>java.lang.String</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="aws-prototyping-sdk.pipeline.PDKPipelineJavaProject.property.DEFAULT_TASK"></a>

```java
public java.lang.String getDefaultTask();
```

- *Type:* java.lang.String

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### PDKPipelinePyProject <a name="PDKPipelinePyProject" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject"></a>

Synthesizes a Python Project with a CI/CD pipeline.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pipeline.PDKPipelinePyProject;

PDKPipelinePyProject.Builder.create()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
    .authorEmail(java.lang.String)
    .authorName(java.lang.String)
    .version(java.lang.String)
//  .classifiers(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .homepage(java.lang.String)
//  .license(java.lang.String)
//  .packageName(java.lang.String)
//  .poetryOptions(PoetryPyprojectOptionsWithoutDeps)
//  .setupConfig(java.util.Map<java.lang.String, java.lang.Object>)
    .moduleName(java.lang.String)
//  .deps(java.util.List<java.lang.String>)
//  .devDeps(java.util.List<java.lang.String>)
//  .pip(java.lang.Boolean)
//  .poetry(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenrcPython(java.lang.Boolean)
//  .projenrcPythonOptions(ProjenrcOptions)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcTsOptions)
//  .pytest(java.lang.Boolean)
//  .pytestOptions(PytestOptions)
//  .sample(java.lang.Boolean)
//  .setuptools(java.lang.Boolean)
//  .venv(java.lang.Boolean)
//  .venvOptions(VenvOptions)
//  .buildCommand(java.lang.String)
//  .cdkout(java.lang.String)
//  .context(java.util.Map<java.lang.String, java.lang.Object>)
//  .featureFlags(java.lang.Boolean)
//  .requireApproval(ApprovalLevel)
//  .watchExcludes(java.util.List<java.lang.String>)
//  .watchIncludes(java.util.List<java.lang.String>)
    .cdkVersion(java.lang.String)
//  .cdkAssert(java.lang.Boolean)
//  .cdkAssertions(java.lang.Boolean)
//  .cdkDependencies(java.util.List<java.lang.String>)
//  .cdkDependenciesAsDeps(java.lang.Boolean)
//  .cdkTestDependencies(java.util.List<java.lang.String>)
//  .cdkVersionPinning(java.lang.Boolean)
//  .constructsVersion(java.lang.String)
//  .appEntrypoint(java.lang.String)
//  .testdir(java.lang.String)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.version">version</a></code> | <code>java.lang.String</code> | Version of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.classifiers">classifiers</a></code> | <code>java.util.List<java.lang.String></code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.description">description</a></code> | <code>java.lang.String</code> | A short description of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.homepage">homepage</a></code> | <code>java.lang.String</code> | A URL to the website of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.license">license</a></code> | <code>java.lang.String</code> | License of this package as an SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.packageName">packageName</a></code> | <code>java.lang.String</code> | Package name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.poetryOptions">poetryOptions</a></code> | <code>io.github.cdklabs.projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.setupConfig">setupConfig</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.moduleName">moduleName</a></code> | <code>java.lang.String</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | List of runtime dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dev dependencies for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.pip">pip</a></code> | <code>java.lang.Boolean</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.poetry">poetry</a></code> | <code>java.lang.Boolean</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Use projenrc in javascript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcPython">projenrcPython</a></code> | <code>java.lang.Boolean</code> | Use projenrc in Python. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcPythonOptions">projenrcPythonOptions</a></code> | <code>io.github.cdklabs.projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use projenrc in TypeScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.pytest">pytest</a></code> | <code>java.lang.Boolean</code> | Include pytest tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.pytestOptions">pytestOptions</a></code> | <code>io.github.cdklabs.projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.sample">sample</a></code> | <code>java.lang.Boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.setuptools">setuptools</a></code> | <code>java.lang.Boolean</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.venv">venv</a></code> | <code>java.lang.Boolean</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.venvOptions">venvOptions</a></code> | <code>io.github.cdklabs.projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.buildCommand">buildCommand</a></code> | <code>java.lang.String</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkout">cdkout</a></code> | <code>java.lang.String</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.context">context</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.featureFlags">featureFlags</a></code> | <code>java.lang.Boolean</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.requireApproval">requireApproval</a></code> | <code>io.github.cdklabs.projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.watchExcludes">watchExcludes</a></code> | <code>java.util.List<java.lang.String></code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.watchIncludes">watchIncludes</a></code> | <code>java.util.List<java.lang.String></code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkVersion">cdkVersion</a></code> | <code>java.lang.String</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkAssert">cdkAssert</a></code> | <code>java.lang.Boolean</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkAssertions">cdkAssertions</a></code> | <code>java.lang.Boolean</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkDependencies">cdkDependencies</a></code> | <code>java.util.List<java.lang.String></code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkDependenciesAsDeps">cdkDependenciesAsDeps</a></code> | <code>java.lang.Boolean</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkTestDependencies">cdkTestDependencies</a></code> | <code>java.util.List<java.lang.String></code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkVersionPinning">cdkVersionPinning</a></code> | <code>java.lang.Boolean</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.constructsVersion">constructsVersion</a></code> | <code>java.lang.String</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.appEntrypoint">appEntrypoint</a></code> | <code>java.lang.String</code> | The CDK app's entrypoint (relative to the source directory, which is "src" by default). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.testdir">testdir</a></code> | <code>java.lang.String</code> | Python sources directory. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.name"></a>

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.commitGenerated"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.gitOptions"></a>

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.logging"></a>

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.outdir"></a>

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.parent"></a>

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenCommand"></a>

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJson"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.renovatebot"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.autoMerge"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.clobber"></a>

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.devContainer"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.github"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.githubOptions"></a>

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.gitpod"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenCredentials"></a>

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.readme"></a>

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.stale"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.staleOptions"></a>

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.vscode"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `authorEmail`<sup>Required</sup> <a name="authorEmail" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.authorEmail"></a>

- *Type:* java.lang.String
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `authorName`<sup>Required</sup> <a name="authorName" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.authorName"></a>

- *Type:* java.lang.String
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.version"></a>

- *Type:* java.lang.String
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.classifiers"></a>

- *Type:* java.util.List<java.lang.String>

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.description"></a>

- *Type:* java.lang.String

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.homepage"></a>

- *Type:* java.lang.String

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.license"></a>

- *Type:* java.lang.String

License of this package as an SPDX identifier.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.packageName"></a>

- *Type:* java.lang.String

Package name.

---

##### `poetryOptions`<sup>Optional</sup> <a name="poetryOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.poetryOptions"></a>

- *Type:* io.github.cdklabs.projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setupConfig`<sup>Optional</sup> <a name="setupConfig" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.setupConfig"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>

Additional fields to pass in the setup() function if using setuptools.

---

##### `moduleName`<sup>Required</sup> <a name="moduleName" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.moduleName"></a>

- *Type:* java.lang.String
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.deps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.devDeps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.pip"></a>

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.poetry"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJs"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrcPython`<sup>Optional</sup> <a name="projenrcPython" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcPython"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrcPythonOptions`<sup>Optional</sup> <a name="projenrcPythonOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcPythonOptions"></a>

- *Type:* io.github.cdklabs.projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcTs"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.pytest"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include pytest tests.

---

##### `pytestOptions`<sup>Optional</sup> <a name="pytestOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.pytestOptions"></a>

- *Type:* io.github.cdklabs.projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.sample"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.setuptools"></a>

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.venv"></a>

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venvOptions`<sup>Optional</sup> <a name="venvOptions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.venvOptions"></a>

- *Type:* io.github.cdklabs.projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `buildCommand`<sup>Optional</sup> <a name="buildCommand" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.buildCommand"></a>

- *Type:* java.lang.String
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkout"></a>

- *Type:* java.lang.String
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.context"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `featureFlags`<sup>Optional</sup> <a name="featureFlags" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.featureFlags"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include all feature flags in cdk.json.

---

##### `requireApproval`<sup>Optional</sup> <a name="requireApproval" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.requireApproval"></a>

- *Type:* io.github.cdklabs.projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watchExcludes`<sup>Optional</sup> <a name="watchExcludes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.watchExcludes"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watchIncludes`<sup>Optional</sup> <a name="watchIncludes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.watchIncludes"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkVersion"></a>

- *Type:* java.lang.String
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdkAssert`~~<sup>Optional</sup> <a name="cdkAssert" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkAssert"></a>

- *Deprecated:* The

- *Type:* java.lang.Boolean
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdkAssertions`<sup>Optional</sup> <a name="cdkAssertions" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkAssertions"></a>

- *Type:* java.lang.Boolean
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdkDependencies`~~<sup>Optional</sup> <a name="cdkDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

- *Type:* java.util.List<java.lang.String>

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdkDependenciesAsDeps`~~<sup>Optional</sup> <a name="cdkDependenciesAsDeps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

- *Type:* java.lang.Boolean
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdkTestDependencies`~~<sup>Optional</sup> <a name="cdkTestDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

- *Type:* java.util.List<java.lang.String>

AWS CDK modules required for testing.

---

##### `cdkVersionPinning`<sup>Optional</sup> <a name="cdkVersionPinning" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.cdkVersionPinning"></a>

- *Type:* java.lang.Boolean

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructsVersion`<sup>Optional</sup> <a name="constructsVersion" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.constructsVersion"></a>

- *Type:* java.lang.String
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `appEntrypoint`<sup>Optional</sup> <a name="appEntrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.appEntrypoint"></a>

- *Type:* java.lang.String
- *Default:* "app.py"

The CDK app's entrypoint (relative to the source directory, which is "src" by default).

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.Initializer.parameter.testdir"></a>

- *Type:* java.lang.String
- *Default:* "tests"

Python sources directory.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDependency">addDependency</a></code> | Adds a runtime dependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDevDependency">addDevDependency</a></code> | Adds a dev dependency. |

---

##### `addExcludeFromCleanup` <a name="addExcludeFromCleanup" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addExcludeFromCleanup"></a>

```java
public void addExcludeFromCleanup(java.lang.String globs)
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* java.lang.String

The glob patterns to match.

---

##### `addGitIgnore` <a name="addGitIgnore" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addGitIgnore"></a>

```java
public void addGitIgnore(java.lang.String pattern)
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addGitIgnore.parameter.pattern"></a>

- *Type:* java.lang.String

The glob pattern to ignore.

---

##### `addPackageIgnore` <a name="addPackageIgnore" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addPackageIgnore"></a>

```java
public void addPackageIgnore(java.lang.String _pattern)
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* java.lang.String

The glob pattern to exclude.

---

##### `addTask` <a name="addTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask"></a>

```java
public Task addTask(java.lang.String name)
public Task addTask(java.lang.String name, TaskOptions props)
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.name"></a>

- *Type:* java.lang.String

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTask.parameter.props"></a>

- *Type:* io.github.cdklabs.projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTip"></a>

```java
public void addTip(java.lang.String message)
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addTip.parameter.message"></a>

- *Type:* java.lang.String

The message.

---

##### `annotateGenerated` <a name="annotateGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.annotateGenerated"></a>

```java
public void annotateGenerated(java.lang.String glob)
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.annotateGenerated.parameter.glob"></a>

- *Type:* java.lang.String

the glob pattern to match (could be a file path).

---

##### `postSynthesize` <a name="postSynthesize" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.postSynthesize"></a>

```java
public void postSynthesize()
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `preSynthesize` <a name="preSynthesize" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.preSynthesize"></a>

```java
public void preSynthesize()
```

Called before all components are synthesized.

##### `removeTask` <a name="removeTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.removeTask"></a>

```java
public Task removeTask(java.lang.String name)
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.removeTask.parameter.name"></a>

- *Type:* java.lang.String

The name of the task to remove.

---

##### `runTaskCommand` <a name="runTaskCommand" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.runTaskCommand"></a>

```java
public java.lang.String runTaskCommand(Task task)
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.runTaskCommand.parameter.task"></a>

- *Type:* io.github.cdklabs.projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.synth"></a>

```java
public void synth()
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `tryFindFile` <a name="tryFindFile" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindFile"></a>

```java
public FileBase tryFindFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindJsonFile"></a>

```java
public JsonFile tryFindJsonFile(java.lang.String filePath)
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### `tryFindObjectFile` <a name="tryFindObjectFile" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindObjectFile"></a>

```java
public ObjectFile tryFindObjectFile(java.lang.String filePath)
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### `tryRemoveFile` <a name="tryRemoveFile" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryRemoveFile"></a>

```java
public FileBase tryRemoveFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `addDependency` <a name="addDependency" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDependency"></a>

```java
public void addDependency(java.lang.String spec)
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDependency.parameter.spec"></a>

- *Type:* java.lang.String

Format `<module>@<semver>`.

---

##### `addDevDependency` <a name="addDevDependency" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDevDependency"></a>

```java
public void addDevDependency(java.lang.String spec)
```

Adds a dev dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.addDevDependency.parameter.spec"></a>

- *Type:* java.lang.String

Format `<module>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.buildTask">buildTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.compileTask">compileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.components">components</a></code> | <code>java.util.List<io.github.cdklabs.projen.Component></code> | Returns all the components within this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.deps">deps</a></code> | <code>io.github.cdklabs.projen.Dependencies</code> | Project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.ejected">ejected</a></code> | <code>java.lang.Boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.files">files</a></code> | <code>java.util.List<io.github.cdklabs.projen.FileBase></code> | All files in this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitattributes">gitattributes</a></code> | <code>io.github.cdklabs.projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitignore">gitignore</a></code> | <code>io.github.cdklabs.projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.logger">logger</a></code> | <code>io.github.cdklabs.projen.Logger</code> | Logging utilities. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.name">name</a></code> | <code>java.lang.String</code> | Project name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.outdir">outdir</a></code> | <code>java.lang.String</code> | Absolute output directory of this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.packageTask">packageTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.postCompileTask">postCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.preCompileTask">preCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projectBuild">projectBuild</a></code> | <code>io.github.cdklabs.projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.root">root</a></code> | <code>io.github.cdklabs.projen.Project</code> | The root project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.tasks">tasks</a></code> | <code>io.github.cdklabs.projen.Tasks</code> | Project tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.testTask">testTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.defaultTask">defaultTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.initProject">initProject</a></code> | <code>io.github.cdklabs.projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | A parent project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.autoApprove">autoApprove</a></code> | <code>io.github.cdklabs.projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.devContainer">devContainer</a></code> | <code>io.github.cdklabs.projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.github">github</a></code> | <code>io.github.cdklabs.projen.github.GitHub</code> | Access all github components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitpod">gitpod</a></code> | <code>io.github.cdklabs.projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.vscode">vscode</a></code> | <code>io.github.cdklabs.projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.depsManager">depsManager</a></code> | <code>io.github.cdklabs.projen.python.IPythonDeps</code> | API for managing dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.envManager">envManager</a></code> | <code>io.github.cdklabs.projen.python.IPythonEnv</code> | API for mangaging the Python runtime environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.moduleName">moduleName</a></code> | <code>java.lang.String</code> | Python module name (the project name, with any hyphens or periods replaced with underscores). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.version">version</a></code> | <code>java.lang.String</code> | Version of the package for distribution (should follow semver). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.packagingManager">packagingManager</a></code> | <code>io.github.cdklabs.projen.python.IPythonPackaging</code> | API for managing packaging the project as a library. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.pytest">pytest</a></code> | <code>io.github.cdklabs.projen.python.Pytest</code> | Pytest component. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.appEntrypoint">appEntrypoint</a></code> | <code>java.lang.String</code> | The CDK app entrypoint. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkConfig">cdkConfig</a></code> | <code>io.github.cdklabs.projen.awscdk.CdkConfig</code> | cdk.json configuration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkDeps">cdkDeps</a></code> | <code>io.github.cdklabs.projen.awscdk.AwsCdkDeps</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkTasks">cdkTasks</a></code> | <code>io.github.cdklabs.projen.awscdk.CdkTasks</code> | Common CDK tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkVersion">cdkVersion</a></code> | <code>java.lang.String</code> | The CDK version this app is using. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.testdir">testdir</a></code> | <code>java.lang.String</code> | The directory in which the python tests reside. |

---

##### `buildTask`<sup>Required</sup> <a name="buildTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.buildTask"></a>

```java
public Task getBuildTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `commitGenerated`<sup>Required</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean

Whether to commit the managed files by default.

---

##### `compileTask`<sup>Required</sup> <a name="compileTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.compileTask"></a>

```java
public Task getCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.components"></a>

```java
public java.util.List<Component> getComponents();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Component>

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.deps"></a>

```java
public Dependencies getDeps();
```

- *Type:* io.github.cdklabs.projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.ejected"></a>

```java
public java.lang.Boolean getEjected();
```

- *Type:* java.lang.Boolean

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.files"></a>

```java
public java.util.List<FileBase> getFiles();
```

- *Type:* java.util.List<io.github.cdklabs.projen.FileBase>

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitattributes"></a>

```java
public GitAttributesFile getGitattributes();
```

- *Type:* io.github.cdklabs.projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitignore"></a>

```java
public IgnoreFile getGitignore();
```

- *Type:* io.github.cdklabs.projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.logger"></a>

```java
public Logger getLogger();
```

- *Type:* io.github.cdklabs.projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String

Absolute output directory of this project.

---

##### `packageTask`<sup>Required</sup> <a name="packageTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.packageTask"></a>

```java
public Task getPackageTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `postCompileTask`<sup>Required</sup> <a name="postCompileTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.postCompileTask"></a>

```java
public Task getPostCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `preCompileTask`<sup>Required</sup> <a name="preCompileTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.preCompileTask"></a>

```java
public Task getPreCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `projectBuild`<sup>Required</sup> <a name="projectBuild" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projectBuild"></a>

```java
public ProjectBuild getProjectBuild();
```

- *Type:* io.github.cdklabs.projen.ProjectBuild

Manages the build process of the project.

---

##### `projenCommand`<sup>Required</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.root"></a>

```java
public Project getRoot();
```

- *Type:* io.github.cdklabs.projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.tasks"></a>

```java
public Tasks getTasks();
```

- *Type:* io.github.cdklabs.projen.Tasks

Project tasks.

---

##### `testTask`<sup>Required</sup> <a name="testTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.testTask"></a>

```java
public Task getTestTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `defaultTask`<sup>Optional</sup> <a name="defaultTask" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.defaultTask"></a>

```java
public Task getDefaultTask();
```

- *Type:* io.github.cdklabs.projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `initProject`<sup>Optional</sup> <a name="initProject" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.initProject"></a>

```java
public InitProject getInitProject();
```

- *Type:* io.github.cdklabs.projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

A parent project.

If undefined, this is the root project.

---

##### `projectType`<sup>Required</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.projectType"></a>

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType

---

##### `autoApprove`<sup>Optional</sup> <a name="autoApprove" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.autoApprove"></a>

```java
public AutoApprove getAutoApprove();
```

- *Type:* io.github.cdklabs.projen.github.AutoApprove

Auto approve set up for this project.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.devContainer"></a>

```java
public DevContainer getDevContainer();
```

- *Type:* io.github.cdklabs.projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.github"></a>

```java
public GitHub getGithub();
```

- *Type:* io.github.cdklabs.projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.gitpod"></a>

```java
public Gitpod getGitpod();
```

- *Type:* io.github.cdklabs.projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.vscode"></a>

```java
public VsCode getVscode();
```

- *Type:* io.github.cdklabs.projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### `depsManager`<sup>Required</sup> <a name="depsManager" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.depsManager"></a>

```java
public IPythonDeps getDepsManager();
```

- *Type:* io.github.cdklabs.projen.python.IPythonDeps

API for managing dependencies.

---

##### `envManager`<sup>Required</sup> <a name="envManager" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.envManager"></a>

```java
public IPythonEnv getEnvManager();
```

- *Type:* io.github.cdklabs.projen.python.IPythonEnv

API for mangaging the Python runtime environment.

---

##### `moduleName`<sup>Required</sup> <a name="moduleName" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.moduleName"></a>

```java
public java.lang.String getModuleName();
```

- *Type:* java.lang.String

Python module name (the project name, with any hyphens or periods replaced with underscores).

---

##### `version`<sup>Required</sup> <a name="version" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.version"></a>

```java
public java.lang.String getVersion();
```

- *Type:* java.lang.String

Version of the package for distribution (should follow semver).

---

##### `packagingManager`<sup>Optional</sup> <a name="packagingManager" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.packagingManager"></a>

```java
public IPythonPackaging getPackagingManager();
```

- *Type:* io.github.cdklabs.projen.python.IPythonPackaging

API for managing packaging the project as a library.

Only applies when the `projectType` is LIB.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.pytest"></a>

```java
public Pytest getPytest();
```

- *Type:* io.github.cdklabs.projen.python.Pytest

Pytest component.

---

##### `appEntrypoint`<sup>Required</sup> <a name="appEntrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.appEntrypoint"></a>

```java
public java.lang.String getAppEntrypoint();
```

- *Type:* java.lang.String

The CDK app entrypoint.

---

##### `cdkConfig`<sup>Required</sup> <a name="cdkConfig" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkConfig"></a>

```java
public CdkConfig getCdkConfig();
```

- *Type:* io.github.cdklabs.projen.awscdk.CdkConfig

cdk.json configuration.

---

##### `cdkDeps`<sup>Required</sup> <a name="cdkDeps" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkDeps"></a>

```java
public AwsCdkDeps getCdkDeps();
```

- *Type:* io.github.cdklabs.projen.awscdk.AwsCdkDeps

---

##### `cdkTasks`<sup>Required</sup> <a name="cdkTasks" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkTasks"></a>

```java
public CdkTasks getCdkTasks();
```

- *Type:* io.github.cdklabs.projen.awscdk.CdkTasks

Common CDK tasks.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.cdkVersion"></a>

```java
public java.lang.String getCdkVersion();
```

- *Type:* java.lang.String

The CDK version this app is using.

---

##### `testdir`<sup>Required</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.testdir"></a>

```java
public java.lang.String getTestdir();
```

- *Type:* java.lang.String

The directory in which the python tests reside.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>java.lang.String</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="aws-prototyping-sdk.pipeline.PDKPipelinePyProject.property.DEFAULT_TASK"></a>

```java
public java.lang.String getDefaultTask();
```

- *Type:* java.lang.String

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### PDKPipelineTsProject <a name="PDKPipelineTsProject" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject"></a>

Synthesizes a Typescript Project with a CI/CD pipeline.

#### Initializers <a name="Initializers" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer"></a>

```java
import software.aws.awsprototypingsdk.pipeline.PDKPipelineTsProject;

PDKPipelineTsProject.Builder.create()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
//  .allowLibraryDependencies(java.lang.Boolean)
//  .authorEmail(java.lang.String)
//  .authorName(java.lang.String)
//  .authorOrganization(java.lang.Boolean)
//  .authorUrl(java.lang.String)
//  .autoDetectBin(java.lang.Boolean)
//  .bin(java.util.Map<java.lang.String, java.lang.String>)
//  .bugsEmail(java.lang.String)
//  .bugsUrl(java.lang.String)
//  .bundledDeps(java.util.List<java.lang.String>)
//  .codeArtifactOptions(CodeArtifactOptions)
//  .deps(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .devDeps(java.util.List<java.lang.String>)
//  .entrypoint(java.lang.String)
//  .homepage(java.lang.String)
//  .keywords(java.util.List<java.lang.String>)
//  .license(java.lang.String)
//  .licensed(java.lang.Boolean)
//  .maxNodeVersion(java.lang.String)
//  .minNodeVersion(java.lang.String)
//  .npmAccess(NpmAccess)
//  .npmRegistry(java.lang.String)
//  .npmRegistryUrl(java.lang.String)
//  .npmTokenSecret(java.lang.String)
//  .packageManager(NodePackageManager)
//  .packageName(java.lang.String)
//  .peerDependencyOptions(PeerDependencyOptions)
//  .peerDeps(java.util.List<java.lang.String>)
//  .pnpmVersion(java.lang.String)
//  .repository(java.lang.String)
//  .repositoryDirectory(java.lang.String)
//  .scopedPackagesOptions(java.util.List<ScopedPackagesOptions>)
//  .scripts(java.util.Map<java.lang.String, java.lang.String>)
//  .stability(java.lang.String)
//  .jsiiReleaseVersion(java.lang.String)
//  .majorVersion(java.lang.Number)
//  .minMajorVersion(java.lang.Number)
//  .npmDistTag(java.lang.String)
//  .postBuildSteps(java.util.List<JobStep>)
//  .prerelease(java.lang.String)
//  .publishDryRun(java.lang.Boolean)
//  .publishTasks(java.lang.Boolean)
//  .releaseBranches(java.util.Map<java.lang.String, BranchOptions>)
//  .releaseEveryCommit(java.lang.Boolean)
//  .releaseFailureIssue(java.lang.Boolean)
//  .releaseFailureIssueLabel(java.lang.String)
//  .releaseSchedule(java.lang.String)
//  .releaseTagPrefix(java.lang.String)
//  .releaseTrigger(ReleaseTrigger)
//  .releaseWorkflowName(java.lang.String)
//  .releaseWorkflowSetupSteps(java.util.List<JobStep>)
//  .versionrcOptions(java.util.Map<java.lang.String, java.lang.Object>)
//  .workflowContainerImage(java.lang.String)
//  .workflowRunsOn(java.util.List<java.lang.String>)
    .defaultReleaseBranch(java.lang.String)
//  .artifactsDirectory(java.lang.String)
//  .autoApproveUpgrades(java.lang.Boolean)
//  .buildWorkflow(java.lang.Boolean)
//  .buildWorkflowTriggers(Triggers)
//  .bundlerOptions(BundlerOptions)
//  .codeCov(java.lang.Boolean)
//  .codeCovTokenSecret(java.lang.String)
//  .copyrightOwner(java.lang.String)
//  .copyrightPeriod(java.lang.String)
//  .dependabot(java.lang.Boolean)
//  .dependabotOptions(DependabotOptions)
//  .depsUpgrade(java.lang.Boolean)
//  .depsUpgradeOptions(UpgradeDependenciesOptions)
//  .gitignore(java.util.List<java.lang.String>)
//  .jest(java.lang.Boolean)
//  .jestOptions(JestOptions)
//  .mutableBuild(java.lang.Boolean)
//  .npmignore(java.util.List<java.lang.String>)
//  .npmignoreEnabled(java.lang.Boolean)
//  .npmIgnoreOptions(IgnoreFileOptions)
//  .package(java.lang.Boolean)
//  .prettier(java.lang.Boolean)
//  .prettierOptions(PrettierOptions)
//  .projenDevDependency(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenVersion(java.lang.String)
//  .pullRequestTemplate(java.lang.Boolean)
//  .pullRequestTemplateContents(java.util.List<java.lang.String>)
//  .release(java.lang.Boolean)
//  .releaseToNpm(java.lang.Boolean)
//  .releaseWorkflow(java.lang.Boolean)
//  .workflowBootstrapSteps(java.util.List<JobStep>)
//  .workflowGitIdentity(GitIdentity)
//  .workflowNodeVersion(java.lang.String)
//  .disableTsconfig(java.lang.Boolean)
//  .disableTsconfigDev(java.lang.Boolean)
//  .docgen(java.lang.Boolean)
//  .docsDirectory(java.lang.String)
//  .entrypointTypes(java.lang.String)
//  .eslint(java.lang.Boolean)
//  .eslintOptions(EslintOptions)
//  .libdir(java.lang.String)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcOptions)
//  .sampleCode(java.lang.Boolean)
//  .srcdir(java.lang.String)
//  .testdir(java.lang.String)
//  .tsconfig(TypescriptConfigOptions)
//  .tsconfigDev(TypescriptConfigOptions)
//  .tsconfigDevFile(java.lang.String)
//  .typescriptVersion(java.lang.String)
//  .buildCommand(java.lang.String)
//  .cdkout(java.lang.String)
//  .context(java.util.Map<java.lang.String, java.lang.Object>)
//  .featureFlags(java.lang.Boolean)
//  .requireApproval(ApprovalLevel)
//  .watchExcludes(java.util.List<java.lang.String>)
//  .watchIncludes(java.util.List<java.lang.String>)
    .cdkVersion(java.lang.String)
//  .cdkAssert(java.lang.Boolean)
//  .cdkAssertions(java.lang.Boolean)
//  .cdkDependencies(java.util.List<java.lang.String>)
//  .cdkDependenciesAsDeps(java.lang.Boolean)
//  .cdkTestDependencies(java.util.List<java.lang.String>)
//  .cdkVersionPinning(java.lang.Boolean)
//  .constructsVersion(java.lang.String)
//  .appEntrypoint(java.lang.String)
//  .edgeLambdaAutoDiscover(java.lang.Boolean)
//  .integrationTestAutoDiscover(java.lang.Boolean)
//  .lambdaAutoDiscover(java.lang.Boolean)
//  .lambdaExtensionAutoDiscover(java.lang.Boolean)
//  .lambdaOptions(LambdaFunctionCommonOptions)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>java.lang.Boolean</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorOrganization">authorOrganization</a></code> | <code>java.lang.Boolean</code> | Is the author an organization. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorUrl">authorUrl</a></code> | <code>java.lang.String</code> | Author's URL / Website. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoDetectBin">autoDetectBin</a></code> | <code>java.lang.Boolean</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bin">bin</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Binary programs vended with your module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bugsEmail">bugsEmail</a></code> | <code>java.lang.String</code> | The email address to which issues should be reported. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bugsUrl">bugsUrl</a></code> | <code>java.lang.String</code> | The url to your project's issue tracker. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bundledDeps">bundledDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dependencies to bundle into this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.codeArtifactOptions">codeArtifactOptions</a></code> | <code>io.github.cdklabs.projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | Runtime dependencies of this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.description">description</a></code> | <code>java.lang.String</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | Build dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.entrypoint">entrypoint</a></code> | <code>java.lang.String</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.homepage">homepage</a></code> | <code>java.lang.String</code> | Package's Homepage / Website. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.keywords">keywords</a></code> | <code>java.util.List<java.lang.String></code> | Keywords to include in `package.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.license">license</a></code> | <code>java.lang.String</code> | License's SPDX identifier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.licensed">licensed</a></code> | <code>java.lang.Boolean</code> | Indicates if a license should be added. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.maxNodeVersion">maxNodeVersion</a></code> | <code>java.lang.String</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.minNodeVersion">minNodeVersion</a></code> | <code>java.lang.String</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmAccess">npmAccess</a></code> | <code>io.github.cdklabs.projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmRegistry">npmRegistry</a></code> | <code>java.lang.String</code> | The host name of the npm registry to publish to. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmRegistryUrl">npmRegistryUrl</a></code> | <code>java.lang.String</code> | The base URL of the npm package registry. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmTokenSecret">npmTokenSecret</a></code> | <code>java.lang.String</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.packageManager">packageManager</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.packageName">packageName</a></code> | <code>java.lang.String</code> | The "name" in package.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.peerDependencyOptions">peerDependencyOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.peerDeps">peerDeps</a></code> | <code>java.util.List<java.lang.String></code> | Peer dependencies for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.pnpmVersion">pnpmVersion</a></code> | <code>java.lang.String</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.repository">repository</a></code> | <code>java.lang.String</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.repositoryDirectory">repositoryDirectory</a></code> | <code>java.lang.String</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.scopedPackagesOptions">scopedPackagesOptions</a></code> | <code>java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions></code> | Options for privately hosted scoped packages. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.scripts">scripts</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | npm scripts to include. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.stability">stability</a></code> | <code>java.lang.String</code> | Package's Stability. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.jsiiReleaseVersion">jsiiReleaseVersion</a></code> | <code>java.lang.String</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.majorVersion">majorVersion</a></code> | <code>java.lang.Number</code> | Major version to release from the default branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.minMajorVersion">minMajorVersion</a></code> | <code>java.lang.Number</code> | Minimal Major version to release. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmDistTag">npmDistTag</a></code> | <code>java.lang.String</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.postBuildSteps">postBuildSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.prerelease">prerelease</a></code> | <code>java.lang.String</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.publishDryRun">publishDryRun</a></code> | <code>java.lang.Boolean</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.publishTasks">publishTasks</a></code> | <code>java.lang.Boolean</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseBranches">releaseBranches</a></code> | <code>java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions></code> | Defines additional release branches. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseEveryCommit">releaseEveryCommit</a></code> | <code>java.lang.Boolean</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseFailureIssue">releaseFailureIssue</a></code> | <code>java.lang.Boolean</code> | Create a github issue on every failed publishing task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseFailureIssueLabel">releaseFailureIssueLabel</a></code> | <code>java.lang.String</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseSchedule">releaseSchedule</a></code> | <code>java.lang.String</code> | CRON schedule to trigger new releases. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseTagPrefix">releaseTagPrefix</a></code> | <code>java.lang.String</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseTrigger">releaseTrigger</a></code> | <code>io.github.cdklabs.projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseWorkflowName">releaseWorkflowName</a></code> | <code>java.lang.String</code> | The name of the default release workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseWorkflowSetupSteps">releaseWorkflowSetupSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.versionrcOptions">versionrcOptions</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowContainerImage">workflowContainerImage</a></code> | <code>java.lang.String</code> | Container image to use for GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowRunsOn">workflowRunsOn</a></code> | <code>java.util.List<java.lang.String></code> | Github Runner selection labels. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.defaultReleaseBranch">defaultReleaseBranch</a></code> | <code>java.lang.String</code> | The name of the main release branch. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.artifactsDirectory">artifactsDirectory</a></code> | <code>java.lang.String</code> | A directory which will contain build artifacts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoApproveUpgrades">autoApproveUpgrades</a></code> | <code>java.lang.Boolean</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.buildWorkflow">buildWorkflow</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.buildWorkflowTriggers">buildWorkflowTriggers</a></code> | <code>io.github.cdklabs.projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bundlerOptions">bundlerOptions</a></code> | <code>io.github.cdklabs.projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.codeCov">codeCov</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.codeCovTokenSecret">codeCovTokenSecret</a></code> | <code>java.lang.String</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.copyrightOwner">copyrightOwner</a></code> | <code>java.lang.String</code> | License copyright owner. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.copyrightPeriod">copyrightPeriod</a></code> | <code>java.lang.String</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.dependabot">dependabot</a></code> | <code>java.lang.Boolean</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.dependabotOptions">dependabotOptions</a></code> | <code>io.github.cdklabs.projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.depsUpgrade">depsUpgrade</a></code> | <code>java.lang.Boolean</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.depsUpgradeOptions">depsUpgradeOptions</a></code> | <code>io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitignore">gitignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.jest">jest</a></code> | <code>java.lang.Boolean</code> | Setup jest unit tests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.jestOptions">jestOptions</a></code> | <code>io.github.cdklabs.projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.mutableBuild">mutableBuild</a></code> | <code>java.lang.Boolean</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmignore">npmignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .npmignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmignoreEnabled">npmignoreEnabled</a></code> | <code>java.lang.Boolean</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmIgnoreOptions">npmIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.package">package</a></code> | <code>java.lang.Boolean</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.prettier">prettier</a></code> | <code>java.lang.Boolean</code> | Setup prettier. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.prettierOptions">prettierOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenDevDependency">projenDevDependency</a></code> | <code>java.lang.Boolean</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenVersion">projenVersion</a></code> | <code>java.lang.String</code> | Version of projen to install. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.pullRequestTemplate">pullRequestTemplate</a></code> | <code>java.lang.Boolean</code> | Include a GitHub pull request template. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.pullRequestTemplateContents">pullRequestTemplateContents</a></code> | <code>java.util.List<java.lang.String></code> | The contents of the pull request template. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.release">release</a></code> | <code>java.lang.Boolean</code> | Add release management to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseToNpm">releaseToNpm</a></code> | <code>java.lang.Boolean</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseWorkflow">releaseWorkflow</a></code> | <code>java.lang.Boolean</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowBootstrapSteps">workflowBootstrapSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowGitIdentity">workflowGitIdentity</a></code> | <code>io.github.cdklabs.projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowNodeVersion">workflowNodeVersion</a></code> | <code>java.lang.String</code> | The node version to use in GitHub workflows. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.disableTsconfig">disableTsconfig</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.disableTsconfigDev">disableTsconfigDev</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.docgen">docgen</a></code> | <code>java.lang.Boolean</code> | Docgen by Typedoc. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.docsDirectory">docsDirectory</a></code> | <code>java.lang.String</code> | Docs directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.entrypointTypes">entrypointTypes</a></code> | <code>java.lang.String</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.eslint">eslint</a></code> | <code>java.lang.Boolean</code> | Setup eslint. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.eslintOptions">eslintOptions</a></code> | <code>io.github.cdklabs.projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.libdir">libdir</a></code> | <code>java.lang.String</code> | Typescript  artifacts output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.sampleCode">sampleCode</a></code> | <code>java.lang.Boolean</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.srcdir">srcdir</a></code> | <code>java.lang.String</code> | Typescript sources directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.testdir">testdir</a></code> | <code>java.lang.String</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.tsconfig">tsconfig</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.tsconfigDev">tsconfigDev</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.tsconfigDevFile">tsconfigDevFile</a></code> | <code>java.lang.String</code> | The name of the development tsconfig.json file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.typescriptVersion">typescriptVersion</a></code> | <code>java.lang.String</code> | TypeScript version to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.buildCommand">buildCommand</a></code> | <code>java.lang.String</code> | A command to execute before synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkout">cdkout</a></code> | <code>java.lang.String</code> | cdk.out directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.context">context</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional context to include in `cdk.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.featureFlags">featureFlags</a></code> | <code>java.lang.Boolean</code> | Include all feature flags in cdk.json. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.requireApproval">requireApproval</a></code> | <code>io.github.cdklabs.projen.awscdk.ApprovalLevel</code> | To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.watchExcludes">watchExcludes</a></code> | <code>java.util.List<java.lang.String></code> | Glob patterns to exclude from `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.watchIncludes">watchIncludes</a></code> | <code>java.util.List<java.lang.String></code> | Glob patterns to include in `cdk watch`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkVersion">cdkVersion</a></code> | <code>java.lang.String</code> | Minimum version of the AWS CDK to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkAssert">cdkAssert</a></code> | <code>java.lang.Boolean</code> | Warning: NodeJS only. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkAssertions">cdkAssertions</a></code> | <code>java.lang.Boolean</code> | Install the assertions library? |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkDependencies">cdkDependencies</a></code> | <code>java.util.List<java.lang.String></code> | Which AWS CDKv1 modules this project requires. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkDependenciesAsDeps">cdkDependenciesAsDeps</a></code> | <code>java.lang.Boolean</code> | If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkTestDependencies">cdkTestDependencies</a></code> | <code>java.util.List<java.lang.String></code> | AWS CDK modules required for testing. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkVersionPinning">cdkVersionPinning</a></code> | <code>java.lang.Boolean</code> | Use pinned version instead of caret version for CDK. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.constructsVersion">constructsVersion</a></code> | <code>java.lang.String</code> | Minimum version of the `constructs` library to depend on. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.appEntrypoint">appEntrypoint</a></code> | <code>java.lang.String</code> | The CDK app's entrypoint (relative to the source directory, which is "src" by default). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.edgeLambdaAutoDiscover">edgeLambdaAutoDiscover</a></code> | <code>java.lang.Boolean</code> | Automatically adds an `cloudfront.experimental.EdgeFunction` for each `.edge-lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.integrationTestAutoDiscover">integrationTestAutoDiscover</a></code> | <code>java.lang.Boolean</code> | Automatically discovers and creates integration tests for each `.integ.ts` file in under your test directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.lambdaAutoDiscover">lambdaAutoDiscover</a></code> | <code>java.lang.Boolean</code> | Automatically adds an `awscdk.LambdaFunction` for each `.lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.lambdaExtensionAutoDiscover">lambdaExtensionAutoDiscover</a></code> | <code>java.lang.Boolean</code> | Automatically adds an `awscdk.LambdaExtension` for each `.lambda-extension.ts` entrypoint in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.lambdaOptions">lambdaOptions</a></code> | <code>io.github.cdklabs.projen.awscdk.LambdaFunctionCommonOptions</code> | Common options for all AWS Lambda functions. |

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.name"></a>

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.commitGenerated"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitOptions"></a>

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.logging"></a>

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.outdir"></a>

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.parent"></a>

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenCommand"></a>

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJson"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.renovatebot"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoMerge"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.clobber"></a>

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.devContainer"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.github"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.githubOptions"></a>

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitpod"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenCredentials"></a>

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.readme"></a>

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.stale"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.staleOptions"></a>

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.vscode"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allowLibraryDependencies`<sup>Optional</sup> <a name="allowLibraryDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.allowLibraryDependencies"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `authorEmail`<sup>Optional</sup> <a name="authorEmail" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorEmail"></a>

- *Type:* java.lang.String

Author's e-mail.

---

##### `authorName`<sup>Optional</sup> <a name="authorName" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorName"></a>

- *Type:* java.lang.String

Author's name.

---

##### `authorOrganization`<sup>Optional</sup> <a name="authorOrganization" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorOrganization"></a>

- *Type:* java.lang.Boolean

Is the author an organization.

---

##### `authorUrl`<sup>Optional</sup> <a name="authorUrl" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.authorUrl"></a>

- *Type:* java.lang.String

Author's URL / Website.

---

##### `autoDetectBin`<sup>Optional</sup> <a name="autoDetectBin" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoDetectBin"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bin"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugsEmail`<sup>Optional</sup> <a name="bugsEmail" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bugsEmail"></a>

- *Type:* java.lang.String

The email address to which issues should be reported.

---

##### `bugsUrl`<sup>Optional</sup> <a name="bugsUrl" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bugsUrl"></a>

- *Type:* java.lang.String

The url to your project's issue tracker.

---

##### `bundledDeps`<sup>Optional</sup> <a name="bundledDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bundledDeps"></a>

- *Type:* java.util.List<java.lang.String>

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `codeArtifactOptions`<sup>Optional</sup> <a name="codeArtifactOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.codeArtifactOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.deps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.description"></a>

- *Type:* java.lang.String

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.devDeps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.entrypoint"></a>

- *Type:* java.lang.String
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.homepage"></a>

- *Type:* java.lang.String

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.keywords"></a>

- *Type:* java.util.List<java.lang.String>

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.license"></a>

- *Type:* java.lang.String
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.licensed"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Indicates if a license should be added.

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.maxNodeVersion"></a>

- *Type:* java.lang.String
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.minNodeVersion"></a>

- *Type:* java.lang.String
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npmAccess`<sup>Optional</sup> <a name="npmAccess" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmAccess"></a>

- *Type:* io.github.cdklabs.projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npmRegistry`~~<sup>Optional</sup> <a name="npmRegistry" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

- *Type:* java.lang.String

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npmRegistryUrl`<sup>Optional</sup> <a name="npmRegistryUrl" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmRegistryUrl"></a>

- *Type:* java.lang.String
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npmTokenSecret`<sup>Optional</sup> <a name="npmTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmTokenSecret"></a>

- *Type:* java.lang.String
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `packageManager`<sup>Optional</sup> <a name="packageManager" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.packageManager"></a>

- *Type:* io.github.cdklabs.projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.packageName"></a>

- *Type:* java.lang.String
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peerDependencyOptions`<sup>Optional</sup> <a name="peerDependencyOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.peerDependencyOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peerDeps`<sup>Optional</sup> <a name="peerDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.peerDeps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpmVersion`<sup>Optional</sup> <a name="pnpmVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.pnpmVersion"></a>

- *Type:* java.lang.String
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.repository"></a>

- *Type:* java.lang.String

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repositoryDirectory`<sup>Optional</sup> <a name="repositoryDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.repositoryDirectory"></a>

- *Type:* java.lang.String

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scopedPackagesOptions`<sup>Optional</sup> <a name="scopedPackagesOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.scopedPackagesOptions"></a>

- *Type:* java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions>
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

- *Type:* java.util.Map<java.lang.String, java.lang.String>
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.stability"></a>

- *Type:* java.lang.String

Package's Stability.

---

##### `jsiiReleaseVersion`<sup>Optional</sup> <a name="jsiiReleaseVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.jsiiReleaseVersion"></a>

- *Type:* java.lang.String
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `majorVersion`<sup>Optional</sup> <a name="majorVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.majorVersion"></a>

- *Type:* java.lang.Number
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `minMajorVersion`<sup>Optional</sup> <a name="minMajorVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.minMajorVersion"></a>

- *Type:* java.lang.Number
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npmDistTag`<sup>Optional</sup> <a name="npmDistTag" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmDistTag"></a>

- *Type:* java.lang.String
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `postBuildSteps`<sup>Optional</sup> <a name="postBuildSteps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.postBuildSteps"></a>

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.prerelease"></a>

- *Type:* java.lang.String
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publishDryRun`<sup>Optional</sup> <a name="publishDryRun" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.publishDryRun"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publishTasks`<sup>Optional</sup> <a name="publishTasks" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.publishTasks"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `releaseBranches`<sup>Optional</sup> <a name="releaseBranches" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseBranches"></a>

- *Type:* java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions>
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`releaseEveryCommit`~~<sup>Optional</sup> <a name="releaseEveryCommit" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

- *Type:* java.lang.Boolean
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `releaseFailureIssue`<sup>Optional</sup> <a name="releaseFailureIssue" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseFailureIssue"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `releaseFailureIssueLabel`<sup>Optional</sup> <a name="releaseFailureIssueLabel" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseFailureIssueLabel"></a>

- *Type:* java.lang.String
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`releaseSchedule`~~<sup>Optional</sup> <a name="releaseSchedule" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

- *Type:* java.lang.String
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `releaseTagPrefix`<sup>Optional</sup> <a name="releaseTagPrefix" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseTagPrefix"></a>

- *Type:* java.lang.String
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `releaseTrigger`<sup>Optional</sup> <a name="releaseTrigger" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseTrigger"></a>

- *Type:* io.github.cdklabs.projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `releaseWorkflowName`<sup>Optional</sup> <a name="releaseWorkflowName" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseWorkflowName"></a>

- *Type:* java.lang.String
- *Default:* "Release"

The name of the default release workflow.

---

##### `releaseWorkflowSetupSteps`<sup>Optional</sup> <a name="releaseWorkflowSetupSteps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseWorkflowSetupSteps"></a>

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrcOptions`<sup>Optional</sup> <a name="versionrcOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.versionrcOptions"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflowContainerImage`<sup>Optional</sup> <a name="workflowContainerImage" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowContainerImage"></a>

- *Type:* java.lang.String
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflowRunsOn`<sup>Optional</sup> <a name="workflowRunsOn" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowRunsOn"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `defaultReleaseBranch`<sup>Required</sup> <a name="defaultReleaseBranch" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.defaultReleaseBranch"></a>

- *Type:* java.lang.String
- *Default:* "main"

The name of the main release branch.

---

##### `artifactsDirectory`<sup>Optional</sup> <a name="artifactsDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.artifactsDirectory"></a>

- *Type:* java.lang.String
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `autoApproveUpgrades`<sup>Optional</sup> <a name="autoApproveUpgrades" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.autoApproveUpgrades"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.buildWorkflow"></a>

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `buildWorkflowTriggers`<sup>Optional</sup> <a name="buildWorkflowTriggers" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.buildWorkflowTriggers"></a>

- *Type:* io.github.cdklabs.projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundlerOptions`<sup>Optional</sup> <a name="bundlerOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.bundlerOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `codeCov`<sup>Optional</sup> <a name="codeCov" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.codeCov"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with @codeCovTokenSecret.

---

##### `codeCovTokenSecret`<sup>Optional</sup> <a name="codeCovTokenSecret" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.codeCovTokenSecret"></a>

- *Type:* java.lang.String
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyrightOwner`<sup>Optional</sup> <a name="copyrightOwner" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.copyrightOwner"></a>

- *Type:* java.lang.String
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyrightPeriod`<sup>Optional</sup> <a name="copyrightPeriod" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.copyrightPeriod"></a>

- *Type:* java.lang.String
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.dependabot"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabotOptions`<sup>Optional</sup> <a name="dependabotOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.dependabotOptions"></a>

- *Type:* io.github.cdklabs.projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `depsUpgrade`<sup>Optional</sup> <a name="depsUpgrade" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.depsUpgrade"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `depsUpgradeOptions`<sup>Optional</sup> <a name="depsUpgradeOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.depsUpgradeOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.gitignore"></a>

- *Type:* java.util.List<java.lang.String>

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.jest"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Setup jest unit tests.

---

##### `jestOptions`<sup>Optional</sup> <a name="jestOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.jestOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutableBuild`<sup>Optional</sup> <a name="mutableBuild" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.mutableBuild"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

- *Type:* java.util.List<java.lang.String>

Additional entries to .npmignore.

---

##### `npmignoreEnabled`<sup>Optional</sup> <a name="npmignoreEnabled" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmignoreEnabled"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npmIgnoreOptions`<sup>Optional</sup> <a name="npmIgnoreOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.npmIgnoreOptions"></a>

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.package"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.prettier"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Setup prettier.

---

##### `prettierOptions`<sup>Optional</sup> <a name="prettierOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.prettierOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projenDevDependency`<sup>Optional</sup> <a name="projenDevDependency" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenDevDependency"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJs"></a>

- *Type:* java.lang.Boolean
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projenVersion`<sup>Optional</sup> <a name="projenVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenVersion"></a>

- *Type:* java.lang.String
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pullRequestTemplate`<sup>Optional</sup> <a name="pullRequestTemplate" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.pullRequestTemplate"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include a GitHub pull request template.

---

##### `pullRequestTemplateContents`<sup>Optional</sup> <a name="pullRequestTemplateContents" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.pullRequestTemplateContents"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.release"></a>

- *Type:* java.lang.Boolean
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `releaseToNpm`<sup>Optional</sup> <a name="releaseToNpm" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseToNpm"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`releaseWorkflow`~~<sup>Optional</sup> <a name="releaseWorkflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.releaseWorkflow"></a>

- *Deprecated:* see `release`.

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflowBootstrapSteps`<sup>Optional</sup> <a name="workflowBootstrapSteps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowBootstrapSteps"></a>

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflowGitIdentity`<sup>Optional</sup> <a name="workflowGitIdentity" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowGitIdentity"></a>

- *Type:* io.github.cdklabs.projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflowNodeVersion`<sup>Optional</sup> <a name="workflowNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.workflowNodeVersion"></a>

- *Type:* java.lang.String
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `disableTsconfig`<sup>Optional</sup> <a name="disableTsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.disableTsconfig"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disableTsconfigDev`<sup>Optional</sup> <a name="disableTsconfigDev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.disableTsconfigDev"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.docgen"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Docgen by Typedoc.

---

##### `docsDirectory`<sup>Optional</sup> <a name="docsDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.docsDirectory"></a>

- *Type:* java.lang.String
- *Default:* "docs"

Docs directory.

---

##### `entrypointTypes`<sup>Optional</sup> <a name="entrypointTypes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.entrypointTypes"></a>

- *Type:* java.lang.String
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.eslint"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Setup eslint.

---

##### `eslintOptions`<sup>Optional</sup> <a name="eslintOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.eslintOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.libdir"></a>

- *Type:* java.lang.String
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcTs"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sampleCode`<sup>Optional</sup> <a name="sampleCode" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.sampleCode"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.srcdir"></a>

- *Type:* java.lang.String
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.testdir"></a>

- *Type:* java.lang.String
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.tsconfig"></a>

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfigDev`<sup>Optional</sup> <a name="tsconfigDev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.tsconfigDev"></a>

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfigDevFile`<sup>Optional</sup> <a name="tsconfigDevFile" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.tsconfigDevFile"></a>

- *Type:* java.lang.String
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescriptVersion`<sup>Optional</sup> <a name="typescriptVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.typescriptVersion"></a>

- *Type:* java.lang.String
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `buildCommand`<sup>Optional</sup> <a name="buildCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.buildCommand"></a>

- *Type:* java.lang.String
- *Default:* no build command

A command to execute before synthesis.

This command will be called when
running `cdk synth` or when `cdk watch` identifies a change in your source
code before redeployment.

---

##### `cdkout`<sup>Optional</sup> <a name="cdkout" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkout"></a>

- *Type:* java.lang.String
- *Default:* "cdk.out"

cdk.out directory.

---

##### `context`<sup>Optional</sup> <a name="context" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.context"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* no additional context

Additional context to include in `cdk.json`.

---

##### `featureFlags`<sup>Optional</sup> <a name="featureFlags" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.featureFlags"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include all feature flags in cdk.json.

---

##### `requireApproval`<sup>Optional</sup> <a name="requireApproval" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.requireApproval"></a>

- *Type:* io.github.cdklabs.projen.awscdk.ApprovalLevel
- *Default:* ApprovalLevel.BROADENING

To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.

---

##### `watchExcludes`<sup>Optional</sup> <a name="watchExcludes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.watchExcludes"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Glob patterns to exclude from `cdk watch`.

---

##### `watchIncludes`<sup>Optional</sup> <a name="watchIncludes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.watchIncludes"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Glob patterns to include in `cdk watch`.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkVersion"></a>

- *Type:* java.lang.String
- *Default:* "2.1.0"

Minimum version of the AWS CDK to depend on.

---

##### ~~`cdkAssert`~~<sup>Optional</sup> <a name="cdkAssert" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkAssert"></a>

- *Deprecated:* The

- *Type:* java.lang.Boolean
- *Default:* will be included by default for AWS CDK >= 1.0.0 < 2.0.0

Warning: NodeJS only.

Install the @aws-cdk/assert library?

---

##### `cdkAssertions`<sup>Optional</sup> <a name="cdkAssertions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkAssertions"></a>

- *Type:* java.lang.Boolean
- *Default:* will be included by default for AWS CDK >= 1.111.0 < 2.0.0

Install the assertions library?

Only needed for CDK 1.x. If using CDK 2.x then
assertions is already included in 'aws-cdk-lib'

---

##### ~~`cdkDependencies`~~<sup>Optional</sup> <a name="cdkDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkDependencies"></a>

- *Deprecated:* For CDK 2.x use "deps" instead. (or "peerDeps" if you're building a library)

- *Type:* java.util.List<java.lang.String>

Which AWS CDKv1 modules this project requires.

---

##### ~~`cdkDependenciesAsDeps`~~<sup>Optional</sup> <a name="cdkDependenciesAsDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkDependenciesAsDeps"></a>

- *Deprecated:* Not supported in CDK v2.

- *Type:* java.lang.Boolean
- *Default:* true

If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).

This is to ensure that downstream consumers actually have your CDK dependencies installed
when using npm < 7 or yarn, where peer dependencies are not automatically installed.
If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
they are present during development.

Note: this setting only applies to construct library projects

---

##### ~~`cdkTestDependencies`~~<sup>Optional</sup> <a name="cdkTestDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkTestDependencies"></a>

- *Deprecated:* For CDK 2.x use 'devDeps' (in node.js projects) or 'testDeps' (in java projects) instead

- *Type:* java.util.List<java.lang.String>

AWS CDK modules required for testing.

---

##### `cdkVersionPinning`<sup>Optional</sup> <a name="cdkVersionPinning" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.cdkVersionPinning"></a>

- *Type:* java.lang.Boolean

Use pinned version instead of caret version for CDK.

You can use this to prevent mixed versions for your CDK dependencies and to prevent auto-updates.
If you use experimental features this will let you define the moment you include breaking changes.

---

##### `constructsVersion`<sup>Optional</sup> <a name="constructsVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.constructsVersion"></a>

- *Type:* java.lang.String
- *Default:* for CDK 1.x the default is "3.2.27", for CDK 2.x the default is "10.0.5".

Minimum version of the `constructs` library to depend on.

---

##### `appEntrypoint`<sup>Optional</sup> <a name="appEntrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.appEntrypoint"></a>

- *Type:* java.lang.String
- *Default:* "main.ts"

The CDK app's entrypoint (relative to the source directory, which is "src" by default).

---

##### `edgeLambdaAutoDiscover`<sup>Optional</sup> <a name="edgeLambdaAutoDiscover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.edgeLambdaAutoDiscover"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically adds an `cloudfront.experimental.EdgeFunction` for each `.edge-lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `integrationTestAutoDiscover`<sup>Optional</sup> <a name="integrationTestAutoDiscover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.integrationTestAutoDiscover"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically discovers and creates integration tests for each `.integ.ts` file in under your test directory.

---

##### `lambdaAutoDiscover`<sup>Optional</sup> <a name="lambdaAutoDiscover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.lambdaAutoDiscover"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically adds an `awscdk.LambdaFunction` for each `.lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `lambdaExtensionAutoDiscover`<sup>Optional</sup> <a name="lambdaExtensionAutoDiscover" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.lambdaExtensionAutoDiscover"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically adds an `awscdk.LambdaExtension` for each `.lambda-extension.ts` entrypoint in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.

---

##### `lambdaOptions`<sup>Optional</sup> <a name="lambdaOptions" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.Initializer.parameter.lambdaOptions"></a>

- *Type:* io.github.cdklabs.projen.awscdk.LambdaFunctionCommonOptions
- *Default:* default options

Common options for all AWS Lambda functions.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBins">addBins</a></code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBundledDeps">addBundledDeps</a></code> | Defines bundled dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCompileCommand">addCompileCommand</a></code> | DEPRECATED. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDeps">addDeps</a></code> | Defines normal dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDevDeps">addDevDeps</a></code> | Defines development/test dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addFields">addFields</a></code> | Directly set fields in `package.json`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addKeywords">addKeywords</a></code> | Adds keywords to package.json (deduplicated). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPeerDeps">addPeerDeps</a></code> | Defines peer dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addScripts">addScripts</a></code> | Replaces the contents of multiple npm package.json scripts. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTestCommand">addTestCommand</a></code> | DEPRECATED. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.hasScript">hasScript</a></code> | Indicates if a script by the name name is defined. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeScript">removeScript</a></code> | Removes the npm script (always successful). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.renderWorkflowSetup">renderWorkflowSetup</a></code> | Returns the set of workflow steps which should be executed to bootstrap a workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.setScript">setScript</a></code> | Replaces the contents of an npm package.json script. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCdkDependency">addCdkDependency</a></code> | Adds an AWS CDK module dependencies. |

---

##### `addExcludeFromCleanup` <a name="addExcludeFromCleanup" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addExcludeFromCleanup"></a>

```java
public void addExcludeFromCleanup(java.lang.String globs)
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* java.lang.String

The glob patterns to match.

---

##### `addGitIgnore` <a name="addGitIgnore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addGitIgnore"></a>

```java
public void addGitIgnore(java.lang.String pattern)
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addGitIgnore.parameter.pattern"></a>

- *Type:* java.lang.String

The glob pattern to ignore.

---

##### `addPackageIgnore` <a name="addPackageIgnore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPackageIgnore"></a>

```java
public void addPackageIgnore(java.lang.String pattern)
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `pattern`<sup>Required</sup> <a name="pattern" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPackageIgnore.parameter.pattern"></a>

- *Type:* java.lang.String

---

##### `addTask` <a name="addTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask"></a>

```java
public Task addTask(java.lang.String name)
public Task addTask(java.lang.String name, TaskOptions props)
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.name"></a>

- *Type:* java.lang.String

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTask.parameter.props"></a>

- *Type:* io.github.cdklabs.projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTip"></a>

```java
public void addTip(java.lang.String message)
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTip.parameter.message"></a>

- *Type:* java.lang.String

The message.

---

##### `annotateGenerated` <a name="annotateGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.annotateGenerated"></a>

```java
public void annotateGenerated(java.lang.String glob)
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.annotateGenerated.parameter.glob"></a>

- *Type:* java.lang.String

the glob pattern to match (could be a file path).

---

##### `postSynthesize` <a name="postSynthesize" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.postSynthesize"></a>

```java
public void postSynthesize()
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### `preSynthesize` <a name="preSynthesize" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.preSynthesize"></a>

```java
public void preSynthesize()
```

Called before all components are synthesized.

##### `removeTask` <a name="removeTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeTask"></a>

```java
public Task removeTask(java.lang.String name)
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeTask.parameter.name"></a>

- *Type:* java.lang.String

The name of the task to remove.

---

##### `runTaskCommand` <a name="runTaskCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.runTaskCommand"></a>

```java
public java.lang.String runTaskCommand(Task task)
```

Returns the shell command to execute in order to run a task.

This will
typically be `npx projen TASK`.

###### `task`<sup>Required</sup> <a name="task" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.runTaskCommand.parameter.task"></a>

- *Type:* io.github.cdklabs.projen.Task

The task for which the command is required.

---

##### `synth` <a name="synth" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.synth"></a>

```java
public void synth()
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### `tryFindFile` <a name="tryFindFile" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindFile"></a>

```java
public FileBase tryFindFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindJsonFile"></a>

```java
public JsonFile tryFindJsonFile(java.lang.String filePath)
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### `tryFindObjectFile` <a name="tryFindObjectFile" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindObjectFile"></a>

```java
public ObjectFile tryFindObjectFile(java.lang.String filePath)
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### `tryRemoveFile` <a name="tryRemoveFile" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryRemoveFile"></a>

```java
public FileBase tryRemoveFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### `addBins` <a name="addBins" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBins"></a>

```java
public void addBins(java.util.Map<java.lang.String, java.lang.String> bins)
```

###### `bins`<sup>Required</sup> <a name="bins" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBins.parameter.bins"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### `addBundledDeps` <a name="addBundledDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBundledDeps"></a>

```java
public void addBundledDeps(java.lang.String deps)
```

Defines bundled dependencies.

Bundled dependencies will be added as normal dependencies as well as to the
`bundledDependencies` section of your `package.json`.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addBundledDeps.parameter.deps"></a>

- *Type:* java.lang.String

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addCompileCommand`~~ <a name="addCompileCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCompileCommand"></a>

```java
public void addCompileCommand(java.lang.String commands)
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCompileCommand.parameter.commands"></a>

- *Type:* java.lang.String

---

##### `addDeps` <a name="addDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDeps"></a>

```java
public void addDeps(java.lang.String deps)
```

Defines normal dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDeps.parameter.deps"></a>

- *Type:* java.lang.String

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `addDevDeps` <a name="addDevDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDevDeps"></a>

```java
public void addDevDeps(java.lang.String deps)
```

Defines development/test dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addDevDeps.parameter.deps"></a>

- *Type:* java.lang.String

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `addFields` <a name="addFields" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addFields"></a>

```java
public void addFields(java.util.Map<java.lang.String, java.lang.Object> fields)
```

Directly set fields in `package.json`.

###### `fields`<sup>Required</sup> <a name="fields" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addFields.parameter.fields"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>

The fields to set.

---

##### `addKeywords` <a name="addKeywords" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addKeywords"></a>

```java
public void addKeywords(java.lang.String keywords)
```

Adds keywords to package.json (deduplicated).

###### `keywords`<sup>Required</sup> <a name="keywords" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addKeywords.parameter.keywords"></a>

- *Type:* java.lang.String

The keywords to add.

---

##### `addPeerDeps` <a name="addPeerDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPeerDeps"></a>

```java
public void addPeerDeps(java.lang.String deps)
```

Defines peer dependencies.

When adding peer dependencies, a devDependency will also be added on the
pinned version of the declared peer. This will ensure that you are testing
your code against the minimum version required from your consumers.

###### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addPeerDeps.parameter.deps"></a>

- *Type:* java.lang.String

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### `addScripts` <a name="addScripts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addScripts"></a>

```java
public void addScripts(java.util.Map<java.lang.String, java.lang.String> scripts)
```

Replaces the contents of multiple npm package.json scripts.

###### `scripts`<sup>Required</sup> <a name="scripts" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addScripts.parameter.scripts"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The scripts to set.

---

##### ~~`addTestCommand`~~ <a name="addTestCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTestCommand"></a>

```java
public void addTestCommand(java.lang.String commands)
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addTestCommand.parameter.commands"></a>

- *Type:* java.lang.String

---

##### ~~`hasScript`~~ <a name="hasScript" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.hasScript"></a>

```java
public java.lang.Boolean hasScript(java.lang.String name)
```

Indicates if a script by the name name is defined.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.hasScript.parameter.name"></a>

- *Type:* java.lang.String

The name of the script.

---

##### `removeScript` <a name="removeScript" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeScript"></a>

```java
public void removeScript(java.lang.String name)
```

Removes the npm script (always successful).

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.removeScript.parameter.name"></a>

- *Type:* java.lang.String

The name of the script.

---

##### `renderWorkflowSetup` <a name="renderWorkflowSetup" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.renderWorkflowSetup"></a>

```java
public java.util.List<JobStep> renderWorkflowSetup()
public java.util.List<JobStep> renderWorkflowSetup(RenderWorkflowSetupOptions options)
```

Returns the set of workflow steps which should be executed to bootstrap a workflow.

###### `options`<sup>Optional</sup> <a name="options" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.renderWorkflowSetup.parameter.options"></a>

- *Type:* io.github.cdklabs.projen.javascript.RenderWorkflowSetupOptions

Options.

---

##### `setScript` <a name="setScript" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.setScript"></a>

```java
public void setScript(java.lang.String name, java.lang.String command)
```

Replaces the contents of an npm package.json script.

###### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.setScript.parameter.name"></a>

- *Type:* java.lang.String

The script name.

---

###### `command`<sup>Required</sup> <a name="command" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.setScript.parameter.command"></a>

- *Type:* java.lang.String

The command to execute.

---

##### `addCdkDependency` <a name="addCdkDependency" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCdkDependency"></a>

```java
public void addCdkDependency(java.lang.String modules)
```

Adds an AWS CDK module dependencies.

###### `modules`<sup>Required</sup> <a name="modules" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.addCdkDependency.parameter.modules"></a>

- *Type:* java.lang.String

The list of modules to depend on.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildTask">buildTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.compileTask">compileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.components">components</a></code> | <code>java.util.List<io.github.cdklabs.projen.Component></code> | Returns all the components within this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.deps">deps</a></code> | <code>io.github.cdklabs.projen.Dependencies</code> | Project dependencies. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.ejected">ejected</a></code> | <code>java.lang.Boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.files">files</a></code> | <code>java.util.List<io.github.cdklabs.projen.FileBase></code> | All files in this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitattributes">gitattributes</a></code> | <code>io.github.cdklabs.projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitignore">gitignore</a></code> | <code>io.github.cdklabs.projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.logger">logger</a></code> | <code>io.github.cdklabs.projen.Logger</code> | Logging utilities. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.name">name</a></code> | <code>java.lang.String</code> | Project name. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.outdir">outdir</a></code> | <code>java.lang.String</code> | Absolute output directory of this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.packageTask">packageTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.postCompileTask">postCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.preCompileTask">preCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projectBuild">projectBuild</a></code> | <code>io.github.cdklabs.projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The command to use in order to run the projen CLI. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.root">root</a></code> | <code>io.github.cdklabs.projen.Project</code> | The root project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tasks">tasks</a></code> | <code>io.github.cdklabs.projen.Tasks</code> | Project tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.testTask">testTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.defaultTask">defaultTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.initProject">initProject</a></code> | <code>io.github.cdklabs.projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | A parent project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.autoApprove">autoApprove</a></code> | <code>io.github.cdklabs.projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.devContainer">devContainer</a></code> | <code>io.github.cdklabs.projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.github">github</a></code> | <code>io.github.cdklabs.projen.github.GitHub</code> | Access all github components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitpod">gitpod</a></code> | <code>io.github.cdklabs.projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.vscode">vscode</a></code> | <code>io.github.cdklabs.projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>java.lang.Boolean</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.artifactsDirectory">artifactsDirectory</a></code> | <code>java.lang.String</code> | The build output directory. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.artifactsJavascriptDirectory">artifactsJavascriptDirectory</a></code> | <code>java.lang.String</code> | The location of the npm tarball after build (`${artifactsDirectory}/js`). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.bundler">bundler</a></code> | <code>io.github.cdklabs.projen.javascript.Bundler</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.entrypoint">entrypoint</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.manifest">manifest</a></code> | <code>java.lang.Object</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.npmrc">npmrc</a></code> | <code>io.github.cdklabs.projen.javascript.NpmConfig</code> | The .npmrc file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.package">package</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackage</code> | API for managing the node package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.packageManager">packageManager</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackageManager</code> | The package manager to use. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.runScriptCommand">runScriptCommand</a></code> | <code>java.lang.String</code> | The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.autoMerge">autoMerge</a></code> | <code>io.github.cdklabs.projen.github.AutoMerge</code> | Component that sets up mergify for merging approved pull requests. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildWorkflow">buildWorkflow</a></code> | <code>io.github.cdklabs.projen.build.BuildWorkflow</code> | The PR build GitHub workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildWorkflowJobId">buildWorkflowJobId</a></code> | <code>java.lang.String</code> | The job ID of the build workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.jest">jest</a></code> | <code>io.github.cdklabs.projen.javascript.Jest</code> | The Jest configuration (if enabled). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.maxNodeVersion">maxNodeVersion</a></code> | <code>java.lang.String</code> | Maximum node version required by this package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.minNodeVersion">minNodeVersion</a></code> | <code>java.lang.String</code> | Minimum node.js version required by this package. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.npmignore">npmignore</a></code> | <code>io.github.cdklabs.projen.IgnoreFile</code> | The .npmignore file. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.prettier">prettier</a></code> | <code>io.github.cdklabs.projen.javascript.Prettier</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.publisher">publisher</a></code> | <code>io.github.cdklabs.projen.release.Publisher</code> | Package publisher. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.release">release</a></code> | <code>io.github.cdklabs.projen.release.Release</code> | Release management. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.upgradeWorkflow">upgradeWorkflow</a></code> | <code>io.github.cdklabs.projen.javascript.UpgradeDependencies</code> | The upgrade workflow. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.docsDirectory">docsDirectory</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.libdir">libdir</a></code> | <code>java.lang.String</code> | The directory in which compiled .js files reside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.srcdir">srcdir</a></code> | <code>java.lang.String</code> | The directory in which the .ts sources reside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.testdir">testdir</a></code> | <code>java.lang.String</code> | The directory in which tests reside. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfigDev">tsconfigDev</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfig</code> | A typescript configuration file which covers all files (sources, tests, projen). |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.watchTask">watchTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | The "watch" task. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.docgen">docgen</a></code> | <code>java.lang.Boolean</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.eslint">eslint</a></code> | <code>io.github.cdklabs.projen.javascript.Eslint</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfig">tsconfig</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfigEslint">tsconfigEslint</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.appEntrypoint">appEntrypoint</a></code> | <code>java.lang.String</code> | The CDK app entrypoint. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkConfig">cdkConfig</a></code> | <code>io.github.cdklabs.projen.awscdk.CdkConfig</code> | cdk.json configuration. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkDeps">cdkDeps</a></code> | <code>io.github.cdklabs.projen.awscdk.AwsCdkDeps</code> | *No description.* |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkTasks">cdkTasks</a></code> | <code>io.github.cdklabs.projen.awscdk.CdkTasks</code> | Common CDK tasks. |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkVersion">cdkVersion</a></code> | <code>java.lang.String</code> | The CDK version this app is using. |

---

##### `buildTask`<sup>Required</sup> <a name="buildTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildTask"></a>

```java
public Task getBuildTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `commitGenerated`<sup>Required</sup> <a name="commitGenerated" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean

Whether to commit the managed files by default.

---

##### `compileTask`<sup>Required</sup> <a name="compileTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.compileTask"></a>

```java
public Task getCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `components`<sup>Required</sup> <a name="components" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.components"></a>

```java
public java.util.List<Component> getComponents();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Component>

Returns all the components within this project.

---

##### `deps`<sup>Required</sup> <a name="deps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.deps"></a>

```java
public Dependencies getDeps();
```

- *Type:* io.github.cdklabs.projen.Dependencies

Project dependencies.

---

##### `ejected`<sup>Required</sup> <a name="ejected" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.ejected"></a>

```java
public java.lang.Boolean getEjected();
```

- *Type:* java.lang.Boolean

Whether or not the project is being ejected.

---

##### `files`<sup>Required</sup> <a name="files" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.files"></a>

```java
public java.util.List<FileBase> getFiles();
```

- *Type:* java.util.List<io.github.cdklabs.projen.FileBase>

All files in this project.

---

##### `gitattributes`<sup>Required</sup> <a name="gitattributes" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitattributes"></a>

```java
public GitAttributesFile getGitattributes();
```

- *Type:* io.github.cdklabs.projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### `gitignore`<sup>Required</sup> <a name="gitignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitignore"></a>

```java
public IgnoreFile getGitignore();
```

- *Type:* io.github.cdklabs.projen.IgnoreFile

.gitignore.

---

##### `logger`<sup>Required</sup> <a name="logger" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.logger"></a>

```java
public Logger getLogger();
```

- *Type:* io.github.cdklabs.projen.Logger

Logging utilities.

---

##### `name`<sup>Required</sup> <a name="name" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

Project name.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String

Absolute output directory of this project.

---

##### `packageTask`<sup>Required</sup> <a name="packageTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.packageTask"></a>

```java
public Task getPackageTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `postCompileTask`<sup>Required</sup> <a name="postCompileTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.postCompileTask"></a>

```java
public Task getPostCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `preCompileTask`<sup>Required</sup> <a name="preCompileTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.preCompileTask"></a>

```java
public Task getPreCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `projectBuild`<sup>Required</sup> <a name="projectBuild" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projectBuild"></a>

```java
public ProjectBuild getProjectBuild();
```

- *Type:* io.github.cdklabs.projen.ProjectBuild

Manages the build process of the project.

---

##### `projenCommand`<sup>Required</sup> <a name="projenCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String

The command to use in order to run the projen CLI.

---

##### `root`<sup>Required</sup> <a name="root" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.root"></a>

```java
public Project getRoot();
```

- *Type:* io.github.cdklabs.projen.Project

The root project.

---

##### `tasks`<sup>Required</sup> <a name="tasks" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tasks"></a>

```java
public Tasks getTasks();
```

- *Type:* io.github.cdklabs.projen.Tasks

Project tasks.

---

##### `testTask`<sup>Required</sup> <a name="testTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.testTask"></a>

```java
public Task getTestTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### `defaultTask`<sup>Optional</sup> <a name="defaultTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.defaultTask"></a>

```java
public Task getDefaultTask();
```

- *Type:* io.github.cdklabs.projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### `initProject`<sup>Optional</sup> <a name="initProject" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.initProject"></a>

```java
public InitProject getInitProject();
```

- *Type:* io.github.cdklabs.projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

A parent project.

If undefined, this is the root project.

---

##### `projectType`<sup>Required</sup> <a name="projectType" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.projectType"></a>

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType

---

##### `autoApprove`<sup>Optional</sup> <a name="autoApprove" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.autoApprove"></a>

```java
public AutoApprove getAutoApprove();
```

- *Type:* io.github.cdklabs.projen.github.AutoApprove

Auto approve set up for this project.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.devContainer"></a>

```java
public DevContainer getDevContainer();
```

- *Type:* io.github.cdklabs.projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### `github`<sup>Optional</sup> <a name="github" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.github"></a>

```java
public GitHub getGithub();
```

- *Type:* io.github.cdklabs.projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.gitpod"></a>

```java
public Gitpod getGitpod();
```

- *Type:* io.github.cdklabs.projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.vscode"></a>

```java
public VsCode getVscode();
```

- *Type:* io.github.cdklabs.projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`allowLibraryDependencies`~~<sup>Required</sup> <a name="allowLibraryDependencies" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.allowLibraryDependencies"></a>

- *Deprecated:* use `package.allowLibraryDependencies`

```java
public java.lang.Boolean getAllowLibraryDependencies();
```

- *Type:* java.lang.Boolean

---

##### `artifactsDirectory`<sup>Required</sup> <a name="artifactsDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.artifactsDirectory"></a>

```java
public java.lang.String getArtifactsDirectory();
```

- *Type:* java.lang.String

The build output directory.

An npm tarball will be created under the `js`
subdirectory. For example, if this is set to `dist` (the default), the npm
tarball will be placed under `dist/js/boom-boom-1.2.3.tg`.

---

##### `artifactsJavascriptDirectory`<sup>Required</sup> <a name="artifactsJavascriptDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.artifactsJavascriptDirectory"></a>

```java
public java.lang.String getArtifactsJavascriptDirectory();
```

- *Type:* java.lang.String

The location of the npm tarball after build (`${artifactsDirectory}/js`).

---

##### `bundler`<sup>Required</sup> <a name="bundler" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.bundler"></a>

```java
public Bundler getBundler();
```

- *Type:* io.github.cdklabs.projen.javascript.Bundler

---

##### ~~`entrypoint`~~<sup>Required</sup> <a name="entrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.entrypoint"></a>

- *Deprecated:* use `package.entrypoint`

```java
public java.lang.String getEntrypoint();
```

- *Type:* java.lang.String

---

##### ~~`manifest`~~<sup>Required</sup> <a name="manifest" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.manifest"></a>

- *Deprecated:* use `package.addField(x, y)`

```java
public java.lang.Object getManifest();
```

- *Type:* java.lang.Object

---

##### `npmrc`<sup>Required</sup> <a name="npmrc" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.npmrc"></a>

```java
public NpmConfig getNpmrc();
```

- *Type:* io.github.cdklabs.projen.javascript.NpmConfig

The .npmrc file.

---

##### `package`<sup>Required</sup> <a name="package" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.package"></a>

```java
public NodePackage getPackage();
```

- *Type:* io.github.cdklabs.projen.javascript.NodePackage

API for managing the node package.

---

##### ~~`packageManager`~~<sup>Required</sup> <a name="packageManager" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.packageManager"></a>

- *Deprecated:* use `package.packageManager`

```java
public NodePackageManager getPackageManager();
```

- *Type:* io.github.cdklabs.projen.javascript.NodePackageManager

The package manager to use.

---

##### `runScriptCommand`<sup>Required</sup> <a name="runScriptCommand" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.runScriptCommand"></a>

```java
public java.lang.String getRunScriptCommand();
```

- *Type:* java.lang.String

The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager).

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.autoMerge"></a>

```java
public AutoMerge getAutoMerge();
```

- *Type:* io.github.cdklabs.projen.github.AutoMerge

Component that sets up mergify for merging approved pull requests.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildWorkflow"></a>

```java
public BuildWorkflow getBuildWorkflow();
```

- *Type:* io.github.cdklabs.projen.build.BuildWorkflow

The PR build GitHub workflow.

`undefined` if `buildWorkflow` is disabled.

---

##### `buildWorkflowJobId`<sup>Optional</sup> <a name="buildWorkflowJobId" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.buildWorkflowJobId"></a>

```java
public java.lang.String getBuildWorkflowJobId();
```

- *Type:* java.lang.String

The job ID of the build workflow.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.jest"></a>

```java
public Jest getJest();
```

- *Type:* io.github.cdklabs.projen.javascript.Jest

The Jest configuration (if enabled).

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.maxNodeVersion"></a>

```java
public java.lang.String getMaxNodeVersion();
```

- *Type:* java.lang.String

Maximum node version required by this package.

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.minNodeVersion"></a>

```java
public java.lang.String getMinNodeVersion();
```

- *Type:* java.lang.String

Minimum node.js version required by this package.

---

##### `npmignore`<sup>Optional</sup> <a name="npmignore" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.npmignore"></a>

```java
public IgnoreFile getNpmignore();
```

- *Type:* io.github.cdklabs.projen.IgnoreFile

The .npmignore file.

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.prettier"></a>

```java
public Prettier getPrettier();
```

- *Type:* io.github.cdklabs.projen.javascript.Prettier

---

##### ~~`publisher`~~<sup>Optional</sup> <a name="publisher" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.publisher"></a>

- *Deprecated:* use `release.publisher`.

```java
public Publisher getPublisher();
```

- *Type:* io.github.cdklabs.projen.release.Publisher

Package publisher.

This will be `undefined` if the project does not have a
release workflow.

---

##### `release`<sup>Optional</sup> <a name="release" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.release"></a>

```java
public Release getRelease();
```

- *Type:* io.github.cdklabs.projen.release.Release

Release management.

---

##### `upgradeWorkflow`<sup>Optional</sup> <a name="upgradeWorkflow" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.upgradeWorkflow"></a>

```java
public UpgradeDependencies getUpgradeWorkflow();
```

- *Type:* io.github.cdklabs.projen.javascript.UpgradeDependencies

The upgrade workflow.

---

##### `docsDirectory`<sup>Required</sup> <a name="docsDirectory" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.docsDirectory"></a>

```java
public java.lang.String getDocsDirectory();
```

- *Type:* java.lang.String

---

##### `libdir`<sup>Required</sup> <a name="libdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.libdir"></a>

```java
public java.lang.String getLibdir();
```

- *Type:* java.lang.String

The directory in which compiled .js files reside.

---

##### `srcdir`<sup>Required</sup> <a name="srcdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.srcdir"></a>

```java
public java.lang.String getSrcdir();
```

- *Type:* java.lang.String

The directory in which the .ts sources reside.

---

##### `testdir`<sup>Required</sup> <a name="testdir" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.testdir"></a>

```java
public java.lang.String getTestdir();
```

- *Type:* java.lang.String

The directory in which tests reside.

---

##### `tsconfigDev`<sup>Required</sup> <a name="tsconfigDev" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfigDev"></a>

```java
public TypescriptConfig getTsconfigDev();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfig

A typescript configuration file which covers all files (sources, tests, projen).

---

##### `watchTask`<sup>Required</sup> <a name="watchTask" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.watchTask"></a>

```java
public Task getWatchTask();
```

- *Type:* io.github.cdklabs.projen.Task

The "watch" task.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.docgen"></a>

```java
public java.lang.Boolean getDocgen();
```

- *Type:* java.lang.Boolean

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.eslint"></a>

```java
public Eslint getEslint();
```

- *Type:* io.github.cdklabs.projen.javascript.Eslint

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfig"></a>

```java
public TypescriptConfig getTsconfig();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfig

---

##### `tsconfigEslint`<sup>Optional</sup> <a name="tsconfigEslint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.tsconfigEslint"></a>

```java
public TypescriptConfig getTsconfigEslint();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfig

---

##### `appEntrypoint`<sup>Required</sup> <a name="appEntrypoint" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.appEntrypoint"></a>

```java
public java.lang.String getAppEntrypoint();
```

- *Type:* java.lang.String

The CDK app entrypoint.

---

##### `cdkConfig`<sup>Required</sup> <a name="cdkConfig" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkConfig"></a>

```java
public CdkConfig getCdkConfig();
```

- *Type:* io.github.cdklabs.projen.awscdk.CdkConfig

cdk.json configuration.

---

##### `cdkDeps`<sup>Required</sup> <a name="cdkDeps" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkDeps"></a>

```java
public AwsCdkDeps getCdkDeps();
```

- *Type:* io.github.cdklabs.projen.awscdk.AwsCdkDeps

---

##### `cdkTasks`<sup>Required</sup> <a name="cdkTasks" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkTasks"></a>

```java
public CdkTasks getCdkTasks();
```

- *Type:* io.github.cdklabs.projen.awscdk.CdkTasks

Common CDK tasks.

---

##### `cdkVersion`<sup>Required</sup> <a name="cdkVersion" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.cdkVersion"></a>

```java
public java.lang.String getCdkVersion();
```

- *Type:* java.lang.String

The CDK version this app is using.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>java.lang.String</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### `DEFAULT_TASK`<sup>Required</sup> <a name="DEFAULT_TASK" id="aws-prototyping-sdk.pipeline.PDKPipelineTsProject.property.DEFAULT_TASK"></a>

```java
public java.lang.String getDefaultTask();
```

- *Type:* java.lang.String

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---


