"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const project_configuration_1 = require("nx/src/generators/utils/project-configuration");
const string_change_1 = require("../../utils/string-change");
const path_1 = require("path");
const tsquery_1 = require("@phenomnomnominal/tsquery");
const visit_not_ignored_files_1 = require("../../generators/visit-not-ignored-files");
const devkit_1 = require("@nrwl/devkit");
function update(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        for (const [project, { root }] of (0, project_configuration_1.getProjects)(tree)) {
            (0, visit_not_ignored_files_1.visitNotIgnoredFiles)(tree, root, (filePath) => {
                if ((0, path_1.extname)(filePath) === '.ts') {
                    let changed = false;
                    let file = tree.read(filePath).toString();
                    // Need to import createTreeWithEmptyV1Workspace, and use it instead
                    if (file.includes('createTreeWithEmptyWorkspace(1)') ||
                        file.includes('createTreeWithEmptyWorkspace()')) {
                        changed = true;
                        file = file.replace(/createTreeWithEmptyWorkspace\(1\)/g, 'createTreeWithEmptyV1Workspace()');
                        file = file.replace(/createTreeWithEmptyWorkspace\(\)/g, 'createTreeWithEmptyV1Workspace()');
                        // Was only using v1, simple string replace updates imports.
                        if (!file.includes('createTreeWithEmptyWorkspace(2)')) {
                            file = file.replace('createTreeWithEmptyWorkspace', 'createTreeWithEmptyV1Workspace');
                        }
                        else {
                            const changes = [];
                            const ast = tsquery_1.tsquery.ast(file);
                            const importDeclarations = (0, tsquery_1.tsquery)(ast, 'ImportDeclaration[moduleSpecifier.text="@nrwl/devkit/testing"]');
                            for (const declaration of importDeclarations) {
                                const namedImports = (0, tsquery_1.tsquery)(declaration, 'NamedImports ImportSpecifier');
                                if (namedImports.length) {
                                    const firstImport = namedImports[0].pos;
                                    changes.push({
                                        type: string_change_1.ChangeType.Insert,
                                        index: firstImport,
                                        text: ' createTreeWithEmptyV1Workspace,',
                                    });
                                    break;
                                }
                            }
                            file = (0, string_change_1.applyChangesToString)(file, changes);
                        }
                    }
                    // Replace all instances with param set to 2, to version w/o param
                    if (file.includes('createTreeWithEmptyWorkspace(2)')) {
                        file = file.replace(/createTreeWithEmptyWorkspace\(2\)/g, 'createTreeWithEmptyWorkspace()');
                        changed = true;
                    }
                    if (changed) {
                        tree.write(filePath, file);
                    }
                }
            });
        }
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.default = update;
//# sourceMappingURL=split-create-empty-tree.js.map