"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipelineJavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const path = require("path");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
/**
 * Synthesizes a Java Project with a CI/CD pipeline.
 *
 * @pjid pdk-pipeline-java
 */
class PDKPipelineJavaProject extends awscdk_1.AwsCdkJavaApp {
    constructor(options) {
        super({
            sample: false,
            junit: false,
            ...options,
            mainClass: options.mainClass !== "org.acme.MyApp"
                ? options.mainClass
                : 'software.aws.Pipeline -Dexec.classpathScope="test"',
        });
        this.addDependency("software.aws.awsprototypingsdk/aws-prototyping-sdk@^0");
        this.testTask.exec("mvn test");
        this.addTestDependency("org.junit.jupiter/junit-jupiter-api@5.7.0");
        this.addTestDependency("org.junit.jupiter/junit-jupiter-engine@5.7.0");
        const mainPackage = this.mainClass
            .split(" ")[0]
            .split(".")
            .slice(0, -1)
            .join(".");
        new projen_1.SampleDir(this, path.join("src", "main", "java", ...mainPackage.split(".")), {
            sourceDir: path.join(__dirname, "..", "samples", "java", "src", "main", "java", "software", "aws"),
        });
        new projen_1.SampleDir(this, path.join("src", "test", "java", ...mainPackage.split(".")), {
            sourceDir: path.join(__dirname, "..", "samples", "java", "src", "test", "java", "software", "aws"),
        });
    }
}
exports.PDKPipelineJavaProject = PDKPipelineJavaProject;
_a = JSII_RTTI_SYMBOL_1;
PDKPipelineJavaProject[_a] = { fqn: "aws-prototyping-sdk.pipeline.PDKPipelineJavaProject", version: "0.3.7" };
//# sourceMappingURL=data:application/json;base64,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