# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class RebuildInstanceRequest(JDCloudRequest):
    """
    云主机使用指定镜像重置云主机系统<br>
云主机的状态必须为<b>stopped</b>状态。<br>
若不指定镜像ID，默认使用当前主机的原镜像重置系统。<br>
云主机系统盘类型必须与待更换镜像支持的系统盘类型保持一致，若当前云主机系统盘为local类型，则更换镜像的系统盘类型必须为loaclDisk类型；同理，若当前云主机系统盘为cloud类型，则更换镜像的系统盘类型必须为cloudDisk类型。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimages">DescribeImages</a>接口获得指定地域的镜像信息。<br>
指定的镜像必须能够支持当前主机的实例规格(instanceType)，否则会返回错误。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimageconstraints">DescribeImageConstraints</a>接口获得指定镜像支持的系统盘类型信息。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(RebuildInstanceRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:rebuildInstance', 'POST', header, version)
        self.parameters = parameters


class RebuildInstanceParameters(object):

    def __init__(self, regionId, instanceId, password, ):
        """
        :param regionId: 地域ID
        :param instanceId: 云主机ID
        :param password: 云主机密码，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.password = password
        self.imageId = None
        self.keyNames = None

    def setImageId(self, imageId):
        """
        :param imageId: (Optional) 镜像ID。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimages">DescribeImages</a>接口获得指定地域的镜像信息。
        """
        self.imageId = imageId

    def setKeyNames(self, keyNames):
        """
        :param keyNames: (Optional) 密钥对名称；当前只支持一个。仅Linux系统支持指定。
        """
        self.keyNames = keyNames

