# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ModifySubscriptionAttributeRequest(JDCloudRequest):
    """
    修改订阅
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ModifySubscriptionAttributeRequest, self).__init__(
            '/regions/{regionId}/topics/{topicName}/subscriptions/{consumerGroupId}', 'PATCH', header, version)
        self.parameters = parameters


class ModifySubscriptionAttributeParameters(object):

    def __init__(self, regionId, topicName, consumerGroupId, ):
        """
        :param regionId: 所在区域的Region ID
        :param topicName: topic 名称
        :param consumerGroupId: consumerGroupId
        """

        self.regionId = regionId
        self.topicName = topicName
        self.consumerGroupId = consumerGroupId
        self.maxRetryTimes = None
        self.messageInvisibleTimeInSeconds = None
        self.dlqEnable = None

    def setMaxRetryTimes(self, maxRetryTimes):
        """
        :param maxRetryTimes: (Optional) 最大重试次数
        """
        self.maxRetryTimes = maxRetryTimes

    def setMessageInvisibleTimeInSeconds(self, messageInvisibleTimeInSeconds):
        """
        :param messageInvisibleTimeInSeconds: (Optional) 消息ack超时时间
        """
        self.messageInvisibleTimeInSeconds = messageInvisibleTimeInSeconds

    def setDlqEnable(self, dlqEnable):
        """
        :param dlqEnable: (Optional) 是否开启死信队列[true, false]
        """
        self.dlqEnable = dlqEnable

