# Protobuf Schema Parser

Protobuf Schema Parser is a pure-Python library that parses and writes Protobuf schemas to and from an abstract syntax tree (AST).

The library uses `proto_schema_parser.parser.Parser` to parse the [CST into an AST](https://stackoverflow.com/questions/29971097/how-to-create-ast-with-antlr4). The `proto_schema_parser.generator.Generator` class converts the AST back into a CST (a Protobuf schema string).

_The lexer and parser are autogenerated from [Buf](https://buf.build/)'s ANTLR [lexer and parser](https://github.com/bufbuild/protobuf.com/tree/main/examples/antlr) grammar files._

## Features

- ✅ proto2 and proto3 support
- ✅ message, field, enum, optional, required, repeated
- ✅ import, package, oneof, map, and option
- ✅ group and extend (in proto2)
- ✅ service, rpc, and stream
- ✅ line and block comment preservation

## Installation

Install the package via pip:

```bash
pip install proto-schema-parser
```

## Usage

To parse a protobuf schema, create a `Parser` object and call the `parse` method:

```python
from proto_schema_parser.parser import Parser

text = """
syntax = "proto3";

message SearchRequest {
  string query = 1;
  int32 page_number = 2;
  int32 result_per_page = 3;
}
"""

result = Parser().parse(text)
```

This will return an AST object (`ast.File`) representing the parsed protobuf schema.

```python
File(
  syntax='proto3',
  file_elements=[
    Message(
      name='SearchRequest',
      elements=[
        Field(
          name='query',
          number=1,
          type='string',
          cardinality=None,
          options=[]),
        Field(
          name='page_number',
          number=2,
          type='int32',
          cardinality=None,
          options=[]),
        Field(
          name='result_per_page',
          number=3,
          type='int32',
          cardinality=None,
          options=[])])])
```

To write the AST back to a protobuf schema, create a `Generator` object and call the `generate` method:

```python
from proto_schema_parser.generator import Generator

proto = Generator().generate(result)
```

The `proto` variable now contains the string:

```proto
syntax = "proto3";
message SearchRequest {
  string query = 1;
  int32 page_number = 2;
  int32 result_per_page = 3;
}
```

## Contributing

I welcome contributions!

- Submit a PR and I'll review it as soon as I can.
- Open an issue if you find a bug or have a feature request.

## License

Protobuf Schema Parser is licensed under the [MIT license](./LICENSE).
