"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DaemonSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const k8s = require("./imports/k8s");
const workload = require("./workload");
/**
 * A DaemonSet ensures that all (or some) Nodes run a copy of a Pod.
 * As nodes are added to the cluster, Pods are added to them.
 * As nodes are removed from the cluster, those Pods are garbage collected.
 * Deleting a DaemonSet will clean up the Pods it created.
 *
 * Some typical uses of a DaemonSet are:
 *
 * - running a cluster storage daemon on every node
 * - running a logs collection daemon on every node
 * - running a node monitoring daemon on every node
 *
 * In a simple case, one DaemonSet, covering all nodes, would be used for each type of daemon.
 * A more complex setup might use multiple DaemonSets for a single type of daemon,
 * but with different flags and/or different memory and cpu requests for different hardware types.
 */
class DaemonSet extends workload.Workload {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id, props);
        this.resourceType = 'daemonsets';
        this.apiObject = new k8s.KubeDaemonSet(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
        this.minReadySeconds = (_b = props.minReadySeconds) !== null && _b !== void 0 ? _b : 0;
    }
    /**
     * @internal
     */
    _toKube() {
        return {
            minReadySeconds: this.minReadySeconds,
            template: {
                metadata: this.podMetadata.toJson(),
                spec: this._toPodSpec(),
            },
            selector: {
                matchExpressions: this.matchExpressions,
                matchLabels: this.matchLabels,
            },
        };
    }
}
exports.DaemonSet = DaemonSet;
_a = JSII_RTTI_SYMBOL_1;
DaemonSet[_a] = { fqn: "cdk8s-plus-22.DaemonSet", version: "2.0.0-beta.1" };
//# sourceMappingURL=data:application/json;base64,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