# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class AttachNetworkInterfaceRequest(JDCloudRequest):
    """
    云主机绑定一块弹性网卡。<br>
云主机状态必须为<b>running</b>或<b>stopped</b>状态，并且没有正在进行中的任务才可操作。<br>
弹性网卡上如果绑定了弹性公网IP，那么其所在az需要与云主机的az保持一致，或者为全可用区型弹性公网IP，才可挂载该网卡。<br>
云主机挂载弹性网卡的数量，不能超过实例规格的限制。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeinstancetypes">DescribeInstanceTypes</a>接口获得指定规格可挂载弹性网卡的数量上限。<br>
弹性网卡与云主机必须在相同vpc下。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(AttachNetworkInterfaceRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:attachNetworkInterface', 'POST', header, version)
        self.parameters = parameters


class AttachNetworkInterfaceParameters(object):

    def __init__(self, regionId, instanceId, networkInterfaceId, ):
        """
        :param regionId: 地域ID
        :param instanceId: 云主机ID
        :param networkInterfaceId: 弹性网卡ID
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.networkInterfaceId = networkInterfaceId
        self.autoDelete = None

    def setAutoDelete(self, autoDelete):
        """
        :param autoDelete: (Optional) 随云主机删除而自动删除，默认为False
        """
        self.autoDelete = autoDelete

