# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateBackendRequest(JDCloudRequest):
    """
    创建一个后端服务
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateBackendRequest, self).__init__(
            '/regions/{regionId}/backends/', 'POST', header, version)
        self.parameters = parameters


class CreateBackendParameters(object):

    def __init__(self, regionId, backendName, loadBalancerId, protocol, port, healthCheckSpec, ):
        """
        :param regionId: Region ID
        :param backendName: 后端服务名字,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符
        :param loadBalancerId: 后端服务所属负载均衡的Id
        :param protocol: 后端服务的协议 <br>【alb】取值范围：Http、Tcp <br>【nlb】取值范围：Tcp <br>【dnlb】取值范围：Tcp
        :param port: 后端服务的端口，取值范围为[1, 65535]，如指定了TargetSpec中的port，实际按照target指定的port进行转发
        :param healthCheckSpec: 健康检查信息
        """

        self.regionId = regionId
        self.backendName = backendName
        self.loadBalancerId = loadBalancerId
        self.protocol = protocol
        self.port = port
        self.healthCheckSpec = healthCheckSpec
        self.algorithm = None
        self.targetGroupIds = None
        self.agIds = None
        self.proxyProtocol = None
        self.description = None
        self.sessionStickiness = None
        self.sessionStickyTimeout = None
        self.connectionDrainingSeconds = None
        self.httpCookieExpireSeconds = None
        self.httpForwardedProtocol = None
        self.httpForwardedPort = None
        self.httpForwardedHost = None
        self.httpForwardedVip = None

    def setAlgorithm(self, algorithm):
        """
        :param algorithm: (Optional) 调度算法 <br>【alb,nlb】取值范围为[IpHash, RoundRobin, LeastConn]（取值范围的含义：加权源Ip哈希，加权轮询和加权最小连接），alb和nlb默认为加权轮询 <br>【dnlb】取值范围为[IpHash, QuintupleHash]（取值范围的含义分别为：加权源Ip哈希和加权五元组哈希），dnlb默认为加权源Ip哈希
        """
        self.algorithm = algorithm

    def setTargetGroupIds(self, targetGroupIds):
        """
        :param targetGroupIds: (Optional) 虚拟服务器组的Id列表，目前只支持一个，且与agIds不能同时存在
        """
        self.targetGroupIds = targetGroupIds

    def setAgIds(self, agIds):
        """
        :param agIds: (Optional) 高可用组的Id列表，目前只支持一个，且与targetGroupIds不能同时存在
        """
        self.agIds = agIds

    def setProxyProtocol(self, proxyProtocol):
        """
        :param proxyProtocol: (Optional) 【alb Tcp协议】获取真实ip, 取值为False(不获取)或者True(获取,支持Proxy Protocol v1版本)，默认为False
        """
        self.proxyProtocol = proxyProtocol

    def setDescription(self, description):
        """
        :param description: (Optional) 描述,允许输入UTF-8编码下的全部字符，不超过256字符
        """
        self.description = description

    def setSessionStickiness(self, sessionStickiness):
        """
        :param sessionStickiness: (Optional) 会话保持, 取值为false(不开启)或者true(开启)，默认为false <br>【alb Http协议，RoundRobin算法】支持基于cookie的会话保持 <br>【nlb】支持基于报文源目的IP的会话保持
        """
        self.sessionStickiness = sessionStickiness

    def setSessionStickyTimeout(self, sessionStickyTimeout):
        """
        :param sessionStickyTimeout: (Optional) 【nlb】会话保持超时时间，sessionStickiness开启时生效，默认300s, 取值范围[1-3600]
        """
        self.sessionStickyTimeout = sessionStickyTimeout

    def setConnectionDrainingSeconds(self, connectionDrainingSeconds):
        """
        :param connectionDrainingSeconds: (Optional) 【nlb】连接耗尽超时。移除target前，连接的最大保持时间，默认300s，取值范围[0-3600]
        """
        self.connectionDrainingSeconds = connectionDrainingSeconds

    def setHttpCookieExpireSeconds(self, httpCookieExpireSeconds):
        """
        :param httpCookieExpireSeconds: (Optional) 【alb Http协议】cookie的过期时间,sessionStickiness开启时生效，取值范围为[0-86400], 默认为0（表示cookie与浏览器同生命周期）
        """
        self.httpCookieExpireSeconds = httpCookieExpireSeconds

    def setHttpForwardedProtocol(self, httpForwardedProtocol):
        """
        :param httpForwardedProtocol: (Optional) 【alb Http协议】获取负载均衡的协议, 取值为False(不获取)或True(获取), 默认为False
        """
        self.httpForwardedProtocol = httpForwardedProtocol

    def setHttpForwardedPort(self, httpForwardedPort):
        """
        :param httpForwardedPort: (Optional) 【alb Http协议】获取负载均衡的端口, 取值为False(不获取)或True(获取), 默认为False
        """
        self.httpForwardedPort = httpForwardedPort

    def setHttpForwardedHost(self, httpForwardedHost):
        """
        :param httpForwardedHost: (Optional) 【alb Http协议】获取负载均衡的host信息, 取值为False(不获取)或True(获取), 默认为False
        """
        self.httpForwardedHost = httpForwardedHost

    def setHttpForwardedVip(self, httpForwardedVip):
        """
        :param httpForwardedVip: (Optional) 【alb Http协议】获取负载均衡的vip, 取值为False(不获取)或True(获取), 默认为False
        """
        self.httpForwardedVip = httpForwardedVip

