import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ReplicationSlotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Sets the database to add the replication slot to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/replication_slot#database ReplicationSlot#database}
    */
    readonly database?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/replication_slot#name ReplicationSlot#name}
    */
    readonly name: string;
    /**
    * Sets the output plugin to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/replication_slot#plugin ReplicationSlot#plugin}
    */
    readonly plugin: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/replication_slot postgresql_replication_slot}
*/
export declare class ReplicationSlot extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_replication_slot";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/replication_slot postgresql_replication_slot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ReplicationSlotConfig
    */
    constructor(scope: Construct, id: string, config: ReplicationSlotConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _plugin?;
    get plugin(): string;
    set plugin(value: string);
    get pluginInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
