"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'construct an AWS::Serverless::Application'(test) {
        const stack = new cdk.Stack();
        new lib_1.CfnApplication(stack, 'App', {
            location: {
                applicationId: 'arn:aws:serverlessrepo:us-east-1:077246666028:applications/aws-serverless-twitter-event-source',
                semanticVersion: '2.0.0'
            },
            parameters: {
                SearchText: '#serverless -filter:nativeretweets',
                TweetProcessorFunctionName: 'test'
            }
        });
        assert_1.expect(stack).toMatch({
            Transform: 'AWS::Serverless-2016-10-31',
            Resources: {
                App: {
                    Type: 'AWS::Serverless::Application',
                    Properties: {
                        Location: {
                            ApplicationId: 'arn:aws:serverlessrepo:us-east-1:077246666028:applications/aws-serverless-twitter-event-source',
                            SemanticVersion: '2.0.0'
                        },
                        Parameters: {
                            SearchText: '#serverless -filter:nativeretweets',
                            TweetProcessorFunctionName: 'test'
                        }
                    }
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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