# coding: utf-8

"""
    Fox API

     Warning: Please add a custom user agent header to your requests. This would help us fighting against DDoS attacks in future, while keeping your application's access to the API. In future, this may be a mandatory requirement.  To reduce the system load, the API endpoints are rate limited. The default limit is 30 requests per minute. Contact admin@orangefox.tech if you need a higher limit.  The requests may be logged for analytics and development purposes. 

    The version of the OpenAPI document: 5.2.6
    Contact: admin@orangefox.tech
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from foxclient.models.maintainer_short_model import MaintainerShortModel
from typing import Optional, Set
from typing_extensions import Self

class DeviceResponse(BaseModel):
    """
    DeviceResponse
    """ # noqa: E501
    id: StrictStr = Field(alias="_id")
    codename: StrictStr = Field(description="Device codename, legacy")
    model_name: StrictStr = Field(description="Model name of device, does not include the OEM part, legacy")
    oem_name: StrictStr
    id: StrictStr
    codenames: List[StrictStr]
    model_names: List[StrictStr]
    supported: StrictBool
    maintainer: MaintainerShortModel
    notes: Optional[StrictStr] = None
    device_tree: Optional[StrictStr] = None
    full_name: StrictStr = Field(description="Full name of device / devices, legacy")
    url: StrictStr = Field(description="URL of the device on the official website")
    __properties: ClassVar[List[str]] = ["_id", "codename", "model_name", "oem_name", "id", "codenames", "model_names", "supported", "maintainer", "notes", "device_tree", "full_name", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "full_name",
            "url",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of maintainer
        if self.maintainer:
            _dict['maintainer'] = self.maintainer.to_dict()
        # set to None if notes (nullable) is None
        # and model_fields_set contains the field
        if self.notes is None and "notes" in self.model_fields_set:
            _dict['notes'] = None

        # set to None if device_tree (nullable) is None
        # and model_fields_set contains the field
        if self.device_tree is None and "device_tree" in self.model_fields_set:
            _dict['device_tree'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_id": obj.get("_id"),
            "codename": obj.get("codename"),
            "model_name": obj.get("model_name"),
            "oem_name": obj.get("oem_name"),
            "id": obj.get("id"),
            "codenames": obj.get("codenames"),
            "model_names": obj.get("model_names"),
            "supported": obj.get("supported"),
            "maintainer": MaintainerShortModel.from_dict(obj["maintainer"]) if obj.get("maintainer") is not None else None,
            "notes": obj.get("notes"),
            "device_tree": obj.get("device_tree"),
            "full_name": obj.get("full_name"),
            "url": obj.get("url")
        })
        return _obj


