# Label Studio &middot; ![GitHub](https://img.shields.io/github/license/heartexlabs/label-studio?logo=heartex) [![Build Status](https://travis-ci.com/heartexlabs/label-studio.svg?branch=master)](https://travis-ci.com/heartexlabs/label-studio) [![codecov](https://codecov.io/gh/heartexlabs/label-studio/branch/master/graph/badge.svg)](https://codecov.io/gh/heartexlabs/label-studio) ![GitHub release](https://img.shields.io/github/v/release/heartexlabs/label-studio?include_prereleases) &middot; :sunny:

[Website](https://labelstud.io/) • [Docs](https://labelstud.io/guide) • [Twitter](https://twitter.com/heartexlabs) • [Join Slack Community <img src="https://go.heartex.net/docs/images/slack-mini.png" width="18px"/>](https://join.slack.com/t/label-studio/shared_invite/zt-cr8b7ygm-6L45z7biEBw4HXa5A2b5pw)

<br/>

> **NEW** Release 0.6.0: Nested & Per-Region Labeling, Filtering & Cueing the active labels, read the [release notes](https://labelstud.io/blog/release-060-nested-data-labeling.html).

**Label Studio is a swiss army knife of data labeling and annotation tools :v:**
 
Try it now in a **[running app](https://app.labelstud.io)** and check out the **[introductory post](https://towardsdatascience.com/introducing-label-studio-a-swiss-army-knife-of-data-labeling-140c1be92881#3907-fd502dc24c8d)**.
 
Its purpose is to help you label different types of data using a simple interface with a standardized output format. You're dealing with the custom dataset and thinking about creating your tool? Don't - using Label Studio, you can save time and create a custom tool and interface in minutes. 

<br/>

![Label Studio](https://raw.githubusercontent.com/heartexlabs/label-studio/master/images/annotation_examples.gif)

## Summary

<img align="right" height="180" src="https://github.com/heartexlabs/label-studio/blob/master/images/heartex_icon_opossum_green@2x.png?raw=true" />

- [Quick Start](#quick-start)
- [One Click Deploy](#one-click-deploy)
- [Features :star2:](#features-star2)
- [Use Cases](#use-cases)
- [Machine Learning Integration](#machine-learning-integration)
- [For Teams and Enterprises :office:](#label-studio-for-teams-startups-and-enterprises-office)
- [Ecosystem](#ecosystem)
- [License](#license)

## Quick Start

```bash
# Requires >=Python3.5
pip install label-studio

# Initialize the project in labeling_project path
label-studio init labeling_project

# Start the server at http://localhost:8080
label-studio start labeling_project
```

#### Install on Windows

For running on Windows, the following wheel packages are needed to be manually downloaded from [Gohlke builds](https://www.lfd.uci.edu/~gohlke/pythonlibs), by ensuring the right python version:

- [lxml](https://www.lfd.uci.edu/~gohlke/pythonlibs/#lxml)

Install Label Studio:
 
```bash
# Upgrade pip 
pip install -U pip

# Assuming you are running Win64 with Python 3.8, install packages downloaded form Gohlke:
pip install lxml‑4.5.0‑cp38‑cp38‑win_amd64.whl

# Install label studio
pip install label-studio
```

#### Local development
Running the latest Label Studio version locally without installing package from pip could be done by:
```bash
# Install all package dependencies
pip install -e .
```
```bash
# Start the server at http://localhost:8080
python label-studio/server.py start labeling_project --init
```

## Run docker
You can also start serving at `http://localhost:8080` by using docker:
```bash
docker run --rm -p 8080:8080 -v `pwd`/my_project:/label-studio/my_project --name label-studio heartexlabs/label-studio:latest label-studio start my_project --init
```

By default, it starts blank project in `./my_project` directory.

> Note: if `./my_project` folder exists, an exception will be thrown. Please delete this folder or use `--force` option.

You can override the default startup command by appending:

```bash
docker run -p 8080:8080 -v `pwd`/my_project:/label-studio/my_project --name label-studio heartexlabs/label-studio:latest label-studio start my_project --init --force --template image_mixedlabel
```

If you want to build a local image, run:
```bash
docker build -t heartexlabs/label-studio:latest .
```

## Using docker-compose

You can also start serving at `http://localhost:8080` using docker-compose.

### First time to run the app
```bash
INIT_COMMAND='--init' docker-compose up -d
```
### Run the app with existing project data
```bash
docker-compose up -d
```
### Run the app reseting project data
```bash
INIT_COMMAND='--init --force' docker-compose up -d
```

Or you can just use .env file instead of INIT_COMMAND='...' adding this line:
```bash
INIT_COMMAND=--init --force
```

## One Click Deploy

[<img src="https://www.herokucdn.com/deploy/button.svg" height="30px">](https://heroku.com/deploy)
[<img src="https://azurecomcdn.azureedge.net/mediahandler/acomblog/media/Default/blog/deploybutton.png" height="30px">](https://azuredeploy.net/)
[<img src="https://deploy.cloud.run/button.svg" height="30px">](https://deploy.cloud.run)

## Features :star2:

- **Simple**: Crafted with minimal UI design. A simple design is the best design.
- **Configurable**: Using high-level jsx tags config, you can fully customize the visual interface for your data. It feels like building a custom labeling tool for your specific needs. And it's fast to do.
- **Collaborative Annotations**: Label the same task by two or more people and compare the results. 
- **Multiple Data Types**: Label _Images_, _Audios_, _Texts_, _HTMLs_, _Pairwise_ types with different labeling scenarios that you define yourself.
- **Import Formats**: JSON, CSV, TSV, RAR and ZIP archives
- **Mobile-Friendly**: Works on devices of different sizes.
- **Embeddable**: It's an [NPM package](https://github.com/heartexlabs/label-studio-frontend) too. You can include it in your projects.
- **Machine Learning**: Integration support for machine learning. Visualize and compare predictions from different models. Use the best ones for pre-labeling.
- **Stylable**: Configure the visual appearance to match your company brand, distribute the labeling tasks as a part of your product.

## Use Cases

The list of supported use cases for data annotation. Please contribute your own configs and feel free to extend the base types to support more scenarios. Note that it's not an extensive list and has only major scenarios.

| Task | Description |
|-|-|
| **Image** | | 
| [Classification](https://labelstud.io/templates/image_classification.html) | Put images into categories |
| Object Detection | Detect objects in an image using a bounding box or polygons |
| Semantic Segmentation | Detect for each pixel the object category it belongs to | 
| Pose Estimation | Mark positions of a person’s joints |
| **Text** | | 
| [Classification](https://labelstud.io/templates/sentiment_analysis.html) | Put texts into categories |
| Summarization | Create a summary that represents the most relevant information within the original content |
| HTML Tagging | Annotate things like resumes, research, legal papers and excel sheet converted to HTML | 
| **Audio** | |
| [Classification](https://labelstud.io/templates/audio_classification.html) | Put audios into categories |
| Speaker Diarisation | partitioning an input audio stream into homogeneous segments according to the speaker identity | 
| Emotion Recognition | Tag and identifying emotion from the audio |
| Transcription | Write down verbal communication in text |
| **Video** | |
| [Classification](https://labelstud.io/templates/video_classification.html) | Put videos into categories | 
| **Comparison** | |
| Pairwise | Comparing entities in pairs to judge which of each entity is preferred | 
| Ranking | Sort items in the list according to some property |

## Machine Learning Integration

You can easily connect your favorite machine learning framework with Label Studio by using [Heartex SDK](https://github.com/heartexlabs/pyheartex). 

That gives you the opportunities to use:
- **Pre-labeling**: Use model predictions for pre-labeling
- **Online Learning**: Simultaneously update (retrain) your model while new annotations are coming
- **Active Learning**: Perform labeling in active learning mode
- **Prediction Service**: Instantly create running production-ready prediction service

There is a quick example tutorial on how to do that with simple image classification:

1. Clone pyheartex, and start serving example image classifier ML backend at `http://localhost:9090`
    ```bash
    git clone https://github.com/heartexlabs/pyheartex.git
    cd pyheartex/examples/docker
    docker-compose up -d
    ```
   
2. Run Label Studio project specifying ML backend URLs:

    ```bash
    label-studio start imgcls --init --template image_classification \
    --ml-backend-url http://localhost:9090 --ml-backend-name my_model
    ```
    
Once you're satisfied with pre-labeling results, you can immediately send prediction requests via REST API:
```bash
curl -X POST -H 'Content-Type: application/json' -d '{"image_url": "https://go.heartex.net/static/samples/sample.jpg"}' http://localhost:8080/predict
```

Feel free to play around any other models & frameworks apart from image classifiers! (see instructions [here](https://github.com/heartexlabs/pyheartex#advanced-usage))

## Label Studio for Teams, Startups, and Enterprises :office:

Label Studio for Teams is our enterprise edition (cloud & on-prem), that includes a data manager, high-quality baseline models, active learning, collaborators support, and more. Please visit the [website](https://www.heartex.ai/) to learn more.

## Ecosystem

| Project | Description |
|-|-|
| label-studio | Server part, distributed as a pip package |
| [label-studio-frontend](https://github.com/heartexlabs/label-studio-frontend) | Frontend part, written in JavaScript and React, can be embedded into your application | 
| [label-studio-converter](https://github.com/heartexlabs/label-studio-converter) | Encode labels into the format of your favorite machine learning library | 
| [label-studio-transformers](https://github.com/heartexlabs/label-studio-transformers) | Transformers library connected and configured for use with label studio | 

## License

This software is licensed under the [Apache 2.0 LICENSE](/LICENSE) © [Heartex](https://www.heartex.ai/). 2020

<img src="https://github.com/heartexlabs/label-studio/blob/master/images/opossum_looking.png?raw=true" title="Hey everyone!" height="140" width="140" />
