# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2016-10-10 20:52
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations

FIELD_MAPPINGS = {
    'ProcessNextStepPlugin': [
        ('button-type', 'button_type'),
        ('button-size', 'button_size'),
        ('button-options', 'button_options'),
        ('quick-float', 'quick_float'),
        ('icon-left', 'icon_left'),
        ('icon-right', 'icon_right'),
    ],
    'ShopProceedButton': [
        ('button-type', 'button_type'),
        ('button-size', 'button_size'),
        ('button-options', 'button_options'),
        ('quick-float', 'quick_float'),
        ('icon-left', 'icon_left'),
        ('icon-right', 'icon_right'),
    ],
}


def forwards(apps, schema_editor):
    field_mappings = {}
    for key, maps in FIELD_MAPPINGS.items():
        field_mappings[key] = dict(maps)
    migrate_glossary(apps, field_mappings)


def backwards(apps, schema_editor):
    field_mappings = {}
    for key, maps in FIELD_MAPPINGS.items():
        field_mappings[key] = dict((m[1], m[0]) for m in maps)
    migrate_glossary(apps, field_mappings)


def migrate_glossary(apps, field_mappings):
    CascadeElement = apps.get_model('cmsplugin_cascade', 'CascadeElement')
    for element in CascadeElement.objects.all():
        if element.plugin_type not in field_mappings:
            continue
        glossary = dict(element.glossary)
        for srckey, value in element.glossary.items():
            dstkey = field_mappings[element.plugin_type].get(srckey)
            if dstkey and srckey in glossary:
                glossary[dstkey] = glossary.pop(srckey)
        element.glossary = glossary
        element.save()


class Migration(migrations.Migration):

    dependencies = [
        ('shop', '0002_auto_20151016_1451'),
    ]
    operations = []

    if 'cmsplugin_cascade' in settings.INSTALLED_APPS:
        dependencies.append(('cmsplugin_cascade', '0014_glossary_field'))
        operations.append(migrations.RunPython(forwards, reverse_code=backwards))
