# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeVpcPeeringsRequest(JDCloudRequest):
    """
    查询VpcPeering资源列表
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeVpcPeeringsRequest, self).__init__(
            '/regions/{regionId}/vpcPeerings/', 'GET', header, version)
        self.parameters = parameters


class DescribeVpcPeeringsParameters(object):

    def __init__(self,regionId, ):
        """
        :param regionId: Region ID
        """

        self.regionId = regionId
        self.pageNumber = None
        self.pageSize = None
        self.filters = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码, 默认为1, 取值范围：[1,∞), 页码超过总页数时, 显示最后一页
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小，默认为20，取值范围：[10,100]
        """
        self.pageSize = pageSize

    def setFilters(self, filters):
        """
        :param filters: (Optional) vpcPeeringIds - vpcPeering ID，支持多个
vpcPeeringNames - vpcPeering名称列表，支持多个
vpcId	- vpcPeering本端Vpc Id，支持单个
remoteVpcId - vpcPeering对端Vpc Id，支持单个
azType - vpcPeering本端VPC az类型，取值：all(全部类型)，standard(标准VPC)，edge(边缘VPC)，默认standard ，支持单个
azs - vpcPeering本端VPC可用区，支持多个

        """
        self.filters = filters

