# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateKeypairRequest(JDCloudRequest):
    """
    
创建密钥。

公钥和私钥都由京东云生成，公钥保存在京东云，私钥返回给用户，由用户保存。

详细操作说明请参考帮助文档：[创建密钥](https://docs.jdcloud.com/cn/virtual-machines/create-keypair)

## 接口说明
- 调用该接口创建密钥后，公钥部分存储在京东云，并返回未加密的 `PEM` 编码的 `PKCS#8` 格式私钥，您只有一次机会保存您的私钥。请妥善保管。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateKeypairRequest, self).__init__(
            '/regions/{regionId}/keypairs', 'POST', header, version)
        self.parameters = parameters


class CreateKeypairParameters(object):

    def __init__(self,regionId, keyName):
        """
        :param regionId: 地域ID。
        :param keyName: 密钥对名称，需要全局唯一。
只允许数字、大小写字母、下划线“_”及中划线“-”，不超过32个字符。

        """

        self.regionId = regionId
        self.keyName = keyName

