# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class TidbInstanceSpec(object):

    def __init__(self, instanceName, architecture, tidbNodeSpec, tikvNodeSpec, pdNodeSpec, monitorNodeSpec, azId, vpcId, subnetId, chargeSpec, engineVersion=None, tiflashNodeSpec=None, ticdcNodeSpec=None, tagSpec=None):
        """
        :param instanceName:  实例名
        :param engineVersion: (Optional) TiDB引擎版本
        :param architecture:  CPU架构
        :param tidbNodeSpec:  TiDB节点规格和数目
        :param tikvNodeSpec:  TiKV节点规格和数目
        :param pdNodeSpec:  PD节点规格和数目
        :param monitorNodeSpec:  Monitor节点规格，只能有1个Monitor节点
        :param tiflashNodeSpec: (Optional) TiFlash节点规格和数目
        :param ticdcNodeSpec: (Optional) Ticdc节点规格和数目
        :param azId:  可用区ID，目前仅支持单可用区部署
        :param vpcId:  VPC的ID
        :param subnetId:  子网ID
        :param chargeSpec:  计费规格，包括计费类型，计费周期等
        :param tagSpec: (Optional) 标签信息
        """

        self.instanceName = instanceName
        self.engineVersion = engineVersion
        self.architecture = architecture
        self.tidbNodeSpec = tidbNodeSpec
        self.tikvNodeSpec = tikvNodeSpec
        self.pdNodeSpec = pdNodeSpec
        self.monitorNodeSpec = monitorNodeSpec
        self.tiflashNodeSpec = tiflashNodeSpec
        self.ticdcNodeSpec = ticdcNodeSpec
        self.azId = azId
        self.vpcId = vpcId
        self.subnetId = subnetId
        self.chargeSpec = chargeSpec
        self.tagSpec = tagSpec
